'*** VGAcD_lib V2.0***
Sub VGAclocks(obj, clock_x_pos, clock_y_pos, draw_scale, base_time$)
  Option angle degrees
  Local integer hr, min, sec, gauge_flag, helper2

  If obj > 100 Then
    Inc obj, -100
    gauge_flag = 1
  End If

  clock_radius(obj) = ring_radius(obj) - ring_lw(obj) - ring_lw1(obj)

  If draw_scale > 0 Then
    dr_sc = draw_scale / 100
  Else
    dr_sc = 1
  End If

  If Not gauge_flag Then
    helper2 = Val(Field$(base_time$,1,":")) : Inc helper2, UTC_offset(obj)
    If helper2 < 1 Then Inc helper2, 12
    If helper2 > 12 Then Inc helper2, -12
    base_time$ = Str$(helper2) + ":" + Field$(base_time$,2,":") + ":" + Field$(base_time$,3,":")
  End If

  draw_obj_analog_clock(obj, clock_x_pos, clock_y_pos, gauge_flag, base_time$)

  max_x_old = max_x_ref
End Sub


Sub draw_obj_analog_clock(obj, clock_x_pos, clock_y_pos, gauge_flag, base_time$)
  Local integer hand_num, hand_roff, hand_corners
  Local integer scale_start, scale_end
  Local float hr, min, sec, hand_angle, hand_scale

  hr = Val(Field$(base_time$,1,":"))
  min = Val(Field$(base_time$,2,":"))
  sec = Val(Field$(base_time$,3,":"))

  If gauge_flag = 1 Then
    scale_start = hr
    scale_end = min
  Else
    scale_start = 0
    scale_end = 330
    If hr > 11 Then
      hr = (hr - 12) * 5
    Else
      hr = hr * 5
    End If
  End If

  draw_face(obj, clock_x_pos, clock_y_pos, gauge_flag, scale_start, scale_end)

  Select Case gauge_flag
  Case 0 'hr
    If hand_bc_hr(obj) + hand_fc_hr(obj) <> 32 Then
      hand_angle = (hr - 30 +  min / 60 * 5) * -6
      draw_hand(obj, clock_x_pos, clock_y_pos, gauge_flag, 1, hand_angle, hand_scale_hr1(obj), hand_corners_h(obj), hand_hr_roff(obj), hand_bc_hr(obj), hand_fc_hr(obj), hand_bc_hr1(obj), hand_fc_hr1(obj))
    End If
    If hand_bc_min(obj) + hand_fc_min(obj) <> 32 Then
      hand_angle = (min - 30) * -6 'min
      draw_hand(obj, clock_x_pos, clock_y_pos, gauge_flag, 2, hand_angle, hand_scale_min1(obj), hand_corners_m(obj), hand_min_roff(obj), hand_bc_min(obj), hand_fc_min(obj), hand_bc_min1(obj), hand_fc_min1(obj))
    End If
    If hand_bc_sec(obj) + hand_fc_sec(obj) <> 32 Then
      hand_angle = (sec - 30 ) * -6
      draw_hand(obj, clock_x_pos, clock_y_pos, gauge_flag, 3, hand_angle, hand_scale_sec1(obj), hand_corners_s(obj), hand_sec_roff(obj), hand_bc_sec(obj), hand_fc_sec(obj), hand_bc_sec1(obj), hand_fc_sec1(obj))
    End If
  Case Else
    hand_angle = -sec
    draw_hand(obj, clock_x_pos, clock_y_pos, gauge_flag, 3, hand_angle, hand_scale_sec1(obj), hand_corners_s(obj), hand_sec_roff(obj), hand_bc_sec(obj), hand_fc_sec(obj), hand_bc_sec1(obj), hand_fc_sec1(obj))
  End Select
End Sub

Sub draw_hand(obj, clock_x_pos, clock_y_pos, gauge_flag, hand_num, hand_angle, hand_scale, hand_corners, hand_roff, hand_bc, hand_fc, hand_bc1, hand_fc1)
  Local float hand_base_x(hand_corners+1), hand_base_y(hand_corners+1), hand_base_x1(hand_corners+1), hand_base_y1(hand_corners+1)
  Local float   ratio_x, ratio_y, max_x = -999, max_y = -999, min_x = 999, min_y = 999

  If gauge_flag <> 1 Then
    If hand_num = 1 Then
      For counter = 0  To hand_corners
        hand_base_x(counter) = hand_corners_xh(obj,counter+1)
        hand_base_y(counter) = hand_corners_yh(obj,counter+1)
      Next counter
    Else If hand_num = 2 Then
      For counter = 0 To hand_corners
        hand_base_x(counter) = hand_corners_xm(obj,counter+1)
        hand_base_y(counter) = hand_corners_ym(obj,counter+1)
      Next counter
    End If
  End If
  If hand_num = 3 Then
    For counter = 0 To hand_corners
      hand_base_x(counter) = hand_corners_xs(obj,counter+1)
      hand_base_y(counter) = hand_corners_ys(obj,counter+1)
    Next counter
  End If

  For counter = 0 To hand_corners
    If hand_base_x(counter) < min_x Then min_x = hand_base_x(counter)
    If hand_base_x(counter) > max_x Then max_x = hand_base_x(counter)
    If hand_base_y(counter) < min_y Then min_y = hand_base_y(counter)
    If hand_base_y(counter) > max_y Then max_y = hand_base_y(counter)
  Next counter
  Local float tx = max_x- min_x
  Local float ty = max_y - min_y
  If tx = 0 Then tx = 1
  If ty = 0 Then ty = 1
  If tx > ty Then
    ratio_x = tx / ty
    ratio_y = 1
  Else
    ratio_x = 1
    ratio_y = ty / tx
  End If

  If hand_roff + max_y  > max_x_ref Then max_x_ref = hand_roff + max_y
  If -hand_roff - min_y > max_x_ref Then max_x_ref = -hand_roff - min_y

  Math scale hand_base_x(),1-(1-hand_scale/100)/ratio_x, hand_base_x1()
  Math scale hand_base_y(),1-(1-hand_scale/100)/ratio_y, hand_base_y1()
  Math add hand_base_y(),hand_roff, hand_base_y()
  Math add hand_base_y1(),hand_roff, hand_base_y1()
  Math v_rotate 0, 0, hand_angle, hand_base_x(), hand_base_y(), hand_base_x() , hand_base_y()
  Math v_rotate 0, 0, hand_angle, hand_base_x1(), hand_base_y1(), hand_base_x1() , hand_base_y1()
  Math scale hand_base_x(), -dr_sc, hand_base_x()
  Math scale hand_base_y(), dr_sc, hand_base_y()
  Math scale hand_base_x1(), -dr_sc, hand_base_x1()
  Math scale hand_base_y1(), dr_sc, hand_base_y1()
  Math add hand_base_x(), clock_x_pos, hand_base_x()
  Math add hand_base_y(), clock_y_pos, hand_base_y()
  Math add hand_base_x1(), clock_x_pos, hand_base_x1()
  Math add hand_base_y1(), clock_y_pos, hand_base_y1()

  If Not first_run Then
    If hand_fc <> 16 Then
      Polygon hand_corners, hand_base_x(), hand_base_y(), hand_bc, hand_fc
    Else
      Polygon hand_corners, hand_base_x(), hand_base_y(), hand_bc
    End If
    If hand_bc1 + hand_fc1 <> 32 Then
      If hand_fc1 <> 16 Then
        Polygon hand_corners, hand_base_x1(), hand_base_y1(), hand_bc1, hand_fc1
      Else
        Polygon hand_corners, hand_base_x1(), hand_base_y1(), hand_bc1
      End If
    End If
  End If

  If hand_cover_bc(obj) + hand_cover_fc(obj) <> 32 Then
    If hand_cover_radius(obj) > max_x_ref Then max_x_ref = hand_cover_radius(obj)
    If Not first_run Then
      If hand_cover_fc(obj) <> 16 Then
        Circle clock_x_pos, clock_y_pos,hand_cover_radius(obj) * dr_sc, hand_cover_lw(obj) * dr_sc,, hand_cover_bc(obj), hand_cover_fc(obj)
      Else
        Circle clock_x_pos, clock_y_pos,hand_cover_radius(obj) * dr_sc, hand_cover_lw(obj) * dr_sc,, hand_cover_bc(obj)
      End If
      If hand_cover_bc1(obj) + hand_cover_fc1(obj) <> 32 Then
        If hand_cover_radius1(obj) > max_x_ref Then max_x_ref = hand_cover_radius1(obj)
        If hand_cover_fc1(obj) <> 16 Then
          Circle clock_x_pos, clock_y_pos,hand_cover_radius1(obj) * dr_sc, hand_cover_lw1(obj) * dr_sc,, hand_cover_bc1(obj), hand_cover_fc1(obj)
        Else
          Circle clock_x_pos, clock_y_pos,hand_cover_radius1(obj) * dr_sc, hand_cover_lw1(obj) * dr_sc,, hand_cover_bc1(obj)
        End If
      End If
    End If
  End If
End Sub

Sub build_label(obj, label_nbr, flag, clock_x_pos, clock_y_pos)
Local float ratio_x, ratio_y, tx, ty, roff, buildx(13), buildy(13), conv(3,1)
  Local float  max_x = 0, max_y = 0, min_x = 999, min_y = 999, scale1 = 1
  Local integer pcorners, helper_min = 999, helper_max

  Select Case label_nbr
  Case 0
  build_mode = face_hour_build_mode(obj)
  roff = face_hour_roff(obj)
  If face_hour_scale1(obj) > 100 Then scale1 = face_hour_scale1(obj) / 100
  conv(0,0) = face_hour_w(obj)
  conv(0,1) = face_hour_h(obj)
  conv(1,0) = face_hour_w1(obj)
  conv(1,1) = face_hour_h1(obj)
  conv(2,0) = face_hour_w2(obj)
  conv(2,1) = face_hour_h2(obj)
  conv(3,0) = face_hour_w3(obj)
  conv(3,1) = face_hour_h3(obj)
  Case 1
  build_mode = face_min_build_mode(obj)
  roff = face_min_roff(obj)
  If face_min_scale1(obj) > 100 Then scale1 = face_min_scale1(obj) / 100
  conv(0,0) = face_min_w(obj)
  conv(0,1) = face_min_h(obj)
  conv(1,0) = face_min_w1(obj)
  conv(1,1) = face_min_h1(obj)
  conv(2,0) = face_min_w2(obj)
  conv(2,1) = face_min_h2(obj)
  conv(3,0) = face_min_w3(obj)
  conv(3,1) = face_min_h3(obj)
  Case 3
  build_mode= indi3_build_mode(obj)
  roff = indi3_roff(obj)
  If indi3_scale1(obj) > 100 Then scale1 = indi3_scale1(obj) / 100
  conv(0,0) = indi3_w(obj)
  conv(0,1) = indi3_h(obj)
  conv(1,0) = indi3_w1(obj)
  conv(1,1) = indi3_h1(obj)
  conv(2,0) = indi3_w2(obj)
  conv(2,1) = indi3_h2(obj)
  conv(3,0) = indi3_w3(obj)
  conv(3,1) = indi3_h3(obj)
  Case 6
  build_mode = indi6_build_mode(obj)
  roff = indi6_roff(obj)
  If indi6_scale1(obj) > 100 Then scale1 = indi6_scale1(obj) / 100
  conv(0,0) = indi6_w(obj)
  conv(0,1) = indi6_h(obj)
  conv(1,0) = indi6_w1(obj)
  conv(1,1) = indi6_h1(obj)
  conv(2,0) = indi6_w2(obj)
  conv(2,1) = indi6_h2(obj)
  conv(3,0) = indi6_w3(obj)
  conv(3,1) = indi6_h3(obj)
  Case 9
  build_mode = indi9_build_mode(obj)
  roff = indi9_roff(obj)
  If indi9_scale1(obj) > 100 Then scale1 = indi9_scale1(obj) / 100
  conv(0,0) = indi9_w(obj)
  conv(0,1) = indi9_h(obj)
  conv(1,0) = indi9_w1(obj)
  conv(1,1) = indi9_h1(obj)
  conv(2,0) = indi9_w2(obj)
  conv(2,1) = indi9_h2(obj)
  conv(3,0) = indi9_w3(obj)
  conv(3,1) = indi9_h3(obj)
  Case 12
  build_mode = indi12_build_mode(obj)
  roff = indi12_roff(obj)
  If indi12_scale1(obj) > 100 Then scale1 = indi12_scale1(obj) / 100
  conv(0,0) = indi12_w(obj)
  conv(0,1) = indi12_h(obj)
  conv(1,0) = indi12_w1(obj)
  conv(1,1) = indi12_h1(obj)
  conv(2,0) = indi12_w2(obj)
  conv(2,1) = indi12_h2(obj)
  conv(3,0) = indi12_w3(obj)
  conv(3,1) = indi12_h3(obj)
  End Select

  Inc roff, ring_radius(obj)

  Select Case build_mode
  Case 0 'Triangle
    pcorners = 3
    buildx(0) = -conv(0,0)
    buildy(0) = conv(0,1)
    buildx(1) = 0
    buildy(1) = -conv(0,1) * 2
    buildx(2) = conv(0,0)
    buildy(2) = conv(0,1)
    For counter = 0 To 2
      If helper_min > buildy(counter) Then helper_min = buildy(counter)
      If helper_max < buildy(counter) Then helper_max = buildy(counter)
    Next counter
    If -helper_min > helper_max Then Inc roff, -helper_min / 2
  Case 1 'box
    pcorners = 4
    buildx(0) = -conv(0,0)
    buildy(0) = -conv(0,1)
    buildx(1) = -conv(0,0)
    buildy(1) = conv(0,1)
    buildx(2) = conv(0,0)
    buildy(2) = conv(0,1)
    buildx(3) = conv(0,0)
    buildy(3) = -conv(0,1)
    For counter = 0 To 3
      If helper_min > buildy(counter) Then helper_min = buildy(counter)
      If helper_max < buildy(counter) Then helper_max = buildy(counter)
    Next counter
  Case 2 'symetrical x
    pcorners = 8
    buildx(0) = -conv(0,0)
    buildy(0) = conv(0,1) * 2
    buildx(1) = -conv(1,0)
    buildy(1) = -conv(1,1)
    buildx(2) = -conv(2,0)
    buildy(2) = -conv(2,1)
    buildx(3) = -conv(3,0)
    buildy(3) = -conv(3,1)
    For counter = 0 To 3
      buildx(7 - counter) = -buildx(counter)
      buildy(7 - counter) = buildy(counter)
    Next counter
    For counter = 0 To 7
      If helper_min > buildy(counter) Then helper_min = buildy(counter)
      If helper_max < buildy(counter) Then helper_max = buildy(counter)
    Next counter
  Case 3 'mirror symmetrical
    pcorners = 14
    For counter= 1 To 3
      buildx(counter) = -conv(counter,0)
      buildy(counter) = -conv(counter,1)
      buildx(14 - counter) = -conv(counter,0)
      buildy(14 - counter) = conv(counter,1)
      buildx(7 - counter) = conv(counter,0)
      buildy(7 - counter) = -conv(counter,1)
      buildx(7 + counter) = conv(counter,0)
      buildy(7 + counter) = conv(counter,1)
    Next counter
    buildx(0) = -conv(0,0)
    buildy(0) = -conv(0,1)
    buildx(7) = conv(0,0)
    buildy(7) = -conv(0,1)
    For counter = 0 To 13
      If helper_min > buildy(counter) Then helper_min = buildy(counter)
      If helper_max < buildy(counter) Then helper_max = buildy(counter)
    Next counter
  End Select

  If helper_min < 0 Then helper_min = -helper_min
  If helper_min > helper_max Then helper_max = helper_min
  If flag Then helper_max = helper_max * scale1

  Select Case label_nbr
  Case 0, 3, 6, 9, 12
    Math scale buildx(), dr_sc, hpx()
    Math scale buildy(), dr_sc, hpy()
    Math add hpy(), (roff - helper_max) * dr_sc, hpy()
    Math add hpx(), clock_x_pos,  hpx()
    Math add hpy(), clock_y_pos, hpy()
  Case 1
    Math scale buildx(), dr_sc, mpx()
    Math scale buildy(), dr_sc, mpy()
    Math add mpy(), (roff - helper_max) * dr_sc, mpy()
    Math add mpx(), clock_x_pos,  mpx()
    Math add mpy(), clock_y_pos, mpy()
  End Select

  If flag Then
    For counter = 0 To pcorners -1
      If  buildx(counter) < min_x Then min_x = buildx(counter)
      If  buildx(counter)  > max_x Then max_x = buildx(counter)
      If  buildy(counter) < min_y Then min_y = buildy(counter)
      If  buildy(counter) > max_y Then max_y = buildy(counter)
    Next counter
     tx = max_x - min_x
     ty = max_y - min_y
    If tx = 0 Then tx = 1
    If ty = 0 Then ty = 1
    If tx > ty Then
      ratio_x = ty / tx
      ratio_y = 1
    Else
      ratio_x = 1
      ratio_y = tx / ty
    End If

    Select Case label_nbr
    Case 0
      Math scale buildx(), 1 - (1-  face_hour_scale1(obj)/100) * ratio_x), hpx1()
      Math scale buildy(), 1 - (1-  face_hour_scale1(obj)/100) * ratio_y), hpy1()
    Case 1
      Math scale buildx(), 1 - (1-  face_min_scale1(obj)/100) * ratio_x), mpx1()
      Math scale buildy(), 1 - (1-  face_min_scale1(obj)/100) * ratio_y), mpy1()
    Case 3
      Math scale buildx(), 1 - (1-  indi3_scale1(obj)/100) * ratio_x), hpx1()
      Math scale buildy(), 1 - (1-  indi3_scale1(obj)/100) * ratio_y), hpy1()
    Case 6
      Math scale buildx(), 1 - (1-  indi6_scale1(obj)/100) * ratio_x), hpx1()
      Math scale buildy(), 1 - (1-  indi6_scale1(obj)/100) * ratio_y), hpy1()
    Case 9
      Math scale buildx(), 1 - (1-  indi9_scale1(obj)/100) * ratio_x), hpx1()
      Math scale buildy(), 1 - (1-  indi9_scale1(obj)/100) * ratio_y), hpy1()
    Case 12
      Math scale buildx(), 1 - (1-  indi12_scale1(obj)/100) * ratio_x), hpx1()
      Math scale buildy(), 1 - (1-  indi12_scale1(obj)/100) * ratio_y), hpy1()
    End Select

    Select Case label_nbr
    Case 0, 3, 6, 9, 12
      Math scale hpx1(), dr_sc, hpx1()
      Math scale hpy1(), dr_sc, hpy1()
      Math add hpy1(), (roff - helper_max) * dr_sc, hpy1()
      Math add hpx1(), clock_x_pos, hpx1()
      Math add hpy1(), clock_y_pos, hpy1()
    Case 1
      Math scale mpx1(), 1 - (1-  face_min_scale1(obj)/100) * ratio_x), mpx1()
      Math scale mpy1(), 1 - (1-  face_min_scale1(obj)/100) * ratio_y), mpy1()
      Math scale mpx1(), dr_sc, mpx1()
      Math scale mpy1(), dr_sc, mpy1()
      Math add mpy1(), (roff - helper_max) * dr_sc, mpy1()
      Math add mpx1(), clock_x_pos, mpx1()
      Math add mpy1(), clock_y_pos, mpy1()
    End Select
  End If
End Sub

Sub draw_face(obj, clock_x_pos, clock_y_pos, gauge_flag, scale_start, scale_end)

  Local float hour_roff = ring_radius(obj) + face_hour_roff(obj)
  Local float min_roff = ring_radius(obj) + face_min_roff(obj)

  Local float phour_roff(1) = ring_radius(obj) + face_phour_roff(obj) - face_phour_radius(obj)
  Local float pmin_roff(1) = ring_radius(obj) + face_pmin_roff(obj) - face_pmin_radius(obj)
  Local float pmin_xoff(1), phour_xoff(1), numbers_xoff(1)
  Local float print_px(13), print_py(13)
  Local float phour_xofft(1), phour_rofft(1), pmin_xofft(1), pmin_rofft(1)

  Local integer fonts_wh(1,15) = (8,12,12,20,16,16,10,16,24,32,32,50,6,8,4,6,8,8,8,8,16,24,16,16,16,16,16,16,16,32,16,22) 'font#1-16 sizes

  Local integer txt_font, numbers_font, min_angle, counter1, txt_scale, numbers_scale, print_txt, print_num
  Local float txt_x, txt_y, count, angle, wh2, ht2, helper2, numbers_rx0(1), numbers_ry0(1), s = face_numbers_style(obj)
  Local string helper1$, h1$, h2$, face_txt$ LENGTH 30

  build_mode = 0 : set_indi = 0 : indi_mode = 0 : indi_done = 0 : hour_done = 0 : max_x_ref = ring_radius(obj)

  If face_pmin_bc(obj) + face_pmin_fc(obj) <> 32 Then 'circle min
    If pmin_roff(0) + face_pmin_radius(obj) > max_x_ref Then max_x_ref = pmin_roff(0) + face_pmin_radius(obj)
    If face_pmin_bc1(obj) + face_pmin_fc1(obj) <> 32 Then
      If ring_radius(obj) + face_pmin_roff(obj) + face_pmin_radius1(obj) - face_pmin_radius(obj) > max_x_ref Then max_x_ref = ring_radius(obj) + face_pmin_roff(obj) + face_pmin_radius1(obj) - face_pmin_radius(obj)
    End If
    Math scale pmin_roff(), dr_sc, pmin_roff()
    Math add pmin_xoff(), clock_x_pos, pmin_xoff()
    Math add pmin_roff(), clock_y_pos, pmin_roff()
  End If

  If face_phour_bc(obj) + face_phour_fc(obj) <> 32 Then 'circle hour
    If phour_roff(0) + face_phour_radius(obj) > max_x_ref Then max_x_ref = phour_roff(0) + face_phour_radius(obj)
    If face_phour_bc1(obj) + face_phour_fc1(obj) <> 32 Then
      If ring_radius(obj) + face_phour_roff(obj) + face_phour_radius1(obj) - face_phour_radius(obj) > max_x_ref Then max_x_ref = ring_radius(obj) + face_phour_roff(obj) + face_phour_radius1(obj) - face_phour_radius(obj)
    End If
    Math scale phour_roff(), dr_sc, phour_roff()
    Math add phour_xoff(), clock_x_pos, phour_xoff()
    Math add phour_roff(), clock_y_pos, phour_roff()
  End If

  If ring_bc(obj) + ring_fc(obj) <> 32 Then 'draw face
    If ring_fc(obj) <> 16 Then
      Circle clock_x_pos, clock_y_pos, ring_radius(obj) * dr_sc, ring_lw(obj) * dr_sc,, ring_bc(obj),ring_fc(obj) 'outer ring
    Else
      Circle clock_x_pos, clock_y_pos, ring_radius(obj) * dr_sc, ring_lw(obj) * dr_sc,,, ring_bc(obj) 'transparent
    End If
  End If
  If face_bc(obj) + face_fc(obj) <> 32 Then
    If face_fc(obj) <> 16 Then
      Circle clock_x_pos, clock_y_pos, clock_radius(obj) * dr_sc, face_lw(obj) * dr_sc,, face_bc(obj), face_fc(obj) 'clock face
    Else
      Circle clock_x_pos, clock_y_pos, clock_radius(obj) * dr_sc, face_lw(obj) * dr_sc,,, face_bc(obj)
    End If
  End If

  If Not first_run And grid_flag Then draw_grid()

  If face_text_bc(obj) + face_text_fc(obj) + face_numbers_bc(obj) + face_numbers_fc(obj) <> 64 Then 'calc scale/font numbers and text
    Local integer flag
    If dr_sc > 0.07 Then
      If dr_sc < 0.4 Or MM.HRES < 600 Then flag = 1
      If face_text_bc(obj) + face_text_fc(obj) <> 32 Then
        print_txt = 1
        txt_scale = (1 + dr_sc)^2
        If face_text_font(obj) <> 0 And face_text_scale(obj) <> 0 Then
          txt_font = face_text_font(obj)
          txt_scale = face_text_scale(obj)
        Else
          txt_font = 7 + flag
        End If
        If face_text_font(obj) <> 0 And face_text_scale(obj) = 0 Then txt_font = face_text_font(obj)
        If txt_font = 0 Then txt_font = 7 + flag
      End If
      If face_numbers_bc(obj) + face_numbers_fc(obj) <> 32 Then
        print_num = 1
        numbers_scale = (1 + dr_sc)^2
        If face_numbers_font(obj) <> 0 And face_numbers_scale(obj) <> 0 Then
          numbers_font = face_numbers_font(obj)
          numbers_scale = face_numbers_scale(obj)
        Else
          numbers_font = 7 + flag
        End If
        If face_numbers_font(obj)) <> 0 And face_numbers_scale(obj) = 0 Then numbers_font = face_numbers_font(obj)
        If numbers_font = 0 Then numbers_font = 7 + flag
      End If
    Else
      print_txt = 0
      print_num = 0
    End If
  Else
    print_txt = 0
    print_num = 0
  End If

  If txt_scale > 15 Then txt_scale = 15
  If numbers_scale > 15 Then numbers_scale = 15

  If print_txt Then 'calc text pos
    If text_date_set(obj) Then
      face_txt$ = Date$
    Else
      face_txt$ = face_text1$(obj)
    End If
    txt_x = clock_x_pos + face_text_xoff(obj) * dr_sc + Len(face_txt$) * fonts_wh(0, txt_font -1) * txt_scale / 2
    txt_y = clock_y_pos + face_text_roff(obj) * dr_sc
    If face_text_xoff(obj) + Len(face_txt$) * fonts_wh(0, txt_font -1) * txt_scale / 2 / dr_sc > max_x_ref Then
      max_x_ref = face_text_xoff(obj) + Len(face_txt$) * fonts_wh(0, txt_font -1) * txt_scale / 2 / dr_sc
    End If
  End If

  If print_num Then 'calc pos, print numbers
    Local float nbr_w = Len(face_numbers_1to12$(3,s)) * fonts_wh(0, numbers_font -1) / 2 * numbers_scale + 1
    numbers_rx0(0) = 0
    numbers_ry0(0) = ring_radius(obj) + face_numbers_roff(obj)
    If numbers_ry0(0) + nbr_w / dr_sc  > max_x_ref Then
      max_x_ref = numbers_ry0(0) + nbr_w / dr_sc
      If menu <> 4 Then
        If clock_x_pos + numbers_ry0(0) * dr_sc + nbr_w > m_window_clk Then Inc numbers_ry0(0), -((clock_x_pos + numbers_ry0(0) * dr_sc + nbr_w) - m_window_clk) / dr_sc
      End If
    End If
    Math scale numbers_ry0(), dr_sc, numbers_ry0()
    Text clock_x_pos + numbers_ry0(0), clock_y_pos, face_numbers_1to12$(3,s), "CM", numbers_font, numbers_scale, face_numbers_bc(obj), face_numbers_fc(obj)
    Text clock_x_pos, clock_y_pos + numbers_ry0(0), face_numbers_1to12$(6,s), "CM", numbers_font, numbers_scale, face_numbers_bc(obj), face_numbers_fc(obj)
    Text clock_x_pos - numbers_ry0(0), clock_y_pos, face_numbers_1to12$(9,s), "CM", numbers_font, numbers_scale, face_numbers_bc(obj), face_numbers_fc(obj)
    Text clock_x_pos, clock_y_pos - numbers_ry0(0), face_numbers_1to12$(12,s), "CM", numbers_font, numbers_scale, face_numbers_bc(obj), face_numbers_fc(obj)
    For count = 1 To 2
      Math v_rotate 0, 0, -30, numbers_rx0(), numbers_ry0(), numbers_rx0(), numbers_ry0()
      Text clock_x_pos + numbers_rx0(0),clock_y_pos - numbers_ry0(0), face_numbers_1to12$(count,s), "CM", numbers_font, numbers_scale, face_numbers_bc(obj), face_numbers_fc(obj)
      Text clock_x_pos + numbers_rx0(0),clock_y_pos + numbers_ry0(0), face_numbers_1to12$(6 - count, s), "CM", numbers_font, numbers_scale, face_numbers_bc(obj), face_numbers_fc(obj)
      Text clock_x_pos - numbers_rx0(0),clock_y_pos + numbers_ry0(0), face_numbers_1to12$(6 + count, s), "CM", numbers_font, numbers_scale, face_numbers_bc(obj), face_numbers_fc(obj)
      Text clock_x_pos - numbers_rx0(0),clock_y_pos - numbers_ry0(0), face_numbers_1to12$(9 + count, s), "CM", numbers_font, numbers_scale, face_numbers_bc(obj), face_numbers_fc(obj)
    Next count
  End If

  If face_min_bc(obj) + face_min_fc(obj) <> 32 Then
    If ring_radius(obj) + face_min_roff(obj) > max_x_ref Then max_x_ref = ring_radius(obj) + face_min_roff(obj)
    If Not first_run Then
      If face_min_bc1(obj) + face_min_fc1(obj) <> 32 Then
        build_label(obj, 1, 1, clock_x_pos, clock_y_pos)
      Else
        build_label(obj, 1, 0, clock_x_pos, clock_y_pos)
      End If
    End If
  End If

  If indi6_style(obj) <> 2 Then build_hour(obj, clock_x_pos, clock_y_pos)

  For angle = scale_start To scale_end Step 30 'prepare labels and rotate/print to hour positions

    Select Case angle
    Case 0
      indi_mode = indi6_style(obj)
      set_indi = 6
    Case 90
      indi_mode = indi9_style(obj)
      set_indi = 9
    Case 180
      indi_mode = indi12_style(obj)
      set_indi = 12
    Case 270
      indi_mode = indi3_style(obj)
      set_indi = 3
    Case Else
      indi_mode = 1
      indi_set = 0
    End Select

    Select Case indi_mode
    Case 0
      indi_done = 1
      hour_done = 1
      indi_set = 0
    Case 1
      If face_hour_bc(obj) + face_hour_fc(obj) <> 32 Then
        If ring_radius(obj) + face_hour_roff(obj) > max_x_ref Then max_x_ref = ring_radius(obj) + face_hour_roff(obj)
        hour_done = 1
      Else
        hour_done = 0
      End If
      indi_done = 0
      indi_set = 0
    Case 2,3,4,5,6
      hour_done = 0
      build_indi(obj, set_indi, clock_x_pos, clock_y_pos)
      If ring_radius(obj) + indi3_roff(obj) > max_x_ref Then max_x_ref = ring_radius(obj) + indi3_roff(obj)
      indi_set = 1 : If Not indi_done Then indi_set = 0
      If indi_mode = 4 Then draw_indi_circle(obj, angle, set_indi, clock_x_pos, clock_y_pos, phour_xoff(), phour_roff(), phour_xofft(), phour_rofft())
      If indi_mode = 6 Then draw_hour_circle(obj, angle, clock_x_pos, clock_y_pos, phour_xoff(), phour_roff(), phour_xofft(), phour_rofft())
      End If
    End Select

    If Not first_run And hour_done + indi_done = 1 Then 'draw hour label
      If hour_done Then
        draw_label(obj,angle, 0, 0, clock_x_pos, clock_y_pos)
      Else
        draw_label(obj,angle, set_indi, 0, clock_x_pos, clock_y_pos)
      End If
    End If

    If Not first_run And indi_mode = 1 Or indi_mode = 3 Then draw_hour_circle(obj, angle, clock_x_pos, clock_y_pos, phour_xoff(), phour_roff(), phour_xofft(), phour_rofft())

    If Not first_run And indi_mode = 5 Then draw_indi_circle(obj, angle, set_indi, clock_x_pos, clock_y_pos, phour_xoff(), phour_roff(), phour_xofft(), phour_rofft())

    If indi_set Then indi_set = 0 : indi_mode = 0 : If Not first_run Then build_hour(obj, clock_x_pos, clock_y_pos)

    For min_angle = 24 To 6 Step -6 'draw minutes
      If Not first_run Then draw_label(obj,angle + min_angle, 1, 1, clock_x_pos, clock_y_pos) 'draw minute label
      If Not first_run And face_pmin_bc(obj) + face_pmin_fc(obj) <> 32 Then 'draw minute circle
        Math v_rotate clock_x_pos, clock_y_pos, angle + min_angle, pmin_xoff(), pmin_roff(), pmin_xofft(), pmin_rofft()
        If face_pmin_fc(obj) <> 16 Then
          Circle pmin_xofft(0) , pmin_rofft(0), face_pmin_radius(obj) * dr_sc, face_pmin_lw(obj) * dr_sc,, face_pmin_bc(obj), face_pmin_fc(obj)
        Else
          Circle pmin_xofft(0) , pmin_rofft(0), face_pmin_radius(obj) * dr_sc, face_pmin_lw(obj) * dr_sc,, face_pmin_bc(obj)
        End If
        If  face_pmin_bc1(obj) + face_pmin_fc1(obj) <> 32 Then 'draw minute1 circle
          If face_pmin_fc1(obj) <> 16 Then
            Circle pmin_xofft(0) , pmin_rofft(0), face_pmin_radius1(obj) * dr_sc, face_pmin_lw1(obj) * dr_sc,, face_pmin_bc1(obj), face_pmin_fc1(obj)
          Else
            Circle pmin_xofft(0), pmin_rofft(0),face_pmin_radius1(obj) * dr_sc, face_pmin_lw1(obj) * dr_sc,, face_pmin_bc1(obj)
          End If
        End If
      End If
    Next min_angle
  Next angle

  If print_txt Then 'print text if in bound
    If menu <> 4 Then If txt_x > m_window_clk Then Inc txt_x, m_window_clk - txt_x
    Text txt_x, txt_y, face_txt$, "RB", txt_font, txt_scale, face_text_bc(obj), face_text_fc(obj)
  End If
End Sub

Sub draw_hour_circle(obj, angle, clock_x_pos, clock_y_pos, phour_xoff(), phour_roff(), phour_xofft(), phour_rofft())
    If face_phour_bc(obj) + face_phour_fc(obj) <> 32 Then 'draw hour circle
      Math v_rotate clock_x_pos, clock_y_pos, angle, phour_xoff(), phour_roff(), phour_xofft(), phour_rofft()
      If face_phour_fc(obj) <> 16 Then
        Circle phour_xofft(0), phour_rofft(0), face_phour_radius(obj) * dr_sc, face_phour_lw(obj) * dr_sc,, face_phour_bc(obj), face_phour_fc(obj)
      Else
        Circle phour_xofft(0), phour_rofft(0) , face_phour_radius(obj) * dr_sc, face_phour_lw(obj) * dr_sc,, face_phour_bc(obj)
      End If
      If  face_phour_bc1(obj) + face_phour_fc1(obj) <> 32 Then
        If face_phour_fc1(obj) <> 16 Then
           Circle phour_xofft(0), phour_rofft(0), face_phour_radius1(obj) * dr_sc, face_phour_lw1(obj) * dr_sc,, face_phour_bc1(obj), face_phour_fc1(obj)
        Else
          Circle phour_xofft(0), phour_rofft(0) , face_phour_radius1(obj) * dr_sc, face_phour_lw1(obj) * dr_sc,, face_phour_bc1(obj)
        End If
      End If
    End If
  End Sub

Sub build_hour(obj, clock_x_pos, clock_y_pos)
  If face_hour_bc(obj) + face_hour_fc(obj) <> 32 Then
    hour_done = 1
    If face_hour_bc1(obj) + face_hour_fc1(obj) <> 32 Then
      build_label(obj, 0, 1, clock_x_pos, clock_y_pos)
    Else
      build_label(obj, 0, 0, clock_x_pos, clock_y_pos)
    End If
  Else
    hour_done = 0
  End If
End Sub

Sub build_indi(obj, set_indi, clock_x_pos, clock_y_pos)
  set_label_colour(obj, set_indi)
  If col_bc + col_fc <> 32 Then
    indi_done = 1
    If col_bc1 + col_fc1 <> 32 Then
      build_label(obj, set_indi, 1, clock_x_pos, clock_y_pos)
    Else
      build_label(obj, set_indi, 0, clock_x_pos, clock_y_pos)
    End If
  Else
    indi_done = 0
  End If
End Sub

Sub draw_label(obj,d_angle, lnbr, label, clock_x_pos, clock_y_pos)
  Local integer print_px(13), print_py(13)
  Local integer pcorners

  set_label_colour(obj, lnbr)

  Select Case build_mode
  Case 0
    pcorners = 3
  Case 1
    pcorners = 4
  Case 2
    pcorners = 8
  Case 3
    pcorners = 14
  End Select

  If col_fc + col_bc <> 32 Then
    If Not label Then
      Math v_rotate clock_x_pos, clock_y_pos, d_angle, hpx(), hpy(), print_px(), print_py()
    Else
      Math v_rotate clock_x_pos, clock_y_pos, d_angle, mpx(), mpy(), print_px(), print_py()
    End If
    If col_fc <> 16 Then
      Polygon pcorners, print_px(), print_py(), col_bc, col_fc
    Else
      Polygon pcorners, print_px(), print_py(), col_bc
    End If
    If col_bc1 + col_fc1 <> 32 Then 'draw hour1 label
      If label Then
        Math v_rotate clock_x_pos, clock_y_pos, d_angle, mpx1(), mpy1(), print_px(), print_py()
      Else
        Math v_rotate clock_x_pos, clock_y_pos, d_angle, hpx1(), hpy1(), print_px(), print_py()
      End If
      If col_fc1 <> 16 Then
        Polygon pcorners, print_px(), print_py(), col_bc1, col_fc1
      Else
        Polygon pcorners, print_px(), print_py(), col_bc1
      End If
    End If
  End If
End Sub

Sub set_label_colour(obj, label_nbr)
  Select Case label_nbr
  Case 0
    build_mode = face_hour_build_mode(obj)
    col_bc = face_hour_bc(obj)
    col_fc = face_hour_fc(obj)
    col_bc1 = face_hour_bc1(obj)
    col_fc1 = face_hour_fc1(obj)
  Case 1
    build_mode = face_min_build_mode(obj)
    col_bc = face_min_bc(obj)
    col_fc = face_min_fc(obj)
    col_bc1 = face_min_bc1(obj)
    col_fc1 = face_min_fc1(obj)
  Case 3
    build_mode = indi3_build_mode(obj)
    col_bc = indi3_bc(obj)
    col_fc = indi3_fc(obj)
    col_bc1 = indi3_bc1(obj)
    col_fc1 = indi3_fc1(obj)
  Case 6
    build_mode = indi6_build_mode(obj)
    col_bc = indi6_bc(obj)
    col_fc = indi6_fc(obj)
    col_bc1 = indi6_bc1(obj)
    col_fc1 = indi6_fc1(obj)
  Case 9
    build_mode = indi9_build_mode(obj)
    col_bc = indi9_bc(obj)
    col_fc = indi9_fc(obj)
    col_bc1 = indi9_bc1(obj)
    col_fc1 = indi9_fc1(obj)
  Case 12
    build_mode = indi12_build_mode(obj)
    col_bc = indi12_bc(obj)
    col_fc = indi12_fc(obj)
    col_bc1 = indi12_bc1(obj)
    col_fc1 = indi12_fc1(obj)
  End Select
End Sub

Sub draw_indi_circle(obj, angle, label_nbr, clock_x_pos, clock_y_pos, phour_xoff(), phour_roff(), phour_xofft(), phour_rofft())
  Local float  w, h, w1, h1, lw, lw1, roff, bc, fc, bc1, fc1
  Execute "w = cir_indi" + Str$(label_nbr) + "_radius(obj)"
  Execute "h = cir_indi" + Str$(label_nbr) + "_alignment(obj)"
  Execute "w1 = cir_indi" + Str$(label_nbr) + "_radius1(obj)"
  Execute "h1 = cir_indi" + Str$(label_nbr) + "_alignment1(obj)"
  Execute "lw = cir_indi" + Str$(label_nbr) + "_lw(obj)"
  Execute "lw1 = cir_indi" + Str$(label_nbr) + "_lw1(obj)"
  Execute "roff = cir_indi" + Str$(label_nbr) + "_roff(obj)"
  Execute "bc = cir_indi" + Str$(label_nbr) + "_bc(obj)"
  Execute "fc = cir_indi" + Str$(label_nbr) + "_fc(obj)"
  Execute "bc1 = cir_indi" + Str$(label_nbr) + "_bc1(obj)"
  Execute "fc1 = cir_indi" + Str$(label_nbr) + "_fc1(obj)"

  If w = 0 Then w = 0.1
  If w1 = 0 Then w1 = 0.1
  If bc + fc <> 32 Then
    If label_nbr = 3 Then
      If w * h / w > w1 * h1 / w1 Then
        Inc roff, -w * (h / w)
        If ring_radius(obj) + roff + w * (h / w) > max_x_ref Then max_x_ref = ring_radius(obj) + roff + w * (h / w)
      Else
        Inc roff, -w1 * (h1 / w1)
        If ring_radius(obj) + roff + w1 * (h1 / w1) > max_x_ref Then max_x_ref = ring_radius(obj) + roff + w1 * (h1 / w1)
      End If
    End If
    phour_xoff(1) = clock_x_pos
    phour_roff(1) = clock_y_pos + (ring_radius(obj) + roff) * dr_sc
    Math v_rotate clock_x_pos, clock_y_pos, angle, phour_xoff(), phour_roff(), phour_xofft(), phour_rofft()
    If fc <> 16 Then
      Circle phour_xofft(1), phour_rofft(1), w * dr_sc, lw * dr_sc, h / w, bc, fc
    Else
      Circle phour_xofft(1), phour_rofft(1), w * dr_sc, lw * dr_sc, h / w, bc
    End If
    If bc1 + fc1 <> 32 Then
      If fc1 <> 16 Then
        Circle phour_xofft(1), phour_rofft(1), w1 * dr_sc, lw1 * dr_sc, h1 / w1, bc1, fc1
      Else
        Circle phour_xofft(1), phour_rofft(1), w1 * dr_sc, lw1 * dr_sc, h1 / w1, bc1
      End If
    End If
  End If
End Sub

DefineFont #9
  60200808
  00000000 00000000 38383838 00380038 8844EEEE 00000000 62FF6200 0062FF62
  FEC0F61C 0070DE06 381CEEE6 00CEEE70 7EE0E4FC 00FEE4E4 20103838 00000000
  10100804 00040810 08081020 00201008 3C7E1800 0000187E FE383800 00003838
  00000000 20103838 7E000000 00000000 00000000 00383800 381C0E06 00C0E070
  C6C2C2FE 00FE8686 10101030 007C7C10 FE0202FE 00FEC0C0 FE0404FC 00FE0606
  C6C6C0C0 000606FE FE8080FE 00FE0606 FE808CFC 00FE8686 3E0202FE 00303030
  FE4C4C7C 00FEC6C6 FE8686FE 00060606 00383800 00003838 00383800 20103838
  70381C0E 000E1C38 007E0000 0000007E 0E1C3870 0070381C 3E0ECEFE 00300030
  41899576 36494122 FE46467E 00868686 FE8C8CFC 00FE8686 808686FE 00FE8282
  C68484FC 00FEC6C6 FE8080FE 00FEC0C0 FEC080FE 00C0C0C0 9E8082FE 00FE8686
  FE868686 00868686 1810107E 007E1818 06040404 00FE8686 F8848282 0086868C
  C0404040 00FEC0C0 8696AEC6 00868686 9EB6E6C6 0086868E 868282FE 00FE8686
  FE8282FE 00C0C0C0 C4C4C4FC 00F6CECC FE8C8CFC 00C6C6C6 FEC0C2FE 00FEC202
  1818187E 00181818 86868686 00FE8686 86868686 00385C8E 86868686 00C6AE96
  7CC2C2C2 00868686 7E464646 00181818 380C06FE 00FEC060 10100804 00040810
  3870E0C0 00060E1C 08081020 00201008 38381010 0000006C 00000000 FF000000
  FC40623C 00FEE0E0 86FE0000 00F68E86 C2FEC0C0 00FEE2C2 C2FE0000 00FEE2C0
  86FE0606 00FE8E86 C2FE0000 00FEE0FE C0C03E00 00E0E0F8 86FE0000 FE0EFE86
  C2FEC0C0 00E2E2C2 1838001C 001C1C18 0C0C000C FE8E0E0C 86868080 008E8EFC
  18181838 001C1C18 C2FE0000 00EAEACA C2FE0000 00E2E2C2 86FE0000 00FE8E86
  C2FE0000 E0E0FEC2 8EFE0000 0E0EFE8E C2FE0000 00E0E0C0 C0FE0000 00FE0EFE
  C0F8C0C0 00FEE2C0 86860000 00FE8E86 C2C20000 0070E8C4 CACA0000 00FEE2CA
  74E20000 008E5C38 86860000 FE0EFE86 06FE0000 00FEE0FE B838383A 003A3838
  38383838 00383838 3E3838B8 00B83838 AA55AA55 AA55AA55 B195423C 3C4295B1
End DefineFont
