'*************************************************************************************
'
' Gerry Allardice
' 2.0 1st release
' 2015-05-17
' Dual Battery Monitor
'
' Graphics library for ILI9341 display with XPT2046 touch controller
' based on Peter Mather's library on TBS forum.
' Touch is interupt driven

'  dim integer I9341_CD=4  
'  dim integer I9341_CS=6
'  dim integer I9341_RESET=5
'  dim integer T_IRQ=2         
'  dim integer T_CS=7  
'  LED PWM 2A  26
'  V1 on pin 23  
'  V2 on pin 24
'*************************************************************************************
option explicit
option default NONE
OPTION BASE 0
OPTION AUTORUN ON
cpu 48


  I9341.init 'display
  
  'additional program DIM declarations for global variables
  DIM INTEGER ActivePage,LastPage,ArrayAddress(5),ActiveArray,LastArray,MenuSelected,VMenuSelected,HMenuSelected,TouchType,LastX,LastY,LastYseq=0,LastXseq=0
  DIM INTEGER Rolling1MinuteTotal0=0,Rolling3MinuteTotal0=0,Rolling6MinuteTotal0=0,Rolling1MinuteTotal1=0,Rolling3MinuteTotal1=0,Rolling6MinuteTotal1=0
  DIM INTEGER Rolling1MinuteTotal2=0,Rolling3MinuteTotal2=0,Rolling6MinuteTotal2=0,Rolling1MinuteTotal3=0,Rolling3MinuteTotal3=0,Rolling6MinuteTotal3=0
  DIM INTEGER RollingCount1=0,RollingCount3=0, RollingCount6=0 ,Last239

  dim integer colours(7)=(red,blue,green,magenta,cyan,yellow,white,black),PWMv=0
  '**********************************************************************************
  ' Swap between these two lines to set colours for individual graphs
  'DIM INTEGER gparams(7)=(2,black,white,red,magenta,yellow,yellow,magenta)
  DIM INTEGER gparams(7)=(2,black,white,red,magenta,yellow,green,cyan)
  '**********************************************************************************
  DIM INTEGER CountDown1=0,CountDown2=0,ManualOff=0,ScreenOff=0

  DIM INTEGER v1sec(720),v1min(720),v3min(720),v6min(720),p1sec=0,p1min=0,p3min=0,p6min=0,pmax1min=720,pmax3min=720,pmax6min=720,pmax1sec=720,vnow
  DIM FLOAT vpin0
  DIM INTEGER screen(240),ScreenArrayAddress
  DIM INTEGER lastv0,lastv1,lastV2,lastv3
  ArrayAddress(1)=PEEK(VARADDR v1sec())
  ArrayAddress(2)=PEEK(VARADDR v1min())
  ArrayAddress(3)=PEEK(VARADDR v3min())
  ArrayAddress(4)=PEEK(VARADDR v6min())
  ScreenArrayAddress =PEEK(VARADDR screen())
  
   'set resistor values in voltage divider
'  DIM INTEGER R1=47060         'breadboard
'  DIM INTEGER R2=10160
'  DIM INTEGER R3=46660
'  DIM INTEGER R4=10120

'  DIM INTEGER R1=46990        'no2  MUP No1
'  DIM INTEGER R2=10210
'  DIM INTEGER R3=46750
'  DIM INTEGER R4=10130
  
  DIM INTEGER R1=46990        'no3  BP170 No1
  DIM INTEGER R2=10210
  DIM INTEGER R3=46750
  DIM INTEGER R4=10130
  
 ' DIM INTEGER R1=46990       'no4  BP170 No2
 ' DIM INTEGER R2=10210
 ' DIM INTEGER R3=46750
 ' DIM INTEGER R4=10130
  
  
  
  DIM FLOAT M1=(R1+R2)/R2
  DIM FLOAT M2=(R3+R4)/R4
  

  SetupApplicationDisplay
  'Setup reading and storing of data at 1 second interupt
  SETTICK 1000,ReadAndStoreData,1
  
  memory
  'It is all interupt driven from here so do notrhing forever.
  do
  LOOP
  END

sub SetupApplicationDisplay
  LOCAL integer i
  'for i=1 to 4
  '  print hex$(arrayaddress(i))
  'next i
  for i= 1 to 180
    v1sec(i)=0
    v1min(i)=0
    v3min(i)=0
    v6min(i)=0
  next i
  for i= 1 to 240
   screen(i)=0
  next i
  'local integer x0, y0, x1, y1, wi, ht,i, colour=red
  I9341.setrot(3)   'rotate screen
 
  PrepareMenu
  SetInitialMenu
  WriteScaleLines
  WriteScaleLabels


  'i=T.Getdata(&HA8) 'wake up the controller -not required it seems
 ' pause 1000
  setpin T_IRQ,INTL,readtouch,pullup   'Use interupt driver touch 
  'SETPIN 23,AIN
  SETPIN 23,AIN
  SETPIN 24,AIN   
  vnow=PIN(23)
  vpin0=PIN(0)
  'LED Driven thru BC558 via PIN 26 PWM 2A
  pwm 2,1000,0
  
end SUB


SUB ReadAndStoreData
   local integer value,value0,value1,value2,value3,v0inst,v1inst,v2inst,v3inst,vnow0,vnow1,temp
   
   TIMER=0
   '********************************************************************
   'Start of data capture monitoring 2 voltages (pin 23 and 24)
   
   'vpin0=PIN(0)  ' Using PIN(0) before a real PIN(x) command seem to intermittantly cause resets.
   vnow0=CINT(20*M1*pin(23)/(vpin0/1.2))*5
   vnow1=CINT(20*M2*pin(24)/(vpin0/1.2))*5
   vpin0=PIN(0)  'Doing it here seems quite OK.
   'To conserve power we automatically put it in sleep mode after 15 minutes if voltage < 12.6 Volts
   'If voltage <12.6 we will start  autoshutdown timer
   IF vnow0<1260 then
       CountDown2=0
       IF CountDown1=0 THEN  
        CountDown1=1      
        SETTICK 900000,AutoOff,3            '900 seconds is 15 minutes
       END IF 
  'If voltage >13.0 we will automattically wake it up after 1 second via AutoOn timer
   ELSE IF vnow0>1300 then
      CountDown1=0
      IF CountDown2=0 THEN  
        CountDown2=1      
        SETTICK 1000,AutoOn,3
      END IF 
   'if between 12.6 and 13.0 then leave it as it is.
   else 
       CountDown1=0
       CountDown2=0
       SETTICK 0,0,3
   END IF
   
   
   value0=CINT(210-(vnow0-1000)*0.3)
   value1=CINT(210-(vnow1-1000)*0.3)
   'set value3 to smooth value0 graph   
   if lastv0>value0 then
      value3=value0+1
   elseIF lastv0<value0 then
      value3=value0-1 
   ELSE
       value3=lastv3
   endif 
   'set value2 to smooth value1 graph 
   if lastv1>value1 then
      value2=value1+1
   elseIF lastv1<value1 then
      value2=value1-1 
    
   ELSE
       value2=lastv2
   endif 
   lastv0=value0 
   lastv1=value1 
   lastv2=value2 
   lastv3=value3 

   'end reading voltages
  
   '**********************************************************
   'TEST CODE FOR 4 individual graphs
   'Uncomment these 7 lines to see some example sin waves displayed
   value0=cint(120+100*sin(RAD(p1sec)*1.5))   'green
   value1=cint(115+100*sin(RAD(p1sec*2)))      'cyan
   value2=cint(120+100*sin(RAD(p1sec)))       'magenta
   value3=cint(120+100*sin(RAD(p1sec/2)))     'yellow 
   CountDown1=0  'dont turn it off or on automatically
   CountDown2=0  'dont turn it off or on automatically
   SETTICK 0,0,3 'dont turn it off or on automatically
   '**********************************************************
   
      
   v0inst=value0
   v1inst=value1
   v2inst=value2
   v3inst=value3
   

   value=(encode(value3)<<24)+(encode(value2)<<16)+(encode(value1)<<8) + encode(value0)
   POKE WORD ArrayAddress(1)+p1sec*4,value

   Rolling1MinuteTotal0=Rolling1MinuteTotal0+v0inst
   Rolling3MinuteTotal0=Rolling3MinuteTotal0+v0inst
   Rolling6MinuteTotal0=Rolling6MinuteTotal0+v0inst
   Rolling1MinuteTotal1=Rolling1MinuteTotal1+v1inst
   Rolling3MinuteTotal1=Rolling3MinuteTotal1+v1inst
   Rolling6MinuteTotal1=Rolling6MinuteTotal1+v1inst
   Rolling1MinuteTotal2=Rolling1MinuteTotal2+v2inst
   Rolling3MinuteTotal2=Rolling3MinuteTotal2+v2inst
   Rolling6MinuteTotal2=Rolling6MinuteTotal2+v2inst
   Rolling1MinuteTotal3=Rolling1MinuteTotal3+v3inst
   Rolling3MinuteTotal3=Rolling3MinuteTotal3+v3inst
   Rolling6MinuteTotal3=Rolling6MinuteTotal3+v3inst
   RollingCount1=RollingCount1+1
   RollingCount3=RollingCount3+1
   RollingCount6=RollingCount6+1

      'store the rolling 1 minute averages
      value0=CINT(Rolling1MinuteTotal0/RollingCount1)AND 255
      value1=CINT(Rolling1MinuteTotal1/RollingCount1)AND 255
      value2=CINT(Rolling1MinuteTotal2/RollingCount1)AND 255
      value3=CINT(Rolling1MinuteTotal3/RollingCount1)AND 255
      value=(encode(value3)<<24)+(encode(value2)<<16)+(encode(value1)<<8) + encode(value0)
      POKE WORD ArrayAddress(2)+p1min*4,value
      
      'store the rolling 3 minute averages
      value0=CINT(Rolling3MinuteTotal0/RollingCount3)AND 255
      value1=CINT(Rolling3MinuteTotal1/RollingCount3)AND 255
      value2=CINT(Rolling3MinuteTotal2/RollingCount3)AND 255
      value3=CINT(Rolling3MinuteTotal3/RollingCount3)AND 255
      value=(encode(value3)<<24)+(encode(value2)<<16)+(encode(value1)<<8) + encode(value0)
      POKE WORD ArrayAddress(3)+p3min*4,value
      
      'store the rolling 6 minute averages
      value0=CINT(Rolling6MinuteTotal0/RollingCount6)AND 255
      value1=CINT(Rolling6MinuteTotal1/RollingCount6)AND 255
      value2=CINT(Rolling6MinuteTotal2/RollingCount6)AND 255
      value3=CINT(Rolling6MinuteTotal3/RollingCount6)AND 255
      value=(encode(value3)<<24)+(encode(value2)<<16)+(encode(value1)<<8) + encode(value0)
      POKE WORD ArrayAddress(4)+p6min*4,value

      'Check if a round minute has passed
      If RollingCount1=60 Then
         Rolling1MinuteTotal0=0
         Rolling1MinuteTotal1=0
         Rolling1MinuteTotal2=0
         Rolling1MinuteTotal3=0
         RollingCount1=0
         p1min=p1min+1
         if p1min=1440 then p1min=0
      END If
      If RollingCount3=180 Then
         Rolling3MinuteTotal0=0
         Rolling3MinuteTotal1=0
         Rolling3MinuteTotal2=0
         Rolling3MinuteTotal3=0
         RollingCount3=0
         p3min=p3min+1
         if p3min=1440 then p3min=0
      END If
      If RollingCount6=360 Then
         Rolling6MinuteTotal0=0
         Rolling6MinuteTotal1=0
         Rolling6MinuteTotal2=0
         Rolling6MinuteTotal3=0
         RollingCount6=0
         p6min=p6min+1
         if p6min=1440 then p6min=0
      END If
    'if ScreenOff=0 then RefreshGraph
    RefreshGraph
    p1sec=p1sec+1
    if p1sec=1440 then
      p1sec=0
     '?"p1sec reset "+TIME$
    ENDIF
   
    'I9341.pstring(120, 220,STR$(TIMER)+"  "+str$(v0inst)+"  "+str$(v1inst)+"  "+STR$(v2inst)+"  "+STR$(temp)+"  ", 1, 0, white, black)
    I9341.pstring(120, 220,str$(vnow0/100,2,2),2, 0, magenta, black)
    I9341.pstring(190, 220,Str$(vnow1/100,2,2),2, 0, yellow, black)
    'PRINT STR$(TIMER) + "ms - Read & Refresh"
END SUB
SUB AutoOff
     LOCAL INTEGER i
     ScreenOff=1
     i=I9341draw(I9341.wcom,&H10) 'sleep
     'turn off backlight
     pwm 2,STOP
     PWMv=0
     cpu 10 

END SUB
SUB AutoOn
     LOCAL INTEGER i
     ScreenOff=0
     IF ManualOff=0 THEN
       i=I9341draw(I9341.wcom,&H11) 'wakeup
       pause 150
       cpu 48
       if PWMv=0 then
        pwm 2,100,0
       ELSE IF PWMv=50 THEN
        pwm 2,100,50
       ELSE IF PWMv=80 THEN
        pwm 2,100,90
       END IF  
     END IF 
END SUB
FUNCTION encode(x as INTEGER)as INTEGER
  
  select CASE x
             CASE 30,60,90,120,150,180,210
             encode=x\30 AND 255
  CASE else
              encode=x and 255
  END SELECT
  If x>=211 then encode=211 AND 255
  If x>=500 then encode=0 AND 255  'likely zero volts so no output
  IF x=<29 then encode=29 AND 255 
  IF x=<1 then encode=0 AND 255
END FUNCTION

SUB RefreshGraph
  LOCAL INTEGER j,k,pn, NewValuesAddress
  SELECT CASE ActiveArray
  CASE 1
   pn=p1sec
  CASE 2
    pn=p1min
  CASE 3
   pn=p3min
  CASe 4
    pn=p6min
  END SELECT


  j=((pn*4)-959-(ActivePage*960))
  if j<0 then j=2880+j

  k=(pn-239-(ActivePage*240))
  if k<0 then k=1440+k

  NewValuesAddress=ArrayAddress(ActiveArray)

  'call refresh routine with the two array address for the new and old values
 
  I9341.dgraph(NewValuesAddress,k, screen(),gparams())

  

END SUB

'Write the scale lines for the graph
SUB WriteScaleLines
   LOCAL INTEGER i,j,k,x,o,n
   'Vertical scale lines
   for i=30 to 210 step 30
     I9341.dline(0, i, 239,i,white)
   Next i
     'Vertical labels
     I9341.pstring(242, 27, "16V", 1, 0, white, black)
     I9341.pstring(242, 57, "15V", 1, 0, white, black)
     I9341.pstring(242, 87, "14V", 1, 0, white, black)
     I9341.pstring(242, 117, "13V", 1, 0, white, black)
     I9341.pstring(242, 147, "12V", 1, 0, white, black)
     I9341.pstring(242, 177, "11V", 1, 0, white, black)
     I9341.pstring(242, 207, "10V", 1, 0, white, black)

      'horizontal scale
      I9341.dline(0, 10, 239,10,white)
      I9341.dline(0, 10, 0,18,white)
      I9341.dline(14, 10, 14,12,white)
      I9341.dline(29, 10, 29,15,white)
      I9341.dline(44, 10, 44,12,white)
      I9341.dline(59, 10,59,18,white)
      I9341.dline(74, 10, 74,12,white)
      I9341.dline(89, 10, 89,15,white)
      I9341.dline(104, 10, 104,12,white)
      I9341.dline(119, 10,119,18,white)
      I9341.dline(134, 10, 134,12,white)
      I9341.dline(149, 10, 149,15,white)
      I9341.dline(164, 10, 164,12,white)
      I9341.dline(179, 10,179,18,white)
      I9341.dline(194, 10, 194,12,white)
      I9341.dline(209, 10, 209,15,white)
      I9341.dline(224, 10, 224,12,white)
      I9341.dline(239, 10, 239,18,white)

END SUB

'Write the scale lines for the graph
SUB WriteScaleLabels


          SELECT CASE ActiveArray
          CASE 1,2

            I9341.pstring(242, 13, str$(ActivePage*4)+"  ", 1, 0, white, black)
            I9341.pstring(182, 13, str$(ActivePage*4+1)+"  ", 1, 0, white, black)
            I9341.pstring(122, 13, str$(ActivePage*4+2)+"  ", 1, 0, white, black)
            I9341.pstring(62, 13, str$(ActivePage*4+3)+"  ", 1, 0, white, black)
            I9341.pstring(2, 13, str$(ActivePage*4+4)+"  ", 1, 0, white, black)
            if ActiveArray=1 then
                I9341.pstring(89, 0, "previous minutes", 1, 0, white, black)
            else
                I9341.pstring(89, 0, "previous hours  ", 1, 0, white, black)
            endif
          CASE 3
            I9341.pstring(89, 0, "previous hours  ", 1, 0, white, black)
            I9341.pstring(242, 13, str$(ActivePage*12)+"  ", 1, 0, white, black)
            I9341.pstring(182, 13, str$(ActivePage*12+3)+"  ", 1, 0, white, black)
            I9341.pstring(122, 13, str$(ActivePage*12+6)+"  ", 1, 0, white, black)
            I9341.pstring(62, 13, str$(ActivePage*12+9)+"  ", 1, 0, white, black)
            I9341.pstring(2, 13, str$(ActivePage*12+12)+"  ", 1, 0, white, black)
          CASe 4
             I9341.pstring(89, 0, "previous hours  ", 1, 0, white, black)
             I9341.pstring(242, 13, str$(ActivePage*24)+"  ", 1, 0, white, black)
             I9341.pstring(182, 13, str$(ActivePage*24+6)+"  ", 1, 0, white, black)
             I9341.pstring(122, 13, str$(ActivePage*24+12)+"  ", 1, 0, white, black)
             I9341.pstring(62, 13, str$(ActivePage*24+18)+"  ", 1, 0, white, black)
             I9341.pstring(2, 13, str$(ActivePage*24+24)+"  ", 1, 0, white, black)
          END SELECT

END SUB
SUB SetInitialMenu
        MenuSelected=5
        VMenuSelected=MenuSelected
        I9341.drndrect(272, (5-MenuSelected)*50, 47, 39, 3, green)
        I9341.drndrect(273, (5-MenuSelected)*50+1, 45, 37, 3, green)
        I9341.drndrect(274, (5-MenuSelected)*50+2, 43, 35, 3, green)
        TouchType=1
        ActiveArray=1
        LastArray=1
        ActivePage=0
        LastPage=0

END SUB
SUB ActionTouch
  local integer yvalue,xvalue,i
  setpin T_IRQ,OFF   'Use interupt driver touch
  SETTICK 0,0,4
  SELECT CASE TouchType
  CASE 1  'Vertical Menu
    'Always show first page if menu changes
    ActivePage=0
    if MenuSelected=5 Then
     ActiveArray=1

     writescalelabels
    ELSEif MenuSelected=4 Then
     ActiveArray=2

     writescalelabels
    ELSEif MenuSelected=3 Then
     ActiveArray=3

     writescalelabels
    ELSEif MenuSelected=2 Then
     ActiveArray=4
     writescalelabels
     
    ELSEif MenuSelected=1 Then 'Switch Off
     i=I9341draw(I9341.wcom,&H10) 'sleep
     
     pwm 2,STOP  'turn off backlight
     PWMv=0
     ScreenOff=1
     cpu 10
     '
     'print "OFF"
    Endif

   'print "Vmenu"
  CASE 2  'Horizontal Menu
    'print "Hmenu"
    if MenuSelected=9 Then
      'I9341.pstring(100, 100,  " LEFT  ", 2, 0, black, white)
        If ActivePage<5 then ActivePage=ActivePage+1
        writescalelabels
        'Deselect the menu when finished
        I9341.drndrect((4-HMenuSelected)*64, 219, 47, 21,3, white) '
        I9341.drndrect((4-HMenuSelected)*64+1, 220, 45, 19,3, white)
        I9341.drndrect((4-HMenuSelected)*64+2, 221, 43, 17,3, white)

    ELSEIF MenuSelected=8 Then
       'I9341.pstring(100, 100,  " RIGHT  ", 2, 0, black, white)
          If ActivePage>0 then ActivePage=ActivePage-1
          writescalelabels
          'Deselect the menu when finished
          I9341.drndrect((4-HMenuSelected)*64, 219, 47, 21,3, white) '
          I9341.drndrect((4-HMenuSelected)*64+1, 220, 45, 19,3, white)
          I9341.drndrect((4-HMenuSelected)*64+2, 221, 43, 17,3, white)
    ELSEIF MenuSelected=7 Then
     ' I9341.pstring(100, 100,  " PAUSE  ", 2, 0, black, white)

    ELSEIF MenuSelected=6 Then
       'I9341.pstring(100, 100,  " HELP  ", 2, 0, black, white)

    End IF
  CASE 3  'Work Area
     ScreenOff=0
     i=I9341draw(I9341.wcom,&H11) 'wakeup
     pause 150
     'Put CPU backup 
     cpu 48
     ' Turn on backlight
     if PWMv=0 then
      pwm 2,1000,0
      PWMv=50
     ELSE IF PWMv=50 THEN
      pwm 2,1000,50
      PWMv=80
     ELSE IF PWMv=80 THEN
      pwm 2,1000,90
      PWMv=0
     END IF  
    
  CASE ELSE
    'print "Not Set"
  END SELECT
  setpin T_IRQ,INTL,readtouch,pullup   'Use interupt driver touch
END SUB

SUB ReadTouch

    LOCAL integer x0, y0, x1, y1, wi, ht,i, colour=red
    local float tn
    local integer xvalue,yvalue
    
    LOCAL INTEGER j 
    'any touch will stop the timeout    
    CountDown1=0
    CountDown2=0
    SETTICK 0,0,3

    wi=I9341_Params(I9341_wi)
    ht=I9341_params(I9341_ht)

    if T.getxy(xvalue,yvalue,1000)  then
      y0=yvalue
      x0=xvalue
    
      if y0<=30  then ' y in vertical menu strip
        MenuSelected=(x0\25)+1

        VMenuSelected=MenuSelected
        if MenuSelected>1 then  'Done move green button if off
          for i=1 to 5

                I9341.drndrect(272, (5-i)*50, 47, 39, 3, white)
                I9341.drndrect(273, (5-i)*50+1, 45, 37, 3, white)
                I9341.drndrect(274, (5-i)*50+2, 43, 35, 3, white)
          Next i

          I9341.drndrect(272, (5-MenuSelected)*50, 47, 39, 3, green)
          I9341.drndrect(273, (5-MenuSelected)*50+1, 45, 37, 3, green)
          I9341.drndrect(274, (5-MenuSelected)*50+2, 43, 35, 3, green)
        endif
        TouchType=1
        
      else
        if x0<=30  then ' In horizontal Menus
          'Highlight the selected horizontal menu
          IF y0 > 73 THEN          
           If y0>93 then
            MenuSelected=9
           elseif y0>73 THEN
            MenuSelected=8
           Endif
           'MenuSelected=((y0-10)\23)+5
           HMenuSelected=MenuSelected-5
           I9341.drndrect((9-MenuSelected)*64, 219, 47, 21,3, green) '
           I9341.drndrect((9-MenuSelected)*64+1, 220, 45, 19,3, green)
           I9341.drndrect((9-MenuSelected)*64+2, 221, 43, 17,3, green)
           TouchType=2
          END IF
          'LastYseq=0
        else
          'We are in the work area. look for gestures
         
          TouchType=3
        endif
      ENDIF
      'print Menuselected
      'print x0,y0,MenuSelected
      LastY=(y0)\10
      LastX=(x0\10)
      SETTICK 1,actiontouch,4
    endif
END SUB
'Prepare the buttons on the screen
sub PrepareMenu
  LOCAL INTEGER i
  Local String menu$="off... 6 min 3 min 1 min 1 sec"
  I9341.fillscreen(black)
 for i=1 to 5
    'Vertical Menus
     I9341.frndrect(272, (5-i)*50, 47, 39,3, white) '  ;x, y coordinates of top left, width, height, radius of corner, colour
     I9341.pstring(277, (5-i)*50+3,  mid$(menu$,(i-1)*6+1,3), 2, 0, black, white)
     I9341.pstring(277, (5-i)*50+18, mid$(menu$,(i-1)*6+4,3), 2, 0, black, white)
 next i
   menu$=" ? || --><--"
 for i=3 to 4
    'Horizonal Menus
     I9341.frndrect((4-i)*64, 219, 47, 20,3, white) '  ;x, y coordinates of top left, width, height, radius of corner, colour
     I9341.pstring((4-i)*64+5, 224,  mid$(menu$,(i-1)*3+1,3), 2, 0, black, white)
     'I9341.pstring((4-i)*64+5, 218, mid$(menu$,(i-1)*6+4,3), 2, 0, black, white)
 next i
end sub

sub I9341.init
'Global "Constants"
  dim integer I9341_CS=6
  dim integer I9341_CD=4  
  dim integer I9341_RESET=5
  'dim integer T_IRQ=10           '2
  'dim integer T_CS=9             '7  
  dim integer T_IRQ=2           '2
  dim integer T_CS=7             '7  
  dim integer LED=15   
  'MX470 Chip  
  'dim integer I9341_CS=14
 ' dim integer I9341_CD=16
  'dim integer I9341_RESET=11
  'dim integer T_IRQ=64
  'dim integer T_CS=60 
  const ILI9341_SOFTRESET          =&H01
  Const ILI9341_SLEEPIN            =&H10
  Const ILI9341_SLEEPOUT           =&H11
  Const ILI9341_NORMALDISP         =&H13
  Const ILI9341_INVERTOFF          =&H20
  Const ILI9341_INVERTON           =&H21
  Const ILI9341_GAMMASET           =&H26
  Const ILI9341_DISPLAYOFF         =&H28
  Const ILI9341_DISPLAYON          =&H29
  Const ILI9341_COLADDRSET         =&H2A
  Const ILI9341_PAGEADDRSET        =&H2B
  Const ILI9341_MEMORYWRITE        =&H2C
  Const ILI9341_PIXELFORMAT        =&H3A
  Const ILI9341_FRAMECONTROL       =&HB1
  Const ILI9341_DISPLAYFUNC        =&HB6
  Const ILI9341_ENTRYMODE          =&HB7
  Const ILI9341_POWERCONTROL1      =&HC0
  Const ILI9341_POWERCONTROL2      =&HC1
  Const ILI9341_VCOMCONTROL1      =&HC5
  Const ILI9341_VCOMCONTROL2      =&HC7
  DIM integer ILI9341_MEMCONTROL  =&H36
  DIM integer  ILI9341_MADCTL_MY  =&H80
  DIM integer  ILI9341_MADCTL_MX  =&H40
  DIM integer  ILI9341_MADCTL_MV  =&H20
  DIM integer  ILI9341_MADCTL_ML  =&H10
  DIM integer  ILI9341_MADCTL_RGB =&H00
  DIM integer  ILI9341_MADCTL_BGR =&H08
  DIM integer  ILI9341_MADCTL_MH  =&H04
'  
  dim integer BLACK = &H0000 ' Color definitions: 16 bit (RGB565) colour palette so these are just examples
  dim integer BLUE  = &H001F
  dim integer RED   = &HF800
  dim integer GREEN = &H07E0
  dim integer CYAN  = &H07FF
  dim integer MAGENTA=&HF81F
  dim integer YELLOW= &HFFE0 
  dim integer WHITE = &HFFFF
  dim integer I9341.pix=0
  dim integer I9341.ffr=1
  dim integer I9341.drawline=3
  dim integer I9341.wcom=4
  dim integer I9341.wdata=5
  dim integer I9341.fastfillscreen=6
  dim integer I9341.fpstring=7
  dim integer I9341.fcirch=8
  dim integer I9341.dcirch=9
  dim integer I9341.drawgraph=10         'additional function
  dim integer I9341_normal=0
  dim integer I9341_inverse=1
  dim integer I9341_rt_right=2
  dim integer I9341_rt_left=3
  dim integer I9341_AddrOfFont, I9341_params(6) ' Global variables
  DIM integer I9341_wi=0,I9341_ht=1,I9341_rot=2,I9341_nr=3,I9341_X=4,I9341_Y=5,I9341_seed=6  
  local integer i
  'spi open 12000000,3,8   '48Mhz Clock
  spi open   2500000,3,8   '10MHz Clock
  I9341_Params(I9341_wi)=240
  I9341_params(I9341_ht)=320
  I9341_AddrOfFont=PEEK(CFunAddr FONT)  
  setpin T_IRQ,din,pullup
  pin(T_CS)=1
  setpin T_CS,dOUT
  pin(I9341_CS)=1
  setpin I9341_CS, DOUT
  pin(I9341_CD)=1
  setpin I9341_CD, DOUT
  pin(I9341_RESET)=1
  setpin I9341_RESET, DOUT'  Reset the display
  pin(I9341_RESET)=0
  pause 100
  pin(I9341_RESET)=1
  pause 100
  i=I9341draw(I9341.wcom,ILI9341_SOFTRESET)'software reset
  pause 150
  i=I9341draw(I9341.wcom,ILI9341_DISPLAYOFF)
  i=I9341draw(I9341.wcom,ILI9341_POWERCONTROL1)
  i=I9341draw(I9341.wdata,&H23)
  i=I9341draw(I9341.wcom,ILI9341_POWERCONTROL2)
  i=I9341draw(I9341.wdata,&H10)
  i=I9341draw(I9341.wcom,ILI9341_VCOMCONTROL1)
  i=I9341draw(I9341.wdata,&H2B)
  i=I9341draw(I9341.wdata,&H2B)
  i=I9341draw(I9341.wcom,ILI9341_VCOMCONTROL2)
  i=I9341draw(I9341.wdata,&HC0)
  i=I9341draw(I9341.wcom,ILI9341_MEMCONTROL)
  i=I9341draw(I9341.wdata,(ILI9341_MADCTL_MX OR ILI9341_MADCTL_BGR))
  i=I9341draw(I9341.wcom,ILI9341_PIXELFORMAT)
  i=I9341draw(I9341.wdata,&H55)
  i=I9341draw(I9341.wcom,ILI9341_FRAMECONTROL)
  i=I9341draw(I9341.wdata,&H00)
  i=I9341draw(I9341.wdata,&H1B)
  i=I9341draw(I9341.wcom,ILI9341_ENTRYMODE)
  i=I9341draw(I9341.wdata,&H07)
  i=I9341draw(I9341.wcom,ILI9341_SLEEPOUT)
  i=I9341draw(I9341.wdata,0)
  pause 150
  i=I9341draw(I9341.wcom,ILI9341_NORMALDISP)
  i=I9341draw(I9341.wcom,ILI9341_DISPLAYON)
  pause 500
  I9341.setrot(I9341_normal)
  i=I9341draw(I9341.wcom,ILI9341_COLADDRSET)
  i=I9341draw(I9341.wdata,0)
  i=I9341draw(I9341.wdata,0)
  i=I9341draw(I9341.wdata,0)
  i=I9341draw(I9341.wdata,239)
  i=I9341draw(I9341.wcom,ILI9341_PAGEADDRSET)
  i=I9341draw(I9341.wdata,0)
  i=I9341draw(I9341.wdata,0)
  i=I9341draw(I9341.wdata,1)
  i=I9341draw(I9341.wdata,63)
  I9341.fillscreen(black)
  i=T.Getdata(&HA0) 'wake up the touch controller
end sub
'
sub I9341.setrot(x%) 'sets screen rotation: 0=I9341_normal, 1=invert, 2=rotate right, 3-rotate left
   local integer i=x% \ 2 '0 for portrait, 1 for landscape
   local integer j=I9341_params(I9341_rot)\2 
   I9341_params(I9341_rot)=(x% and 3)
   if i<>j then 'swap height and width if landscape
     local integer k=I9341_params(I9341_wi)
     I9341_params(I9341_wi)=I9341_params(I9341_ht)
     I9341_params(I9341_ht)=k
   endif  
   on I9341_params(I9341_rot)+1 goto rnor,rinv,rrr,rrl
   rnor:
     i=I9341draw(I9341.wcom,ILI9341_MEMCONTROL)
     i=I9341draw(I9341.wdata, ILI9341_MADCTL_MX OR ILI9341_MADCTL_BGR)
     exit sub
   rinv:
     i=I9341draw(I9341.wcom,ILI9341_MEMCONTROL)
     i=I9341draw(I9341.wdata, ILI9341_MADCTL_MY OR ILI9341_MADCTL_BGR)
     exit sub
   rrr:
     i=I9341draw(I9341.wcom,ILI9341_MEMCONTROL)
     i=I9341draw(I9341.wdata, ILI9341_MADCTL_MV OR ILI9341_MADCTL_BGR)
     exit sub
   rrl:
     i=I9341draw(I9341.wcom,ILI9341_MEMCONTROL)
     i=I9341draw(I9341.wdata, ILI9341_MADCTL_MY OR ILI9341_MADCTL_MX OR ILI9341_MADCTL_MV OR ILI9341_MADCTL_BGR)
end sub
'
function T.Getdata(command as integer) as integer 'get data from the touch controller
  local integer i,j,k
  poke word &HBF805830,&H17 'slow down the SPI
  pin(T_CS)=0
  i=spi(command)
  j=spi(0)
 ' k=spi(0)
  pin(T_CS)=1
 ' T.Getdata= (j*256+k)>>4
  T.Getdata= j     'dont use second byte
  poke word &HBF805830,1 'SPI back to full speed
end function
'
function T.getxy(x as integer, y as integer, timeout as integer) as integer
  timer=0
  do while timer<timeout and pin(T_IRQ)=1:loop
  if timer>=timeout then
    T.getxy=0
  else
    y=T.getdata(&H90)         ' Set B(3)=1 for 8 bit resolution ADC
    x=T.getdata(&HD0)         ' Set B(3)=1 for 8 bit resolution ADC
    T.getxy=1
  endif
end function


sub I9341.fillscreen(scol as integer)
  local integer i=I9341_params(I9341_rot)
  I9341_params(I9341_rot)=I9341_normal
  local integer j=I9341draw(I9341.ffr,scol, 0,0,I9341_params(I9341_wi),I9341_params(I9341_ht), I9341_params())
  I9341_params(I9341_rot)=i
end sub
'
sub I9341.dcirc(x0 as integer, y0 as integer, r as integer, colour as integer) 'x, y coordinates of centre, radius
  local integer i=I9341draw(I9341.dcirch, colour,x0,y0,r,31,I9341_params())

end sub
 '
sub I9341.dtri(x0 as integer, y0 as integer, x1 as integer, y1 as integer, x2 as integer, y2 as integer, colour as integer) 'three coordinate pairs
  I9341.dline(x0, y0, x1, y1, colour)
  I9341.dline(x1, y1, x2, y2, colour)
  I9341.dline(x2, y2, x0, y0, colour)
end sub
 '
sub I9341.ftri (x0 as integer, y0 as integer, x1 as integer, y1 as integer, x2 as integer, y2 as integer, colour as integer) 'three coordinate pairs
  local integer a, b, y, dp, last
  if (y0>y1) then
    swap(y0, y1)
    swap(x0, x1)
  endif
  if (y1>y2) then
    swap(y2, y1)
    swap(x2, x1)
  endif
  if (y0>y1) then
    swap(y0, y1)
    swap(x0, x1)
  endif
  if(y0=y2) then ' Handle awkward all-on-same-line case as its own thing
    a=x0
    b=x0
    if(x1<a) then
  a=x1
    else
  if(x1>b) then b=x1
    endif
    if(x2<a) then
  a=x2
    else
  if(x2>b) then b=x2
    endif
    dp=I9341draw(I9341.ffr, colour, a, y0, 1, b-a+1,  I9341_params()) 
    exit sub
  endif
    local integer  dx01=x1-x0,  dy01=y1-y0,  dx02=x2-x0,  dy02=y2-y0, dx12=x2-x1,  dy12=y2-y1,  sa=0, sb=0
  if(y1=y2) then
    last=y1 'Include y1 scanline
  else
     last=y1-1 ' Skip it
  endif
  for y=y0 to last
    a=x0+sa \ dy01
    b=x0+sb \ dy02
    sa=sa+dx01
    sb=sb+dx02
    a=x0+(x1-x0) * (y-y0) \ (y1-y0)
    b=x0+(x2-x0) * (y-y0) \ (y2-y0)
    if(a>b) then swap(a, b)
    dp=I9341draw(I9341.ffr, colour, a, y, b-a+1, 1,  I9341_params()) 
  next y
  sa=dx12 * (y-y1)
  sb=dx02 * (y-y0)
  do while y<=y2
    a=x1+sa \ dy12
    b=x0+sb \ dy02
    sa=sa+dx12
    sb=sb+dx02
    a=x1+(x2-x1) * (y-y1) \ (y2-y1)
    b=x0+(x2-x0) * (y-y0) \ (y2-y0)
    if(a>b) then swap(a, b)
    dp=I9341draw(I9341.ffr, colour, a, y, b-a+1, 1,  I9341_params()) 
    y=y+1
  loop
end sub
'
sub I9341.pstring(xx0 as integer, yy0 as integer, text$, sz as integer, orientation as integer, fontcolour as integer, backgroundcolour as integer) 'x, y coordinates of top left of first character, text string, size, orientation
  local integer i=I9341draw(I9341.fpstring,I9341_AddrOfFont,xx0,yy0,sz,orientation,fontcolour,backgroundcolour,I9341_params(),text$)
end sub
'
sub I9341.dline(xx0 as integer, yy0 as integer, xx1 as integer, yy1 as integer, colour as integer) ' x, y of start line, x, y of end line
   local integer dp=I9341draw(I9341.drawline, colour, xx0, yy0, xx1, yy1,  I9341_params())
end sub
 '
sub I9341.dgraph(values as integer, offset as integer, screen as integer,gparams as integer) ' values is address of new values, offset is position in array,screenarray
   local integer dp=I9341draw(I9341.drawgraph, values,offset,screen(),gparams, I9341_params())
end sub 
 
sub swap (a% , b% )
  local  t%
  t%=b%
  b%=a%
  a%=t%
end sub
 '
sub I9341.drect(x as integer, y as integer, w as integer, h as integer, rcolour as integer) 'x, y coordinate of top left, wi, ht
  local integer a, dp
  dp=I9341draw(I9341.ffr, rcolour, x, y, w, 1,  I9341_params()) 
  a=y+h-1
  dp=I9341draw(I9341.ffr, rcolour, x, a, w, 1,  I9341_params()) 
  dp=I9341draw(I9341.ffr, rcolour, x, y, 1, h,  I9341_params()) 
  a=x+w-1
  dp=I9341draw(I9341.ffr, rcolour, a, y, 1, h,  I9341_params()) 
end sub
'
sub I9341.frect(x as integer, y as integer, w as integer, h as integer, rcolour as integer) 'x, y coordinate of top left, width, height
  local integer dp
  dp=I9341draw(I9341.ffr, rcolour, x, y, w, h,  I9341_params()) 
end sub
'
FUNCTION I9341.Getchar(char as integer) as integer
  local integer i=char<<3
  I9341.Getchar=PEEK(WORD I9341_AddrOfFont+i)+(PEEK(WORD I9341_AddrOfFont+i+4)<<32) 
END FUNCTION
'
sub I9341.fcirc(x0 as integer, y0 as integer, r as integer, ccolour as integer)  'x, y coordinates of centre, radius
  local integer dp
  dp=I9341draw(I9341.ffr, ccolour, x0, y0-r, 1, 2*r+1,  I9341_params())
  dp=I9341draw(I9341.fcircH,x0, y0, r, 3, 0, ccolour, I9341_params())
end sub
 '
sub I9341.drndrect(x as integer, y as integer, w as integer, h as integer, r as integer, rcolour as integer) 'x, y coordinates of top left, width, height, radius of corner
  local integer dp
  dp=I9341draw(I9341.ffr, rcolour, x+r, y, w-2*r, 1,  I9341_params()) 
  dp=I9341draw(I9341.ffr, rcolour, x+r, y+h-1, w-2*r, 1,  I9341_params()) 
  dp=I9341draw(I9341.ffr, rcolour, x, y+r, 1, h-2*r,  I9341_params()) 
  dp=I9341draw(I9341.ffr, rcolour, x+w-1, y+r, 1, h-2*r,  I9341_params()) 
  dp=I9341draw(I9341.dcirch, rcolour, x+r, y+r, r, 1,I9341_params())
  dp=I9341draw(I9341.dcirch,  rcolour, x+w-r-1, y+r, r, 2,I9341_params())
  dp=I9341draw(I9341.dcirch,  rcolour, x+w-r-1, y+h-r-1, r, 4,I9341_params())
  dp=I9341draw(I9341.dcirch,  rcolour, x+r, y+h-r-1, r, 8,I9341_params())
end sub
'
sub I9341.frndrect(x as integer, y as integer, w as integer, h as integer, r as integer, colour as integer) 'x, y coordinates of top left, width, height, radius of corner
  local integer dp
  dp=I9341draw(I9341.ffr, colour, x+r, y, w-2*r, h,  I9341_params()) 
  dp=I9341draw(I9341.fcircH,x+w-r-1, y+r, r, 1, h-2*r-1, colour, I9341_params())
  dp=I9341draw(I9341.fcircH,x+r, y+r, r, 2, h-2*r-1, colour, I9341_params())
end sub

'*************************************************************************************
'
' Peter Mather
'
' 1.2
' 2015-19-1
'
' Graphics library with drivers for SSD1289 display with XPT2046 touch controller
'
' drawing primitives assume a graphics display where top left is point 0, 0
'
' set screen orientation: sub I9341.setrot(x) ;T32_normal=normal, T32_inverse=invert, T32_rt_right=rotate right, T32_rt_left=rotate left
' draw circle: sub I9341.dcirc(x0, y0, r, colour) ;x, y coordinates of centre, radius, colour
' draw filled circle: sub I9341.fcirc(x0, y0, r, colour) ;x, y coordinates of centre, radius, colour
' draw triangle:  sub I9341.dtri(x0, y0, x1, y1, 	x2, y2, colour) ;three coordinate pairs, colour
' draw filled triangle sub I9341.ftri (x0, y0, x1, y1, x2, y2, colour) ;three coordinate pairs, colour
' print string: sub I9341.pstring(xx0, yy0, text$, sz, orientation, forecolour, backcolour) ;x, y coordinates of top left of first character, text string, size, character orientation,  foreground colour,  background colour
' print 8x5 bitmap: sub I9341.pbitmap(xx0, yy0, char, sz, orientation, forecolour, backcolour) ;x, y coordinates of top left of first character, bitmap, size, character orientation,  foreground colour,  background colour
' draw line: sub I9341.dline(xx0, yy0, xx1, yy1, colour) ;x, y of start line, x, y of end line, colour
' draw rectangle: sub I9341.drect(x, y, w, h, colour) ;x, y coordinate of top left, width, height, colour
' draw filled rectangle: sub I9341.frect(x, y, w, h, colour) ;x, y coordinate of top left, width, height, colour
' draw rounded rectangle: sub I9341.drndrect(x, y, w, h, r, colour) ;x, y coordinates of top left, width, height, radius of corner, colour
' draw filled rounded rectangle: sub I9341.frndrect(x, y, w, h, r, colour) ;x, y coordinates of top left, width, height, radius of corner, colour
' set pixel : I9341.dpix(x,y,colour)

'Modified to use 8 bit resolution by setting B(3) in commands.
'Allows faster SPI and less data bits.
'
' specific routines
'
'sub I9341.initdisplay
''Global "Constants"
'  dim integer T32_CS=4 'b0
'  dim integer T32_CD=5 'b1
'  dim integer T32_WR=6 'b2
'  dim integer LT_latch=7 'b3 connect to pin 12 on both 74HC595
'  DIM integer Master_reset=15 ' connect to reset pins on display and both 74HC595 (pin 10)
'' SPI Clock - connect to pin 11 on both 74HC595
'' SPI Out - connect to pin 14 on first 74HC595 which is connected to B(0-7) on display
'' connect pin 14 on second 74HC595 to pin 9 on first (This one connects to B(-15) on display
'' connect pin 13 on both 74HC595 to GND
'' Tie display RD pin high
'  dim integer BLACK = &H0000 ' Color definitions: 16 bit (RGB565) colour palette so these are just examples
'  dim integer BLUE  = &H001F
'  dim integer RED   = &HF800
'  dim integer GREEN = &H07E0
'  dim integer CYAN  = &H07FF
'  dim integer MAGENTA=&HF81F
'  dim integer YELLOW= &HFFE0
'  dim integer WHITE = &HFFFF
'  dim integer I9341.pix=0
'  dim integer I9341.ffr=1
'  dim integer I9341.filltri=2
'  dim integer I9341.drawline=3
'  dim integer I9341.writecommand=4
'  dim integer I9341.writedata=5
'  dim integer I9341.fpstring=7
'  dim integer I9341.fcirch=8
'  dim integer I9341.dcirch=9
'  dim integer T32_normal=0
'  dim integer T32_inverse=1
'  dim integer T32_rt_right=2
'  dim integer T32_rt_left=3
'  ' Global variables
'  dim integer T32_AddrOfFont,   T32_params(6) ' Global variables
'  DIM integer T32_wi=0,T32_ht=1,T32_rot=2,T32_nr=3,T32_X=4,T32_Y=5,T32_seed=6
'  T32_AddrOfFont=PEEK(CFunAddr FONT)
'  local integer i,j,k
'  T32_params(T32_wi)=240
'  T32_params(T32_ht)=320
'  pin(LT_latch)=0
'  setpin LT_latch,dout
'  pin(T32_CS)=1
'  setpin T32_CS, DOUT
'  pin(T32_CD)=1
'  setpin T32_CD, DOUT
'  pin(T32_WR)=1
'  setpin T32_WR, DOUT
'  pin(Master_RESET)=1
'  setpin Master_RESET, DOUT'  Resets the display and the 74HC595s
'  pin(Master_RESET)=0
'  pause 100
'  pin(Master_RESET)=1
'  pause 100
'  spi open 1000000,3,16  '16 bits talking to dual shift registers
'  dim integer T_IRQ=10
'  dim integer T_CS=9
'  pin(T_CS)=1
'  setpin T_CS,dOUT
'  'setpin T_IRQ,din,pullup
'  i=T.Getdata(&HA0) 'wake up the controller
' 	I9341.wreg(&H00,&H0001)
'	I9341.wreg(&H03,&HA8A4)
'	I9341.wreg(&H0C,&H0000)
'	I9341.wreg(&H0D,&H080C)
'	I9341.wreg(&H0E,&H2B00)
'	I9341.wreg(&H1E,&H00B7)
'	I9341.wreg(&H01,&H2B3F)
'	I9341.wreg(&H02,&H0600)
'	I9341.wreg(&H10,&H0000)
'	I9341.wreg(&H11,&H6070)
'	I9341.wreg(&H05,&H0000)
'	I9341.wreg(&H06,&H0000)
'	I9341.wreg(&H16,&HEF1C)
'	I9341.wreg(&H17,&H0003)
'	I9341.wreg(&H07,&H0233)
'	I9341.wreg(&H0B,&H0000)
'	I9341.wreg(&H0F,&H0000)
'	I9341.wreg(&H41,&H0000)
'	I9341.wreg(&H42,&H0000)
'	I9341.wreg(&H48,&H0000)
'	I9341.wreg(&H49,&H013F)
'	I9341.wreg(&H4A,&H0000)
'	I9341.wreg(&H4B,&H0000)
'	I9341.wreg(&H44,&HEF00)
'	I9341.wreg(&H45,&H0000)
'	I9341.wreg(&H46,&H013F)
'	I9341.wreg(&H30,&H0707)
'	I9341.wreg(&H31,&H0204)
'	I9341.wreg(&H32,&H0204)
'	I9341.wreg(&H33,&H0502)
'	I9341.wreg(&H34,&H0507)
'	I9341.wreg(&H35,&H0204)
'	I9341.wreg(&H36,&H0204)
'	I9341.wreg(&H37,&H0502)
'	I9341.wreg(&H3A,&H0302)
'	I9341.wreg(&H3B,&H0302)
'	I9341.wreg(&H23,&H0000)
'	I9341.wreg(&H24,&H0000)
'	I9341.wreg(&H25,&H8000)
'	I9341.wreg(&H4f,&H0000)
'	I9341.wreg(&H4e,&H0000)
'  pause 50
'  i=T32draw(I9341.writecommand, &H22)
'  I9341.setrot(T32_normal)
'end sub
''
'sub I9341.wreg(register as integer, databyte as integer)
'  local integer i
'  i=T32draw(I9341.writecommand, register)
'  i=T32draw(I9341.writedata, databyte)
'end sub
''
'sub I9341.fillscreen(scol as integer)
'  local integer i=T32_params(T32_rot)
'  T32_params(T32_rot)=0
'  local integer j=T32draw(I9341.ffr,scol, 0,0,T32_params(T32_wi),T32_params(T32_ht), T32_params())
'  T32_params(T32_rot)=i
'end sub
'
'function T.Getdata(command as integer) as integer 'get data from the touch controller 'DEBUG
'  local integer i,j,k 'DEBUG
'  poke word &HBF805800,&H8060 '8-bit 'DEBUG
  'poke word &HBF805830,&H17 'slow down the SPI not needed for 8 bit resolution ADC
'  pin(T_CS)=0 'DEBUG
'  i=spi(command) 'DEBUG
'  j=spi(0)   'only 8 bits returned 'DEBUG
  'k=spi(0)
'  pin(T_CS)=1 'DEBUG
  'T.Getdata= (j*256+k)>>4
'  T.Getdata= j 'DEBUG
  'poke word &HBF805830,1 'SPI back to full speed - not needed
'  poke word &HBF805800,&H8460 '16-bit 'DEBUG
'end function 'DEBUG
'
'function T.getxy(x as integer, y as integer, timeout as integer) as integer 'DEBUG
  'We are interupt driven so dont need the timeout
    'timer=0
 ' do while timer<timeout and pin(T_IRQ)=1:loop
  'if timer>=timeout then
 '   T.getxy=0
 ' else
'    y=T.getdata(&H98)   'B(3)=1 for 8 bit resolution ADC 'DEBUG
'    x=T.getdata(&HD8)   'B(3)=1 for 8 bit resolution ADC 'DEBUG
'    T.getxy=1 'DEBUG
  'endif
'end function 'DEBUG
'
'
' Generic drawing routines
'
'
'sub I9341.dpix(xx0 as integer, yy0 as integer,  colour as integer) ' x, y of start line, x, y of end line
'   local integer dp=T32draw(I9341.pix, colour, xx0, yy0,  T32_params())
'end sub
'
'sub I9341.dcirc(x0 as integer, y0 as integer, r as integer, colour as integer) 'x, y coordinates of centre, radius
'  local integer i=T32draw(I9341.dcirch, colour,x0,y0,r,31,T32_params())
'
'end sub
' '
'sub I9341.dtri(x0 as integer, y0 as integer, x1 as integer, y1 as integer, x2 as integer, y2 as integer, colour as integer) 'three coordinate pairs
'  I9341.dline(x0, y0, x1, y1, colour)
'  I9341.dline(x1, y1, x2, y2, colour)
'  I9341.dline(x2, y2, x0, y0, colour)
'end sub
' '
'sub I9341.ftri(x0 as integer, y0 as integer, x1 as integer, y1 as integer, x2 as integer, y2 as integer, colour as integer) 'three coordinate pairs
'  local integer i=T32draw(I9341.filltri, x0,y0,x1,y1,x2,y2,colour,T32_params())
'end sub
''
'sub I9341.pstring(xx0 as integer, yy0 as integer, text$, sz as integer, orientation as integer, fontcolour as integer, backgroundcolour as integer) 'x, y coordinates of top left of first character, text string, size, orientation
'  local integer i=T32draw(I9341.fpstring,T32_AddrOfFont,xx0,yy0,sz,orientation,fontcolour,backgroundcolour,T32_params(),text$)
'end sub
''
'sub I9341.pbitmap(xx0 as integer, yy0 as integer, char as integer, sz as integer, orientation as integer, fontcolour as integer, backgroundcolour as integer) 'x, y coordinates of top left of first character, text string, size, orientation
'  local integer i=T32draw(I9341.fpstring,char,xx0,yy0,sz,orientation,fontcolour,backgroundcolour,T32_params(),"")
'end sub
''
'sub I9341.dline(xx0 as integer, yy0 as integer, xx1 as integer, yy1 as integer, colour as integer) ' x, y of start line, x, y of end line
'   local integer dp=T32draw(I9341.drawline, colour, xx0, yy0, xx1, yy1,  T32_params())
'end sub
' '
'sub swap (a% , b% )
'  local  t%
'  t%=b%
'  b%=a%
'  a%=t%
'end sub
' '
'sub I9341.drect(x as integer, y as integer, w as integer, h as integer, rcolour as integer) 'x, y coordinate of top left, wi, ht
'  local integer a, dp
'  dp=T32draw(I9341.ffr, rcolour, x, y, w, 1,  T32_params())
'  a=y+h-1
'  dp=T32draw(I9341.ffr, rcolour, x, a, w, 1,  T32_params())
'  dp=T32draw(I9341.ffr, rcolour, x, y, 1, h,  T32_params())
'  a=x+w-1
'  dp=T32draw(I9341.ffr, rcolour, a, y, 1, h,  T32_params())
'end sub
''
'sub I9341.frect(x as integer, y as integer, w as integer, h as integer, rcolour as integer) 'x, y coordinate of top left, width, height
'  local integer dp
'  dp=T32draw(I9341.ffr, rcolour, x, y, w, h,  T32_params())
'end sub
''
'FUNCTION I9341.Getchar(char as integer) as integer
'  local integer i=char<<3
'  I9341.Getchar=PEEK(WORD T32_AddrOfFont+i)+(PEEK(WORD T32_AddrOfFont+i+4)<<32)
'END FUNCTION
''
'sub I9341.fcirc(x0 as integer, y0 as integer, r as integer, ccolour as integer)  'x, y coordinates of centre, radius
'  local integer dp
'  dp=T32draw(I9341.ffr, ccolour, x0, y0-r, 1, 2*r+1,  T32_params())
'  dp=T32draw(I9341.fcircH,x0, y0, r, 3, 0, ccolour, T32_params())
'end sub
' '
'sub I9341.drndrect(x as integer, y as integer, w as integer, h as integer, r as integer, rcolour as integer) 'x, y coordinates of top left, width, height, radius of corner
'  local integer dp
'  dp=T32draw(I9341.ffr, rcolour, x+r, y, w-2*r, 1,  T32_params())
'  dp=T32draw(I9341.ffr, rcolour, x+r, y+h-1, w-2*r, 1,  T32_params())
'  dp=T32draw(I9341.ffr, rcolour, x, y+r, 1, h-2*r,  T32_params())
'  dp=T32draw(I9341.ffr, rcolour, x+w-1, y+r, 1, h-2*r,  T32_params())
'  dp=T32draw(I9341.dcirch, rcolour, x+r, y+r, r, 1,T32_params())
'  dp=T32draw(I9341.dcirch,  rcolour, x+w-r-1, y+r, r, 2,T32_params())
'  dp=T32draw(I9341.dcirch,  rcolour, x+w-r-1, y+h-r-1, r, 4,T32_params())
'  dp=T32draw(I9341.dcirch,  rcolour, x+r, y+h-r-1, r, 8,T32_params())
'end sub
''
'sub I9341.frndrect(x as integer, y as integer, w as integer, h as integer, r as integer, colour as integer) 'x, y coordinates of top left, width, height, radius of corner
'  local integer dp
'  dp=T32draw(I9341.ffr, colour, x+r, y, w-2*r, h,  T32_params())
'  dp=T32draw(I9341.fcircH,x+w-r-1, y+r, r, 1, h-2*r-1, colour, T32_params())
'  dp=T32draw(I9341.fcircH,x+r, y+r, r, 2, h-2*r-1, colour, T32_params())
'end sub
' '
'sub I9341.setrot(x%) 'sets screen rotation: 0=T32_normal, 1=invert, 2=rotate right, 3-rotate left
'   T32_params(T32_rot)=(x% and 3)
'end sub
'
'D:\Peter\MPLABXProjects\TFT32\dist\default\production\T32draw.bas

'
'C:\Users\gallardice\MPLABXProjects\TFTILI9431SPI.X\dist\default\production\I9341draw.bas

'
'I9341draw  2015-03-22 23:54:49 CFuncGen Ver 1.0.21 by user=gallardice
'
'
'C:\Users\gallardice\MPLABXProjects\TFTILI9431SPI.X\dist\default\production\I9341draw.bas

'
'I9341draw  2015-03-24 20:23:32 CFuncGen Ver 1.0.21 by user=gallardice
'
CFunction I9341draw
'writeCommand
	000007AD
	3c02bf88 24030004 ac436134 24030001 ac436134 3c02bf80 ac445820 3c03bf80 
	8c625810 30420080 1040fffd 3c02bf88 24030004 ac436138 3c02bf80 8c425820 
	03e00008 00000000 

'writeData
3c02bf88 24030004 ac436134 24030001 ac436138 3c02bf80 
	ac445820 3c03bf80 8c625810 30420080 1040fffd 3c02bf88 24030004 ac436138 
	3c02bf80 8c425820 03e00008 00000000 

'setpos
27bdffd8 afbf0024 afb30020 afb2001c 
	afb10018 afb00014 00808821 00a09021 00c09821 00e08021 2404002a 00002821 
	0411FFCF 00000000 7e243a00 00002821 0411FFDD 00000000 322400ff 00002821 
	0411FFD9 00000000 7e443a00 00002821 0411FFD5 00000000 324400ff 00002821 
	0411FFD1 00000000 2404002b 00002821 0411FFBB 00000000 7e643a00 00002821 
	0411FFC9 00000000 326400ff 00002821 0411FFC5 00000000 7e043a00 00002821 
	0411FFC1 00000000 320400ff 00002821 0411FFBD 00000000 2404002c 00002821 
	0411FFA7 00000000 8fbf0024 8fb30020 8fb2001c 8fb10018 8fb00014 03e00008 
	27bd0028 

'localfastfillrect
27bdffd8 afbf0024 afb30020 afb2001c afb10018 afb00014 8fa30038 
	8fa70048 8fa20050 8c480000 8c490008 7c913a00 309000ff 00c02021 00601021 
	24caffff 8fa50040 04c10004 01452821 24c60002 00a62821 00002021 00a8302a 
	50c00001 2505ffff 2466ffff 04410004 00c73821 24630002 00e33821 00001021 
	00e9182a 50600001 2527ffff 04a2002d 00002021 04e0002d 0088402a 1100002e 
	0049482a 5120002f 00002021 24120001 02441823 00651821 02429823 02679821 
	72639802 00403021 0411FF91 00000000 3c02bf88 ac526138 24030004 ac436134 
	12600012 3c02bf80 2664ffff ac515820 8c435810 30630080 1060fffd 00000000 
	8c435820 ac505820 8c435810 30630080 1060fffd 00000000 8c435820 10800004 
	24030004 1000fff1 2484ffff 24030004 3c02bf88 ac436138 02602021 1000000a 
	00002821 10000008 00002821 00002021 10000005 00002821 00002021 10000002 
	00002821 00002821 00801021 00a01821 8fbf0024 8fb30020 8fb2001c 8fb10018 
	8fb00014 03e00008 27bd0028 

'colourrect
27bdffe0 afbf001c afb20018 afb10014 afb00010 
	00808021 8fa30030 8fa70040 8fa20048 8c480000 8c490008 00c02021 00601021 
	24caffff 8fa50038 04c10004 01452821 24c60002 00a62821 00002021 00a8302a 
	50c00001 2505ffff 2466ffff 04410004 00c73821 24630002 00e33821 00001021 
	00e9182a 50600001 2527ffff 04a20035 00002021 04e00035 0088402a 11000036 
	0049482a 51200037 00002021 24120001 02441823 00651821 02428823 02278821 
	72238802 00403021 0411FF31 00000000 3c02bf88 ac526138 24030004 ac436134 
	12200019 3c07bf88 00002021 24060004 3c02bf80 ace66134 02002821 92030001 
	ac435820 8c435810 30630080 1060fffd 00000000 8c435820 90a30000 ac435820 
	8c435810 30630080 1060fffd 00000000 8c435820 24840001 1491ffee 26100002 
	10000003 24030004 00008821 24030004 3c02bf88 ac436138 02202021 1000000a 
	00002821 10000008 00002821 00002021 10000005 00002821 00002021 10000002 
	00002821 00002821 00801021 00a01821 8fbf001c 8fb20018 8fb10014 8fb00010 
	03e00008 27bd0020 

'localdrawPixel
27bdffe8 afbf0014 afb00010 00808021 8fa70028 8fa20030 
	8c440004 1c800008 24030001 54800006 00001821 8c440000 00c4202b 14800003 
	306300ff 00001821 306300ff 1060001e 00002021 8c44000c 1c800008 24030001 
	54800006 00001821 8c420008 00e2102b 14400003 306300ff 00001821 306300ff 
	50600011 00002021 00c02021 00c02821 00e03021 0411FED6 00000000 7e043a00 
	00002821 0411FEC0 00000000 320400ff 00002821 0411FEBC 00000000 24040001 
	10000002 00002821 00002821 00801021 00a01821 8fbf0014 8fb00010 03e00008 
	27bd0018 

'drawline
27bdffb8 afbf0044 afbe0040 afb7003c afb60038 afb50034 afb40030 
	afb3002c afb20028 afb10024 afb00020 afa40048 afa5004c 8fa20058 8fa30060 
	8fa40068 8fb60070 00c08021 00409021 00609821 0044282a 10a00003 0080a821 
	10000002 0082a023 0044a023 00c3282a 50a00002 00c32823 00662823 00b4a02a 
	52800006 0270102a 00809821 0060a821 00408021 00c09021 0270102a 10400008 
	0255102a 02401021 02a09021 0040a821 02001021 02608021 00409821 0255102a 
	10400007 0270b823 02b2a823 00178fc2 02378821 00118843 10000006 241e0001 
	0255a823 00178fc2 02378821 00118843 241effff 0270102a 14400020 8fbf0044 
	5280000d afb20010 afb00010 001017c3 afa20014 afb60018 8fa40048 8fa5004c 
	02403021 00123fc3 0411FF7F 00000000 1000000b 02358823 001217c3 afa20014 
	afb60018 8fa40048 8fa5004c 02003021 00103fc3 0411FF74 00000000 02358823 
	06210003 26100001 025e9021 02378821 0270102a 1040ffe2 8fbf0044 8fbe0040 
	8fb7003c 8fb60038 8fb50034 8fb40030 8fb3002c 8fb20028 8fb10024 8fb00020 
	03e00008 27bd0048 

'localdrawPixelPre
27bdffd8 afbf0024 8fa30038 8fa80040 19000026 8faa0048 
	29020014 5040000e 2402001d 00081140 00084040 00484023 afa80010 000847c3 
	afa80014 afaa0018 00603021 00033fc3 0411FF4D 00000000 10000017 00021fc3 
	11020003 afa80010 240200d3 1502000b 000847c3 afa80014 afaa0018 00c02021 
	00e02821 00603021 00033fc3 0411FF3E 00000000 10000008 00021fc3 afa80014 
	afaa0018 00603021 00033fc3 0411FF36 00000000 00021fc3 8fbf0024 03e00008 
	27bd0028 

'drawgraph
27bdff68 afbf0094 afbe0090 afb7008c afb60088 afb50084 afb40080 
	afb3007c afb20078 afb10074 afb00070 afa40098 8fa200ac 8c440008 8c45000c 
	afa40058 afa5005c 8c440010 8c450014 afa40060 afa50064 8c440018 8c45001c 
	afa40068 afa5006c 8c440020 8c450024 afa40038 afa5003c 8c440028 8c45002c 
	afa40040 afa50044 8c440030 8c450034 afa40048 afa5004c 8c440038 8c45003c 
	afa40050 afa50054 afa60028 240500f0 afa50030 0000b821 8fa30028 00031080 
	8fa40098 00821021 8c540000 001710c0 8fa500a8 00a21021 afa2002c 8c420000 
	329000ff 7e913a00 7e923c00 0014a602 305300ff 7c553a00 7c563c00 00021602 
	afa20034 12700023 0040f021 12710021 00000000 1272001f 00000000 1274001d 
	2662ffff 2c420013 50400011 afb30010 00131940 00131040 00621023 afa20010 
	000217c3 afa20014 8fa200b0 afa20018 8fa40060 8fa50064 02e03021 00003821 
	0411FED9 00000000 1000000a 00000000 afa00014 8fa300b0 afa30018 8fa40058 
	8fa5005c 02e03021 00003821 0411FECE 00000000 12b00023 00000000 12b10021 
	00000000 12b2001f 00000000 12b4001d 26a2ffff 2c420013 50400011 afb50010 
	00151940 00151040 00621023 afa20010 000217c3 afa20014 8fa400b0 afa40018 
	8fa40060 8fa50064 02e03021 00003821 0411FEB5 00000000 1000000a 00000000 
	afa00014 8fa500b0 afa50018 8fa40058 8fa5005c 02e03021 00003821 0411FEAA 
	00000000 12d00023 00000000 12d10021 00000000 12d2001f 00000000 12d4001d 
	26c2ffff 2c420013 50400011 afb60010 00161940 00161040 00621023 afa20010 
	000217c3 afa20014 8fa200b0 afa20018 8fa40060 8fa50064 02e03021 00003821 
	0411FE91 00000000 1000000a 00000000 afa00014 8fa300b0 afa30018 8fa40058 
	8fa5005c 02e03021 00003821 0411FE86 00000000 13d00025 00000000 13d10023 
	00000000 13d20021 00000000 13d4001f 8fa40034 2482ffff 2c420013 10400011 
	8fa20034 00041140 00041840 00431023 afa20010 000217c3 afa20014 8fa500b0 
	afa50018 8fa40060 8fa50064 02e03021 00003821 0411FE6C 00000000 1000000b 
	00000000 afa20010 afa00014 8fa300b0 afa30018 8fa40058 8fa5005c 02e03021 
	00003821 0411FE60 00000000 1270001e 00000000 1a00001c 2a020014 50400011 
	afb00010 00101940 00101040 00621023 afa20010 000217c3 afa20014 8fa400b0 
	afa40018 8fa40038 8fa5003c 02e03021 00003821 0411FE4C 00000000 1000000a 
	00000000 afa00014 8fa500b0 afa50018 8fa40038 8fa5003c 02e03021 00003821 
	0411FE41 00000000 12b1001e 00000000 1a20001c 2a220014 50400011 afb10010 
	00111940 00111040 00621023 afa20010 000217c3 afa20014 8fa200b0 afa20018 
	8fa40040 8fa50044 02e03021 00003821 0411FE2D 00000000 1000000a 00000000 
	afa00014 8fa300b0 afa30018 8fa40040 8fa50044 02e03021 00003821 0411FE22 
	00000000 12d2001e 00000000 1a40001c 2a420014 50400011 afb20010 00121940 
	00121040 00621023 afa20010 000217c3 afa20014 8fa400b0 afa40018 8fa40048 
	8fa5004c 02e03021 00003821 0411FE0E 00000000 1000000a 00000000 afa00014 
	8fa500b0 afa50018 8fa40048 8fa5004c 02e03021 00003821 0411FE03 00000000 
	13d4000d 00000000 afb70010 afa00014 afb40018 afa0001c 8fa200b0 afa20020 
	8fa40050 8fa50054 8fa60068 8fa7006c 0411FE95 00000000 16130024 00000000 
	12150005 00000000 12160003 00000000 161e001e 00000000 1a00001c 2a020014 
	50400011 afb00010 00101940 00101040 00621023 afa20010 000217c3 afa20014 
	8fa300b0 afa30018 8fa40038 8fa5003c 02e03021 00003821 0411FDDB 00000000 
	1000000a 00000000 afa00014 8fa400b0 afa40018 8fa40038 8fa5003c 02e03021 
	00003821 0411FDD0 00000000 16350024 00000000 12330005 00000000 12360003 
	00000000 163e001e 00000000 1a20001c 2a220014 50400011 afb10010 00111940 
	00111040 00621023 afa20010 000217c3 afa20014 8fa500b0 afa50018 8fa40040 
	8fa50044 02e03021 00003821 0411FDB6 00000000 1000000a 00000000 afa00014 
	8fa200b0 afa20018 8fa40040 8fa50044 02e03021 00003821 0411FDAB 00000000 
	16560024 00000000 12530005 00000000 12550003 00000000 165e001e 00000000 
	1a40001c 2a420014 50400011 afb20010 00121940 00121040 00621023 afa20010 
	000217c3 afa20014 8fa300b0 afa30018 8fa40048 8fa5004c 02e03021 00003821 
	0411FD91 00000000 1000000a 00000000 afa00014 8fa400b0 afa40018 8fa40048 
	8fa5004c 02e03021 00003821 0411FD86 00000000 569e0025 0014a600 12930005 
	00000000 12950003 00000000 5696001f 0014a600 1a80001c 2a820014 50400011 
	afb40010 00141940 00141040 00621023 afa20010 000217c3 afa20014 8fa500b0 
	afa50018 8fa40050 8fa50054 02e03021 00003821 0411FD6C 00000000 1000000b 
	0014a600 afa00014 8fa200b0 afa20018 8fa40050 8fa50054 02e03021 00003821 
	0411FD61 00000000 0014a600 02908021 00129400 02128021 00118a00 02118821 
	8fa3002c ac710000 00118fc3 ac710004 8fa40028 24840001 2c8205a0 14400003 
	afa40028 2484fa60 afa40028 26f70001 8fa50030 24a5ffff 14a0fe47 afa50030 
	8fbf0094 8fbe0090 8fb7008c 8fb60088 8fb50084 8fb40080 8fb3007c 8fb20078 
	8fb10074 8fb00070 03e00008 27bd0098 

'drawchar
27bdff00 afbf00fc afbe00f8 afb700f4 
	afb600f0 afb500ec afb400e8 afb300e4 afb200e0 afb100dc afb000d8 00c0b821 
	8fb00118 afa40098 afa5009c 8fa4011c 14800063 00e0f021 0200b021 8fa50114 
	afa500a8 afa000b4 afa000b8 27a60097 afa600a0 00108fc3 000717c3 afa200bc 
	00171fc3 afa300c4 afb700ac afa700b0 02009821 1000003d 0220b821 92020000 
	02821024 10400016 00000000 56750004 afbe0010 8fa400ac 10000024 a6440000 
	8fa500a4 afa50014 afb30018 afb7001c afb30020 afb70024 8fa60120 afa60028 
	8fa400ac 8fa500c4 02203021 00113fc3 0411FC3C 00000000 10000015 2610ffff 
	56750004 afbe0010 8fa200b0 1000000f a6420000 8fa300a4 afa30014 afb30018 
	afb7001c afb30020 afb70024 8fa40120 afa40028 8fa400b0 8fa500bc 02203021 
	00113fc3 0411FC27 00000000 2610ffff 02368821 8fa500a0 1605ffd0 26520002 
	8fa600b8 24c60006 afa600b8 8fa200b4 24420001 afa200b4 8fa300a8 00761821 
	24020030 10c2000f afa300a8 24140001 8fa400b4 0094a004 8fbe00a8 001e2fc3 
	afa500a4 27b0009d 8fb10110 8fa600b8 00069040 27a20030 00529021 1000ffb7 
	24150001 8fb700ac 8fbe00b0 02608021 00131040 001318c0 1000007e 00621023 
	24040001 8fa5011c 14a40079 0200b021 8fa60114 24c60001 afa600d4 001010c0 
	00c21023 afa200ac 24020007 afa200b4 afa000b8 8fa30110 24630001 afa300c4 
	00701823 00101080 00501021 00621023 afa200cc 27a4009e afa400a0 00108fc3 
	00072fc3 afa500bc afa700b0 02e0f021 02009821 1000003f 0220b821 92020000 
	02821024 10400016 00000000 16750003 8fa200a4 10000026 a65e0000 afa20010 
	8fa300a8 afa30014 afb30018 afb7001c afb30020 afb70024 8fa40120 afa40028 
	03c02021 8fa500c0 02203021 00113fc3 0411FBCC 00000000 10000016 26100001 
	16750004 8fa600a4 8fa500b0 10000010 a6450000 afa60010 8fa200a8 afa20014 
	afb30018 afb7001c afb30020 afb70024 8fa30120 afa30028 8fa400b0 8fa500bc 
	02203021 00113fc3 0411FBB6 00000000 26100001 02368821 8fa400a0 1604ffcf 
	26520002 8fa500b8 24a50006 afa500b8 8fa600b4 24c6ffff afa600b4 8fa200ac 
	00561021 afa200ac 24020030 50a20014 03c0b821 24140001 8fa300b4 0074a004 
	8fa400ac afa400a4 00042fc3 afa500a8 27b00098 8fa600c4 afa600d0 8fb100cc 
	8fa200b8 00029040 27a30030 00729021 24150001 001e27c3 1000ffb0 afa400c0 
	8fbe00b0 02608021 001318c0 8fa500d4 00a32823 afa50114 00131040 00621023 
	8fa600d0 00c23023 10000075 afa60110 afa000b8 24040002 8fa5011c 14a40072 
	24040003 0200a821 8fa60114 afa600b4 27b4009d 27a20097 afa200a0 8fa300b8 
	afa300bc 8fa40110 24840001 afa400c8 001010c0 00821023 afa200d4 00108fc3 
	001e2fc3 afa500c0 001737c3 afa600c4 afb700ac afbe00b0 02009821 1000003e 
	0220f021 92820000 02021007 30420001 10400017 00000000 16760004 8fa300a4 
	8fa200ac 10000026 a6420000 afa30010 8fa400a8 afa40014 afb30018 afbe001c 
	afb30020 afbe0024 8fa50120 afa50028 8fa400ac 8fa500c4 02203021 00113fc3 
	0411FB50 00000000 10000016 2610ffff 16760004 8fa200a4 8fa600b0 10000010 
	a6460000 afa20010 8fa300a8 afa30014 afb30018 afbe001c afb30020 afbe0024 
	8fa40120 afa40028 8fa400b0 8fa500c0 02203021 00113fc3 0411FB3A 00000000 
	2610ffff 02358821 1617ffce 26520002 8fa500bc 24a50008 afa500bc 8fa600b4 
	00d53021 afa600b4 2694ffff 8fa200a0 52820010 02608021 8fa300b4 afa300a4 
	000327c3 afa400a8 8fa500c8 afa500d0 8fb100d4 8fa600bc 00069040 27a20030 
	00529021 24100007 24160001 1000ffb5 2417ffff 8fa300b8 24630030 afa300b8 
	001318c0 8fa400d0 00832023 afa40110 00601021 00132040 1000006a 00641823 
	24040003 8fa5011c 14a40067 24040001 0200a821 00101840 001010c0 00621023 
	24420001 8fa60114 00c23021 afa60114 afa600b0 27b40098 27a2009e afa200a0 
	8fa300b8 afa300b4 00108fc3 001e27c3 afa400bc 00172fc3 afa500c4 afb700a8 
	afbe00ac 02009821 1000003d 0220b821 92820000 02021007 30420001 10400017 
	24050001 24060001 56660004 afbe0010 8fa200a8 10000024 a6420000 8fa300a4 
	afa30014 afb30018 afb7001c afb30020 afb70024 8fa40120 afa40028 8fa400a8 
	8fa500c4 02203021 00113fc3 0411FADD 00000000 10000015 26100001 56650004 
	afbe0010 8fa600ac 1000000f a6460000 8fa200a4 afa20014 afb30018 afb7001c 
	afb30020 afb70024 8fa30120 afa30028 8fa400ac 8fa500bc 02203021 00113fc3 
	0411FAC8 00000000 26100001 02358821 1616ffcf 26520002 8fa400b4 24840008 
	afa400b4 8fa500b0 00b52821 afa500b0 26940001 8fa600a0 5286000c 02608021 
	8fbe00b0 001e17c3 afa200a4 8fb10110 8fa300b4 00039040 27a40030 00929021 
	00008021 1000ffba 24160008 8fa500b8 24a50030 afa500b8 001310c0 00131840 
	00431823 24040001 16040014 8fa400b8 8fa60114 afa60010 000627c3 afa40014 
	afa20018 000217c3 afa2001c afa30020 00031fc3 afa30024 8fa20120 afa20028 
	27a40030 8fa60110 00063fc3 0411FAF7 00000000 afa200b8 8fa400b8 00041fc3 
	00801021 8fbf00fc 8fbe00f8 8fb700f4 8fb600f0 8fb500ec 8fb400e8 8fb300e4 
	8fb200e0 8fb100dc 8fb000d8 03e00008 27bd0100 

'pstring
27bdffa0 afbf005c afbe0058 
	afb70054 afb60050 afb5004c afb40048 afb30044 afb20040 afb1003c afb00038 
	8fa50078 8fbe0088 8fb50098 8fb4009c 00c09021 8fb30070 8fb10080 8fb60090 
	afa40030 92840000 18800037 00a0b821 00051040 000528c0 00a22823 afa50028 
	00051023 afa2002c 24100001 02901021 90420000 2443ffe0 306300ff 2c630060 
	50600008 00002021 2442ffe0 000210c0 8fa30030 00431021 8c440000 10000002 
	8c450004 00002821 afb20010 afb30014 afb70018 afb1001c afb50020 03c03021 
	02c03821 0411FDDA 00000000 16200004 24040001 8fa40028 1000000a 02449021 
	16240003 8fa4002c 1000000a 02449021 24040002 16240003 8fa40028 10000005 
	02649821 24040003 16240002 8fa4002c 02649821 26100001 92840000 0090202a 
	5080ffd3 02901021 aeb20020 001297c3 aeb20024 aeb30028 00139fc3 aeb3002c 
	8fbf005c 8fbe0058 8fb70054 8fb60050 8fb5004c 8fb40048 8fb30044 8fb20040 
	8fb1003c 8fb00038 03e00008 27bd0060 

'dcirch
27bdffa0 afbf005c afbe0058 afb70054 
	afb60050 afb5004c afb40048 afb30044 afb20040 afb1003c afb00038 afa40060 
	afa50064 00c0b021 8fb50070 8fb00078 8fa20080 8fb70088 afa60024 afb50028 
	afa20020 30420010 1040002a 02008821 000697c3 02151021 afa20010 000217c3 
	afa20014 afb70018 02403821 0411FACE 00000000 02b01023 afa20010 000217c3 
	afa20014 afb70018 8fa40060 8fa50064 02c03021 02403821 0411FAC3 00000000 
	001597c3 02163821 afb50010 afb20014 afb70018 8fa40060 8fa50064 00e03021 
	00073fc3 0411FAB8 00000000 02d03823 afb50010 afb20014 afb70018 8fa40060 
	8fa50064 00e03021 00073fc3 0411FAAE 00000000 1a20008f 24110001 02308823 
	0010f040 001ef023 26b3ffff 26d4ffff 26b50001 26d60001 00009021 8fa20020 
	30420004 afa2002c 8fa30020 30630002 afa30030 8fa20020 30420008 afa20034 
	8fa30020 30630001 afa30020 06200004 8fa2002c 2610ffff 27de0002 023e8821 
	10400019 26520001 8fa30028 02031021 afa20010 000217c3 afa20014 afb70018 
	8fa40060 8fa50064 02c03021 00163fc3 0411FA85 00000000 8fa20024 02023821 
	afb50010 001517c3 afa20014 afb70018 8fa40060 8fa50064 00e03021 00073fc3 
	0411FA79 00000000 8fa30030 1060001a 8fa30034 8fa30028 00701023 afa20010 
	000217c3 afa20014 afb70018 8fa40060 8fa50064 02c03021 00163fc3 0411FA6A 
	00000000 8fa20024 02023821 afb30010 001317c3 afa20014 afb70018 8fa40060 
	8fa50064 00e03021 00073fc3 0411FA5E 00000000 8fa30034 1060001a 8fa20020 
	8fa20024 00503823 afb50010 001517c3 afa20014 afb70018 8fa40060 8fa50064 
	00e03021 00073fc3 0411FA4F 00000000 8fa30028 02031021 afa20010 000217c3 
	afa20014 afb70018 8fa40060 8fa50064 02803021 00143fc3 0411FA43 00000000 
	8fa20020 5040001a 2673ffff 8fa30024 00703823 afb30010 001317c3 afa20014 
	afb70018 8fa40060 8fa50064 00e03021 00073fc3 0411FA34 00000000 8fa30028 
	00701023 afa20010 000217c3 afa20014 afb70018 8fa40060 8fa50064 02803021 
	00143fc3 0411FA28 00000000 2673ffff 2694ffff 26b50001 0250102a 10400005 
	26d60001 00121040 24420001 1000ff87 02228821 8fbf005c 8fbe0058 8fb70054 
	8fb60050 8fb5004c 8fb40048 8fb30044 8fb20040 8fb1003c 8fb00038 03e00008 
	27bd0060 

'fcirch
27bdff90 afbf006c afbe0068 afb70064 afb60060 afb5005c afb40058 
	afb30054 afb20050 afb1004c afb00048 8fb10080 8fb40090 8fbe00a0 afa40038 
	afa6003c 8fa20088 1a200076 02801821 24100001 02118023 0011b840 0017b823 
	2495ffff 24d3ffff 26940003 24960001 00009021 30440001 afa40030 24630001 
	afa30040 30420002 afa20034 06000004 8fa20030 2631ffff 26f70002 02178021 
	1040002a 26520001 8fa3003c 00711023 afa20010 000217c3 afa20014 24020001 
	00001821 afa20018 afa3001c 00111040 8fa30040 00621021 afa20020 000217c3 
	afa20024 afbe0028 8fa40098 8fa5009c 02c03021 00163fc3 0411F90A 00000000 
	8fa40038 02243821 afb30010 001317c3 afa20014 24020001 00001821 afa20018 
	afa3001c afb40020 001417c3 afa20024 afbe0028 8fa40098 8fa5009c 00e03021 
	00073fc3 0411F8F7 00000000 8fa30034 5060002b 26b5ffff 8fa4003c 00911023 
	afa20010 000217c3 afa20014 24020001 00001821 afa20018 afa3001c 00111040 
	8fa30040 00621021 afa20020 000217c3 afa20024 afbe0028 8fa40098 8fa5009c 
	02a03021 00153fc3 0411F8DE 00000000 8fa40038 00913823 afb30010 001317c3 
	afa20014 24020001 00001821 afa20018 afa3001c afb40020 001417c3 afa20024 
	afbe0028 8fa40098 8fa5009c 00e03021 00073fc3 0411F8CB 00000000 26b5ffff 
	2673ffff 26940002 0251102a 10400005 26d60001 00121040 24420001 1000ff9b 
	02028021 8fbf006c 8fbe0068 8fb70064 8fb60060 8fb5005c 8fb40058 8fb30054 
	8fb20050 8fb1004c 8fb00048 03e00008 27bd0070 

'main
27bdffb8 afbf0044 afb00040 
	00808021 00e01021 8fa80058 8faa005c 8fa90060 8c830000 8c870004 00672025 
	1480000e 8fab0064 8ca40000 8ca50004 8cc70004 8cc60000 8c430004 8c420000 
	afa20010 afa30014 afa80018 0411F966 00000000 100000b4 8fbf0044 24040001 
	14640018 24040003 14e00016 00000000 8ca40000 8ca50004 8cc70004 8cc60000 
	8c430004 8c420000 afa20010 afa30014 8d020000 8d030004 afa20018 afa3001c 
	8d420000 8d430004 afa20020 afa30024 afa90028 0411F883 00000000 1000009a 
	8fbf0044 14640019 24040004 14e00017 00000000 8ca40000 8ca50004 8cc70004 
	8cc60000 8c430004 8c420000 afa20010 afa30014 8d020000 8d030004 afa20018 
	afa3001c 8d420000 8d430004 afa20020 afa30024 afa90028 0411F96A 00000000 
	8e020000 1000007f 8e030004 1464000a 24040005 14e00008 00000000 8ca40000 
	8ca50004 0411F7FE 00000000 8e020000 10000074 8e030004 1464000a 24040007 
	14e00008 00000000 8ca40000 8ca50004 0411F805 00000000 8e020000 10000069 
	8e030004 14640021 24040008 14e0001f 00000000 8ca40000 8ca50004 8cc70004 
	8cc60000 8c430004 8c420000 afa20010 afa30014 8d020000 8d030004 afa20018 
	afa3001c 8d420000 8d430004 afa20020 afa30024 8d220000 afa20028 8d620000 
	8d630004 afa20030 afa30034 8fa20068 afa20038 8fa2006c afa2003c 0411FDAD 
	00000000 10000048 8fbf0044 1464001d 24040009 14e0001b 00000000 8ca40000 
	8ca50004 8cc70004 8cc60000 8c430004 8c420000 afa20010 afa30014 8d020000 
	8d030004 afa20018 afa3001c 8d420000 8d430004 afa20020 afa30024 8d220000 
	8d230004 afa20028 afa3002c afab0030 0411FECC 00000000 8e020000 10000029 
	8e030004 14640019 2404000a 14e00017 00000000 8ca40000 8ca50004 8cc70004 
	8cc60000 8c430004 8c420000 afa20010 afa30014 8d020000 8d030004 afa20018 
	afa3001c 8d420000 8d430004 afa20020 afa30024 afa90028 0411FDD5 00000000 
	8e020000 1000000f 8e030004 1464000e 8fbf0044 54e0000d 8fb00040 8ca40000 
	8cc70004 8cc60000 afa20010 afa80014 afaa0018 0411F983 00000000 8e020000 
	8e030004 8fbf0044 8fb00040 03e00008 27bd0048 
End CFunction
'
CFunction font
	00000000
	00000000 00000000 5f000000 00000000 00070000 00000007 147f1400 0000147f
	7f2a1200 0000242a 08646200 00002313 56205000 00003649 07030000 00000008
	22410000 0000001c 221c0000 00000041 7f1c2a00 00002a1c 3e080800 00000808
	70300000 00000080 08080800 00000808 60600000 00000000 08040200 00002010
	49453e00 00003e51 7f400000 00000042 49494600 00007249 494d3300 00002141
	127f1000 00001814 45453900 00002745 49493100 00003c4a 11090700 00004121
	49493600 00003649 49291e00 00004649 14000000 00000000 34000000 00000040
	14224100 00000008 14141400 00001414 22140800 00000041 59090600 00000201
	5d594e00 00003e41 11127c00 00007c12 49493600 00007f49 41412200 00003e41
	41413e00 00007f41 49494100 00007f49 09090100 00007f09 41517300 00003e41
	08087f00 00007f08 7f410000 00000041 413f0100 00002040 14224100 00007f08
	40404000 00007f40 1c027f00 00007f02 08107f00 00007f04 41413e00 00003e41
	09090600 00007f09 51215e00 00003e41 19294600 00007f09 49493200 00002649
	7f010300 00000301 40403f00 00003f40 40201f00 00001f20 38403f00 00003f40
	08146300 00006314 78040300 00000304 494d4300 00006159 41414100 0000007f
	08102000 00000204 41417f00 00000041 01020400 00000402 40404000 00004040
	07080000 00000003 54784000 00002054 44443800 00007f28 44442800 00003844
	44287f00 00003844 54541800 00003854 7e090200 00000008 a49c7800 000018a4
	04047800 00007f08 7d400000 00000044 403d0000 00002040 28440000 00007f10
	7f400000 00000041 78047800 00007c04 04047800 00007c08 44443800 00003844
	24241800 0000fc18 2418fc00 00001824 04040800 00007c08 54542400 00004854
	3f442400 00000404 40207c00 00003c40 40201c00 00001c20 30403c00 00003c40
	10284400 00004428 90907c00 00004c90 544c4400 00004464 36410000 00000008
	77000000 00000000 36080000 00000041 02040200 00000201 23263c00 00003c26
End CFunction
