  ' V1.1
  ' Graphics library with drivers for ILI9341 SPI display with XPT2046 touch controller
  '
  ' drawing primitives assume a graphics display where top left is point 0, 0
  '
  ' set screen orientation: sub I9341.setrot(x) ;I9341_normal=normal, I9341_inverse=invert, I9341_rt_right=rotate right, I9341_rt_left=rotate left
  ' draw circle: sub I9341.dcirc(x0, y0, r, colour) ;x, y coordinates of centre, radius, colour
  ' draw filled circle: sub I9341.fcirc(x0, y0, r, colour) ;x, y coordinates of centre, radius, colour
  ' draw triangle:  sub I9341.dtri(x0, y0, x1, y1, 	x2, y2, colour) ;three coordinate pairs, colour
  ' draw filled triangle sub I9341.ftri (x0, y0, x1, y1, x2, y2, colour) ;three coordinate pairs, colour
  ' print string: sub I9341.pstring(xx0, yy0, text$, sz, orientation, forecolour, backcolour) ;x, y coordinates of top left of first character, text string, size, character orientation,  foreground colour,  background colour
  ' print 8x5 bitmap: sub I9341.pbitmap(xx0, yy0, char, sz, orientation, forecolour, backcolour) ;x, y coordinates of top left of first character, text string, size, character orientation,  foreground colour,  background colour
  ' draw line: sub I9341.dline(xx0, yy0, xx1, yy1, colour) ;x, y of start line, x, y of end line, colour
  ' draw rectangle: sub I9341.drect(x, y, w, h, colour) ;x, y coordinate of top left, width, height, colour
  ' draw filled rectangle: sub I9341.frect(x, y, w, h, colour) ;x, y coordinate of top left, width, height, colour
  ' draw rounded rectangle: sub I9341.drndrect(x, y, w, h, r, colour) ;x, y coordinates of top left, width, height, radius of corner, colour
  ' draw filled rounded rectangle: sub I9341.frndrect(x, y, w, h, r, colour) ;x, y coordinates of top left, width, height, radius of corner, colour
  '
  OPTION DEFAULT none
  OPTION EXPLICIT
  CPU 48
  'These need to be global as need to remember them between calls to QwertyTest
  DIM STRING L1$=""
  DIM INTEGER SHIFT=1
  
  I9341.init
  'PWM 2,1000,0
    '
 'Graemes Qwertypad with QwertyTest & using Peters x,y touch coords routi
 'with some mods by Greg
  QwertyPad  'Just set up the keyboard and wait.
  ' The interrupt will call QwertyTest
  

  DO
    'I9341_test
    'nothing to do
  LOOP
  END
  '
SUB I9341.init
  'Global "Constants"
  DIM INTEGER I9341_CS=6
  DIM INTEGER I9341_CD=4
  DIM INTEGER I9341_RESET=5
  DIM INTEGER T_IRQ=2
  DIM INTEGER T_CS=7
  CONST ILI9341_SOFTRESET         =&H01
  CONST ILI9341_SLEEPIN           =&H10
  CONST ILI9341_SLEEPOUT          =&H11
  CONST ILI9341_NORMALDISP        =&H13
  CONST ILI9341_INVERTOFF         =&H20
  CONST ILI9341_INVERTON          =&H21
  CONST ILI9341_GAMMASET          =&H26
  CONST ILI9341_DISPLAYOFF        =&H28
  CONST ILI9341_DISPLAYON         =&H29
  CONST ILI9341_COLADDRSET        =&H2A
  CONST ILI9341_PAGEADDRSET       =&H2B
  CONST ILI9341_MEMORYWRITE       =&H2C
  CONST ILI9341_PIXELFORMAT       =&H3A
  CONST ILI9341_FRAMECONTROL      =&HB1
  CONST ILI9341_DISPLAYFUNC       =&HB6
  CONST ILI9341_ENTRYMODE         =&HB7
  CONST ILI9341_POWERCONTROL1     =&HC0
  CONST ILI9341_POWERCONTROL2     =&HC1
  CONST ILI9341_VCOMCONTROL1      =&HC5
  CONST ILI9341_VCOMCONTROL2      =&HC7
  DIM INTEGER  ILI9341_MEMCONTROL =&H36
  DIM INTEGER  ILI9341_MADCTL_MY  =&H80
  DIM INTEGER  ILI9341_MADCTL_MX  =&H40
  DIM INTEGER  ILI9341_MADCTL_MV  =&H20
  DIM INTEGER  ILI9341_MADCTL_ML  =&H10
  DIM INTEGER  ILI9341_MADCTL_RGB =&H00
  DIM INTEGER  ILI9341_MADCTL_BGR =&H08
  DIM INTEGER  ILI9341_MADCTL_MH  =&H04
  '
  DIM INTEGER BLACK = &H0000 ' Color definitions: 16 bit (RGB565) colour palette so these are just examples
  DIM INTEGER BLUE  = &H001F
  DIM INTEGER RED   = &HF800
  DIM INTEGER GREEN = &H07E0
  DIM INTEGER CYAN  = &H07FF
  DIM INTEGER MAGENTA=&HF81F
  DIM INTEGER YELLOW= &HFFE0
  DIM INTEGER WHITE = &HFFFF
  DIM INTEGER I9341.pix=0
  DIM INTEGER I9341.ffr=1
  DIM INTEGER I9341.drawline=3
  DIM INTEGER I9341.wcom=4
  DIM INTEGER I9341.wdata=5
  DIM INTEGER I9341.fastfillscreen=6
  DIM INTEGER I9341.fpstring=7
  DIM INTEGER I9341.fcirch=8
  DIM INTEGER I9341.dcirch=9
  DIM INTEGER I9341_normal=0
  DIM INTEGER I9341_inverse=1
  DIM INTEGER I9341_rt_right=2
  DIM INTEGER I9341_rt_left=3
  DIM INTEGER I9341_AddrOfFont, I9341_params(6) ' Global variables
  DIM INTEGER I9341_wi=0,I9341_ht=1,I9341_rot=2,I9341_nr=3,I9341_X=4,I9341_Y=5,I9341_seed=6
  LOCAL INTEGER i
  SPI OPEN 12000000,3,8
  I9341_Params(I9341_wi)=240
  I9341_params(I9341_ht)=320
  I9341_AddrOfFont=PEEK(CFUNADDR FONT)
  'SETPIN T_IRQ,DIN,PULLUP
  SETPIN T_IRQ,INTL,QwertyTest,pullup 'Use interrupt driver touch 
  PIN(T_CS)=1
  SETPIN T_CS,DOUT
  PIN(I9341_CS)=1
  SETPIN I9341_CS, DOUT
  PIN(I9341_CD)=1
  SETPIN I9341_CD, DOUT
  PIN(I9341_RESET)=1
  SETPIN I9341_RESET, DOUT'  Reset the display
  PIN(I9341_RESET)=0
  PAUSE 100
  PIN(I9341_RESET)=1
  PAUSE 100
  i=I9341draw(I9341.wcom,ILI9341_SOFTRESET)'software reset
  PAUSE 150
  i=I9341draw(I9341.wcom,ILI9341_DISPLAYOFF)
  i=I9341draw(I9341.wcom,ILI9341_POWERCONTROL1)
  i=I9341draw(I9341.wdata,&H23)
  i=I9341draw(I9341.wcom,ILI9341_POWERCONTROL2)
  i=I9341draw(I9341.wdata,&H10)
  i=I9341draw(I9341.wcom,ILI9341_VCOMCONTROL1)
  i=I9341draw(I9341.wdata,&H2B)
  i=I9341draw(I9341.wdata,&H2B)
  i=I9341draw(I9341.wcom,ILI9341_VCOMCONTROL2)
  i=I9341draw(I9341.wdata,&HC0)
  i=I9341draw(I9341.wcom,ILI9341_MEMCONTROL)
  i=I9341draw(I9341.wdata,(ILI9341_MADCTL_MX OR ILI9341_MADCTL_BGR))
  i=I9341draw(I9341.wcom,ILI9341_PIXELFORMAT)
  i=I9341draw(I9341.wdata,&H55)
  i=I9341draw(I9341.wcom,ILI9341_FRAMECONTROL)
  i=I9341draw(I9341.wdata,&H00)
  i=I9341draw(I9341.wdata,&H1B)
  i=I9341draw(I9341.wcom,ILI9341_ENTRYMODE)
  i=I9341draw(I9341.wdata,&H07)
  i=I9341draw(I9341.wcom,ILI9341_SLEEPOUT)
  i=I9341draw(I9341.wdata,0)
  PAUSE 150
  i=I9341draw(I9341.wcom,ILI9341_NORMALDISP)
  i=I9341draw(I9341.wcom,ILI9341_DISPLAYON)
  PAUSE 500
  I9341.setrot(I9341_normal)
  i=I9341draw(I9341.wcom,ILI9341_COLADDRSET)
  i=I9341draw(I9341.wdata,0)
  i=I9341draw(I9341.wdata,0)
  i=I9341draw(I9341.wdata,0)
  i=I9341draw(I9341.wdata,239)
  i=I9341draw(I9341.wcom,ILI9341_PAGEADDRSET)
  i=I9341draw(I9341.wdata,0)
  i=I9341draw(I9341.wdata,0)
  i=I9341draw(I9341.wdata,1)
  i=I9341draw(I9341.wdata,63)
  I9341.fillscreen(black)
  i=T.Getdata(&HA0) 'wake up the touch controller
END SUB
  '
SUB I9341.setrot(x%) 'sets screen rotation: 0=I9341_normal, 1=invert, 2=rotate right, 3-rotate left
  LOCAL INTEGER i=x% \ 2 '0 for portrait, 1 for landscape
  LOCAL INTEGER j=I9341_params(I9341_rot)\2
  I9341_params(I9341_rot)=(x% AND 3)
  IF i<>j THEN 'swap height and width if landscape
    LOCAL INTEGER k=I9341_params(I9341_wi)
    I9341_params(I9341_wi)=I9341_params(I9341_ht)
    I9341_params(I9341_ht)=k
  ENDIF
  ON I9341_params(I9341_rot)+1 GOTO rnor,rinv,rrr,rrl
rnor:
  i=I9341draw(I9341.wcom,ILI9341_MEMCONTROL)
  i=I9341draw(I9341.wdata, ILI9341_MADCTL_MX OR ILI9341_MADCTL_BGR)
  EXIT SUB
rinv:
  i=I9341draw(I9341.wcom,ILI9341_MEMCONTROL)
  i=I9341draw(I9341.wdata, ILI9341_MADCTL_MY OR ILI9341_MADCTL_BGR)
  EXIT SUB
rrr:
  i=I9341draw(I9341.wcom,ILI9341_MEMCONTROL)
  i=I9341draw(I9341.wdata, ILI9341_MADCTL_MV OR ILI9341_MADCTL_BGR)
  EXIT SUB
rrl:
  i=I9341draw(I9341.wcom,ILI9341_MEMCONTROL)
  i=I9341draw(I9341.wdata, ILI9341_MADCTL_MY OR ILI9341_MADCTL_MX OR ILI9341_MADCTL_MV OR ILI9341_MADCTL_BGR)
END SUB
  '
FUNCTION T.Getdata(command AS INTEGER) AS INTEGER 'get data from the touch controller
  LOCAL INTEGER i,j,k,l
  PIN(T_CS)=0
  l=PEEK(WORD &HBF805830) 'read the SPI clock register
  POKE WORD &HBF805830,&H17 'slow down the SPI
  i=SPI(command)
  j=SPI(0)
  k=SPI(0)
  PIN(T_CS)=1
  POKE WORD &HBF805830,l 'reset the SPI clock register
  T.Getdata= (j*256+k)>>4
END FUNCTION
  '
FUNCTION T.getxy(x AS INTEGER, y AS INTEGER, timeout AS INTEGER) AS INTEGER
  TIMER=0
  DO WHILE (TIMER<timeout AND PIN(T_IRQ)=1)
  LOOP
  IF TIMER>=timeout THEN
    T.getxy=0
  ELSE
    y=T.getdata(&H90)
    x=T.getdata(&HD0)
    T.getxy=1
  ENDIF
END FUNCTION
  '
  ' Generic drawing routines
  '
SUB I9341.fillscreen(scol AS INTEGER)
  LOCAL INTEGER i=I9341_params(I9341_rot)
  I9341_params(I9341_rot)=I9341_normal
  LOCAL INTEGER j=I9341draw(I9341.ffr,scol, 0,0,I9341_params(I9341_wi),I9341_params(I9341_ht), I9341_params())
  I9341_params(I9341_rot)=i
END SUB
  '
SUB I9341.dcirc(x0 AS INTEGER, y0 AS INTEGER, r AS INTEGER, colour AS INTEGER) 'x, y coordinates of centre, radius
  LOCAL INTEGER i=I9341draw(I9341.dcirch, colour,x0,y0,r,31,I9341_params())
  
END SUB
  '
SUB I9341.dtri(x0 AS INTEGER, y0 AS INTEGER, x1 AS INTEGER, y1 AS INTEGER, x2 AS INTEGER, y2 AS INTEGER, colour AS INTEGER) 'three coordinate pairs  
  I9341.dline(x0, y0, x1, y1, colour)
  I9341.dline(x1, y1, x2, y2, colour)
  I9341.dline(x2, y2, x0, y0, colour)
END SUB
  '
SUB I9341.ftri (x0 AS INTEGER, y0 AS INTEGER, x1 AS INTEGER, y1 AS INTEGER, x2 AS INTEGER, y2 AS INTEGER, colour AS INTEGER) 'three coordinate pairs
  LOCAL INTEGER a, b, y, dp, last
  IF (y0>y1) THEN
    swap(y0, y1)
    swap(x0, x1)
  ENDIF
  IF (y1>y2) THEN
    swap(y2, y1)
    swap(x2, x1)
  ENDIF
  IF (y0>y1) THEN
    swap(y0, y1)
    swap(x0, x1)
  ENDIF
  IF(y0=y2) THEN ' Handle awkward all-on-same-line case as its own thing
    a=x0
    b=x0
    IF(x1<a) THEN
      a=x1
    ELSE
      IF(x1>b) THEN b=x1
    ENDIF
    IF(x2<a) THEN
      a=x2
    ELSE
      IF(x2>b) THEN b=x2
    ENDIF
    dp=I9341draw(I9341.ffr, colour, a, y0, 1, b-a+1,  I9341_params())
    EXIT SUB
  ENDIF
  LOCAL INTEGER  dx01=x1-x0,  dy01=y1-y0,  dx02=x2-x0,  dy02=y2-y0, dx12=x2-x1,  dy12=y2-y1,  sa=0, sb=0
  IF(y1=y2) THEN
    last=y1 'Include y1 scanline
  ELSE
    last=y1-1 ' Skip it
  ENDIF
  FOR y=y0 TO last
    a=x0+sa \ dy01
    b=x0+sb \ dy02
    sa=sa+dx01
    sb=sb+dx02
    a=x0+(x1-x0) * (y-y0) \ (y1-y0)
    b=x0+(x2-x0) * (y-y0) \ (y2-y0)
    IF(a>b) THEN swap(a, b)
    dp=I9341draw(I9341.ffr, colour, a, y, b-a+1, 1,  I9341_params())
  NEXT y
  sa=dx12 * (y-y1)
  sb=dx02 * (y-y0)
  DO WHILE y<=y2
    a=x1+sa \ dy12
    b=x0+sb \ dy02
    sa=sa+dx12
    sb=sb+dx02
    a=x1+(x2-x1) * (y-y1) \ (y2-y1)
    b=x0+(x2-x0) * (y-y0) \ (y2-y0)
    IF(a>b) THEN swap(a, b)
    dp=I9341draw(I9341.ffr, colour, a, y, b-a+1, 1,  I9341_params())
    y=y+1
  LOOP
END SUB
  '
SUB I9341.pstring(xx0 AS INTEGER, yy0 AS INTEGER, text$, sz AS INTEGER, orientation AS INTEGER, fontcolour AS INTEGER, backgroundcolour AS INTEGER) 'x, y coordinates of top left of first character, text string, size, orientation
  IF text$<>""  THEN
    LOCAL INTEGER i=I9341draw(I9341.fpstring,I9341_AddrOfFont,xx0,yy0,sz,orientation,fontcolour,backgroundcolour,I9341_params(),text$)
  ENDIF
END SUB 
'
SUB I9341.pbitmap(xx0 AS INTEGER, yy0 AS INTEGER, char AS INTEGER, sz AS INTEGER, orientation AS INTEGER, fontcolour AS INTEGER, backgroundcolour AS INTEGER) 'x, y coordinates of top left of first character, text string, size, orientation
  LOCAL INTEGER i=I9341draw(I9341.fpstring,char,xx0,yy0,sz,orientation,fontcolour,backgroundcolour,I9341_params(),"")
END SUB
  '
SUB I9341.dline(xx0 AS INTEGER, yy0 AS INTEGER, xx1 AS INTEGER, yy1 AS INTEGER, colour AS INTEGER) ' x, y of start line, x, y of end line
  LOCAL INTEGER dp=I9341draw(I9341.drawline, colour, xx0, yy0, xx1, yy1,  I9341_params())
END SUB
  '
SUB swap (a% , b% )
  LOCAL  t%
  t%=b%
  b%=a%
  a%=t%
END SUB
  '
SUB I9341.drect(x AS INTEGER, y AS INTEGER, w AS INTEGER, h AS INTEGER, rcolour AS INTEGER) 'x, y coordinate of top left, wi, ht
  LOCAL INTEGER a, dp
  dp=I9341draw(I9341.ffr, rcolour, x, y, w, 1,  I9341_params())
  a=y+h-1
  dp=I9341draw(I9341.ffr, rcolour, x, a, w, 1,  I9341_params())
  dp=I9341draw(I9341.ffr, rcolour, x, y, 1, h,  I9341_params())
  a=x+w-1
  dp=I9341draw(I9341.ffr, rcolour, a, y, 1, h,  I9341_params())
END SUB
  '
SUB I9341.frect(x AS INTEGER, y AS INTEGER, w AS INTEGER, h AS INTEGER, rcolour AS INTEGER) 'x, y coordinate of top left, width, height
  LOCAL INTEGER dp
  dp=I9341draw(I9341.ffr, rcolour, x, y, w, h,  I9341_params())
END SUB
  '
FUNCTION I9341.Getchar(char AS INTEGER) AS INTEGER
  LOCAL INTEGER i=char<<3
  I9341.Getchar=PEEK(WORD I9341_AddrOfFont+i)+(PEEK(WORD I9341_AddrOfFont+i+4)<<32)
END FUNCTION
  '
SUB I9341.fcirc(x0 AS INTEGER, y0 AS INTEGER, r AS INTEGER, ccolour AS INTEGER)  'x, y coordinates of centre, radius
  LOCAL INTEGER dp
  dp=I9341draw(I9341.ffr, ccolour, x0, y0-r, 1, 2*r+1,  I9341_params())
  dp=I9341draw(I9341.fcircH,x0, y0, r, 3, 0, ccolour, I9341_params())
END SUB
  '
SUB I9341.drndrect(x AS INTEGER, y AS INTEGER, w AS INTEGER, h AS INTEGER, r AS INTEGER, rcolour AS INTEGER) 'x, y coordinates of top left, width, height, radius of corner
  LOCAL INTEGER dp
  dp=I9341draw(I9341.ffr, rcolour, x+r, y, w-2*r, 1,  I9341_params())
  dp=I9341draw(I9341.ffr, rcolour, x+r, y+h-1, w-2*r, 1,  I9341_params())
  dp=I9341draw(I9341.ffr, rcolour, x, y+r, 1, h-2*r,  I9341_params())
  dp=I9341draw(I9341.ffr, rcolour, x+w-1, y+r, 1, h-2*r,  I9341_params())
  dp=I9341draw(I9341.dcirch, rcolour, x+r, y+r, r, 1,I9341_params())
  dp=I9341draw(I9341.dcirch,  rcolour, x+w-r-1, y+r, r, 2,I9341_params())
  dp=I9341draw(I9341.dcirch,  rcolour, x+w-r-1, y+h-r-1, r, 4,I9341_params())
  dp=I9341draw(I9341.dcirch,  rcolour, x+r, y+h-r-1, r, 8,I9341_params())
END SUB
  '
SUB I9341.frndrect(x AS INTEGER, y AS INTEGER, w AS INTEGER, h AS INTEGER, r AS INTEGER, colour AS INTEGER) 'x, y coordinates of top left, width, height, radius of corner
  LOCAL INTEGER dp
  dp=I9341draw(I9341.ffr, colour, x+r, y, w-2*r, h,  I9341_params())
  dp=I9341draw(I9341.fcircH,x+w-r-1, y+r, r, 1, h-2*r-1, colour, I9341_params())
  dp=I9341draw(I9341.fcircH,x+r, y+r, r, 2, h-2*r-1, colour, I9341_params())
END SUB
  '
  'D:\Peter\MPLABXProjects\TFT18\dist\default\production\I9341draw.bas
  'I9341draw  2015-01-17 09:42:08 CFuncGen Ver 1.0.21 by user=Peter
  '
CFUNCTION I9341draw
  'writeCommand
  000005B2
  3c02bf88 24030004 ac436134 24030001 ac436134 3c02bf80 ac445820 3c03bf80
  8c625810 30420080 1040fffd 3c02bf88 24030004 ac436138 3c02bf80 8c425820
  03e00008 00000000
  
  'writeData
  3c02bf88 24030004 ac436134 24030001 ac436138 3c02bf80
  ac445820 3c03bf80 8c625810 30420080 1040fffd 3c02bf88 24030004 ac436138
  3c02bf80 8c425820 03e00008 00000000
  
  'setpos
  27bdffd8 afbf0024 afb30020 afb2001c
  afb10018 afb00014 00808821 00a09021 00c09821 00e08021 2404002a 00002821
  0411FFCF 00000000 7e243a00 00002821 0411FFDD 00000000 322400ff 00002821
  0411FFD9 00000000 7e443a00 00002821 0411FFD5 00000000 324400ff 00002821
  0411FFD1 00000000 2404002b 00002821 0411FFBB 00000000 7e643a00 00002821
  0411FFC9 00000000 326400ff 00002821 0411FFC5 00000000 7e043a00 00002821
  0411FFC1 00000000 320400ff 00002821 0411FFBD 00000000 2404002c 00002821
  0411FFA7 00000000 8fbf0024 8fb30020 8fb2001c 8fb10018 8fb00014 03e00008
  27bd0028
  
  'localfastfillrect
  27bdffd0 afbf002c afb50028 afb40024 afb30020 afb2001c afb10018
  afb00014 8fa90040 8fa70050 8fa20058 8c430000 8c480008 7c933a00 309200ff
  00c02021 01201021 24caffff 8fa50048 04c10004 01452821 24c60002 00a62821
  00002021 00a3502a 2466ffff 00ca280a 2526ffff 04410004 00c73821 25290002
  00e93821 00001021 00e8482a 2506ffff 00c9380a 00008021 04a0002a 00008821
  04e00028 0083182a 10600026 0048402a 51000025 02001021 24140001 02841823
  00651821 0282a823 02a7a821 72a3a802 00403021 0411FF8E 00000000 3c02bf88
  ac546138 24030004 ac436134 12a00010 26a4ffff 3c02bf80 ac535820 8c435810
  30630080 1060fffd 00000000 8c435820 ac525820 8c435810 30630080 1060fffd
  00000000 8c435820 1480fff3 2484ffff 24030004 3c02bf88 ac436138 02a08021
  00008821 02001021 02201821 8fbf002c 8fb50028 8fb40024 8fb30020 8fb2001c
  8fb10018 8fb00014 03e00008 27bd0030
  
  'colourrect
  27bdffd8 afbf0024 afb40020 afb3001c
  afb20018 afb10014 afb00010 00808021 8fa90038 8fa70048 8fa20050 8c430000
  8c480008 00c02021 01201021 24caffff 8fa50040 04c10004 01452821 24c60002
  00a62821 00002021 00a3502a 2466ffff 00ca280a 2526ffff 04410004 00c73821
  25290002 00e93821 00001021 00e8482a 2506ffff 00c9380a 00009021 04a00033
  00009821 04e00031 0083182a 1060002f 0048402a 5100002e 02401021 24140001
  02841823 00651821 02828823 02278821 72238802 00403021 0411FF35 00000000
  3c02bf88 ac546138 24030004 ac436134 12200019 00001021 00002021 3c07bf88
  24060004 3c02bf80 ace66134 02002821 92030001 ac435820 8c435810 30630080
  1060fffd 00000000 8c435820 90a30000 ac435820 8c435810 30630080 1060fffd
  00000000 8c435820 24840001 1491ffee 26100002 02201021 24040004 3c03bf88
  ac646138 00409021 00009821 02401021 02601821 8fbf0024 8fb40020 8fb3001c
  8fb20018 8fb10014 8fb00010 03e00008 27bd0028
  
  'localdrawPixel
  27bdffe8 afbf0014 afb00010
  00808021 8fa70028 8fa20030 8c440004 1c800008 24030001 54800006 00001821
  8c440000 00c4202b 14800003 306300ff 00001821 306300ff 1060001e 00002021
  8c44000c 1c800008 24030001 54800006 00001821 8c420008 00e2102b 14400003
  306300ff 00001821 306300ff 50600011 00002021 00c02021 00c02821 00e03021
  0411FEE3 00000000 7e043a00 00002821 0411FECD 00000000 320400ff 00002821
  0411FEC9 00000000 24040001 10000002 00002821 00002821 00801021 00a01821
  8fbf0014 8fb00010 03e00008 27bd0018
  
  'drawline
  27bdffb8 afbf0044 afbe0040 afb7003c
  afb60038 afb50034 afb40030 afb3002c afb20028 afb10024 afb00020 afa40048
  afa5004c 8fa20058 8fa30060 8fa40068 8fb60070 00c08021 00409021 00609821
  0044a02a 00822823 00443823 00f4280a 00a0a021 00c3402a 00663823 00c32823
  00e8280b 00b4a02a 12800005 0080a821 00809821 0060a821 00408021 00c09021
  0270102a 10400008 0255102a 02401021 02a09021 0040a821 02001021 02608021
  00409821 0255102a 10400007 0270b823 02b2a823 00178fc2 02378821 00118843
  10000006 241e0001 0255a823 00178fc2 02378821 00118843 241effff 0270102a
  14400020 8fbf0044 5280000d afb20010 afb00010 001017c3 afa20014 afb60018
  8fa40048 8fa5004c 02403021 00123fc3 0411FF80 00000000 1000000b 02358823
  001217c3 afa20014 afb60018 8fa40048 8fa5004c 02003021 00103fc3 0411FF75
  00000000 02358823 06210003 26100001 025e9021 02378821 0270102a 1040ffe2
  8fbf0044 8fbe0040 8fb7003c 8fb60038 8fb50034 8fb40030 8fb3002c 8fb20028
  8fb10024 8fb00020 03e00008 27bd0048
  
  'drawchar
  27bdff00 afbf00fc afbe00f8 afb700f4
  afb600f0 afb500ec afb400e8 afb300e4 afb200e0 afb100dc afb000d8 00c0b821
  8fb00118 afa40098 afa5009c 8fa4011c 14800063 00e0f021 0200b021 8fa50114
  afa500a8 afa000b4 afa000b8 27a60097 afa600a0 00108fc3 000717c3 afa200bc
  00171fc3 afa300c4 afb700ac afa700b0 02009821 1000003d 0220b821 92020000
  02821024 10400016 00000000 56750004 afbe0010 8fa400ac 10000024 a6440000
  8fa500a4 afa50014 afb30018 afb7001c afb30020 afb70024 8fa60120 afa60028
  8fa400ac 8fa500c4 02203021 00113fc3 0411FE6C 00000000 10000015 2610ffff
  56750004 afbe0010 8fa200b0 1000000f a6420000 8fa300a4 afa30014 afb30018
  afb7001c afb30020 afb70024 8fa40120 afa40028 8fa400b0 8fa500bc 02203021
  00113fc3 0411FE57 00000000 2610ffff 02368821 8fa500a0 1605ffd0 26520002
  8fa600b8 24c60006 afa600b8 8fa200b4 24420001 afa200b4 8fa300a8 00761821
  24020030 10c2000f afa300a8 24140001 8fa400b4 0094a004 8fbe00a8 001e2fc3
  afa500a4 27b0009d 8fb10110 8fa600b8 00069040 27a20030 00529021 1000ffb7
  24150001 8fb700ac 8fbe00b0 02608021 00131040 001318c0 1000007e 00621023
  24040001 8fa5011c 14a40079 0200b021 8fa60114 24c60001 afa600d4 001010c0
  00c21023 afa200ac 24020007 afa200b4 afa000b8 8fa30110 24630001 afa300c4
  00701823 00101080 00501021 00621023 afa200cc 27a4009e afa400a0 00108fc3
  00072fc3 afa500bc afa700b0 02e0f021 02009821 1000003f 0220b821 92020000
  02821024 10400016 00000000 16750003 8fa200a4 10000026 a65e0000 afa20010
  8fa300a8 afa30014 afb30018 afb7001c afb30020 afb70024 8fa40120 afa40028
  03c02021 8fa500c0 02203021 00113fc3 0411FDFC 00000000 10000016 26100001
  16750004 8fa600a4 8fa500b0 10000010 a6450000 afa60010 8fa200a8 afa20014
  afb30018 afb7001c afb30020 afb70024 8fa30120 afa30028 8fa400b0 8fa500bc
  02203021 00113fc3 0411FDE6 00000000 26100001 02368821 8fa400a0 1604ffcf
  26520002 8fa500b8 24a50006 afa500b8 8fa600b4 24c6ffff afa600b4 8fa200ac
  00561021 afa200ac 24020030 50a20014 03c0b821 24140001 8fa300b4 0074a004
  8fa400ac afa400a4 00042fc3 afa500a8 27b00098 8fa600c4 afa600d0 8fb100cc
  8fa200b8 00029040 27a30030 00729021 24150001 001e27c3 1000ffb0 afa400c0
  8fbe00b0 02608021 001318c0 8fa500d4 00a32823 afa50114 00131040 00621023
  8fa600d0 00c23023 10000075 afa60110 afa000b8 24040002 8fa5011c 14a40072
  24040003 0200a821 8fa60114 afa600b4 27b4009d 27a20097 afa200a0 8fa300b8
  afa300bc 8fa40110 24840001 afa400c8 001010c0 00821023 afa200d4 00108fc3
  001e2fc3 afa500c0 001737c3 afa600c4 afb700ac afbe00b0 02009821 1000003e
  0220f021 92820000 02021007 30420001 10400017 00000000 16760004 8fa300a4
  8fa200ac 10000026 a6420000 afa30010 8fa400a8 afa40014 afb30018 afbe001c
  afb30020 afbe0024 8fa50120 afa50028 8fa400ac 8fa500c4 02203021 00113fc3
  0411FD80 00000000 10000016 2610ffff 16760004 8fa200a4 8fa600b0 10000010
  a6460000 afa20010 8fa300a8 afa30014 afb30018 afbe001c afb30020 afbe0024
  8fa40120 afa40028 8fa400b0 8fa500c0 02203021 00113fc3 0411FD6A 00000000
  2610ffff 02358821 1617ffce 26520002 8fa500bc 24a50008 afa500bc 8fa600b4
  00d53021 afa600b4 2694ffff 8fa200a0 52820010 02608021 8fa300b4 afa300a4
  000327c3 afa400a8 8fa500c8 afa500d0 8fb100d4 8fa600bc 00069040 27a20030
  00529021 24100007 24160001 1000ffb5 2417ffff 8fa300b8 24630030 afa300b8
  001318c0 8fa400d0 00832023 afa40110 00601021 00132040 1000006a 00641823
  24040003 8fa5011c 14a40067 24040001 0200a821 00101840 001010c0 00621023
  24420001 8fa60114 00c23021 afa60114 afa600b0 27b40098 27a2009e afa200a0
  8fa300b8 afa300b4 00108fc3 001e27c3 afa400bc 00172fc3 afa500c4 afb700a8
  afbe00ac 02009821 1000003d 0220b821 92820000 02021007 30420001 10400017
  24050001 24060001 56660004 afbe0010 8fa200a8 10000024 a6420000 8fa300a4
  afa30014 afb30018 afb7001c afb30020 afb70024 8fa40120 afa40028 8fa400a8
  8fa500c4 02203021 00113fc3 0411FD0D 00000000 10000015 26100001 56650004
  afbe0010 8fa600ac 1000000f a6460000 8fa200a4 afa20014 afb30018 afb7001c
  afb30020 afb70024 8fa30120 afa30028 8fa400ac 8fa500bc 02203021 00113fc3
  0411FCF8 00000000 26100001 02358821 1616ffcf 26520002 8fa400b4 24840008
  afa400b4 8fa500b0 00b52821 afa500b0 26940001 8fa600a0 5286000c 02608021
  8fbe00b0 001e17c3 afa200a4 8fb10110 8fa300b4 00039040 27a40030 00929021
  00008021 1000ffba 24160008 8fa500b8 24a50030 afa500b8 001310c0 00131840
  00431823 24040001 16040014 8fa400b8 8fa60114 afa60010 000627c3 afa40014
  afa20018 000217c3 afa2001c afa30020 00031fc3 afa30024 8fa20120 afa20028
  27a40030 8fa60110 00063fc3 0411FD20 00000000 afa200b8 8fa400b8 00041fc3
  00801021 8fbf00fc 8fbe00f8 8fb700f4 8fb600f0 8fb500ec 8fb400e8 8fb300e4
  8fb200e0 8fb100dc 8fb000d8 03e00008 27bd0100
  
  'pstring
  27bdffa0 afbf005c afbe0058
  afb70054 afb60050 afb5004c afb40048 afb30044 afb20040 afb1003c afb00038
  00c08021 8fa60070 afa6002c 8fa60078 afa60028 8fa90080 8fa60088 8fa70090
  8fb50098 8fb4009c 02009821 8fb1002c 8fbe0028 01209021 00c0b821 afa40030
  92880000 1100003c 00e0b021 19000063 24100001 001e1040 001e18c0 00621823
  afa30028 00031023 afa2002c 39230003 afa30034 02901021 90420000 2443ffe0
  306300ff 2c630060 50600008 00002021 2442ffe0 000210c0 8fa40030 00441021
  8c440000 10000002 8c450004 00002821 afb30010 afb10014 afbe0018 afb2001c
  afb50020 02e03021 02c03821 0411FDD0 00000000 16400004 24060001 8fa50028
  1000000a 02659821 16460003 8fa4002c 1000000a 02649821 24050002 16450003
  8fa60028 10000005 02268821 8fa5002c 02252021 8fa60034 0086880a 26100001
  92840000 0090202a 5080ffd3 02901021 1000002b aeb30020 afb00010 8fa2002c
  afa20014 8fa30028 afa30018 afa9001c afb50020 0411FDAE 00000000 16400007
  24040001 8fa50028 00052040 000598c0 02649823 10000011 02139821 16440006
  8fa60028 00069840 000620c0 02649823 10000012 02139821 24040002 16440007
  8fa50028 00052040 000588c0 02248823 8fa6002c 10000009 00d18821 24040003
  16440006 8fa40028 00048840 000420c0 02248823 8fa5002c 00b18821 aeb30020
  00139fc3 aeb30024 aeb10028 00118fc3 aeb1002c 8fbf005c 8fbe0058 8fb70054
  8fb60050 8fb5004c 8fb40048 8fb30044 8fb20040 8fb1003c 8fb00038 03e00008
  27bd0060
  
  'dcirch
  27bdffa0 afbf005c afbe0058 afb70054 afb60050 afb5004c afb40048
  afb30044 afb20040 afb1003c afb00038 afa40060 afa50064 00c0b021 8fb50070
  8fb00078 8fa20080 8fb70088 afa60024 afb50028 afa20020 30420010 1040002a
  02008821 000697c3 02151021 afa20010 000217c3 afa20014 afb70018 02403821
  0411FCBC 00000000 02b01023 afa20010 000217c3 afa20014 afb70018 8fa40060
  8fa50064 02c03021 02403821 0411FCB1 00000000 001597c3 02163821 afb50010
  afb20014 afb70018 8fa40060 8fa50064 00e03021 00073fc3 0411FCA6 00000000
  02d03823 afb50010 afb20014 afb70018 8fa40060 8fa50064 00e03021 00073fc3
  0411FC9C 00000000 1a20008f 24110001 02308823 0010f023 001ef040 26b3ffff
  26d4ffff 26b50001 26d60001 00009021 8fa20020 30420004 afa2002c 8fa30020
  30630002 afa30030 8fa20020 30420008 afa20034 8fa30020 30630001 afa30020
  06200004 8fa2002c 2610ffff 27de0002 023e8821 10400019 26520001 8fa30028
  02031021 afa20010 000217c3 afa20014 afb70018 8fa40060 8fa50064 02c03021
  00163fc3 0411FC73 00000000 8fa20024 02023821 afb50010 001517c3 afa20014
  afb70018 8fa40060 8fa50064 00e03021 00073fc3 0411FC67 00000000 8fa30030
  1060001a 8fa30034 8fa30028 00701023 afa20010 000217c3 afa20014 afb70018
  8fa40060 8fa50064 02c03021 00163fc3 0411FC58 00000000 8fa20024 02023821
  afb30010 001317c3 afa20014 afb70018 8fa40060 8fa50064 00e03021 00073fc3
  0411FC4C 00000000 8fa30034 1060001a 8fa20020 8fa20024 00503823 afb50010
  001517c3 afa20014 afb70018 8fa40060 8fa50064 00e03021 00073fc3 0411FC3D
  00000000 8fa30028 02031021 afa20010 000217c3 afa20014 afb70018 8fa40060
  8fa50064 02803021 00143fc3 0411FC31 00000000 8fa20020 5040001a 2673ffff
  8fa30024 00703823 afb30010 001317c3 afa20014 afb70018 8fa40060 8fa50064
  00e03021 00073fc3 0411FC22 00000000 8fa30028 00701023 afa20010 000217c3
  afa20014 afb70018 8fa40060 8fa50064 02803021 00143fc3 0411FC16 00000000
  2673ffff 2694ffff 26b50001 0250102a 10400005 26d60001 00121040 24420001
  1000ff87 02228821 8fbf005c 8fbe0058 8fb70054 8fb60050 8fb5004c 8fb40048
  8fb30044 8fb20040 8fb1003c 8fb00038 03e00008 27bd0060
  
  'fcirch
  27bdff90 afbf006c
  afbe0068 afb70064 afb60060 afb5005c afb40058 afb30054 afb20050 afb1004c
  afb00048 8fb10080 8fb40090 8fbe00a0 afa40038 afa6003c 8fa20088 1a200076
  02801821 24100001 02118023 0011b823 0017b840 2495ffff 24d3ffff 26940003
  24960001 00009021 30440001 afa40030 24630001 afa30040 30420002 afa20034
  06000004 8fa20030 2631ffff 26f70002 02178021 1040002a 26520001 8fa3003c
  00711023 afa20010 000217c3 afa20014 24020001 00001821 afa20018 afa3001c
  00111040 8fa30040 00621021 afa20020 000217c3 afa20024 afbe0028 8fa40098
  8fa5009c 02c03021 00163fc3 0411FB05 00000000 8fa40038 02243821 afb30010
  001317c3 afa20014 24020001 00001821 afa20018 afa3001c afb40020 001417c3
  afa20024 afbe0028 8fa40098 8fa5009c 00e03021 00073fc3 0411FAF2 00000000
  8fa30034 5060002b 26b5ffff 8fa4003c 00911023 afa20010 000217c3 afa20014
  24020001 00001821 afa20018 afa3001c 00111040 8fa30040 00621021 afa20020
  000217c3 afa20024 afbe0028 8fa40098 8fa5009c 02a03021 00153fc3 0411FAD9
  00000000 8fa40038 00913823 afb30010 001317c3 afa20014 24020001 00001821
  afa20018 afa3001c afb40020 001417c3 afa20024 afbe0028 8fa40098 8fa5009c
  00e03021 00073fc3 0411FAC6 00000000 26b5ffff 2673ffff 26940002 0251102a
  10400005 26d60001 00121040 24420001 1000ff9b 02028021 8fbf006c 8fbe0068
  8fb70064 8fb60060 8fb5005c 8fb40058 8fb30054 8fb20050 8fb1004c 8fb00048
  03e00008 27bd0070
  
  'main
  27bdffb8 afbf0044 afb00040 00808021 00e01021 8fa90058
  8faa005c 8fa80060 8c830000 8c840004 00643825 14e0000e 8fab0064 8ca40000
  8ca50004 8cc70004 8cc60000 8c430004 8c420000 afa20010 afa30014 afa90018
  0411FB54 00000000 100000a7 8fbf0044 24070001 14670018 24070003 14800016
  00000000 8ca40000 8ca50004 8cc70004 8cc60000 8c430004 8c420000 afa20010
  afa30014 8d220000 8d230004 afa20018 afa3001c 8d420000 8d430004 afa20020
  afa30024 afa80028 0411FA7E 00000000 1000008d 8fbf0044 14670019 24070004
  14800017 00000000 8ca40000 8ca50004 8cc70004 8cc60000 8c430004 8c420000
  afa20010 afa30014 8d220000 8d230004 afa20018 afa3001c 8d420000 8d430004
  afa20020 afa30024 afa80028 0411FB58 00000000 8e020000 10000072 8e030004
  1467000a 24070005 14800008 00000000 8ca40000 8ca50004 0411F9F9 00000000
  8e020000 10000067 8e030004 1467000a 24070007 14800008 00000000 8ca40000
  8ca50004 0411FA00 00000000 8e020000 1000005c 8e030004 14670023 24070008
  14800021 00000000 8ca40000 8ca50004 8cc70004 8cc60000 8c430004 8c420000
  afa20010 afa30014 8d220000 8d230004 afa20018 afa3001c 8d420000 8d430004
  afa20020 afa30024 8d020000 8d030004 afa20028 afa3002c 8d620000 8d630004
  afa20030 afa30034 8fa20068 afa20038 8fa2006c afa2003c 0411FD76 00000000
  10000039 8fbf0044 1467001d 24070009 1480001b 00000000 8ca40000 8ca50004
  8cc70004 8cc60000 8c430004 8c420000 afa20010 afa30014 8d220000 8d230004
  afa20018 afa3001c 8d420000 8d430004 afa20020 afa30024 8d020000 8d030004
  afa20028 afa3002c afab0030 0411FECA 00000000 8e020000 1000001a 8e030004
  14670019 8fbf0044 54800018 8fb00040 8ca40000 8ca50004 8cc70004 8cc60000
  8c430004 8c420000 afa20010 afa30014 8d220000 8d230004 afa20018 afa3001c
  8d420000 8d430004 afa20020 afa30024 afa80028 0411FDD3 00000000 8e020000
  8e030004 8fbf0044 8fb00040 03e00008 27bd0048
END CFUNCTION
  '
CFUNCTION font
  00000000
  00000000 00000000 5f000000 00000000 00070000 00000007 147f1400 0000147f
  7f2a1200 0000242a 08646200 00002313 56205000 00003649 07030000 00000008
  22410000 0000001c 221c0000 00000041 7f1c2a00 00002a1c 3e080800 00000808
  70300000 00000080 08080800 00000808 60600000 00000000 08040200 00002010
  49453e00 00003e51 7f400000 00000042 49494600 00007249 494d3300 00002141
  127f1000 00001814 45453900 00002745 49493100 00003c4a 11090700 00004121
  49493600 00003649 49291e00 00004649 14000000 00000000 34000000 00000040
  14224100 00000008 14141400 00001414 22140800 00000041 59090600 00000201
  5d594e00 00003e41 11127c00 00007c12 49493600 00007f49 41412200 00003e41
  41413e00 00007f41 49494100 00007f49 09090100 00007f09 41517300 00003e41
  08087f00 00007f08 7f410000 00000041 413f0100 00002040 14224100 00007f08
  40404000 00007f40 1c027f00 00007f02 08107f00 00007f04 41413e00 00003e41
  09090600 00007f09 51215e00 00003e41 19294600 00007f09 49493200 00002649
  7f010300 00000301 40403f00 00003f40 40201f00 00001f20 38403f00 00003f40
  08146300 00006314 78040300 00000304 494d4300 00006159 41414100 0000007f
  08102000 00000204 41417f00 00000041 01020400 00000402 40404000 00004040
  07080000 00000003 54784000 00002054 44443800 00007f28 44442800 00003844
  44287f00 00003844 54541800 00003854 7e090200 00000008 a49c7800 000018a4
  04047800 00007f08 7d400000 00000044 403d0000 00002040 28440000 00007f10
  7f400000 00000041 78047800 00007c04 04047800 00007c08 44443800 00003844
  24241800 0000fc18 2418fc00 00001824 04040800 00007c08 54542400 00004854
  3f442400 00000404 40207c00 00003c40 40201c00 00001c20 30403c00 00003c40
  10284400 00004428 90907c00 00004c90 544c4400 00004464 36410000 00000008
  77000000 00000000 36080000 00000041 02040200 00000201 23263c00 00003c26
END CFUNCTION
  '
FUNCTION filter(values() AS INTEGER) AS INTEGER
  LOCAL INTEGER AB,BC,AC
  AB=ABS(values(0)-values(1))
  BC=ABS(values(1)-values(2))
  AC=ABS(values(0)-values(2))
  IF AB<=BC AND AB<=AC THEN filter=(values(0)+values(1))\2
  IF BC<=AB AND BC<=AC THEN filter=(values(1)+values(2))\2
  IF AC<=AB AND AC<=BC THEN filter=(values(0)+values(2))\2
END FUNCTION

  
SUB QwertyPad     'Graeme's routine for a Qwerty pad
  LOCAL INTEGER J
  LOCAL STRING Q$
  Q$="QWERTYUIOPASDFGHJKL^ZXCVBNM<  *     .1234567890"
  I9341.setrot(I9341_rt_left)
  I9341.fillscreen(black)
  I9341.drect(0, 0, 320, 240, red)
'--------- This section adds a number row
  FOR J = 1 TO 10
    I9341.frndrect((J*32)-30,68,29,29,3,yellow)
    I9341.pstring((J*32)-22,73,MID$(Q$,J+37,1),3,0,black,yellow)
  NEXT J
'---------
  FOR J = 1 TO 10
    I9341.frndrect((J*32)-30,100,29,29,3,cyan)
    I9341.pstring((J*32)-22,105,MID$(Q$,J,1),3,0,black,cyan)
  NEXT J
  FOR J = 1 TO 9
    I9341.frndrect((J*32)-16,132,29,29,3,cyan)
    I9341.pstring((J*32)-7,137,MID$(Q$,J+10,1),3,0,black,cyan)
  NEXT J
  FOR J = 1 TO 10
    I9341.frndrect((J*32)-30,164,29,29,3,cyan)
    I9341.pstring((J*32)-22,169,MID$(Q$,J+19,1),3,0,black,cyan)
  NEXT J
  FOR J = 1 TO 2
    I9341.frndrect((J*32)-15,196,30,30,3,cyan)
    I9341.pstring((J*32)-7,201,MID$(Q$,J+29,1),3,0,black,cyan)
  NEXT J
  I9341.pstring(17,210,"Shift",1,0,black,cyan)
  I9341.frndrect(81,196,160,30,3,cyan)
  I9341.pstring(125,210,"SPACE",2,0,black,cyan)
  FOR J = 8 TO 9
    I9341.frndrect((J*32)-13,196,30,30,3,cyan)
  NEXT J
  I9341.pstring(243,201,".",3,0,black,cyan)
  I9341.pstring(275,211,"Enter",1,0,black,cyan)
  I9341.pstring(245,230,"spilcdv2.bas",1,0,green,black)
  'I9341.frndrect(10,10,300,80,3,white)
I9341.frndrect(10,2,316,44,3,white)
  I9341.pstring(15,15,"The First Line is Here",2,0,Black,White)
  I9341.pstring(15,35,"The Second Line is Here",2,0,Black,White)
  'I9341.pstring(15,55,"The Third Line is Here",2,0,Black,White)
  'I9341.pstring(15,75,"The Fourth Line is Here",2,0,Black,White)
END SUB
'                  -------Test Touch for QwertyPad-------

SUB QwertyTest
  LOCAL INTEGER x0,y0,xvalues(3),yvalues(3) 
  
 
  SETPIN 24,DOUT
  'DO
    IF T.getxy(xvalues(0),yvalues(0),1000) AND T.getxy(xvalues(1),yvalues(1),1000) AND T.getxy(xvalues(2),yvalues(2),1000) THEN
      'DO WHILE PIN(T_IRQ)=0:LOOP          'wait for key release before processing
      y0=filter(yvalues())
      x0=filter(xvalues())
      IF 1400 > x0 AND 1160 < x0 THEN                  'Value for number row
        IF 1850 > y0 AND 1680 < y0 THEN                'Value for Key 1
          Beep
          L1$=L1$+"1"
        ENDIF
        IF 1680 > y0 AND 1510 < y0 THEN                'Value for 2
          Beep
          L1$=L1$+"2"
        ENDIF
        IF 1510 > y0 AND 1340 < y0 THEN                'Value for 3
          Beep
          L1$=L1$+"3"
        ENDIF
        IF 1340 > y0 AND 1170 < y0 THEN                'Value for 4
          Beep
          L1$=L1$+"4"
        ENDIF
        IF 1170 > y0 AND 1000 < y0 THEN                'Value for 5
          Beep
          L1$=L1$+"5"
        ENDIF
        IF 1000 > y0 AND 830 < y0 THEN                 'Value for 6
          Beep
          L1$=L1$+"6"
        ENDIF
        IF 830 > y0 AND 660 < y0 THEN                  'Value for 7
          Beep
          L1$=L1$+"7"
        ENDIF
        IF 660 > y0 AND 490 < y0 THEN                  'Value for 8
          Beep
          L1$=L1$+"8"
        ENDIF
        IF 490 > y0 AND 320 < y0 THEN                  'Value for 9
          Beep
          L1$=L1$+"9"
        ENDIF
        IF 320 > y0 AND 150 < y0 THEN                  'Value for 0
          Beep
          L1$=L1$+"0"
        ENDIF
      ENDIF
      IF 1160 > x0 AND 920 < x0 THEN                   'Value for 1st alphas row
        IF 1850 > y0 AND 1680 < y0 THEN                'Value for Key Q
          Beep
          IF Shift=1 THEN L1$=L1$+"Q" ELSE L1$=L1$+"q"
        ENDIF
        IF 1680 > y0 AND 1510 < y0 THEN                'Value for W
          Beep
          IF Shift=1 THEN L1$=L1$+"W" ELSE L1$=L1$+"w"
        ENDIF
        IF 1510 > y0 AND 1340 < y0 THEN                'Value for E
          Beep
          IF Shift=1 THEN L1$=L1$+"E" ELSE L1$=L1$+"e"
        ENDIF
        IF 1340 > y0 AND 1170 < y0 THEN                'Value for R
          Beep
          IF Shift=1 THEN L1$=L1$+"R" ELSE L1$=L1$+"r"
        ENDIF
        IF 1170 > y0 AND 1000 < y0 THEN                'Value for T
          Beep
          IF Shift=1 THEN L1$=L1$+"T" ELSE L1$=L1$+"t"
        ENDIF
        IF 1000 > y0 AND 830 < y0 THEN                 'Value for Y
          Beep
          IF Shift=1 THEN L1$=L1$+"Y" ELSE L1$=L1$+"y"
        ENDIF
        IF 830 > y0 AND 660 < y0 THEN                  'Value for U
          Beep
          IF Shift=1 THEN L1$=L1$+"U" ELSE L1$=L1$+"u"
        ENDIF
        IF 660 > y0 AND 490 < y0 THEN                  'Value for I
          Beep
          IF Shift=1 THEN L1$=L1$+"I" ELSE L1$=L1$+"i"
        ENDIF
        IF 490 > y0 AND 320 < y0 THEN                  'Value for O
          Beep
          IF Shift=1 THEN L1$=L1$+"O" ELSE L1$=L1$+"o"
        ENDIF
        IF 320 > y0 AND 150 < y0 THEN                  'Value for P
          Beep
          IF Shift=1 THEN L1$=L1$+"P" ELSE L1$=L1$+"p"
        ENDIF
      ENDIF
      IF 920 > x0 AND 680 < x0 THEN                    'Value for 2nd alphas row
        IF 1760 > y0 AND 1590 < y0 THEN                'Value for Key A
          Beep
          IF Shift=1 THEN L1$=L1$+"A" ELSE L1$=L1$+"a"
        ENDIF
        IF 1590 > y0 AND 1420 < y0 THEN                'Value for S
          Beep
          IF Shift=1 THEN L1$=L1$+"S" ELSE L1$=L1$+"s"
        ENDIF
        IF 1420 > y0 AND 1250 < y0 THEN                'Value for D
          Beep
          IF Shift=1 THEN L1$=L1$+"D" ELSE L1$=L1$+"d"
        ENDIF
        IF 1250 > y0 AND 1080 < y0 THEN                'Value for F
          Beep
          IF Shift=1 THEN L1$=L1$+"F" ELSE L1$=L1$+"f"
        ENDIF
        IF 1080 > y0 AND 910 < y0 THEN                 'Value for G
          Beep
          IF Shift=1 THEN L1$=L1$+"G" ELSE L1$=L1$+"g"
        ENDIF
        IF 910 > y0 AND 740 < y0 THEN                  'Value for H
          Beep
          IF Shift=1 THEN L1$=L1$+"H" ELSE L1$=L1$+"h"
        ENDIF
        IF 740 > y0 AND 570 < y0 THEN                  'Value for J
          Beep
          IF Shift=1 THEN L1$=L1$+"J" ELSE L1$=L1$+"j"
        ENDIF
        IF 570  > y0 AND 400 < y0 THEN                 'Value for K
          Beep
          IF Shift=1 THEN L1$=L1$+"K" ELSE L1$=L1$+"k"
        ENDIF
        IF  400 > y0 AND 230  < y0 THEN                'Value for L
          Beep
          IF Shift=1 THEN L1$=L1$+"L" ELSE L1$=L1$+"l"
        ENDIF
      ENDIF
      IF 680 > x0 AND 440 < x0 THEN                    'Value for 3rd row
        IF 1850 > y0 AND 1680 < y0 THEN                'Value for Key SHIFT
          Beep
          Shift= NOT Shift           ':QweryPad
        ENDIF
        IF 1680 > y0 AND 1510 < y0 THEN                'Value for Z
          Beep
          IF Shift=1 THEN L1$=L1$+"Z" ELSE L1$=L1$+"z"
        ENDIF
        IF 1510 > y0 AND 1340 < y0 THEN                'Value for X
          Beep
          IF Shift=1 THEN L1$=L1$+"X" ELSE L1$=L1$+"x"
        ENDIF
        IF 1340 > y0 AND 1170 < y0 THEN                'Value for C
          Beep
          IF Shift=1 THEN L1$=L1$+"C" ELSE L1$=L1$+"c"
        ENDIF
        IF 1170 > y0 AND 1000 < y0 THEN                'Value for V
          Beep
          IF Shift=1 THEN L1$=L1$+"V" ELSE L1$=L1$+"v"
        ENDIF
        IF 1000 > y0 AND 830 < y0 THEN                 'Value for B
          Beep
          IF Shift=1 THEN L1$=L1$+"B" ELSE L1$=L1$+"b"
        ENDIF
        IF 830 > y0 AND 660 < y0 THEN                  'Value for N
          Beep
          IF Shift=1 THEN L1$=L1$+"N" ELSE L1$=L1$+"n"
        ENDIF
        IF 660 > y0 AND 490 < y0 THEN                  'Value for M
          Beep
          IF Shift=1 THEN L1$=L1$+"M" ELSE L1$=L1$+"m"
        ENDIF
        IF 490 > y0 AND 320 < y0 THEN                  'Value for Backspace
          Beep
          IF LEN(L1$) > 0  THEN
            L1$=LEFT$(L1$,(LEN(L1$)-1))
          ENDIF
        ENDIF
      ENDIF
    I9341.pstring(15,15,"                          ",2,0,red,white)
    I9341.pstring(15,15,L1$,2,0,red,white)
    ENDIF
  'LOOP
SETPIN 24,OFF
END SUB
'
SUB Beep
  PIN(24)=1:PAUSE 20:PIN(24)=0                 'flash LED
END SUB
  '---------------------------------------
