//Setup for matherP board


// Removed cutouts for 4mm nuts
// dropped supports 1.5mm to allow screen (Not needed here)
enclosure_inner_length = 137;  //board is 100
enclosure_inner_width = 86;      //board is 80
//enclosure_inner_depth = 20;
//Signal Generator case @ 10mm
enclosure_inner_depth = 35;  

enclosure_thickness = 2;

cover_thickness = 5.0;
//part = "enclosure";
part = "cover"; // [enclosure:Enclosure, cover:Cover, both:Enclosure and Cover]

print_part();

module print_part() {
	if (part == "enclosure") {
		box2(enclosure_inner_length,enclosure_inner_width,enclosure_inner_depth,enclosure_thickness,enclosure_thickness/2-0.10,cover_thickness);
	} else if (part == "cover") {
		lid2(enclosure_inner_length,enclosure_inner_width,enclosure_inner_depth,enclosure_thickness,enclosure_thickness/2+0.10,cover_thickness);
	} else {
		both();
	}
}

module both() {

box2(enclosure_inner_length,enclosure_inner_width,enclosure_inner_depth,enclosure_thickness,enclosure_thickness/2-0.10,cover_thickness);
lid2(enclosure_inner_length,enclosure_inner_width,enclosure_inner_depth,enclosure_thickness,enclosure_thickness/2+0.10,cover_thickness);

}

module screws(in_x, in_y, in_z, shell) {

	sx = in_x/2 - 4;
	sy = in_y/2 - 4;
	sh = shell + in_z - 12;
	nh = shell + in_z - 4;

translate([0,0,0]) {
    // hole in lid and box for screws
    //echo (sx);
	ra=-2.0; //rightadjustment
    // Top right
    if (part == "cover") {
     translate([sx+ra , sy, sh]) cylinder(r=1.5, h = 15, $fn=32); 
     //countersink for screwheads   
     translate([sx+ra , sy, sh]) cylinder(r=3.0, h = 12, $fn=32); 
    }else{
     translate([sx+ra , sy, sh]) cylinder(r=1.0, h = 15, $fn=32);    
    }    
	
    //Bottom Right
    
    if (part == "cover") {
     translate([sx+ra , -sy, sh ]) cylinder(r=1.5, h = 15, $fn=32);   
     translate([sx+ra , -sy, sh]) cylinder(r=3.0, h = 12, $fn=32); 
    }else{
     translate([sx+ra , -sy, sh ]) cylinder(r=1.0, h = 15, $fn=32);
    }    
	 la=-0.5; //leftadjustment
     //Top Left
    if (part == "cover") {
     translate([-sx+la , sy, sh ]) cylinder(r=1.5, h = 15, $fn=32);   
     translate([-sx+la , sy, sh]) cylinder(r=3.0, h = 12, $fn=32); 
    }else{
     translate([-sx+la , sy, sh ]) cylinder(r=1.0, h = 15, $fn=32);    
    }    
	
     //Bottom Left
    if (part == "cover") {
      translate([-sx+la , -sy, sh ]) cylinder(r=1.5, h = 15, $fn=32);   
      translate([-sx+la , -sy, sh]) cylinder(r=3.0, h = 12, $fn=32); 
    } else {
      translate([-sx+la , -sy, sh ]) cylinder(r=1.0, h = 15, $fn=32); 
    }    

    // Cutout for 4 mm nuts
	//translate([-sx , -sy, nh ]) rotate([0,0,-45]) 
	//	translate([-5.75/2, -5.6/2, -0.7]) cube ([5.75, 10, 2.8]);
	//translate([sx , -sy, nh ]) rotate([0,0,45]) 
	//	translate([-5.75/2, -5.6/2, -0.7]) cube ([5.75, 10, 2.8]);
	//translate([sx , sy, nh ]) rotate([0,0,90+45]) 
	//	translate([-5.75/2, -5.6/2, -0.7]) cube ([5.75, 10, 2.8]);
	//translate([-sx , sy, nh ]) rotate([0,0,-90-45]) 
	//	translate([-5.75/2, -5.6/2, -0.7]) cube ([5.75, 10, 2.8]);
}
}

module bottom(in_x, in_y, in_z, shell) {

	hull() {
   	 	translate([-in_x/2+shell, -in_y/2+shell, 0]) cylinder(r=shell*2,h=shell, $fn=32);
		translate([+in_x/2-shell, -in_y/2+shell, 0]) cylinder(r=shell*2,h=shell, $fn=32);
		translate([+in_x/2-shell, in_y/2-shell, 0]) cylinder(r=shell*2,h=shell, $fn=32);
		translate([-in_x/2+shell, in_y/2-shell, 0]) cylinder(r=shell*2,h=shell, $fn=32);
	}
}

module sides(in_x, in_y, in_z, shell) {
translate([0,0,shell])
difference() {

	hull() {
   	 	translate([-in_x/2+shell, -in_y/2+shell, 0]) cylinder(r=shell*2,h=in_z, $fn=32);
		translate([+in_x/2-shell, -in_y/2+shell, 0]) cylinder(r=shell*2,h=in_z, $fn=32);
		translate([+in_x/2-shell, in_y/2-shell, 0]) cylinder(r=shell*2,h=in_z, $fn=32);
		translate([-in_x/2+shell, in_y/2-shell, 0]) cylinder(r=shell*2,h=in_z, $fn=32);
	}

	hull() {
   	 	translate([-in_x/2+shell, -in_y/2+shell, 0]) cylinder(r=shell,h=in_z+1, $fn=32);
		translate([+in_x/2-shell, -in_y/2+shell, 0]) cylinder(r=shell,h=in_z+1, $fn=32);
		translate([+in_x/2-shell, in_y/2-shell, 0]) cylinder(r=shell,h=in_z+1, $fn=32);
		translate([-in_x/2+shell, in_y/2-shell, 0]) cylinder(r=shell,h=in_z+1, $fn=32);
	}
}

intersection() {
	translate([-in_x/2, -in_y/2, shell]) cube([in_x, in_y, in_z+2]);

	union() {
	//translate([-in_x/2 , -in_y/2,shell + in_z -6]) cylinder(r=9, h = 6, $fn=64);
	//translate([-in_x/2 , -in_y/2,shell + in_z -10]) cylinder(r1=3, r2=9, h = 4, $fn=64);

    translate([-in_x/2 , -in_y/2,shell + in_z -2.5]) cylinder(r=9, h = 2.3, $fn=64);
	translate([-in_x/2 , -in_y/2,shell + in_z -6.5]) cylinder(r1=3, r2=9, h = 4, $fn=64);
	
     translate([in_x/2 , -in_y/2, shell + in_z -2.5]) cylinder(r=9, h = 2.3, $fn=64);
	translate([in_x/2 , -in_y/2, shell + in_z -6.5]) cylinder(r1=3, r2=9, h = 4, $fn=64);

	translate([in_x/2 , in_y/2,  shell + in_z -2.5]) cylinder(r=9, h = 2.3, $fn=64);
	translate([in_x/2 , in_y/2,  shell + in_z -6.5]) cylinder(r1=3, r2=9, h = 4, $fn=64);

	translate([-in_x/2 , in_y/2, shell + in_z -2.5]) cylinder(r=9, h = 2.3, $fn=64);
	translate([-in_x/2 , in_y/2, shell + in_z -6.5]) cylinder(r1=3, r2=9, h = 4, $fn=64);
	}

}
}

module lid_top_lip2(in_x, in_y, in_z, shell, top_lip, top_thickness) {

	cxm = -in_x/2 - (shell-top_lip);
	cxp = in_x/2 + (shell-top_lip);
	cym = -in_y/2 - (shell-top_lip);
	cyp = in_y/2 + (shell-top_lip);

	translate([0,0,shell+in_z])
    //translate([0,0,0])

difference() {

	hull() {
   	 	translate([-in_x/2+shell, -in_y/2+shell, 0]) cylinder(r=shell*2,h=top_thickness, $fn=32);
		translate([+in_x/2-shell, -in_y/2+shell, 0]) cylinder(r=shell*2,h=top_thickness, $fn=32);
		translate([+in_x/2-shell, in_y/2-shell, 0]) cylinder(r=shell*2,h=top_thickness, $fn=32);
		translate([-in_x/2+shell, in_y/2-shell, 0]) cylinder(r=shell*2,h=top_thickness, $fn=32);
	}

	
	translate([0, 0, -1]) linear_extrude(height = top_thickness + 2) polygon(points = [
		[cxm+5, cym],
		[cxm, cym+5],
		[cxm, cyp-5],
		[cxm+5, cyp],
		[cxp-5, cyp],
		[cxp, cyp-5],
		[cxp, cym+5],
		[cxp-5, cym]]);
}
}

module lid2(in_x, in_y, in_z, shell, top_lip, top_thickness) {

	cxm = -in_x/2 - (shell-top_lip);
	cxp = in_x/2 + (shell-top_lip);
	cym = -in_y/2 - (shell-top_lip);
	cyp = in_y/2 + (shell-top_lip);	

difference() {
	//translate([0, 0,in_z+shell]) linear_extrude(height = 
    translate([0, 0,0]) linear_extrude(height =
    top_thickness ) polygon(points = [
		[cxm+5, cym],
		[cxm, cym+5],
		[cxm, cyp-5],
		[cxm+5, cyp],
		[cxp-5, cyp],
		[cxp, cyp-5],
		[cxp, cym+5],
		[cxp-5, cym]]);
		

		//screws(in_x, in_y, in_z, shell);
        screws(in_x, in_y, 0, shell);
        
        // cutout screen view hole
        translate([-57.0, -37.5,-1])
        cube([113,71,6]);
    
        // cutout screen recess
        translate([-61.1, -38.75,.5])
        cube([119.2,78,5]);
       
              
        // cutout for pin heads
        translate([58.75, -30.0,1.5])
        cube([6.0,60,4]);
        
      // cutout for ribbon cable
         translate([20.5, 38.75,.5])
         cube([20,2,5]);
	
}
}

module box2(in_x, in_y, in_z, shell, top_lip, top_thickness) {
	bottom(in_x, in_y, in_z, shell);
	difference() {
		sides(in_x, in_y, in_z, shell);
		screws(in_x, in_y, in_z, shell);
	}
	lid_top_lip2(in_x, in_y, in_z, shell, top_lip, top_thickness);
}



