'MMEDIT!!! Basic Version = Micromite_Plus_V5.2
'MMEDIT!!! Port = COM9:38400:30,150
'MMEDIT!!! Device = MicroMite
'MMEDIT!!! Config = 100111100121010011100002010011
﻿'Weather Station LCD Codef V1.0, Lewis G1RUN'''''''''''''''''''''''''''''''''''''''''
'Thanks to Geoffg(GPS CODE), Matherp, WhiteWizzard, Microblocks, MikeO''''''''
'and everyone else who helped me in getting the code working''''''''''''''''''
'Sorry if I have missed anyones name out but please accept my thanks here'''''

'Updates to make gauges work G.A.09/01/2017
'This is code originally posted by Lewis modified mainly in the area of getting the gauges to work
' Touch is now interupt driving.
' Gauges are at a first cut.
' Two gauge sets which operate indpendantly. One set is in the first 1/4 of the screen
' the second set is on the last 3/4. They sets can be refresh and written independantly.

' Added diagnostic screen which is access by touch screen 3 times within 3 seconds.
' GPSConnected=1 will expected a GPS connected on COM1
' GPSConnected=0 will expect HC-12 on COM1
' messages expected: 
'                   STXW1...................... 
'                   STXW2.............................  etc


'*to fix *************************
' heavy intensity rain
'********************************************



' Commands for setting up the E100 board
'OPTION SDCARD 47
'OPTION LCDPANEL SSD1963_5,L
'OPTION TOUCH 01,40
'OPTION TOUCH 01,40,39   'with piezo
'OPTION RTC 67,66        'with auto set of time from RTC
'GUI CALIBRATE
OPTION EXPLICIT

DIM INTEGER GPSConnected
GPSConnected=0    ' If outdoor Unit connected to COM1 via HC-12
'GPSConnected=1    ' If GPS connected to COM1


'Turn on the backlight if required.
'See if its one of the SSD1963 screens
if peek(byte peek(word &H9D000090) + 20) < 7  and peek(byte peek(word &H9D000090) + 20) > 0 then 
   BACKLIGHT 30
endif
'Set CPU speed to match your chip
'CPU 100
'*************************** generates some values to exercise the gauges ***********************************
dim integer counter=0
DIM integer d3=0,d4=0,d5=500,d6=0,d7=0,d8=0,d9=30,increment=5,updatedials=0
Settick 3000 ,SetValues,4    'establish seconds "Tick Timer" 
'***************************************************************************************************************

' Touch is not interupt driven
GUI INTERRUPT PenDown
'
Dim integer ActivePage,ChangePage=0
DIM INTEGER ShowPage3=0

const SD_CS_PIN = 47 'Connection to CS on SD card 
'const pausetime = 3 'pause between pics in seconds 
const mount=0  
const fileopen=1  
const readfile=2  
const writefile=3  
const opendir=4  
const readdir=5  
dim float temp,humidity
HUMID 59, temp, humidity  
SETPIN 97, DOUT            '1/4 hour chime
SETPIN 96, DOUT            '2/4 hour chime 
SETPIN 95, DOUT            '13/4 hour chime 
SETPIN 92, DOUT            '4/4 hour chime 
SETPIN 91, DOUT            'Hour chime 
SETPIN 90, DOUT            'Long Hour chime 
PIN(97) = 1                'Chime off
PIN(96) = 1                'Chime off  
PIN(95) = 1                'Chime off   
PIN(92) = 1                'Chime off  
PIN(91) = 1                'Chime off  
PIN(90) = 1                'Chime off  
dim pics$(200) length 18, s$ length 18 
DIM STRING ICON$ , ICON1$, ICON2$ , ICON3$ , ICON4$, speed0$, speed1$, speed2$, speed3$, speed4$
DIM STRING DESC0$ , DESC1$, DESC2$, DESC3$, DESC4$,  mint1$, mint2$, mint3$, mint4$, maxt1$, maxt2$, maxt3$, maxt4$
DIM STRING DESC1a$, DESC2a$, DESC3a$, DESC4a$
DIM STRING DESC1b$, DESC2b$, DESC3b$, DESC4b$
DIM STRING dir0$,dir1$,dir2$,dir3$
DIM STRING gps$,stx$,stxw1$,stxw2$,stxw3$,stxw4$,stxbad$

DIM STRING TEMP0$, press0$, press1$, press2$, press3$, press4$, hum0$, hum1$, hum2$, hum3$, hum4$
DIM STRING  Direction$, Direction1$, Direction2$
DIM INTEGER YEAR,month,day,a,m,y,secs2
dim INTEGER pos1(3)=(0,270,140,30) 
dim INTEGER pos2(3)=(0,411,150,30) 
dim integer i,num=0 
DIM integer secs,mins,hours,first=1

'
Dim integer bufferwatch(500)
'buffer for dialset 0 
Const buffersizea = 2000
Dim integer buffa(buffersizea)
Dim integer nta=6 'Number of triangles being updated in dialset 0  4 for clock and 2 for raingauge
Dim integer xx0a(nta*2-1),yy0a(nta*2-1),xx1a(nta*2-1),yy1a(nta*2-1),xx2a(nta*2-1),yy2a(nta*2-1),tcola(nta*2-1)


'buffer for dialset 1 
Const buffersizeb = 3000
Dim integer buffb(buffersizeb)
Dim integer ntb=9 'Number of triangles being updated in dialset 1
Dim integer xx0b(ntb*2-1),yy0b(ntb*2-1),xx1b(ntb*2-1),yy1b(ntb*2-1),xx2b(ntb*2-1),yy2b(ntb*2-1),tcolb(ntb*2-1)

memory

Dim string DOW$(6) length 9
DIM INTEGER ArrayMax=25
DIM string FieldArray$(ArrayMax) 'Max number of fields recieved by serial port
'Settick 1000 ,L1,1    'establish seconds "Tick Timer"
'Settick 1000 ,L2,2    'establish seconds "Tick Timer"
Year=Val(Mid$(Date$,7,4)):Month=Val(Mid$(Date$,4,2)):Day=Val(Mid$(Date$,1,2))
ICON$  = "50d.ppm" : ICON1$  = "50d.ppm" : ICON2$  = "50d.ppm" : ICON3$  = "50d.ppm" 
DIM STRING day2$ = "xxx" ,day3$ = "xxx" , day4$ = "xxx"
'*****************************  Mount SD CARD *****************************************
 sdcard mount,SD_CS_PIN,4 'set up the chip select pin for the SDcard and SPI speed to maximum  
  '   reduce speed if too fast for your card
  '   "speed" controls how fast the SPI bus operates. If omitted the bus runs at 7.5MHz which should suit most SDHC cards. 
  '   Assuming the CPU is running at 100MHz, a parameter of 0 runs the bus at 25MHz which works for me on Class-10 cards. 
  '   Values in the range 0-fastest to 10-slowest should cater for any speed of card. The default if omitted is 2. 


'*********************************End of Inits**************************************
DOW$(0)="Sunday":DOW$(1)="Monday":DOW$(2)="Tuesday":DOW$(3)= "Wednesday"
DOW$(4)="Thursday":DOW$(5)="Friday":DOW$(6)="Saturday"

RTC GETTIME                                              'Get the time from the RTC
CLS RGB(63, 133, 195)                                                      'Clear the screen 
Font 1, 2 ' Set the default font
if GPSConnected=0 THEN
   Open "COM1:19200" As #1                               'Open port for HC-12 TX/RX  
ELSE   
    Open "COM1:9600" As #1                                 'Open port for GPS directly connected TX/RX   
END IF      
OPEN "COM2:9600" AS #2                                 'Open port for ESP8266

'secs=Val(Right$(Time$,2))
'mins=Val(Mid$(Time$,4,2))
'hours=Val(Left$(Time$,2))


'************** Left 200 Pixels of the Screen********************************
ActivePage=1
DisplayPicture "4.ppm",0,0                                 'Background Clock Image
TEXT 90 ,310, "Indoor", CM, 1, 2, RGB(BLACK), RGB(63, 133, 195) 
TEXT 70 ,350, "Humidity", CM, 1, 2, RGB(BLACK), RGB(70, 144, 205)
Text 130 ,380, "%" , CM, 1, 2, RGB(BLACK), RGB(70, 144, 205)

'*********************Remaining 600 pixels of Screen****************************
DisplayPicture "3.ppm",200,0   'Background Sky Image 
'**************Draw the switch at the top of the screen**************************
'Switch1                                                   'Display the switch

'Initialise dialset 0
hands(0,0,secs,mins,hours,82,100, 100)               ' SIZE of hands, position from left, position from top 
'bar_Raingauge(0,4,90,d9,20,445)
bar_RainGauge(0,4,0,d3,170,14,455,0,150,"mm",3)
'read current background into the secondhalf of the buffer a
i=triangles(nta, buffa() , tcola(nta), xx0a(nta), yy0a(nta), xx1a(nta), yy1a(nta), xx2a(nta), yy2a(nta))
Print "Read buffer is ",i/buffersizea*100,"% used"

'call page1 to set up the 2nd 3/4 of the screen and initialise the second gauge set.
page1

dim integer loc1last,loc1now,loc2last,loc2now,lastsecs

'**********************Start of Main Program**********************************
Do

    '***********************Check Serial Ports for Data*********************
    loc1last=loc1now
    loc1now=LOC(#1)    
    IF LOC(#1) > 0 THEN 
     pause 100
     SERIAL1             'If data in COM1 then GOSUB Serial1
    END IF
     
    loc2last=loc2now
    loc2now=LOC(#2)
    IF LOC(#2) > 0 THEN 
          pause 100
          SERIAL2            'If data in Com1 then GOSUB Serial2
    END IF  


  secs=Val(Right$(Time$,2))
  mins=Val(Mid$(Time$,4,2))
  hours=Val(Left$(Time$,2))
  if lastsecs<>secs then  
   lastsecs=secs
   
   
   
    ' Update dialset 0        
     hands(0,0,secs,mins,hours,82,100, 100)  ' SIZE of hands, position from left, position from top
     'bar(0,4,90,d9,20,445)
     bar_RainGauge(0,4,1,d3,170,14,455,0,150,"mm",3)
     i=triangles(nta*2, buffa() , tcola(), xx0a(), yy0a(), xx1a(), yy1a(), xx2a(), yy2a())
   if ActivePage=1 and  ChangePage=0 then
   ' Update dialset 1 
     dial(1,0,1,d4,82,320,124,-135,135,0,50,"MPH")        'speed
     dial(1,1,1,d5,82,518,125,-155,155,500,2000,"mb")    'pressure
     dial(1,2,1,d6,82,320,378,-135,135,0,50,"MPH")        'av speed
     dial(1,3,1,d7,82,511,383,-135,135,0,100,"Percent")       'humidity
     dial(1,4,1,d8,82,696,380,-180,180,0,360)    'direction
     bar_Thermometer(1,5,1,d9,145,646,185,-10,50,"",3)
     bar_Thermometer(1,7,1,d9,145,727,185,-10,50,"",3)
     i=triangles(ntb*2, buffb() , tcolb(), xx0b(), yy0b(), xx1b(), yy1b(), xx2b(), yy2b())
   end if
   
   'Print the diagnostic screen if required
   If ActivePage=3 and Changepage=0 Then
      TEXT 221,40, "Diagnostic Screen", LM, 1, 1, RGB(BLACK), RGB(white) 
      Text 221,60, Date$+" "+Time$, LM, 1, 1, RGB(BLACK), RGB(63, 133, 195)             'Print the Date
      if GPSConnected=1 THEN      
        TEXT 221,80, "Last GPS Message...", LM, 1, 1, RGB(BLACK), RGB(white) 
        TEXT 221,100, gps$, LM, 1, 1, RGB(BLACK), RGB(white) 
      END IF  
      if GPSConnected=0 THEN 
        TEXT 221,80, "Last Messages...", LM, 1, 1, RGB(BLACK), RGB(white) 
        TEXT 221,100, LEFT$(stxw1$+string$(80,32),80), LM, 1, 1, RGB(BLACK), RGB(white) 
        TEXT 221,120, LEFT$(stxw2$+string$(80,32),80), LM, 1, 1, RGB(BLACK), RGB(white) 
        TEXT 221,140, LEFT$(stxw3$+string$(80,32),80), LM, 1, 1, RGB(BLACK), RGB(white) 
        TEXT 221,160, LEFT$(stxw4$+string$(80,32),80), LM, 1, 1, RGB(BLACK), RGB(white)      
        TEXT 221,200, LEFT$(stxbad$+string$(80,32),80), LM, 1, 1, RGB(BLACK), RGB(white)   
      END IF        
   end if    
  
   Text 90,215, DOW$(DayOfWeek(Year, Month, Day)), CM, 1, 2, RGB(BLACK), RGB(63, 133, 195)   'Print the Day of week Under Big Ben
   Text 90,250, Date$, CM, 1, 2, RGB(BLACK), RGB(63, 133, 195)             'Print the Date
   Text 90,280, time$, CM, 1, 2, RGB(BLACK), RGB(63, 133, 195)             'Print the Date
   Text 80 ,380, Str$(humidity), CM, 1, 2, RGB(BLACK), RGB(70, 144, 205)   'Print the Humidity
  endif
  If ChangePage=1 then 
     If ActivePage=1 then 
       page1
     end if 
   
     If ActivePage=2 then 
       page2
     endif 
     
     IF ActivePage=3 Then
       page3
     END IF 
   
  End IF  


  'NEED TO PUT CODE HERE TO SHOW THE INDOOR TEMP HERE IN THE GRAPH ON THE "IN" THERMOMETER TOP RIGHT OF SCREEN*****

  If Time$ = "02:01" Then                               'AT 02:01 Sync clock with the RTC again (This will reset the clock on GMT/BST changover as well)
    RTC GETTIME
  END IF



Loop
'********************End of Main program loop *********************************************************
End
''**********************Subroutines and Function ****************************************
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Generate some values for the Gauge demo.
SUB SetValues
   showpage3=0
   if counter=11 then counter =0
   LOCAL d3values(10)=(0,1,5,5,20,40,50,80,100,125,150)
   LOCAL d4values(10)=(0,5,10,15,20,25,30,35,40,45,50)
   LOCAL d5values(10)=(500,600,700,900,1000,1020,1100,1150,1200,1500,2000)
   LOCAL d6values(10)=(0,5,10,15,20,25,30,35,40,45,50)
   LOCAL d7values(10)=(0,10,20,30,40,50,60,70,80,90,100)
   LOCAL d8values(10)=(0,30,60,90,150,180,210,240,270,330,360)
   LOCAL d9values(10)=(-10,-5,0,10,15,20,25,30,35,40,50)
     d3=d3values(counter)     
     d4=d4values(counter)
     d5=d5values(counter)
     d6=d6values(counter)
     d7=d7values(counter)
     d8=d8values(counter)
     d9=d9values(counter)
     counter=counter+1
END SUB


'Handle touch interupt. '***********************IF the Buttons are touched******************************** 
SUB PenDown
     
   IF Touch(X)>255 AND Touch(X)<(395) AND Touch(Y)>0 AND Touch(Y)< (30) THEN 'If Touch pressed
     ActivePage=1
     ChangePage=1                                       'GOSUB Page1 
   END IF    

   IF Touch(X)>396 AND Touch(X)<(546) AND Touch(Y)>0 AND Touch(Y)< (30) THEN 'If Touch pressed
     ActivePage=2
     ChangePage=1                                        'GOSUB Page2
   END IF
   showpage3=showpage3+1
      
   if showpage3=3 then
      ActivePage=3
      ChangePage=1
      showpage3=0
   Endif
   
'   if ActivePage=3 and GPSConnected=0 THEN 'DEBUG
'     if showpage3=0 then 'DEBUG
'       print #1, "STXW4,Hello,there" 'DEBUG
'     end if 'DEBUG
'     if showpage3=1 then 'DEBUG
'       print #1, "STXW2,Hello,there" 'DEBUG
'     end if 'DEBUG
'     if showpage3=2 then 'DEBUG
'       print #1, "STXW3,Hello,there" 'DEBUG
'     end if 'DEBUG
'     if showpage3=3 then 'DEBUG
'       print #1, "STXW1,Hello,there" 'DEBUG
'     end if 'DEBUG
'   end if 'DEBUG
   
   'print touch(x),touch(y)
end sub
''***************************************************************************************
'
'********************Sub to draw Gauge dial **************************
Sub dial(grp as INTEGER,dn as integer,mode as integer,value As float, size As integer, x As integer, y As integer,amin as float,amax as float,vmin as float,vmax as float,units as string)'Sub to draw dial needle
    Local integer x1,y1,x2,y2,x0,y0,i,s,t
    Local float angle=value*0.36
    if value<vmin then value=vmin
    if value>vmax then value=vmax
    angle=amin+((amax-amin)/(vmax-vmin))*(value-vmin)
    if units<>"" Then
        if mode=0 then text x,y+10,units,CT,1,2,RGB(BLACK),RGB(63,133,195)
        s=len(str$(vmax)):t=len(str$(vmax))
        if t>s then s=t  
        text x,y+45,str$(value,s,0),CT,1,2,RGB(BLACK),RGB(white)  
    end if
    'prepare the new triangle and save the old one
    rotatetriangle(grp,dn,RGB(BLACK),angle,x,y,-size/15,0,size/15,0,0,-size*0.9)
    'draw the centre of the dial
    Circle x,y, size\8, 0, , RGB(BLACK), RGB(BLACK))
    'Circle x,y, size\15, 0, , 0, 0
    'Circle x,y, size\20, 0, , RGB(gray), RGB(gray)
End Sub

'********************Sub to draw clock hands. i.e 3 dials **************************
Sub hands(grp as INTEGER,dn as integer,seconds As integer, minutes As integer,  hours As integer, size As integer, x As integer, y As integer)'Sub to draw hands of clock
    Local integer x1,y1,x2,y2,x0,y0,i
    Local float angle=seconds*6
    rotatetriangle(grp,dn+2,RGB(RED),angle,x,y,-3,50,3,50,-3,-size) 'make up the second hand with two triangles
    rotatetriangle(grp ,dn+3,RGB(RED),angle,x,y,3,-size,3,50,-3,-size*0.9)
    angle=minutes*6 + seconds/10
    rotatetriangle(grp ,dn,RGB(BLACK),angle,x,y,-size/15,0,size/15,0,0,-size*0.9)
    angle=hours*30 + minutes/2
    rotatetriangle(grp ,dn+1,RGB(BLACK),angle,x,y,-size/12,0,size/12,0,0,-size*0.7)
   
    Circle x,y, size\12, 0, , RGB(red), RGB(red))
    Circle x,y, size\15, 0, , 0, 0
    Circle x,y, size\20, 0, , RGB(gray), RGB(gray)
End Sub


'********************Sub to draw Rain Gauge **************************
'Consists of two triangle.
'The height increases proportional to the area(volume) held in the Gauge.
'The slope of the Gauge is 1 in 5. e.g width is 1/5 of height.
'Area=height*width=height*(height/5)
'Height is SQR(10*Area)

Sub bar_RainGauge(grp as INTEGER,dn as integer,mode as integer,value As float, size As integer, x As integer, y As integer,vmin as float,vmax as float,units as string,dsize as integer)'Sub to column
    Local integer x1,y1,x2,y2,x0,y0,i,width,height,temp
    Local float angle=0,scale  'horizontal    
    if value<vmin then value=vmin
    if value>vmax then value=vmax
    scale=size/SQR(10*(vmax-vmin))
    height=sqr(value*10)*scale
    width=height/5
    if units<>"" Then
        if mode=0 then text x+90,y+2,units,LT,1,2,RGB(BLACK),RGB(WHITE)
    end if  
    IF  dsize>0 then
        's=len(str$(vmax)):t=len(str$(vmax))
        'if t>s then s=t  
        text x+90,y+2,str$(value,dsize,0),RT,1,2,RGB(BLACK),RGB(white)  
    end if
    rotatetriangle(grp,dn,RGB(RED),angle,x,y,0,0,0,-2,height,0) 'make up Gauge with two triangles
    rotatetriangle(grp,dn+1,RGB(RED),angle,x,y,height,-width,0,-2,height,0)
    
End Sub

Sub bar_Thermometer(grp as INTEGER,dn as integer,mode as integer,value As float, size As integer, x As integer, y As integer,vmin as float,vmax as float,units as string,dsize as integer)'Sub to column
    Local integer x1,y1,x2,y2,x0,y0,i,height
    Local float angle=0,scale  'horizontal    
    if value<vmin then value=vmin
    if value>vmax then value=vmax
    height=size*(value-vmin)/(vmax-vmin)
    ' angle=amin+((amax-amin)/(vmax-vmin))*(value-vmin)
    
    if units<>"" Then
        if mode=0 then text x,y+45,units,CT,1,2,RGB(BLACK),RGB(WHITE)
    end if  
    IF  dsize>0 then
        's=len(str$(vmax)):t=len(str$(vmax))
        'if t>s then s=t  
        text x,y+45,str$(value,dsize,0),CT,1,2,RGB(BLACK),RGB(white)  
    end if
    rotatetriangle(grp,dn,RGB(RED),angle,x,y,-3,5,3,5,-3,-height) 'make up Gauge with two triangles
    rotatetriangle(grp,dn+1,RGB(RED),angle,x,y,3,-height,3,5,-3,-height)
    
End Sub

'********************Sub to draw parallel Gauge dial **************************
Sub bar(grp as INTEGER,dn as integer,angle As float, size As integer, x As integer, y As integer)'Sub to column
    Local integer x1,y1,x2,y2,x0,y0,i
    'Local float angle=value*0.36
    rotatetriangle(grp,dn,RGB(RED),angle,x,y,-3,5,3,5,-3,-size) 'make up column with two triangles
    rotatetriangle(grp,dn+1,RGB(RED),angle,x,y,3,-size,3,5,-3,-size)
    'angle=minutes*6 + seconds/10
    'rotatetriangle(dn,RGB(BLACK),angle,x,y,-size/15,0,size/15,0,0,-size*0.9)
    'angle=hours*30 + minutes/2
    'rotatetriangle(1,RGB(BLACK),angle,x,y,-size/12,0,size/12,0,0,-size*0.7)
   
    'Circle x,y, 5, 0, , RGB(red), RGB(red))
    'Circle x,y, 4, 0, , 0, 0
    'Circle x,y, size\20, 0, , RGB(gray), RGB(gray)
End Sub


'******************functionto extract fields *****************************************************************
Function GetFieldArrays( Record$, Delimiter$, KeepQuotes )           'Function to get array from COM port
  Local Index, Char, InQuote, count     
  InQuote = 0     
  count = 0 
  FieldArray$(Count) = "" 
  If Delimiter$ = "" Then Delimiter$ = ","     
  For Index = 1 To Len(Record$)     
    Char = Asc(Mid$(Record$, Index, 1))     
    If Char = 34 Then InQuote = Not InQuote     
    If Not InQuote And Instr(Delimiter$, Chr$(char)) >= 1  Then     
      if count < ArrayMax  Then Count = Count + 1     
      FieldArray$(count) = "" 
    Else     
      If Char <> 34 Or KeepQuotes Then 
       FieldArray$(count) = FieldArray$(count) + Chr$(char) 
      EndIf     
    EndIf     
  Next     
  if count < ArrayMax THEN GetFieldArrays = count + 1     
End Function 


FUNCTION GetDirection(Dir As Integer) as String          'Function to change degrees to words for day2
   LOCAL Directions(15) AS STRING =("North","NNE","NE","ENE","East","ESE","SE","SSE","South","SSW","SW","WSW","West","WNW","NW","NNW") 
   GetDirection = Directions((INT(Dir /22.5 + 16.5) MOD 16)) 
END FUNCTION


FUNCTION GetDirection1(Dir1 As Integer) as String           'Function to change degrees to words for day3  
  LOCAL Directions1(15) AS STRING =("North","NNE","NE","ENE","East","ESE","SE","SSE","South","SSW","SW","WSW","West","WNW","NW","NNW") 
  GetDirection1 = Directions1((INT(Dir1 /22.5 + 16.5) MOD 16)) 
END FUNCTION


FUNCTION GetDirection2(Dir2 As Integer) as String           'Function to change degrees to words for day4
  LOCAL Directions2(15) AS STRING =("North","NNE","NE","ENE","East","ESE","SE","SSE","South","SSW","SW","WSW","West","WNW","NW","NNW") 
  GetDirection2 = Directions2((INT(Dir2 /22.5 + 16.5) MOD 16)) 
END FUNCTION


Function DayOfWeek(year AS INTEGER, month AS INTEGER, day AS INTEGER) AS INTEGER 'Day of Week Function
  a = Int((14-month)/12)
  m = month + 12*a - 2
  y = year - a
  DayOfWeek = (day + y + Int(y/4)-Int(y/100)+Int(y/400)+Int(31*m/12)) Mod 7
End Function



'******************************PAGE 1 Draw Left 200 Pixels of screen**************************************
SUB Page1   
       
   DisplayPicture "3.ppm",200,0                                               'Background Image
   Text 610 ,15, Str$(temp), CM, 1, 2, RGB(BLACK), RGB(48, 107, 167)          'Display the Indoor Temperature
   Text 660 ,15, "`C" , CM, 1, 2, RGB(BLACK), RGB(48, 107, 167)               'Display the C symbol
  
   Text 690 ,1, "     " , TR, 1, 2, RGB(BLACK), RGB(48, 107, 167))'clear the temp & °C symbol top right
   Text 800 ,1, "`C" , TR, 1, 2, RGB(BLACK), RGB(48, 107, 167))          'Display  the "°C" symbol top right
   Text 770 ,1, temp0$, TR, 1, 2, RGB(BLACK), RGB(48, 107, 167)          'Display the Outdoor Temperature top right 
   Switch1 
  
   
  'Initialise dialset 1
  dial(1,0,0,d4,82,320,124,-135,135,0,50,"MPH")        'speed
  dial(1,1,0,d5,82,518,125,-155,155,500,2000,"mb")    'pressure
  dial(1,2,0,d6,82,320,378,-135,135,0,50,"MPH")        'av speed
  dial(1,3,0,d7,82,511,383,-135,135,0,100,"Percent")       'humidity
  dial(1,4,0,d8,82,696,380,-180,180,0,360)    'direction
  bar_Thermometer(1,5,0,d9,145,646,185,-10,50,"",3)
  bar_Thermometer(1,7,0,d9,145,727,185,-10,50,"",3)
   
   'read current background into the secondhalf of the buffer b
    i=triangles(ntb, buffb() , tcolb(ntb), xx0b(ntb), yy0b(ntb), xx1b(ntb), yy1b(ntb), xx2b(ntb), yy2b(ntb))
    Print "Read buffer is ",i/buffersizeb*100,"% used"
   ChangePage=0   'ok to go on now
END SUB
'****************************End of Left 200 Pixels*********************************************


'************************* PAGE 2 Draw Remaining 600 Pixels of screen***********************************
SUB Page2                 'PAGE2
   
   'CLS RGB(63, 133, 195)     'Clear the screen to RGB(63, 133, 195) 
   BOX 200,0,600,600,1,RGB(63, 133, 195),RGB(63, 133, 195)
   'DisplayPicture "4.ppm",0,0                   'Background Clock Image
   TEXT 90 ,310, "Indoor", CM, 1, 2, RGB(BLACK), RGB(63, 133, 195) 
   TEXT 70 ,350, "Humidity", CM, 1, 2, RGB(BLACK), RGB(70, 144, 205)
   Text 130 ,380, "%" , CM, 1, 2, RGB(BLACK), RGB(70, 144, 205)
   TEXT 225, 10, day2$, CM, 1, 2, RGB(BLACK), RGB(63, 133, 195)           'day2
   TEXT 570, 10, day3$, CM, 1, 2, RGB(BLACK), RGB(63, 133, 195)           'day3
   TEXT 680, 10, day4$, CM, 1, 2, RGB(BLACK), RGB(63, 133, 195)           'day4
   BOX 200, 20, 200, 460, 1, RGB(WHITE), RGB(63, 133, 195)                'Draw the box for data
   BOX 400, 20, 200, 460, 1, RGB(WHITE), RGB(63, 133, 195)                'Draw the box for data
  BOX  600, 20, 200, 460, 1, RGB(WHITE), RGB(63, 133, 195)               'Draw the box for data
  Day2A                                                                  'Draw Pixels 201 - 400
  Day3A                                                                  'Draw Pixels 401 - 600
  Day4A                                                                  'Draw Pixels 601 - 800
  Switch1                                                                'Gosub Switch1 (Draw the switch)
  ChangePage=0   'ok to go on now
END SUB
'************************* PAGE 2 Draw Remaining 600 Pixels of screen***********************************
SUB Page3                 'PAGE3
   
   'CLS RGB(63, 133, 195)     'Clear the screen to RGB(63, 133, 195) 
   BOX 200,0,600,600,1,RGB(63, 133, 195),RGB(63, 133, 195)
   'DisplayPicture "4.ppm",0,0                   'Background Clock Image
                                                                'Draw Pixels 601 - 800
  Switch1                                                                'Gosub Switch1 (Draw the switch)
  ChangePage=0   'ok to go on now
END SUB

SUB Switch1                                                  'Draw the switch
  BOX 255, 0, 140, 30, 2,  RGB(white),RGB(brown)             'Left hand switch
  BOX 396, 0, 150, 30, 2,  RGB(white),RGB(brown)             'Right hand switch
  TEXT 325,15, "Weather", CM, 3, 1, RGB(CYAN), RGB(Blue)  
  TEXT 470,15, "Forecast", CM, 3, 1, RGB(CYAN), RGB(Blue) 
END SUB

' serial 1 ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
SUB SERIAL1                                                       'Com1 data
  Local F$                                                        'Get the data in arrays
  LOCAL N as INTEGER ,p as integer,q as integer
  if loc1now=loc1last then  ' data has stopped coming in, lets see what is was
    loc1last=0
    F$ = Input$(254, #1) 'Suck everything in buffer out
    
    IF GPSConnected=1 then  ' If we have the GPS directly connected to COM1
      ' ? F$ 
      p=INSTR(F$,"$GPRMC")
      if p>0 then     
       F$=mid$(F$,p)
       q=instr(F$,chr$(13)+chR$(10))
       if q>0 then
          F$=LEFT$(F$,q-1)                                      
          N = GetFieldArrays(F$)
          gps$=f$
       end if  
     end if 
    else    ' We have the Outdoor unit connected via HC-12 connected on COM1
        ? F$ 
        p=INSTR(F$,"STX")
        if p>0 then     
           F$=mid$(F$,p)
           q=instr(F$,chr$(13)+chR$(10))
           if q>0 then
              F$=LEFT$(F$,q-1)                                      
              N = GetFieldArrays(F$)
              stx$=f$
              SELECT CASE FieldArray$(0)
                 CASE "STXW1" 
                   DOSTXW1(N)
                 CASE "STXW2" 
                   DOSTXW2(N)
                 CASE "STXW3"
                     DOSTXW3(N)
                  CASE "STXW4" 
                    DOSTXW4(N)
                 CASE ELSE
                   stxbad$=F$ + " "+Time$   
              END SELECT      
           end IF   
       else
            stxbad$=F$ + " "+Time$       
       end if 
    END IF   
  end if                           
END SUB

' Proocess each message 
SUB DOSTXW1(fieldmax as integer)
  ? str$(fieldmax)+" - " + stx$
  stxw1$=str$(fieldmax)+" - " + stx$+ " "+Time$
END SUB

SUB DOSTXW2 (fieldmax as integer)
  ? str$(fieldmax)+" - " + stx$
   stxw2$=str$(fieldmax)+" - " + stx$+ " "+Time$
end sub

SUB DOSTXW3 (fieldmax as integer)
  ? str$(fieldmax)+" - " + stx$
   stxw3$=str$(fieldmax)+" - " + stx$+ " "+Time$
end sub 

SUB DOSTXW4 (fieldmax as integer)
  ? str$(fieldmax)+" - " + stx$
   stxw4$=str$(fieldmax)+" - " + stx$+ " "+Time$
end sub


' serial 2 ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

SUB SERIAL2                                                       'Com2 ESP8266 Weather Forecast
  Local F$                                                        'Get the data in arrays
  LOCAL N as INTEGER 
  if loc2now=loc2last then
    loc2last=0
    F$ = Input$(254, #2)                                            'Suck everything in buffer out
    print F$
    N = GetFieldArrays(F$)
    IF FieldArray$(0) = "Today" THEN T1                             'If the 1st array is "Today" then GOSUB T1
    IF FieldArray$(0) = "Day2" and FieldArray$(2)<>"not found" THEN T2   'If the 1st array is "Day2" then GOSUB T2
    IF FieldArray$(0) = "Day3" and FieldArray$(2)<>"not found" THEN T3   'If the 1st array is "Day3" then GOSUB T3
    IF FieldArray$(0) = "Day4" and FieldArray$(2)<>"not found" THEN T4   'If the 1st array is "Day4" then GOSUB T4
  ENDIF                              
  
 End Sub  
 
 FUNCTION getleft(a$ as string) AS STRING
    LOCAL p as integer
    p=instr(a$," ")
    if p>0 then 
     getleft="  "+left$(a$,p-1)+"  "
    else
      getleft="  "+ a$+"  "
    endif 
 
 end FUNCTION
 
FUNCTION getright(a$ as string) AS STRING
    LOCAL p as integer
    p=instr(a$," ")
    if p>0 then 
     getright="  "+MID$(a$,p+1)+"  "
    else
      getright="              "
    endif 
end FUNCTION
 
'**************************************Today************************************
SUB T1   'T1  Today
  desc0$ = FieldArray$(1)
  temp0$ = FieldArray$(3)
  press0$ = FieldArray$(4)
  hum0$ = FieldArray$(7)
  speed0$ = FieldArray$(5)
  dir0$ = FieldArray$(6)
  ICON$ = FieldArray$(2)
  if INSTR("01d.01n.02d.02n.03d.03n.04d.04n.09d.09n.10d.10n.11d.11n.13d.13n.50d.50n",ICON$) then   
   ICON$=ICON$+".ppm"
  else
   ICON$  = "50d.ppm" 
  ENDIF

   Text 690 ,1, "     " , TR, 1, 2, RGB(BLACK), RGB(48, 107, 167))'clear the temp & °C symbol top right
   Text 800 ,1, "`C" , TR, 1, 2, RGB(BLACK), RGB(48, 107, 167))          'Display  the "°C" symbol top right
   Text 770 ,1, temp0$, TR, 1, 2, RGB(BLACK), RGB(48, 107, 167)          'Display the Outdoor Temperature top right 
   Text 610 ,15, Str$(temp), CM, 1, 2, RGB(BLACK), RGB(48, 107, 167)          'Display the Indoor Temperature
   Text 660 ,15, "`C" , CM, 1, 2, RGB(BLACK), RGB(48, 107, 167)               'Display the C symbol
   Text 80 ,380, "      ", CM, 1, 2, RGB(BLACK), RGB(70, 144, 205) ' Clear Humidity
   Text 80 ,380, hum0$, CM, 1, 2, RGB(BLACK), RGB(70, 144, 205) ' Update Humidity bottom right screen
  
  '****************Display Weather ICON on the left of the Screen***************
   DisplayPicture ICON$ , 150 , 340                                    'Display Today's Weather ICON
END SUB 
'********************************End of Today*************************************************




'**********************************Tomorrow***************************************************
SUB T2                                     'T2 Tomorrow
  
  ICON1$ = FieldArray$(3)                    'ICON
  desc1$ = FieldArray$(2)                    'DESCRIPTION
  desc1a$=getleft(desc1$)
  desc1b$=getright(desc1$)
  mint1$ = FieldArray$(4)                    'MIN-TEMP
  maxt1$ = FieldArray$(5)                    'MAX-TEMP
  press1$ = FieldArray$(6)                   'PRESSURE
  press1$=str$(val(press1$),4,0)
  hum1$ = FieldArray$(7)                     'HUMIDITY
  hum1$=str$(val(hum1$),3,0)
  speed1$ = FieldArray$(8)                   'WIND SPEED
  dir1$ = FieldArray$(9)                      'WIND DIRECTION
  day2$ = LEFT$(FieldArray$(1), 3)           'DAY THE FORECAST RELATES TO
 'SELECT THE CORRECT ICON FOR TODAY 
  if INSTR("01d.01n.02d.02n.03d.03n.04d.04n.09d.09n.10d.10n.11d.11n.13d.13n.50d.50n",ICON1$) then   
   ICON1$=ICON1$+".ppm"
  else
   ICON1$  = "50d.ppm" 
  ENDIF
  'Refresh if page 2 active
  if ActivePage=2 then Day2A
END SUB



SUB Day2A      ' Sub to display text for Tomorrow on Page2
   Direction$ = getDirection(INT(VAL(dir1$)))
   DisplayPicture ICON1$ , 280 , 35
   TEXT 302,95, desc1a$ , C, 1, 2, RGB(BLACK), RGB(63, 133, 195)           'description
   TEXT 302,120, desc1b$ , C, 1, 2, RGB(BLACK), RGB(63, 133, 195)           'description
   
   TEXT 202,170, "Tmin" , L, 1, 2, RGB(BLACK), RGB(63, 133, 195) 
   TEXT 282,170, mint1$ , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)              'minimum temp
   TEXT 360,170, "`C" , L, 1, 2, RGB(BLACK), RGB(63, 133, 195) 
   
   TEXT 202,228, "Tmax" , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)
   TEXT 282,228, maxt1$ , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)             'max temp
   TEXT 360,228, "`C" , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)
   
   TEXT 202,288, "Pres" , L, 1, 2, RGB(BLACK), RGB(63, 133, 195) 
   TEXT 282,288, press1$ , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)           'press
   TEXT 348,288, " mb" , L, 1, 2, RGB(BLACK), RGB(63, 133, 195) 
   
   TEXT 202,348, "Humidity" , L, 1, 2, RGB(BLACK), RGB(63, 133, 195) 
   TEXT 330,348,hum1$,L,1,2,RGB(BLACK),RGB(63, 133, 195)          'humidity
   TEXT 396,348, "%" , R, 1, 2, RGB(BLACK), RGB(63, 133, 195) 
  '? hum1$   
   TEXT 202,408, "Wind" , L, 1, 2, RGB(BLACK), RGB(63, 133, 195) 
   TEXT 282,408, speed1$,L,1,2, RGB(BLACK), RGB(63, 133, 195)           'speed
   TEXT 396,408, "MPH" , R, 1, 2, RGB(BLACK), RGB(63, 133, 195) 
   
   TEXT 202,450, "Dir" , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)
   TEXT 282,450, dir1$, L, 1, 2, RGB(BLACK), RGB(63, 133, 195)            'direction
   TEXT 396,450, Direction$, R, 1, 2, RGB(BLACK), RGB(63, 133, 195)
End SUB
'******************End of Tomorrow*********************************************


'***************************Day after Tomorrow********************************

SUB T3                                    'T3 DAY AFTER TOMORROW
   ICON2$ = FieldArray$(3)                    'ICON
   desc2$ = FieldArray$(2)                    'DESCRIPTION
   desc2a$=getleft(desc2$)
   desc2b$=getright(desc2$)
   mint2$ = FieldArray$(4)                    'MIN-TEMP
   maxt2$ = FieldArray$(5)                    'MAX-TEMP
   press2$ = FieldArray$(6)                   'PRESSURE
   press2$=str$(val(press2$),4,0)
   hum2$ = FieldArray$(7)                     'HUMIDITY
   hum2$=str$(val(hum2$),3,0)
   speed2$ = FieldArray$(8)                   'WIND SPEED
   dir2$ = FieldArray$(9)                     'WIND DIRECTION
  day3$ = LEFT$(FieldArray$(1), 3)           'DAY THE FORECAST RELATES TO
  'SELECT THE CORRECT ICON FOR TODAY 
  if INSTR("01d.01n.02d.02n.03d.03n.04d.04n.09d.09n.10d.10n.11d.11n.13d.13n.50d.50n",ICON2$) then   
   ICON2$=ICON2$+".ppm"
  else
   ICON2$  = "50d.ppm" 
  ENDIF
  'Refresh if page 2 active
  if ActivePage=2 then Day3A
END SUB


SUB Day3A   ' Sub to display text for Day after Tomorrow on Page2
   Direction1$ = getDirection1(INT(VAL(dir2$)))
   DisplayPicture ICON2$,480,35
   TEXT 502,95,desc2a$,C,1,2,RGB(BLACK),RGB(63,133,195)           'description
   TEXT 502,120,desc2b$,C,1,2,RGB(BLACK),RGB(63,133,195)           'description
   
   TEXT 402,170,"Tmin",L,1,2,RGB(BLACK),RGB(63, 133, 195) 
   TEXT 482,170,mint2$,L,1,2,RGB(BLACK),RGB(63, 133, 195)              'minimum temp
   TEXT 560,170,"`C",L,1,2,RGB(BLACK),RGB(63, 133, 195) 
   
   TEXT 402,228,"Tmax",L,1,2,RGB(BLACK),RGB(63, 133, 195)
   TEXT 482,228,maxt2$,L, 1, 2, RGB(BLACK), RGB(63, 133, 195)             'max temp
   TEXT 560,228,"`C", L, 1, 2, RGB(BLACK), RGB(63, 133, 195)
   
   TEXT 402,288,"Pres", L, 1, 2, RGB(BLACK), RGB(63, 133, 195) 
   TEXT 482,288,press2$,L, 1, 2, RGB(BLACK), RGB(63, 133, 195)           'press
   TEXT 596, 288," mb", R, 1, 2, RGB(BLACK), RGB(63, 133, 195) 
      
   TEXT 402,348,"Humidity", L, 1, 2, RGB(BLACK), RGB(63, 133, 195) 
   TEXT 530,348,hum2$,L, 1, 2, RGB(BLACK), RGB(63, 133, 195)          'humidity
   TEXT 596,348,"%",R,1,2, RGB(BLACK), RGB(63, 133, 195) 
   ' ? hum2$  
   TEXT 402,408,"Wind", , 1, 2, RGB(BLACK), RGB(63, 133, 195) 
   TEXT 482,408,speed2$,L, 1, 2, RGB(BLACK), RGB(63, 133, 195)           'speed
   TEXT 596,408,"MPH", R, 1, 2, RGB(BLACK), RGB(63, 133, 195) 
   
   TEXT 402,450,"Dir",L,1,2,RGB(BLACK),RGB(63, 133, 195)
   TEXT 482,450,dir2$,L,1,2, RGB(BLACK),RGB(63, 133, 195)            'direction
   TEXT 596,450,Direction1$,R, 1, 2, RGB(BLACK), RGB(63, 133, 195)
END SUB
'**************************End of Day after Tomorrow*****************************



'*******************************3 Days Time****************************************
SUB T4                                    'T2 3 DAYS TIME
  ICON3$ = FieldArray$(3)                    'ICON
  desc3$ = FieldArray$(2)                    'DESCRIPTION
  desc3a$=getleft(desc3$)
  desc3b$=getright(desc3$)
  mint3$ = FieldArray$(4)                    'MIN-TEMP
  maxt3$ = FieldArray$(5)                    'MAX-TEMP
  press3$ = FieldArray$(6)                   'PRESSURE
  press3$=str$(val(press3$),4,0)
  hum3$ = FieldArray$(7)                     'HUMIDITY
  hum3$=str$(val(hum3$),3,0)
  speed3$ = FieldArray$(8)                   'WIND SPEED
  dir3$ = FieldArray$(9)                     'WIND DIRECTION
  day4$ = LEFT$(FieldArray$(1), 3)           'DAY THE FORECAST RELATES TO
'SELECT THE CORRECT ICON FOR TODAY 
  if INSTR("01d.01n.02d.02n.03d.03n.04d.04n.09d.09n.10d.10n.11d.11n.13d.13n.50d.50n",ICON3$) then   
   ICON3$=ICON3$+".ppm"
  else
   ICON3$  = "50d.ppm" 
  ENDIF
  'Refresh if page 2 active
  if ActivePage=2 then Day4A
END SUB

SUB DAY4A       ' Sub to display text for 3rd day from now on Page2
   
   Direction2$ = getDirection2(INT(VAL(dir3$)))
   DisplayPicture ICON3$,680,35  
   TEXT 702,95,desc3a$,C,1,2,RGB(BLACK),RGB(63,133,195)           'description
   TEXT 702,120,desc3b$,C,1,2,RGB(BLACK),RGB(63,133,195)           'description
   
   TEXT 602,170,"Tmin",L,1,2,RGB(BLACK),RGB(63,133,195) 
   TEXT 682,170, mint3$ , L, 1, 2, RGB(BLACK), RGB(63,133,195)              'minimum temp
   TEXT 760,170,"`C",L,1,2,RGB(BLACK),RGB(63,133,195) 
   
   TEXT 602,228,"Tmax",L,1,2,RGB(BLACK),RGB(63,133,195)
   TEXT 682,228,maxt3$,L,1,2,RGB(BLACK),RGB(63,133,195)             'max temp
   TEXT 760,228,"`C",L,1,2,RGB(BLACK),RGB(63,133,195)
   
   TEXT 602,288, "Pres",L,1,2,RGB(BLACK),RGB(63,133,195) 
   TEXT 682,288,press3$,L,1,2,RGB(BLACK),RGB(63,133,195)           'press
   TEXT 796, 288, " mb" , R, 1, 2, RGB(BLACK), RGB(63, 133, 195) 
   
   TEXT 602,348,"Humidity",L,1,2,RGB(BLACK),RGB(63,133,195) 
   TEXT 730,348,hum3$,L,1,2,RGB(BLACK),RGB(63,133,195)          'humidity
   TEXT 796,348,"%",R,1,2,RGB(BLACK),RGB(63,133,195) 
   ' ? hum3$  
   TEXT 602,408,"Wind",L,1,2,RGB(BLACK),RGB(63,133,195) 
   TEXT 682,408,speed3$, L,1,2,RGB(BLACK),RGB(63,133,195)           'speed
   TEXT 796,408,"MPH",R,1,2,RGB(BLACK),RGB(63,133,195) 
   
   TEXT 602,450,"Dir",L,1,2, RGB(BLACK),RGB(63,133,195)
   TEXT 682,450,dir3$,L,1,2, RGB(BLACK),RGB(63,133,195)            'direction
   TEXT 796,450,Direction2$,R,1,2,RGB(BLACK),RGB(63,133,195)
END SUB
'*******************************End of 3 Day's time***************************************





Sub DisplayPicture(PIC$, StartX%, StartY%) 
  'text startx%,starty%,pic$
  'exit SUB
     
  LOCAL Buffer$,addbuffer$ length 3    
  LOCAL Result%=-1    
  LOCAL NumBytes%,a%,i%   
  local integer buff(511)  
 
  SDcard fileopen,PIC$  
  'Read the first 128 bytes    
  Buffer$=STRING$(128," ")    
  SDcard readfile,buffer$,0,len(buffer$),NumBytes%  
  a%=instr(buffer$,chr$(10)) ' look for the first CR    
  if left$(buffer$,a%-1)="P6" then     
      buffer$=right$(buffer$,len(buffer$)-a%)  
      if left$(buffer$,1)="#" then   
        a%=instr(buffer$,chr$(10)) ' look for the second CR    
        buffer$=right$(buffer$,len(buffer$)-a%)    
      endif 
      a%=instr(buffer$,chr$(32)) ' look for the space between dimensions    
      local width%=val(left$(buffer$,a%-1))    
      buffer$=right$(buffer$,len(buffer$)-a%)    
      a%=instr(buffer$,chr$(10)) ' look for the third CR    
      LOCAL height%=val(left$(buffer$,a%-1))    
      buffer$=right$(buffer$,len(buffer$)-a%)    
      a%=instr(buffer$,chr$(10)) ' look for the fourth CR    
      buffer$=right$(buffer$,len(buffer$)-a%)    
      a%=len(buffer$) mod 3    
      addBuffer$=STRING$(3-a%," ") ' we need to make sure we have a number of bytes divisible by three in the buffer    
      SDcard readfile,addbuffer$,-1,len(addbuffer$),NumBytes%   
      buffer$=buffer$+addbuffer$          
      if (StartX%+width%>MM.HRES) OR (StartY%+height%>MM.VRES) then     
          print pic$," too big", width%," x",height%    
      else   
          defineregionSSD StartX%, StartY%, width%, height% 
          DisplayBufferSSD Buffer$    
          do    
              SDcard readfile,buff(),-1,4095,NumBytes%   
              if numbytes%<>0 then DisplayBufferSSD Buff(),numbytes%   
          loop while NumBytes%<>0   
      endif    
  else    
     Print "Invalid File Format"    
  endif   
     
end sub

'*********************************************Enf of .ppm Sub





Sub rotatetriangle(grp as INTEGER,n As integer, col As integer, angle As float, x As integer, y As integer, x0 As integer, y0 As integer, x1 As integer, y1 As integer, x2 As integer, y2 As integer)
   Local float sine=Sin(Rad(angle)),cosine=Cos(Rad(angle))
   Local integer x0a,y0a,x1a,y1a,x2a,y2a
   x0a= x0*cosine - y0 * sine + x
   y0a= y0*cosine + x0 * sine + y
   x1a= x1*cosine - y1 * sine + x
   y1a= y1*cosine + x1 * sine + y
   x2a= x2*cosine - y2 * sine + x
   y2a= y2*cosine + x2 * sine + y
   if grp=0 then
     xx0a(n)=xx0a(n+nta)
     yy0a(n)=yy0a(n+nta)
     xx1a(n)=xx1a(n+nta)
     yy1a(n)=yy1a(n+nta)
     xx2a(n)=xx2a(n+nta)
     yy2a(n)=yy2a(n+nta)
     xx0a(n+nta)=x0a
     yy0a(n+nta)=y0a
     xx1a(n+nta)=x1a
     yy1a(n+nta)=y1a
     xx2a(n+nta)=x2a
     yy2a(n+nta)=y2a
     tcola(n)=-1
     tcola(n+nta)=col
    ELSEif grp=1 then
     xx0b(n)=xx0b(n+ntb)
     yy0b(n)=yy0b(n+ntb)
     xx1b(n)=xx1b(n+ntb)
     yy1b(n)=yy1b(n+ntb)
     xx2b(n)=xx2b(n+ntb)
     yy2b(n)=yy2b(n+ntb)
     xx0b(n+ntb)=x0a
     yy0b(n+ntb)=y0a
     xx1b(n+ntb)=x1a
     yy1b(n+ntb)=y1a
     xx2b(n+ntb)=x2a
     yy2b(n+ntb)=y2a
     tcolb(n)=-1
     tcolb(n+ntb)=col
   end if
End Sub   


'*************Matherp's subs and CFUNCTIONS to draw clock and .ppm pictures****************


sub mm.startup 
   setrd(6)' set up the read pin 
end sub 

Csub setrd 
    00000000 
    27BDFFE8 AFBF0014 AFB00010 3C109D00 8C830000 8E020090 24050008 00003021  
    A043002D 8E030090 8E020010 0040F809 8064002D 8E030090 8E020010 24050065  
    8064002D 0040F809 00003021 8E030090 8E02001C 24050006 0040F809 8064002D  
    8FBF0014 8FB00010 03E00008 27BD0018  
End Csub


CFunction triangles '100-pin  August 2016   fix 4.3 screens and 120MHz CPU
    00000286
    'defineregion
    3C029D00 8C430090 24080100 3C02BF88 AC486434 80620015 2489FFFF 24A8FFFF 
    01264821 24060001 10460004 01074021 24060003 54460005 80630014 00805821 
    01205021 10000013 01002021 24020001 14620009 3C029D00 8C420094 01005021 
    00A05821 8C480000 2508FFFF 01092823 10000008 01042023 8C420094 01005821 
    00A05021 8C480000 2508FFFF 01092823 01042023 000B6202 000A4A02 3C02BF88 
    24030200 24060100 00054202 00043A02 35290300 358C0300 356B0300 240D022A 
    AC4D6430 354A0300 AC436434 35080300 AC436438 34A50300 AC466438 34E70300 
    AC4C6430 34840300 AC436434 AC436438 AC4B6430 AC436434 AC436438 AC496430 
    2409022B AC436434 AC436438 AC4A6430 AC436434 AC436438 AC466434 AC496430 
    AC436434 AC436438 AC466438 AC486430 AC436434 AC436438 AC456430 AC436434 
    AC436438 AC476430 AC436434 AC436438 AC446430 AC436434 AC436438 03E00008 
    00000000 
    'writeRectangle
    27BDFFD8 AFB40020 AFB3001C 00C0A021 00E09821 72749802 AFB00010 8FB00038 
    AFB20018 AFB10014 00109403 00108A03 AFBF0024 0411FF99 00000000 3C02BF88 
    24030100 24040200 2405022C AC436434 36520300 AC456430 36310300 AC446434 
    36100300 AC446438 AC436438 1260000F 2673FFFF 24030200 2404FFFF 2673FFFF 
    AC526430 AC436434 AC436438 AC516430 AC436434 AC436438 AC506430 AC436434 
    AC436438 1664FFF6 2673FFFF 8FBF0024 8FB40020 8FB3001C 8FB20018 8FB10014 
    8FB00010 03E00008 27BD0028 
    'ReadRectangle
    27BDFFC8 AFBF0034 AFBE0030 AFB7002C AFB60028 AFB50024 AFB40020 AFB3001C 
    AFB20018 3C139D00 AFB10014 AFB00010 8E630090 0080B021 8E620028 8064002D 
    00C0A821 00E0F021 00A0B821 0040F809 8FB10048 8E640090 8E630024 24050006 
    8084002D 24100001 0060F809 00508004 8E630090 00409021 8E620024 8064002D 
    24050005 0040F809 0015A040 0295A021 00409821 729E1002 02C02021 02E02821 
    02A03021 03C03821 0051A021 0411FF48 00000000 3C04BF88 24050100 AC856434 
    8FA2004C 24060200 2403022E AC836430 AC866434 AC866438 AC856438 240500FF 
    00511021 3C03BF88 AC85641C 00000000 00000000 00000000 AE700000 00000000 
    00000000 00000000 00000000 AE500000 00000000 00000000 00000000 00000000 
    00000000 8C646420 A0440000 AE700000 00000000 00000000 00000000 00000000 
    AE500000 00000000 00000000 00000000 00000000 00000000 8C646420 A0440001 
    AE700000 00000000 00000000 00000000 00000000 AE500000 00000000 00000000 
    00000000 00000000 00000000 8C656420 26310003 0234202B A0450002 1480FFD3 
    24420003 3C02BF88 240300FF AC43641C 8FBF0034 02201021 8FBE0030 8FB7002C 
    8FB60028 8FB50024 8FB40020 8FB3001C 8FB20018 8FB10014 8FB00010 03E00008 
    27BD0038 
    'RestoreRectangle
    27BDFFE0 AFB20018 AFB10014 00C09021 00E08821 72328802 AFB00010 AFBF001C 
    8FB00030 0411FEF1 00000000 3C02BF88 24030100 24040200 2405022C AC436434 
    AC456430 AC446434 AC446438 AC436438 1220001D 2631FFFF 8FA40034 02202821 
    00902021 24030200 2407FFFF 80860000 24A5FFFF 34C60300 AC466430 AC436434 
    AC436438 80860001 34C60300 AC466430 AC436434 AC436438 80860002 24840003 
    34C60300 AC466430 AC436434 AC436438 54A7FFEF 80860000 00111040 26100003 
    00518821 02118021 8FBF001C 02001021 8FB20018 8FB10014 8FB00010 03E00008 
    27BD0020 
    'triangles
    27BDFFA8 AFB20038 8FA3006C 00809021 8FA40074 AFBE0050 AFB7004C 0083102A 
    AFB3003C AFB10034 AFBF0054 AFB60048 AFB50044 AFB40040 AFB00030 00A09821 
    00C0B821 AFA70064 8FB10068 10400006 8FBE007C 02201021 AFA4006C 8FB10070 
    AFA30074 AFA20070 8FA30074 03C3102A 10400009 8FA6006C 8FA20070 8FA40078 
    AFBE0074 AFA20078 AFA40070 0060F021 8FA6006C 8FA30074 0066102A 50400008 
    8FA6006C 8FA40074 02201021 AFA60074 8FB10070 AFA4006C AFA20070 8FA6006C 
    14DE0036 8FA30074 8FA30070 0071102A 14400006 02203821 0223102A 10400005 
    8FA40078 10000002 8FA70070 8FB10070 8FA40078 0091102A 54400003 8FB10078 
    00E4102A 0082380B 1640000C 24020001 8FA5006C 24E70001 02202021 24060001 
    00F13823 AFB30010 AFB70014 0411FF02 00000000 100000B0 00409821 1642000C 
    8FA20064 8FA5006C 24E70001 02202021 24060001 00F13823 AFB30010 AFB70014 
    0411FF6E 00000000 100000A3 00409821 8FA5006C 24E70001 02202021 24060001 
    00F13823 AFA20010 AFB70014 0411FEB7 00000000 10000099 8FBF0054 8FA4006C 
    007E1026 0002102B 00621023 AFA20020 0044102A 14400044 00808021 8FA60070 
    8FA20078 00641823 00D13023 00511023 03C42023 AFA60024 AFA20028 0000A021 
    0000A821 AFA30018 AFA4001C 24160001 8FA40018 8FA6001C 02002821 02A4001A 
    008001F4 02C03821 00001012 00511021 0286001A 00C001F4 00001812 00711821 
    0062302A 10C00003 00402021 00601021 00801821 24660001 00402021 16400009 
    00C23023 02002821 02C03821 AFB30010 AFB70014 0411FEB8 00000000 10000012 
    00409821 5656000C 8FA20064 24630001 00402021 02002821 00623023 02C03821 
    AFB30010 AFB70014 0411FF24 00000000 10000005 00409821 AFB70014 AFA20010 
    0411FE72 00000000 8FA30020 8FA40024 8FA60028 26100001 0070102A 02A4A821 
    1040FFCB 0286A021 03D0102A 1440004A 8FA30070 8FA20078 8FA40074 8FA60078 
    00431023 AFA20024 8FA2006C 0204A023 00D13023 0202A823 8FA20024 70D5A802 
    03C41823 8FA4006C AFA60020 AFA30018 03C42023 AFA4001C 24160001 7054A002 
    8FA40018 8FA6001C 02002821 0284001A 008001F4 8FA40070 02C03821 00001012 
    00441021 02A6001A 00C001F4 00001812 00711821 0062202A 10800003 00403021 
    00601021 00C01821 24660001 00402021 16400009 00C23023 02002821 02C03821 
    AFB30010 AFB70014 0411FE6B 00000000 10000012 00409821 5656000C 8FA20064 
    24630001 00402021 02002821 00623023 02C03821 AFB30010 AFB70014 0411FED7 
    00000000 10000005 00409821 AFB70014 AFA20010 0411FE25 00000000 8FA30024 
    8FA40020 26100001 03D0102A 0283A021 1040FFCB 02A4A821 8FBF0054 02601021 
    8FBE0050 8FB7004C 8FB60048 8FB50044 8FB40040 8FB3003C 8FB20038 8FB10034 
    8FB00030 03E00008 27BD0058 
    'gettearscanline
    27BDFFE0 AFBF001C AFB20018 AFB10014 AFB00010 3C109D00 8E030090 8E020028 
    0040F809 8064002D 8E030090 00409021 8E020024 8064002D 0040F809 24050006 
    8E030090 00408821 8E020024 8064002D 0040F809 24050005 24040001 3C03BF88 
    02449004 24060100 24070200 240500FF 24080245 AC666434 3C04BF81 AC686430 
    AC676434 AC676438 AC666438 AC65641C AC520000 8C86F220 8C86F220 8C86F220 
    8C86F220 AE320000 8C666420 AC520000 8C82F220 8C82F220 8C82F220 8C82F220 
    AE320000 8C626420 AC65641C 8FBF001C 30C400FF 00042200 304200FF 00821025 
    8FB20018 8FB10014 8FB00010 03E00008 27BD0020 
    'main
    27BDFFB0 AFBE0048 AFB70044 AFB60040 AFB5003C AFB40038 AFB1002C AFBF004C 
    AFB30034 AFB20030 AFB00028 3C029D00 8C420090 24030001 00808821 80420014 
    00A0A821 AFA60058 00E0A021 8FBE0068 8FB7006C 10430011 8FB60070 0411FFAB 
    00000000 2442FE70 2C42000A 1040FFFB 00000000 8E220000 18400034 00008021 
    8FA20058 8C440004 0480000C 8C470000 00008021 100000A2 00001821 0411FF9B 
    00000000 2442FF10 2C42000A 1040FFFB 00000000 1000FFF0 8E220000 8FB20058 
    00001821 00001021 00008021 8FA40060 8FA50064 02834821 00834021 00A33021 
    02E32021 03C32821 02C31821 8D2C0000 8D0B0000 8CCA0000 8CA90000 8C880000 
    8C630000 24040001 00402821 02A03021 AFA30024 AFAC0010 AFAB0014 AFAA0018 
    AFA9001C AFA80020 0411FE6D 00000000 8E240000 26100001 0204202A 14800005 
    001018C0 1000002F 00001021 1000002D 00001021 8E44000C 8E470008 0480FFDB 
    26520008 8FA40058 001018C0 00831021 8C440004 8C470000 04810069 00001021 
    10000021 8E230000 8FA50060 8FA40064 02834821 00A34021 00833021 03C32821 
    02E32021 02C31821 8D2C0000 8D0B0000 8CCA0000 8CA90000 8C880000 8C630000 
    00002021 00402821 02A03021 AFA30024 AFAC0010 AFAB0014 AFAA0018 AFA9001C 
    AFA80020 0411FE3E 00000000 8E240000 8FA50058 26730001 0264202A 1480000D 
    00B21821 8E230000 0203182A 10600036 8FA40058 001018C0 00832821 8CA40004 
    04800031 8CA70000 26120001 10000008 001290C0 8C640004 26450008 0480FFF1 
    8C670000 02401821 1000FFCF 00A09021 8FA50060 8FA40064 02834821 00A34021 
    00833021 03C32821 02E32021 02C31821 8D2C0000 8D0B0000 8CCA0000 8CA90000 
    8C880000 8C630000 24040002 00402821 02A03021 AFA30024 AFAC0010 AFAB0014 
    AFAA0018 AFA9001C AFA80020 0411FE0C 00000000 8E240000 8FA50058 26100001 
    0204202A 10800008 00B21821 8C640004 26450008 04800004 8C670000 02401821 
    1000FFDB 00A09021 8FBF004C 00021FC3 8FBE0048 000210C3 8FB70044 8FB60040 
    8FB5003C 8FB40038 8FB30034 8FB20030 8FB1002C 8FB00028 03E00008 27BD0050 
    26120001 001290C0 02009821 1000FF96 00001021 
End CFunction

'CFunction triangles   July 2016
'    00000267
'    'defineregion
'    3C029D00 8C420090 24080100 3C03BF88 AC686434 80420015 2488FFFF 24A3FFFF 
'    01064021 24060001 10460004 00671821 24060003 14460005 3C029D00 00805821 
'    01005021 10000008 00602021 8C420094 00605821 00A05021 8C430000 2463FFFF 
'    00682823 00642023 000B6202 000A4202 3C02BF88 24060200 24090100 00053A02 
'    00041A02 35080300 358C0300 356B0300 240D022A AC4D6430 354A0300 AC466434 
'    34E70300 AC466438 34A50300 AC496438 34630300 AC4C6430 34840300 AC466434 
'    AC466438 AC4B6430 AC466434 AC466438 AC486430 2408022B AC466434 AC466438 
'    AC4A6430 AC466434 AC466438 AC496434 AC486430 AC466434 AC466438 AC496438 
'    AC476430 AC466434 AC466438 AC456430 AC466434 AC466438 AC436430 AC466434 
'    AC466438 AC446430 AC466434 AC466438 03E00008 00000000 
'    'writeRectangle
'    27BDFFD8 AFB40020 AFB3001C 00C0A021 00E09821 72749802 AFB00010 8FB00038 
'    AFB20018 AFB10014 00109403 00108A03 AFBF0024 0411FFA4 00000000 3C02BF88 
'    24030100 24040200 2405022C AC436434 36520300 AC456430 36310300 AC446434 
'    36100300 AC446438 AC436438 1260000F 2673FFFF 24030200 2404FFFF 2673FFFF 
'    AC526430 AC436434 AC436438 AC516430 AC436434 AC436438 AC506430 AC436434 
'    AC436438 1664FFF6 2673FFFF 8FBF0024 8FB40020 8FB3001C 8FB20018 8FB10014 
'    8FB00010 03E00008 27BD0028 
'    'ReadRectangle
'    27BDFFC8 AFBF0034 AFBE0030 AFB7002C AFB60028 AFB50024 AFB40020 AFB3001C 
'    AFB20018 3C139D00 AFB10014 AFB00010 8E630090 0080B021 8E620028 8064002D 
'    00C0A821 00E0F021 00A0B821 0040F809 8FB10048 8E640090 8E630024 24050006 
'    8084002D 24100001 0060F809 00508004 8E630090 00409021 8E620024 8064002D 
'    24050005 0040F809 0015A040 0295A021 00409821 729E1002 02C02021 02E02821 
'    02A03021 03C03821 0051A021 0411FF53 00000000 3C05BF88 24060100 ACA66434 
'    8FA3004C 24070200 2402022E ACA26430 ACA76434 ACA76438 ACA66438 240600FF 
'    00711821 3C02BF81 3C04BF88 ACA6641C AE700000 8C45F220 8C45F220 8C45F220 
'    AE500000 8C866420 26310003 0234282B A0660000 AE700000 8C46F220 8C46F220 
'    8C46F220 AE500000 8C866420 A0660001 AE700000 8C46F220 8C46F220 8C46F220 
'    AE500000 8C866420 A0660002 14A0FFE8 24630003 3C02BF88 240300FF AC43641C 
'    8FBF0034 02201021 8FBE0030 8FB7002C 8FB60028 8FB50024 8FB40020 8FB3001C 
'    8FB20018 8FB10014 8FB00010 03E00008 27BD0038 
'    'RestoreRectangle
'    27BDFFE0 AFB20018 AFB10014 00C09021 00E08821 72328802 AFB00010 AFBF001C 
'    8FB00030 0411FF10 00000000 3C02BF88 24030100 24040200 2405022C AC436434 
'    AC456430 AC446434 AC446438 AC436438 1220001D 2631FFFF 8FA40034 02202821 
'    00902021 24030200 2407FFFF 80860000 24A5FFFF 34C60300 AC466430 AC436434 
'    AC436438 80860001 34C60300 AC466430 AC436434 AC436438 80860002 24840003 
'    34C60300 AC466430 AC436434 AC436438 54A7FFEF 80860000 00111040 26100003 
'    00518821 02118021 8FBF001C 02001021 8FB20018 8FB10014 8FB00010 03E00008 
'    27BD0020 
'    'triangles
'    27BDFFA8 AFB20038 8FA3006C 00809021 8FA40074 AFBE0050 AFB7004C 0083102A 
'    AFB3003C AFB10034 AFBF0054 AFB60048 AFB50044 AFB40040 AFB00030 00A09821 
'    00C0B821 AFA70064 8FB10068 10400006 8FBE007C 02201021 AFA4006C 8FB10070 
'    AFA30074 AFA20070 8FA30074 03C3102A 10400009 8FA6006C 8FA20070 8FA40078 
'    AFBE0074 AFA20078 AFA40070 0060F021 8FA6006C 8FA30074 0066102A 50400008 
'    8FA6006C 8FA40074 02201021 AFA60074 8FB10070 AFA4006C AFA20070 8FA6006C 
'    14DE0036 8FA30074 8FA30070 0071102A 14400006 02203821 0223102A 10400005 
'    8FA40078 10000002 8FA70070 8FB10070 8FA40078 0091102A 54400003 8FB10078 
'    00E4102A 0082380B 1640000C 24020001 8FA5006C 24E70001 02202021 24060001 
'    00F13823 AFB30010 AFB70014 0411FF16 00000000 100000B0 00409821 1642000C 
'    8FA20064 8FA5006C 24E70001 02202021 24060001 00F13823 AFB30010 AFB70014 
'    0411FF6E 00000000 100000A3 00409821 8FA5006C 24E70001 02202021 24060001 
'    00F13823 AFA20010 AFB70014 0411FECB 00000000 10000099 8FBF0054 8FA4006C 
'    007E1026 0002102B 00621023 AFA20020 0044102A 14400044 00808021 8FA60070 
'    8FA20078 00641823 00D13023 00511023 03C42023 AFA60024 AFA20028 0000A021 
'    0000A821 AFA30018 AFA4001C 24160001 8FA40018 8FA6001C 02002821 02A4001A 
'    008001F4 02C03821 00001012 00511021 0286001A 00C001F4 00001812 00711821 
'    0062302A 10C00003 00402021 00601021 00801821 24660001 00402021 16400009 
'    00C23023 02002821 02C03821 AFB30010 AFB70014 0411FECC 00000000 10000012 
'    00409821 5656000C 8FA20064 24630001 00402021 02002821 00623023 02C03821 
'    AFB30010 AFB70014 0411FF24 00000000 10000005 00409821 AFB70014 AFA20010 
'    0411FE86 00000000 8FA30020 8FA40024 8FA60028 26100001 0070102A 02A4A821 
'    1040FFCB 0286A021 03D0102A 1440004A 8FA30070 8FA20078 8FA40074 8FA60078 
'    00431023 AFA20024 8FA2006C 0204A023 00D13023 0202A823 8FA20024 70D5A802 
'    03C41823 8FA4006C AFA60020 AFA30018 03C42023 AFA4001C 24160001 7054A002 
'    8FA40018 8FA6001C 02002821 0284001A 008001F4 8FA40070 02C03821 00001012 
'    00441021 02A6001A 00C001F4 00001812 00711821 0062202A 10800003 00403021 
'    00601021 00C01821 24660001 00402021 16400009 00C23023 02002821 02C03821 
'    AFB30010 AFB70014 0411FE7F 00000000 10000012 00409821 5656000C 8FA20064 
'    24630001 00402021 02002821 00623023 02C03821 AFB30010 AFB70014 0411FED7 
'    00000000 10000005 00409821 AFB70014 AFA20010 0411FE39 00000000 8FA30024 
'    8FA40020 26100001 03D0102A 0283A021 1040FFCB 02A4A821 8FBF0054 02601021 
'    8FBE0050 8FB7004C 8FB60048 8FB50044 8FB40040 8FB3003C 8FB20038 8FB10034 
'    8FB00030 03E00008 27BD0058 
'    'gettearscanline
'    27BDFFE0 AFBF001C AFB20018 AFB10014 AFB00010 3C109D00 8E030090 8E020028 
'    0040F809 8064002D 8E030090 00409021 8E020024 8064002D 0040F809 24050006 
'    8E030090 00408821 8E020024 8064002D 0040F809 24050005 24040001 3C03BF88 
'    02449004 24060100 24070200 240500FF 24080245 AC666434 3C04BF81 AC686430 
'    AC676434 AC676438 AC666438 AC65641C AC520000 8C86F220 8C86F220 8C86F220 
'    8C86F220 AE320000 8C666420 AC520000 8C82F220 8C82F220 8C82F220 8C82F220 
'    AE320000 8C626420 AC65641C 8FBF001C 30C400FF 00042200 304200FF 00821025 
'    8FB20018 8FB10014 8FB00010 03E00008 27BD0020 
'    'main
'    27BDFFB0 AFBE0048 AFB70044 AFB60040 8FBE0068 8FB7006C 8FB60070 AFB5003C 
'    AFB40038 AFB1002C AFBF004C AFB30034 AFB20030 AFB00028 00808821 00A0A821 
'    AFA60058 00E0A021 0411FFB0 00000000 2442FE70 2C42000A 1040FFFB 00000000 
'    8E220000 184000A0 00008021 8FA20058 8C440004 04810025 8C470000 8FB20058 
'    00001821 00001021 00008021 8FA40060 8FA50064 02834821 00834021 00A33021 
'    02E32021 03C32821 02C31821 8D2C0000 8D0B0000 8CCA0000 8CA90000 8C880000 
'    8C630000 24040001 00402821 02A03021 AFA30024 AFAC0010 AFAB0014 AFAA0018 
'    AFA9001C AFA80020 0411FE7D 00000000 8E240000 26100001 0204202A 1480000E 
'    001018C0 1000006A 00001021 8FA40058 001018C0 00831021 8C440004 8C470000 
'    0480002A 00001021 26120001 001290C0 10000007 02009821 8E44000C 8E470008 
'    0480FFD2 26520008 1000FFF1 8FA40058 8FA50060 8FA40064 02834821 00A34021 
'    00833021 03C32821 02E32021 02C31821 8D2C0000 8D0B0000 8CCA0000 8CA90000 
'    8C880000 8C630000 00002021 00402821 02A03021 AFA30024 AFAC0010 AFAB0014 
'    AFAA0018 AFA9001C AFA80020 0411FE4C 00000000 8E240000 8FA50058 26730001 
'    0264202A 1480000D 00B21821 8E230000 0203182A 10600036 8FA40058 001018C0 
'    00832821 8CA40004 04800031 8CA70000 26120001 10000008 001290C0 8C640004 
'    26450008 0480FFF1 8C670000 02401821 1000FFCF 00A09021 8FA50060 8FA40064 
'    02834821 00A34021 00833021 03C32821 02E32021 02C31821 8D2C0000 8D0B0000 
'    8CCA0000 8CA90000 8C880000 8C630000 24040002 00402821 02A03021 AFA30024 
'    AFAC0010 AFAB0014 AFAA0018 AFA9001C AFA80020 0411FE1A 00000000 8E240000 
'    8FA50058 26100001 0204202A 10800008 00B21821 8C640004 26450008 04800004 
'    8C670000 02401821 1000FFDB 00A09021 8FBF004C 00021FC3 8FBE0048 000210C3 
'    8FB70044 8FB60040 8FB5003C 8FB40038 8FB30034 8FB20030 8FB1002C 8FB00028 
'    03E00008 27BD0050 1000FFF1 00001021 
'End CFunction
'
'CFunction triangles     '64 PIN
'00000267 
'    'defineregion 
'    3C029D00 8C420090 24081000 3C03BF88 AC686134 80420015 2488FFFF 24A3FFFF  
'    01064021 24060001 10460004 00671821 24060003 14460005 3C029D00 00805821  
'    01005021 10000008 00602021 8C420094 00605821 00A05021 8C430000 2463FFFF  
'    00682823 00642023 000B6202 000A4202 3C02BF88 24060800 24091000 00053A02  
'    00041A02 35081800 358C1800 356B1800 240D022A AC4D6430 354A1800 AC466134  
'    34E71800 AC466138 34A51800 AC496138 34631800 AC4C6430 34841800 AC466134  
'    AC466138 AC4B6430 AC466134 AC466138 AC486430 2408022B AC466134 AC466138  
'    AC4A6430 AC466134 AC466138 AC496134 AC486430 AC466134 AC466138 AC496138  
'    AC476430 AC466134 AC466138 AC456430 AC466134 AC466138 AC436430 AC466134  
'    AC466138 AC446430 AC466134 AC466138 03E00008 00000000  
'    'writeRectangle 
'    27BDFFD8 AFB40020 AFB3001C 00C0A021 00E09821 72749802 AFB00010 8FB00038  
'    AFB20018 AFB10014 00109403 00108A03 AFBF0024 0411FFA4 00000000 3C02BF88  
'    24031000 24040800 2405022C AC436134 36521800 AC456430 36311800 AC446134  
'    36101800 AC446138 AC436138 1260000F 2673FFFF 24030800 2404FFFF 2673FFFF  
'    AC526430 AC436134 AC436138 AC516430 AC436134 AC436138 AC506430 AC436134  
'    AC436138 1664FFF6 2673FFFF 8FBF0024 8FB40020 8FB3001C 8FB20018 8FB10014  
'    8FB00010 03E00008 27BD0028  
'    'ReadRectangle 
'    27BDFFC8 AFBF0034 AFBE0030 AFB7002C AFB60028 AFB50024 AFB40020 AFB3001C  
'    AFB20018 3C139D00 AFB10014 AFB00010 8E630090 0080B021 8E620028 8064002D  
'    00C0A821 00E0F021 00A0B821 0040F809 8FB10048 8E640090 8E630024 24050006  
'    8084002D 24100001 0060F809 00508004 8E630090 00409021 8E620024 8064002D  
'    24050005 0040F809 0015A040 0295A021 00409821 729E1002 02C02021 02E02821  
'    02A03021 03C03821 0051A021 0411FF53 00000000 3C05BF88 24061000 ACA66134  
'    8FA3004C 24070800 2402022E ACA26430 ACA76134 ACA76138 ACA66138 240600FF  
'    00711821 3C02BF81 3C04BF88 ACA6641C AE700000 8C45F220 8C45F220 8C45F220  
'    AE500000 8C866420 26310003 0234282B A0660000 AE700000 8C46F220 8C46F220  
'    8C46F220 AE500000 8C866420 A0660001 AE700000 8C46F220 8C46F220 8C46F220  
'    AE500000 8C866420 A0660002 14A0FFE8 24630003 3C02BF88 240300FF AC43641C  
'    8FBF0034 02201021 8FBE0030 8FB7002C 8FB60028 8FB50024 8FB40020 8FB3001C  
'    8FB20018 8FB10014 8FB00010 03E00008 27BD0038  
'    'RestoreRectangle 
'    27BDFFE0 AFB20018 AFB10014 00C09021 00E08821 72328802 AFB00010 AFBF001C  
'    8FB00030 0411FF10 00000000 3C02BF88 24031000 24040800 2405022C AC436134  
'    AC456430 AC446134 AC446138 AC436138 1220001D 2631FFFF 8FA40034 02202821  
'    00902021 24030800 2407FFFF 80860000 24A5FFFF 34C61800 AC466430 AC436134  
'    AC436138 80860001 34C61800 AC466430 AC436134 AC436138 80860002 24840003  
'    34C61800 AC466430 AC436134 AC436138 54A7FFEF 80860000 00111040 26100003  
'    00518821 02118021 8FBF001C 02001021 8FB20018 8FB10014 8FB00010 03E00008  
'    27BD0020  
'    'triangles 
'    27BDFFA8 AFB20038 8FA3006C 00809021 8FA40074 AFBE0050 AFB7004C 0083102A  
'    AFB3003C AFB10034 AFBF0054 AFB60048 AFB50044 AFB40040 AFB00030 00A09821  
'    00C0B821 AFA70064 8FB10068 10400006 8FBE007C 02201021 AFA4006C 8FB10070  
'    AFA30074 AFA20070 8FA30074 03C3102A 10400009 8FA6006C 8FA20070 8FA40078  
'    AFBE0074 AFA20078 AFA40070 0060F021 8FA6006C 8FA30074 0066102A 50400008  
'    8FA6006C 8FA40074 02201021 AFA60074 8FB10070 AFA4006C AFA20070 8FA6006C  
'    14DE0036 8FA30074 8FA30070 0071102A 14400006 02203821 0223102A 10400005  
'    8FA40078 10000002 8FA70070 8FB10070 8FA40078 0091102A 54400003 8FB10078  
'    00E4102A 0082380B 1640000C 24020001 8FA5006C 24E70001 02202021 24060001  
'    00F13823 AFB30010 AFB70014 0411FF16 00000000 100000B0 00409821 1642000C  
'    8FA20064 8FA5006C 24E70001 02202021 24060001 00F13823 AFB30010 AFB70014  
'    0411FF6E 00000000 100000A3 00409821 8FA5006C 24E70001 02202021 24060001  
'    00F13823 AFA20010 AFB70014 0411FECB 00000000 10000099 8FBF0054 8FA4006C  
'    007E1026 0002102B 00621023 AFA20020 0044102A 14400044 00808021 8FA60070  
'    8FA20078 00641823 00D13023 00511023 03C42023 AFA60024 AFA20028 0000A021  
'    0000A821 AFA30018 AFA4001C 24160001 8FA40018 8FA6001C 02002821 02A4001A  
'    008001F4 02C03821 00001012 00511021 0286001A 00C001F4 00001812 00711821  
'    0062302A 10C00003 00402021 00601021 00801821 24660001 00402021 16400009  
'    00C23023 02002821 02C03821 AFB30010 AFB70014 0411FECC 00000000 10000012  
'    00409821 5656000C 8FA20064 24630001 00402021 02002821 00623023 02C03821  
'    AFB30010 AFB70014 0411FF24 00000000 10000005 00409821 AFB70014 AFA20010  
'    0411FE86 00000000 8FA30020 8FA40024 8FA60028 26100001 0070102A 02A4A821  
'    1040FFCB 0286A021 03D0102A 1440004A 8FA30070 8FA20078 8FA40074 8FA60078  
'    00431023 AFA20024 8FA2006C 0204A023 00D13023 0202A823 8FA20024 70D5A802  
'    03C41823 8FA4006C AFA60020 AFA30018 03C42023 AFA4001C 24160001 7054A002  
'    8FA40018 8FA6001C 02002821 0284001A 008001F4 8FA40070 02C03821 00001012  
'    00441021 02A6001A 00C001F4 00001812 00711821 0062202A 10800003 00403021  
'    00601021 00C01821 24660001 00402021 16400009 00C23023 02002821 02C03821  
'    AFB30010 AFB70014 0411FE7F 00000000 10000012 00409821 5656000C 8FA20064  
'    24630001 00402021 02002821 00623023 02C03821 AFB30010 AFB70014 0411FED7  
'    00000000 10000005 00409821 AFB70014 AFA20010 0411FE39 00000000 8FA30024  
'    8FA40020 26100001 03D0102A 0283A021 1040FFCB 02A4A821 8FBF0054 02601021  
'    8FBE0050 8FB7004C 8FB60048 8FB50044 8FB40040 8FB3003C 8FB20038 8FB10034  
'    8FB00030 03E00008 27BD0058  
'    'gettearscanline 
'    27BDFFE0 AFBF001C AFB20018 AFB10014 AFB00010 3C109D00 8E030090 8E020028  
'    0040F809 8064002D 8E030090 00409021 8E020024 8064002D 0040F809 24050006  
'    8E030090 00408821 8E020024 8064002D 0040F809 24050005 24040001 3C03BF88  
'    02449004 24061000 24070800 240500FF 24080245 AC666134 3C04BF81 AC686430  
'    AC676134 AC676138 AC666138 AC65641C AC520000 8C86F220 8C86F220 8C86F220  
'    8C86F220 AE320000 8C666420 AC520000 8C82F220 8C82F220 8C82F220 8C82F220  
'    AE320000 8C626420 AC65641C 8FBF001C 30C400FF 00042200 304200FF 00821025  
'    8FB20018 8FB10014 8FB00010 03E00008 27BD0020  
'    'main 
'    27BDFFB0 AFBE0048 AFB70044 AFB60040 8FBE0068 8FB7006C 8FB60070 AFB5003C  
'    AFB40038 AFB1002C AFBF004C AFB30034 AFB20030 AFB00028 00808821 00A0A821  
'    AFA60058 00E0A021 0411FFB0 00000000 2442FE70 2C42000A 1040FFFB 00000000  
'    8E220000 184000A0 00008021 8FA20058 8C440004 04810025 8C470000 8FB20058  
'    00001821 00001021 00008021 8FA40060 8FA50064 02834821 00834021 00A33021  
'    02E32021 03C32821 02C31821 8D2C0000 8D0B0000 8CCA0000 8CA90000 8C880000  
'    8C630000 24040001 00402821 02A03021 AFA30024 AFAC0010 AFAB0014 AFAA0018  
'    AFA9001C AFA80020 0411FE7D 00000000 8E240000 26100001 0204202A 1480000E  
'    001018C0 1000006A 00001021 8FA40058 001018C0 00831021 8C440004 8C470000  
'    0480002A 00001021 26120001 001290C0 10000007 02009821 8E44000C 8E470008  
'    0480FFD2 26520008 1000FFF1 8FA40058 8FA50060 8FA40064 02834821 00A34021  
'    00833021 03C32821 02E32021 02C31821 8D2C0000 8D0B0000 8CCA0000 8CA90000  
'    8C880000 8C630000 00002021 00402821 02A03021 AFA30024 AFAC0010 AFAB0014  
'    AFAA0018 AFA9001C AFA80020 0411FE4C 00000000 8E240000 8FA50058 26730001  
'    0264202A 1480000D 00B21821 8E230000 0203182A 10600036 8FA40058 001018C0  
'    00832821 8CA40004 04800031 8CA70000 26120001 10000008 001290C0 8C640004  
'    26450008 0480FFF1 8C670000 02401821 1000FFCF 00A09021 8FA50060 8FA40064  
'    02834821 00A34021 00833021 03C32821 02E32021 02C31821 8D2C0000 8D0B0000  
'    8CCA0000 8CA90000 8C880000 8C630000 24040002 00402821 02A03021 AFA30024  
'    AFAC0010 AFAB0014 AFAA0018 AFA9001C AFA80020 0411FE1A 00000000 8E240000  
'    8FA50058 26100001 0204202A 10800008 00B21821 8C640004 26450008 04800004  
'    8C670000 02401821 1000FFDB 00A09021 8FBF004C 00021FC3 8FBE0048 000210C3  
'    8FB70044 8FB60040 8FB5003C 8FB40038 8FB30034 8FB20030 8FB1002C 8FB00028  
'    03E00008 27BD0050 1000FFF1 00001021  


.
'CSub DisplayBufferSSD '64-pin 
'    00000000 
'    14A00003 90880000 10000004 24050001 8CA80000 00002821 2508FFFF 00A8102A  
'    10400017 00852021 3C02BF88 24030800 90870000 24A50003 00A8302A 34E71800  
'    AC476430 AC436134 AC436138 90870001 34E71800 AC476430 AC436134 AC436138  
'    90870002 24840003 34E71800 AC476430 AC436134 AC436138 54C0FFEE 90870000  
'    03E00008 00000000  
'End CSub 
' 
CSub DisplayBufferSSD '100-pin 
    00000000 
    14A00003 90880000 10000004 24050001 8CA80000 00002821 2508FFFF 00A8102A 
    10400017 00852021 3C02BF88 24030200 90870000 24A50003 00A8302A 34E70300 
    AC476430 AC436434 AC436438 90870001 34E70300 AC476430 AC436434 AC436438 
    90870002 24840003 34E70300 AC476430 AC436434 AC436438 54C0FFEE 90870000 
    03E00008 00000000 
End CSub 
' 

'CSub defineregionSSD '64-pin 
'    00000000 
'    3C029D00 8C420090 8C830000 8CA50000 8CC40000 24081000 8CE60000 3C07BF88  
'    ACE86134 80420015 24A7FFFF 2468FFFF 00E63021 24070001 10470004 01042021  
'    24070003 14470005 3C029D00 00C03821 00604021 10000007 00803021 8C420094  
'    00A04021 8C470000 24E7FFFF 00E42823 00E33823 00086202 00065A02 3C02BF88  
'    24030800 24041000 00055202 34C61800 358C1800 35081800 356B1800 240D022A  
'    AC4D6430 00074A02 AC436134 34A51800 AC436138 354A1800 AC446138 AC4C6430  
'    AC436134 AC436138 AC486430 AC436134 AC436138 AC4B6430 AC436134 AC436138  
'    AC466430 2406022B AC436134 35291800 AC436138 34E71800 AC446134 AC466430  
'    AC436134 AC436138 AC446138 AC4A6430 AC436134 AC436138 AC456430 2405022C  
'    AC436134 AC436138 AC496430 AC436134 AC436138 AC476430 AC436134 AC436138  
'    AC446134 AC456430 AC436134 AC436138 AC446138 03E00008 00000000  
'End CSub 

CSub defineregionSSD '100-pin 
    00000000 
    3C029D00 8C420090 8C830000 8CA50000 8CC40000 24080100 8CE60000 3C07BF88  
    ACE86434 80420015 24A7FFFF 2468FFFF 00E63021 24070001 10470004 01042021  
    24070003 14470005 3C029D00 00C03821 00604021 10000007 00803021 8C420094  
    00A04021 8C470000 24E7FFFF 00E42823 00E33823 00086202 00065A02 3C02BF88  
    24030200 24040100 00055202 34C60300 358C0300 35080300 356B0300 240D022A  
    AC4D6430 00074A02 AC436434 34A50300 AC436438 354A0300 AC446438 AC4C6430  
    AC436434 AC436438 AC486430 AC436434 AC436438 AC4B6430 AC436434 AC436438  
    AC466430 2406022B AC436434 35290300 AC436438 34E70300 AC446434 AC466430  
    AC436434 AC436438 AC446438 AC4A6430 AC436434 AC436438 AC456430 2405022C  
    AC436434 AC436438 AC496430 AC436434 AC436438 AC476430 AC436434 AC436438  
    AC446434 AC456430 AC436434 AC436438 AC446438 03E00008 00000000  
End CSub 

'End CSub 
' 


CSub sdcard '64-pin or 100-pin 
    00000676 
    'rcv_spi 
    240300FF 3C02BF80 AC435A20 3C03BF80 8C625A10 30420080 1040FFFD 3C02BF80  
    8C425A20 03E00008 304200FF  
    'xmit_spi 
    308400FF 3C02BF80 AC445A20 3C03BF80 8C625A10 30420080 1040FFFD 3C02BF80  
    8C425A20 03E00008 304200FF  
    'mem_set 
    10C00006 00801021 00862021 A0450000 24420001 5444FFFE A0450000 03E00008  
    00000000  
    'mem_cmp 
    2407FFFF 24C6FFFF 10C70008 00001021 80830000 80A20000 00621023 14400003  
    24840001 1000FFF7 24A50001 03E00008 00000000  
    'mystrlen 
    80830000 10600006 00001021 24420001 00821821 80630000 5460FFFD 24420001  
    03E00008 00000000  
    'send_cmd 
    27BDFFE0 AFBF001C AFB20018 AFB10014 AFB00010 309100FF 7C111420 04410009  
    00A09021 24040077 00002821 0411FFF4 00000000 2C430002 10600034 8FBF001C  
    3231007F 3C109D00 8E030090 8E02001C 80640030 0040F809 24050006 0411FFB2  
    00000000 8E030090 8E02001C 80640030 0040F809 24050005 0411FFAB 00000000  
    02202021 0411FFB3 00000000 00122602 0411FFB0 00000000 7E443C00 0411FFAD  
    00000000 7E443A00 0411FFAA 00000000 324400FF 0411FFA7 00000000 24020040  
    12220006 24040095 3A310048 24020001 24030087 00402021 0071200A 0411FF9D  
    00000000 2410000A 0411FF8F 00000000 7C021C20 04610004 2610FFFF 321000FF  
    1600FFF9 00000000 8FBF001C 8FB20018 8FB10014 8FB00010 03E00008 27BD0020  
    'disk_readp 
    27BDFFD8 AFBF0024 AFB40020 AFB3001C AFB20018 AFB10014 AFB00010 00809021  
    00C09821 00E0A021 3C029D00 8C42008C 8C4300FC 30630008 00051240 24040051  
    0043280A 0411FFA6 00000000 14400024 24100001 34109C40 241100FF 0411FF6A  
    00000000 14510005 2610FFFF 1600FFFB 00000000 1000001A 24100001 240300FE  
    14430017 24100001 00138823 26310202 12600006 02348823 0411FF5B 00000000  
    2673FFFF 1660FFFC 00000000 02548021 0411FF55 00000000 A2420000 26520001  
    1650FFFB 00000000 0411FF4F 00000000 2631FFFF 1620FFFC 00000000 00008021  
    3C029D00 8C430090 8C42001C 80640030 0040F809 24050006 0411FF43 00000000  
    02001021 8FBF0024 8FB40020 8FB3001C 8FB20018 8FB10014 8FB00010 03E00008  
    27BD0028  
    'clust2sect 
    24A5FFFE 8C830008 2463FFFE 00A3182B 10600005 00001021 90830002 8C820014  
    70A32002 00821021 03E00008 00000000  
    'dir_rewind 
    27BDFFE8 AFBF0014 AFB00010 00A08021 A4A00000 8CA50008 24030001 10A30015  
    24020001 8C830008 00A3182B 50600012 8FBF0014 54A00008 AE05000C 90830000  
    24020003 54620008 AE00000C 8C850010 10A00005 AE05000C 0411FFDD 00000000  
    10000003 AE020010 8C820010 AE020010 00001021 8FBF0014 8FB00010 03E00008  
    27BD0018  
    'create_name 
    27BDFFE0 AFBF001C AFB10018 AFB00014 00A08021 8C910004 02202021 24050020  
    2406000B 0411FF18 00000000 8E080000 00002021 00001821 24070008 2409002F  
    2406002E 240A0008 01031021 90420000 24630001 2C450021 14A00018 306300FF  
    50490017 01031821 10460003 0087282B 14A00008 2445FF9F 54EA0011 01031821  
    5446000F 01031821 01402021 1000FFEE 2407000B 30A500FF 2CA5001A 10A00003  
    02242821 2442FFE0 304200FF A0A20000 24840001 1000FFE4 308400FF 01031821  
    AE030000 2C420021 A222000B 00001021 8FBF001C 8FB10018 8FB00014 03E00008  
    27BD0020  
    'get_clust 
    90840000 24020003 14820006 00001821 90A30015 00031A00 90A20014 00621825  
    00031C00 90A2001B 00021200 90A4001A 00441025 03E00008 00621025  
    'get_fat 
    27BDFFE0 AFBF001C 2CA20002 1440001B 24030001 8C820008 00A2102B 10400018  
    00601021 000519C2 8C82000C 30A6007F 27A40010 00622821 00063080 24070004  
    0411FF31 00000000 1440000C 24030001 93A30013 00031E00 93A20012 00021400  
    00621825 93A20010 00621825 93A20011 00021200 00621825 7C63D800 00601021  
    8FBF001C 03E00008 27BD0020  
    'dir_next 
    27BDFFE0 AFBF001C AFB20018 AFB10014 AFB00010 00808821 00A08021 94B20000  
    26520001 3252FFFF 12400028 24020003 8CA30010 50600026 8FBF001C 3242000F  
    54400021 A6120000 24630001 ACA30010 8CA5000C 14A00007 00121902 94830004  
    0243182B 14600017 24020003 10000018 8FBF001C 90820002 2442FFFF 00621024  
    54400011 A6120000 0411FFBA 00000000 00402821 2C430002 1460000C 24020001  
    8E230008 00A3182B 10600008 24020003 AE05000C 02202021 0411FF39 00000000  
    AE020010 A6120000 00001021 8FBF001C 8FB20018 8FB10014 8FB00010 03E00008  
    27BD0020  
    'dir_find 
    27BDFFD8 AFBF0024 AFB30020 AFB2001C AFB10018 AFB00014 00809821 00A08821  
    00C09021 0411FF31 00000000 14400021 00408021 96260000 30C6000F 02402021  
    8E250010 00063140 24070020 0411FED2 00000000 0002802B 16000017 02001021  
    92420000 50400013 24100003 9242000B 30420008 14400008 02602021 02402021  
    8E250004 2406000B 0411FE64 00000000 10400008 02602021 02202821 0411FF9F  
    00000000 1040FFE3 00408021 10000002 02001021 02001021 8FBF0024 8FB30020  
    8FB2001C 8FB10018 8FB00014 03E00008 27BD0028  
    'follow_path 
    27BDFFE0 AFBF001C AFB20018 AFB10014 AFB00010 00809021 00A08021 AFA7002C  
    80E20000 24030020 14430006 00C08821 24E70001 AFA7002C 80E20000 5043FFFD  
    24E70001 2403002F 54430004 AE000008 24E70001 AFA7002C AE000008 8FA2002C  
    90420000 2C420020 10400008 02002021 02402021 02002821 0411FEE7 00000000  
    1000001B A2200000 02002021 27A5002C 0411FF02 00000000 14400015 02402021  
    02002821 02203021 0411FFA0 00000000 14400010 8FBF001C 8E030004 9063000B  
    5460000D 8FB20018 9222000B 30420010 10400006 02402021 02202821 0411FF28  
    00000000 1000FFE8 AE020008 24020003 8FBF001C 8FB20018 8FB10014 8FB00010  
    03E00008 27BD0020  
    'pf_lseek 
    27BDFFD8 AFBF0024 AFB30020 AFB2001C AFB10018 AFB00014 00808021 1080004F  
    24020005 90830001 30630001 1060004B 24020004 8C82001C 0045902B 00B2100A  
    00409021 8C830018 AC800018 12400043 00001021 90910002 10600012 00118A40  
    2463FFFF 2642FFFF 0051001B 022001F4 00001012 0071001B 022001F4 00002012  
    0044102B 54400008 8E050020 00111023 00431824 AE030018 02439023 10000003  
    8E050024 8E050020 AE050024 0232102B 10400018 00119823 02519023 02002021  
    0411FEFC 00000000 00402821 2C420002 54400006 A2000001 8E020008 00A2102B  
    54400004 AE050024 A2000001 1000001B 24020001 8E020018 00511021 AE020018  
    02531021 00511821 0223182B 5460FFEB 00409021 8E020018 00529021 AE120018  
    02002021 0411FE6E 00000000 54400004 92040002 A2000001 10000008 24020001  
    2484FFFF 8E030018 00031A42 00831824 00431021 AE020028 00001021 8FBF0024  
    8FB30020 8FB2001C 8FB10018 8FB00014 03E00008 27BD0028  
    'pf_read 
    27BDFFD0 AFBF002C AFB60028 AFB50024 AFB40020 AFB3001C AFB20018 AFB10014  
    AFB00010 00808021 00A0A821 00E09821 ACE00000 1080004A 24020005 90830001  
    30630001 10600046 24020004 8C92001C 8C820018 02429023 0246102B 00C2900A  
    1240003F 00001021 00A0A021 24160200 8E020018 304301FF 5460001F 8E060018  
    00021A42 92110002 2631FFFF 00718824 323100FF 1620000E 02002021 54400003  
    8E050024 10000003 8E020020 0411FEA3 00000000 2C430002 50600004 AE020024  
    A2000001 10000026 24020001 02002021 8E050024 0411FE24 00000000 14400004  
    00518821 A2000001 1000001D 24020001 AE110028 8E060018 30C601FF 02C61023  
    0052882B 0251100A 00408821 00002021 0295200B 8E050028 00403821 0411FDC9  
    00000000 50400004 8E020018 A2000001 1000000B 24020001 00511021 AE020018  
    02519023 8E620000 00511021 12400003 AE620000 1000FFC6 0291A021 00001021  
    8FBF002C 8FB60028 8FB50024 8FB40020 8FB3001C 8FB20018 8FB10014 8FB00010  
    03E00008 27BD0030  
    'disk_initialize 
    27BDFFD0 AFBF002C AFB30028 AFB20024 AFB10020 AFB0001C 2403003B 3C02BF80  
    AC435A30 3C029D00 8C430090 8C42001C 80640030 0040F809 24050006 2410000A  
    0411FD20 00000000 2610FFFF 321000FF 1600FFFB 24040040 00002821 0411FD4F  
    00000000 24030001 14430061 3C029D00 24040048 240501AA 0411FD48 00000000  
    24030001 14430037 240400E9 27B00010 27B10014 0411FD0B 00000000 A2020000  
    26100001 1611FFFB 93A30012 24020001 1462004E 00008021 93A30013 240200AA  
    1462004B 3C029D00 10000008 24112710 0040F809 24040064 2631FFFF 16200005  
    240400E9 1000003F 00008021 3C109D00 240400E9 3C054000 0411FD28 00000000  
    5440FFF3 8E020004 12200038 00008021 2404007A 00002821 0411FD20 00000000  
    14400033 3C029D00 24110004 0411FCE5 00000000 27A40010 00901821 26100001  
    1611FFFA A0620000 93B00010 32100040 2402000C 24030004 0070100A 10000023  
    00408021 00002821 0411FD0C 00000000 2C420002 24030002 24100001 0062800B  
    240300E9 24130041 0062980B 24112710 10000006 3C129D00 0040F809 24040064  
    2631FFFF 52200011 00008021 02602021 00002821 0411FCF9 00000000 5440FFF6  
    8E420004 52200009 00008021 24040050 24050200 0411FCF1 00000000 10000003  
    0002800B 10000002 3C029D00 3C029D00 8C43008C AC7000FC 8C430090 8C42001C  
    80640030 0040F809 24050006 0411FCAD 00000000 12000005 3C029D00 8C420090  
    8043003C 3C02BF80 AC435A30 2E020001 8FBF002C 8FB30028 8FB20024 8FB10020  
    8FB0001C 03E00008 27BD0030  
    'disk_writep 
    27BDFFE0 AFBF001C AFB20018 AFB10014 AFB00010 10800014 00808021 30A5FFFF  
    10A00052 00009021 97828010 1040004F 00858821 92040000 26100001 0411FC99  
    00000000 97828010 2442FFFF 3042FFFF 12110045 A7828010 5440FFF7 92040000  
    10000042 00009021 10A00016 97908010 3C029D00 8C42008C 8C4300FC 30630008  
    00051240 24040058 0043280A 0411FCB0 00000000 14400035 24120001 240400FF  
    0411FC80 00000000 240400FE 0411FC7D 00000000 24020200 A7828010 1000002B  
    00009021 26100002 12000008 2610FFFF 2411FFFF 00002021 0411FC72 00000000  
    2610FFFF 1611FFFC 00002021 0411FC62 00000000 3042001F 24030005 14430010  
    24120001 10000005 241207D0 0040F809 240403E8 10000003 2652FFFF 241100FF  
    3C109D00 0411FC54 00000000 50510004 2E520001 5640FFF5 8E020004 24120001  
    3C029D00 8C430090 8C42001C 80640030 0040F809 24050006 0411FC47 00000000  
    10000003 02401021 00009021 02401021 8FBF001C 8FB20018 8FB10014 8FB00010  
    03E00008 27BD0020  
    'pf_write 
    27BDFFD0 AFBF002C AFB60028 AFB50024 AFB40020 AFB3001C AFB20018 AFB10014  
    AFB00010 00808021 00C09021 00E09821 ACE00000 1080007B 24020005 90830001  
    30640001 10800077 24020004 14C00010 30630040 5060000A 92020001 00002021  
    00002821 0411FF84 00000000 50400004 92020001 A2000001 1000006A 24020001  
    304200BF A2020001 10000066 00001021 54600006 8E03001C 8E030018 2402FE00  
    00621024 AE020018 8E03001C 8E020018 00621023 0052182B 14600005 00000000  
    00A0A021 24150200 10000005 2416FFBF 1440FFFB 00409021 10000053 8FBF002C  
    8E020018 304301FF 54600029 8E110018 00021A42 92110002 2631FFFF 00718824  
    323100FF 1620000E 02002021 54400003 8E050024 10000003 8E020020 0411FD30  
    00000000 2C430002 50600004 AE020024 A2000001 1000003B 24020001 02002021  
    8E050024 0411FCB1 00000000 14400004 00512821 A2000001 10000032 24020001  
    AE050028 00002021 0411FF43 00000000 50400004 92020001 A2000001 10000029  
    24020001 34420040 A2020001 8E110018 323101FF 02B18823 0232102B 0242880A  
    02802021 02202821 0411FF33 00000000 50400004 8E020018 A2000001 10000019  
    24020001 00511021 AE020018 8E620000 00511021 AE620000 8E020018 304201FF  
    5440000D 02519023 00002021 00002821 0411FF21 00000000 50400004 92020001  
    A2000001 10000007 24020001 00561024 A2020001 02519023 1640FFB1 0291A021  
    00001021 8FBF002C 8FB60028 8FB50024 8FB40020 8FB3001C 8FB20018 8FB10014  
    8FB00010 03E00008 27BD0030  
    'check_fs 
    27BDFFE0 AFBF001C AFB10018 AFB00014 00808021 00A08821 240601FE 24070002  
    0411FC1E 00000000 14400028 24030003 92040001 00042200 92020000 00822025  
    7C042620 2402AA55 14820020 24030002 02002021 02202821 24060036 24070002  
    0411FC0E 00000000 1440000A 02002021 92040001 00042200 92020000 00822025  
    7C042620 24024146 10820010 00001821 02002021 02202821 24060052 24070002  
    0411FBFE 00000000 14400008 24030001 92030001 00031A00 92020000 00621825  
    7C031E20 38634146 0003182B 00601021 8FBF001C 8FB10018 8FB00014 03E00008  
    27BD0020  
    'pf_mount 
    27BDFFB8 AFBF0044 AFB10040 AFB0003C 00808021 0411FE39 00000000 30420001  
    14400087 24030002 27A40010 00002821 0411FFBA 00000000 24030001 1443001A  
    00008821 27A40010 00002821 240601BE 24070010 0411FBD8 00000000 14400078  
    24030001 93A20014 10400075 24030006 93B1001B 00118E00 93A2001A 00021400  
    02228825 93A20018 02228825 93A20019 00021200 02228825 27A40010 02202821  
    0411FF9E 00000000 24040003 10440064 24030001 14400062 24030006 27A40010  
    02202821 2406000D 24070024 0411FBBA 00000000 1440005A 24030001 93A2001A  
    00021200 93A30019 00431025 1440000C 93A30013 93A3002A 00031E00 93A20029  
    00021400 00621025 93A30027 00431025 93A30028 00031A00 00431025 93A30013  
    70431002 93A60012 00063200 93A30011 00C33025 02268821 AE11000C 93A50010  
    A2050002 93A40015 00042200 93A30014 00832025 A6040004 93A30017 00031A00  
    93A70016 00671825 1460000B 00042102 93A70026 00073E00 93A30025 00031C00  
    00E31825 93A70023 00671825 93A70024 00073A00 00671825 00661823 00621823  
    00641823 0065001B 00A001F4 00003012 24C50002 AE050008 24C6F00A 3407EFFF  
    00C7302B 2CA70FF7 24030002 0066380B 3403FFF7 00A3282B 10A0001F 24030003  
    10E00017 24030006 24030003 14E3000D A2070000 93A50032 00052E00 93A30031  
    00031C00 00A32825 93A3002F 00A32825 93A30030 00031A00 00A31825 10000003  
    AE030010 00511821 AE030010 02248821 02221021 AE020014 A2000001 00001821  
    00601021 8FBF0044 8FB10040 8FB0003C 03E00008 27BD0048 1000FFE6 A2030000  
    'pf_open 
    27BDFFA0 AFBF005C AFB10058 AFB00054 00808821 00A03821 10800025 24100005  
    A0800001 27A20024 AFA20014 27A50010 27A60030 0411FC97 00000000 1440001C  
    00408021 93A20030 10400018 93A2003B 30420010 54400016 24100003 02202021  
    27A50030 0411FBEB 00000000 AE220020 93A3004F 00031E00 93A2004E 00021400  
    00621025 93A3004C 00431025 93A3004D 00031A00 00431025 AE22001C AE200018  
    24020001 10000002 A2220001 24100003 02001021 8FBF005C 8FB10058 8FB00054  
    03E00008 27BD0060  
    'pf_opendir 
    27BDFFB0 AFBF004C AFB10048 AFB00044 00808021 00A08821 00C03821 10800018  
    24020005 27A20010 ACA20004 27A6001C 0411FC66 00000000 14400012 8FBF004C  
    93A2001C 1040000B 02002021 93A30027 30630010 1060000A 24020003 02002021  
    27A5001C 0411FBB9 00000000 AE220008 02002021 02202821 0411FB5A 00000000  
    8FBF004C 8FB10048 8FB00044 03E00008 27BD0050  
    'get_fileinfo 
    8C830010 10600036 24C20009 90A30000 24040020 1064000E 00A02021 244A0008  
    24090005 240800E5 10000003 240B0020 106B0007 24840001 00693826 0107180A  
    A0430000 24420001 544AFFF9 90830001 90A40008 24030020 1083000A 2403002E  
    A0430000 90A30008 24040020 1464001E 24420001 10000004 90A3000B A0430000  
    24420001 90A3000B A0C30008 90A4001F 00042600 90A3001E 00031C00 00831825  
    90A4001C 00641825 90A4001D 00042200 00641825 ACC30000 90A30019 00031A00  
    90A40018 00641825 A4C30004 90A30017 00031A00 90A40016 00641825 A4C30006  
    03E00008 A0400000 A0430000 90A30009 24040020 1064FFE3 24420001 A0430000  
    90A3000A 1464FFDD 24420001 1000FFDE 90A3000B  
    'dir_read 
    27BDFFD8 AFBF0024 AFB40020 AFB3001C AFB20018 AFB10014 AFB00010 00809821  
    00A08021 00C08821 24020003 241200E5 10000019 2414002E 30C6000F 02202021  
    00063140 24070020 0411FAA7 00000000 0002102B 54400016 AE000010 92230000  
    50600012 24020003 10720005 9224000B 10740003 30840008 1080000E 8FBF0024  
    02602021 02002821 0411FB78 00000000 54400007 AE000010 8E050010 54A0FFE6  
    96060000 10400003 8FBF0024 AE000010 8FBF0024 8FB40020 8FB3001C 8FB20018  
    8FB10014 8FB00010 03E00008 27BD0028  
    'pf_readdir 
    27BDFFB0 AFBF004C AFB20048 AFB10044 AFB00040 00808821 00A08021 00C09021  
    1080001B 24020005 27A20010 14C00005 ACA20004 0411FACD 00000000 10000015  
    8FBF004C 27A6001C 0411FFB9 00000000 24030003 10430004 02002021 1440000D  
    8FBF004C 02002021 27A5001C 02403021 0411FF6A 00000000 02202021 02002821  
    0411FB46 00000000 38430003 0003100A 8FBF004C 8FB20048 8FB10044 8FB00040  
    03E00008 27BD0050  
    'getFPC 
    27BDFFF8 AFBF0004 00852023 03E42021 ACC40000 8FBF0004 03E00008 27BD0008  
    'errstring 
    27BDFFE0 AFBF001C AFB00018 00808021 00002021 3C059D00 24A518D0 27A60010  
    0411FFEF 00000000 8FA20010 1200003C 24030001 16030006 24030002 8FA30010  
    3C049D00 24842468 10000012 00832021 56030006 3C049D00 8FA30010 3C049D00  
    24842478 10000013 00832021 24842458 00822021 24020003 16020007 24020004  
    8FA30010 3C049D00 24842484 10000011 00832021 24020004 16020007 24020005  
    8FA30010 3C049D00 24842490 10000011 00832021 24020005 16020007 24020006  
    8FA30010 3C049D00 248424A0 10000010 00832021 24020006 16020007 24020007  
    8FA30010 3C049D00 248424B0 10000008 00832021 24020007 16020006 3C029D00  
    8FA30010 3C049D00 248424C4 00832021 3C029D00 8C4200BC 0040F809 00000000  
    8FBF001C 8FB00018 03E00008 27BD0020  
    'main 
    27BDFFA8 AFBF0054 AFBE0050 AFB7004C AFB60048 AFB50044 AFB40040 AFB3003C  
    AFB20038 AFB10034 AFB00030 00808021 00A08821 00C0A821 00E09821 3C02BF80  
    34038260 AC435A00 24030C00 AC435A40 3C039D00 8C640090 8084003C AC445A30  
    8C72008C 26540050 8E060000 24020001 10C20006 26570078 24020006 10C20003  
    24020007 14C20006 24020004 82250000 04A10007 00001021 1000000F 03A52821  
    14C2001A 24020007 1000FFF9 82250000 27A40010 00821821 02222021 90840000  
    A0640000 24420001 00A2182A 1060FFF9 27A40010 03A52821 24020006 14C20005  
    A0A00011 3C029D00 8C4200C4 0040F809 00000000 8E060000 24020001 10C20007  
    24020006 10C20005 24020007 10C20003 24020004 54C200A6 8E030000 3C029D00  
    8C430090 80640030 8C430088 00041080 00431021 8C430000 24020065 10620003  
    24040007 0411FF62 00000000 3C02BF81 8C43F220 7C63D800 3C020580 3442B053  
    00621026 24030030 24040014 0082180B 00601021 3C039D00 8C630088 00431021  
    8C430000 24020065 10620054 3C029D00 8C420010 3C03BF81 8C65F220 7CA5D800  
    3C030580 3463B053 00A32826 2403000C 24040005 0065200A 24050008 0040F809  
    00003021 3C029D00 8C420010 3C03BF81 8C65F220 7CA5D800 3C030580 3463B053  
    00A32826 2403000C 24040005 0065200A 24050064 0040F809 00003021 3C029D00  
    8C420010 3C03BF81 8C65F220 7CA5D800 3C030580 3463B053 00A32826 2403000B  
    2404002F 0065200A 24050002 0040F809 00003021 3C029D00 8C420010 3C03BF81  
    8C65F220 7CA5D800 3C030580 3463B053 00A32826 2403000B 2404002F 0065200A  
    24050064 0040F809 00003021 3C029D00 8C420010 3C03BF81 8C65F220 7CA5D800  
    3C030580 3463B053 00A32826 2403000A 24040004 0065200A 24050008 0040F809  
    00003021 3C029D00 8C420010 3C03BF81 8C65F220 7CA5D800 3C030580 3463B053  
    00A32826 2403000A 24040004 0065200A 24050064 0040F809 00003021 3C02BF81  
    8C43F220 7C63D800 3C020580 3442B053 1462000C 3C02BF81 8C43FA90 24040001  
    7C831804 AC43FA90 3C02BF81 8C43FCA0 24040006 7C831804 AC43FCA0 1000000B  
    3C02BF80 8C43FA90 24040007 7C831804 AC43FA90 3C02BF81 8C43FC9C 24040006  
    7C831804 AC43FC9C 3C02BF80 34038260 AC435A00 24030C00 AC435A40 3C029D00  
    8C42008C AC4000F8 02802021 0411FD3E 00000000 00402021 0411FED5 00000000  
    8E030000 24020001 1462000A 24020002 02802021 27A50011 0411FDCB 00000000  
    00402021 0411FECA 00000000 8E030000 24020002 54620022 8E030000 8EA50000  
    04A00006 02802021 0411FAA6 00000000 00402021 0411FEBE 00000000 8E660000  
    28C20100 1040000B 02802021 26250001 27A70020 0411FAF9 00000000 00402021  
    0411FEB3 00000000 8FA20020 10000008 A2220000 02202821 27A70020 0411FAEF  
    00000000 00402021 0411FEA9 00000000 8FA30020 8FA20068 AC430000 8E030000  
    24020003 5462007B 8E030000 8EA20000 04410005 3C029D00 8C42008C 8C4200F8  
    AEA20000 3C029D00 8C42008C 8C4400F8 8E630000 00831821 AC4300F8 8EB60000  
    241EFE00 02DEF024 02802021 03C02821 0411FA74 00000000 00402021 0411FE8C  
    00000000 8E660000 28C20100 02221021 AFA2002C 8EA20000 105E004C 32D601FF  
    AFB60028 3C029D00 8C420040 0040F809 24040200 0040B021 02802021 00402821  
    24060200 27A70020 0411FABC 00000000 00402021 0411FE76 00000000 02802021  
    03C02821 0411FA57 00000000 00402021 0411FE6F 00000000 8E650000 8FA20028  
    00452821 2CA20201 14400003 0000F021 24BEFE00 24050200 8FA30028 0065102A  
    10400009 8FA3002C 8FA40028 02C41021 02C52821 90640000 A0440000 24420001  
    1445FFFC 24630001 02802021 02C02821 8FA60020 27A70020 0411FBEF 00000000  
    00402021 0411FE52 00000000 13C0000D 02802021 8E650000 00BE2823 8FA2002C  
    00452821 03C03021 27A70020 0411FBE2 00000000 00402021 0411FE45 00000000  
    02802021 00002821 00003021 27A70020 0411FBD9 00000000 00402021 0411FE3C  
    00000000 10000013 8E030000 02802021 8FA5002C 27A70020 0411FBCF 00000000  
    00402021 0411FE32 00000000 02802021 00002821 00003021 27A70020 0411FBC6  
    00000000 00402021 0411FE29 00000000 8E030000 24020004 5462000A 8E030000  
    02802021 02E02821 27A60011 0411FD50 00000000 00402021 0411FE1D 00000000  
    8E030000 24020005 5462003C 8E030000 265200A0 02802021 02E02821 02403021  
    0411FDE1 00000000 00402021 0411FE10 00000000 92430008 24020016 5462000A  
    82420009 02802021 02E02821 02403021 0411FDD5 00000000 00402021 0411FE04  
    00000000 82420009 50400023 A2200000 92420008 30420010 54400006 2402003C  
    24130001 02331821 00001021 1000000C 2405000C A2220001 24020044 A2220002  
    24020069 A2220003 24020072 A2220004 2402003E A2220005 1000FFF2 24130006  
    02422021 90840009 A0640000 24420001 1445FFFB 24630001 2402000C AFA20020  
    26440009 0411F7E4 00000000 2673FFFF 02629821 A2330000 8E030000 24020006  
    5462003E 8E030000 3C029D00 8C420040 0040F809 3404C800 0040B821 02802021  
    27A50011 0411FCD0 00000000 00402021 0411FDCF 00000000 02802021 00002821  
    0411F9B0 00000000 00402021 0411FDC8 00000000 02E09021 0000B021 24130001  
    02802021 02402821 24060080 27A70020 0411FA02 00000000 00402021 0411FDBC  
    00000000 8FA30020 1860000E 00001021 02421821 80630000 54600006 24420001  
    52600004 24420001 AFA20020 00009821 24420001 8FA30020 0043202A 5480FFF5  
    02421821 24020080 14620003 02C3B021 1000FFE3 26520080 02F6B021 A2C00000  
    A2C00001 3C029D00 8C4200B8 02E02021 0040F809 00002821 8E030000 24020007  
    5462004D 8E020000 02802021 27A50011 0411FC95 00000000 00402021 0411FD94  
    00000000 02802021 00002821 0411F975 00000000 00402021 0411FD8D 00000000  
    3C129D00 8E420040 0040F809 24040100 00409821 8E5600C0 24120001 3C179D00  
    1000001D 241E000D 1452FFFF 02602021 8EE200C8 0040F809 02C02821 0040B021  
    02602021 0411F77C 00000000 02621821 A07E0000 2404000A A0640001 02802021  
    02602821 24460002 27A70020 0411FB0A 00000000 00402021 0411FD6D 00000000  
    82C20000 14400005 00000000 82C20001 50400005 A2600000 82C20000 1440FFE2  
    00000000 A2600000 A2600001 02802021 02602821 24060002 27A70020 0411FAF6  
    00000000 00402021 0411FD59 00000000 02802021 00002821 00003021 27A70020  
    0411FAED 00000000 00402021 0411FD50 00000000 8E020000 1440002D 3C029D00  
    8C420090 92230000 12A00006 A0430030 3C029D00 8C420090 8EA30000 10000005  
    A043003C 3C029D00 8C420090 24030002 A043003C 3C029D00 8C430090 80640030  
    8C420088 00041880 00621021 8C430000 24020065 1062000B 3C109D00 8E020010  
    24050008 0040F809 00003021 8E030090 8E020010 80640030 24050065 0040F809  
    00003021 3C109D00 8E030090 8E02001C 80640030 0040F809 2405FFFD 8E030090  
    8E02001C 80640030 0040F809 24050006 8FBF0054 8FBE0050 8FB7004C 8FB60048  
    8FB50044 8FB40040 8FB3003C 8FB20038 8FB10034 8FB00030 03E00008 27BD0058  
    '.rodata 
    'err0 
    6E6B6E55 206E776F 6F727265 000A0D72  
    'err1 
    6B736944 72724520 0A0D726F 00000000  
    'err2 
    20746F4E 64616552 000A0D79  
    'err3 
    46206F4E 0D656C69 0000000A 20746F4E 6E65704F 0A0D6465 00000000 20746F4E  
    62616E45 0D64656C 0000000A 46206F4E 20656C69 74737953 0A0D6D65 00000000  
    20746F4E 6E756F6D 0D646574 0000000A  
End CSub
'**************************Subs/CFUNCTIONS END*********************************************
