;
; ------------------------------------------------------------
;
;   PureBasic - MMReplace.exe
;   This utility impliments the following directives in MMEdit so long vaiable names and be substitued on loading.
;   this can be used to save space and/or increase speed but still allow the use of descriptive varaible names in the code.
;   #REPLACE longvariable shortvariable
;   MMReplace.exe can be placed anywhere. It is integrated to MMEdit by initially selecting menu item (with Shift Key held down)
;   Advanced/Run External Program
;   and then checking the option.
;   X Auto Run External Program on Load
;
;   MMEdit creates file TEMP.BAS and then calls MMReplace.exe which then actions the #REPLACE Directive,
;   control then returns the MMEdit which then Crunches and Loads the program in the now modified TEMP.BAS
;   MMEdit then deletes TEMP.BAS
;   Add #LIBRARYLOAD #LIBRARYSTART   #LIBRARYEND Directives
;   /*           
;   C style block comments allowed if markers placed in column 1
;   */
;   #PI_CLIPBOARD,#PI_AUTORUN,#PI_AUTOSAVE Directives added for Pi-Cromite
;   #ENDCODE directive added
;   AUTOSAVE now replaces AUTO for Pi-Cromite 5.04.15 onwards
;   Started addition of #ARRAYSTART and #ARRAYEND Directives to implement Nathans simpleArrayGenerator.exe
;   #ARRAYSTART string cfunction myStrArray
;   : Hello World
;   : Hello Moon 
;   #ARRAYEND
;   #ARRAYSTART int cfunction myIntArrays
;   : 1 2 3 4 5 6 7 8 9 10
;   : 10 20 30 40 50 60 70 80 90 100 
;   #ARRAYEND
;   #ARRAYGENERATE       - causes the arrays to be regenerated. Comment if not required.  To DO !!!!!!!!!!!!!!!!!!!!
;   #ARRAYINCLUDE myStrArray
;   #ARRAYINCLUDE myIntArrays
;   Allow call to MMBASIC DOS Version if #PI_CLIPBOARD directive does not exist and syntax file is DOS_V4.5
;   Shift + 'File/Run In DOS' menu assigned to MMBasic.CMD which then runs MMReplace.exe with an additional parameter
;   containing location of DOS version i.e. MMBasic.exe . Contents of CMD file is single line as below.
;   @start C:\Users\Gerry\Documents\MMBasic\MMREPLACE.EXE %1 "C:\Program Files (x86)\MMBASIC\mmbasic.exe"
;
;   Shift + 'Advanced/Run external Program' menu assigned to MMReplace.exe
;   #ESP_CLIPBOARD and #ESP_KEEPCOMMENTS Directives added to support ESPBASIC
;   Relaxed constaints on column 1
;   Load Library for maximite added #LIBRARYLOAD filename.lib
;   added version number.and clear any comment after #LIBRARYLOAD directive.
; ------------------------------------------------------------
version$="1.01 - 15 Apr 2018" ; Added version number and clear any comment after #LIBRARYLOAD directive.
version$="1.02 - 15 Apr 2018" ; /* */ aropund library handled. multiple library handled
version$="1.03 - 16 Apr 2018" ; #LIBRARYLOAD filename for maximite will only load one library
version$="1.04 - 17 Apr 2018" ;fixed issue with maximitelibexists=1 on permanately
version$="1.05 - 26 may 2018" ;allow use of quotes or no quotes in PI_AUTOSAVE directive
version$="1.06 - 26 jan 2019" ;allow #LOADLIBRARY1,#LOADLIBRARY2,#LIBRARYSTART1,#LIBRARYSTART2
version$="1.07 - 27 jan 2019" ;allow comment before : in arraydefinition ie.':  Stops syntax highlighting
                              ;MMReplace32.exe is 32bit version
    Dim rep$(1000,2)
    dlay   = 4000                                  ; delay will set to 4000
    dev=0
     verbose=0
     
     inlibrary=0
     loadlibrary=0
     comments=0
     specialseparators$=~"\n"+~"\t"+~"\r"+~"\f"
     separators$=" ,()-+/\*<>=!:'$&" + specialseparators$+Chr(34)
     linecount=0
     replacecount=0
     clipboard=0
     esp=0
     autorun=0
     autosave=0
     endcode=0
     savefile$="PROG1.BAS"
     mmbasic$="C:\Program Files (x86)\MMBASIC\mmbasic.exe"
     mmbasicdos=0
     cfgfilestr$=""
     cfgfilename$=""
     inarray=0
     filepath$=""
     arraypath$=""
     incline$=""
     keepespcomments=0
     arraygenerate=0
     maximitelib=0
     maximitelibexists=0
     maximiteliblist$=""
     libfilestr$=""
     libfilename$=""
;
;-------- Open our Console --------
;

    OpenConsole()                                  ; First we must open a console
    ConsoleTitle ("#REPLACE Directive for MMEdit")  ; Now we can give the opened console a Titlename ;)                                                  
       
    ConsoleLocate (18,12)                          ; x y position 
            
    ClearConsole()  ; This will clean the ConsoleScreen
    PrintN ("MMReplace version " +version$)
   

    If CountProgramParameters()>=1 
      filename$=ProgramParameter(0)    ;' get passed in filename
      If CountProgramParameters()=2
        mmbasic$=ProgramParameter(1)    ;' get path for DOS mmbasic.exe
        mmbasicdos=1
      EndIf  
      If (filename$="tempin.bas")
        dev=1
        verbose=1
        arraypath$=GetCurrentDirectory()
        filepath$=GetCurrentDirectory()
      Else 
        arraypath$=GetPathPart( ProgramFilename())
        filepath$=GetPathPart( filename$)
        If ReadFile(3, arraypath$+"debug.txt")   ; if the file could be read, verbose=1
           verbose=1
           CloseFile(3)               ; close the previously opened file
           PrintN(arraypath$+"debug.txt found - verbose mode")
        EndIf

      EndIf  
      PrintN ("Passed Parameter=" +filename$)
      PrintN ("Array Executable=" +arraypath$+"simpleArrayFuncGen.exe")
      ;simpleArrayFuncGen.exe -cfgin CfunctionInt.cfg -progout CfunctionInt.bas
      ; first line is below
      ;*int cfunction myIntArrayCFunct # *int <cfunction|csub> <outputFunctionName>
      ;*string cfunction myStrArrayFunction # *string <cfunction|csub> <outputFunctionName>
      ;Delay(1000)
    Else
       PrintN ("The filename to process must be passed as a commandline parameter")
       PrintN("Press return to exit")
       a$=Input()
       CloseConsole()
       End
    EndIf 
   
     
    ;Read the file
    If ReadFile(0, FileName$)
       ;totalfile$="  'Replacement done"+~"\r\n" 
       While Eof(0) = 0 And endcode=0          ; loop as long the 'end of file' isn't reached and #ENDCODE not found
         thisline$=ReadString(0)
         If esp=1
           thisline$=LTrim(thisline$)
         EndIf  
         If (FindString(LTrim(thisline$), "#ENDCODE",0,#PB_String_NoCase)=1)
           endcode=1
         Else
         ; ************** REPLACE DIRECTIVE **************************  
         rs=FindString(LTrim(thisline$), "#REPLACE",0,#PB_String_NoCase )
         rem=FindString(thisline$, "'" )
         If (rs>0)  ;Its a  #REPLACE
           If (rem=0 Or rs<rem)
             ;not commented out
             PrintN(thisline$)
             ;PrintN (Str(rs)+" "+ Str(rem))
             rep$( replacecount,0)=StringField(LTrim(thisline$), 2, " ")
             rep$( replacecount,1)=StringField(LTrim(thisline$), 3, " ")
             If esp=0
               thisline$="'"+thisline$+~"\r\n"
             Else
               thisline$=";"+thisline$+~"\r\n"
             EndIf  
             replacecount=replacecount+1
             ;Keep directives for now unless its commented with ;
             If loadlibrary=0
                If (FindString(thisline$, ";",0,#PB_String_NoCase)<>1)
                  totalfile$=totalfile$+thisline$
                EndIf  
             EndIf  
           EndIf
         Else  ;Not a #replace
              If (FindString(LTrim(thisline$), "/*",0,#PB_String_NoCase)=1)
                comments=1
                PrintN("Directive /* comment start found")
              EndIf
              ;******************************simpleARRAYGEN Directives *************************************
                If (FindString(LTrim(thisline$), "#ARRAYGENERATE",0,#PB_String_NoCase)=1)  ; generate array using simpleArrayCommandLine
                    arraygenerate=1
                    PrintN("Directive ARRAYGENERATE  found: array  CSUB/CFUNCTION  will regenerate")
                    thisline$="'"+thisline$ 
                EndIf 
               If (FindString(LTrim(thisline$), "#ARRAYEND",0,#PB_String_NoCase)=1)    ; now execute the command and set a flag 
                 
                  thisline$="'"+thisline$                                                             
                  inarray=0
                  PrintN("Directive ARRAYEND  found")
                  ;PrintN(cfgfilestr$)
                  If arraygenerate=1 
                   If CreateFile(1,  cfgfilename$)    ; opens an existing file or creates one, if it does not exist yet 
                     WriteString(1, cfgfilestr$)
                     CloseFile(1)
                   Else
                      PrintN("Failed to create "+arraypath$+cfgfilename$)
                   EndIf  
                  
                   If RunProgram(arraypath$+"simpleArrayFuncGen.exe",parms$,"",#PB_Program_Wait   )
                        PrintN("simpleArrayFuncGen.exe was run")
                   Else 
                        PrintN("simpleArrayFuncGen.exe fail to start with: " +arraypath$+"simpleArrayFuncGen.exe" +" "+parms$)
                   EndIf
                  EndIf 
              EndIf 
              If inarray=1
                 ;remove comment in front of : if used
                  If (FindString(LTrim(thisline$), "':",0,#PB_String_NoCase)=1)
                    thisline$=Mid(thisline$,2)  
                  EndIf
                  cfgfilestr$=cfgfilestr$+thisline$+~"\r\n"
                  thisline$="'"+thisline$
              EndIf
              If (FindString(LTrim(thisline$), "#ARRAYSTART",0,#PB_String_NoCase)=1)  ; start of array definition
                                                                                      ; Create a CFG file from the array elements
                  thisline$=LTrim(thisline$) 
                 
                  inarray=1 
                  cfgfilename$= filepath$+"z_"+StringField(thisline$,4, " ")+".cfg" 
                  parms$="-cfgin " + cfgfilename$ + " -progout "+filepath$+"z_"+StringField(thisline$,4, " ")+".bas"
                  cfgfilestr$="*"+LCase(StringField(thisline$, 2, " "))+" "+LCase(StringField(thisline$, 3, " "))+" "+StringField(thisline$, 4, " ")+~"\r\n"
                  PrintN("Directive ARRAYSTART  found with files")
                  PrintN("   -cfgin " + cfgfilename$)
                  PrintN("   -progout "+filepath$+"z_"+StringField(thisline$,4, " ")+".bas")
                  thisline$="'"+thisline$ 
              EndIf 
              If (FindString(LTrim(thisline$), "#ARRAYINCLUDE",0,#PB_String_NoCase)=1)  ; generate incude for mmedit
                IncludeFile$=filepath$+"z_"+StringField(thisline$, 2, " ")+".bas"
                 PrintN("Directive #ARRAYINCLUDE found-"+IncludeFile$)
                thisline$="'"+thisline$+~"\r\n" +~"\r\n"
                ;thisline$="'#INCLUDE "+filepath$+StringField(thisline$, 2, " ")+".bas"
                 If ReadFile(2,IncludeFile$)
                   While Eof(2) = 0         ; loop as long the 'end of file' isn't reached 
                     incline$=ReadString(2)
                     ;PrintN("--->"+incline$+ Str(FindString(incline$, "End CFunction",0,#PB_String_NoCase)))
                     p=FindString(incline$, "End CFunction",0,#PB_String_NoCase)
                     If p>0
                       incline$=Left(incline$,p-1)+~"\r\n"+"End CFunction"
                     EndIf 
                     q=FindString(incline$, "End CSub",0,#PB_String_NoCase)
                     If q>0
                       incline$=Left(incline$,q-1)+~"\r\n"+"End CSub"
                     EndIf 
                     thisline$=thisline$+incline$+~"\r\n"
                   Wend
                   CloseFile(2) 
                   thisline$=thisline$+~"\r\n"
                   PrintN("   -  File included :"+ IncludeFile$)
                 Else 
                   PrintN("   -  File NOT FOUND :"+ IncludeFile$)  
                 EndIf
               EndIf 
               
             ; *************ESPBASIC DIRECTIVES ******************************** 
             If (FindString(LTrim(thisline$), "#ESP_KEEPCOMMENTS",0,#PB_String_NoCase)=1)
                keepespcomments=1
                 thisline$=";"+thisline$+~"\r\n"
                PrintN("Directive #ESP_CLIPBOARD found")
             EndIf   
             If (FindString(LTrim(thisline$), "#ESP_CLIPBOARD",0,#PB_String_NoCase)=1)
               If esp=0 
                clipboard=1
                esp=1
                mmbasicdos=0
                 ;thisline$=";"+thisline$+~"\r\n"
                PrintN("Directive #ESP_CLIPBOARD found - re reading file")
               
                ;*** Close and reopen and reread from start
                totalfile$=""
                thisline$=";"+thisline$+~"\r\n" 
                CloseFile(0)
                ReadFile(0, FileName$)
               Else
                 thisline$=";"+thisline$+~"\r\n" 
               EndIf  
              EndIf 
             ; *************PI-CROMITE DIRECTIVES ********************************  
             If (FindString(LTrim(thisline$), "#PI_CLIPBOARD",0,#PB_String_NoCase)=1)
                clipboard=1
                mmbasicdos=0
                thisline$="'"+thisline$   ;comment the directive.
                PrintN("Directive #PI_CLIPBOARD found")
             EndIf
             If (FindString(LTrim(thisline$), "#PI_AUTORUN",0,#PB_String_NoCase)=1)
                autorun=1
                thisline$="'"+thisline$   ;comment the directive.
                PrintN("Directive #PI_AUTORUN found")
             EndIf 
             If (FindString(LTrim(thisline$), "#PI_AUTOSAVE",0,#PB_String_NoCase)=1)
                autosave=1
                savefile$=LTrim(ReplaceString(thisline$,"#PI_AUTOSAVE","",#PB_String_NoCase ))
                savefile$=ReplaceString(savefile$,Chr(34),"",#PB_String_NoCase )
                thisline$="'"+thisline$   ;comment the directive.
                PrintN("Directive #PI_AUTOSAVE found -"+savefile$)
             EndIf  
             
             
             ; ******************Library directives ****************************** 
             If (FindString(LTrim(thisline$), "#LIBRARYLOAD2",0,#PB_String_NoCase)=1)
                ;PrintN(Str(comments))
                If comments=0
                 PrintN("Directive #LIBRARYLOAD1 found:"+thisline$)
                 loadlibrary=3 
                 totalfile$=""  ; clear anything incase there is code above #LOADLIBRARY
               EndIf 
             ElseIf (FindString(LTrim(thisline$), "#LIBRARYLOAD1",0,#PB_String_NoCase)=1)
                ;PrintN(Str(comments))
                If comments=0
                 PrintN("Directive #LIBRARYLOAD1 found:"+thisline$)
                 loadlibrary=2 
                 totalfile$=""  ; clear anything incase there is code above #LOADLIBRARY
                EndIf   
             ElseIf (FindString(LTrim(thisline$), "#LIBRARYLOAD",0,#PB_String_NoCase)=1)
                ;PrintN(Str(comments))
                If comments=0
                 PrintN("Directive #LIBRARYLOAD found:"+thisline$)
                 loadlibrary=1
                 thisline$=LTrim(thisline$)
                 thisline$=ReplaceString(thisline$,Chr(8)," ",#PB_String_NoCase )
                 thisline$=ReplaceString(thisline$,"  "," ",#PB_String_NoCase )
                 If LTrim(RTrim( StringField(thisline$,2, " ") ))<>"" 
                  maximitelib=1
                  ;comment after directive
                  c=FindString(RTrim(thisline$), "'",0,#PB_String_NoCase)
                  If c>1  ;comment after directive
                     thisline$=RTrim(Left(thisline$,c-1))
                  EndIf 
                  libfilename$= LTrim(RTrim( StringField(thisline$,2, " ")))
                  If (FindString(LTrim(libfilename$), ".lib",0,#PB_String_NoCase)=0)
                    libfilename$=libfilename$+".lib"
                   EndIf
                  libfilename$=filepath$+libfilename$
                  PrintN("Maximite #LIBRARYLOAD found for " + libfilename$)
                  ;PrintN(thisline$)
                EndIf    
                totalfile$=""  ; clear anything incase there is code above #LOADLIBRARY
               EndIf 
             ElseIf (FindString(LTrim(thisline$), "#LIBRARYSTART2",0,#PB_String_NoCase)=1)
               If comments=0
                PrintN("Directive #LIBRARYSTART1 found")
                inlibrary=3
                PrintN(thisline$)
               EndIf   
              
             ElseIf (FindString(LTrim(thisline$), "#LIBRARYSTART1",0,#PB_String_NoCase)=1)
               If comments=0
                PrintN("Directive #LIBRARYSTART1 found")
                inlibrary=2
                PrintN(thisline$)
               EndIf  
             ElseIf (FindString(LTrim(thisline$), "#LIBRARYSTART",0,#PB_String_NoCase)=1)
               If comments=0
                PrintN("Directive #LIBRARYSTART found")
                inlibrary=1
                PrintN(thisline$)
               EndIf  
             ElseIf (FindString(LTrim(thisline$), "#LIBRARYEND",0,#PB_String_NoCase)=1)
               If comments=0
                PrintN("Directive #LIBRARYEND found")
                PrintN(thisline$)
                inlibrary=0
                If maximitelib=1
                   PrintN("Writing LIB file for SDCARD Xfer "+libfilename$)
                   If CreateFile(1,  libfilename$)    ; opens an existing file or creates one, if it does not exist yet 
                    ; PrintN(libfilestr$)
                     WriteString(1, libfilestr$)
                     CloseFile(1)
                     libfilestr$=""
                   Else
                      PrintN("Failed to create "+libfilename$)
                   EndIf
                   maximitelib=0
                   loadlibrary=1 ; cancel any further library unless it has own #LOADLIBRARY
                   maximitelibexists=1
                 EndIf 
               EndIf 
             Else 
               If comments=0 
                 If (loadlibrary=1)
                  If inlibrary=1 
                    thisline$=thisline$+~"\r\n"
                    totalfile$=totalfile$+thisline$
                    libfilestr$=libfilestr$+thisline$
                    ;PrintN("In LIBRARY "+thisline$)
                  EndIf  
                  
                ElseIf (loadlibrary=2)
                  If inlibrary=2 
                    thisline$=thisline$+~"\r\n"
                    totalfile$=totalfile$+thisline$
                    libfilestr$=libfilestr$+thisline$
                    ;PrintN("In LIBRARY1 "+thisline$)
                  EndIf 
                ElseIf (loadlibrary=3)
                  If inlibrary=3 
                    thisline$=thisline$+~"\r\n"
                    totalfile$=totalfile$+thisline$
                    libfilestr$=libfilestr$+thisline$
                    ;PrintN("In LIBRARY1 "+thisline$)
                  EndIf    
                  
                Else
                   ;******************* output non library code ********************** 
                  If inlibrary=0 
                    If esp=0
                       thisline$=thisline$+~"\r\n"
                       totalfile$=totalfile$+thisline$
                     Else  ;its espbasic so remove comments unless keepespcomments=1
                       If thisline$=""
                          thisline$=";"
                       EndIf
                      If (FindString(thisline$, ";",0,#PB_String_NoCase)<>1)
                       If keepespcomments=1
                           thisline$=thisline$+~"\r\n"
                           totalfile$=totalfile$+thisline$
                          
                       Else  
                          If (FindString(thisline$, "'",0,#PB_String_NoCase)<>0)
                            c=FindString(thisline$, "'",0,#PB_String_NoCase)
                            If c>1  ;esp code with comment after code
                             thisline$=RTrim(Left(thisline$,c-1))+~"\r\n"
                             totalfile$=totalfile$+thisline$
                            Else 
                              ;do nothing its a comment line we will leaveout fully
                            EndIf           
                          Else
                             thisline$=thisline$+~"\r\n"
                             totalfile$=totalfile$+thisline$
                           EndIf
                         EndIf  
                       EndIf  ; a directive in ESP so remove
                      EndIf 
                   EndIf  
                 EndIf  
              Else
                ;comments=1 so keep lines but comment them so MMEdit keeps track of line numbers
                If (FindString(LTrim(thisline$), "*/",0,#PB_String_NoCase)=1)
                   comments=0
                   thisline$="'"+thisline$+~"\r\n"   ;comment the directive.
                   totalfile$=totalfile$+thisline$
                   PrintN("Directive */ comment end found")
                Else   
                   thisline$="'"+thisline$+~"\r\n"
                   totalfile$=totalfile$+thisline$
                EndIf
                
               EndIf
             EndIf ;end library code
              
          EndIf ;matches #replace
         EndIf ;matches else for #ENDCODE
        
       Wend
       CloseFile(0)
       PrintN ("TotalLines= "+Str(linecount))
       PrintN ("Total #REPLACE = "+Str(replacecount))
    Else
       PrintN ("Cant open file for reading - " +filename$)  
       PrintN("Press return to exit")

       a$=Input()
       CloseConsole()
       End
     EndIf
     For r=0 To replacecount-1
       For i=1 To Len(separators$)
         totalfile$=ReplaceString(totalfile$,rep$( r,0)+Mid(separators$,i,1),rep$( r,1)+Mid(separators$,i,1),#PB_String_NoCase )
       Next i  
     Next r 
     If dev=1
       If CreateFile(1, "TEMPOUT.BAS")    ; opens an existing file or creates one, if it does not exist yet 
         If clipboard=0 
           WriteString(1, totalfile$) 
         Else
           WriteString(1, "'Nothing to load")
           SetClipboardText(totalfile$)

         EndIf  
         CloseFile(1)
         PrintN("Press return to continue")
         a$=Input()
         
       EndIf
     EndIf  
     If dev=0
       If CreateFile(1, FileName$)    ; opens an existing file or creates one, if it does not exist yet 
         If clipboard=0 
           If maximitelibexists=1
             q$=Chr(34)
             maximiteliblist$="? "+q$+"Library files saved and ready to transfer to the SDCard"+q$+~"\r\n"
             maximiteliblist$= maximiteliblist$+"? "+~"\r\n"
             maximiteliblist$= maximiteliblist$+"? "+q$+"If you used menu Advanced/Run External Program then"+q$+~"\r\n"
             maximiteliblist$= maximiteliblist$+"? "+q$+"use menu Edit/Undo to restore your code in MMEdit."+q$+~"\r\n"
             maximiteliblist$= maximiteliblist$+"? "+~"\r\n"
             maximiteliblist$= maximiteliblist$+"? "+q$+"If you used the Load and Run icon MMEdit is unchanged,however"+q$+~"\r\n"
             maximiteliblist$= maximiteliblist$+"? "+q$+"your Maximite (CMM) code needs to be reloaded "+q$+~"\r\n"
              totalfile$=maximiteliblist$
           EndIf  
           WriteString(1, totalfile$)
           CloseFile(1)
           If mmbasicdos=1
             WriteString(1, totalfile$)
             ;execute MMBASICDOS VERSION
             ;PrintN("MMBASICDOS Running" +mmbasic$ +" "+FileName$)
             ;a$=Input()
             If RunProgram(mmbasic$ ,FileName$,"")
                
             Else 
                PrintN("MMDOS fail to start with: " +mmbasic$ +" "+FileName$)
             EndIf
           EndIf  
         Else
           If esp=0 ;its a pi
            WriteString(1, "'#NOLOAD")
            CloseFile(1)
            If autorun=0 And autosave=0
               SetClipboardText("AUTOSAVE"+~"\r\n"+totalfile$+Chr(3))
            ElseIf autorun=1 And autosave=0   
             SetClipboardText("AUTOSAVE"+~"\r\n"+totalfile$+Chr(3)+"RUN"+~"\r\n")
            ElseIf autorun=0 And autosave=1  
             SetClipboardText("AUTOSAVE"+~"\r\n"+totalfile$+Chr(3)+"SAVE "+Chr(34)+savefile$+Chr(34)+~"\r\n")
            ElseIf autorun=1 And autosave=1   
               SetClipboardText(Chr(3)+"AUTOSAVE"+~"\r\n"+totalfile$+Chr(3)+"SAVE "+Chr(34)+savefile$+Chr(34)+~"\r\n"+"CLS CONSOLE"+~"\r\n"+"RUN"+~"\r\n")  
             EndIf
           Else ;load ESP Data into clipboard
              SetClipboardText(totalfile$)
           EndIf  
         EndIf  
         
         ;If  DeleteFile(FileName$)
         ;  PrintN("Deleted "+FileName$)
         ;EndIf  
      EndIf 
      ;Delay (2000) 
       If verbose=1
         PrintN("Press return to continue")
         a$=Input()
       EndIf  
     EndIf
   

    CloseConsole()
End
; IDE Options = PureBasic 5.73 LTS (Windows - x64)
; ExecutableFormat = Console
; CursorPosition = 52
; FirstLine = 29
; EnableXP
; Executable = ..\MMBasic\MMReplace32.exe
; DisableDebugger
; CommandLine = tempin.bas
; Compiler = PureBasic 5.73 LTS (Windows - x86)