REM TINYTREK.BAS -- Guy "djwildstar" Garnett <djwildstar@me.com> 10/9/2020
REM Converted JF Gaffney's TINYTREK.ENT from TINY BASIC to MaxiMite 2 BASIC.
REM Source code obtained from HTTPS://www.sol20.org/programs.html was 
REM was identified as D:\CPM\TINY dated Wed 11-15-1989 16:13:19.06 and
REM converted from Palo Alto Tiny BASIC (PATB) to the Color MexiMite 2's
REM dialect of MaxiMite BASIC (MMBasic). This conversion necessitated a few 
REM changes to the code:
REM  * PATB allows abbreviated keywords (minimum distinct name plus a period,
REM    such as P. for PRINT) which needed to be expanded for MMBasic. The full
REM    list of PATB keywoards is:
REM      A. = ABS       IN. = INPUT   P. = PEEK     R. = RUN    U. = USR
REM      F. = FOR       L. = LIST     P. = POKE     S. = SAVE   W. = WAIT
REM      GOS. = GOSUB   LO. = LOAD    PR. = PRINT   S. = SIZE
REM      G. = GOTO      N. = NEW      R. = RETURN   S. = STEP
REM      I. = INP       O. = OUTPUT   R. = RND      S. = STOP
REM    Note that thee is no abbreviation for the IF, REM, or TO keywords, and
REM    that the interpretation of an abbreviation may vary by context (S. is 
REM    SAVE in immediate mode, the SIZE function in an expression, STEP when
REM    part of a FOR statement, or STOP when used as a command).
REM  * PATB performs an assignment statement if no valid keyword is found (for
REM    example, X=3, LET X=3, and BLARG X=3 all perform an assignment). PATB
REM    also allows multiple assignments separated by commas. In the MMBasic
REM    conversion I have used an explicit LET statement for clarity.
REM  * PATB uses a #N format specifier in the PRINT statement, which has been
REM    replaced with the MMBasic FORMAT$ function.
REM  * PATB permits multiple statements on a line separated by semicolons.
REM    These have been replaced with the colon notation used by MMBasic.
REM  * The PATB syntax for IF does not employ THEN, while MMBasic does.
REM  * PATB is a 16-bit integer BASIC with limited operators and functions,
REM    while MMBasic is a double-precision floating point BASIC interpreter.
REM    This has necessitated several changes to arithmetic expressions:
REM     - MMBasic has different operators for division: / performs floating-
REM       point division, while \ performs integer division. So all use of
REM       the PATB division operator (/) have been replced with \ to force
REM       MMBasic to perform integer division.
REM     - PATB lacks the SGN function but has ABS, so the idiom X/ABS(X) is
REM       used to extract the sign of X. This has been replaced with SGN(X).
REM     - PATB provides a RND(X) function that generates a random integer
REM       beteen 1 and X inclusive. The MMBasic RND(X) function ignores the
REM       value of X and always returns a random floating-point value between
REM       0.000000 and 0.999999 inclusive. A RAND(X) function has been 
REM       provided below to provide the same functionality as PATB RND().
REM In addition PATB has a few quirks that are helpful in understanding the
REM original TINYTREK source code:
REM  * There are 26 integer variables named A through Z.
REM  * There is one single-dimensional integer array named @(), whicn consists
REM    of all othewise-unused memory. This array does not need to be declared
REM    and is always of dimension @(0) through @(SIZE/2). 
REM  * String literals may be used in INPUT and PRINT statements, and may be
REM    enclosed in either single or double quotes. There are no string
REM    variables, operators, or functions.
REM  * Anything typed in response to an INPUT statement is treated as an
REM    expression and evaluated - so if the user types A in response to
REM    INPUT X, then the value of the varialble A is stored in X.  This feature
REM    is used to permit alphbetic inputs in lines 5 and 120 of the program.
REM  * There are no string variable types.
REM Finally, I added a prompt to display game instructions before the start of
REM the game, so that users do not have to read the comments or the original
REM documentation file.
REM Original comments and documentation are included below.

OPTION DEFAULT INTEGER  ' PATB variables are 16-bit signed integers
DIM AT(153) AS INTEGER  ' Declare an MMBasic array to stand in for PATB @()
FUNCTION RAND(X AS INTEGER) AS INTEGER
  LET RAND = 1+FIX(RND*X)
END FUNCTION

INPUT "DO YOU WANT INSTRUCTIONS? (Y OR N): ",Z$
IF UCASE$(LEFT$(Z$,1)) = "Y" THEN
  PRINT "This is a modified version of Lynn Cochran's STARTREK, as published in the June"
  PRINT "1976 issue of SCCS Interface and subsquently modified to run under Palo Alto"
  PRINT "Tiny BASIC and subsequently CMM2 MMBasic."
  PRINT
  PRINT "The game is played in a galaxy of 64 quadrants in an 8x8 array.  Each quadrant"
  PRINT "consists of 64 sectors in an 8x8 array.  The objective of the game is to destroy"
  PRINT "all Klingon vessels in the galaxy before time expires."
  PRINT
  PRINT "The available commands are:"
  PRINT "  GALAXY to display the galaxy map."
  PRINT "  LONG to perform a long-range scan."
  PRINT "  PHASER to fire phasers."
  PRINT "  REPORT to print a status report."
  PRINT "  SHORT to perform a short-range scan."
  PRINT "  TORPEDO to fire photon torpedos."
  PRINT "  WARP for warp navigtion."
  PRINT "All commands can be abbreviated to the first letter."
  PRINT
  PRINT "Course (for warp navigation) and direction (for torpedo fire) is in degrees from"
  PRINT "0 to 360 inclusive - 0 is North, 90 is East, 180 is South, and 270 is West."
  PRINT
  PRINT "Warp distance is given in sectors.  Each quadrant is 8 sectors, so to move 3"
  PRINT "quadrants, enter 24 sectors.  Each warp takes 1 stardate, but longer distances"
  PRINT "require more energy."
  PRINT
  PRINT "Dock at starbases to replenish your energy and torpedos."
  PRINT
  PRINT "The long-range scan and galaxy maps use a 3-digit number to show the number of"
  PRINT "Klingons, number of starbases, and number of stars in a quadrant.  For example,"
  PRINT "a value of 103 means 1 Klingon, 0 bases, and 3 stars.  The galaxy map is updated"
  PRINT "only when short-range or long-range scans are performed."
  PRINT
  PRINT "The short range scan shows the position of the Enterprise (E), Klingon ships (K)"
  PRINT "starbases (B), and stars (*) within the quadrant."
  PRINT
ENDIF

REM TINYTREK.ENT -- jfgaffney 08/30/01
REM Summary: This is Dr. Li-Chen Wang's Palo Alto Tiny BASIC ver 2.0 hooked up
REM to Sol I/O and Dr. Wang's version of the Startrek game called TinyTrek.
REM The BASIC and game run in 8k of ram (0-1FFF) on a Sol-20. BASIC is located
REM at (0-0768) and (1F66-1FFF).
REM Details: The first version of Palo Alto Tiny Basic (PATB) appeared in the
REM May 1976 Vol 1, No. 5 issue of Dr. Dobb's Journal of Computer Calisthenics
REM & Orthodontia. An errata was in June/July issue. The Lynn Cochran Startrek
REM program appeared in Interface (Age) June 1976. MITS 8k Basic and the program
REM would run in an Altair with 12k of ram. The Dr. Wang TinyTrek program
REM appeared in July issue of PCC (Peoples Computer Company newsprint journal).
REM The ver 2.0 of PATB appeared in Interface Age December 1976. Roger Rauskolb
REM did this version, giving full credit to Dr. Wang. He translated the
REM mnemonics to standard Intel 8080 from Dr. Wang's use of an obscure IBM set
REM and he relocated the program to run at low memory. He made some fixes and
REM introduced a bad error in the subtraction routine, errata in May 1977 issue.
REM I have one of the first Sol computers. I received the main card kit in
REM December 1976 and the remainder in January 1977. Only the Consol OS was
REM provided at the time. I also had ptc 8k static RAM card. I had to devise my
REM own tape write routine, hand assemble and key it into 1k system RAM. After
REM getting usable tape saves with a JCPenny recorder, PATB and game was the
REM first program of substance that I keyed in and my notes indicate I had the
REM program working Feb 7, 1977.
REM A few days ago I turned on this Sol-20 after about 2 years non-use. I found
REM it fully functional except keyboard keypads. I took it apart to replace
REM essential pads, but I found all of my spare pads useless also. I wound up
REM using the bare PC card as a touch keypad to get this program off a North
REM Star disk.
REM
REM STARTREK: THIS IS A MODIFIED VERSION OF LYNN COCHRAN'S STARTREK (PUBLISHED
REM IN THE JUNE 1976 ISSUE OF SCCS INTERFACE). IT IS CODED IN TINY BASIC (PALO
REM ALTO VERSION) AND THUS TAKES LESS MEMORY (8K INSTEAD OF 12K) AND IS FASTER
REM (4 SECONDS TO SET UP THE GALAXY MOST OF THE TIME, INSTEAD OF 10 SECONDS).
REM IT IS A LITTLE DIFFERENT FROM LYNN'S VERSION:
REM (1) COMMANDS ARE GIVEN IN WORDS INSTEAD OF NUMBERS.
REM   W OR WARP FOR WARP ENGINE
REM   T OR TORPEDO FOR PHOTON TORPEDO
REM   P OR PHASER FOR PHASERS
REM   S OR SHORT FOR SHORT RANGE SCAN
REM   L OR LONG FOR LONG RANGE SCAN
REM   G OR GALAXY FOR GALAXY MAP
REM (2) THERE IS ONE MORE COMMAND: 'REPORT' OR 'R' WHICH PRINT NTS OUT PERTINENT
REM     INFORMATION (INCLUDING DAMAGES).
REM (3) DIRECTION (OR COURSE) IS GIVEN IN DEGREES (0 FOR NORTH, 90 FOR EAST,
REM     180 FOR SOUTH, AND 270 FOR WEST), AND DISTANCE (OR WARPS) IS GIVEN IN
REM     UNITS OF SECTORS. BOTH MUST BE INTEGERS.
REM (4) THE WARP ENGINE HAS BETTER CONTROLS NOW. YOU CAN MOVE PRECISLY TO WHERE
REM     YOU WANT TO GO, EVEN AFTER CROSSING THE QUADRANT BOUNDARY. IT STILL 
REM     TAKES 1 STARDATE TO MAKE A MOVE, BUT FOR LONG DISTANCE MOVES YOU WILL
REM     BURN A DISPRINT PORTIONALLY LARGE AMOUNT OF ENERGY.
REM (5) WHEN KLINGONS FIRE AT YOU, YOU COULD GET HURT NOW. (IN LYNN'S VERSION,
REM     THEY CANNOT DAMAGE YOU, AND THEY DEPLETE THEIR OWN ENERGY MORE THAN
REM     YOURS.)  SO, DON'T TRY TO SIT THERE AND WEAR THEM OUT.
REM (6) IF YOU HIT A KLINGON WITH YOUT PHOTON TORPEDO, THE KLINGON MIGHT NOT
REM     GET TOTALLY DESTROYED. ALSO, IF YOU HIT A STAR, IT MIGHT NOT GET
REM     EFFECTED AT ALL. WHEN A STAR IS DESTROYED, IT MIGHT NOVA AND THE
REM     RADIATION WILL HURT YOU.
REM (7) ON THE POSITIVE SIDE, YOU GET MORE ENERGY (4000 UNITS) AT EACH DOCKING,
REM     AND YOU ARE WELL PROTECTED BY YOUR SHIIELD. YOU NEVER GET HURT UNLESS
REM     THE SHIELD IS DAMAGED.
REM THE GALAXY CONSISTS OF 64 QUADRANTS IN AN 8 BY 8 ARRAY. EACH QUADRANT
REM CONSISTS OF 64 SECTORS IN AN 8 BY 8 ARRAY. WHEN YOU MOVE YOU GIVE THE
REM NUMBER OF SECTORS YOU WISH TO MOVE. THAT IS, 3 QUADRANTS WOULD BE 24
REM SECTORS (8 SECTORS X 3 QUADRANTS).

REM Converted code follows:
   5 LET Y=2999 : INPUT "DO YOU WANT A DIFFICULT GAME? (Y OR N): ",Z$
  10 PRINT "STARDATE 3200:  YOUR MISSION IS "; : IF UCASE$(LEFT$(Z$,1))="Y" THEN LET Y=999
  15 LET K=0 : LET B=0 : LET D=30 : FOR I=0 TO 63 : LET J=RAND(99)<5 : LET B=B+J
  20 LET M=RAND(Y) : LET M=(M<209)+(M<99)+(M<49)+(M<24)+(M<9)+(M<2) : LET K=K+M
  25 LET AT(I)=-100*M-10*J-RAND(8) : NEXT I : IF (B<2)+(K<4) THEN GOTO 15
  30 PRINT "TO DESTROY";K;" KLINGONS IN 30 STARDATES."
  35 PRINT "THERE ARE";B;" STARBASES." :  GOSUB 160 : LET C=0 : LET H=K
  40 LET U=RAND(8) : LET V=RAND(8) : LET X=RAND(8) : LET Y=RAND(8)
  45 FOR I=71 TO 152 : LET AT(I)=0 : NEXT I : LET AT(8*X+Y+62)=4 : LET M=ABS(AT(8*U+V-9)) : LET N=M\100
  50 LET I=1 : IF N THEN FOR J=1 TO N : GOSUB 165 : LET AT(J+134)=300 : LET AT(J+140)=S : LET AT(J+146)=T : NEXT J
  55 GOSUB 175 : LET M=M-100*N : LET I=2 : IF M\10 THEN GOSUB 165
  60 LET M=M-M\10*10 : LET I=3 : IF M THEN FOR J=1 TO M : GOSUB 165 : NEXT J
  65 GOSUB 145 : GOSUB 325 : IF K THEN GOTO 95
  70 PRINT : PRINT "MISSION ACCOMPLISHED." : IF D<3 THEN PRINT "BOY, YOU BARELY MADE IT."
  75 IF D>5 THEN PRINT "GOOD WORK..." : IF D>9 THEN PRINT "FANTASTIC!" : IF D>13 THEN PRINT "UNBELIEVABLE!"
  80 LET D=30-D : LET I=H*100\D*10 : PRINT H;" KLINGONS IN";D;" STARDATES. (";I;")"
  85 LET J=100*(C=0)-5*C : PRINT C;" CASUALTIES INCURRED. (";J;")"
  90 PRINT "YOUR SCORE:";I+J : GOTO 110
  95 IF D<0 THEN PRINT "IT'S TOO LATE, THE FEDERATION HAS BEEN CONQUERED." : GOTO 110
 100 IF E>=0 THEN GOTO 120
 105 PRINT "ENTERPRISE DESTROYED" : IF (H-K)>9 THEN PRINT "BUT YOU WERE A GOOD MAN"
 110 LET Y=987 : PRINT : INPUT "ANOTHERE GAME?  (Y OR N):",Z$ : IF A=Y THEN GOTO 5
 115 PRINT "GOOD BYE." : GOTO 650
 120 LET S=220 : LET G=180 : LET L=200 : LET P=260 : LET R=420 : LET W=465 : LET T=555 : INPUT "CAPTAIN: ",Z$
 125 SELECT CASE UCASE$(LEFT$(Z$,1)) : CASE "S":GOTO 220 : CASE "G":GOTO 180 : CASE "L":GOTO 200 : CASE "P":GOTO 260 : CASE "R":GOTO 420 : CASE "W":GOTO 465 : CASE "T":GOTO 555 : END SELECT
 130 PRINT "R=REPORT            S=SR SENSOR        L=LR SENSOR"
 135 PRINT "G=GALAXY MAP        P=PHASER           T=TORPEDO"
 140 PRINT "W=WARP ENGINE  **PLEASE USE ONE OF THESE COMMANDS**" : GOTO 120
 145 FOR I=X-(X>1) TO X+(X<8) : FOR J=Y-(Y>1) TO Y+(Y<8)
 150 IF AT(8*I+J+62)<>2 THEN NEXT J : NEXT I : LET O=0 : RETURN
 155 IF O=0 THEN PRINT "SULU: 'CAPTAIN, WE ARE DOCKED AT STARBASE.'"
 160 LET E=4000 : LET F=10 : LET O=1 : FOR I=64 TO 70 : AT(I)=0 : NEXT I : RETURN
 165 LET S=RAND(8) : LET T=RAND(8) : LET A=8*S+T+62 : IF AT(A) THEN GOTO 165
 170 LET AT(A)=I : RETURN
 175 PRINT "ENTERPRISE IN Q-";FORMAT$(U,"%1g");FORMAT$(V,"%1g");" S-";FORMAT$(X,"%1g");FORMAT$(Y,"%1g") : RETURN
 180 GOSUB 175 : LET J=2 : GOSUB 375 : IF I THEN GOTO 120
 185 PRINT " OF GALAXY MAP" : FOR I=0 TO 7 : PRINT : PRINT FORMAT$(I+1,"%1g");":"; : FOR J=0 TO 7 : LET M=AT(8*I+J)
 190 PRINT " ";FORMAT$((M>0)*M,"%03g"); : NEXT J : PRINT : NEXT I : PRINT "  "; : FOR I=0 TO 7 : PRINT " ..."; : NEXT I : PRINT 
 195 PRINT " "; : FOR I=1 TO 8 : PRINT "   ";FORMAT$(I,"%1g"); : NEXT I : PRINT : PRINT : GOTO 120
 200 GOSUB 175 : LET J=3 : GOSUB 375 : IF I GOTO 120
 205 PRINT : FOR I=U-1 TO U+1 : FOR J=V-1 TO V+1 : LET M=8*I+J-9 : LET A=0
 210 IF (I>0)*(I<9)*(J>0)*(J<9) THEN LET A=ABS(AT(M)) : LET AT(M)=A
 215 PRINT " ";FORMAT$(A,"%03g"), : NEXT J : PRINT : NEXT I : GOTO 120
 220 GOSUB 175 : LET J=1 : GOSUB 375 : IF I THEN GOTO 120
 225 LET M=8*U+V-9 : LET AT(M)=ABS(AT(M))
 230 PRINT : FOR I=1 TO 8 : PRINT FORMAT$(I,"%1g"); : FOR J=1 TO 8 : LET M=AT(8*I+J+62) : IF M=0 THEN PRINT " .";
 235 IF M=1 THEN PRINT " K";
 240 IF M=2 THEN PRINT " B";
 245 IF M=3 THEN PRINT " *";
 250 IF M=4 THEN PRINT " E";
 255 NEXT J : PRINT : NEXT I : PRINT "  "; : FOR I=1 TO 8 : PRINT FORMAT$(I,"%1g"), : NEXT I : PRINT : GOTO 120
 260 LET J=4 : GOSUB 375 : IF I THEN GOTO 120
 265 INPUT " ENERGIZED.  UNITS TO FIRE: ",A : IF A<1 THEN GOTO 120
 270 IF A>E THEN PRINT "SPOCK: 'WE HAVE ONLY";E;" UNITS.'" : GOTO 270
 275 LET E=E-A : IF N<1 THEN PRINT "PHASER FIRED AT EMPTY SPACE." : GOTO 65
 280 LET A=A\N : FOR M=135 TO 140 : IF AT(M)=0 GOTO 290
 285 GOSUB 295 : PRINT S;" UNITS HIT "; : GOSUB 305
 290 NEXT M : GOTO 65
 295 IF A>1090 THEN PRINT "..OVERLOADED.." : LET J=4 : LET AT(67)=1 : LET A=9 : GOSUB 375
 300 LET I=AT(M+6)-X : LET J=AT(M+12)-Y : LET S=A*30\(30+I*I+J*J)+1 : RETURN
 305 PRINT "KLINGON AT S-";FORMAT$(AT(M+6),"%1g");FORMAT$(AT(M+12),"%1g"); : LET AT(M)=AT(M)-S
 310 IF AT(M)>0 THEN PRINT " **DAMAGED**" : RETURN
 315 LET AT(M)=0 : LET I=8*U+V-9 : LET J=SGN(AT(I)) : LET AT(I)=AT(I)-100*J : LET K=K-1
 320 LET I=8*AT(M+6)+AT(M+12)+62 : LET AT(I)=0 : LET N=N-1 :  PRINT " ***DESTROYED***" : RETURN
 325 IF N=0 THEN RETURN
 330 PRINT "KLINGON ATTACK" : IF O THEN PRINT "STARBASE PROTECTS ENTERPRISE" : RETURN
 335 LET T=0 : FOR M=135 TO 140 : IF AT(M)=0 THEN GOTO 350
 340 LET A=(AT(M)+RAND(AT(M)))\2 : GOSUB 295 : LET T=T+S : LET I=AT(M+6) : LET J=AT(M+12)
 345 PRINT S;" UNITS HIT FROM KLINGON AT S-";FORMAT$(I,"%1g");FORMAT$(J,"%1g")
 350 NEXT M : LET E=E-T : IF E<=0 THEN PRINT "*** BANG ***" : RETURN
 355 PRINT E;" UNITS OF ENERGY LEFT." : IF RAND(E\4)>T THEN RETURN 
 360 IF AT(70)=0 THEN LET AT(70)=RAND(T\50+1) : LET J=7 : GOTO 375
 365 LET J=RAND(6) : LET AT(J+63)=RAND(T\99+1)+AT(J+63) : LET I=RAND(8)+1 : LET C=C+I
 370 PRINT "MC COY: 'SICKBAY  TO  BRIDGE, WE SUFFERED";I;" CASUALTIES.''"
 375 LET I=AT(J+63) : IF J=1 THEN PRINT "SHORT RANGE SENSOR";
 380 IF J=2 THEN PRINT "COMPUTER DISPLAY";
 385 IF J=3 THEN PRINT "LONG RANGE SENSOR";
 390 IF J=4 THEN PRINT "PHASER";
 395 IF J=5 THEN PRINT "WARP ENGINE";
 400 IF J=6 THEN PRINT "PHOTON TORPEDO TUBES";
 405 IF J=7 THEN PRINT "SHIELD";
 410 IF I=0 THEN RETURN
 415 PRINT " DAMAGED,";I;" STARDATES ESTIMATED FOR REPAIR" : RETURN
 420 PRINT "STATUS REPORT:" : PRINT "STARDATE";TAB(14);3230-D : PRINT "TIME LEFT";TAB(14);D
 425 PRINT "CONDITION";TAB(15); : IF O THEN PRINT "DOCKED" : GOTO 445
 430 IF N THEN PRINT "RED" : GOTO 445
 435 IF E<999 THEN PRINT "YELLOW" : GOTO 445
 440 PRINT "GREEN"
 445 PRINT "POSITION";TAB(15);"Q-";FORMAT$(U,"%1g");FORMAT$(V,"%1g");" S-";FORMAT$(X,"%1g");FORMAT$(Y,"%1g") : PRINT "ENERGY";TAB(14);E
 450 PRINT "TORPEDOES";TAB(14);F : PRINT "KLINGONS LEFT";TAB(14);K : PRINT "STARBASES";TAB(14);B
 455 FOR J=1 TO 7 : IF AT(J+63) THEN GOSUB 375
 460 NEXT J : GOTO 120
 465 LET J=5 : GOSUB 375 : IF I=0 THEN PRINT 
 470 INPUT "SECTOR DISTANCE: ",W : IF W<1 THEN GOTO 120
 475 IF I*(W>2) THEN PRINT "CHEKOV: 'WE CAN TRY 2 AT MOST, SIR.'"
 480 IF W>91 THEN LET W=91 : PRINT "SPOCK: 'ARE YOU SURE, CAPTAIN?'"
 485 IF E<W*W\2 THEN PRINT "SCOTTY: 'SIR, WE DO NOT HAVE THE ENERGY.'" : GOTO 470
 490 GOSUB 615 : IF R=0 THEN GOTO 120
 495 LET D=D-1 : LET E=E-W*W\2 : LET AT(8*X+Y+62)=0
 500 FOR M=64 TO 70 : LET AT(M)=(AT(M)-1)*(AT(M)>0) : NEXT M
 505 LET P=45*X+22 : LET G=45*Y+22 : LET W=45*W : FOR M=1 TO 8 : LET W=W-R : IF W<-22 THEN GOTO 525
 510 LET P=P+S : LET G=G+T : LET I=P\45 : LET J=G\45 : IF (I<1)+(I>8)+(J<1)+(J>8) THEN GOTO 530
 515 IF AT(8*I+J+62)=0 THEN LET X=I : LET Y=J : NEXT M
 520 PRINT "**EMERGENCY STOP**" : PRINT "SPOCK: 'TO ERR IS HUMAN.'"
 525 LET AT(8*X+Y+62)=4 : GOSUB 175 : GOTO 65
 530 LET P=U*72+P\5+W\5*S\R-9 : LET U=P\72 : LET G=V*72+G\5+W\5*T\R-9 : LET V=G\72
 535 IF RAND(9)<2 THEN PRINT "***SPACE STORM***" : LET T=100 : GOSUB 360
 540 IF (U>0)*(U<9)*(V>0)*(V<9) THEN LET X=(P+9-72*U)\9 : LET Y=(G+9-72*V)\9 : GOTO 45
 545 PRINT "**YOU WANDERED OUTSIDE THE GALAXY**"
 550 PRINT "ON BOARD COMPUTER TAKES OVER, AND SAVED YOUR LIFE" : GOTO 40
 555 LET J=6 : GOSUB 375 : IF I THEN GOTO 120
 560 IF F=0 THEN PRINT " EMPTY" : GOTO 120
 565 PRINT " LOADED" : GOSUB 615 : IF R=0 THEN GOTO 120
 570 PRINT "TORPEDO TRACK "; : LET F=F-1 : LET P=45*X+22 : LET G=45*Y+22 : FOR M=1 TO 8
 575 LET P=P+S : LET G=G+T : LET I=P\45 : LET J=G\45 : IF (I<1)+(I>8)+(J<1)+(J>8) THEN GOTO 585
 580 LET L=8*I+J+62 : LET W=8*U+V-9 : LET R=SGN(AT(W)) : PRINT FORMAT$(I,"%1g");FORMAT$(J,"%1g");" "; : GOTO 585+5*AT(L)
 585 NEXT M : PRINT "...MISSED" : GOTO 65
 590 LET S=RAND(99)+280 : FOR M=135 TO 140 : IF (AT(M+6)=I)*(AT(M+12)=J) THEN GOSUB 305
 592 NEXT M : GOTO 65
 595 LET B=B-1 : LET AT(L)=0 : LET AT(W)=AT(W)-10*R : PRINT "STARBASE DESTROYED"
 597 PRINT "SPOCK: 'I OFTEN FIND HUMAN BEHAVIOUR FASCINATING.'" : GOTO 65
 600 PRINT "HIT A STAR" : IF RAND(9)<3 THEN PRINT " TORPEDO ABSORBED" : GOTO 65
 605 LET AT(L)=0 : LET AT(W)=AT(W)-R : IF RAND(9)<6 THEN PRINT " STAR DESTROYED" : GOTO 65
 610 LET T=300 : PRINT " IT NOVAS": PRINT "***RADIATION ALARM***" : GOSUB 360 : GOTO 65
 615 INPUT "COURSE (0-360): ",I : IF (I>360)+(I<0) THEN R=0 : RETURN
 620 LET S=(I+45)\90 : LET I=I-S*90 : LET R=(45+I*I)\110+45 : GOTO 625+5*(S<4)*S
 625 LET S=-45 : LET T=I : RETURN
 630 LET S=I : LET T=45 : RETURN
 635 LET S=45 : LET T=-I : RETURN
 640 LET S=-I : LET T=-45 : RETURN
 650 END
