'23-DCMOT-ABDRIVE.BAS
'TWO DC MOTOR CONTROL
'DRK 20160226
'L9110 MOTOR CONTROL CHIP
'B-IA B-IB GND VCC(2.5-12V DC) A-IA A-IB
'SCREW: MOTOR B MOTOR A 
'ARF     A-B  R-L  F(ULL) M(IDDLE) L(OW) S(TOP)
'PWM:
'MM28 PWM1 A,B,C > 4,5,6 PWM2 A,B > 26,24
'MM44 PWM1A,B,C > 21,22,23 PWM2 A,B >15,11
'======[ INITIALIZING ]================================================
OPTION EXPLICIT
'PRG
CONST A1PIN=21, A2PIN=24, B1PIN=15, B2PIN=23
CONST M_A_DIR=A2PIN 'A-IB
CONST M_B_DIR=B2PIN 'B-IA
'APWM=21 BPWM=15
'A>21--24 B>15--23
CONST PWM_FAST=90,PWM_MID=60,PWM_SLOW=10
CONST F_TIME=100,M_TIME=80,L_TIME=25
DIM UT$
'======[ PROGRAM ]=====================================================
MAIN:
	MA_STOP
  MB_STOP    
DO
'MANUAL CONTROL:
  UT$=INSTRU$()
  ABCONTROL UT$
'TIMING CONTROL:
'  ABCONTROL "ARL"
'  ABCONTROL "BRF"
'  PAUSE 1000
'  ABCONTROL "ALF"
'  ABCONTROL "BLM"
'  PAUSE 3000
'  ABCONTROL "ALL"
'  ABCONTROL "BRL"
'  PAUSE 3000
LOOP
'======[ SUBROUTINES, FUNCTIONS ]======================================
'MOTOR MOVEMENT USER INTERFACE-OUTPUT:THREE VALID  LETTERS
FUNCTION INSTRU$() 
  LOCAL L$,M$,R$,INS$
UJRA:
  INS$=""
  PRINT
  PRINT "FORMAT: THREE LETTERS: MOTOR(A,B)-DIR(R,L)-SPEED(F,M,L,S)"
  INPUT "A,B--R,L--F(ULL),M(ID),(L)OW),S(TOP)   >>",INS$
  PRINT
	INS$=UCASE$(INS$): L$=LEFT$(INS$,1):M$=MID$(INS$,2,1):R$=RIGHT$(INS$,1) 
  IF (L$<>"A" AND L$<>"B")OR(M$<>"R" AND M$<>"L")OR(R$<>"F" AND R$<>"M" AND R$<>"L" AND R$<>"S") THEN 
  PRINT INS$,":ERROR!!!"
  GOTO UJRA   
  ENDIF 
  PRINT INS$
  INSTRU$=INS$
END FUNCTION
'MOTOR A AND B MOVEMENT CONTROL WITH THREE VALID LETTERS 
SUB ABCONTROL INST$
    LOCAL ASTATE,BSTATE
    IF INST$="BRS" THEN INST$="BLS"
    IF INST$="ARS" THEN INST$="ALS"         
    SELECT CASE INST$
'===============================================    
      CASE "ALF"		
        ASTATE=1:AFOROG 0,PWM_FAST
        PRINT "A FAST FORWARD..."                
      CASE "ALM"			'2-FORWARD 
        ASTATE=2:AFOROG 0,PWM_MID
        PRINT "A MID FORWARD..."         
      CASE "ALL"			'3-FORWARD 
        ASTATE=3:AFOROG 0,PWM_SLOW
        PRINT "A SLOW FORWARD..." 
      CASE "ARF"		
        ASTATE=4:AFOROG 1,PWM_SLOW
        PRINT "A FAST REVERSE..."                
      CASE "ARM"			'2-FORWARD 
        ASTATE=5:AFOROG 1,PWM_MID
        PRINT "A MID REVERSE..."         
      CASE "ARL"			'3-FORWARD 
        ASTATE=6:AFOROG 1,PWM_FAST
        PRINT "A SLOW REVERSE..."         
      CASE "ALS"			'3-FORWARD         
        IF ASTATE=1 THEN
        AFOROG 1,PWM_SLOW
        PAUSE F_TIME
        ENDIF
        IF ASTATE=2 THEN
        AFOROG 1,PWM_MID
        PAUSE M_TIME
        ENDIF       
        IF ASTATE=3 THEN
        AFOROG 1,PWM_FAST
        PAUSE L_TIME
        ENDIF
        IF ASTATE=4 THEN
        AFOROG 0,PWM_FAST
        PAUSE F_TIME
        ENDIF
        IF ASTATE=5 THEN
        AFOROG 0,PWM_MID
        PAUSE M_TIME
        ENDIF       
        IF ASTATE=6 THEN
        AFOROG 0,PWM_SLOW
        PAUSE L_TIME
        ENDIF                
        ASTATE=7
        MA_STOP
        PRINT "A STOP"
'===============================================        
      CASE "BLF"		
        BSTATE=1:BFOROG 0,PWM_FAST
        PRINT "B FAST FORWARD..."                
      CASE "BLM"			'2-FORWARD 
        BSTATE=2:BFOROG 0,PWM_MID
        PRINT "B MID FORWARD..."         
      CASE "BLL"			'3-FORWARD 
        BSTATE=3:BFOROG 0,PWM_SLOW
        PRINT "B SLOW FORWARD..." 
      CASE "BRF"		
        BSTATE=4:BFOROG 1,PWM_SLOW
        PRINT "B FAST REVERSE..."                
      CASE "BRM"			'2-FORWARD 
        BSTATE=5:BFOROG 1,PWM_MID
        PRINT "B MID REVERSE..."         
      CASE "BRL"			'3-FORWARD 
        BSTATE=6:BFOROG 1,PWM_FAST
        PRINT "B SLOW REVERSE..." 
      CASE "BLS"			
        IF BSTATE=1 THEN 
        BFOROG 1,PWM_SLOW
        PAUSE F_TIME 
        ENDIF
        IF BSTATE=2 THEN 
        BFOROG 1,PWM_MID        
        PAUSE M_TIME
        ENDIF       
        IF BSTATE=3 THEN
        BFOROG 1,PWM_FAST 
        PAUSE L_TIME 
        ENDIF
        IF BSTATE=4 THEN
        BFOROG 0,PWM_FAST
        PAUSE F_TIME 
        ENDIF
        IF BSTATE=5 THEN
        BFOROG 0,PWM_MID
        PAUSE M_TIME
        ENDIF       
        IF BSTATE=6 THEN 
        BFOROG 0,PWM_SLOW 
        PAUSE L_TIME 
        ENDIF 
        BSTATE=7
        MB_STOP
        PRINT "B STOP" 
'===============================================    
      CASE ELSE
          PRINT INSTR$,": ERROR!!!"    
    END SELECT
END SUB
'DIRECT CONTROL MOTOR A (TESTING IN CMD LINE) 
SUB CTRLA  
  LOCAL X
  DO
  INPUT "XA(0,1,2,3)= ",X
  PORT(A1PIN,1,A2PIN,1)=X
  LOOP
END SUB
'DIRECT CONTROL MOTOR B (TESTING IN CMD LINE) 
SUB CTRLB  
  LOCAL X
  DO
  INPUT "XB(0,1,2,3)= ",X
  PORT(B1PIN,1,B2PIN,1)=X
  LOOP
END SUB
'MOTOR A STOP         
SUB MA_STOP
  pwm 1,stop:SETPIN A1PIN,DOUT:PIN(A1PIN)=0:SETPIN A2PIN,DOUT:PIN(A2PIN)=0 
END SUB
'MOTOR B STOP
SUB MB_STOP
  pwm 2,stop:SETPIN B1PIN,DOUT:PIN(B1PIN)=0:SETPIN B2PIN,DOUT:PIN(B2PIN)=0 
END SUB
'
SUB APWM KT
	  PWM 1,20,KT 'PWM1(21)
END SUB
'
SUB BPWM KT
	  PWM 2,20,KT 'ANPWM(15)
END SUB
'
SUB AFOROG MDIR,MSEB
    MA_STOP:PIN(M_A_DIR)=MDIR:APWM MSEB    
END SUB
'
SUB BFOROG MDIR,MSEB
    MB_STOP:PIN(M_B_DIR)=MDIR:BPWM MSEB    
END SUB
END '**[ PROGRAM END ]*************************************************
