'BMP180 sensor
'====================================================
'=----             Electricat. 2023            -----=
'====================================================
MODE 1
CLS
Dim sens_dat(1)=(1,1) As integer
Dim calibration_reg(21) As integer
Dim temperature(1) As integer
Dim pressure(1)

bus_speed=400
bus_timeout=100
device_adress=0

tab1=16
tab2=200
tab3=400
lh=12 'line heigth
tab=8
up=2
lo=8

SetPin gp4,gp5, i2c
I2C open bus_speed,bus_timeout

'Read CHIP ID (check communication)
I2C write &h77,0,1,&hD0',&hEF
I2C read &h77,0,1,sens_dat()
If sens_dat(0) <> &h55 Then
Print "Communication error."
Print "Check I2C line wirring."
Print "Add 4k7 pulups if needed."
Print "Program stopped."
End
EndIf
'Read sensor calibration vars
I2C write  &h77,0,1,&hAA
I2C read &h77,0,22, calibration_reg()

Colour RGB(red),RGB(black)
Print @(tab1,lh*10) ; Tab(80)
Colour RGB(white),RGB(black)
Line tab1,lh*10+lo,tab*79,lh*10+lo,,1

Colour RGB(red),RGB(black)
Print @(tab1,lh*12) ; Tab(80)
Colour RGB(white),RGB(black)
Line tab1,lh*12+up,tab*79,lh*12+up,,1

Colour RGB(yellow),RGB(black)
Print @(tab1,lh*27) ; Tab(80)
Colour RGB(white),RGB(black)
Line tab1,lh*27+lo,tab*79,lh*27+lo,,1

Colour RGB(yellow),RGB(black)
Print @(tab1,lh*31) ; Tab(80)
Colour RGB(white),RGB(black)
Line tab1,lh*31+up,tab*79,lh*31+up,,1

Colour RGB(yellow),RGB(black)
Print @(tab2,lh*26)"Ultra low power mode 'OSS=0'"
Colour RGB(white),RGB(black)

Colour RGB(red),RGB(black)
Print @(tab2-24,lh*39)"Sensor's pressure range 300-1100 hPa"
Colour RGB(white),RGB(black)

repeat:
I2C write &h77,0,2,&hF4,&h2E
Pause 10
I2C write &h77,0,1,&hF7
I2C read &h77,0,1,temperature(0)
I2C write &h77,0,1,&hF6
I2C read &h77,0,1,temperature(1)
'read pressure
I2C write &h77,0,2,&hF4,&h34
Pause 10
I2C write &h77,0,1,&hF7
I2C read &h77,0,1,pressure(0) ' LSB
I2C write &h77,0,1,&hF6
I2C read &h77,0,1,pressure(1) ' MSB

AC1=calibration_reg(0)*256+calibration_reg(1)
If (AC1 >= 32768) Then AC1=AC1-65536 : EndIf
AC2=calibration_reg(2)*256+calibration_reg(3)
If (AC2 >= 32768) Then AC2=AC2-65536 : EndIf
AC3=calibration_reg(4)*256+calibration_reg(5)
If (AC3 >= 32768) Then AC3=AC3-65536 : EndIf
AC4=calibration_reg(6)*256+calibration_reg(7)
AC5=calibration_reg(8)*256+calibration_reg(9)
AC6=calibration_reg(10)*256+calibration_reg(11)
B1=calibration_reg(12)*256+calibration_reg(13)
If (B1 >= 32768) Then B1=B1-65536 : EndIf
B2=calibration_reg(14)*256+calibration_reg(15)
If (B2 >= 32768) Then B2=B2-65536 : EndIf
MB=calibration_reg(16)*256+calibration_reg(17)
If (MB >= 32768) Then MB=MB-65536 : EndIf
MC=calibration_reg(18)*256+calibration_reg(19)
If (MC >= 32768) Then MC=MC-65536 : EndIf
MD=calibration_reg(20)*256+calibration_reg(21)
If (MD >= 32768) Then MD=MD-65536 : EndIf


Print @(tab1,lh)"AC1> " AC1,@(tab2,lh)"Ac2> " AC2,@(tab3,lh)"AC3> " AC3
Print @(tab1,lh*3)"AC4> " AC4,@(tab2,lh*3)"AC5> " AC5,@(tab3,lh*3)"AC6> " AC6
Print @(tab1,lh*5)"B1>  " B1, @(tab2,lh*5) "B2>  " B2,@(tab3,lh*5)  "MB>  " MB
Print @(tab1,lh*7)"MC>  " MC, @(tab2,lh*7) "MD>  " MD
UT=temperature(1)*256+temperature(0)
X1=Int((UT-AC6)*(AC5/2^15))
X2=Int(MC*2^11/(X1+MD))
B5=Int(X1+X2)
T=Int((B5+8)/16)*0.1
Print @(tab2,lh*10) " Temperature =>",T " C"+Chr$(96) + " "
UP=pressure(1)*256+pressure(0)
Print @(tab1,lh*14)"UP> " UP,
B6=B5-4000
Print @(tab2,lh*14) "b6> " B6,
X1= ((B2*(B6*B6)/2^12))/2^11
Print @(tab3,lh*14) "X1> " Str$(X1,0,3),
X2=(AC2*B6)/2^11
Print @(tab1,lh*16)"X2> " Str$(X2,0,3),
X3=X1+X2
Print @(tab2,lh*16) "X3> " Str$(X3,0,3),
B3=(((AC1*4)+X3)+2)/2^2
Print @(tab3,lh*16)"B3> " Str$(B3,0,3),
X1=AC3*B6/2^13
Print @(tab1,lh*18) "X1> " Str$(X1,0,3),
X2=(B1*((B6*b6)/2^12))/2^16
Print @(tab2,lh*18)"X2> " Str$(X2,0,3),
X3=((X1+X2)+2)/2^2
Print @(tab3,lh*18)"X3> " Str$(X3,0,3),
B4=(AC4*(X3+32768))/2^15
Print @(tab1,lh*20)"B4> " Str$(B4,0,3),
B7=(UP-B3)*50000
Print @(tab2,lh*20)"B7> " Str$(B7,0,3),

If B7 < &h80000000 Then p=Int((B7*2)/B4)
EndIf

If B7 > &h80000000 Then p=Int((B7/B4)*2)
EndIf

Print @(tab3,lh*20)"p>  " Str$(p,0,3),
X1=(p/2^8)*(p/2^8)
X1=(X1*3038)/2^16
Print @(tab1,lh*22)"X1> " Str$(X1,0,3),
X2=(-7357*p)/2^16
Print @(tab2,lh*22)"X2> " Str$(X2,0,3),
p=p+(X1+X2+3791)/2^4
Print @(tab2,lh*27)"Fin. Pressure => "Str$(p,0,2) " hPa ",
Print @(tab2,lh*29)"Milibars      => "Str$((p/100),0,2) " mbar",

GoTo repeat

I2C close
End
