OPTION EXPLICIT
' Initial code from TassyJim at Back Shed Forum:-
' https://www.thebackshed.com/forum/ViewTopic.php?FID=16&TID=12839
' 
' Code elk1984 - 28 Sept 2020
' 
' Licensed under the UNLICENSE - details at the footer of the file
'

CONST True = (1=1)
CONST False = (1=0)

CONST caseMatch=0
CONST caseIgnore=1

CONST fileInfo_name = 0
CONST fileInfo_size = 1
CONST fileInfo_imageWidth = 2
CONST fileInfo_imageHeight = 3
CONST fileInfo_imageBitDepth = 4
CONST fileInfo_imageType = 5
CONST fileInfo_info = 6

DIM fileInfo(6) as String

CLS
DoTest

END

'##################################################################################################

SUB DoTest
  getFileInfo("test.bmp",fileInfo()) : printFileInfo(fileInfo()) : PRINT
  getFileInfo("test.gif",fileInfo()) : printFileInfo(fileInfo()) : PRINT
  getFileInfo("test.png",fileInfo()) : printFileInfo(fileInfo()) : PRINT
  getFileInfo("test.jpg",fileInfo()) : printFileInfo(fileInfo()) : PRINT
END SUB

'##################################################################################################

SUB getFileInfo(filename As String, fileInfo() As String)
LOCAL fileSize As Integer = -1
LOCAL imageWidth As Integer = -1
LOCAL imageHeight As Integer = -1
LOCAL imageBitDepth As Integer = -1
LOCAL imageType As String = "~NUL"
LOCAL info as String = "~NUL"
LOCAL fileHeader As String

fileSize = MM.INFO(filesize filename)

fileInfo(fileInfo_name) = filename
fileInfo(fileInfo_size) = STR$(fileSize)
fileInfo(fileInfo_imageWidth) = STR$(imageWidth)
fileInfo(fileInfo_imageHeight) = STR$(imageHeight)
fileInfo(fileInfo_imageBitDepth) = STR$(imageBitDepth)
fileInfo(fileInfo_imageType) = imageType
fileInfo(fileInfo_info) = info


IF fileSize > -1 THEN

  OPEN filename FOR RANDOM AS #2
  SEEK #2,1

  SELECT CASE UCASE$(RIGHT$(filename,4))
  CASE ".BMP"

  '####################################################################
  '
  ' BMP Format
  '
  '  1 - 18   18 bytes - header
  ' 19 - 22    4 bytes - imageWidth
  ' 23 - 26    4 bytes - ImageHeight
  ' 27 - 28    2 bytes - ignored
  ' 29 - 30    2 bytes - bit depth
  '
  '####################################################################

    LOCAL byteArray(30) As Integer
    LOCAL c as Integer = ReadFileIntoByteArray(2,1,30,byteArray())

    imageWidth  = byteArray(19)+byteArray(20)*256+byteArray(21)*2^16+byteArray(22)*2^24
    imageHeight = byteArray(23)+byteArray(24)*256+byteArray(25)*2^16+byteArray(26)*2^24
    imageType = "BMP "+STR$(byteArray(29)+byteArray(30)*256)+" bit"


  CASE ".GIF"

  '####################################################################
  '
  ' GIF Format
  '
  '  1 -  6    6 bytes - header
  '  7 -  8    2 bytes - imageWidth
  '  9 - 10    2 bytes - ImageHeight
  '      11    1 byte  - bit depth
  '
  '####################################################################

    LOCAL byteArray(11) As Integer
    LOCAL c as Integer = ReadFileIntoByteArray(2,1,11,byteArray())

    imageWidth = byteArray(7)+byteArray(8)*256
    imageHeight = byteArray(9)+byteArray(10)*256
    imageBitDepth = (byteArray(11) and &b00000111) + 1
    imageType = "GIF "+STR$(imageBitDepth)+" bit"


  CASE ".PNG"

  '####################################################################
  '
  ' PNG Format
  '
  ' Data from https://en.wikipedia.org/wiki/Portable_Network_Graphics
  '
  '  1 - 12   12 bytes - header
  ' 13 - 16    4 bytes - always = "IHDR"
  ' 17 - 20    4 bytes - imageWidth
  ' 21 - 24    4 bytes - ImageHeight
  ' 25         1 byte  - bit depth
  ' 26         1 byte  - type
  '
  '####################################################################

    LOCAL byteArray(26) As Integer
    LOCAL c as Integer = ReadFileIntoByteArray(2,1,26,byteArray())

    imageWidth = byteArray(17)*2^24 + byteArray(18)*2^16 + byteArray(19)*256 + byteArray(20)
    imageHeight = byteArray(21)*2^24 + byteArray(22)*2^16 + byteArray(23)*256 + byteArray(24)
    imageBitDepth = byteArray(25)
  
    SELECT CASE byteArray(26)
    CASE 0
      imageType = "PNG "+STR$(imageBitDepth)+" bit Grayscale"
    CASE 2
      imageType = "PNG "+STR$(imageBitDepth*3)+" bit Truecolour"
    CASE 3
      imageType = "PNG "+STR$(imageBitDepth)+" bit Palettised"
    CASE 4
      imageType = "PNG "+STR$(imageBitDepth*2)+" bit Grayscale+Alpha"
    CASE 6
      imageType = "PNG "+STR$(imageBitDepth*4)+" bit RGBA"
    CASE ELSE
      imageType = "PNG "+STR$(imageBitDepth)+" bit/pixel"
    END SELECT



  CASE ".JPG"    

  '####################################################################
  '
  ' JPG Format
  '
  ' The maximum size for a JPG header is 64.  The markers for the image
  ' metadata will start with 2 bytes of FFC0 (Standard) or 
  ' FFC2 (Progressive).  Counts below are offset from the header start
  ' 
  '  1         1 byte  - Normal / Progressive
  '  2 -  4    3 bytes - ignored
  '  5 -  6    2 bytes - imageWidth
  '  7 -  8    2 bytes - ImageHeight
  '
  '####################################################################

    LOCAL byteArray(65536) As Integer
    LOCAL pHead as Integer = -1
    
    pHead = FindInFile(2,chr$(&hFF)+chr$(&hC0),caseMatch,65536)

    IF pHead = -1 THEN
      pHead = FindInFile(2,chr$(&hFF)+chr$(&hC2),caseMatch,65536)
    END IF

    IF pHead > -1 THEN
      LOCAL c as Integer = ReadFileIntoByteArray(2,pHead,8,byteArray())

      SELECT CASE byteArray(1)
      CASE &hC0
        imageType = "JPG Normal"
      CASE &hC2
        imageType = "JPG Progessive"
      END SELECT
    
      imageHeight = byteArray(5)*256 + byteArray(6)
      imageWidth = byteArray(7)*256 + byteArray(8)
    ELSE
      info="Could not find image metadata."
    END IF

  END SELECT

  CLOSE #2
  
ELSE
  info="File does not exist."
END IF

fileInfo(fileInfo_name) = filename
fileInfo(fileInfo_size) = STR$(filesize)
fileInfo(fileInfo_imageWidth) = STR$(imageWidth)
fileInfo(fileInfo_imageHeight) = STR$(imageHeight)
fileInfo(fileInfo_imageBitDepth) = STR$(imageBitDepth)
fileInfo(fileInfo_imageType) = imageType
fileInfo(fileInfo_info) = info


END SUB


'##################################################################################################


SUB printFileInfo(fileInfo() AS String)

  PRINT "Filename        : " + RemoveNullsFromOutput(fileInfo(fileInfo_name))
  PRINT "File Info       : " + RemoveNullsFromOutput(fileInfo(fileInfo_info))
  PRINT "Image Type      : " + RemoveNullsFromOutput(fileInfo(fileInfo_imageType))
  PRINT "Size            : " + RemoveNullsFromOutput(fileInfo(fileInfo_size))
  PRINT "Image Width     : " + RemoveNullsFromOutput(fileInfo(fileInfo_imageWidth))
  PRINT "Image Height    : " + RemoveNullsFromOutput(fileInfo(fileInfo_imageHeight))
  PRINT "Image Bit Depth : " + RemoveNullsFromOutput(fileInfo(fileInfo_imageBitDepth))

END SUB


'##################################################################################################


FUNCTION ReadFileIntoByteArray(fileNumber AS Integer, startByte As Integer, bytesToRead AS Integer, arrayToFill() AS Integer) AS Integer

  LOCAL p as Integer = startByte
  DO
    SEEK #2,p
    arrayToFill(p-(startByte)+1) = ASC(INPUT$(1,fileNumber))
    p=p+1
  LOOP UNTIL EOF(fileNumber) OR (p-startByte)>=bytesToRead

  ReadFileIntoByteArray=p-(startByte)

END FUNCTION


'##################################################################################################


FUNCTION FindInFile(fileNumber AS Integer, stringToFind AS String, matchType AS Integer, maxBytesToRead AS Integer) AS Integer

  LOCAL stringFound as String = ""

  IF matchType = caseMatch THEN
    'Nothing to do, the normal comparisons are case sensitive
  ELSE
    stringToFind = UCASE$(stringToFind)
  END IF

  FindInFile = -1

  'Create a string which is the last Len(stringToFind) characters.
  'If the string doesn't match then the string becomes RIGHT$(stringFound,LEN(stringToFind))
  
  LOCAL p as Integer = 1
  DO
    SEEK #2,p
    stringFound=RIGHT$(stringFound+INPUT$(1,fileNumber),Len(stringToFind))
    IF matchType=caseIgnore THEN stringFound=UCASE$(stringFound)
    p=p+1
  LOOP UNTIL EOF(fileNumber) OR p>maxBytesToRead OR (stringFound=StringToFind)

  FindInFile=(p-1)

END FUNCTION


'##################################################################################################


FUNCTION RemoveNullsFromOutput(stringToFormat AS String) AS String

  SELECT CASE stringToFormat

  CASE "-1"
    RemoveNullsFromOutput = ""
  CASE "~NUL"
    RemoveNullsFromOutput = ""
  CASE ELSE
    RemoveNullsFromOutput = stringToFormat
  END SELECT

END FUNCTION


'##################################################################################################
' 
' Unlicense:
' 
' This is free and unencumbered software released into the public domain.
'
' Anyone is free to copy, modify, publish, use, compile, sell, or
' distribute this software, either in source code form or as a compiled
' binary, for any purpose, commercial or non-commercial, and by any
' means.
' 
' In jurisdictions that recognize copyright laws, the author or authors
' of this software dedicate any and all copyright interest in the
' software to the public domain. We make this dedication for the benefit
' of the public at large and to the detriment of our heirs and
' successors. We intend this dedication to be an overt act of
' relinquishment in perpetuity of all present and future rights to this
' software under copyright law.
' 
' THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
' EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
' MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
' IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
' OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
' ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
' OTHER DEALINGS IN THE SOFTWARE.
' 
' For more information, please refer to <http://unlicense.org/>
'
'##################################################################################################