
'######################################
'#                                    #
'# Control Property Setters / Getters #
'#                                    #
'######################################

FUNCTION Name(crName As String) As String
  LOCAL ctlFound As Integer = ctlDoesNotExist

  ctlFound=ctlGetControlIDByName(crName)

  IF ctlFound<>ctlDoesNotExist THEN
    Name=ctlArray(ctlFound, ctlName)
  ELSE
    PRINT "Control "+crName+" Does Not Exist"
    END
  END IF  

END FUNCTION

'##################################################################################################

SUB SetName(crName As String,valueToSet As String)
  PRINT "ERROR: Name is a Read Only Propety and cannot be changed. Control: "+crName
  END
END SUB

'##################################################################################################

FUNCTION Type(crName As String) As Integer
  LOCAL ctlFound As Integer = ctlDoesNotExist

  ctlFound=ctlGetControlIDByName(crName)

  IF ctlFound<>ctlDoesNotExist THEN
    Type=VAL(ctlArray(ctlFound, ctlType))
  ELSE
    PRINT "Control "+crName+" Does Not Exist"
    END
  END IF  

END FUNCTION

'##################################################################################################

SUB SetType(crName As String,valueToSet As String)
  PRINT "ERROR: Type is a Read Only Propety and cannot be changed. Control: "+crName
  END
END SUB

'##################################################################################################

FUNCTION Label(crName As String) As String
  LOCAL ctlFound As Integer = ctlDoesNotExist

  ctlFound=ctlGetControlIDByName(crName)

  IF ctlFound<>ctlDoesNotExist THEN
    Label=ctlArray(ctlFound, ctlLabel)
  ELSE
    PRINT "Control "+crName+" Does Not Exist"
    END
  END IF  

END FUNCTION

'##################################################################################################

SUB SetLabel(crName As String, valueToSet As String)
  LOCAL ctlFound As Integer = ctlDoesNotExist

  ctlFound=ctlGetControlIDByName(crName)

  IF ctlFound<>ctlDoesNotExist THEN
    ctlArray(ctlFound, ctlLabel)=valueToSet
  ELSE
    PRINT "Control "+crName+" Does Not Exist"
    END
  END IF  

END SUB

'##################################################################################################

FUNCTION Value(crName As String) As String
  LOCAL ctlFound As Integer = ctlDoesNotExist

  ctlFound=ctlGetControlIDByName(crName)

  IF ctlFound<>ctlDoesNotExist THEN
    Value=ctlArray(ctlFound, ctlValue)
  ELSE
    PRINT "Control "+crName+" Does Not Exist"
    END
  END IF  

END FUNCTION

'##################################################################################################

SUB SetValue(crName As String, valueToSet As String)
  LOCAL ctlFound As Integer = ctlDoesNotExist

  ctlFound=ctlGetControlIDByName(crName)

  IF ctlFound<>ctlDoesNotExist THEN
    ctlArray(ctlFound, ctlValue)=valueToSet
  ELSE
    PRINT "Control "+crName+" Does Not Exist"
    END
  END IF  

END SUB

'##################################################################################################

FUNCTION Top(crName As String) As Integer
  LOCAL ctlFound As Integer = ctlDoesNotExist

  ctlFound=ctlGetControlIDByName(crName)

  IF ctlFound<>ctlDoesNotExist THEN
    Top=VAL(ctlArray(ctlFound, ctlTop))
  ELSE
    PRINT "Control "+crName+" Does Not Exist"
    END
  END IF  

END FUNCTION

'##################################################################################################

SUB SetTop(crName As String, valueToSet As Integer)
  LOCAL ctlFound As Integer = ctlDoesNotExist

  ctlFound=ctlGetControlIDByName(crName)

  IF ctlFound<>ctlDoesNotExist THEN
    ctlArray(ctlFound, ctlTop)=STR$(valueToSet)
  ELSE
    PRINT "Control "+crName+" Does Not Exist"
    END
  END IF  

END SUB

'##################################################################################################

FUNCTION Left(crName As String) As Integer
  LOCAL ctlFound As Integer = ctlDoesNotExist

  ctlFound=ctlGetControlIDByName(crName)

  IF ctlFound<>ctlDoesNotExist THEN
    Left=VAL(ctlArray(ctlFound, ctlLeft))
  ELSE
    PRINT "Control "+crName+" Does Not Exist"
    END
  END IF  

END FUNCTION

'##################################################################################################

SUB SetLeft(crName As String, valueToSet As Integer)
  LOCAL ctlFound As Integer = ctlDoesNotExist

  ctlFound=ctlGetControlIDByName(crName)

  IF ctlFound<>ctlDoesNotExist THEN
    ctlArray(ctlFound, ctlLeft)=STR$(valueToSet)
  ELSE
    PRINT "Control "+crName+" Does Not Exist"
    END
  END IF  

END SUB

'##################################################################################################

FUNCTION Height(crName As String) As Integer
  LOCAL ctlFound As Integer = ctlDoesNotExist

  ctlFound=ctlGetControlIDByName(crName)

  IF ctlFound<>ctlDoesNotExist THEN
    Height=VAL(ctlArray(ctlFound, ctlHeight))
  ELSE
    PRINT "Control "+crName+" Does Not Exist"
    END
  END IF  

END FUNCTION

'##################################################################################################

SUB SetHeight(crName As String, valueToSet As Integer)
  LOCAL ctlFound As Integer = ctlDoesNotExist

  ctlFound=ctlGetControlIDByName(crName)

  IF ctlFound<>ctlDoesNotExist THEN
    ctlArray(ctlFound, ctlHeight)=STR$(valueToSet)
  ELSE
    PRINT "Control "+crName+" Does Not Exist"
    END
  END IF  

END SUB

'##################################################################################################

FUNCTION Width(crName As String) As Integer
  LOCAL ctlFound As Integer = ctlDoesNotExist

  ctlFound=ctlGetControlIDByName(crName)

  IF ctlFound<>ctlDoesNotExist THEN
    Width=VAL(ctlArray(ctlFound, ctlWidth))
  ELSE
    PRINT "Control "+crName+" Does Not Exist"
    END
  END IF  

END FUNCTION

'##################################################################################################

SUB SetWidth(crName As String, valueToSet As Integer)
  LOCAL ctlFound As Integer = ctlDoesNotExist

  ctlFound=ctlGetControlIDByName(crName)

  IF ctlFound<>ctlDoesNotExist THEN
    ctlArray(ctlFound, ctlWidth)=STR$(valueToSet)
  ELSE
    PRINT "Control "+crName+" Does Not Exist"
    END
  END IF  

END SUB

'##################################################################################################

FUNCTION TabOrder(crName As String) As Integer
  LOCAL ctlFound As Integer = ctlDoesNotExist

  ctlFound=ctlGetControlIDByName(crName)

  IF ctlFound<>ctlDoesNotExist THEN
    TabOrder=VAL(ctlArray(ctlFound, ctlTabOrder))
  ELSE
    PRINT "Control "+crName+" Does Not Exist"
    END
  END IF  

END FUNCTION

'##################################################################################################


SUB SetTabOrder(crName As String, valueToSet As Integer)
  LOCAL ctlFound As Integer = ctlDoesNotExist

  ctlFound=ctlGetControlIDByName(crName)

  IF ctlFound<>ctlDoesNotExist THEN
    ctlArray(ctlFound, ctlTabOrder)=STR$(valueToSet)
  ELSE
    PRINT "Control "+crName+" Does Not Exist"
    END
  END IF  

END SUB


'##################################################################################################

FUNCTION ParentControl(crName As String) As String
  LOCAL ctlFound As Integer = ctlDoesNotExist

  ctlFound=ctlGetControlIDByName(crName)

  IF ctlFound<>ctlDoesNotExist THEN
    ParentControl=ctlArray(ctlFound, ctlParentControl)
  ELSE
    PRINT "Control "+crName+" Does Not Exist"
    END
  END IF  

END FUNCTION

'##################################################################################################


SUB SetParentControl(crName As String, valueToSet As String)
  PRINT "ERROR: ParentControl is a Read Only Propety and cannot be changed. Control: "+crName
  END
END SUB


'##################################################################################################


FUNCTION Visible(crName As String) As Integer
  LOCAL ctlFound As Integer = ctlDoesNotExist

  ctlFound=ctlGetControlIDByName(crName)

  IF ctlFound<>ctlDoesNotExist THEN
    TabOrder=VAL(ctlArray(ctlFound, ctlVisible))
  ELSE
    PRINT "Control "+crName+" Does Not Exist"
    END
  END IF  

END FUNCTION

'##################################################################################################


SUB SetVisible(crName As String, valueToSet As Integer)
  LOCAL ctlFound As Integer = ctlDoesNotExist

  ctlFound=ctlGetControlIDByName(crName)

  IF ctlFound<>ctlDoesNotExist THEN
    ctlArray(ctlFound, ctlVisible)=STR$(valueToSet)
    onVisibleChanged crName, valueToSet
  ELSE
    PRINT "Control "+crName+" Does Not Exist"
    END
  END IF  

END SUB


'##################################################################################################


