
'############################
'#                          #
'# Draw Control Definitions #
'#                          #
'############################

SUB drawControls()
  LOCAL fontHeight As Integer = MM.INFO(fontHeight)
  LOCAL fontWidth As Integer = MM.INFO(fontWidth)

  LOCAL i As Integer
  LOCAL controlName as String

  FOR i=0 TO ctlControlCount-1
    controlName=ctlGetControlNameById(i)    
    'PRINT controLName + " " + STR$(Type(controlName))
    SELECT CASE Type(controlName)
    CASE ctlTypeImage, ctlTypeSelectableImage
      PAGE WRITE 1
      BOX Left(controlName),Top(controlName),Width(controlName),Height(controlName),,RGB(50,50,50),RGB(195,195,195)
      BOX Left(controlName),Top(controlName),Width(controlName),fontHeight+2,,RGB(50,50,50),RGB(50,50,50)
      TEXT Left(controlName)+2,Top(controlName)+2), "Id: " + STR$(i),,,,RGB(195,195,195),RGB(50,50,50)
      PAGE WRITE 0

      IF SPRITE(X,i)=-1 THEN
        SPRITE READ i,Left(controlName),Top(controlName),Width(controlName),Height(controlName),1
        SPRITE SHOW i,Left(controlName),Top(controlName),0
      END IF
    CASE ctlTypeButton
      PAGE WRITE 1
      BOX Left(controlName),Top(controlName),Width(controlName),Height(controlName),,RGB(40,40,40),RGB(40,40,40)
      BOX Left(controlName),Top(controlName),Width(controlName)-1,Height(controlName)-1,,RGB(40,40,40),RGB(195,195,195)
      'Top Line
      LINE Left(controlName),Top(controlName),Left(controlName)+Width(controlName)-2,Top(controlName),1,RGB(255,255,255)
      'Left Line
      LINE Left(controlName),Top(controlName),Left(controlName),Top(controlName)+Height(controlName)-2,1,RGB(255,255,255)
      'Bottom Line
      LINE Left(controlName)+1,Top(controlName)+Height(controlName)-2,Left(controlName)+Width(controlName)-2,Top(controlName)+Height(controlName)-2,1,RGB(133,137,140)
      'Right Line
      LINE Left(controlName)+Width(controlName)-2,Top(controlName)+1,Left(controlName)+Width(controlName)-2,Top(controlName)+Height(controlName)-2,1,RGB(133,137,140)

      TEXT Left(controlName)+((Width(controlName)/2))-((Len(Label(controlName))/2)*FontWidth),Top(controlName)+(Height(controlName)/2)-(fontHeight/2),Label(controlName),,,,RGB(40,40,40),RGB(195,195,195)
      PAGE WRITE 0

      IF SPRITE(X,i)=-1 THEN
        SPRITE READ i,Left(controlName),Top(controlName),Width(controlName),Height(controlName),1
        SPRITE SHOW i,Left(controlName),Top(controlName),0
      END IF
    CASE ctlTypeDefaultButton
      PAGE WRITE 1
      BOX Left(controlName),Top(controlName),Width(controlName),Height(controlName),,RGB(40,40,40),RGB(40,40,40)
      BOX Left(controlName)+1,Top(controlName)+1,Width(controlName)-3,Height(controlName)-3,,RGB(40,40,40),RGB(195,195,195)
      'Top Line
      LINE Left(controlName)+1,Top(controlName)+1,Left(controlName)+Width(controlName)-3,Top(controlName)+1,1,RGB(255,255,255)
      'Left Line
      LINE Left(controlName)+1,Top(controlName)+1,Left(controlName)+1,Top(controlName)+Height(controlName)-3,1,RGB(255,255,255)
      'Bottom Line
      LINE Left(controlName)+2,Top(controlName)+Height(controlName)-3,Left(controlName)+Width(controlName)-3,Top(controlName)+Height(controlName)-3,1,RGB(133,137,140)
      'Right Line
      LINE Left(controlName)+Width(controlName)-3,Top(controlName)+2,Left(controlName)+Width(controlName)-3,Top(controlName)+Height(controlName)-3,1,RGB(133,137,140)

      TEXT Left(controlName)+((Width(controlName)/2))-((Len(Label(controlName))/2)*FontWidth),Top(controlName)+(Height(controlName)/2)-(fontHeight/2),Label(controlName),,,,RGB(40,40,40),RGB(195,195,195)
      PAGE WRITE 0

      IF SPRITE(X,i)=-1 THEN
        SPRITE READ i,Left(controlName),Top(controlName),Width(controlName),Height(controlName),1
        SPRITE SHOW i,Left(controlName),Top(controlName),0
      END IF



    END SELECT
  NEXT i

  'PressAnyKey
  'ctlListControls
END SUB

'##################################################################################################

SUB ctlMove(controlName as String, newXPos as Integer, newYPos as Integer)
  LOCAL controlID As Integer
  IF ctlExists(controlName)<>ctlDoesNotExist THEN
    controlID = ctlGetControlIDByName(controlName)
    IF SPRITE(X,controlID)=-1 THEN
      SPRITE READ controlID,Left(controlName),Top(controlName),Width(controlName),Height(controlName)
    END IF
    SetLeft(controlName,NewXPos)
    SetTop(controlName,NewYPos)
    SPRITE SHOW controlID, Left(controlName),Top(controlName),0
  END IF
END SUB

'##################################################################################################

SUB onVisibleChanged(controlName as String, controlVisible as Integer)
  LOCAL controlID As Integer
  IF ctlExists(controlName)<>ctlDoesNotExist THEN
    controlID = ctlGetControlIDByName(controlName)
    IF controlVisible = True THEN
      SPRITE SHOW controlID, Left(controlName),Top(controlName),0
    ELSE
      SPRITE HIDE controlID
    END IF
  END IF
END SUB
