SUB CheckKeys
LOCAL NumKeys As Integer
LOCAL KeyPressed As Integer
LOCAL ModifierKeys As Integer
LOCAL LockKeys As Integer
  TIMER=0
  DO
    NumKeys = KEYDOWN(0): KeyPressed = KEYDOWN(1) : ModifierKeys = KEYDOWN(7) : LockKeys = KEYDOWN(8)
  LOOP UNTIL NumKeys>0 OR ModifierKeys<>0 OR LockKeys<>0 OR TIMER>1000

  PRINT "NK", NumKeys, "KP", ProcessKeys(KeyPressed, ModifierKeys), "MK", ProcessModifier(ModifierKeys), "LK", ProcessLocks(LockKeys)

END SUB



' ************************************************************************************************************
' Key Modifier Values
'     /----------------  1 = Left Alt
'     |
'     | /--------------  2 = Left Control
'     | |
'     | | /------------  4 = Left Windows Key
'     | | |
'     | | | /----------  8 = Left Shift
'     | | | | 
'     | | | | /-------- 16 = Alt+Gr
'     | | | | |
'     | | | | | /------ 32 = Right Contrl
'     | | | | | |
'     | | | | | | /---- 64 = Right Windows Key
'     | | | | | | |
'     | | | | | | | /- 128 = Right Shift
'     | | | | | | | |
'     | | | | | | |  
'     | | | |       1
'             1 3 6 2
'   0 1 2 4 8 6 2 4 8
' ************************************************************************************************************

FUNCTION ProcessModifier(ModifierKeys AS Integer) AS String
LOCAL Description AS STRING = ""

  IF (ModifierKeys AND 128) = 128 THEN Description = Description + "Right Shift "
  IF (ModifierKeys AND  64) =  64 THEN Description = Description + "Right OS Key "
  IF (ModifierKeys AND  32) =  32 THEN Description = Description + "Right Control "
  IF (ModifierKeys AND  16) =  16 THEN Description = Description + "Right Alt/AltGr "
  IF (ModifierKeys AND   8) =   8 THEN Description = Description + "Left Shift "
  IF (ModifierKeys AND   4) =   4 THEN Description = Description + "Left OS Key "
  IF (ModifierKeys AND   2) =   2 THEN Description = Description + "Left Control "
  IF (ModifierKeys AND   1) =   1 THEN Description = Description + "Left Alt "

  'Remove trailing SPACE
  IF LEN(Description)>0 THEN
    Description=LEFT$(Description,LEN(Description)-1)
  END IF

  ProcessModifier = Description
END FUNCTION


' ************************************************************************************************************
' Lock Modifier Values
'     /----------------  1 = Caps Lock
'     |
'     | /--------------  2 = Num Lock
'     | |
'     | | /------------  4 = Scroll Lock
'     | | |
' 
'   0 1 2 4
' ************************************************************************************************************

FUNCTION ProcessLocks(LockKeys AS Integer) AS String
LOCAL Description AS STRING = ""

  IF (LockKeys AND   4) =   4 THEN Description = Description + "Scroll Lock "
  IF (LockKeys AND   2) =   2 THEN Description = Description + "Num Lock "
  IF (LockKeys AND   1) =   1 THEN Description = Description + "Caps Lock "

  'Remove trailing SPACE
  IF LEN(Description)>0 THEN
    Description=LEFT$(Description,LEN(Description)-1)
  END IF

  ProcessLocks = Description
END FUNCTION



' ************************************************************************************************************
' Function Keys
' 145  F1    209 Shift+F1
' 146  F2    210 Shift+F2
' 147  F3    211 Shift+F3
' 148  F4    212 Shift+F4
' 149  F5    213 Shift+F5
' 150  F6    214 Shift+F6
' 151  F7    215 Shift+F7
' 152  F8    216 Shift+F8
' 153  F9    217 Shift+F9
' 154  F10   218 Shift+F10
' 155  F11   219 Shift+F11
' 156  F12   220 Shift+F12

' Cursor Keys
' 132  Insert
' 134  Home
' 136  Page Up
' 127  Delete
' 135  End
' 137  Page Down

' Arrow Keys
' 128  Up
' 129  Down
' 130  Left
' 131  Right

' Special Keys
' 27   Escape
' 9    Tab
' 8    Backspace
' 10   Enter
' 157  Print Screen
' 158  Pause
' ************************************************************************************************************

FUNCTION ProcessKeys(Keys AS Integer, ModifierKeys AS Integer) AS String
LOCAL Description AS STRING = ""


  SELECT CASE ProcessModifier(ModifierKeys)
  CASE "Left Control", "Right Control"  
    Description = Description + "Ctrl+"
  CASE "Left Shift", "Right Shift 
    Description = Description + "Shift+"
  CASE "Left Alt", "Right Alt"  
    Description = Description + "Alt+"
  END SELECT

  SELECT CASE Keys
  'Used with Control Combinations
  CASE 1 TO 26
    Description = Description + CHR$(64+Keys)  
  'Function Keys
  CASE 145 TO 156
    Description = Description + "F" + STR$(Keys-144)
  'Shifted Function Keys
  CASE 209 TO 221
    Description = Description + "Shift+F" + STR$(Keys-208)
  'Cursor Keys
  CASE 132
    Description = Description +"Insert"
  CASE 134
    Description = Description +"Home"
  CASE 136
    Description = Description +"Page Up"
  CASE 127
    Description = Description +"Delete"
  CASE 135
    Description = Description +"End"
  CASE 137
    Description = Description +"Page Down"

  'Special Keys
  CASE 27
    Description = Description +"Escape"
  CASE 9
    Description = Description +"Tab"
  CASE 8
    Description = Description +"Backspace"
  CASE 10
    Description = Description +"Enter"
  CASE 157
    Description = Description +"Print Screen"
  CASE 158
    Description = Description +"Pause"

  'Arrow Keys
  CASE 128
    Description = Description +"Up"
  CASE 129
    Description = Description +"Down"
  CASE 130
    Description = Description +"Left"
  CASE 131
    Description = Description +"Right"

  CASE ELSE
    Description = Description + CHR$(Keys)

  END SELECT

  ProcessKeys = Description
END FUNCTION