#ifndef __DF_DEFINES_H__
#define __DF_DEFINES_H__

#define TE_TILE_SUBPIXEL_W 256
#define TE_TILE_SUBPIXEL_H 256
#define TE_TILE_PIXEL_W_SHIFT 4
#define TE_TILE_PIXEL_H_SHIFT 4

#define TILE_COL_MASK  0x0000000000FF0000ULL
#define TILE_TRIG_MASK 0x00000000FF000000ULL
#define TILE_TRIG_SHIFT 24

#define TE_TABLE_MAX_MAP_WIDTH 0
#define TE_TABLE_MAX_MAP_HEIGHT 1
#define TE_TABLE_MAP_WIDTH 2
#define TE_TABLE_MAP_HEIGHT 3
#define TE_TABLE_MAP_XMASK 4
#define TE_TABLE_MAP_YMASK 5
#define TE_TABLE_TRIGMAP_VIEW 6
#define TE_TABLE_TRIGMAP_PREV_TILEX 7
#define TE_TABLE_TRIGMAP_PREV_TILEY 8

#define BG_TABLE_WIDTH 0
#define BG_TABLE_HEIGHT 1

#define MAX_ALTITUDE 3
#define MAX_OBJ_LIST_SIZE 400
#define OBJ_FLG_ALT_MSK (15<<9)
#define OBJ_FLG_ALT_SHFT 9
#define OBJ_FLG_BOX_MSK (1023<<15)
#define OBJ_FLG_BOX_SHFT 15
#define OBJ_FLG_SOLID_MSK (3<<13)
#define OBJ_FLG_SOLID_SHFT 13
#define OBJ_FLG_TYPE_MSK (255<<1)
#define OBJ_FLG_TYPE_SHFT 1
#define OBJ_FLG_CG_MSK (7<<25)
#define OBJ_FLG_CG_SHFT 25
#define OBJ_FLG_PERSIST_MSK (1<<29)
#define OBJ_FLG_PERSIST_SHFT 29


#define CFUNC_RAM_IDX_BOX_CORNER_X 0
#define CFUNC_RAM_IDX_BOX_CORNER_Y 1
#define CFUNC_RAM_IDX_BOX_HORIZONTAL 2
#define CFUNC_RAM_IDX_BOX_VERTICAL 3
#define CFUNC_RAM_IDX_OBJLIST_NUMELEMS 4
#define CFUNC_RAM_IDX_OBJLIST_LIST 5
#define CFUNC_RAM_IDX_OBJ_FLAGS 6
#define CFUNC_RAM_IDX_OBJ_POSITION_X 7
#define CFUNC_RAM_IDX_OBJ_POSITION_Y 8
#define CFUNC_RAM_IDX_CG_MAPS 9
#define CFUNC_RAM_IDX_OBJ_VELOCITY_X 10
#define CFUNC_RAM_IDX_OBJ_VELOCITY_Y 11
#define CFUNC_RAM_IDX_LM_LOG_CALLOUT 12
#define CFUNC_RAM_IDX_LM_LOG_TBL 13
#define CFUNC_RAM_IDX_TE_MAP 14
#define CFUNC_RAM_IDX_TE_TBL 15
#define CFUNC_RAM_IDX_BG_TBL 16

#define ABS(x) ((x)>=0 ? (x) : -(x))

#endif /*DF_DEFINES_H*/

