  '-------------------------------------------------------------------------------'
  '       MM Console+                          								                    '
  '                                                                               '
  '       Author:   Philip Erb                                                    '
  '                                                                               '
      dim ProgTitle$ = "MM Console+"                                              '
  '                                                                               '
      Dim ProgVer$   = "v1.0.70"                                                  '
  '                                                                               '
      Dim ProgDate$  = "22-Jul-2019"                                              '
  '-------------------------------------------------------------------------------'
  
  Option Explicit
  Option Default Integer
  
  'CONSTANTS
  '=========
  
  'Pin Assignments - E100 MX470
  'Inputs

  'Outputs
  CONST PIN_BEEP%=0                                   'Use GUI BEEP - requires Touch WITH Click pin set
'  CONST PIN_BEEP%=39                                  'Beep pin - no Touch or Touch WITHOUT Click pin
  
  'Values
  CONST MAXENTRIES%=200                               '# of entries in the Output Window (Display Lines Array)
  CONST MAXSAVECMDS%=10                               '# of previous Commands to save for recall
  
  'Font
  Const FONT_IN%=16                                   'Font # to be used for Input Text Boxes
  
  'Colours
  '   as used by the Main Output Window Panels - Console Output, View Log File & Log Search Results 
  '   and the Lite Editor edit panel.
  '   These are defined here to allow for easy modification of these colours 
  '   should it be necessary to address readability issues.
  CONST FCOut%=RGB(Cyan)                              'Forecolour = CYAN
  CONST BCOut%=RGB(Black)                             'Backcolour = BLACK
  
  'Console Logging 
  CONST LOGDIR$="A:/MMCONS+/CONSLOGS"                 'directory name for console log files
  Const MAXFNLEN%=127                                 'maximum length of file name  
  
  'Program Upload and/or Edit
  Const PROGDIR$="A:/MMCONS+/PROGS"                   'directory name for program files for upload/edit
  Const TEMPDIR$="A:/MMCONS+/TEMP"                    'directory name for temporary files used by the Editor
  
  'Lite Editor
  'NOTE: The sum of EDMAXRECS% & EDMAXUPDS% must NOT exceed 4095.
  CONST EDMAXRECS%=3800                               'Max program file size (records) to open in Editor
  Const EDMAXUPDS%=290                                'Max pending updates in the Editor
  const EDMAXRECSZ%=120                               'Max record length (bytes) handled by the Editor
  const EDUPDWARNSTEP%=5                              'Warning issued at 2x then 1x this value remaining 
  '                                                   '   before the file being edited is made Read-Only.
  'Literal Strings data file
  CONST DATADIR$="A:/MMCONS+/DATA"                    'directory and file name for the file Containing
  CONST STRINGSFN$="Strings.dat"                      'the Literal Strings used by the program.
  Const MAXSTRINGS%=275                               'the maximum # of records expected in
  '                                                   'the Literal Strings file (adjust this value if reqd).
  '                                                   '- allow at least 1 extra record slot.

  'VARIABLES
  '=========
  
  'IMPORTANT NOTE:  All VARIABLES and FUNCTIONS default to INTEGER data type unless 
  '===============  specifically set to another type.
  '                 String variables all use a $ symbol as the last character to indicate
  '                 their type without the need for "AS STRING".
  '                 This (as well as other things) has been done to reduce the size of the 
  '                 program so that it will fit into the Micromite Plus Flash Memory space.
  
  'Literal Strings
  '===============
  'StrPtr is the pointer array for tracking the Literal Strings used 
  'by the program and stored in the 'Strings.dat' file on the SD Card.
  'This array is initialized on program startup.
  'NOTE:  The SD Card containing the 'Strings.dat' file MUST
  '=====  remain available while the program is running!!!
  Dim StrPtr(MAXSTRINGS%)                             'change MAXSTRINGS% if additional Strings are added
  dim StrFN$                                          'Strings file name (incl directory)
  Dim StringsOpen                                     'flag indicating if the file is open
  dim StrCnt                                          '# of records loaded from Strings file
  
  'The CritStrs$ array is used to store IN MEMORY the first 20 Strings
  'from the 'Strings.dat' file on SD Card. These strings are setup to
  'be the ones associated with reporting SD Card access errors / problems
  'and therefore need to subsequently be available even if the SD Card is not !!
  Dim CritStrs$(20) Length 50
  
  'Font related 
  Dim fW_Out_1                                        'font width and height values
  dim fH_Out_1                                        'for both Output fonts
  dim fW_Out_2                                        '- used extensively for
  Dim fH_Out_2                                        'building display data
  
  Dim Fnt_In                                          'Text Input Font (specified as FONT_IN% in CONSTANTS)
  dim fW_In                                           'Font Width for the Input font
  Dim fH_In                                           'Font Height for the Input font
  
  DIM Fnt_Out                                         'Output Font currently being used  
  Dim fW_Out                                          'Font Width for the Output display font
  Dim fH_Out                                          'Font Height for the Output display font
  
  DIM Fnt_Mnu                                         'Menu (and Setup) Mode Font (usually the same as Output Font)
  Dim fW_Mnu                                          'Font Width for the Menu & Setup font
  Dim fH_Mnu                                          'Font Height for the Menu & Setup font
  
  Dim SaveFontSelect                                  'saved Font Select (for Fnt_Out) value 

  'Colours used for text and backgrounds
  'NOTE:  Main output window panels - Console Output, View Log File, Log Search Results 
  '=====  and Lite Editor edit panel all share the FCOut% (Forecolour) and BCOut% (Background)
  '       colours as defined in the CONSTANTS section at the start of this file.
  '       This allows for easy modification of these colours should it be necessary to
  '       address readability issues.
  
  'for other screens, menus, dialog & message boxes, etc.
  dim FCblk                                           'Forecolour - RGB(Black)
  Dim FCwh                                            'Forecolour - RGB(White)
  dim FCerr                                           'Forecolour - Error Message box (RGB(White))
  dim BC50                                            'Backgroung - RGB(50,50,50)
  Dim BC160                                           'Background - RGB(160, 160, 160)
  Dim BC175                                           'Background - RGB(175, 175, 175)
  Dim BC190                                           'Background - RGB(190, 160, 190)
  Dim BC210                                           'Background - RGB(210, 210, 210)
  dim BCgry                                           'Background - RGB(GRAY)
  DIM BCblu                                           'Background - RGB(BLUE)  
  dim BCblk                                           'Background - RGB(BLACK)
  dim BCerr                                           'Background - Error Message box (RGB(Red))
  
  'text positioning and line spacing
  dim TxtX                                            'X coordinate for text position
  dim IndentX                                         'X coordinate for indented text position
  Dim LnPtrX                                          'X coordinate for the Editor current line indicator 
  dim TxtY                                            'Y coordinate for text position when using Fnt_Mnu
  dim OutY                                            'Y coordinate for text position when using Fnt_Out
  
  DIM Temp$
  Dim In_Cmd$          
  Dim In_Char$          
  Dim In_Char_Val 
  dim Save_Cmds$(MAXSAVECMDS% - 1)                    'array to save previous commands entered
  Dim Save_CmdsPtr                                    'pointer to the Save_Cmds$ array entries (for saving)
  dim Reload_CmdsPtr                                  'pointer to the Save_Cmds$ array entries (for reloading)
  Dim In_Count 
  Dim In_Rslt 
  dim CmdStartPos                                     'char index in In_Cmd$ of leftmost displayed char 
  Dim CmdMaxChars                                     'max # of chars that can be displayed in the Cmd text box field
  Dim CmdHScrlInc                                     'text box field horizontal scroll increment
  dim CmdCuPos                                        'current Cmd cursor position (char positions in Input text contol box)
  dim CmdPrevCuPos                                    'previous Cmd cursor position
  dim InsertMode                                      'char insert / overwrite mode  (1 = Insert / 0 = Overwrite)
  dim ConsRxLock                                      'Console Rx lock flag
  
  dim Mode=0                                          'Operating Mode - Start in Normal Mode (0)
  
  dim cbY                                             'y coordinate (top) of Command Input Box
  Dim cbH                                             'height of the Command Input Box
  dim opY                                             'y coordinate (top) of the Output Window
  Dim opH                                             'height of the Output Window
  
  'Status Bar and Panels
  Dim sbY                                             'y coordinate (top) of the Status Bar
  dim sbH                                             'height of the Status Bar
  Dim sbpY                                            'Status Bar Panels top (Y)
  dim sbpTextY                                        'Status Bar Panels Text top (Y)
  dim sbpH                                            'Status Bar Panels height
  
  dim ConsMsg$                                        'Console message field
  dim RxChars                                         '# of characters waiting in the COM port Rx buffer  
  Dim opInPtr                                         'index into display line array for next input slot
  dim opLastEndPtr                                    'save index for end line of last display in the Output Window
  dim opDispPtr                                       'index into line array for display in Output Window
  dim opDispLine                                      'count of lines displayed in the Output Window
  dim opMaxLines                                      'max lines displayed in the Output Window
  dim opMaxChars                                      'max characters per line in the Output Window
  Dim opWrap                                          'opLine$ array has filled at least once
  dim opCanScroll                                     'more than MaxLines stored - can scroll display now
  
  Dim f,i                                             'general use integer vars
  dim PrevRxChars           	                        
  dim TankedPcnt           
  
  dim inpX,inpY,inpW,inpH                             'X, Y, Width & Height parameters for Input Text Fields (not Cmd)
  Dim inp_Txt$                                        'Input Text Box string
  dim inpStartPos                                     'char index of leftmost displayed char in Input Text Box
  dim inpMaxChars                                     'max # of chars that can be displayed in the Input Text Box
  dim inpHScrlInc                                     'Horizontal Scroll Increment (for scrollable text fields)
  dim inpCuPos                                        'current cursor position (char index) on the line
  Dim inpPrevCuPos                                    'previous cursor position (char index) on the line
  dim inpMaxLen                                       'maximum number of chars that can be entered in the text box
  
  Dim smX                                             'X coordinate (Left) of the Settings Menu box
  Dim smY                                             'Y coordinate (Top) of the Settings Menu box
  Dim smW                                             'width of Settings Menu box
  Dim smH                                             'height of the Settings Menu box 
  
  Dim cuFC                                            'current Cursor Colour
  dim BeepVol                                         'current Beep volume setting 
  Dim comsBaudRate                                    'current COMS Baud Rate setting 
  Dim TempCuFC                                        'for Settings Menu temporary store of changed value
  dim TempBeepVol                                     'for Settings Menu temporary store of changed value
  dim CfgBaudRate                                     'for Settings Menu temporary store of changed value
  dim BaudRateChgd                                    'Baud Rate changed flag for Settings Menu
  
  Dim ebrX                                            'X coordinate (Left) of the Edit Baud Rate box
  Dim ebrY                                            'Y coordinate (Top) of the Edit Baud Rate box
  Dim ebrW                                            'width of the Edit Baud Rate box
  Dim ebrH                                            'height of the Edit Baud Rate box 
  
  'variables used with Console Log File capture 
  dim lsmX                                            'Logging Setup Mode box left (X)
  dim lsmY                                            'Logging Setup Mode box top (Y)
  dim lsmW                                            'Logging Setup Mode box width (W)
  dim lsmH                                            'Logging Setup Mode box height (H)

  dim FN_MaxLen                                       'size of longest file name in the directory
  dim FileCnt                                         'number of files currently in the directory
  Dim flX                                             'File List box left (X)
  Dim flY                                             'File List box top (Y)
  Dim flW                                             'File List box width (W)
  Dim flH                                             'File List box height (H)
  dim flMaxChars                                      'File List max chars per line
  dim flMaxLines                                      'File List max lines visible
  dim flMaxIdx                                        'Max valid index into the File Name array
  dim flCurrStrtPtr                                   'File Name array index for the currently displayed top line entry
  Dim flCurrSelPtr                                    'File Name array index for the currently selected entry
  Dim flPrevSelPtr                                    'File Name array index for the previously selected entry
  dim flErrMsg$                                       'Error message associated with SDCard file access
  
  dim LogOpen                                         'Logging Enabled / Log file open flag
  dim LogFN$                                          'Log File Name
  dim LogLnSeq                                        'log file line sequence number 
  
  dim SrchRsltsAvail                                  'Search Results are available flag  
  dim vlmFN$                                          'Log File Name currently being viewed
  dim vlmRecCnt                                       'Number of records in the log file to be viewed
  dim vlmLastStartRecNbr                              'Last record number starting the display
  Dim vlmNextRecNbr                                   'Next sequential record number to display 
  dim vlmSelRecNbr                                    'Record Number Selected via Search Results screen
  dim vlmHScrl                                        'Number of characters the output window is scrolled horizontally
  dim vlmMaxHScrl                                     'Max HScrl value to accomodate longest record in log file
  dim lsmcX                                           'Left (X) for the Log Search Match Case check box
  dim lsmcY                                           'Top (Y) for the Log Search Match Case check box
  dim lstsX                                           'Left (X) for the Log Search Include Timestamp check box
  dim lstsY                                           'Top (Y) for the Log Search Include Timestamp check box
  dim lsmMtchCase                                     'Log Search Match Case flag
  dim lsmInclTS                                       'Include searching the record Timestamp     
  dim dsrRecCnt                                       'Count of records with match on the Log Search String
  dim dsrLastStrtIdx                                  'Last Search RsltsIdx starting the display
  Dim dsrNextIdx                                      'Next sequential Search RsltsIdx to display 
  dim dsrHScrl                                        'Number of characters the output window is scrolled horizontally
  dim dsrMaxHScrl                                     'Max HScrl value to accomodate longest record in search results
  dim dsrIndRow                                       'Current Selected Line (Indicator) on Display Srch Rslts screen
  dim dsrPrevIndRow                                   'Previous Selected Line (Indicator) on Display Srch Rslts screen
  dim dsrRecNbrs(2)                                   'dummy array for saving Rec Nbrs for Srch Rslts screen
  
  dim spfX                                            'Select Program File Mode box left (X)
  dim spfY                                            'Select Program File Mode box top (Y)
  dim spfW                                            'Select Program File Mode box width (W)
  dim spfH                                            'Select Program File Mode box height (H)
  dim pumX                                            'Program Upload Mode box left (X)
  dim pumY                                            'Program Upload Mode box top (Y)
  dim pumW                                            'Program Upload Mode box width (W)
  dim pumH                                            'Program Upload Mode box height (H)
  dim pumState                                        'Upload process state 0 = not started, 1 = Running, 2 = Complete, -1 = Failed
  dim pumFN$                                          'Program File Name to be uploaded
  dim pumCrnFN$                                       'Crunched Program File Name
  dim CrunchOpt                                       'Crunch File option flag
  dim CLSOpt                                          'Send CLS option flag
  dim cfX                                             'Left (X) for the Crunch File check box
  dim cfY                                             'Top (Y) for the Crunch File check box
  dim scX                                             'Left (X) for the Send CLS check box
  dim scY                                             'Top (Y) for the Send CLS check box
  dim upsX                                            'Upload Status box left (X)
  dim upsY                                            'Upload Status box top (Y)
  dim upsW                                            'Upload Status box width (W)
  dim upsH                                            'Upload Status box height (H)
  dim upsTxtX                                         'Left (X) for next Text in the Upload Status box
  dim upsTxtY                                         'Top (Y) for next Text line in the Upload Status box
  
  dim RxTOutFlg                                       'Flag indicating the RxTimeout period has expired during Upload
  Dim RxData$                                         'Data received from the target MM during Program Upload process
  dim Resp1$                                          'Response string #1 from target MM during Upload
  dim Resp2$                                          'Response string #2 from target MM during Upload

  Dim edFN$                                           'Program File Name to be edited 
  Dim edSaveFN$                                       'File Name edited program will be saved as
  dim edUpdFN$                                        'File name for the Temp UpdRec file storing updated recs
  dim edModFlg                                        'file modified flag
  dim edRecCount                                      'number of records in the Program File being edited 
  dim edRec$                                          'save area for current record in Edit window
  dim edRecMod                                        'current edRec$ content has been modified (requires save).
  dim edState                                         'save area for State of current record in Edit window
  dim edY                                             'Top (Y) for the Edit Window
  dim edH                                             'Height (H) for the Edit Window
  dim edMaxLines                                      'Max lines available in the Edit Window
  dim edMaxChars                                      'Max visible chars on an Edit Window line
  dim edMaxTxt                                        'Max visible text chars (excl Rec Nbr)
  dim edHScrlInc                                      'Edit Mode horizontal scroll increment
  dim edStart                                         'Pointer to the first non-deleted entry in edRecTrak linked list
  dim edEnd                                           'Pointer to the last non-deleted entry in edRecTrak linked list
  dim edNewIdx                                        'Index of the next RecTrak entry to use for inserted record
  dim edUpdPtr                                        'Pointer offset to the next record to assign in UpdRec file
  dim edUpdCnt                                        'Count of Pending Updates (records in edUpdFN$ file)
  dim edUpdWarn                                       'Nbr of updates prior to Max to issue Warning
  dim edUpdWarnState                                  'Tracks which Warning state the Upd Warnings is in.
  dim edStrtRec                                       'Record Number starting the current Edit mode display
  Dim edStrtIdx                                       'Index to RecTrak entry starting the current Edit mode display
  dim edCurrRec                                       'Record Number for the current Cursor Row in the Edit Window
  Dim edCurrIdx                                       'Index to RecTrak entry for the current Cursor Row in the Edit Window
  dim edEndRec                                        'Record Number for the last row of the current Edit mode display
  Dim edEndIdx                                        'Index to RecTrak entry for the last row of the current Edit mode display
  dim edCuRow                                         'Current Cursor Row (Line) on Edit screen
  dim edCuCol                                         'Current Cursor Column (char) on Edit  screen
  dim edPrevCuRow                                     'Previous Cursor Line on Edit screen
  dim edPrevCuCol                                     'Previous Cursor Column (char) on Edit  screen
  dim edTargCuCol                                     'Target Cursor Column for cursor move up/down
  dim edStartPos                                      'Position in record for left char of displayed line (Scroll offset)
  dim edPrevStartPos                                  'Previous StartPos value
  dim edFndX                                          'Left (X) for the Find & Replace text boxes
  dim edFndY                                          'Top (Y) for the Find text box
  dim edReplY                                         'Top (y) for the Replace text box
  dim edFndTarg$                                      'Find Target string
  dim edReplVal$                                      'Replace Value string
  dim edFndReplFlg                                    'flag tracking which input field has focus 0=Fnd, 1= Repl
  dim edFndCuPos                                      'save Cursor Pos for the Find Target field
  dim edFndPrevCuPos                                  'save Previous Cursor Pos for the Find Target field
  dim edReplCuPos                                     'save Cursor Pos for the Replace With field
  dim edReplPrevCuPos                                 'save Previous Cursor Pos for the Replace With field
  dim edHLRow                                         'HiLite Row (line) on the Edit screen
  dim edPrevHLRow                                     'Previous HiLite Row
  dim edHLPos                                         'HiLite position within record

  dim fnd1st                                          'Editor Find Initial/Find Next flag
  dim fndUseCurr                                      'Editor Find use current cursor pos as starting point    
  dim fndStrtRec                                      'Editor Find Start Rec Nbr (only set at start of scan cycle)
  dim fndStrtIdx                                      'Editor Find Start Rec Index (in edRecTrak array)
  dim fndStrtPos                                      'Editor Find Start position within record
  dim fndFlg                                          'Editor Find result flag: 0=Not Found, 1=Found, -1=EOF
  dim fndNxtRec                                       'Editor Find Next Rec Nbr
  dim fndNxtIdx                                       'Editor Find Next Rec Index (in edRecTrak array)
  dim fndNxtPos                                       'Editor Find Next position within record

  dim cpfFN$                                          'Program File Name to be crunched (standalone mode)
  dim cpfCrnFN$                                       'Crunched Program File Name (standalone mode)
  dim cpfOLines                                       '# of lines in the original file
  dim cpfOBytes                                       '# of bytes in the original file
  dim cpfCLines                                       '# of lines in the crunched file
  dim cpfCBytes                                       '# of bytes in the crunched file
  dim cpfElapTi                                       'elapsed time for crunch (milliSecs)
  dim cpfDone                                         'Standalone Crunch completed
  
  '============================================================================================================
  '-----------------
  'Main Program Code
  '-----------------
  
  ? "Starting " + ProgTitle$ + ": " + ProgVer$ + " - " + ProgDate$
  ? ""
  
  'determine sizes of the 2 output fonts - the sizes are saved 
  'for use by the Font Select Menu and all screen building functions. 
  FONT 1
  fW_Out_1=MM.Fontwidth                               'font width
  fH_Out_1=MM.Fontheight                              'font height
  
  FONT 2
  fW_Out_2=MM.Fontwidth                               'font width
  fH_Out_2=MM.Fontheight                              'font height
  
  'setup default Menu Font (using Font #2) and associated parameters
  'in case we need to report any errors during program initialization.
  'These initial settings may be overidden later in the initialization process. 
  Fnt_Mnu=2
  fW_Mnu=fW_Out_2
  fH_Mnu=fH_Out_2
  
  CLS RGB(Blue)
  
  StrFN$=DATADIR$ + "/" + STRINGSFN$                  'set Strings file name
  StrCnt=LoadStringPtrs()                             'load the pointers to the Literal Strings
  '? Str$(StrCnt) + " Strings loaded from the Strings file."
  
  if mm.Hres<800 or MM.Vres<480 then                  'incompatible screen res - terminating
    ? ""  
    ? "ERROR:"
    ? "======"
    for i=0 to 3
      In_Cmd$=GetStr(21+i)
      If i=2 Then In_Cmd$=GetStr(23,Str$(mm.Hres),Str$(MM.Vres))
      ? In_Cmd$
      Text MM.HRes\2,MM.VRes\2+(-56+(i*30)),In_Cmd$,CT,1,1,RGB(White),RGB(Blue)
    next i
    
    end                                               'terminate the program here
  endif
  
  'set DEFAULT values for settings options (incl font selection)
  cuFC=RGB(YELLOW)                                    'default cursor colour (Yellow)
  BeepVol=7                                           'default beep volume (Medium)
  comsBaudRate=38400                                  'default coms baud rate (38400)
  SaveFontSelect=2                                    'default Output Font - #2
  
  'restore settings options from saved variables (if they have been previously saved).
  'this will overwrite the defaults set above if that variable has been saved.
  VAR Restore
  
  'set Selected Output Font and associated Font size
  If SaveFontSelect=1 then
    Fnt_Out=1
    fW_Out=fW_Out_1
    fH_Out=fH_Out_1
  Else
    Fnt_Out=2
    fW_Out=fW_Out_2
    fH_Out=fH_Out_2
  ENDIF

  'Set the font used for the Menus and Setup Mode functions.
  'This will default to the selected Output Font, however
  'a check is made to verify the selected font height is suitable.
  'If the font height is greater than 20 pixels it is too big
  'to use for the Menus and Setup Mode functions, so use
  'in-built Font #1 instead.
  
  If fH_Out > 20 then
    'The selected Output Font is too big - use Standard Font #1 - it can't be replaced!
    'save Menu Font details
    Fnt_Mnu=1
    fW_Mnu=fW_Out_1
    fH_Mnu=fH_Out_1
    
  else
    'the specified Output Font is OK - save Menu Font details
    Fnt_Mnu=Fnt_Out
    fW_Mnu=fW_Out
    fH_Mnu=fH_Out
  endif
  
  'set up Text Box Input Font parameters
  Fnt_In=FONT_IN%                                     'library font #16 - IBM_VGA10x16_96
  Font Fnt_In
  fW_In=MM.FONTWIDTH                                  'Font Width
  fH_In=MM.FONTHEIGHT                                 'Font Height
  
  'set the default font back to Font #2 - to match the LCDPANEL CONSOLE default use
  'NOTE: The default Font Setting is NOT used within the program code, 
  '=====      as all TEXT statements specify which Font to use.
  Font 2
  
  'setup Colours
  'Foreground  
  FCblk=RGB(Black)
  FCwh=RGB(WHITE)
  FCerr=RGB(White)                                    'Error Message box fore colour
  'Background
  BC50=RGB(50,50,50)
  BC160=RGB(160, 160, 160)
  BC175=RGB(175, 175, 175)
  BC190=RGB(190, 190, 190)
  BC210=RGB(210, 210, 210)
  BCgry=RGB(Gray)
  BCblu=RGB(Blue)
  BCerr=RGB(Red)                                      'Error Message box back colour
  
  if PIN_BEEP%<>0 then                                'if NOT using GUI BEEP
    'Beeper Pin config
    on error skip 1                                   'in case the Beeper pin is assigned as the Touch Click pin
    SETPin PIN_BEEP%, DOUT                            'set Beeper pin as output
  endif
  
  'Normal Mode flags
  CmdMaxChars=FIX((MM.Hres - 20)/fW_In)               'max display chars in command field
  CmdHScrlInc=Fix(CmdMaxChars/2)                      'horizontal scroll in 1/2 command field width steps
  CmdStartPos=1
  CmdCuPos=0
  CmdPrevCuPos=0
  InsertMode=1                                        'default to insert mode
  ConsRxLock=0                                        'default - Console Rx Lock is disabled  
  LogOpen=0                                           'Logging is disabled
  Save_CmdsPtr=0
  Reload_CmdsPtr=0
  SrchRsltsAvail=0                                    'reset Search Results Avail flag
  pumState=0                                          'Program Upload NOT running
  edTargCuCol=-1                                      'no Traget Cursor Column specified at present
  
  'draw the normal mode screen layout (includes calculating certain
  'display related paramters)
  DrawScreen_Normal(1)
  
  'The following string array is declared here so as to take advantage of 
  'using a dynamic length for each entry since that was only calculated in
  'the call to DrawScreen_Normal(1) above. 
  DIM opLine$(MAXENTRIES%) Length opMaxChars          'Console Output window display line array

  In_Cmd$=""                                          'clear Command Text
  UpdateText_Cmd()                                    'and update the Command Text input box
  
  Settick 1000,UpdDtTm,4                              'set timer interrupt for updating date & time on the Status Bar
  UpdDtTm()                                           'do first update now
    
  Open "COM1:" + Str$(comsBaudRate) + ",5120" As #1   'open the COM port connected to the target MM Console
  '                                                   'specifying a 5K Rx buffer.  
  Do
    RxChars=LOC(#1)
    If RxChars > 0 then
      if not ConsRxLock then
        ConsMsg$=Input$(255, #1)                      'read up to 255 bytes from the Rx Buffer
        ProcessConsMsg()                              'process the console message(s)
        
      else
        'ConsRxLock is on - don't process COM port input at present
        if PrevRxChars <> RxChars then
          PrevRxChars=RxChars
          TankedPcnt=Fix((RxChars/5120)*100)
          If TankedPcnt >= 85 then f=1 Else f=2
          UpdSBPanel(7,"Rx Lock " + Str$(TankedPcnt) + "%",f)
        endif
      endif
    Endif
    
    In_Count=Loc(#0)                                  'check keyboard input buffer (File #0)
    
    If In_Count > 0 Then
      In_Char$=Input$(1, #0)                          'grab first character in the buffer
      In_Char_Val=ASC(In_Char$)                       'and get ASCII value of that character
      
      'process input depending upon the current Mode
      Select Case Mode
        Case 5                                        'Settings Mode
          In_Rslt=ProcIn_SM()
        Case 10                                       'Edit Baud Rate Mode
          In_Rslt=ProcIn_EBR()
        'Note: Mode=15 is no longer used  
        CASE 20                                       'Console Logging Setup Mode
          In_Rslt=ProcIn_LSM()
        CASE 25                                       'Select log File Mode
          In_Rslt=ProcIn_SLM()
        CASE 30                                       'View Log File Mode
          In_Rslt=ProcIn_VLM()
        'Note: Mode=35 is no longer used  
        CASE 40                                       'Get Search Log Parameters Mode
          In_Rslt=ProcIn_SPM()
        CASE 45                                       'Display Search Log Results Mode
          In_Rslt=ProcIn_DSR()
        CASE 50                                       'Select Program File Mode
          'NOTE: ProcIn_SPF (Select Prog File Mode) is 
          '      shared with Mode 60 & 75 (see below)
          In_Rslt=ProcIn_SPF()
        CASE 55                                       'Program File Upload Mode                                       
          In_Rslt=ProcIn_PUM()
        CASE 60                                       'Select Edit File Mode
          'NOTE: Sharing ProcIn_SPF with 
          '      Select Prog File Mode (see above)
          In_Rslt=ProcIn_SPF()
        CASE 65                                       'Program File Edit Mode
          In_Rslt=ProcIn_ED()
        CASE 70                                       'Get Save As File Name Mode
          In_Rslt=ProcIn_SAF()
        CASE 75                                       'Select File to Crunch Mode
          'NOTE: Sharing ProcIn_SPF with 
          '      Select Prog File Mode (see above)
          In_Rslt=ProcIn_SPF()
        CASE 80                                       'Crunch File (Standalone) Mode
          In_Rslt=ProcIn_CPF()
        CASE 85                                       'Find/Replace Parameters Mode
          In_Rslt=ProcIn_FND()
        Case Else                                     'Mode=0 - Normal Console Mode
          In_Rslt=ProcIn_Normal()
      end select
      
      'NOTE:  The Select Case above and the ones below CANNOT be amalgamated as the
      '=====  Mode may be changed by processing within the ProcIn_xxx functions (above).
      
      Select Case Mode
        '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        '  S E T T I N G S    M O D E                  ~
        '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~        
        CASE 5
          SELECT CASE In_Rslt
            CASE 1
              ShowSettingsMenu(1)                     'initial display of Settings Menu                     
            CASE 2
              ShowSettingsMenu(0)                     'refresh display of Settings Menu
            CASE Else                     
              'done - no update reqd       
          End Select
          
        '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        '  E D I T B A U D R A T E    M O D E          ~
        '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        CASE 10
          SELECT CASE In_Rslt
            CASE 1
              ShowEditBaudRate(1)                     'initial display of the Edit Baud Rate control box 
            CASE 2
              ShowEditBaudRate(0)                     'refresh Edit Baud Rate control box 
            CASE 3
              UpdateText_INP()                        'update New Baud Rate Input Text box (& cursor posn)
            CASE 4
              MoveCursor_INP()                        'move the New Baud Rate Input Text box cursor
            CASE Else
              'done - no update reqd
          End SELECT
        
        'NOTE: MODE=15 is no longer used.
        '================================
        
        '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        '  L O G G I N G S E T U P    M O D E          ~
        '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        CASE 20
          SELECT CASE In_Rslt
            CASE 1
              ShowLogFileEnable(1)                    'initial display of the Logging Setup Box
            CASE 2                                    'refresh display of the Logging Setup Box  
              ShowLogFileEnable(0)                    'used to clear the Error Msg box 
            CASE 3
              UpdateText_INP()                        'refresh Log File Name Input Text box
            CASE 4
              MoveCursor_INP()                        'move the cursor in the Log File Name Input Text box
            CASE Else
              'done - no update reqd
          end SELECT
        
        '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        '  S E L E C T L O G    M O D E                ~
        '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        CASE 25
          SELECT CASE In_Rslt
            CASE 1
              SelectLogFile(1)                        'initial display of the Select Log File box
            CASE 2
              SelectLogFile(0)                        'refresh the Select Log File box
            CASE Else
              'done - no update reqd
          end SELECT
        
        '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        '  V I E W L O G    M O D E                    ~
        '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        CASE 30
          SELECT CASE In_Rslt
            CASE 1                                    'initial display of the View Log File screen 
              ViewLogFile()                           'setup & start viewing the selected log file
            CASE 2                                    're-display the View Log screen
              'used on return from the Get Search Params or the Get Go To Rec Nbr screens.
              'Returns to the Display Log at the record pointed to by vlmLastStartRecNbr
              'which may be the same or different to what ws previously displayed.
              DisplayLog(vlmLastStartRecNbr, vlmHScrl)
            CASE Else
              'done - no update reqd
          end SELECT
        
        'NOTE: MODE=35 is no longer used.
        '================================
        
        '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        '  G E T S E A R C H P A R A M S    M O D E    ~
        '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        CASE 40
          SELECT CASE In_Rslt
            CASE 1
              GetSrchLogFileParams(1)                 'initial display of the Get Search Parameter input screen 
            CASE 2
              GetSrchLogFileParams(0)                 'refresh Get Search Parameter screen
            CASE 3
              UpdateText_INP()                        'refresh Search String input text box
            CASE 4
              MoveCursor_INP()                        'move / re-draw cursor
            CASE -1
              DispNoSearchMatches()                   '0 matches found during search
              'refresh the Get Search Parameters screen to clear the error message
              GetSrchLogFileParams(1)
            CASE Else
              'done - no update reqd
          end SELECT     
        
        '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        '  D I S P S R C H R E S U L T S    M O D E    ~
        '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        CASE 45
          SELECT CASE In_Rslt
            CASE 1
              dsrPrevIndRow=0
              dsrIndRow=1
              dsrHScrl=0
              DispSrchResults(1,dsrHScrl)             'initial display of the Display Search Results screen 
            CASE 2
              DispSrchResults(dsrLastStrtIdx,dsrHScrl)  'refresh Display Search Results screen
            cASE 3
              SetCurrLnInd()                          'move the Current Line Indicator
            CASE Else
              'done - no update reqd
          end SELECT
          
        '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        '  S E L E C T P R O G F I L E    M O D E      ~
        '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        CASE 50
          SELECT CASE In_Rslt
            CASE 1
              SelectProgFile(1)                       'initial display of the Select Program File box
            CASE 2
              SelectProgFile(0)                       'refresh the Select Program File box
            CASE Else
              'done - no update reqd
          end SELECT   
        
        '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        '  P R O G R A M U P L O A D    M O D E        ~
        '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        CASE 55
          SELECT CASE In_Rslt
            CASE 1
              ProgramUpload(1)                        'initial display of the Program Upload screen
            CASE 2
              ProgramUpload(0)                        'refresh Program Upload screen
            CASE 3
              DoUpload()                              'initiate Program Upload (incl display Upload Status)
            CASE Else
              'done - no update reqd
          end SELECT  
          
        '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        '  S E L E C T E D I T F I L E    M O D E      ~
        '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        CASE 60
          'NOTE: Shares the Select Program File screen with the Upload Program function (Mode=50)
          
          SELECT CASE In_Rslt
            CASE 1
              SelectProgFile(1)                       'initial display of the Select Program File box
            CASE 2
              SelectProgFile(0)                       'refresh the Select Program File box
            CASE Else
              'done - no update reqd
          end SELECT    
          
        '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        '  P R O G R A M E D I T    M O D E            ~
        '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        CASE 65
          SELECT CASE In_Rslt
            CASE 1
              If Not ProgramEdit() Then               'initial display of the Program Edit screen
                'load of selected Program file failed 
                '- reason already reported, just return to the Normal mode
                ExitEditor()
                UpdateOutputWindow(opLastEndPtr)      'refresh Output Window
                UpdateText_Cmd()                      'refresh Command Input text box
              endif  
            CASE 3,8
              UpdateEditLine()                        'update the current Edit Line text & refresh line
            CASE 4,9
              MoveCursor_Edit()                       'move / re-draw cursor
            CASE 5,10                                 'display Edit window (new or scrolled up/dn/left/right)
              If edRecMod then                        'current edRec$ content is modified but unsaved so
                SaveModifiedRecord()                  'save it before proceeding (resets RecMod flag).
              endif
              DisplayEditLines(edStrtRec,edStrtIdx)   'display screen
            Case 7                                    'Move Highlighting to new Find Target text pos
              ClrPrevHiLite()                         'clear previous highlight
              ShowHiLite()                            'and show new highlight
              MoveCursor_Edit()                       'move / re-draw the cursor  
            CASE Else
              'done - no update reqd
          end SELECT
          
          Select Case In_Rslt
            Case 8,9,10
              fndUseCurr=1                            'set flag for Find Next to use cursor pos as Start
          end select
        
        '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        '  G E T S A V E A S F I L E N A M E    M O D E  ~
        '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        CASE 70
          SELECT CASE In_Rslt
            CASE 1
              GetSaveAsName(1)                        'initial display of the Save As File Name box
            CASE 2                                     
              GetSaveAsName(0)                        'refresh display of the Save As File Name box 
            CASE 3
              UpdateText_INP()                        'refresh the Save As File Name Text box (& cursor)
            CASE 4
              MoveCursor_INP()                        'move the cursor in the Save As File Name box
            CASE Else
              'done - no update reqd
          end SELECT
        
        '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        '  S E L E C T C R U N C H F I L E    M O D E  ~
        '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        'NOTE: Shares the Select Program File screen with the Upload Program & Edit Program functions
        '         (Mode=50 & Mode=60)
        
        CASE 75
          SELECT CASE In_Rslt
            CASE 1
              SelectProgFile(1)                       'initial display of the Select Program File box
            CASE 2
              SelectProgFile(0)                       'refresh the Select Program File box
            CASE Else
              'done - no update reqd
          end SELECT
         
        '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        '  C R U N C H P R O G F I L E    M O D E      ~
        '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        CASE 80
          SELECT CASE In_Rslt
            CASE 1
              StandaloneCrunchFile(1)                 'initial display of the Standalone Crunch File screen
            CASE 2
              StandaloneCrunchFile(0)                 'refresh the Standalone Crunch File screen
            CASE 3
              DoCrunch()                              'initiate Standalone File Crunch (incl progress updates)
            CASE Else
              'done - no update reqd
          end SELECT 
        
        '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        '  F I N D / R E P L P A R A M S    M O D E    ~
        '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        CASE 85
          SELECT CASE In_Rslt
            CASE 1
              DispFindReplParams(1)                   'initial display of the DispFindReplParams screen
            CASE 2                                     
              DispFindReplParams(0)                   'used to clear the Error Msg box 
            CASE 3
              UpdateText_INP()                        'refresh Find/Replace Parameters Input Text box
            CASE 4
              MoveCursor_INP()                        'move the cursor in the Find/Replace Parameters Text box
            CASE Else
              'done - no update reqd
          end SELECT
       
        '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        '  N O R M A L    M O D E                      ~
        '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        CASE Else                                     'must be NORMAL Mode
          SELECT CASE In_Rslt
            CASE -99                                  'EOJ request
              Exit Do
            CASE -3                                   'F2 - set Date & Time in the target MM
              Print #1,"Date$ = " + Chr$(34) + Date$ + Chr$(34) + ": Time$ = " + Chr$(34) + Time$ + Chr$(34) + CHR$(13);                          'send Ctrl-C to the target MM Console
              IncrInPtr()
              StoreConsMsg(GetStr(247),0,0)      
              UpdateOutputWindow(opInPtr)             'record action in Output Window
            CASE -2                                   'F1 - send ^C
              Print #1,Chr$(3) + Chr$(13);            'send Ctrl-C to the target MM Console
              IncrInPtr()
              StoreConsMsg(GetStr(248),0,0)      
              UpdateOutputWindow(opInPtr)             'record action in Output Window
            CASE -1                                   'CR was entered
              If UCase$(In_Cmd$)="EDIT" then          'EDIT command is not supported
                Beep()
                MessageBox(MM.Hres\2,opY+opH\2,GetStr(265),GetStr(266),GetStr(267),"",1,FCerr,BCerr)
                UpdateOutputWindow(opLastEndPtr)      'refresh Output Window (to clear MsgBox)
              else  
                Print #1,In_Cmd$ + CHR$(13);          'send command text to the target MM Console
                SaveLastCmd()                         'save this command in last commands array
              endif
              In_Cmd$=""                              'clear command input string
              CmdStartPos=1
              CmdCuPos=0
              CmdPrevCuPos=0
              UpdateText_Cmd()                        'update displayed text field
            CASE 2,7                                  'refresh the Normal Mode screen
              UpdateOutputWindow(opLastEndPtr)        'refresh Output Window
              UpdateText_Cmd()                        'refresh Command Input text box
              If In_Rslt=7 then UpdSBPanel(1,GetStr(204),1) ''Edited File Saved' msg in Status Panel #1
              UpdConsRxLock(0)                        'disable the Console Rx Lock (if enabled)             
            CASE 3                                    'Input processed
              UpdateText_Cmd()                        'update Command Input text box (& cursor posn)
            CASE 4                                    'cursor moved / changed
              MoveCursor_Cmd()                        'move / re-draw cursor
            CASE Else
              'done - no update reqd
          End SELECT
      end Select
      
      Pause 50									                      '50mSec delay
    EndIf
  Loop 
  
  'exiting the above loop is only done via 
  'F12 (Terminate Program) while in Normal Console mode.
  'code below handles program termination.
  
  Settick 0,0,4                                       'disable the Date & Time update
  Settick 0,0,3                                       'disable the Notification Panel reset timer
  Beep()                                              'double beep signifies program shutdown
  pause 100
  Beep()
  Close #1                                            'close the COM1 port

  If LogOpen then                                     'logging is currently enabled
    'close logging now
    LogConsMsg("",1)          
    LogConsMsg(GetStr(26,Date$,Time$),1)
    Close #2                                          'close the logfile 
    LogOpen=0
  endif
  
  If StringsOpen Then
    Close #10                                         'close the Literal Strings file, if open
    StringsOpen=0
  endif
  
  Pause 100
  CLS RGB(BLUE)
  ? GetStr(14)                                        'Program Terminating
  End                                                 'terminate the program
  '  
  '=================================================================================================================

  '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  '  S E T T I N G S M O D E    -    P R O C E S S I N P U T     ~
  '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  Function ProcIn_SM()                                'for the Settings Menu
    'determine which key was pressed and action accordingly
    
    ProcIn_SM=2                                       'default - refresh Settings Menu

    Select Case In_Char_Val        
      Case 13                                         'ENTER - Save
        If TempCuFC <> cuFC Then  
          'save changed Cursor Colour selection
          cuFC=TempCuFC
          VAR Save cuFC                               'save setting
        Endif
        
        If TempBeepVol <> BeepVol then
          'save changed Beep Volume selection
          BeepVol=TempBeepVol
          VAR SAVE BeepVol                            'save setting
        endif
        
        If BaudRateChgd then
          'save changed COMS Baud Rate
          comsBaudRate=CfgBaudRate
          VAR SAVE comsBaudRate                       'save setting
          UpdSBPanel(5,"",0)
        Endif
        
        If SaveFontSelect=1 AND Fnt_Out <> 1 Then  
          'save changed Font selection
          VAR Save SaveFontSelect                     'save setting
          
        ElseIf SaveFontSelect=2 AND Fnt_Out <> 2 Then  
          'save changed Font selection
          VAR Save SaveFontSelect                     'save setting
        Endif
        
        UpdSBPanel(1,GetStr(99),1)                    'Put Notification in Status Bar Panel #1 & start ResetNotify timer
        'exiting this mode - Note the Mode switch:
        Mode=0                                        'switch back to Normal Mode
        ProcIn_SM=2                                   'return to the Normal Mode screen (& disable ConsRxlock)
        
      Case 27                                         'ESC - Exit (discard changes)
        'exiting this mode - Note the Mode switch:
        Mode=0                                        'switch back to Normal Mode
        ProcIn_SM=2                                   'return to the Normal Mode screen (& disable ConsRxlock) 
        
      Case 145                                        'F1 - Cursor Colour = Red
        TempCuFC=RGB(Red)
        
      Case 146                                        'F2 - Cursor Colour = Yellow
        TempCuFC=RGB(Yellow)
        
      Case 147                                        'F3 - Cursor Colour = Green
        TempCuFC=RGB(Green)
        
      Case 148                                        'F4 - Cursor Colour = Magenta
        TempCuFC=RGB(Magenta)
        
      Case 149                                        'F5 - Beep Volume = Off
        TempBeepVol=0
        
      Case 150                                        'F6 - Beep Volume = Loud
        TempBeepVol=20
        
      Case 151                                        'F7 - Beep Volume = Medium
        TempBeepVol=7
        
      Case 152                                        'F8 - Beep Volume = Soft
        TempBeepVol=1
        
      Case 153                                        'F9 - Edit Coms Baud Rate
        'switch to Edit Baud Rate Mode and
        'display the Change Baud Rate control box
        Mode=10
        ProcIn_SM=1                                   'show Edit Baud Rate control box                         
        
      Case 154                                        'F10 - Small Font
        SaveFontSelect=1
        
      Case 155                                        'F11 - Large Font
        SaveFontSelect=2
        
     Case else
        Beep()
        ProcIn_SM=0                                   'Invalid key pressed - ignored, no action reqd
    End Select
    
  end Function

  '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  '  E D I T B A U D R A T E    -    P R O C E S S I N P U T     ~
  '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  
  Function ProcIn_EBR()                               'for the Edit Baud Rate (EBR) control
    'determine which key was pressed and action accordingly
    
    ProcIn_EBR=0                                      'default - ignore input, no update
    
    'using ProcIn_StdTxt to handle standard text input and related actions.  
    'Use the following SELECT CASE to handle specific actions for 'Enter', 'Esc' 
    'and any Function keys (except 'F3' - clear input). 
    'Also include filtering any non-allowed text characters from the input text. 
    Select Case In_Char_Val
      Case 32 to 47, 58 to 126                        'disallow all alpha characters except numerics 0 -> 9
        Beep()
        
      case 13                                         'ENTER key - OK
        If ValidateBaudRate() then                 
          BaudRateChgd=1                              'set Baud Rate Changed flag
          'exiting this mode - Note the Mode switch:
          Mode=5                                      'switch to Settings Mode
          ProcIn_EBR=2                                'return to the Settings Menu display 
          
        Else                                          'validation failed
          'refresh the Edit Baud Rate control box to clear the Error Msg box
          ProcIn_EBR=2                                'refresh Edit Baud Rate control box
        EndIf
        
      Case 27                                         'ESCAPE key - Cancel
          'exiting this mode - Note the Mode switch:
          Mode=5                                      'switch to Settings Mode
          ProcIn_EBR=2                                'return to the Settings Menu display 
          
      Case else
        'all other values are potentially processed (or rejected)
        'by the StdText handler
        ProcIn_EBR=ProcIn_StdTxt(inp_Txt$,inpMaxLen,inpCuPos,inpPrevCuPos)
    end Select
    
  end Function

  '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  '  L O G G I N G S E T U P M O D E    -    P R O C E S S I N P U T     ~
  '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  Function ProcIn_LSM()                               'handle Logging Setup Mode 
    'determine which key was pressed and action accordingly
    Local DupFileAction, TxtLen           
    
    ProcIn_LSM=0                                      'Default - no update reqd
    TxtLen=Len(inp_Txt$)

    'using ProcIn_ScrollTxt to handle scrollable text input, related actions.  
    'Use the following SELECT CASE to handle specific actions for 'Enter', 'Esc' 
    'and any Function keys (except 'F3' - clear input). 
    'Also include filtering any non-allowed text characters from the input text.       
    Select Case In_Char_Val
      Case 34, 37, 42, 47, 58, 60, 62, 63, 92, 124
        'printable characters that are NOT valid in a File Name - reject
        Beep()
        
      case 13                                         'ENTER key - OK
        If TxtLen=0 then                              'file name must be specified
          ShowFileError(GetStr(8),"",0)
          ProcIn_LSM=2                                'refresh ShowLogFileEnable box to clear Err Msg box
          
        Else
          'check if the specified file name includes the .LOG suffix
          'add it if required
          If UCASE$(Right$(inp_Txt$,4)) <> ".LOG" then
            If TxTLen > 123 then                      'not enough room to attach the .LOG suffix 
              ShowFileError(GetStr(9),GetStr(10),0)
              ProcIn_LSM=2                            'refresh ShowLogFileEnable box to clear Err Msg box
              Exit Function
            Endif
            
            inp_Txt$=inp_Txt$ + ".log"                'attach file name suffix
          endif
          
          if FileExists(inp_Txt$) then
            'a log file exists with the specified name -
            'need to find out whether to :-
            ' 1. replace the existsing file with the new one        (DupFileAction = 2)
            ' 2. append to the end of the existing file             (DupFileAction = 1)
            ' 3. cancel out to allow a new file name to be entered  (DupFileAction = -1)
            DupFileAction=ShowDupFNOpts(1)
            
            If DupFileAction=-1 then                  'cancel to return to prev screen
              ProcIn_LSM=2                            'refresh ShowLogFileEnable box to clear Dup Filename box
              Exit Function
              
            ElseIf DupFileAction=2 then               'delete existing file
              KILL inp_Txt$                           'delete file
            EndIf
          endif
          
          LogFN$=inp_Txt$
          
          If DupFileAction=1 then                     'append to existing log file
            LogLnSeq=GetLastLogLnSeq(LogFN$)          'do this BEFORE opening the log file
            OpenFile(LogFN$,2,2)                      'open file and check for open error
            LogConsMsg(STRING$(43,"="),1)             'write separator line in log
            
          else                                        'create new log file
            OpenFile(LogFN$,1,2)                      'open file and check for open error
            LogLnSeq=0
          Endif
          
          LogOpen=1
          LogConsMsg(GetStr(25,Date$,Time$),1)
          UpdSBPanel(6,"",0)
          UpdSBPanel(1,GetStr(68),1)
          
          'exiting this mode - Note the Mode switch:
          Mode=0                                      'switch to Normal Mode
          ON Error skip 1
          erase FNames$()                             'release the array used to list the existing log files (if it exists)
          on error clear
          
          ClrSpec()
          ProcIn_LSM=2                                'refresh Normal mode screen (& disable ConsRxlock) 
        endif
       
      Case 27                                         'ESCAPE key - Cancel
        'exiting this mode - Note the Mode switch:
        Mode=0                                        'switch to Normal Mode
        ON Error skip 1
        erase FNames$()                               'release the array used to list the existing log files (if it exists)
        on error clear
        
        ClrSpec()
        ProcIn_LSM=2                                  'refresh Normal mode screen (& disable ConsRxlock) 
        
      Case 128                                        'UP Arrow key
        'move the selection one row further UP the 
        'log file list, scrolling the list if necessary.
        MoveFileSelection(1)                       
        
      Case 129                                        'DOWN Arrow key
        'move the selection one row further DOWN the 
        'log file list, scrolling the list if necessary.
        MoveFileSelection(0)                       
        
      Case 145                                        'F1 key - search for existing Log Files
        BuildFileList(inp_Txt$)
        
      Case else
        'all other values are potentially processed (or rejected) by the ScrollText handler
        ProcIn_LSM=ProcIn_ScrollTxt(inp_Txt$,inpMaxLen,inpStartPos,inpHScrlInc,inpMaxChars,inpCuPos,inpPrevCuPos)
    end Select        
    
  End Function

  '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  '  S E L E C T L O G    M O D E    -    P R O C E S S I N P U T    ~
  '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  Function ProcIn_SLM()                               'for the Select Log function
    'determine which key was pressed and action accordingly
    
    ProcIn_SLM=0                                      'default - no update required
    
    Select Case In_Char_Val        
      Case 13                                         'ENTER key
        If flCurrSelPtr>-1 Then
          If FNames$(flCurrSelPtr)=LogFN$ and LogOpen then
            'selected Log File Name is the currently in-use Console Log - cannot view this file !
            MessageBox(MM.HRes\2,opY+opH\2,GetStr(261),GetStr(262,LogFN$),GetStr(263),GetStr(264),1,FCerr,BCerr)
            ProcIn_SLM=2                              'refresh screen to clear Msg Box  
            
          else
            vlmFN$=FNames$(flCurrSelPtr)              'save Log File Name to be viewed
            'exiting this mode - Note the Mode switch:
            Mode=30                                   'switch to ViewLog Mode
            ON Error skip 1
            erase FNames$()                           'release the array used to list the existing log files (if it exists)
            on error clear
            ProcIn_SLM=1                              'go to View Log File screen
          endif
          
        Else  'no files found - cannot use 'ENTER' key at this time.
          Beep()
        Endif
        
      Case 27                                         'ESCAPE key - Cancel
        'exiting this mode - Note the Mode switch:
        Mode=0                                        'switch to Normal Mode 
        ON Error skip 1
        erase FNames$()                               'release the array used to list the existing log files (if it exists)
        on error clear
        ClrSpec()
        ProcIn_SLM=2                                  'return to the Normal mode screen (& disable ConsRxlock)
        
      Case 128                                        'UP Arrow key
        'move the selection one row further UP the 
        'log file list, scrolling the list if necessary.
        MoveFileSelection(1)                       
        
      Case 129                                        'DOWN Arrow key
        'move the selection one row further DOWN the 
        'log file list, scrolling the list if necessary.
        MoveFileSelection(0)                       
        
     Case else
        Beep()
    End Select
    
  end Function

  '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  '  V I E W L O G    M O D E    -    P R O C E S S I N P U T    ~
  '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  Function ProcIn_VLM()                               'for the View Log function
    'determine which key was pressed and action accordingly
    
    ProcIn_VLM=0                                      'default - action complete, no update required
    
    'using ProcIn_StdView to handle standard View log records navigation and related actions.  
    'Use the following SELECT CASE to handle specific actions for 'Esc' and any required Function keys.    
    Select Case In_Char_Val      
      Case 27                                         'ESCAPE key - Cancel/Exit
        'make sure any instance of the Search Results array is ERASED to free memory
        'ensuring no error is reported if the array doesn't exist.
        On Error Skip 1
        ERASE SrchRslts()
        SrchRsltsAvail=0                              'Search Results are no longer available
        ON Error SKIP 1
        Erase dsrRecNbrs()                            'Erase Srch Rslts Rec Nbrs on Display Srch Rslts screen array
        
        'exiting this mode - Note the Mode switch:
        Mode=0                                        'switch to Normal Mode
        DrawScreen_Normal(0)                          're-draw the Normal Mode screen layout 
        ProcIn_VLM=2                                  'refresh Normal mode screen (& disable ConsRxlock) 
        
      Case 146                                        'F2 key - return to previous Search Results
        if SrchRsltsAvail then
          'search results are saved - go to DispSrchRslts() to re-display Search Results
          'exiting this mode - Note the Mode switch:
          Mode=45                                     'switch to Display Search Results Mode
          ProcIn_VLM=2                                'refresh DispSrchRslts()
          
        else
          Beep()
        endif
        
      Case 151                                        'F7 key - Search Log
        'exiting this mode - Note the Mode switch:
        Mode=40                                       'switch to Get Search Params Mode
        ProcIn_VLM=1                                  'will call GetSrchLogFileParams()
        
     Case else
        'all other values are potentially processed (or rejected) by the StdView handler
        ProcIn_VLM=ProcIn_StdView(vlmLastStartRecNbr,vlmNextRecNbr,vlmRecCnt,vlmHScrl,vlmMaxHScrl)       
    End Select
    
    if In_Char_Val<130 or In_Char_Val>135 or In_Char_Val=132 Or In_Char_Val=133 then
      'not Left Arrow (130), Right Arrow (131), HOME (134) or END (135) keys
      'so clear the Select Rec Nbr (if it was set).
      vlmSelRecNbr=-1
    endif
    
  end Function

  '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  '  G E T S E A R C H P A R A M S    M O D E    -    P R O C E S S I N P U T    ~
  '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  Function ProcIn_SPM()                               'for the Get Search Parameters function
    'determine which key was pressed and action accordingly
    
    ProcIn_SPM=0                                      'default - no action reqd
    
    'using ProcIn_StdTxt to handle standard text input and related actions.  
    'Use the following SELECT CASE to handle specific actions for 'Enter', 'Esc' 
    'and any Function keys (except 'F3' - clear input). 
    'Also include filtering any non-allowed text characters from the input text. 
    Select Case In_Char_Val       
      case 13                                         'ENTER key - OK
        If LEN(inp_Txt$) > 0 then                     'some search text entered
          dsrRecCnt=SearchFileContents(inp_Txt$)
          
          If dsrRecCnt > 0 then                       'found at least 1 match
            'exiting this mode - Note the Mode switch:
            Mode=45                                   'switch to Display Search Results Mode
            ProcIn_SPM=1                              'go to DispSrchResults()
            
          Else
            'no matches found during the search
            ProcIn_SPM=-1                             'display 0 matches found msg box
          endif
          
          exit Function
        EndIf
        
        Beep()
        
      Case 27                                         'ESCAPE key - Cancel
        'exiting this mode - Note the Mode switch:
        Mode=30                                       'switch back to View Log Mode
        ProcIn_SPM=2                                  'go to View Log File screen
        
      Case 149                                        'F5 key - toggle Match Case option
        'Toggle lsmMtchCase flag & update checkbox display
        lsmMtchCase=NOT lsmMtchCase 
        UpdVLSBPanel(5,MatchCaseState())
        UpdChkBox(lsmcX,lsmcY,lsmMtchCase)
        
      Case 150                                        'F6 key - toggle Include Timestampe option
        'Toggle lsmInclTS flag & update checkbox display
        lsmInclTS=NOT lsmInclTS               
        UpdChkBox(lstsX,lstsY,lsmInclTS)
        
     Case else
        'all other values are potentially processed (or rejected) by the StdText handler
        ProcIn_SPM=ProcIn_StdTxt(inp_Txt$,inpMaxLen,inpCuPos,inpPrevCuPos)
    End Select
    
  end Function

  '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  '  D I S P S R C H R E S U L T S    M O D E    -    P R O C E S S I N P U T    ~
  '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  Function ProcIn_DSR()                               'for the Display Search Results function
    'determine which key was pressed and action accordingly
    
    ProcIn_DSR=0                                      'Default Result
    
    'using ProcIn_StdView to handle standard View log records navigation and related actions.  
    'Use the following SELECT CASE to handle specific actions for 'Esc' and any required Function keys.    
    Select Case In_Char_Val
      Case 13                                         'ENTER key - display log showing selected record
        'set the Selected Record Number
        vlmSelRecNbr=dsrRecNbrs(dsrIndRow)
        'display the log from the specified record (-10 rows)
        vlmLastStartRecNbr=dsrRecNbrs(dsrIndRow)-10   'set Start record pointer 10 rows before the selected one
        vlmLastStartRecNbr=MAX(vlmLastStartRecNbr,1)  'don't allow it go be less than 1
        'exiting this mode - Note the Mode switch:
        Mode=30                                       'switch back to View Log Mode
        ProcIn_DSR=2                                  'go to View Log File screen
      
      Case 27                                         'ESC key
        'exiting this mode - Note the Mode switch:
        Mode=40                                       'switch back to Get Search Parameters Mode
        ProcIn_DSR=2                                  'go to Get Search Parameters screen
        
      Case 128                                        'UP Arrow key
        'scroll the selected row indicator up one line.
        If dsrIndRow > 1 then
          'not at start of results - can move Indicator up 1 line
          dsrIndRow=dsrIndRow-1                       'decrement Cursor Row value
          ProcIn_DSR=3                                'update the Selected Row Indicator 
          
        else
          'scroll the results data to display starting one 
          'screen prior to the current start or from the start of the results.
          If dsrLastStrtIdx > 1 then
            'not at start of the results data - can scroll up
            dsrLastStrtIdx=dsrLastStrtIdx-(opMaxLines-1)
            dsrLastStrtIdx=MAX(dsrLastStrtIdx,1)      'limit scroll up to start of file
            dsrPrevIndRow=0
            dsrIndRow=opMaxLines-2
            ProcIn_DSR=2                              'refresh the Display Srch Rslts screen
            
          else
            'can't scroll past the start of the search results
            Beep()
          ENDIF  
        ENDIF  
        
      Case 129                                        'DOWN Arrow key
        'scroll the selected row indicator down one line.         
        If dsrIndRow < opMaxLines-1 then              'allow for header row
          'not at bottom of screen - check if at end of results
          If dsrLastStrtIdx+dsrIndRow-1 < dsrRecCnt then
            'not at end of results - can move Indicator down 1 line
            dsrIndRow=dsrIndRow+1                     'increment Cursor Row value
            ProcIn_DSR=3                              'update the Selected Row Indicator 
            Exit Function
          ENDIF  
          
        Else
          'scroll the results data to display starting one 
          'screen past the current start (unless at the end of the results data).
          If dsrNextIdx < dsrRecCnt then
            'not at end of results - can scroll down
            dsrLastStrtIdx=dsrNextIdx
            dsrIndRow=2
            ProcIn_DSR=2                              'refresh the Display Srch Rslts screen
            exit Function
          endif
        ENDIF 
         
        'can't scroll past the end of the search results
        Beep()
        
      Case Else
        'all other values are potentially processed (or rejected) by the StdView handler
        ProcIn_DSR=ProcIn_StdView(dsrLastStrtIdx,dsrNextIdx,dsrRecCnt,dsrHScrl,dsrMaxHScrl) 
    end Select
    
  end function

  '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  '  S E L E C T P R O G F I L E    M O D E    -    P R O C E S S I N P U T    ~
  '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  Function ProcIn_SPF()                               'for the Select Program File function
    'determine which key was pressed and action accordingly
    
    ProcIn_SPF=0                                      'default - action complete, no further update required
    
    Select Case In_Char_Val        
      Case 13                                         'ENTER key
        If flCurrSelPtr>-1 Then
          'clear the Select Program File box by refreshing the Normal Mode screen format
          UpdateOutputWindow(opLastEndPtr)            'refresh Output Window
          ClrSpec()
          UpdateText_Cmd()                            'refresh Command Input text box
          'exiting this mode - Note the Mode switch:
          If Mode=75 then
            Mode=80                                   'switch to Crunch Program File Mode
            cpfFN$=FNames$(flCurrSelPtr)              'save Program File Name to be crunched
          ElseIf Mode=50 then       
            Mode=55                                   'switch to Program Upload Mode
            pumFN$=FNames$(flCurrSelPtr)              'save Program File Name to be uploaded
          Else
            Mode=65                                   'switch to Program Edit Mode
            edFN$=FNames$(flCurrSelPtr)               'save Program File Name to be edited
          endif
          
          On Error Skip 1
          Erase FNames$()                             'release memory used by the FNames$() array
          On error clear
          ProcIn_SPF=1                                'go to the appropriate screen
          
        Else    'no program files found - cannot proceed at this time!
          Beep()
        Endif
        
      Case 27                                         'ESCAPE key - Cancel
        'exiting this mode 
        On Error Skip 1
        Erase FNames$()                               'release memory used by the FNames$() array
        On error clear
        'Note the Mode switch:
        Mode=0                                        'switch to Normal Mode
        ClrSpec()
        ProcIn_SPF=2                                  'return to the Normal mode screen (& disable ConsRxlock)
        
      Case 128                                        'UP Arrow key
        'move the selection one row further UP the 
        'file list, scrolling the list if necessary.
        MoveFileSelection(1)                       
        
      Case 129                                        'DOWN Arrow key
        'move the selection one row further DOWN the 
        'file list, scrolling the list if necessary.
        MoveFileSelection(0)                       
        
     Case else
        Beep()
    End Select
    
  end Function

  '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  '  P R O G R A M U P L O A D    M O D E    -    P R O C E S S I N P U T        ~
  '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  Function ProcIn_PUM()                               'for the Program Upload function
    'determine which key was pressed and action accordingly
    
    ProcIn_PUM=0                                      'default - no action reqd
    
    Select Case In_Char_Val       
      case 13                                         'ENTER key - Commence Upload / Return to Normal Mode
        if pumState=0 then
          ProcIn_PUM=3                                'Initiate Upload - Display Upload Status screen
          
        ElseIf pumState=-1 then                       'Upload Failed - return to Program Upload screen to allow retry
          ProcIn_PUM=2                                'return to the Program Upload screen
          
        ElseIf pumState=50 Then                       'Upload complete
          'exiting this mode - Note the Mode switch:
          Mode=0                                      'switch to Normal Mode 
          pumState=0                                  'reset Upload State
          ClrSpec()
          ProcIn_PUM=2                                'return to the Normal mode screen (& disable ConsRxlock)
          
        Else
          Beep()
        EndIf
        
      Case 27                                         'ESCAPE key - Cancel
        'exiting this mode - Note the Mode switch:
        Mode=0                                        'switch to Normal Mode 
        pumState=0                                    'reset Upload State
        ClrSpec()
        ProcIn_PUM=2                                  'return to the Normal mode screen (& disable ConsRxlock)
        
      Case 149                                        'F5 key - toggle Crunch File option
        CrunchOpt= NOT CrunchOpt                      'toggle Crunch option setting
        UpdChkBox(cfX, cfY, CrunchOpt)                'update check box
        
      Case 150                                        'F6 key - toggle CLSOpt option
        CLSOpt= NOT CLSOpt                            'toggle CLSOpt option setting
        UpdChkBox(scX, scY, CLSOpt)                   'update check box
        
     Case else
        Beep()
    End Select
    
  end Function

  '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  '  P R O G R A M E D I T    M O D E    -    P R O C E S S I N P U T        ~
  '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  Function ProcIn_ED()                                'for Program Edit function
    'determine which key was pressed and action accordingly
    Local RowCnt,TxtLen,TxtPtr,Work,Work1,WorkText$
    
    ProcIn_ED=0                                       'default - no action reqd
    
    Select Case In_Char_Val
      Case 27,128 To 132,134 To 137,145,146,149,151,152,154,155
        'these keys are non-updating (mainly navigation) and are  
        'therefore allowed in both Read Only and Read Write modes.
        
        'NOTE:  'F5' (149 - Line Delete) is included in the non-updating list
        '=====  since deleting a line does NOT consume an edRecTrak table slot
        '       nor temporary UpdRec file record.
        
      Case Else
        'all others are update potential keys - need to check further
        Work=0
        If In_Char_Val=13 then                        'ENTER key - will cause an update!
          Work=2
          
        Elseif In_Char_Val=8 then                     'BS key
          If edCuCol=0 and edCurrRec > 1 Then         'from Home pos on line, but not first record
            i=GetRecTrakPtr(edCurrIdx,1,1)            'get RecTrak Idx for prev (non-deleted) record
            If GetBit4(edRecTrak(i))=1 then           'prev record State=1 (original)
              Work=2                                  'so this action will cause an update!
            endif
          Else                                        'BS from any pos on line with State=1 will cause update
            If edState=1 then Work=1
          endif
          
        Elseif edState=1 then                         'all other update keys on a line with edState=1
          Work=1                                      'will cause an update
        endif
        
        If Work>0 then                                'need to check updates for Max Pending or Warning
          If ChkUpdWarn() then                        'a msg box has been displayed and needs to be cleared
            If edUpdWarnState=3 then                  'reached the limit - disallow further updates
              'error msg box has been displayed (by ChkUpdWarn()
              ProcIn_ED=5                             'redisplay screen (to clear error msg)
              exit function                           'ignore this key press
            endif
            
            If Work=1 then                            'redisplay screen to clear error msg
              DisplayEditLines(edStrtRec,edStrtIdx)
            endif
          endif
        endif
    end select
    
    'determine if we have a modified edRec$ record that needs 
    'to be saved before processing the new key stroke.
    If edRecMod Then                                  'edRec$ has been modified (currently unsaved).
      Select Case In_Char_Val
        'following keys will potentially cause a change to the Current Rec
        'and hence reloading the edRec$ variable, so need to save the 
        'current edRec$ value, which has been modified, BEFORE processing
        'the new key stroke.
        'NOTE:  Some special case handling is also included in the specific
        '-----  code for the BS key (8) and the DEL key (127) as they MAY 
        '       need to save current data if they will cause a line merge.
        
        Case 13,27,128,129,134 to 137,145,146,149,151,152,154 to 156
          SaveModifiedRecord()                        'save the modified text (resets RecMod flag).
      end Select
    endif
    
    edPrevStartPos=edStartPos                         'save current Start Pos as it might change
    TxtLen=Len(edRec$)
    TxtPtr=edStartPos+edCuCol
   
    Select Case In_Char_Val       
      Case 32 to 126                                  'printable character - add to string
        edTargCuCol=-1                                'clear Target Cursor pos
        edHLRow=-1                                    'clear Find HiLite trigger
        ProcIn_ED=AddText(edRec$,TxtLen,TxtPtr,EDMAXRECSZ%,edCuCol)
        
        If ProcIn_ED > 0 then
          edRecMod=1                                  'set the Record Modified flag
          ProcIn_ED=8                                 'update Text & reset Find Start position
          
          If edCuCol >= edMaxTxt then                 'need to scroll whole screen to the right
            edStartPos=edStartPos+edHScrlInc
            edCuCol=edCuCol-edHScrlInc
            ProcIn_ED=10                              'redisplay screen (scrolled) & reset Find Start pos
            
          elseIf edCuCol < 0 then                     'need to scroll whole screen left
            edStartPos=1
            edCuCol=(Len(edRec$)-edStartPos)+1        'calc new cursor pos 
            ProcIn_ED=10                              'redisplay screen (scrolled) & reset Find Start pos
          Endif
        endif
        
        'NOTE:  ProcIn_ED return value of 5 or 10 (redisplay screen) will
        '=====  invoke a record save, if edRecMod is set, so that the modified
        '       data is not lost during the screen refresh. This is handled
        '       in the code processing the ProcIn_ED return value (single place).
        
      Case 8                                          'BS (BackSpace) character
        If edCuCol=0 and edCurrRec > 1 Then
          'special case on Edit screen - Backspace from Home position 
          'causes text on the current line to be appended to the 
          'previous line (which becomes the current line) and the
          'original line is deleted.
          
          If edRecMod then                            'current edRec$ content is modified but unsaved so
            SaveModifiedRecord()                      'save it before proceeding (resets RecMod flag).
          endif
          
          'get the text (if any) on the previous line (need to skip any
          'deleted record(s) immediately prior to the one being merged)
          Work=GetRecTrakPtr(edCurrIdx,1,1)           'GetRecTrakPtr skips deleted records
          WorkText$=GetRec(Work,edState)  
          
          'check total length of text in both records
          If LEN(edRec$)+LEN(WorkText$) > EDMAXRECSZ% then
            'record will be too long
            ErrorMsg(MM.HRES\2,edH\2,55,GetStr(231),GetStr(232))
            ProcIn_ED=5                               'redisplay screen
            
          else
            'ok to merge records and delete the second
            DeleteRecord(edCurrIdx)                   'delete the current record
            edRec$=WorkText$+edRec$                   'combine the 2 record texts
            edCurrIdx=Work                            'set previous record as current record now
            SaveModifiedRecord()                      'save the merged record data (resets RecMod flag).
            edCuRow=edCuRow-1                         'decrement current cursor row 
            edCuCol=Len(WorkText$)                    'set cursor column to end of data on previous line
            
            if edCuRow < 0 then                       'moved past top row of screen - need to scroll up
              RowCnt=MAX(edMaxLines-edStrtRec,0)
              edCuRow=edMaxLines-(RowCnt+2)           'set Cursor Row 1 line above current screen top
              GetScrollUpStart(edStrtRec,edStrtIdx,edMaxLines-1)
            endif
            
            edHLRow=-1                                'clear Find HiLite trigger
            ProcIn_ED=10                              'redisplay screen & reset Find Start pos
          endif
          
          Exit Function
        endif
          
        ProcIn_ED=BackSpace(edRec$,TxtLen,TxtPtr,edCuCol)
        
        If ProcIn_ED > 0 then
          edRecMod=1                                  'set the Record Modified flag
          edTargCuCol=-1                              'clear Target Cursor pos
          edHLRow=-1                                  'clear Find HiLite trigger
          ProcIn_ED=8                                 'update Text & reset Find Start position
          
          If edCuCol=0 AND edStartPos > 1 then        'need to scroll screen to the left
            edStartPos=edStartPos-edHScrlInc
            edCuCol=edCuCol+edHScrlInc
            ProcIn_ED=10                              'redisplay screen & reset Find Start pos
          Endif
        endif
        
      Case 13                                         'ENTER key - Insert new record
        InsertNewRecord(TxtLen,TxtPtr)                'insert new record after current record
        edStartPos=1                                  'set default start pos                  
        edCuRow=edCuRow+1                             'move cursor to new current row
        edCuCol=0                                     'set cursor to start of the inserted line
        edHLRow=-1                                    'clear Find HiLite trigger
        
        If edCuCol >= edMaxTxt then                   'need to scroll whole screen to the right
          edStartPos=edStartPos+edHScrlInc
          edCuCol=edCuCol-edHScrlInc
        endif
        
        if edCuRow >= edMaxLines then                 'at bottom of current screen - need to scroll
          edStrtIdx=edEndIdx
          edStrtRec=edEndRec            
          edCuRow=1
        endif
        
        ProcIn_ED=10                                  'redisplay screen & reset Find Start pos
        
      Case 27                                         'ESCAPE key - Cancel / Return to Normal mode
        If edModFlg then
          MessageBox(MM.Hres\2,edY+edH\2,"Warning:",GetStr(223),GetStr(224),GetStr(225),0,FCwh,BCblu)
          
          If WaitForKeys(13,27)=27 then               ''Esc' pressed - cancel the exit
            ProcIn_ED=5                               'redisplay screen to clear MsgBox
            exit Function
          Endif
        endif                                         ''Enter' pressed - continue to exit
          
        ExitEditor()                                  'handle exit from Editor mode
        ProcIn_ED=2                                   'return to the Normal mode screen (& disable ConsRxlock)
        
      Case 127                                        'DEL (Delete) key
        If TxtPtr > TxtLen Then
          'special case on Edit screen - Delete from End of Line position 
          'causes text on the next line to be appended to the existing
          'text on this line and the next line is deleted.
          
          If edRecMod then                            'current edRec$ content is modified but unsaved so
            SaveModifiedRecord()                      'save it before proceeding (resets RecMod flag).
          endif
          
          'get the text (if any) on the line immediately following the one
          '(skipping any deleted record(s) inbetween)
          Work=GetRecTrakPtr(edCurrIdx,1,0)           'GetRecTrakPtr skips deleted records
          WorkText$=GetRec(Work,edState)  
          
          'check total length of text in both records
          If LEN(edRec$)+LEN(WorkText$) > EDMAXRECSZ% then
            'record will be too long
            ErrorMsg(MM.HRES\2,edH\2,55,GetStr(233),GetStr(232))
            ProcIn_ED=5                               'redisplay screen
            
          else
            'ok to combine records and delete the second
            DeleteRecord(Work)                        'Delete the next record
            edRec$=edRec$+WorkText$                   'combine the 2 record texts
            SaveModifiedRecord()                      'save the merged record data (resets RecMod flag).
            edHLRow=-1                                'clear Find HiLite trigger
            ProcIn_ED=10                              'redisplay screen & reset Find Start pos
          endif
          
          Exit Function
        endif
        
        ProcIn_ED=DeleteChar(edRec$,TxtLen,TxtPtr)
        
        If ProcIn_ED > 0 then
          edRecMod=1                                  'set the Record Modified flag
          edTargCuCol=-1                              'clear Target Cursor pos
          edHLRow=-1                                  'clear Find HiLite trigger
          ProcIn_ED=8                                 'update Text & reset Find Start position
        endif
        
      Case 128                                        'UP Arrow key
        If edTargCuCol=-1 then
          edTargCuCol=edCuCol                         'set the Target Cursor Column
        endif
        
        If edCuRow > 0 then
          'move the cursor up one line if not already at top of screen
          If NOT MoveCursor_UpDown(1) Then            'move Up 1 line
            'attempt to pass start of file - move not valid
            Beep()
            exit Function
          endif
          
          ClrPrevHiLite()                             'clear any previous HiLite
          edHLRow=-1                                  'clear Find HiLite trigger
          ProcIn_ED=9                                 'move cursor & reset Find Start position
          
        else          
          'at top of screen, need to scroll up to next screen
          'unless already at start of the file
          If edStrtRec > 1 then
            RowCnt=MAX(edMaxLines-edStrtRec,0)
            edCuRow=edMaxLines-(RowCnt+2)             'set Cursor Row 1 line above current screen top
            edHLRow=-1                                'clear Find HiLite trigger
            GetScrollUpStart(edStrtRec,edStrtIdx,edMaxLines-1)
            ProcIn_ED=10                              'redisplay screen & reset Find Start pos
            
          else 
            'can't move past the start of file
            Beep()
          endif
        ENDIF  
        
      Case 129                                        'DOWN Arrow key
        If edTargCuCol=-1 then
          edTargCuCol=edCuCol                         'set the Target Cursor Column
        endif
        
        If edCuRow < edMaxLines-1 then
          'move the cursor down one line if not already at bottom of screen
          If NOT MoveCursor_UpDown(0) then            'move Down
            'attempt to pass end of file - move not valid
            Beep()
            exit Function
          endif
          
          ClrPrevHiLite()                             'clear any previous HiLite
          edHLRow=-1                                  'clear Find HiLite trigger
          ProcIn_ED=9                                 'move cursor & reset Find Start pos
          
        else
          'at bottom of this screen, need to scroll down to next screen
          'unless already at end of the file
          If edEndRec < edRecCount then
            edStrtIdx=edEndIdx
            edStrtRec=edEndRec            
            edCuRow=1
            edHLRow=-1                                'clear Find HiLite trigger
            ProcIn_ED=10                              'redisplay screen & reset Find Start pos
            
          Else
            'can't move past the end of file
            Beep()
          ENDIF
        ENDIF 
        
      case 130                                        '<- (Left Arrow) key
        edTargCuCol=-1                                'clear Target Cursor pos
        ProcIn_ED=MoveCuLeft(edCuCol,edPrevCuCol,edStartPos,edHScrlInc)
        
        If ProcIn_ED=3 then                           'scroll screen needed
          ProcIn_ED=10                                'redisplay screen & reset Find Start pos
        endif
        
      case 131                                        '-> (Right Arrow) key
        edTargCuCol=-1                                'clear Target Cursor pos
        ProcIn_ED=MoveCuRight(edCuCol,edPrevCuCol,edStartPos,edHScrlInc,TxtLen,edMaxTxt)
        
        If ProcIn_ED=3 then                           'scroll screen needed
          ProcIn_ED=10                                'redisplay screen & reset Find Start pos
        endif
        
      Case 132                                        'INSERT key
        'toggle Insert Mode
        InsertMode=NOT InsertMode                     'toggle Mode
        edPrevCuCol=edCuCol
        UpdEditSBPanel(2,"")
'        'Note:  we update the text here so as to clear the current cursor since
'        '-----  we wouldn't be able to clear it after changing the Insert Mode!
        ProcIn_ED=3                                   'update text & re-draw cursor (in new Mode)
        
      Case 134                                        'HOME key
        edStartPos=1
        edCuCol=0
        edTargCuCol=-1                                'clear Target Cursor pos
        
        If edStartPos=edPrevStartPos then             'no scrolling reqd 
          ProcIn_ED=8                                 'update text line/cursor posn & reset Find Start pos
        else                                          'scrolling reqd
          ProcIn_ED=10                                'redisplay screen & reset Find Start pos
        endif
        
      Case 135                                        'END key
        edTargCuCol=-1                                'clear Target Cursor pos
        
        If edStartPos=1 then
          if LEN(edRec$) > edMaxTxt then              'need to scroll right to reach end
            edStartPos=edHScrlInc+1                   'set new start pos
          endif
          
        else  'edStartPos=edHScrlInc+1                'already scrolled
          If LEN(edRec$) <= edMaxTxt then             'need to scroll back to the left
            edStartPos=1
          endif
        endif
        
        edCuCol=(Len(edRec$)-edStartPos)+1            'calc new cursor pos 
        
        If edStartPos=edPrevStartPos then             'no scrolling reqd 
          ProcIn_ED=8                                 'update text line/cursor posn & reset Find Start pos
        else                                          'scrolling reqd
          ProcIn_ED=10                                'redisplay screen & reset Find Start pos
        endif
        
      Case 136                                        'PGUP (Page Up) key
        'page up to next screen unless already at start of the file
        If edStrtRec > 1 then
          If edTargCuCol=-1 then
            edTargCuCol=edCuCol                       'set the Target Cursor Column
          endif
          
          edHLRow=-1                                  'clear Find HiLite trigger
          GetScrollUpStart(edStrtRec,edStrtIdx,edMaxLines-1)
          ProcIn_ED=10                                'redisplay screen & reset Find Start pos
          
        else 
          'can't move past the start of file
          Beep()
        endif
        
      Case 137                                        'PGDN (Page Down) key
        'page down to next screen unless already at end of the file
        If edEndRec < edRecCount then
          If edTargCuCol=-1 then
            edTargCuCol=edCuCol                       'set the Target Cu Column
          endif
          
          edStrtIdx=edEndIdx
          edStrtRec=edEndRec
          'make sure the cursor isn't past the last displayed line
          edCuRow=MIN(edRecCount-edStrtRec,edCuRow)
          edHLRow=-1                                  'clear Find HiLite trigger
          ProcIn_ED=10                                'redisplay screen & reset Find Start pos
          
        Else
          'can't move past the end of file
          Beep()
        ENDIF
        
      Case 145                                        'F1 key - Display from start of file
        edTargCuCol=-1                                'clear Target Cursor Column
        edHLRow=-1                                    'clear Find HiLite trigger
        edStartPos=1                                  'start scrolled to the left
        edStrtIdx=edStart
        edStrtRec=1
        edCuRow=0
        edCuCol=0
        ProcIn_ED=10                                  'redisplay screen & reset Find Start pos
        
      Case 146                                        'F2 key - Display from end of file
        If edRecCount < edMaxLines then
          edCuRow=edRecCount-1
        Else
          edCuRow=edMaxLines-1
        endif
        
        edTargCuCol=-1                                'clear Target Cursor Column
        edCuCol=0        
        edHLRow=-1                                    'clear Find HiLite trigger
        edStartPos=1                                  'start scrolled to the left
        GetScrollUpStart(edRecCount,edEnd,edMaxLines-1)
        ProcIn_ED=10                                  'redisplay screen & reset Find Start pos
        
      Case 147                                        'F3 key - clear current line (but not delete)
        edRec$=""
        edRecMod=1                                    'set the Record Modified flag
        edCuCol=0
        edStartPos=1
        edHLRow=-1                                    'clear Find HiLite trigger
        
        If edStartPos=edPrevStartPos then             'no Horizontal Scroll
          ProcIn_ED=8                                 'update line (& cursor posn) & reset Find Start pos
        else  'edStartPos<>edPrevStartPos             'Horizontal Scroll reqd
          ProcIn_ED=10                                'redisplay screen (scrolled) & reset Find Start pos
        endif
        
      Case 149                                        'F5 key - delete line (and any data on it)
        Work=GetRecTrakPtr(edCurrIdx,1,0)             'get Index to next record (skip deleted ones)
        Work1=GetRecTrakPtr(edCurrIdx,1,1)            'get Index to previous record (skip deleted ones)
        DeleteRecord(edCurrIdx)                       'delete the record
        
        If Work=0 then                                'deleting final record in the file
          edCurrIdx=Work1                             'set CurrIdx = previous record (skip deleted ones)
          If edCuRow=0 or edCuRow=1 then              'top or 2nd top record on this screen - scroll up 1 screen
            edCuRow=edMaxLines-1                      'cursor on bottom line of scrolled screen  
            GetScrollUpStart(edRecCount,edEnd,edMaxLines-1)
          else
            edCuRow=MAX(edCuRow-1,0)                  'move cursor up one row
          endif
          
        Elseif Work1=0 then                           'deleting first record in the file
          edStrtIdx=edStart                           'set StrtIdx = new first record
          edCurrIdx=edStart                           'likewise CurrIdx, no chg to cursor row
          
        ELSE
          edCurrIdx=Work                              'set CurrIdx = Fwd Link, no chg to cursor row
        endif
          
        edTargCuCol=-1                                'clear Target Cursor Column
        edHLRow=-1                                    'clear Find HiLite trigger
        edCuCol=0
        edStartPos=1
        edModFlg=1                                    'set File Modified Flag
        UpdEditSBPanel(1,edFN$ + "*")                 'show file as modified  
        ProcIn_ED=10                                  'redisplay screen (scrolled) & reset Find Start pos
         
      Case 151                                        'F7 key - save as
        'exiting this mode - Note the Mode switch:
        Mode=70                                       'switch to Get Save As File Name Mode 
        ProcIn_ED=1                                   'go to GetSaveAsName()
       
      Case 152                                        'F8 key - save
        edSaveFN$=edFN$                               'Save File Name - same as original file
        SaveEditedFile(1)                             'save the file - using 'Save' mode
        ExitEditor()                                  'handle exit from editor mode
        ProcIn_ED=7                                   'return to the Normal mode screen
        '                                             'with 'Edited File Saved' notification in SB panel
        
      Case 154                                        'F10 key - Find
        edFndTarg$=""                                 'clear any existing Find/Replace strings
        edReplVal$=""
        'exiting this mode - Note the Mode switch:
        Mode=85                                       'switch to Editor Find/Replace Params mode
        ProcIn_ED=1                                   'display the DispFindReplParams screen
        
      Case 155                                        'F11 key - Find Next  
        If LEN(edFndTarg$) > 0 then                   'some Find Target text entered
          ProcIn_ED=DoFindNext()                      'do the Find Next and figure out the results 
          
        else
          Beep()                                      'no Find Target text - can't Find Next
        endif
        
      case 156                                        'F12 key - Replace Find Target text
        if Len(edReplVal$) > 0 AND edHLRow >= 0 then  'have both Replace text and a current Find Target
          'check that final length will not exceed max rec len
          If Len(edRec$)-Len(edFndTarg$)+Len(edReplVal$) > EDMAXRECSZ% then
            Beep()
            ErrorMsg(MM.Hres\2,edY+edH\2,0,GetStr(220),GetStr(221))
            ProcIn_ED=5
            
          Else
            'replace the Find Target text by the Replace With text
            edRec$=Left$(edRec$,edHLPos-1)+edReplVal$+Mid$(edRec$,edHLPos+Len(edFndTarg$))
            SaveModifiedRecord()                      'save the modified text (resets RecMod flag)
            edHLRow=-1                                'clear Find HiLite trigger
            'NOTE: setting edHLRow=-1 also prevents a second F12 (replace) for the same target.
            ProcIn_ED=3                               'update the current Edit Line (may change below)
            
            'make sure the replaced text is in the visible part of the screen - scroll if reqd
            If edHLPos<edStartPos then
              edStartPos=1                            'scroll to the left
              ProcIn_ED=5                             'refresh screen
              
            ElseIf edHLPos>edMaxTxt AND edStartPos<(edHScrlInc+1) then
              edStartPos=edHScrlInc+1                 'scroll to the right
              ProcIn_ED=5                             'refresh screen
            endif
            
            edTargCuCol=-1                            'reset Target Cursor Column
            edCuCol=edHLPos-edStartPos                'cursor to start of replaced text
          endif
          
        else
          Beep()
        endif
        
     Case else
        Beep()                                        'all other keys are invalid here
    End Select
    
  End Function

  '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  '  G E T S A V E A S F I L E N A M E    M O D E    -    P R O C E S S I N P U T  ~
  '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  Function ProcIn_SAF()                               'for the Get Save As File Name function
    'determine which key was pressed and action accordingly
    local TxtLen,DupFileAction
      
    ProcIn_SAF=0                                      'default - no action reqd
    TxtLen=Len(inp_Txt$)
    
    'using ProcIn_ScrollTxt to handle standard text input in a scrollable field and related actions.  
    'Use the following SELECT CASE to handle specific actions for 'Enter', 'Esc' 
    'and any Function keys (except 'F3' - clear input). 
    'Also include filtering any non-allowed text characters from the input text. 
    Select Case In_Char_Val       
      Case 34, 37, 42, 47, 58, 60, 62, 63, 92, 124
        'printable characters that are NOT valid in a File Name - reject
        Beep()
        
      case 13                                         'ENTER key - Proceed
        If TxtLen=0 then                              'file name must be specified
          ShowFileError(GetStr(11),"",0)
          ProcIn_SAF=2                                'refresh GetSaveAsName() box to clear Err Msg box
          
        Else
          'check if the specified file name includes the .BAS suffix
          'add it if required
          If UCASE$(Right$(inp_Txt$,4)) <> ".BAS" then
            If TxTLen > 123 then                      'not enough room to attach the .LOG suffix 
              ShowFileError(GetStr(12),GetStr(13),0)
              ProcIn_SAF=2                            'refresh GetSaveAsName() box to clear Err Msg box
              Exit Function
            Endif
            
            inp_Txt$=inp_Txt$ + ".bas"                'attach file name suffix
          endif
          
          if FileExists(inp_Txt$) then
            'a program file exists with the specified name -
            'need to find out whether to :-
            ' 1. replace the existing file with the new one         (DupFileAction = 2)
            ' 2. cancel out to allow a new file name to be entered  (DupFileAction = -1)
            DupFileAction=ShowDupFNOpts()
            
            If DupFileAction=-1 then                  'cancel to return to prev screen
              ProcIn_SAF=2                            'refresh GetSaveAsName() box to clear Dup Filename box
              Exit Function
              
            ElseIf DupFileAction=2 then               'delete existing file
              KILL inp_Txt$                           'delete file
            EndIf
          endif
          
          edSaveFN$=inp_Txt$                          'Save As File Name
          SaveEditedFile(0)                           'save the file - using 'Save As' mode
          ExitEditor()                
          ProcIn_SAF=7                                'return to the Normal mode screen
        endif                                         '     with 'Edited File Saved' notification in SB panel
        
      Case 27                                         'ESCAPE key - Cancel
        'exiting this mode - Note the Mode switch:
        Mode=65                                       'switch back to Program Edit mode
        ProcIn_SAF=5                                  'refresh the Program Edit screen
        
     Case else
        'all other values are potentially processed (or rejected) by the ScrollText handler
        ProcIn_SAF=ProcIn_ScrollTxt(inp_Txt$,inpMaxLen,inpStartPos,inpHScrlInc,inpMaxChars,inpCuPos,inpPrevCuPos)
    End Select
    
  end Function

  '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  '  C R U N C H P R O G F I L E    M O D E    -    P R O C E S S I N P U T      ~ 
  '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  Function ProcIn_CPF()                               'for the Crunch Prog File function
    'determine which key was pressed and action accordingly
    
    ProcIn_CPF=0                                      'default - no action reqd
    
    'only two (2) keys are valid: 
    '   - the 'Enter' key to proceed with the Program File Crunch process
    '         on the already selected program File,
    '         or to switch back to Normal Mode after crunch completion.
    'OR
    '   - the 'Esc' key to exit the Program File Crunch process and 
    '         return to Normal Mode.
    
    Select Case In_Char_Val       
      case 13                                         'ENTER key - Proceed
        If cpfDone then
          cpfDone=0                                   'reset Done flag (for next time)
          'exiting this mode - Note the Mode switch:
          Mode=0                                      'switch back to Normal Mode
          DrawScreen_Normal(0)                        're-draw the Normal Mode screen layout 
          ProcIn_CPF=2                                'return to the Normal mode screen (& disable ConsRxLock)
          
        else        
          ProcIn_CPF=3                                'Crunch the File
        endif
        
      Case 27                                         'ESCAPE key - Cancel
        'exiting this mode - Note the Mode switch:
        Mode=0                                        'switch back to Normal Mode
        DrawScreen_Normal(0)                          're-draw the Normal Mode screen layout 
        ProcIn_CPF=2                                  'return to the Normal mode screen
        
      Case else
        'all other values are invalid
        Beep()
        
    End Select
    
  end Function

  '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  
  '  F I N D / R E P L A C E P A R A M S    M O D E    -    P R O C E S S I N P U T    ~
  '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  Function ProcIn_FND()                               'for the Find/Replace function
    'determine which key was pressed and action accordingly
    Local r
    
    ProcIn_FND=0                                      'default - no action reqd
    
    'using ProcIn_StdTxt to handle standard text input in a non-scrollable field and related actions.  
    'Use the following SELECT CASE to handle specific actions for 'Enter', 'Esc' and 'Tab' 
    Select Case In_Char_Val 
      Case 9                                          'TAB key - toggle input fields
        'save some values for the field changing from Active to Inactive
        if edFndReplFlg=0 then                        'Find Target is active
          edFndTarg$=inp_Txt$                         'save current Find Target text
          edFndCuPos=inpCuPos
          edFndPrevCuPos=inpPrevCuPos
          edFndReplFlg=1                              'flip flag
          
        Else                                          'Replace With is active
          edReplVal$=inp_Txt$                         'save current Replace With text
          edReplCuPos=inpCuPos
          edReplPrevCuPos=inpPrevCuPos
          edFndReplFlg=0                              'flip flag
        endif
        
        DispFindReplInputFlds()                       'refresh display of the Input Fields
        
      Case 27                                         'ESCAPE key - Cancel
        'clear the working text input field and any Find Target and/or Replace With values
        inp_Txt$=""           
        edFndTarg$=""
        edReplVal$=""
        edHLRow=-1                                    'reset the HiLite row - stop highlighting matched target text
        On Error Skip 1
        Erase edLnPtrs()                              'release memory used by the edLnPtrs() array
        On error clear
        'exiting this mode - Note the Mode switch:
        Mode=65                                       'switch back to Program Edit Mode
        ProcIn_FND=5                                  'refresh the DisplayEditLines screen
        
      case 155                                        'F11 key - Initiate Find
        if edFndReplFlg=0 then                        'Find Target is active
          edFndTarg$=inp_Txt$                         'save updated Find Target text
        Else
          edReplVal$=inp_Txt$                         'save updated Replace With text
        endif
        
        inp_Txt$=""
        
        If LEN(edFndTarg$) > 0 then                   'some Find Target text entered
          'save the starting position values to determine when all records have been scanned.
          fnd1st=1                                    'setup as Initial Find
          fndUseCurr=1                                'start from current cursor pos
          r=DoFindNext()                              'do the Find and ignore return value    
          'exiting this mode - Note the Mode switch:
          Mode=65                                     'switch to Program Edit Mode
          ProcIn_FND=5                                'refresh the DisplayEditLines screen
          
        else
          Beep()                                      'no Find Target text - can't initiate Find
        endif
        
     Case else
        'all other values are potentially processed (or rejected) by the StdText handler
        ProcIn_FND=ProcIn_StdTxt(inp_Txt$,inpMaxLen,inpCuPos,inpPrevCuPos)
    End Select
    
  end Function


  '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  '  N O R M A L    M O D E    -    P R O C E S S I N P U T      ~
  '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  Function ProcIn_Normal()
    'determine which key was pressed and action accordingly
    
    ProcIn_Normal=0                                   'default - ignore input, no update
    
    'using ProcIn_ScrollTxt to handle scrollable text input, related actions.  
    'Use the following SELECT CASE to handle specific actions for 'Enter', 'Esc' 
    'and any Function keys (except 'F3' - clear input). 
    'Also include filtering any non-allowed text characters from the input text. 
    Select Case In_Char_Val
      Case 13                                         'CR (Carriage Return) character 
        ProcIn_Normal=-1                              'CR entered
        
      Case 128                                        'UP ARROW key
        If opCanScroll then
          'scrolling is enabled
          UpdateOutputWindow(ScrollOutputWindow(0,3))
          
        Else
          'scrollimg not enabled at present
          Beep()
        endif
        
      Case 129                                        'DOWN ARROW key
        If opCanScroll then
          'scrolling is enabled
          UpdateOutputWindow(ScrollOutputWindow(1,3))
          
        Else
          'scrollimg not enabled at present
          Beep()
        endif
        
      Case 136                                        'PGUP (Page Up) key
        If opCanScroll then
          'scrolling is enabled
          UpdateOutputWindow(ScrollOutputWindow(0,opMaxLines-1))
          
        Else
          'scrollimg not enabled at present
          Beep()
        endif
        
      Case 137                                        'PGDN (Page Down) key
        If opCanScroll then
          'scrolling is enabled
          UpdateOutputWindow(ScrollOutputWindow(1,opMaxLines-1))
          
        Else
          'scrollimg not enabled at present
          Beep()
        endif
        
      Case 145                                        'F1 key
        'send Ctrl-C (^C) to the target MM
        ProcIn_Normal=-2                              'send ^C to target MM
        
      Case 146                                        'F2 key
        'set Date & Time in target MM
        ProcIn_Normal=-3                              'send Date & Time to target MM from the MM Console system
        
      case 148                                        'F4 key - reload previous command
        'reload the command pointed to by the Reload_CmdsPtr
        In_Cmd$=Save_Cmds$(Reload_CmdsPtr)
        'decrement the Reload_CmdsPtr to the previous command
        Reload_CmdsPtr=Reload_CmdsPtr-1
        'wrap pointer if needed
        If Reload_CmdsPtr < 0 then
          Reload_CmdsPtr=MAXSAVECMDS%-1
        endif 
        
        CmdCuPos=0
        CmdStartPos=1
        ProcIn_Normal=3                               'update Command input box (& cursor posn)
        
      Case 149                                        'F5 key - enable/disable console logging
        UpdConsRxLock(1)                              'enable Console Rx Lock while in this function
        
        If LogOpen then                               'logging is currently enabled
          MessageBox(MM.Hres\2,opY+opH\2,GetStr(234),GetStr(235),"    " + LOGDIR$ + "/" + LogFN$,GetStr(236),0,FCwh,BCblu)
          
          If WaitForKeys(13,27)=27 then               'ESC key - don't disable logging!
            'do nothing
          else
            'disable logging now
            LogConsMsg("",1)
            LogConsMsg(GetStr(27,Date$,Time$),1)
            Close #2                                    'close the logfile 
            LogOpen=0
            UpdSBPanel(6,"",1)
            UpdSBPanel(1,GetStr(69),1)
          endif
          ProcIn_Normal=2                             'refresh Normal Mode screen to clear Msg Box
          
        Else                                          'logging is currently disabled
          'start enable logging procedure
          If NOT SdCardPresent() then
            'SD card not accessible - report error
            ShowFileError(flErrMsg$,GetStr(4),0)
            ProcIn_Normal=2                           'refresh Normal Mode screen to clear Error Msg
            
          else
            'SD card is present - can enable logging
            'exiting this Mode - Note: Mode change here:
            Mode=20                                   'switch to Logging Setup mode
            ProcIn_Normal=1                           'this will cause a call to ShowLogFileEnable()
          endif
        endif
        
      case 150                                        'F6 key - Set/Reset Console Rx Lock
        UpdConsRxlock(NOT ConsRxLock)                 'Toggle Log setting  
        
      Case 151                                        'F7 key - View Log File
        UpdConsRxLock(1)                              'enable Console Rx Lock while in this function
        
        If NOT SdCardPresent() then
          'SD card not accessible - report error
          ShowFileError(flErrMsg$,GetStr(6),0)
          ProcIn_Normal=2                             'refresh Normal Mode screen to clear Error Msg
          
        else
          'SD card is present - can view log files
          'exiting this Mode - Note: Mode change here:
          Mode=25                                     'switch to Select Log Mode
          ProcIn_Normal=1                             'display SelectLogFile screen
        endif
        
      Case 152                                        'F8 key - Edit Program File
        UpdConsRxLock(1)                              'enable Console Rx Lock while in this function
        
        If NOT SdCardPresent() then
          'SD card not accessible - report error
          ShowFileError(flErrMsg$,GetStr(5,GetStr(138)),0)
          ProcIn_Normal=2                             'refresh Normal Mode screen to clear Error Msg
          
        else
          'SD card is present - can edit a program file
          'exiting this Mode - Note: Mode change here:
          Mode=60                                     'switch to Select Edit File Mode
          'Note: This function shares the SelectProgFile screen with Upload Program Mode (F10 - see below)
          ProcIn_Normal=1                             'display SelectProgFile screen
        endif
        
      case 153                                        'F9 key - Crunch Program File Mode
        UpdConsRxLock(1)                              'enable Console Rx Lock while in this function
        
        If NOT SdCardPresent() then
          'SD card not accessible - report error
          ShowFileError(flErrMsg$,GetStr(5,GetStr(136)),0)
          ProcIn_Normal=2                             'refresh Normal Mode screen to clear Error Msg
          
        else
          'SD card is present - can crunch a program file
          'exiting this Mode - Note: Mode change here:
          Mode=75                                     'switch to Select Crunch File Mode
          'Note: This function shares the SelectProgFile screen with Upload Program Mode (F10 - see below)
          ProcIn_Normal=1                             'display SelectProgFile screen
        endif
        
      Case 154                                        'F10 key - Upload Program File
        UpdConsRxLock(1)                              'enable Console Rx Lock while in this function
        
        If NOT SdCardPresent() then
          'SD card not accessible - report error
          ShowFileError(flErrMsg$,GetStr(5,GetStr(137)),0)
          ProcIn_Normal=2                             'refresh Normal Mode screen to clear Error Msg
          
        else
          'SD card is present - can upload a program file
          'exiting this Mode - Note: Mode change here:
          Mode=50                                     'switch to Select Program File Mode
          ProcIn_Normal=1                             'display SelectProgFile screen
        endif
        
      case 155                                        'F11 key - Settings Menu
        UpdConsRxLock(1)                              'enable Console Rx Lock while in this function
        
        'exiting this Mode - Note: Mode change here:
        Mode=5                                        'switch to Settings Mode
        ProcIn_Normal=1                               'display Settings Menu                 
        
      Case 156                                        'F12 key - Terminate program
        ProcIn_Normal=-99                             'EOJ requested 
        
      Case 179                                        'Shifted F3 key - clear Output Window
        ClearOutputWindow()
        
      Case else
        'all other values are potentially processed (or rejected) by the ScrollText handler
        ProcIn_Normal=ProcIn_ScrollTxt(In_Cmd$,255,CmdStartPos,CmdHScrlInc,CmdMaxChars,CmdCuPos,CmdPrevCuPos)
    end Select
    
  end Function
  
  '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  '  S T D T X T    ( N O N - S C R O L L I N G )    -    P R O C E S S I N P U T   ~
  '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

   Function ProcIn_StdTxt(spTxt$,ipMaxLen,ipCuPos,ipPrevCuPos)
    'determine which key was pressed and action accordingly
    'NOTE: Use this procedure for non-scrolling text fields.
    '=====
    Local TxtLen,TxtPtr           
    
    ProcIn_StdTxt=0                                   'default - no action reqd
    
    TxtLen=Len(spTxt$)
    TxtPtr=ipCuPos+1    
    
    Select Case In_Char_Val
      Case 32 to 126                                  'printable characters
        ProcIn_StdTxt=AddText(spTxt$,TxtLen,TxtPtr,ipMaxlen,ipCuPos)
        
      Case 8                                          'BS (BackSpace) character
      ProcIn_StdTxt=BackSpace(spTxt$,TxtLen,TxtPtr,ipCuPos)
        
      Case 127                                        'DEL (Delete) key
        ProcIn_StdTxt=DeleteChar(spTxt$,TxtLen,TxtPtr)
        
      case 130                                        '<- (Left Arrow) key (move cursor to the left)
        If ipCuPos > 0 then                           'not already at the start (leftmost) position
          ipPrevCuPos=ipCuPos
          ipCuPos=ipCuPos-1
          ProcIn_StdTxt=4                             'move cursor posn
        Else
          Beep()
        endif
        
      case 131                                        '-> (Right Arrow) key (move cursor to the right)
        If ipCuPos+1 <= TxtLen then                   'not at the end of the string
          ipPrevCuPos=ipCuPos
          ipCuPos=ipCuPos+1
          ProcIn_StdTxt=4                             'move cursor posn
        Else
          Beep()
        endif
        
      Case 132                                        'INSERT key
        'toggle Insert Mode
        InsertMode=NOT InsertMode                     'toggle Mode
        ipPrevCuPos=ipCuPos
        UpdSBPanel(2,"")
        ProcIn_StdTxt=3                               'update text & re-draw cursor (in new Mode)
        
      Case 134                                        'HOME key
        ipPrevCuPos=ipCuPos
        ipCuPos=0
        ProcIn_StdTxt=4                               'move cursor posn
        
      Case 135                                        'END key
        ipPrevCuPos=ipCuPos
        ipCuPos=TxtLen+1
        ProcIn_StdTxt=2                               'action completed, update display
        
      Case 147                                        'F3 key - clear New Baud Rate input text box
        'clear input text box
        spTxt$=""
        ipCuPos=0
        ProcIn_StdTxt=3                               'update text input box (& cursor posn)
        
      Case else                                       'key not supported / not valid in current context - ignore
        Beep()
    end Select
    
  end Function
  
  '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  '  S C R O L L T X T    ( S C R O L L A B L E )    -    P R O C E S S I N P U T   ~
  '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  
  Function ProcIn_ScrollTxt(spTxt$,ipMaxLen,ipStrtPos,ipScrlInc,ipMaxDispChrs,ipCuPos,ipPrevCuPos)
    'determine which key was pressed and action accordingly
    'NOTE: Use this procedure for SCROLLABLE text fields.
    '=====
    Local TxtLen, TxtPtr           
    
    ProcIn_ScrollTxt=0                                'default - ignore input, no update
    
    TxtLen=Len(spTxt$)
    TxtPtr=ipCuPos+ipStrtPos
    
    Select Case In_Char_Val
      Case 32 to 126                                  'printable character - add to string
        ProcIn_ScrollTxt=AddText(spTxt$,TxtLen,TxtPtr,ipMaxlen,ipCuPos)
        
        If ProcIn_ScrollTxt > 0 then
          If ipCuPos >= ipMaxDispChrs then            'need to scroll text in text input box
            ipStrtPos=ipStrtPos+ipScrlInc
            ipCuPos=ipCuPos-ipScrlInc
          Endif
        endif
        
      Case 8                                          'BS (BackSpace) character
        ProcIn_ScrollTxt=BackSpace(spTxt$,TxtLen,TxtPtr,ipCuPos)
        
        If ipCuPos=0 And ipStrtPos > 1 then           'need to scroll text
          If ipStrtPos < ipScrlInc then
            ipCuPos=ipStrtPos-1
            ipStrtPos=1
          Else
            ipStrtPos=ipStrtPos-ipScrlInc
            ipCuPos=ipCuPos+ipScrlInc
          endif
        Endif
        
      Case 127                                        'DEL (Delete) key
        ProcIn_ScrollTxt=DeleteChar(spTxt$,TxtLen,TxtPtr)
        
      case 130                                        '<- (Left Arrow) key
        ProcIn_ScrollTxt=MoveCuLeft(ipCuPos,ipPrevCuPos,ipStrtPos,ipScrlInc)
        
      case 131                                        '-> (Right Arrow) key
        ProcIn_ScrollTxt=MoveCuRight(ipCuPos,ipPrevCuPos,ipStrtPos,ipScrlInc,TxtLen,ipMaxDispChrs)
        
      Case 132                                        'INSERT key
        'toggle Insert Mode
        InsertMode=NOT InsertMode                     'toggle Mode
        ipPrevCuPos=ipCuPos
        UpdSBPanel(2,"")
        ProcIn_ScrollTxt=3                            'update text & re-draw cursor (in new Mode)
        
      Case 134                                        'HOME key
        ipStrtPos=1
        ipCuPos=0
        ProcIn_ScrollTxt=3                            'update text input box (& cursor posn)
        
      Case 135                                        'END key
        i=1
        ipStrtPos=1
        Do
          If TxtLen < ipStrtPos+ipMaxDispChrs then Exit Do
          ipStrtPos=(ipScrlInc*i)+1
          i=i+1
        Loop
        
        ipCuPos=(TxtLen-ipStrtPos)+1
        ProcIn_ScrollTxt=3                            'update text input box (& cursor posn)
        
      Case 147                                        'F3 key - clear Command input text box
        'clear command input text box
        spTxt$=""
        ipCuPos=0
        ipStrtPos=1
        ProcIn_ScrollTxt=3                            'update text input box (& cursor posn)
        
      Case else
        Beep()
    end Select
    
  end Function

  '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  '  S T D V I E W    -    P R O C E S S I N P U T   ~
  '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  
  Function ProcIn_StdView(ipLstStrt,ipNext,ipCount,ipHScrl,ipMaxHScrl)
    'determine which key was pressed and action accordingly
    'NOTE: Use this procedure with the View Log and View Search Results functions.
    '=====
 
    ProcIn_StdView=0                                  'default - no update required
   
    Select Case In_Char_Val      
      Case 128                                        'UP Arrow key
        'scroll the log data to display starting from the previous record to the current start.
        If ipLstStrt > 1 then
          'not at start of file - can scroll up 1
          ipLstStrt=ipLstStrt-1                       'decrement Last Start Rec Nbr
          ProcIn_StdView=2                            'refresh View screen to update display
          
        else
          'can't scroll past the start of the file
          Beep()
        ENDIF  
        
      Case 129                                        'DOWN Arrow key
        'scroll the log data to display starting from the next record to the current start.
        If ipLstStrt < ipCount then
          'not at end of file - can scroll down 1
          ipLstStrt=ipLstStrt+1                       'increment Last Start Rec Nbr
          ProcIn_StdView=2                            'refresh View screen to update display
          
        else
          'can't scroll past the end of the file
          Beep()
        ENDIF  
        
      case 130                                        '<- (Left Arrow) key
        'reduce horizontal scroll setting by 1 character
        If ipHScrl > 0 then
          ipHScrl=ipHScrl-1
          UpdVLSBPanel(2,STR$(ipHScrl))               'update Status Bar HScroll Panel
          ProcIn_StdView=2                            'refresh View Log screen to update display
          
        Else
          Beep()
        endif
        
      case 131                                        '-> (Right Arrow) key
        'increase horizontal scroll setting by 1 character
        If ipHScrl < ipMaxHScrl then
          ipHScrl=ipHScrl+1
          UpdVLSBPanel(2,STR$(ipHScrl))               'update Status Bar HScroll Panel
          ProcIn_StdView=2                            'refresh View Log screen to update display
          
        Else
          Beep()
        endif
        
      Case 134                                        'HOME key
        'set Horiz Scroll value to 0 (display from first char in log records)
        If ipHScrl <> 0 then
          ipHScrl=0
          UpdVLSBPanel(2,STR$(ipHScrl))               'update Status Bar HScroll Panel
          ProcIn_StdView=2                            'refresh View Log screen to update display
        endif
        
      Case 135                                        'END key
        'set Horiz Scroll value to maximum - allows right hand end of longest log record to be visible
        If ipHScrl <> ipMaxHScrl then
          ipHScrl=ipMaxHScrl
          UpdVLSBPanel(2,STR$(ipHScrl))               'update Status Bar HScroll Panel
          ProcIn_StdView=2                            'refresh View Log screen to update display
        endif
        
      Case 136                                        'PGUP key
        'scroll the log data to display starting one 
        'screen prior to the current start or from the start of the file.
        If ipLstStrt > 1 then
          'not at start of file - can scroll up
          ipLstStrt=Max((ipLstStrt-(opMaxLines-1)),1) 'limit scroll up to start of file
          ProcIn_StdView=2                            'refresh View Log screen to update display
          
        else
          'can't scroll past the start of the file
          Beep()
        ENDIF  
        
      Case 137                                        'PGDN key
        'scroll the log data to display starting one 
        'screen past the current start (unless at the end of the file).
        If ipNext < ipCount then
          'not at end of file - can scroll down
          if Mode=45 then
            ipLstStrt=ipNext
          else
            ipLstStrt=ipNext-1
          endif
          ProcIn_StdView=2                            'refresh View Log screen to update display
          
        else
          'can't scroll past the end of the file
          Beep()
        ENDIF  
        
     Case else
        Beep()
        
    End Select
    
  end Function
  
  Function AddText(spTxt$,ipTxtLen,ipTxtPtr,ipMaxLen,ipCuPos)
    'handles adding a character to a text field.
    'NOTE: This function works for BOTH Standard Text and Scrollable Text fields.
    '===== Scrollable Text fields require some additional code to manage whether
    '      scrolling is required or not and adjusting the line start and cursor 
    '      position variables. This extra code is handled within the Scrollable
    '      Text handlers.
    
    If InsertMode Then                                'insert the new character at the cursor position
      If ipTxtLen < ipMaxLen then                     'string not full, can insert
        If ipTxtPtr > ipTxtLen then
          'add new character to the end of the string
          spTxt$=spTxt$ + In_Char$
          
        Else
          'insert new character at the cursor position
          spTxt$=Left$(spTxt$,ipTxtPtr-1) + In_Char$ + Mid$(spTxt$,ipTxtPtr)
        endif
        
        'increment cursor position
        ipCuPos=ipCuPos+1
        AddText=3                                     'update text input box
         
      else                                            'string is already full, CANNOT insert
        Beep()
        AddText=0                                     'key ignored, invalid
      endif
      
    Else                                              'overwrite (replace) mode
      If ipTxtPtr < ipMaxLen+1 then                   'cursor is not past max length of the string
        If ipTxtPtr > ipTxtLen then
          'add new character to the end of the string
          spTxt$=spTxt$ + In_Char$
        Else
          'replace character at the cursor position
          If ipTxtPtr=255 Then
            'special case when replacing the last char in a max size (255 char) string
            spTxt$=Left$(spTxt$,ipTxtPtr-1) + In_Char$
          else
            spTxt$=Left$(spTxt$,ipTxtPtr-1) + In_Char$ + Mid$(spTxt$,ipTxtPtr+1)
          EndIf
        endif
        
        'increment cursor position
        ipCuPos=ipCuPos+1
        AddText=3                                     'update text input box
         
      else                                            'string is already full, CANNOT insert
        Beep()
        AddText=0                                     'key ignored, invalid
      endif
    EndIf

  end function
  
  Function BackSpace(spTxt$,ipTxtLen,ipTxtPtr,ipCuPos)
    'handles the BackSpace function - deletes the character preceeding the cursor position
    'NOTE: This function works for BOTH Standard Text and Scrollable Text fields.
    '===== Scrollable Text fields require some additional code to manage whether
    '      scrolling is required or not and adjusting the line start and cursor 
    '      position variables. This extra code is handled within the Scrollable
    '      Text handlers.
    
    If ipTxtLen > 0 And ipTxtPtr > 1 then             'can't backspace if string is empty or cursor is at the start
      If ipTxtPtr <= ipTxtLen then
        spTxt$=LEFT$(spTxt$,ipTxtPtr-2) + Mid$(spTxt$,ipTxtPtr)
        
      ElseIf ipTxtPtr > ipTxtLen Then
        'deleting the last character in the string
        spTxt$=LEFT$(spTxt$,ipTxtPtr-2)
      ENDIF
      
      ipCuPos=ipCuPos-1
      
      BackSpace=3                                     'update text input box
      
    Else                                              'ignore BS key at present
      Beep()
      BackSpace=0                                     'nothing happened
    endif
    
  end function
  
  Function DeleteChar(spTxt$,ipTxtLen,ipTxtPtr)
    'handles the Delete Character function - 'delete the character at the cursor position
    'NOTE: This function works for BOTH Standard Text and Scrollable Text fields.
    '=====
    DeleteChar=3                                      'update text input box
    
    If ipTxtPtr < ipTxtLen then                       'delete the character at the cursor position
      spTxt$=LEFT$(spTxt$,ipTxtPtr-1) + Mid$(spTxt$,ipTxtPtr+1)
      
    ElseIf ipTxtPtr=ipTxtLen Then                     'deleting the last character in the string
      spTxt$=LEFT$(spTxt$,ipTxtPtr-1)
      
    Else                                              'attempt to delete beyond the end of the string
      Beep()
      DeleteChar=0                                    'nothing happened
    endif
    
  end function
  
  Function MoveCuLeft(ipCuPos,ipPrevCuPos,ipStrtPos,ipScrlInc)
    'handles moving the cursor left and taking care of 
    'scrolling the text/screen if necessary
    'NOTE: This function works ONLY with Scrollable Text fields.
    '===== 
    MoveCuLeft=0                                      'default - nothing happened
    
    If ipCuPos > 0 then
      ipPrevCuPos=ipCuPos
      ipCuPos=ipCuPos-1
      MoveCuLeft=4                                    'move cursor
      
    elseif ipCuPos=0 then
      If ipStrtPos > 1 then                           'need to scroll text
        ipStrtPos=ipStrtPos-ipScrlInc
        ipCuPos=(ipCuPos+ipScrlInc)-1
        MoveCuLeft=3                                  'update text (& cursor posn)
      Else
        
        Beep()
      endif            
      
    Else
      Beep()
    endif
    
  End function
  
  Function MoveCuRight(ipCuPos,ipPrevCuPos,ipStrtPos,ipScrlInc,ipTxtLen,ipMaxDispChrs)
    'handles moving the cursor right and taking care of
    'scrolling the text/screen if necessary
    'NOTE: This function works ONLY with Scrollable Text fields.
    '===== 
    MoveCuRight=0                                     'default - nothing happened    
    
    If (ipCuPos+ipStrtPos) <= ipTxtLen then
      ipPrevCuPos=ipCuPos                             'save cursor pos to previous cursor pos
      
      If (ipCuPos+1) < ipMaxDispChrs then
        ipCuPos=ipCuPos+1
        MoveCuRight=4                                 'move cursor
        
      ElseIf (ipCuPos+1=ipMaxDispChrs) And (ipCuPos+ipStrtPos=ipTxtLen) Then
        ipCuPos=ipCuPos+1
        MoveCuRight=4                                 'move cursor
        
      Else
        ipStrtPos=ipStrtPos+ipScrlInc
        ipCuPos=(ipCuPos-ipScrlInc)+1
        MoveCuRight=3                                 'update text (& cursor posn)
      endif 
      
    Else
      Beep()
    endif
    
  end Function
  
  '===========================================================================================
  '     N O R M A L    M O D E    F U N C T I O N S    &    S U B R O U T I N E S
  '===========================================================================================
  
  Sub DrawScreen_Normal(ipInitial)
    'draws the screen layout used for Normal mode
    
    cls BCblu                                         'ensure screen is clear
    
    'display the screen caption
    TEXT mm.HRES\2,0,GetStr(246,ProgVer$),CT,2,1,FCwh,BCblu
    
    DrawStatusBar()
    
    'draw and initialize the Status Bar text panels (except Date & Time - already done)
    UpdSBPanel(1,"",0)                                'clear Notification Panel
    UpdSBPanel(2,"",0)
    UpdSBPanel(3,"1",0)
    UpdSBPanel(4,"0",0)
    UpdSBPanel(5,"",0)
    UpdSBPanel(6,"",0)
    UpdSBPanel(7,"",0)
    
    'set size and position of Command Text input box and draw text box
    cbY=24                                            'Command Text input box top  
    cbH=fH_In+5                                       'Command Text input box height
    Box 5,cbY,(MM.HRes-10),cbH,1,,BCgry               'draw the Command Text input box
    
    'set size, position and other parameters for the Console Output window
    opY=(cbY+cbH)+5                                   'Console Output window top
    opH=(sbY-opY)-5                                   'Console Output window height
    opMaxLines=opH\(fH_Out+2)                         'Output font height + 2 pixels per line in the Output window
    opMaxChars=(mm.HRes-20)\fW_Out
    
    'draw the Console Output window
    Box 5,opY,(MM.HRes-10),opH,1,,BCOut% 
    
    If ipInitial then       
      opInPtr=0
      opDispPtr=0 
      opCanScroll=0
    endif
   
  end sub
  
  sub ClrSpec()
    'to be sure the small blue strip between the Command input box 
    'and the Output Window is cleared
    
    Box 5,45,790,5,0,0,BCblu          
  
  end sub
  
  sub UpdateText_Cmd()
    'updates the display of the command text field anytime the text content is changed
    
    'clear input display field
    Box 5,cbY,(MM.HRes-10),cbH,1,,BCgry               'includes clearing the previous cursor
    'display updated contents
    Text 10,cbY+3,Mid$(In_Cmd$,CmdStartPos,CmdMaxChars),LT,Fnt_In,1,FCwh,BCgry
    UpdSBPanel(4,STR$(Len(In_Cmd$)),0)
    
    'update the cursor display
    CmdPrevCuPos=-1                                   'previous cursor already cleared
    MoveCursor_Cmd()
    
  End Sub

  Sub MoveCursor_Cmd()
    'move the cursor to a new position, optionally clearing the previous cursor
    
    If InsertMode Then                                'insert mode cursor = vertical bar
      If CmdPrevCuPos > -1 then
        'clear the previous cursor
        Line (CmdPrevCuPos*fW_In)+9,cbY+1,(CmdPrevCuPos*fW_In)+9,(cbY+cbH)-2,2,BCgry 
      endif   
      'draw the new cursor
      Line (CmdCuPos*fW_In)+9,cbY+1,(CmdCuPos*fW_In)+9,(cbY+cbH)-2,2,cuFC
      
    Else                                              'overwrite mode cursor = underline
      If CmdPrevCuPos > -1 then
        'clear the previous cursor
        Line (CmdPrevCuPos*fW_In)+10,(cbY+cbH)-3,((CmdPrevCuPos+1)*fW_In)+10,(cbY+cbH)-3,2,BCgry
      endif
      'draw the new cursor
      Line (CmdCuPos*fW_In)+10,(cbY+cbH)-3,((CmdCuPos+1)*fW_In)+10,(cbY+cbH)-3,2,cuFC
    endif
    
    UpdSBPanel(3,Str$(CmdStartPos+CmdCuPos),0)
    
  End sub
  
  Sub HideCursor_Cmd()
    'hide the Command Cursor (used while in Settings Mode)
     
    If InsertMode Then                                'insert mode cursor = vertical bar
      'clear the cursor
      Line (CmdCuPos*fW_In)+9,cbY+1,(CmdCuPos*fW_In)+9,(cbY+cbH)-2,2,BCgry 
      
    Else                                              'overwrite mode cursor = underline
        'clear the cursor
      Line (CmdCuPos*fW_In)+10,(cbY+cbH)-3,((CmdCuPos+1)*fW_In)+10,(cbY+cbH)-3,2,BCgry
    endif
    
  End sub
  
  sub UpdSBPanel(ipWhich,spCaption$,ipFlag)
    'draw/clear the specified panel, and update the caption displayed in it
    '
    'Status Bar Panel Parameters
    '=============================
    ' sbp1X |   5 | sbp5X | 351 |
    '-------+-----|-------+-----|
    ' sbp1W | 174 | sbp5W |  64 |
    '-------+-----|-------+-----|
    ' sbp1C |   - | sbp5C | 383 |
    '-------+-----|-------+-----|
    ' sbp2X | 184 | sbp6X | 420 |
    '-------+-----|-------+-----|
    ' sbp2W |  72 | sbp6W |  72 |
    '-------+-----|-------+-----|
    ' sbp2C | 220 | sbp6C | 456 |
    '-------+-----|-------+-----|
    ' sbp3X | 261 | sbp7X | 497 |
    '-------+-----|-------+-----|
    ' sbp3W |  40 | sbp7W | 112 |
    '-------+-----|-------+-----|
    ' sbp3C | 281 | sbp7C |   - |
    '-------+-----|-------+-----|
    ' sbp4X | 306 |       |     |
    '-------+-----|-------+-----|
    ' sbp4W |  40 |       |     |
    '-------+-----|-------+-----|
    ' sbp4C | 326 |       |     |
    '----------------------------
    
    local AutoCaption$          
    
    Select case ipWhich
      Case 1                                          'Notification panel
        box 5,sbpY,174,sbpH,0,0,BC190                 'draw/re-draw empty panel
        Text 13,sbpTextY,spCaption$,LT,1,1,FCblk,BC190
        If ipFlag then
          Settick 15000,ResetNotify,3                 'initiate timer interrupt to clear Notification panel
        endif
        
      case 2                                          'Insert/Replace mode
        if InsertMode then
          AutoCaption$="Insert"
        Else
          AutoCaption$="Replace"
        Endif
        box 184,sbpY,72,sbpH,0,0,BC190
        Text 220,sbpTextY,AutoCaption$,CT,1,1,FCblk,BC190
        
      Case 3                                          'Current Cursor Position (in Cmd text)
        box 261,sbpY,40,sbpH,0,0,BC190
        Text 281,sbpTextY,spCaption$,CT,1,1,FCblk,BC190
       
      Case 4                                          'Current Command Text Length
        box 306,sbpY,40,sbpH,0,0,BC190
        Text 326,sbpTextY,spCaption$,CT,1,1,FCblk,BC190
        
      Case 5                                          'Current BaudRate
        box 351,sbpY,64,sbpH,0,0,BC190
        Text 383,sbpTextY,str$(comsBaudRate),CT,1,1,FCblk,BC190
        
      Case 6                                          'Logging Enabled/Disabled
        If LogOpen=1 then
          box 420,sbpY,72,sbpH,0,0,RGB(Green)
          Text 456,sbpTextY,"Log On",CT,1,1,FCblk,RGB(Green)
        Else
          box 420,sbpY,72,sbpH,0,0,RGB(Red)
          Text 456,sbpTextY,"Log Off",CT,1,1,FCwh,RGB(Red)
        endif
        
      Case 7                                          'Auto Scroll Lock panel
        If ConsRxLock=0 then
          ipFlag=0
          AutoCaption$="Rx Unlocked"
        Endif
        If ipFlag=1 then 
          'tanked bytes > 85% of capacity
          box 497,sbpY,112,sbpH,0,0,RGB(Red)          'draw/re-draw empty panel
          Text 505,sbpTextY,spCaption$,LT,1,1,FCwh, RGB(Red)
        Else
          box 497,sbpY,112,sbpH,0,0,BC190             'draw/re-draw empty panel
          If ipFlag=2 then                            'Rx Locked
            Text 505,sbpTextY,spCaption$,LT,1,1,RGB(Red),BC190
          Else                                        'Rx Unlocked
            Text 505,sbpTextY,AutoCaption$,LT,1,1,FCblk,BC190
          endif
        endif
    End Select
   
  End sub
  
  Sub ResetNotify()
    'clears the text from the Notification Panel on the Status Bar after 15 secs
    
    UpdSBPanel(1,"",0)                                'clear the notification text
    Settick 0,0,3                                     'disable the interrupt
   
  End sub
  
  Sub UpdConsRxlock(ipVal)
    'update the ConsRxLock flag
    'ipVal: should be either 0 or 1
    '       0 = ConsRxLock disabled
    '       1 = ConsRxLock enabled     

    ConsRxLock=ipval
    
    If Not ConsRxLock then
      UpdSBPanel(7,"",0)
    Else
      UpdSBPanel(7,"Rx Lock 0%",2)
    endif
    
  end sub
  
  Sub SaveLastCmd()
    'save the command just entered in the Save_Cmds$ array
   
    Save_Cmds$(Save_CmdsPtr)=In_Cmd$
    Reload_CmdsPtr=Save_CmdsPtr                       'set reload pointer to most recently saved entry
    Save_CmdsPtr=Save_CmdsPtr+1                       'increment pointer to next array slot
    If Save_CmdsPtr >= MAXSAVECMDS% Then
      'all slots used - wrap back to slot 0
      Save_CmdsPtr=0
    Endif
    
  End Sub
  
  '===========================================================================================
  '     O U T P U T    W I N D O W    F U N C T I O N S    &    S U B R O U T I N E S
  '===========================================================================================
  
  sub ProcessConsMsg()
    'add data in the ConsMsg$ buffer to the Output Windows Lines array
    'then update the display of the Output Window.
    local CR_Ptr,Upd_Flag=0
    
    STATIC Append_Flag            
    
    Do
      RemoveLF()                                      'remove LF if first char
      'look for a CR in the ConsRxMsg$ buffer
      CR_Ptr= Instr(ConsMsg$,Chr$(13))
      
      If CR_Ptr > 0 then                              'CR Found
        StoreConsMsg(Left$(ConsMsg$,(CR_Ptr - 1)),Append_Flag,1)
       
        'clear the part of the new message up to and including the CR
        ConsMsg$=Mid$(ConsMsg$,(CR_Ptr+1))
        'see if there is a &H0A (LF) following the CR, if so remove it.
        RemoveLF()
        opLine$(opInPtr)=""                           'clear next line ready for use
        Upd_Flag=1                                    'we did something
        
      else
        If Len(ConsMsg$) > 0 then  
          'we have some message text, but no CR yet
          StoreConsMsg(ConsMsg$,Append_Flag,0)
          ConsMsg$=""                                 'clear the Console Msg buffer    
          Upd_Flag=1                                  'we did something
        else
          Append_Flag=0
        endif
      endif 
    Loop until Len(ConsMsg$)=0
    
    If Upd_Flag then
      'need to update the Output Window display
      UpdateOutputWindow(opInPtr)
    endif
    
  end sub
  
  sub StoreConsMsg(spConsMsg$,ipAppend,ipCRFlag)
    'stores the specified ConsMsg string in the opLine$ array
    'splitting over multiple line(s) if required and/or appending 
    'to the previous line based on the Append and CRFlag settings.
    
    Local Work,WorkString$          
    
    'build the entire string to be stored (in WorkString$)
    If ipAppend then
      WorkString$=opLine$(opInPtr) + spConsMsg$       'append to previous text
    else
      WorkString$=spConsMsg$                          'new message line
    endif
    
    Work=Len(WorkString$)                             'length of string to be stored
    
    do
      If Work > opMaxChars then                       'string is longer than 1 line
        'split the string and add the continuation indicator ( ...) to the end
        opLine$(opInPtr)=LEFT$(WorkString$,(opMaxChars-4)) + " ..."
        
        if LogOpen Then                               'logging is on
          LogConsMsg(opLine$(opInPtr))                'write the line to the log file  
        endif
        
        'remove the portion of text just stored from WorkString$
        WorkString$=Mid$(WorkString$,(opMaxChars-3))
        'increment to the next entry in opLine$ array
        IncrInPtr()
        
      Else                                            'string will fit on 1 line
        opLine$(opInPtr)=WorkString$                  'store in array and
        WorkString$=""                                'clear WorkString$
      endif
      
      Work=Len(WorkString$)                           'length of string left to be stored
    Loop until Work=0 
      
    If ipCRFlag then
      'CR terminated this message, need to advance to next display line
      if LogOpen Then                                 'logging is on
        LogConsMsg(opLine$(opInPtr))                  'write the line to the log file  
      endif
        
      IncrInPtr ()
      'reset the Append flag
      ipAppend=0
      
    Else
      'don't increment to next display line, just set the Append flag
      ipAppend=1
    endif
    
    If NOT opCanScroll then
      If opInPtr > opMaxLines then
        opCanScroll=1                                 'enable scrolling in the Output Window
      endif
    endif
    
  end sub

  Sub IncrInPtr()
    'increment to the next entry in the opLine$ array
    
    opInPtr=opInPtr+1
    'check if wraparound is reqd
    If opInPtr=MAXENTRIES% then
      'wraparound back to 0
      opInPtr=0
      'set Wraparound flag
      opWrap=1
    endif
    
  end sub
  
  sub RemoveLF()
    'removes a LF character at the start of the msg buffer, if one exists
    
    If LEN(ConsMsg$) > 0 then
      'see if there is a &H0A (LF) as the first character, if so remove it.
      if Left$(ConsMsg$,1)=Chr$(10) then
        ConsMsg$=Mid$(ConsMsg$,2)
      endif
    Endif
    
  end sub
  
  Sub UpdateOutputWindow(ipEndArrayLinePtr)
    'update the Output Window display
    
    opDispPtr=(ipEndArrayLinePtr+1)-opMaxLines        'calc line index for top line of the display 
    If opDispPtr < 0 then
      if opWrap=0 then
        'less than opMaxLines lines received so far - can start at index = 0
        opDispPtr=0
      else
        'need to wraparound to bottom of the array
        opDispPtr=opDispPtr+MAXENTRIES%
      endif
    endif
    
    'clear the Output Window area
    Box 5,opY,(MM.HRes-10),opH,1,,BCOut%              're-draw the box
    
    'build display from the top line
    opDispLine=0
    
    do
      TEXT 10,opY+(opDispLine*(fH_Out+2))+4,opLine$(opDispPtr),LT,Fnt_Out,1,FCOut%,BCOut% 
      opDispLine=opDispLine+1
      If opDispLine=opMaxLines then
        exit Do
      endif
      
      opDispPtr=opDispPtr+1
      if NOT opWrap AND opDispPtr > opInPtr then 
        exit do 
      endif
      
      If opDispPtr >= MAXENTRIES% then
        'need to wrap around
        opDispPtr=0
      Endif
    loop
    
    'save the end Display Pointer for this display update
    opLastEndPtr=opDispPtr
    
  end sub
  
  Function ScrollOutputWindow(ipDirn,ipStep)
    'calculates the new Ending Display Lines Array index value 
    'to achieve the requested scroll action, taking into account
    'wraparound in the circular list and/or limits imposed by
    'where the new input pointer is at in relation to the requested
    'scroll and/or number of entries in the circular list at this time.
    '
    ' ipDirn = 0 - scroll up
    '        = 1 - scroll down
    
    local j,k           
    
    If ipDirn=0 then                                  'scrolling up    
      j=opLastEndPtr-ipStep                           'scroll up by ipStep lines
      'need to check for limits and/or wraparound
      If NOT opWrap then
        'new EndPtr cannot be less than MaxLines - 1
        If j < (opMaxLines-1) then
          j=(opMaxLines-1)
        Endif
        
      Else
        'array has been filled - wraparound is valid
        'handle EndPtr wraparound if reqd
        If j >= MAXENTRIES% then
          'wraparound 199 -> 0
          j=j-MAXENTRIES%                         
        Endif
        If opLastEndPtr <= opInPtr Then
          'new EndPtr may be less than InPtr if LastEndPtr was less than or equal to InPtr
          'no adjustment/limit required here
        Else
          'calc InPtr + MaxLines and adjust for wraparound if needed
          k=(opInPtr+opMaxLines)
          If k >= MAXENTRIES% Then
            'wraparound 199 -> 0
            k=k-MAXENTRIES%
          Endif
          
          'new EndPtr cannot be less than InPtr + MaxLines
          If j < k Then
            j=k
          endif
        Endif
      Endif
      
    Else                                              'scrolling down
      j=opLastEndPtr+ipStep                           'scroll down by ipStep lines
      'need to check for limits and/or wraparound
      If NOT opWrap then
        j=MIN(opInPtr,j)                              'new EndPtr cannot be greater than InPtr
        
      Else
        'array has been filled - wraparound is valid
        'handle EndPtr wraparound if reqd
        If j >= MAXENTRIES% then
          'wraparound 199 -> 0
          j=j-MAXENTRIES%                         
        Endif
        
        If opLastEndPtr > opInPtr then
          'new EndPtr may be greater than InPtr if last EndPtr was also greater than InPtr,
          'unless it has wrapped when it cannot be greater than InPtr
          If j < opLastEndPtr then
            j=MIN(opInPtr,j)                          'new EndPtr has wrapped, cannot be greater than InPtr now
          endif
          
        Else
          'last EndPtr was less than InPtr, new EndPtr cannot be greater than InPtr
          j=MIN(opInPtr,j)
        endif
      Endif
    endif
    
    ScrollOutputWindow=j                              'return calculated end display ptr
    
    If j=opLastEndPtr then Beep()                     'EndPtr has not changed - must be at a limit
    
  end Function
  
  SUB ClearOutputWindow()
    'clears the output window (and the Display Lines array - opLine$())
    
    On Error Skip 1
    Erase opLine$()                                   'erase the Output Window Display Lines array
    
    DIM opLine$(MAXENTRIES%) Length opMaxChars        're-create Console Output Window Display Lines array
    
    DrawScreen_Normal(1)                              're-draw the Normal mode screen (as initial)
    UpdateText_Cmd()                                  'and update the Command Text input box
    
  end Sub
  
  '===========================================================================================
  '     S E T T I N G S    M E N U    F U N C T I O N S    &    S U B R O U T I N E S
  '===========================================================================================
  
  sUB ShowSettingsMenu(ipInitial)
    'display the Settings Menu
    Local Txt$,InUse,NewSel,svTxtY,X,FC 
    
    If ipInitial then
      'store Current values in Temporary store variables
      TempCuFC=cuFC
      TempBeepVol=BeepVol
      CfgBaudRate=0
      BaudRateChgd=0
      inp_Txt$=""
      
      'hide the cursor in the Command Text input box
      HideCursor_Cmd()
      
      'box width = (Fnt_Mnu Width * 64)
      smW=fW_Mnu*64
      'box height = ((Fnt_Mnu Height + 2) * 15) + 40)
      smH=((fH_Mnu+2)*15)+40
      'calc box left edge (X)
      smX=(mm.HRes\2)-(smW\2)
      'calc box top (Y)
      smY=opY+((opH-smH)\2)
    endif
    
    'calculate left coordinate for Headings and Options text
    TxtX=smX+fW_Mnu
    IndentX=smX+(fW_Mnu*3)
    
    Rbox smX,smY,smW,smH,10,FCblk,BC210
    TxtY=smY+8
    Text TxtX,TxtY,GetStr(96),LT,Fnt_Mnu,1,FCblk,BC210
    TxtYInc(0)
    Line TxtX,TxtY,TxtX+(fW_Mnu*13),TxtY,Fnt_Mnu,FCblk
    TxtYInc(2,5)
    svTxtY=TxtY                                       'save TxtY value for right hand column
    Text TxtX,TxtY,GetStr(97),LT,Fnt_Mnu,1,FCblk,BC210
    
    for i=0 to 3
      InUse=0
      NewSel=0
      
      Select Case i
        Case 0
          Txt$="F1 - Red"
          If cuFC=RGB(Red) Then 
            InUse=1
          else
            If TempCuFC=RGB(Red) Then 
              NewSel=1
            endif
          endif
        Case 1
          Txt$="F2 - Yellow"  
          If cuFC=RGB(Yellow) Then 
            InUse=1
          else
            If TempCuFC=RGB(Yellow) Then 
              NewSel=1
            endif
          endif
        Case 2
          Txt$="F3 - Green"  
          If cuFC=RGB(Green) Then 
            InUse=1
          else
            If TempCuFC=RGB(Green) Then 
              NewSel=1
            endif
          endif
        Case 3
          Txt$="F4 - Magenta" 
          If cuFC=RGB(Magenta) Then 
            InUse=1
          else
            If TempCuFC=RGB(Magenta) Then 
              NewSel=1
            endif
          endif
      End Select
      
      TxtYInc(0)
      If InUse=1 then
        Txt$=Txt$ + GetStr(79)
      endif
      Text IndentX,TxtY,Txt$,LT,Fnt_Mnu,1,FCblk,BC210
      If NewSel=1 then
        Text IndentX+(fW_Mnu*Len(Txt$)),TxtY,GetStr(80),LT,Fnt_Mnu,1,RGB(Red),BC210
      Endif
    Next i
    
    TxtYInc(1)
    Text TxtX,TxtY,GetStr(98),LT,Fnt_Mnu,1,FCblk,BC210
    
    For i=0 to 3
      InUse=0
      NewSel=0
      
      Select Case i
        case 0
          Txt$="F5 - Off"
          If BeepVol=0 then 
            InUse=1
          else
            If TempBeepVol=0 then 
              NewSel=1
            endif
          endif
        case 1
          Txt$="F6 - Loud"
          If BeepVol=20 then 
            InUse=1
          else
            If TempBeepVol=20 then 
              NewSel=1
            endif
          endif
        case 2
          Txt$="F7 - Medium"
          If BeepVol=7 then 
            InUse=1
          else
            If TempBeepVol=7 then 
              NewSel= 1
            endif
          endif
        case 3
          Txt$="F8 - Soft"
          If BeepVol=1 then 
            InUse=1
          else
            If TempBeepVol=1 then 
              NewSel=1
            endif
          endif
      END SELECT
        
      TxtYInc(0)
      If InUse=1 then
        Txt$=Txt$ + GetStr(79)
      endif
      Text IndentX,TxtY,Txt$,LT,Fnt_Mnu,1,FCblk,BC210
      If NewSel=1 then
        Text IndentX+fW_Mnu*Len(Txt$),TxtY,GetStr(80),LT,Fnt_Mnu,1,RGB(Red),BC210
      Endif
    Next i
    
    TxtYInc(1)
    Txt$=GetStr(81)
    X=TxtX
    FC=FCblk
    
    for i=0 to 5
      if Txt$ <> "" then Text X,TxtY,Txt$,LT,Fnt_Mnu,1,FC,BC210
      
      select Case i
        Case 0
          X=IndentX
          TxtYInc(0)
          Txt$=GetStr(82,STR$(comsBaudRate))
        Case 1
          If BaudRateChgd Then 
            X=IndentX+fW_Mnu*16
            Txt$=GetStr(83,STR$(CfgBaudRate))
            FC=RGB(Red)
          endif
        Case 2
          X=IndentX
          TxtYInc(0)
          Txt$=GetStr(84)
          FC=FCblk
        Case 3
          X=TxtX
          TxtYInc(2,fH_Mnu+10)
          Txt$=GetStr(85)
        Case 4
          X=smX+fW_Mnu*32
          Txt$=GetStr(86)
      End Select
    Next i
    
    TxtYInc(0)
      
    'draw vertical separator between left and right columns
    TxtX=smX+fW_Mnu*31
    Line TxtX,svTxtY,TxtX,svTxtY+5+(fH_Mnu+2)*13,1,FCblk
    
    'setup Font Select options in the Right Hand column
    NewSel=0
    TxtX=smX+fW_Mnu*32                                'set new left margin
    IndentX=smX+(fW_Mnu*34)                           'and indented margin
    TxtY=svTxtY                                       'restore top text line pointer
    Text TxtX,TxtY,GetStr(71),LT,Fnt_Mnu,1,FCblk,BC210
    TxtYInc(0)
    Txt$=GetStr(72)
    If Fnt_Out=1 Then 
      Txt$=Txt$ + GetStr(79)
    else
      If SaveFontSelect=1 Then 
        NewSel=1
      endif
    endif   
    Text IndentX,TxtY,Txt$,LT,Fnt_Mnu,1,FCblk,BC210
    If NewSel Then
      Text IndentX+(fW_Mnu*Len(Txt$)),TxtY,GetStr(80),LT,Fnt_Mnu,1,RGB(Red),BC210
      NewSel=0
    Endif
    TxtYInc(0)
    Text IndentX+fW_Mnu*6,TxtY,GetStr(74,"1",Str$(fW_Out_1),Str$(fH_Out_1)),LT,Fnt_Mnu,1,FCblk,BC210
    TxtYInc(0)
    Txt$=GetStr(73)
    If Fnt_Out=2 Then 
      Txt$=Txt$ + GetStr(79)
    else
      If SaveFontSelect=2 Then 
        NewSel=1
      endif
    endif   
    Text IndentX,TxtY,Txt$,LT,Fnt_Mnu,1,FCblk,BC210
    If NewSel Then
      Text IndentX+(fW_Mnu*Len(Txt$)),TxtY,GetStr(80),LT,Fnt_Mnu,1,RGB(Red),BC210
      NewSel=0
    Endif
    TxtYInc(0)
    Text IndentX+fW_Mnu*6,TxtY,GetStr(74,"2",Str$(fW_Out_2),Str$(fH_Out_2)),LT,Fnt_Mnu,1,FCblk,BC210
    TxtYInc(1)
    
    for i=0 to 3
      Text TxtX,TxtY,GetStr(75+i),LT,Fnt_Mnu,1,FCblk,BC210
      TxtYInc(0)
      
      If i=0 then TxtX=TxtX+fW_Mnu*6                  'lines 1, 2 & 3 are indented by 6 chars
    Next i
    
  END SUB
 
  sub ShowEditBaudRate(ipInitial)
    'displays the controls to edit the Coms Baud Rate
    Local X,Txt$
    
    If ipInitial then
      'box width
      ebrW=fW_Out*(Len(GetStr(90))+6)                 'String(90) is longest displayed on this screen
      'box height = ((FNT_Out Height + 2) * 6) + 22)
      ebrH=((fH_Out+2)*7)+30
      'calc box left edge (X)
      ebrX=(mm.HRes\2)-(ebrW\2)
      'calc box top (Y)
      ebrY=opY+((opH-ebrH)\2)
      
      'ensure the New Baud Rate input textbox is empty on initial entry
      inp_Txt$=""
      inpMaxChars=6
      inpMaxLen=6
      inpStartPos=1
      inpCuPos=0
    endif
    
    'calculate left coordinate for Text and Indented Text
    TxtX=ebrX+(fW_Out*2)
    IndentX=ebrX+(fW_Out*4)
    
    'calc Y position of the top line
    TxtY=(ebrY+(fH_Out\2))
    
    Rbox ebrX,ebrY,ebrW,ebrH,10,FCblk,BC190

    Txt$=GetStr(87)
    X=TxtX
    
    For i=0 to 5
      Text X,TxtY,Txt$,LT,FNT_Out,1,FCblk,BC190
      Txt$=GetStr(88+i)                               '88 gets overwritten below (has insert text)
      
      Select Case i
        Case 0
          X=IndentX
          TxtYInc(0)
          Line TxtX,TxtY,(TxtX+(fW_Out*16)),TxtY,1,FCblk
          TxtYInc(2,5)
          Txt$=GetStr(88,STR$(comsBaudRate))
        Case 1
          TxtYInc(1)
        Case 2
          'calculate size and position of the New Baud Rate input text box
          inpX=IndentX+(fW_Out*20)
          inpY=TxtY-3
          inpW=fW_In*8
          inpH=fH_In+6
          
          BOX inpX,inpY,inpW,inpH,1,FCwh,BCgry
          
          If ipInitial AND CfgBaudRate > 0  Then
            inp_Txt$=STR$(CfgBaudRate)                'pre-fill pending change value
            inpCuPos=Len(inp_Txt$)                    'and position cursor at end
          Endif
          
          TxtYInc(2,fH_Out+10)
        Case 3,4
          TxtYInc(1)
      end Select
    next i
    
    UpdateText_INP()
    
  end sub
  
  Function ValidateBaudRate()
    'validate the new Baud Rate value
    Local Temp, ErrFlag=0    
    
    If Len(inp_Txt$)=0 then
      'display error message and wait for ack (Enter) key to continue
      ErrorMsg(mm.HRes\2,ebrY+(ebrH\2),ebrW-fW_Out,GetStr(93),"")
      ErrFlag=1
      
    Else
      Temp=Fix(Val(inp_Txt$))                         'convert entered value to numeric integer
      
      If Temp < 1 or Temp > 282000 then
        'display error message and wait for ack (Enter) key to continue
        ErrorMsg(mm.HRes\2,ebrY+(ebrH\2),ebrW-fW_Out,GetStr(94,inp_Txt$),GetStr(95))
        ErrFlag=1
      Else
        CfgBaudRate=Temp                              'store new Baud Rate value in Settings cfg variable
      Endif
    Endif
    
    ValidateBaudRate=NOT ErrFlag
    
  end Function
  
  '===========================================================================================
  '     C O N S O L E    L O G G I N G    F U N C T I O N S    &    S U B R O U T I N E S
  '===========================================================================================
  
  sub ShowLogFileEnable(ipInitial)
    'display the Console Logging setup window
    Local X,Txt$
    
    If ipInitial then
      'attempt to change the working directory to A:/CONSLOGS (LOGDIR$)
      ON ERROR Skip 1
      CHDIR LOGDIR$                                   'change working directory
      IF MM.ERRNO <> 0 then
        If MM.ERRNO=7 then
          'directory doesn't exist - need to make it
          ON ERROR CLEAR                              'clear previous error indicators - any errors are now fatal
          MKDIR LOGDIR$                               'create the required directory on the SD card
          CHDIR LOGDIR$                               'change to it
        else
          'some other error occurred ???
          'can only report it now as a fatal error
          ShowFileError(GetStr(1),MM.errmsg$,1)
          END                                         'fatal error - terminate the program
        endif
      endif
        
      'hide the cursor in the Command Text input box
      HideCursor_Cmd()
      
      'calculate the size and position taking the requested font size into account.
      'box width = (Fnt_Mnu Width * 60)
      lsmW=fW_Mnu*60
      'box height = ((Fnt_Mnu Height + 2) * 17) + 40
      lsmH=((fH_Mnu+2)*17)+40
      'calc box left edge (X)
      lsmX=(mm.HRes\2)-(lsmW\2)
      'calc box top (Y)
      If lsmH > opH then
        'height required for the Logging Setup box is > than the height of the Output Display Window
        'need to overlap the Command Inut Text Line, but not the Status Bar.
        lsmY=(opY+opH)-lsmH
      else
        'Logging Setup box height is <= Output Display Window height, 
        'center Logging Setup box vertically within the Output Display Window
        lsmY=opY+((opH-lsmH)\2)
      eNDIF
      
      'on initial entry start with an empty file name field
      inp_Txt$=""
      inpMaxLen=MAXFNLEN%
      inpStartPos=1
      inpCuPos=0
    endif
    
    'calculate left coordinate for Text and top coordinate for the first Text line
    TxtX=lsmX+(fW_Mnu*2)
    TxtY=lsmY+5
    
    RBOX lsmX,lsmY,LsmW,lsmH,10,FCblk,BC210
    
    x=TxtX
    Txt$=GetStr(42)                                                         '0
    
    For i=0 to 7  
      Text X,TxtY,Txt$,LT,Fnt_Mnu,1,FCblk,BC210
      Txt$=GetStr(43+i)                                                   '2

      Select Case i
        Case 0
          TxtYInc(0)
          Line TxtX,TxtY,(TxtX+(fW_Mnu*21)),TxtY,1,FCblk
          TxtYInc(2,5)
          Txt$=GetStr(43,LOGDIR$)                                           '1
        case 1
          TxtYInc(1)
        Case 2
          'save top coordinate of this text caption for the Log File List box
          flY=TxtY    
          'calculate the TxtY coordinate for the Log File Name caption 
          'based on the height of the File List box (12 lines)
          TxtY=(TxtY+((fH_Mnu+2)*12))+5
        Case 3          
          'calculate / save parameters for the Log File Name input text box
          inpX=TxtX+fW_Mnu*16
          inpY=TxtY-3
          inpW=fW_Mnu*40
          inpH=fH_In+6
          'draw the Log File Name text input box
          BOX inpX,inpY,inpW,inpH,1,FCwh,BCgry
          TxtYInc(1)
        Case 4
          X=TxtX+fW_Mnu*24
        Case 5
          X=TxtX
          TxtYInc(1)
        Case 6  
          X=TxtX+fW_Mnu*38
      End Select
    Next i
    
    'calculate / save parameters for the Log File List box
    flX=inpX
    flY=flY-4
    flW=inpW
    flH=(fH_Mnu+2)*12
    
    'draw the Log File List box
    BOX flX,flY,flW,flH,1,FCblk,BC190
    'calculate max chars per line / max lines visible in the Log File List box
    flMaxChars=FIX(flW/fW_Mnu)-2                      'max chars visible in Log File List box
    flMaxLines=FIX(flH/(fH_Mnu+2))-1                  'max lines visible in Log File List box
    
    'determine how many log files exist and length of the longest name
    GetFileInfo()
        
    'display initial instructions in the Log File List box
    TxtX=flX+fW_Mnu                                   'calc left (X coordinate) of the text lines
    TxtY=flY+4                                        'calc top (Y coordinate) of top line in the list    
    Txt$=GetStr(50,Str$(FileCnt))
    
    For i=0 to 7
      Text TxtX,TxtY,Txt$,LT,Fnt_Mnu,1,FCblk,BC190
      Txt$=GetStr(51+i)
      TxtYInc(0)
      If i=0 or i=4 then TxtYInc(0)                   'extra line space after line 1 and line 5
    Next i
    
    inpMaxChars=FIX(inpW/fW_In)-2                     'max display chars in Log File Name field
    inpHScrlInc=Fix(inpMaxChars/2)                    'horizontal scroll in 1/2 Log File Name field width steps
    UpdateText_INP()
    
  End sub
  
  sub LogConsMsg(spLogMsg$,ipNoTimestamp)
    'write a line to the Console Log File (including a timestamp unless suppressed)
    Local Log_Timestamp$="         "                  '9 spaces
    
    If ipNoTimestamp=0 then                           'Timestamp is required - overwrite the 9 spaces
      Log_Timestamp$=Time$ + " "                      '9 characters
    endif
    
    LogLnSeq=LogLnSeq+1                               'increment the log line sequence number
    
    Print #2,STR$(LogLnSeq,7) + " "; Log_Timestamp$; spLogMsg$  'write the log record
    
  end sub
  
  Function GetLastLogLnSeq(spLogFN$)
    'read the last few entries in an existing log file 
    'to determine the last Seq number assigned - for use when appending to a log file.
    Local seqNbr,logRec$          
    
    OpenFile(spLogFN$,3,7)                            'open existing log file and check for open error
    
    If LOF(#7) > 300 then                             'more than 300 bytes in the file
      SEEK #7,LOF(#7)-300                             'position pointer 300 bytes from end of file - this
    endif                                             'is sufficient to contain 1 or more log records
    
    do
      LINE INPUT #7,logRec$                           'read record (or partial record ) from log
      If Len(logRec$)=0 then                          'empty record -
        exit do                                       'at EOF so exit loop
        
      elseIf len(logRec$) > 7 then                    'long enough to contain a line seq nbr
        seqNbr=Val(Left$(logRec$,7))                  'extract line seq nbr and save
      Endif
    Loop  
    
    Close #7                                          'close file
    GetLastLogLnSeq=seqNbr                            'return last seq nbr found in the file
    
  end function  
  
  '===========================================================================================
  '     V I E W    L O G    F I L E    F U N C T I O N S    &    S U B R O U T I N E S
  '===========================================================================================
  '
  ' NOTE: View Log File functions share functions from other sections as well as the ones below
  ' =====
  
  Sub SelectLogFile(ipInitial)
    'display a list of available Log Files that can be selected for viewing
    Local Txt$
    
    If ipInitial then
      'attempt to change the working directory to A:/CONSLOGS (LOGDIR$)
      ON ERROR Skip 1
      CHDIR LOGDIR$                                   'change working directory
      IF MM.ERRNO <> 0 then
        If MM.ERRNO= 7 then
          'directory doesn't exist - report as error - can't view log files
          ON ERROR CLEAR                              'clear previous error indicators - any errors are now fatal
          ShowFileError(GetStr(3,LOGDIR$),GetStr(6),0)
          exit sub
        else
          'some other error occurred ???
          'can only report it now as a fatal error
          ShowFileError(GetStr(1),MM.errmsg$,1)
          END                                         'fatal error - terminate the program
        endif
      endif
        
      'hide the cursor in the Command Text input box
      HideCursor_Cmd()
      
      'calculate the size and position taking the requested font size into account.
      'box width = (Fnt_Mnu Width * 60)
      lsmW=fW_Mnu*60
      'box height = ((Fnt_Mnu Height + 2) * 18) + 25)
      lsmH=((fH_Mnu+2)*18)+25
      'calc box left edge (X)
      lsmX=(mm.HRes\2)-(lsmW\2)
      'calc box top (Y)
      If lsmH > opH then
        'height required for the Logging Setup box is > than the height of the Output Display Window
        'need to overlap the Command Inut Text Line, but not the Status Bar.
        lsmY=(opY+opH)-lsmH
      else
        'Logging Setup box height is <= Output Display Window height, 
        'center Logging Setup box vertically within the Output Display Window
        lsmY=opY+((opH-lsmH)\2)
      eNDIF
    endif
    
    'calculate left coordinate for Text and top coordinate for the first Text line
    TxtX=lsmX+(fW_Mnu*2)
    TxtY=lsmY+((fH_Mnu\2)+2)
    
    RBOX lsmX,lsmY,LsmW,lsmH,10,FCblk,BC210
    
    Txt$=GetStr(100)                                                              '0
    
    for i=0 to 5
      Text TxtX,TxtY,Txt$,LT,Fnt_Mnu,1,FCblk,BC210
      Txt$=GetStr(101+i)                              '102 gets overwritten (has insert text)
      
      Select Case i
        Case 0
          TxtYInc(0)
          Line TxtX,TxtY,(TxtX+(fW_Mnu*23)),TxtY,1,FCblk
          TxtYInc(2,5)
        Case 1
          TxtYInc(1)
          Txt$=GetStr(102,LOGDIR$)
        Case 2,4
          TxtYInc(1)
        Case 3
          'save top coordinate of this text caption for the Log File List box
          flY=TxtY
          'calculate the TxtY coordinate for the 'Enter' key caption 
          'based on the height of the File List box (12 lines)
          TxtY=(TxtY+((fH_Mnu+2)*12))+5
      End Select
    next i
      
    'calculate / save parameters for the Log File List box
    flX=TxtX+(fW_Mnu*16)
    flY=flY-4
    flW=fW_Mnu*40
    flH=(fH_Mnu+2)*12
    
    'draw the Log File List box
    BOX flX,flY,flW,flH,1,FCblk,BC190
    'calculate max chars per line / max lines visible in the Log File List box
    flMaxChars=FIX(flW/fW_Mnu)-2                      'max chars visible in Log File List box
    flMaxLines=FIX(flH/(fH_Mnu+2))-1                  'max lines visible in Log File List box
    
    'determine how many log files exist and length of the longest name
    GetFileInfo()
    'build and display the file list
    BuildFileList("")
    
  end sub
  
  sub ViewLogFile()
    'controls setup for viewing the content of a selected log file.
    Local MaxRecLen, RecNbr, Rec$          
    
    DrawScreen_ViewLog()                              'draw the View Log File screen layout
    
    'find the record count in the selected log file
    vlmRecCnt=GetLastLogLnSeq(vlmFN$)
    
    'create a global Integer array with sufficient entries for the # of records in the file
    'this array is used to track the byte offset in the file for the start of each record
    'Note: need to ERASE any existing instance of this array variable first
    '-----
    On Error skip 1
    Erase vlmRecPtr()
    on Error Clear
    'now DIM the new array instance with the number of 
    'elements = # of records in the file (already determined)
    dim vlmRecPtr(vlmRecCnt)           
    
    'initialize the vlmRecPtr array by reading through the
    'log file, recording the byte offset for the start of each record
    RecNbr=1
    'store first record pointer
    vlmRecPtr(RecNbr)=1                               'Record # 1 starts at Byte 1 of the file
    
    OpenFile(vlmFN$,0,3)                              'open log file and check for open error
    
    Do
      Line Input #3,Rec$
      'the LOC(#3) pointer AFTER the LINE INPUT stmt will point to the start of the NEXT record
      RecNbr=RecNbr+1
      'store record pointer
      vlmRecPtr(RecNbr)=LOC(#3)
      'track the maximum record length
      MaxRecLen=MAX(MaxRecLen,LEN(Rec$))
      
      If RecNbr=>vlmRecCnt then Exit Do               'reached End of File = exit loop
    Loop
    
    Close #3
    
    'calculate the maximum HScroll value to cater for the longest record
    'in this log file and the current Output Font size, 
    'but always allow scrolling sufficient to hide the Record Seq # and Timestamp
    vlmMaxHScrl=MAX(17,(MaxRecLen-opMaxChars))
    
    'display the log file contents, starting from the beginning
    vlmSelRecNbr=-1                                   'reset selected rec nbr (only used from Search Results)
    vlmHScrl=4                                        'should only be max 2 digit record nbr on the initial page
    UpdVLSBPanel(2,STR$(vlmHScrl))
    UpdVLSBPanel(3,"1")
    DisplayLog(1,vlmHScrl)

  end sub
  
  sub DrawScreen_ViewLog()
    'draws the screen layout used for View Log File mode
    CLS BCblu
    
    TEXT mm.HRES\2,0,GetStr(106,ProgVer$),CT,2,1,FCwh,BCblu
    
    DrawStatusBar()
        
    'draw and initialize the Status Bar text panels (except Date & Time - already done)
    UpdVLSBPanel(1,vlmFN$)                    
    UpdVLSBPanel(2,"")
    UpdVLSBPanel(3,"")
    UpdVLSBPanel(4,"")
    UpdVLSBPanel(5,"")
    UpdVLSBPanel(6,"")
    
    'set size, position and other parameters for the Output window
    opY=24                                            'Output window top
    opH=(sbY-opY)-5                                   'Output window height
    opMaxLines=opH\(fH_Out+2)                         'Output font height + 2 pixels per line in the Output window
    opMaxChars=(mm.HRes-20)\fW_Out
    
    'draw the View Log Output window
    Box 5,opY,(MM.HRes-10),opH,1,,BCOut%        
    
  end sub
  
  sub UpdVLSBPanel(ipWhich,spCaption$)
    'draw/clear the specified panel, and update the caption displayed in it
    '
    'Status Bar Panel Parameters
    '=============================
    ' sbp1X |   5 | sbp5X | 484 |
    '-------+-----|-------+-----|
    ' sbp1W | 299 | sbp5W |  64 |
    '-------+-----|-------+-----|
    ' sbp1C |   - | sbp5C | 516 |
    '-------+-----|-------+-----|
    ' sbp2X | 309 | sbp6X | 553 |
    '-------+-----|-------+-----|
    ' sbp2W |  32 | sbp6W |  56 |
    '-------+-----|-------+-----|
    ' sbp2C | 325 | sbp6C | 581 |
    '-------+-----|-------+-----|
    ' sbp3X | 346 | sbp7X |   - |
    '-------+-----|-------+-----|
    ' sbp3W |  64 | sbp7W |   - |
    '-------+-----|-------+-----|
    ' sbp3C | 378 | sbp7C |   - |
    '-------+-----|-------+-----|
    ' sbp4X | 415 |       |     |
    '-------+-----|-------+-----|
    ' sbp4W |  64 |       |     |
    '-------+-----|-------+-----|
    ' sbp4C | 447 |       |     |
    '----------------------------
    
    Select case ipWhich
      Case 1                                          'Log File Name panel
        box 5,sbpY,299,sbpH,0,0,BC190     'draw/re-draw empty panel
        Text 9,sbpTextY,"File: " + Left$(spCaption$, 30),LT,1,1,FCblk,BC190
        
      case 2                                          'HScroll Value
        box 309,sbpY,32,sbpH,0,0,BC190
        Text 325,sbpTextY,spCaption$,CT,1,1,FCblk,BC190
        
      Case 3                                          'Record Number for curremt starting record displayed
        box 346,sbpY,64,sbpH,0,0,BC190
        Text 378,sbpTextY,spCaption$,CT,1,1,FCblk,BC190
       
      Case 4                                          'Number of records in the log file
        box 415,sbpY,64,sbpH,0,0,BC190
        Text 447,sbpTextY,spCaption$,CT,1,1,FCblk,BC190
       
      Case 5                                          'Match Case State (only relevant during Search)
        box 484,sbpY,64,sbpH,0,0,BC190
        Text 516,sbpTextY,spCaption$,CT,1,1,FCblk,BC190
       
      Case 6                                          'Display Results available
        box 553,sbpY,56,sbpH,0,0,BC190
        Text 581,sbpTextY,spCaption$,CT,1,1,FCblk,BC190
        
    End Select
    
  end sub
  
  sub DisplayLog(ipStartRec,ipHScrl)
    'displays data from the log file being viewed,
    'starting from the specified Record Number (ipStartRec)
    'and with the specified horizontal scroll value (ipHScrl)
    Local FCdl,BCdl,LineCount,LogRec$                      'log record contents

    'clear the Display Window area
    Box 5,opY,(MM.HRes-10),opH,1,,BCOut%              're-draw the box
    
    'build display from the top line
    LineCount=1
    
    'calc Y coordinate for the top line in the display area
    OutY=opY+4
    
    'set the file pointer to the start of the ipStartRec record
    vlmLastStartRecNbr=ipStartRec                     'save this starting rec number
    UpdVLSBPanel(3,Str$(ipStartRec))                  'update Status Bar panel - Start Rec #
    UpdVLSBPanel(4,STR$(vlmRecCnt))                   'refresh Status Bar panel - Total Record Count
    UpdVLSBPanel(5,"")                                'clear Match Case state (only relevant during Search)
    UpdVLSBPanel(6,SrchRsltsAvailState())             'show Search Results Avail state
    vlmNextRecNbr=ipStartRec
    
    OpenFile(vlmFN$,3,3)                              'open log file and check for open error
    
    Seek #3,vlmRecPtr(vlmNextRecNbr)                  'set file pointer to reqd starting position
    
    do
      Line Input #3,LogRec$                           'read a log file record
      
      If LogRec$="" then                              'check for End of File
        exit do
      endif
      
      If vlmSelRecNbr=vlmNextRecNbr then              'this is the record selected from the Search Results
        BCdl=&HFFDEAD                                 'NavajoWhite background for the selected record
        FCdl=FCblk                                    'with Black text
      Else
        BCdl=BCOut%
        FCdl=FCOut%
      endif
      
      'display the record data in the Output window
       TEXT 10,OutY,Mid$(LogRec$,(ipHScrl+1),opMaxChars),LT,Fnt_Out,1,FCdl,BCdl 
     
      OutYInc(0)                                      'increment Y coordinate pointer
      vlmNextRecNbr=vlmNextRecNbr+1                   'increment log record number
      LineCount=LineCount+1                           'increment displayed line count
      If LineCount > opMaxLines then exit do          'output display area filled
    loop
    
    Close #3                                          'close the log file
    
  end sub
  
  '===========================================================================================
  '     S E A R C H    L O G    F I L E    F U N C T I O N S    &    S U B R O U T I N E S
  '===========================================================================================
  
  SUb GetSrchLogFileParams(ipInitial)
    'displays a pop-up box to allow input of the Log Search parameters
    Local lspX,lspY,lspW,lspH,X           
    
    'calculate the size and position taking the requested font size into account.
    'box width = (Fnt_Mnu Width * 47)
    lspW=fW_Mnu*47
    'box height = ((Fnt_Mnu Height + 2) * 8) + 55)
    lspH=((fH_Mnu+2)*8)+55
    'calc box left edge (X)
    lspX=(mm.HRes\2)-(lspW\2)
    'calc box top (Y)
    lspY=opY+((opH-lspH)\2)
    
    TxtX=lspX+(fW_Mnu*2)
    TxtY=lspY+(fH_Mnu\2)
    
    'draw the box and display the text, etc in it
    RBOX lspX,lspY,lspW,lspH,10,FCblk,BC210
    
    X= TxtX
    
    For i=0 to 6
      Text X,TxtY,GetStr(108+i),LT,Fnt_Mnu,1,FCblk,BC210
      
      Select Case i
        Case 0
          TxtYInc(0)
          Line TxtX,TxtY,(TxtX+(fW_Mnu*19)),TxtY,1,FCblk
          TxtYInc(2, 10)
        Case 1
          TxtYInc(0)
        Case 2
          TxtYInc(1)
          'save size and position of the Log Search String input text box
          inpX=TxtX
          inpY=TxtY
          inpW=fW_Mnu*43
          inpH=fH_In+6
          
          X=TxtX+(fW_Mnu*3)
          TxtYInc(2,(inpH+7))
        Case 3
          'save location of the Log Search Incl Timestamp check box
          lstsX=TxtX
          lstsY=TxtY-2 
          
          X=TxtX+(fW_Mnu*3)
          TxtYInc(1)
        Case 4
          'save location of the Log Search Match Case check box
          lsmcX=TxtX
          lsmcY=TxtY-2 
          
          X=TxtX
          TxtYInc(1)
        Case 5
          TxtYInc(1)
      end select
    Next i
    
    'draw the input text box
    BOX inpX,inpY,inpW,inpH,1,FCwh,BCgry
    'calc max input length the text box allows    
    inpMaxLen=(inpW\fW_In)-1
    'draw the Include Timestamp option check box and its content
    UpdChkBox(lstsX,lstsY,lsmInclTS)
    'draw the Match Case option check box and its content
    UpdChkBox(lsmcX,lsmcY,lsmMtchCase)
    UpdVLSBPanel(5,MatchCaseState())
        
    If ipInitial then
      'start with an empty Search String field on initial entry
      inp_Txt$=""
      inpMaxChars=inpMaxLen
      inpStartPos=1
      inpCuPos=0
    Endif
    
    UpdateText_INP()
    
  end sub

  Function MatchCaseState() as String
    'returns the current state of the Case Match flag
    If lsmMtchCase=0 then                             'ignore case
      MatchCaseState="Ignore"
    Else                                              'match case
      MatchCaseState="Match"
    Endif
    
  End Function  
  
  Function SearchFileContents(spSrchString$)
    'search the Log File currently being viewed, building a list of
    'records (and file pointers) that match the specified Log Search String
    Local SrchStartOffset,RsltsIdx,MaxRecLen,RecNbr,RecPtr,Rec$,TargetString$          
    
    If lsmMtchCase=0 then
      'ignore case - so convert everything to Upper Case
      TargetString$=UCASE$(spSrchString$)
    Else
      TargetString$=spSrchString$
    Endif
    
    if lsmInclTS=0 then
      'don't search in the Timestamp field
      SrchStartOffset=18
    Else
      'include searching in the Timestamp field
      SrchStartOffset=9
    Endif
    
    'declare a global array large enough to contain the search results
    'even if every record contains a match.
    'make sure any previous instance of this array has been ERASED
    On Error Skip 1
    ERASE SrchRslts()
    
    DIM SrchRslts(vlmRecCnt)                          'element 0 = file pointer to start of record matching Srch String
    
    RsltsIdx=1                                        'first result entry is index 1 (not 0)
    RecNbr=1                                          'first Record in file is # 1
    RecPtr=1                                          'and starts at byte 1 in the file
    
    OpenFile(vlmFN$,0,4)                              'open log file and check for open error
    
    Do
      Line Input #4,Rec$
      If Rec$="" then
        'reached end of file - exit loop now
        exit do
      endif
      
      if lsmMtchCase=0 then
        'ignore case - so convert everything to Upper Case
        Rec$=UCase$(Rec$)
      Endif
      
      If InStr(SrchStartOffset,Rec$,TargetString$) > 0 then 
        'match on Search String found - save pointer to this record
        SrchRslts(RsltsIdx)=RecPtr
        'track the maximum record length in matching records
        MaxRecLen=MAX(MaxRecLen,LEN(Rec$))
        'increment RsltsIdx ready for next match
        RsltsIdx=RsltsIdx + 1
      Endif
      
      'increment record number
      RecNbr=RecNbr + 1
      'the LOC(#3) pointer AFTER the LINE INPUT stmt will point to the start of the NEXT record
      RecPtr=LOC(#4)
    Loop
    
    Close #4 
     
    'calculate the maximum HScrl value to cater for the longest record
    'in the Search Results and the current Output Font size, 
    'but always allow scrolling sufficient to hide the Record Seq # and Timestamp
    dsrMaxHScrl=MAX(17,(MaxRecLen-opMaxChars))
    
    'set / reset SrchRsltsAvail flag
    SrchRsltsAvail=(RsltsIdx > 1)
   
    'return the count of matching records found
    'this is 1 less than the current RsltsIdx value
    SearchFileContents=RsltsIdx-1
    
  end Function
  
  sub DispSrchResults(ipStartIdx,ipHScrl)
    'displays data from the log file based on the current Search Results,
    'starting from the specified Results Index (ipStartIdx)
    'and with the specified horizontal scroll value (ipHScrl)
    Local LnNbr,FrzW,Strt,LineCount,LogRec$
    
    'Declare the 'real' dsrRecNbrs global array to store the
    'Record Nbr of each Searchs Results entry displayed on this
    'screen - used for the 'GoTo' selected line function.
    'Note: Need to erase any existing copy of the array
    ON Error SKIP 1                                   'to avoid a fatal error if the array doesn't exist
    Erase dsrRecNbrs()                                'erase current instance of array
    DIM dsrRecNbrs(opMaxLines)                        'declare array, only needs entries for a single screen
    
    'clear the Display Window area
    Box 5,opY,(MM.HRes-10),opH,1,,BCOut%              're-draw the box
    
    UpdVLSBPanel(1,vlmFN$)                            'update Status Bar panel - Log File Name
    UpdVLSBPanel(2,Str$(ipHScrl))                     'update Status Bar panel - Horiz Scroll
    UpdVLSBPanel(3,Str$(ipStartIdx))                  'update Status Bar panel - Start Display RsltsIdx#
    UpdVLSBPanel(4,Str$(dsrRecCnt))                   'update Status Bar panel - Search Results Count
    UpdVLSBPanel(5,MatchCaseState())                  'update Status Bar panel - Search Match Case state
    UpdVLSBPanel(6,SrchRsltsAvailState())             'update Status Bar panel - Search Results Avail state
    
    'calc line spacing and the Y coordinate for the top line in the display area
    OutY=(opY+4)
    
    'display the Search Results header
    Box 6,opY+1,MM.Hres-12,fH_Out+3,0,,RGB(White) 
    Text MM.HRES\2,OutY,GetStr(118,inp_Txt$,Str$(dsrRecCnt)),CT,Fnt_Out,1,FCblk,RGB(White) 
    OutYInc(0)                                        'increment Y coordinate pointer    
    LineCount=2                                       'build display from the second line  
    
    OpenFile(vlmFN$,3,4)                              'open log file and check for open error
    
    'set the file pointer to the start of the ipStartRec record
    dsrLastStrtIdx=ipStartIdx                         'save this starting RsltsIdx number
    dsrNextIdx=ipStartIdx
    
    do
      Seek #4,SrchRslts(dsrNextIdx)                   'set file pointer to start of this result record
      Line Input #4,LogRec$                           'read a log file record
      
      If LogRec$="" then exit do                      'check for End of File
      
      If LineCount=2 then                             'first results display line
        LnNbr=Val(Left$(LogRec$,7))                   'get line (sequence) number for top line
        
        Select CAse LnNbr
          Case < 100
            FrzW=5
            Strt=5
          Case < 1000
            FrzW=6
            Strt=4
          Case < 10000
            FrzW=7
            Strt=3
          Case < 100000
            FrzW=8
            Strt=2
          Case Else
            FrzW=9
            Strt=1
        End Select 
        
        'draw the 'frozen' section on the left
        Box 6,OutY-1,FrzW*fW_Out,opH-fH_Out-6,0,0,BC50           
      endif
      
      'display the "frozen" line (seq) number portion on the left
      Text 10+fW_Out,OutY,Mid$(LogRec$,Strt,FrzW-2),LT,Fnt_Out,1,FCwh,BC50
      dsrRecNbrs(LineCount-1)=Val(Left$(LogRec$,7))   'save line (sequence) number for this line
      
      'display the record data in the Output window
      TEXT 10+fW_Out*FrzW,OutY,Mid$(LogRec$,(ipHScrl+9),opMaxChars-FrzW),LT,Fnt_Out,1,FCOut%,BCOut%
      
      OutYInc(0)                                      'increment Y coordinate pointer
      
      If dsrNextIdx >= dsrRecCnt then Exit Do         'reached end of results
      If LineCount+1 > opMaxLines then Exit Do        'output display area filled
      
      dsrNextIdx=dsrNextIdx+1                         'increment RsltsIdx number
      LineCount=LineCount+1                           'increment displayed line count
    loop
    
    Close #4
    
    dsrIndRow=Min(dsrIndRow,LineCount-1)              'don't let Selected Row Ind go past last used row 
    SetCurrLnInd()                                    'set the Current Line Indicator
    
  end sub

  sub SetCurrLnInd()
    'handles moving the Current Line Indicator up/down,
    'optionally clearing the previous Indicator position.
    Local Ye=6
    
    If Fnt_Out=1 then Ye=3
    
    if dsrPrevIndRow > 0 then
      'clear the previous row indicator
      text 10,opY+((fH_Out+2)*dsrPrevIndRow)+Ye,Chr$(127),LT,Fnt_In,1,BC50,BC50
    endif
    
    'display/redisplay the current row indicator
    text 10,opY+((fH_Out+2)*dsrIndRow)+Ye,Chr$(127),LT,Fnt_In,1,cuFC,BC50
    'save current row as previous row
    dsrPrevIndRow=dsrIndRow

  end sub
  
  Sub DispNoSearchMatches()
    'display the No Search Matches Found message and wait for 'Enter' key
    LOCAL X, Y, W, H           
    
    W=fW_Mnu*39
    H=((fH_Mnu+2)*8)+10
    X=(MM.Hres-W)\2
    Y=(MM.Vres-H)\2
    
    TxtX=X+(fW_Mnu*2)
    TxtY=Y+(fH_Mnu\2)
    
    RBox X,Y,W,H,10,FCerr,BCerr
    Text TxtX,TxtY,GetStr(119),LT,Fnt_Mnu,1,FCerr,BCerr 
    TxtYInc(0)
    Line TxtX,TxtY,TxtX+fW_Out*19,TxtY,1,FCerr
    TxtYInc(2,7)
    
    for i=0 to 5
      Text TxtX,TxtY,GetStr(120+i),LT,Fnt_Mnu,1,FCerr,BCerr
      If i<4 then TxtYInc(0) else TxtYInc(1)
    Next i
    
    'need to wait here until the 'Enter' key is pressed
    WaitForKey()
    
  end sub
  
  FUNCTION SrchRsltsAvailState() as String
    'return a string indicating the state of the SrchRsltsAvail flag
    
    SrchRsltsAvailState=""                            'empty string - default + no search results avail
    
    If SrchRsltsAvail then
      SrchRsltsAvailState="Search"                    '"Search" returned if the flag is set
    Endif
    
  end FUNCTION
  
  '===========================================================================================
  '     U P L O A D    P R O G R A M    F U N C T I O N S    &    S U B R O U T I N E S
  '===========================================================================================
  
  Sub SelectProgFile(ipInitial)
    'NOTE: this subroutine is shared between Program Upload, File Crunch and Program Edit functions
    '=====
    'display a list of available Program Files that can be selected for uploading/editing
    local CaptionLen,FuncTxt$,Txt$          
    
    If ipInitial then
      'attempt to change the working directory to A:/PROGSS (PROGDIR$)
      ON ERROR Skip 1
      CHDIR PROGDIR$                                  'change working directory
      IF MM.ERRNO <> 0 then
        If MM.ERRNO=7 then
          'directory doesn't exist - report as error - can't view program files
          ON ERROR CLEAR                              'clear previous error indicators - any errors are now fatal 
          
          If Mode=75 then                             
            FuncTxt$="Crunching"         
          ElseIf Mode=50 Then
            FuncTxt$="Uploading"         
          Else
            FuncTxt$="Editing"
          endif
          
          ShowFileError(GetStr(3,PROGDIR$),GetStr(5,FuncTxt$),0)          
          exit sub
          
        else
          'some other error occurred ???
          'can only report it now as a fatal error
          ShowFileError(GetStr(1),MM.errmsg$,1)
          END                                         'fatal error - terminate the program
        endif
      endif
        
      'hide the cursor in the Command Text input box
      HideCursor_Cmd()
      
      'calculate the size and position taking the requested font size into account.
      'box width = (Fnt_Mnu Width * 60)
      spfW=fW_Mnu*60
      'box height = ((Fnt_Mnu Height + 2) * 18) + 25)
      spfH=((fH_Mnu+2)*18)+25
      'calc box left edge (X)
      spfX=(mm.HRes-spfW)\2
      
      'calc box top (Y)
      If spfH > opH then
        'height required for the Select Prog File box is > than the height of the Output Display Window
        'need to overlap the Command Input Text Line, but not the Status Bar.
        spfY=(opY+opH)-spfH
      else
        'Select Prog File box height is <= Output Display Window height, 
        'center Select Prog File box vertically within the Output Display Window
        spfY=opY+((opH-spfH)\2)
      eNDIF
    endif
    
    'calculate left coordinate for Text and top coordinate for the first Text line
    TxtX=spfX+(fW_Mnu*2)
    TxtY=spfY+(fH_Mnu\2)+2
    
    RBOX spfX,spfY,spfW,spfH,10,FCblk,BC210
    
    If Mode=75 then
      FuncTxt$=GetStr(136)                            'Crunch
      CaptionLen=29
    ElseIf Mode=50 Then
      FuncTxt$=GetStr(137)                            'Upload
      CaptionLen=29
    Else
      FuncTxt$=GetStr(138)                            'Edit
      CaptionLen=27
    Endif
    
    Txt$=GetStr(130,FuncTxt$)
    
    for i=0 to 5
      Text TxtX,TxtY,Txt$,LT,Fnt_Mnu,1,FCblk,BC210
      
      Select Case i
        Case 0
          TxtYInc(0)
          Line TxtX,TxtY,TxtX+fW_Mnu*CaptionLen,TxtY,1,FCblk
          TxtYInc(2,5)
          FuncTxt$=LCase$(FuncTxt$)
          Txt$=GetStr(131,FuncTxt$)
        Case 1
          TxtYInc(1)
          Txt$=GetStr(132,PROGDIR$)
        Case 2
          TxtYInc(1)
          Txt$=GetStr(133)
        Case 3
          'save top coordinate of the last text caption for the File List box
          flY=TxtY
          'calculate the TxtY coordinate for the 'Enter' key caption 
          'based on the height of the File List box (12 lines)
          TxtY=(TxtY+((fH_Mnu+2)*12))+5
          Txt$=GetStr(134,FuncTxt$)
        Case 4
          TxtYInc(1)
          Txt$=GetStr(135)
      end Select
    next i
    
    'calculate / save parameters for the File List box
    flX=TxtX+(fW_Mnu*16)
    flY=flY-4
    flW=fW_Mnu*40
    flH=(fH_Mnu+2)*12
    
    'draw the Program File List box
    BOX flX,flY,flW,flH,1,FCblk,BC190
    'calculate max chars per line / max lines visible in the Program File List box
    flMaxChars=FIX(flW/fW_Mnu)-2                      'max chars visible
    flMaxLines=FIX(flH/(fH_Mnu+2))-1                  'max lines visible
    
    'determine how many program files exist and length of the longest name
    GetFileInfo()
    'build and display the File List
    BuildFileList("")
    
  end sub
  
  Sub ProgramUpload(ipInitial)
    'displays the Program Upload screen, allowing confirmation of the program file
    'selected for upload and setting Upload Options, then initiating the actual upload.
    Local LineCount,FileLen,WorkX,Txt$            
    
    'get info for the selected program file
    GetProgFileInfo(pumFN$,LineCount,FileLen) 
    
    'calculate the size and position taking the requested font size into account.
    'box width =  fW_Mnu * 48  (48 chars - 44 text + 2 leading + 2 trailing)
    pumW=fW_Mnu*48
    'box height = ((fH_Mnu + 2) * 11) + 44 (10 text lines + 0.5 top & bottom + extra spaces (44 pixel rows))
    pumH=((fH_Mnu + 2)*11)+44
    'calc box left edge (X)
    pumX=(MM.HRES-pumW)\2
    'set box top (Y)
    pumY=((opY+opH)-pumH)\2
    
    TxtX=pumX+(fW_Mnu*2)
    IndentX=pumX+(fW_Mnu*4)
    TxtY=pumY+(fH_Mnu\2)
    
    'draw the box and display the text, etc in it
    RBOX pumX,pumY,pumW,pumH,10,FCblk,BC210
    
    WorkX=TxtX
    Txt$=GetStr(155)
    
    For i=0 to 9
      Text WorkX,TxtY,Txt$,LT,Fnt_Mnu,1,FCblk,BC210
      
      Select Case i
        Case 0
          TxtYInc(0)
          Line TxtX,TxtY,TxtX+fW_Mnu*19,TxtY,1,FCblk
          TxtYInc(2,10)
          Txt$=GetStr(145)
        Case 1
          TxtYInc(0)
          WorkX=IndentX    
          Txt$=GetStr(146,PROGDIR$)
        Case 2
          TxtYInc(0)
          Txt$=GetStr(147,Left$(pumFN$,29))
        Case 3  
          TxtYInc(0)
          Txt$=GetStr(148,Str$(LineCount),Str$(FileLen))
        Case 4
          TxtYInc(1)
          WorkX=TxtX
          TxT$=GetStr(156)
        case 5
          TxtYInc(2,fH_Mnu+10)
          WorkX=IndentX+(fW_Mnu*3)
          TxT$=GetStr(157)
          'save position of the Checkbox
          cfX=IndentX
          cfY=TxtY-2 
        case 6
          TxtYInc(2,fH_Mnu+10)
          WorkX=IndentX+(fW_Mnu*3)
          TxT$=GetStr(158)
          'save position of the Checkbox
          scX=IndentX
          scY=TxtY-2 
        Case 7
          TxtYInc(2,fH_Mnu+10)
          WorkX=TxtX
          TxT$=GetStr(159)
        Case 8
          TxtYInc(1)
          TxT$=GetStr(160)
      End Select
    next i
    
    'draw the Crunch File option check box and contents
    UpdChkBox(cfX,cfY,CrunchOpt)
    'draw the Send CLS option check box and contents
    UpdChkBox(scX,scY,CLSOpt)
    
  end sub
  
  sub DoUpload()
    'controls the entire upload process, reporting progress status along the way
    Local Rslt, OrigLines, OrigBytes, CrnchdLines, CrnchdBytes, ElapTime           
    Local Work as Float
    
    ShowUploadStatus()                                'display the Upload Status screen format + header caption
    
    'send ^C to target MM to interrupt any program running there
    pumState=1                                        'Upload process initiated
    UpdStatus(GetStr(161), 0)
    SendCommand(Chr$(3))                              'send Ctrl-C (0x03) to the target MM Console
    Rslt=WaitForResponse()                            'wait for response or Rx Timeout
    If Rslt=1 then                                    'expected response received
      UpdStatus("- done",1)                           'update status
    ElseIf Rslt=-1 then
      UpdStatus("- failed",1)
      UpdStatus(GetStr(162),1)
      UpdStatus(GetStr(163),1)
      pumState=-1
      exit sub
    endif
    
    'retrieve info about the Target MM device 
    pumState=5                                        'getting target device info
    UpdStatus(GetStr(164),0)
    SendCommand("PRINT MM.DEVICE$: PRINT MM.VER")     'send multi-command string
    Rslt=WaitForResponse()                            'wait for response or Rx Timeout
    If Rslt=1 then                                    'expected response received
      UpdStatus("- done",1)                           'update status
      UpdStatus(GetStr(165,Resp1$),1)
      UpdStatus(GetStr(166,Resp2$),1)
    ElseIf Rslt=-1 then
      UpdStatus("- failed",1)
      UpdStatus(GetStr(167),1)
      pumState=-1
      Exit Sub
    endif
    
    If CLSOpt then
      'send CLS to clear screen
      pumState=10                                     'Send CLS
      UpdStatus(GetStr(168),0)
      SendCommand("CLS")                              'send command
      Rslt=WaitForResponse()                          'wait for response or Rx Timeout
      If Rslt=1 then                                  'expected response received
        UpdStatus("- done",1)                         'update status
      ElseIf Rslt=-1 then
        UpdStatus("- failed",1)
        UpdStatus(GetStr(167),1)
        pumState=-1
        Exit Sub
      endif
    endif
    
    If CrunchOpt then
      pumState=15
      'setup the Crunched file name
      i=Len(pumFN$)
      pumCrnFN$=Left$(pumFN$,i-4) + "_Crunched.bas"
      UpdStatus(GetStr(169),0)
      'crunch the program file
      CrunchFile(pumFN$,pumCrnFN$,OrigLines,OrigBytes,CrnchdLines,CrnchdBytes,ElapTime)  'crunch the program file
      'calc & display the Crunch Statistics
      Work=((OrigBytes-CrnchdBytes)/OrigBytes)*100    '% Savings due to Crunch
      UpdStatus(GetStr(171,STR$(Work,1,1)),1)
      UpdStatus(GetStr(172,Str$(OrigBytes),STR$(OrigLines)),1)
      UpdStatus(GetStr(173,Str$(CrnchdBytes),STR$(CrnchdLines)),1)
      UpdStatus(GetStr(174,STR$(ElapTime/1000)),1)
      
    Else
      'not crunching the file - set Crunched File Name = Orig File Name
      pumCrnFN$=pumFN$
    endif
    
    'clear the program in the target MM (send NEW)
    pumState=20                                       'Send NEW
    UpdStatus(GetStr(175),0)
    SendCommand("NEW")                                'send command
    Rslt=WaitForResponse()                            'wait for response or Rx Timeout
    If Rslt=1 then                                    'expected response received
      UpdStatus("- done",1)                           'update status
    ElseIf Rslt=-1 then
      UpdStatus("- failed",1)
      UpdStatus(GetStr(167),1)
      pumState=-1
      Exit Sub
    endif
    
    XModemSend()                                      'upload the program file to the target MM device     
    
  End Sub

  Sub ShowUploadStatus()
    'display the Upload Status screen 
    '- initially only the Header Caption, details will be added as the upload progresses
    
    'calculate the size and position taking the requested font size into account.
    'box width =  fW_Mnu * 64  (64 chars - 60 text + 2 leading + 2 trailing)
    upsW=fW_Mnu*64
    'box height = opH - (fH_Mnu + 2)
    upsH=opH-(fH_Mnu+2)
    'calc box left edge (X)
    upsX=(MM.HRES-upsW)\2
    'calc box top (Y)
    upsY=opY+(fH_Mnu+2)\2
    
    TxtX=upsX+(fW_Mnu*2)
    IndentX=upsX+(fW_Mnu*4)
    upsTxtX=TxtX
    upsTxtY=upsY+3
    
    'draw the box
    BOX upsX,upsY,upsW,upsH,1,FCblk,BCblu
    
    'display the header
    Box upsX+1,upsY+1,upsW-2,fH_Mnu+4,0,,FCwh 
    Text upsTxtX,upsTxtY,GetStr(176,PROGDIR$,pumFN$),LT,Fnt_Mnu,1,FCblk,RGB(White) 
    UPSTxtYInc(2,fH_Mnu+5)
    
  end sub
 
  sub SendCommand(spTxt$)
    'send the specified Command Text (spTxt$) with a CR terminator
    'to the target MM console and initiate a Response Timeout interrupt.
    
    RxTOutFlg=0                                       'ensure RxTimeout Flag is reset
    PRINT #1,spTxt$ + Chr$(13);                       'send data with CR added
    Settick 15000,PUM_RxTimeout,2                     'initiate Rx Timeout (15 secs)
    
  end sub
  
  sub UPSTxtYInc(ipIncType,ipCustomAmt)
    'increments the upsTxtY pointer based on the IncType requested
    '
    'IncType: 0 - standard line spacing (Font Height + 2)
    '         1 - paragraph line spacing (Font Height + 7)
    '         2 - custom line spacing - ipCustomAmt increment
    
    If ipIncType=0 then
      upsTxtY=upsTxtY+(fH_Mnu+2)
      
    elseIf ipIncType=1 then
      upsTxtY=upsTxtY+(fH_Mnu+7)
      
    elseIf ipIncType=2 then
      upsTxtY=upsTxtY+ipCustomAmt
    endif
    
  end sub
  
  Sub UpdStatus(spTxt$,ipFlag)
    'displays a status message in the Upload Status window area.
    'ipFlag determines how the message is displayed
    '   0 = display at current upsTxtX & upsTxtY, updating upsTxtX to 1 char after the displayed msg
    '   1 = display at current upsTxtX & upsTxtY, then reset upsTxtX to start of line and inc upsTxtY to next line
    '   2 = display at current upsTxtX & upsTxtY, do NOT update either upsTxtX or upsTxtY
    '
    Local TxtLen=Len(spTxt$)
    
    TEXT upsTxtX,upsTxtY,spTxt$,LT,Fnt_Mnu,1,FCwh,RGB(Blue)
    
    select case ipFlag
      case 0
        upsTxtX=upsTxtX+(FW_Mnu*(TxtLen+1))           'advance X pointer to 1 char beyond the Status Text (same line) 
          
      Case 1
        upsTxtX=TxtX                                  'reset to left margin position (saved in TxtX)
        UPSTxtYInc(0)                                 'advance to next line
        
      case 2            
        'nothing to do      
    End Select
    
  End Sub
  
  Function WaitForResponse()
    'wait for the expected response to be received from the target MM
    'Expected response is determined by the current pumState.
    'The wait process can be interrupted by the RxTOutFlg being set
    'by the PUM_RxTimeout() interrupt handler. 
    '
    'Returns  1 = expected response received
    '        -1 = Rx Timeout occurred
    '        -2 = unexpected response received
    
    local TargetResp$, Ptr          
    
    RxData$=""                                        'ensure buffer is clear to start
    
    Do
      Pause 100                                       '100msec pause
      RxChars=LOC(#1)
      If RxChars > 0 then
        RxData$=RxData$ + Input$(255, #1)             'read up to 255 bytes from the Rx Buffer & append to RxData$
        'NOTE: No responses are expected to be longer than 255 characters,
        '===== so shouldn't cause a string length overflow in the RxData$ variable.
        
        'check for expected response to have been received
        'if not, wait from more data to arrive or the Rx Timeout to occur.
        Select Case pumState
          case 1                                      'sent ^C
            'check for 2 x Command Prompts returned: 1 for ^C, 1 for Cr
            TargetResp$=Chr$(13) + Chr$(10) + "> " + Chr$(13) + Chr$(10) + "> "
            If Instr(RxData$,TargetResp$) > 0 then
              'got expected response - exit now
              WaitForResponse=1
              Settick 0,0,2                           'cancel Rx Timeout
              exit Function
            Endif
            
          Case 5                                      'sent PRINT MM.DEVICE$: PRINT MM.VER
            'response will be: Command Echo/CrLf/Device Type/CrLf/MMBasic Ver/CrLf/>
            i=0
            do 
              Ptr=Instr(RxData$,Chr$(13))
              If Ptr > 0 then
                'found Cr - get text preceeding it
                If i=0 then
                  'first response into Resp1$
                  Resp1$=Left$(RxData$,Ptr-1)
                else  'i=1
                  'second response into Resp2$ & set i = 2
                  Resp2$=Left$(RxData$,Ptr-1)
                  i=2
                endif
                
                'increment Ptr to after the Cr or CrLf
                Ptr=Ptr+1                             'increment Ptr by 1
                If Ptr <= Len(RxData$) then
                  If Mid$(RxData$,Ptr,1)=Chr$(10) then
                    'check if char following Cr is a Lf - if so increment Ptr by another 1.
                    Ptr=Ptr+1
                  Endif
                Endif
                
                If i=0 then
                  If INstr(Ucase$(Resp1$),"MM.DEVICE:") then
                    'this is the Command echo 
                    'ignore it and leave i = 0
                    
                  elseif Instr(Ucase$(Resp1$),"MITE") Then
                    'this is the response to MM.DEVICE$
                    'leave it in Resp1$ and set i = 1
                    i=1
                  endif
                  
                  'remove the text up to Ptr from RxData$ (i.e to after the Cr or CrLf)
                  If Ptr < Len(RxData$) then
                    RxData$=Mid$(RxData$,Ptr)
                  else
                    RxData$=""
                  endif
                endif
              else
                'no Cr found in the rest of the response message
                'need to wait for more Rx data to arrive
                Exit Loop
              endif
              
              If i=2 then
                'all expected response data has been received now
                'set return value and exit
                WaitForResponse=1
                Settick 0,0,2                         'cancel Rx Timeout
                exit Function
              endif
            Loop 
            
          Case 10, 20                                 'Send CLS, Send NEW
            'check for 1 x Command Prompt returned
            TargetResp$=Chr$(13) + Chr$(10) + "> "
            If Instr(RxData$,TargetResp$) > 0 then
              'got expected response - exit now
              WaitForResponse=1
              Settick 0,0,2                           'cancel Rx Timeout
              exit Function
            Endif
            
          Case 15                                     'CrunchFile - not used here
            
          Case 30                                     'XModem Receive
            'check for 1 x NAK (0x15 / Decimal 21) - this signifies ready to receive XModem data
            If Len(RxData$) > 0 then
              If Instr(RxData$,Chr$(21)) > 0 then
                'got expected response - exit now
                WaitForResponse=1
                Settick 0,0,2                         'cancel Rx Timeout
                exit Function
              Endif
            EndIf
            
          Case 35                                     'XModem Data Block Transfer
            'expected response is ACK or NAK or possibly CAN
            If Len(RxData$) > 0 then
              if Left$(RxData$,1) = Chr$(6) then
                'response is ACK - successful transfer
                WaitForResponse=1
                
              ElseIf Left$(RxData$,1) = Chr$(21) then
                'response is NAK - failed transfer , retry up to retry limit
                WaitForResponse=-2
                
              Else  'only other expected response is CAN 0x18 - Cancel (Abort) transfer
                WaitForResponse=-3
              Endif
              
              Settick 0,0,2                           'cancel Rx Timeout
              exit Function
            EndIf
            
          Case 40                                     'XModem Transfer EOF (T3erminate transfer)
            'expected response is ACK
            If Len(RxData$) > 0 then
              if Left$(RxData$,1) = Chr$(6) then
                'response is ACK - successful transfer
                WaitForResponse=1
                Settick 0,0,2                         'cancel Rx Timeout
                exit Function
              Endif
            EndIf
            
          Case 45                                     'Saved nnnn bytes message
            'response will be: "Saved nnnn bytes"/CrLf> 
            Ptr=Instr(RxData$,Chr$(13))
            If Ptr > 0 then
              'found Cr - get text preceeding it
              Resp1$=Left$(RxData$,Ptr-1)
              WaitForResponse=1
              Settick 0,0,2                           'cancel Rx Timeout
              exit Function
            EndIf
            
          Case 90                                     'XMODEM Cancel
            'response should be "Error: Cancelled by remote" + CrLf + Cmd Prompt
            Ptr=Instr(RxData$,Chr$(13))
            If Ptr > 0 then
              'found Cr - get text preceeding it
              Resp1$=Left$(RxData$,Ptr-1)
              
              'we got a Cr - check if it is followed by Lf and Cmd Prompt
              'if so, then we know we have cancelled the XModem transfer
              'regardless of the message text we saved on Resp1$
              if Ptr+3 <= Len(RxData$) then
                If Mid$(RxData$,Ptr,4)=CHR$(13) + Chr$(10) + "> " then
                  'all expected response data has been received now
                  'set return value and exit
                  WaitForResponse=1
                  Settick 0,0,2                       'cancel Rx Timeout
                  exit Function
                endif
              endif
            Endif
            'no Cr yet - need to wait for more data or timeout
            
          Case ELse
        End Select
      Endif
      
      If RxTOutFlg then
        'Rx Timeout has occurred - set return value and exit
        WaitForResponse=-1
        exit Function
      endif
    Loop
    
  end Function
  
  Sub PUM_RxTimeout()
    'RxTimeout handler for the Program Upload process
    
    Settick 0,0,2                                     'stop the RxTimeout timer (#2)
    RxTOutFlg=1                                       'set the RxTimeout flag
    
  end sub
  
  Sub XModemSend()                               
    'upload the program file to the target MM via XModem protocol
    local FileLen,TotalBlocks,CurrentBlock,BlockNbr,OnesCompNbr,Retry,Work           
    Local XModemBuffer$,TotBlocks$          
    
    If XModemCancel(0) <> 1 then
      UpdStatus(GetStr(167),1)
      pumState=-1
      Exit Sub
    endif
    
    pumState=30
    UpdStatus(GetStr(177),0)
    
    OpenFile(pumCrnFN$,0,5)                           'open file and check for open error
    
    FileLen=LOF(#5)                                   'get file length (in bytes)
    
    TotalBlocks=FIX(FileLen/128)                      'calc # of blocks required to
    If (FileLen MOD 128) > 0 then                     'transfer the program file
      TotalBlocks=TotalBlocks+1                       'via XModem using 128 block size.
    endif
    TotBlocks$=Str$(TotalBlocks)
    UpdStatus("0 of " + TotBlocks$ + " blocks",2) 'update progress status
    
    'initiate XModem Receive on the target MM
    SendCommand("XMODEM RECEIVE ")                    'initiate XModem Receive
    Work=WaitForResponse()                            'should receive NAK to initiate transfer  
    If Work=-1 then
      UpdStatus(GetStr(178),1)
      UpdStatus(GetStr(167),1)
      pumState=-1
      Exit Sub
    endif
    
    pumState=35
    CurrentBlock=1
    
    Do
      'calculate Block Nbr and 1's Complement for the header
      BlockNbr=CurrentBlock                           'block nbr
      
      do While BlockNbr > 255                         'handle block numbers > 255
        BlockNbr=BlockNbr-256
      Loop
      
      OnesCompNbr=255-BlockNbr                        'calc 1's complement of the block nbr
      
      'build the XModem data block
      'start with Header: SOH + block Nbr + 1's Complement of Block Nbr
      XModemBuffer$=Chr$(1) + Chr$(BlockNbr) + Chr$(OnesCompNbr)
      'append 128 bytes of data
      XModemBuffer$=XModemBuffer$ + Input$(128,#5)    'read 128 bytes of data from program file
      
      If CurrentBlock=TotalBlocks then              
        'last block - may need to pad data out to 128 bytes with SUB (0x1A) chars
        Work=131-Len(XModemBuffer$)                   '128 data bytes + 3 byte header = 131 bytes
        If Work > 0 then
          'need padding for Work chars
          XModemBuffer$=XModemBuffer$+String$(Work,26)  'Decimal 26 = 0x1A (SUB char)
        endif
      Endif
      
      'calculate and attach the CheckSum value as byte 132
      XModemBuffer$=XModemBuffer$+XModemCSum(XModemBuffer$)
      'update progress status
      UpdStatus(Str$(CurrentBlock) + " of " + TotBlocks$ + " blocks",2)  'update progress status
      Retry=0
      Pause 20                                        'time to catch breath :-)
      
      do
        'send the XModem data block 
        RxTOutFlg=0                                   'ensure RxTimeout Flag is reset
        PRINT #1,XModemBuffer$;                       'send data - NOTE: NO Cr added
        Settick 15000,PUM_RxTimeout,2                 'initiate Rx Timeout - use 15 sec timeout for the data transfer
        Work=WaitForResponse()                        'should receive ACK to successful block transfer 
        
        If Work=1 then                                'response was ACK - move on to next block, unless last
          Exit Do
         
        ElseIf Work=-1 then                           'RxTimeout
          UpdStatus(GetStr(179),1)
          Work=XModemCancel(1)                        'attempt to cancel the in progress transfer
          pumState=-1
          Exit Sub 
            
        ElseIf Work=-2 then                           'response was NAK - retry up to retry limit
          Retry=Retry+1                               'increment Retry counter
          If Retry > 5 then 
            UpdStatus(GetStr(180),1)
            Work=XModemCancel(1)                      'attempt to cancel the in progress transfer
            pumState=-1
            Exit Sub 
          Endif
          
          Pause 100
          
        Else  'Work = -3  (Abort Transfer - Block  Number mismatch)
          UpdStatus(GetStr(181),1)
          Work=XModemCancel(1)                        'attempt to cancel the in progress transfer
          pumState=-1
          Exit Sub 
        endif 
      Loop
      
      If CurrentBlock=TotalBlocks then                'all blocks transferred - exit loop    
        exit do
      Endif
      
      CurrentBlock=CurrentBlock+1                     'increment block count
    Loop
    
    Close #5                                          'Close the program file on the SD Card
    UpdStatus("- done  (" + Str$(CurrentBlock) + " of " + TotBlocks$ + " blocks)",1)
    
    'send XModem EOF (End Of File)    
    pumState=40
    UpdStatus(GetStr(182),0)
    RxTOutFlg=0                                       'ensure RxTimeout Flag is reset
    PRINT #1,Chr$(4) + Chr$(4);                       'send data - 2 x EOT chars - NOTE: NO Cr added
    Settick 15000,PUM_RxTimeout,2                     'initiate Rx Timeout - use 15 sec timeout
    Work=WaitForResponse()                            'should receive ACK to EOT 
    
    If Work=1 then
      UpdStatus("- done",1)
    Else  'Work = -1
      UpdStatus(GetStr(178),1)
      pumState=-1
      Exit Sub
    endif
    
    pumState=45                                       'Program Data being saved
    UpdStatus(GetStr(183),0)
    RxTOutFlg=0                                       'ensure RxTimeout Flag is reset
    Settick 30000,PUM_RxTimeout,2                     'initiate Rx Timeout - use 30 sec timeout for data saving
    Work=WaitForResponse()                            'should receive "Saved nnnnnn bytes" message
    
    If Work=1 then
      UpdStatus(": " + Resp1$,1)
    Else  'Work = -1                                  'Timeout while waiting for "Saved nnnnnn bytes" message ????
      UpdStatus(GetStr(184),1)
      pumState=-1
      Exit Sub
    endif
    
    pumState=50                                       'Upload complete
    UpdStatus(GetStr(185),1)
    UpdStatus("",1)
    UpdStatus(GetStr(186),1)
    
  End Sub
  
  Function XModemCancel(ipDispOK)
    'send 6 x Ctrl-X (CAN) characters (0x18) + CR to terminate any previous XModem transfer
    
    pumState=90
    RxTOutFlg=0                                       'ensure RxTimeout Flag is reset
    PRINT #1,String$(6,24) + CHR$(13);                'send 6 x CAN (0x18, dec 24) chars + Cr
    Settick 61000,PUM_RxTimeout,2                     'initiate Rx Timeout (61 secs here !!!)
    XModemCancel=WaitForResponse()
    
    If XModemCancel=1 then
      if ipDispOk then
        UpdStatus(GetStr(187),1)
      endif
    else
      UpdStatus(GetStr(188),1)
    EndIf
    
  End Function

  Function XModemCSum(spData$) as String
    'calculate the XModem Check Sum value for the string specified via the spData$ argument.
    local MyCSum=0
    
    For i=1 to 131
      MyCSum=MyCSum+ASC(Mid$(spData$,i,1))
    next i
    
    XModemCSum=Chr$(MyCSum AND 255)                   'mask out all but Least Significant 8 bits
    
  End function  
'  
'  SUB XModemDebug(spBuff$)
'    'for debug - print content of the XmodemBuffer (spBuff$)
'    Local i, j, l, v, C$, H$           
'    
'    l=Len(spBuff$)
'    j=0
'    
'    C$="  0: "
'    H$="     "
'    
'    For i=1 to l
'      v=ASC(Mid$(spBuff$,i,1))
'       
'      If v < 32 then
'        'non-printable char - display as a space in the Char line
'        C$=C$ + "   "
'      Else
'        'printable - display char
'        C$=C$ + Mid$(spBuff$,i,1) + "  "
'      endif
'      
'      H$=H$ + Hex$(v,2) + " "
'      j=j+1
'      
'      if i MOD 16 = 0 then
'        ? C$
'        ? H$
'        C$=Str$(j,3) + ": "
'        H$="     "
'      Endif
'    Next i
'    
'    ? C$
'    ? H$
'    ? ""
'    
'  End sub
  
  '======================================================================================
  '     C R U N C H P R O G F I L E    F U N C T I O N S    &    S U B R O U T I N E S  =
  '======================================================================================
  
  Sub StandaloneCrunchFile(ipInitial)
    'prepares for the standalone version of the Program File Crunch process
    'providing opportunity to proceed or exit 
    'and displays details including Crunch statistics on completion.
    Local FC,X,Y,W,H,WorkX,Txt$            
    Local Work As Float
    
    If ipInitial then
      'setup the crunched file name
      i=Len(cpfFN$)
      cpfCrnFN$=Left$(cpfFN$,i-4) + "_Crunched.bas"
      
      'get info for the selected program file
      GetProgFileInfo(cpfFN$,cpfOLines,cpfOBytes) 
      
      'box height = ((fH_Mnu + 2) * 11) + 35 (10 text lines + 0.5 top & bottom + extra spaces (35 pixel rows))
      H=((fH_Mnu+2)*11)+35
      
    Else
      'box height = ((fH_Mnu + 2) * 12) + 30 (11 text lines + 0.5 top & bottom + extra spaces (30 pixel rows))
      H=((fH_Mnu+2)*12)+30
      
      Work=((cpfOBytes-cpfCBytes)/cpfOBytes)*100      '% Savings due to Crunch
    endif
    
    'calculate the size and position taking the requested font size into account.
    'box width =  fW_Mnu * 60  (60 chars - 56 text + 2 leading + 2 trailing)
    W=fW_Mnu*60
    'calc box left edge (X)
    X=(MM.HRES-W)\2
    'set box top (Y)
    Y=((opY+opH)-H)\2
    
    TxtX=X+(fW_Mnu*2)
    IndentX=X+(fW_Mnu*4)
    TxtY=Y+(fH_Mnu\2)
    
    'draw the box and display the text, etc in it
    RBOX X,Y,W,H,10,FCblk,BC210
    
    Txt$=GetStr(140)                                                          '0
    WorkX=TxtX
    FC=FCblk
    
    for i=0 to 12
      If Txt$ <> "" then
        Text WorkX,TxtY,Txt$,LT,Fnt_Mnu,1,FC,BC210
      endif
      
      Txt$=""
      WorkX=IndentX
      
      Select Case i
        Case 0
          If Not ipInitial then                       'on completion
            Txt$=GetStr(143)
            WorkX=TxtX+fW_Mnu*37
            Fc=RGB(Red)
          endif
        Case 1
          TxtYInc(0)
          Line TxtX,TxtY,TxtX+fW_Mnu*32,TxtY,1,FCblk
          TxtYInc(2,10)
          TxT$=GetStr(145)                            'Selected File Details:
          WorkX=TxtX
          FC=FCblk
        Case 2
          Txt$=GetStr(146,PROGDIR$)
        Case 3
          Txt$=GetStr(147,Left$(cpfFN$,43))
        Case 4
          Txt$=GetStr(148,Str$(cpfOlines),Str$(cpfOBytes))
        Case 5
          TxtYInc(2, 10)
          WorkX=TxtX
          Txt$=GetStr(149)                            'Crunched File Details:
        Case 6
          Txt$=GetStr(146,PROGDIR$)
        Case 7
          Txt$=GetStr(147,Left$(cpfCrnFN$,43))
        Case 8                                        
          If not ipInitial then
            TxtYInc(0)
            Txt$=GetStr(148,Str$(cpfCLines),Str$(cpfCBytes)) 
          endif
        Case 9                                        
          If not ipInitial then
            TxtYInc(0)
            Txt$=GetStr(150,Str$(Work,1,1),Str$(cpfElapTi/1000,1,2)) 'Crunch Results
          Endif
        Case 10
          TxtYInc(0)
          TxtYInc(2, 10)
          WorkX=TxtX
          If ipInitial then
            Txt$=GetStr(151)
          else
            Txt$=GetStr(153)
          endif
        Case 11
          If ipInitial then
            TxtYInc(1)
            WorkX=TxtX
            Txt$=GetStr(152)
          Endif
      End Select
      
      If i > 1 And i < 8 Then TxtYInc(0)
    next i  
    
  end sub
  
  sub DoCrunch()
    'initiate the standalone Program File Crunch
    
    CrunchFile(cpfFN$,cpfCrnFN$,cpfOLines,cpfOBytes,cpfCLines,cpfCBytes,cpfElapTi)
    cpfDone=1                                         'set the Done flag
    StandaloneCrunchFile(0)                           're-display screen with crunch statistics
    
  end sub
  
  Sub CrunchFile(spFN$,spCrunchedFN$,ipOL,ipOB,ipCL,ipCB,ipTi)
    'reads the program file, creating a "crunched" version
    'that is then used for the upload to the target MM
    Local InString,IgnoreLine,i,j,k,L,m,v,mbX,mbY,SaveTi,ProgBytes,Prog,ProgCnt
    'Note: using upper case L for Length as lower case l looks too much like numeric 1.
    Local Rec$
    
    If MM.Device$="Micromite Plus" then               'MM+ device running this code
      CPU 120                                         '- use fast CPU for this code !!!
      Pause 50
    Endif
    
    SaveTi=timer
    
    OpenFile(spFN$,0,5)                               'open file and check for open error
    
    OpenFile(spCrunchedFN$,1,6)                       'open file and check for open error
    
    ipOL=0
    ipCL=0
    
    if Mode=55 then                                   'Upload Crunch
      UpdStatus("- please wait",2)
    else                                              'Standalone Crunch
      mbX=MM.HRES\2
      mbY=(opY+opH)\2
      MessageBox(mbX,mbY,GetStr(169),GetStr(170),String$(20," "),"",0,FCwh,BCblu)
    endif
    
    ProgBytes=LOF(#5)\6
    Prog=ProgBytes
    ProgCnt=1
    m=0
    do
      Line Input #5,Rec$                              'read 1 record from the file
      ipOL=ipOL+1                                     'count Original File Lines (records)
      L=Len(Rec$)                                     'length of this line
      m=m+L                                           'accumulate length processed so far
      
      If m > Prog then
        'time for progress update
        If Mode=55 then                               'Upload Crunch
          UpdStatus("- please wait" + String$(ProgCnt,"."),2)
        else                                          'Standalone Crunch
        MessageBox(mbX,mbY,GetStr(169),GetStr(170) + " " + String$(ProgCnt,"."),String$(20," "),"",0,FCwh,BCblu)
        endif
        Prog=Prog+ProgBytes
        ProgCnt=ProgCnt+1
      endif
      
      If L=0 then                                     'empty line - ignore
        IgnoreLine=1
      Else
        i=1
        InString=0
        IgnoreLine=0
      endif
      
      If IgnoreLine=0 then
        'find the first char with ascii value > 32 on this line
        '- this skips any leading control characters AND spaces!
        do                                            'scan line from left to right
          v=ASC(Mid$(Rec$,i,1))
          
          If v > 32 then
            'not a control char or Space
            If v=39 then
              '= single quote char - whole line is a comment, ignore
              IgnoreLine=1
              exit do
            endif
            
            If i+3 <= L then
              'check for "REM " as comment keyword
              If UCASE$(MID$(Rec$,i,4))="REM " then
                'REM - whole line is a comment, ignore
                IgnoreLine=1
                exit do
              endif
              
            ELSEIf i+2=L then
              'check for "REM" as the only and last characters on the line
              If UCASE$(MID$(Rec$,i,3))="REM" then
                'REM - whole line is a comment, ignore
                IgnoreLine=1
                exit do
              endif
            endif
            
            If i > 1 then
              'not a comment line, delete chars up to first alphanumeric
              Rec$=Mid$(Rec$,i)
              'we have altered the line content, so reset the pointer
              'to the start and recalculate the line length
              i=1
              L=LEN(Rec$)
            endif
            
            exit do
          endif
          
          i=i+1   'increment character pointer
          
          if i > L then
            'reached end of line, found nothing - blank line, so ignore
            IgnoreLine=1
            Exit Do
          endif
        Loop
        
        If IgnoreLine=0 then  'a line we want -
          'we have removed any leading spaces on this line, now need to
          'check the modified line for trailing comments and/or spaces.
          i=1
          'first see if there is potentially a comment on this line
          j=Instr(Rec$,Chr$(39))                      'look for single quote
          
          If j=0 then
            'no single quote, check for "REM " keyword
            j=Instr(UCase$(Rec$),"REM ")
            
            If j=0 Then
              'no "REM " keyword, check for "REM" (no trailing space)
              'as the last 3 chars on the line
              If RIGHT$(UCASE$(Rec$),3)="REM" Then
                j=L-3
              endif
            endif
          endif
          
          If j > 0 then
            'a comment potentially exists on this line, so check if there is
            'a double quote on the line indicating the possible presence of a string.
            k=Instr(Rec$,CHR$(34))
            
            If k > 0 Then
              'comment exists AND a double quote (string) exists -
              'the comment character or keyword **MAY** be part of
              'a string and would therefore not be a comment!
              'Scan the line character by character to see what is where
              do
                v=ASC(MID$(Rec$,i,1))
                
                if v=34 then
                  'found double quote - start or end of a literal string
                  '- toggle the InString flag
                  InString = NOT InString
                endif  
                
                If InString=0 Then
                  'currently NOT in a string, so check for comments
                  If v=39 Then
                    'single quote - remainder of the line is a comment, truncate
                    exit do
                    
                  ElseIf v=82 or v=114 then
                    'this char is "R" or "r" - check for REM/rem
                    If i+3 <= L then
                      'check for "REM " as comment keyword
                      If UCASE$(MID$(Rec$,i,4))="REM " then
                        'REM - remainder of the line is a comment, truncate
                        exit do
                      endif
                      
                    Elseif i+2=L then
                      'check for "REM" as the only and last characters on the line
                      If UCASE$(MID$(Rec$,i,3))="REM" then
                        'REM - remainder of the line is a comment, truncate
                        exit do
                      endif
                    endif
                  endif
                Endif
                
                i=i+1                                 'increment character pointer
                
                if i > L then
                  'reached end of line - exit loop
                  Exit Do
                endif
              Loop
              
            else  'k=0
              'no string(s) on this line, so comment is confirmed
              'set index for the start of the comment
              i=j
            endif
            
            if i <= L then
              'we found a confirmed comment, starting at the current value of i.
              'Truncate off the remainder of the line
              Rec$=Left$(Rec$,i-1)
              'line content has altered, recalculate the line length
              L=LEN(Rec$)
            endif
          Else  'j=0
            'no comment exists on this line so don't need to look for one.
          endif
          
          'finally reverse scan to see if there are trailing spaces left behind
          for i=L to 1 Step -1
            If MID$(Rec$,i,1) <> " " then
              'not a Space so this is the new End Of Line -
              'truncate anything to the right of the present position.
              If i < L then
                'truncate off the trailing spaces
                Rec$=LEFT$(Rec$,i)
              endif
              
              Exit For
            endif
          next i
          
          'now write what is left of this record to the Crunched file
          If ipCL=0 then
            'first line - don't need CrLf terminating the previous line
            Print #6,Rec$;
          else
            'subsequent lines - need preceeding CrLf to terminate previous line
            Print #6,CHR$(13) + CHR$(10) + Rec$;
          Endif
          
          ipCL=ipCL+1                                 'increment count of Crunched File Lines (records)
        Endif
      Endif
      
      If EOF(#5) then
        'reached end of file - exit the processing loop
        exit Do
      Endif
    Loop
    
    ipOB=LOF(#5)                                      'Original File Length
    ipCB=LOF(#6)                                      'Crunched File Length
    ipTi=Timer-SaveTi                                 'Elapsed Time (milliSecs)
    
    Close #5, #6                                      'Close both files
    
    If MM.Device$="Micromite Plus" then               'MM+ device running this code
      CPU 100                                         'back to default CPU speed
      Pause 50
    Endif
    
  END SUB
  
  '=================================================================================
  '     L I T E    E D I T O R    F U N C T I O N S    &    S U B R O U T I N E S
  '=================================================================================
  
  Function ProgramEdit()
    'controls setup for editing the selected program file.
    Local MaxRecLen,RecNbr,PassNbr,CurrPtr,Rec$        
    
    ProgramEdit=1                                     'default return value - successful
    DrawEditScreen                                    'draw the Program Edit screen layout
    
    Text MM.Hres\2,mm.VRES\2,GetStr(191),CM,Fnt_Out,1,FCwh,BCblk
    
    PassNbr=1
    RecNbr=0
    CurrPtr=0
    edModFlg=0                                        'reset File Modified Flag.
    'Pass #1 determines the record count in the selected program file
    On Error Skip 1
    Close #8                                          'in case we come here a second time!
    OpenFile(edFN$,3,8)                               'open file and check for open error

    Seek #8, 0                                        'set file pointer to start at beginning
    
    Do
      Do
        Line Input #8,Rec$
        
        If PassNbr=1 then
          If EOF(#8) then                             'reached end of file
            If CurrPtr < LOF(#8) then                 'last record is not empty
              RecNbr=RecNbr+1                         'so count it
            endif
            edRecCount=RecNbr                         'save record count
            exit do
          endif
          
          'track the maximum record length
          MaxRecLen=MAX(MaxRecLen,LEN(Rec$))
          
          If RecNbr MOD 500=0 then NotifyWait(1)      'Blink '*LOADING*' status msg (top left on screen)
        endif
        
        'the LOC(#8) pointer AFTER the LINE INPUT stmt (above) will point to the start of the NEXT record
        CurrPtr=Loc(#8)
        RecNbr=RecNbr+1                               'increment record nbr to next record
        
        If PassNbr=2 then
          'build the edRecTrak entry for this record
          PutBit4(edRecTrak(RecNbr),1)                'set State = Original
          PutInt12(edRecTrak(RecNbr),0,RecNbr+1)      'set Fwd Link (points to next entry)
          PutInt12(edRecTrak(RecNbr),1,RecNbr-1)      'set Bwd Link (points to Prev entry)
          PutInt16(edRecTrak(RecNbr),0)               'set Pointer to UpdRec temp file = 0 (not used yet)
          PutInt20(edRecTrak(RecNbr),CurrPtr)         'set File Offset for this rec
          
          If RecNbr=edRecCount then                   'processed the last record in the file
            PutInt12(edRecTrak(RecNbr),0,0)           'set Fwd Link in the current array entry = 0 (end of list)
            exit do                                   'exit inner loop now
          endif                  
          
          If RecNbr MOD 50=0 then 
            NotifyWait(1)                             'Blink '*LOADING*' status msg (top left on screen)
            UpdEditSBPanel(6,Str$(RecNbr))            'Progress record count
          endif
        endif
      Loop
      
      If PassNbr=1 Then 
        If edRecCount > EDMAXRECS% then               'Program file is too big (too many records)
          MessageBox(MM.HRES\2,opY+opH\2,GetStr(237),GetStr(238,Str$(edRecCount)),GetStr(239),GetStr(240,STR$(EDMAXRECS%)),1,FCerr,BCerr)
          ProgramEdit=0                               'return value = error encountered
          NotifyWait(0)                               'reset NotifyWait    
          exit function                               'exit now
        endif
        
        If MaxRecLen > EDMAXRECSZ% then               'Program file max record length is too long
          MessageBox(MM.HRES\2,opY+opH\2,GetStr(241),GetStr(242,Str$(MaxRecLen)),GetStr(243),GetStr(244,STR$(EDMAXRECSZ%)),1,FCerr,BCerr)
          ProgramEdit=0                               'return value = error encountered
          NotifyWait(0)                               'reset NotifyWait    
          exit function                               'exit now
        endif
      endif
      
      If PassNbr=2 then      
        'end of second pass - exit outer loop now
        Exit Do
      Endif
      
      'setup for the second Pass
      PassNbr=2
      'create a global Integer array with sufficient entries for the # of records in the file
      '+ EDMAXUPDS% additional entries for tracking modified or inserted records. 
      '
      'This array is setup as a Linked List and is used to track the State, 
      'Byte Offset in the file for the start of each record and the
      'Pointer to the New/Modified records data array entry (when one exists).
      'Note: need to ERASE any existing instance of this array variable first
      '-----
      On Error skip 1
      Erase edRecTrak()
      on Error Clear
      'now DIM the new array instance with the number of 
      'elements = # of records in the file (edRecCount - already determined) 
      'plus the EDMAXUPDS% (allowed updates) value.
      dim edRecTrak(edRecCount+EDMAXUPDS%)           
      
      'The array is organised as a bi-directional Linked List with 
      'a Forward and a Backward Link in each element and is used to 
      'track the State, Byte Offset in the original file for the start 
      'of each original record and the Byte Offset in the UpdRec 
      'temporary file for the start of each Modified or Inserted record.
      '
      'Note:  each 64-bit (INTEGER) element is used to store 5 values :-
      '=====    1 x 20-bit + 1 x 16-bit + 2 x 12-bit & 1 x 4-bit integer 
      '         values packed into the 64-bits.
      '
      'Values tracked via this array are:-
      '       1. Record State     - 4-bit int   0=Unused, 1=Original, 2=Modified, 3=Inserted, 4=Deleted
      '       2. Forward Link     - 12-bit int  index of next linked array entry (forward direction)
      '       3. Backward Link    - 12-bit int  index of the preceeding linked array entry (backward direction)
      '       4. Upd array index  - 16-bit int  byte offset into the UpdRec temporary file used to store 
      '                                             modified and new (inserted) records 
      '       5. File pointer     - 20-bit int  byte offset in the original file for the start of each
      '                                             original file record
      '
      'reset the file pointer to the start of the file for Pass #2
      Seek #8, 0
      'Pass #2 initializes the edRecTrak array by reading through the
      'program file again, recording the byte offset for the start of each record, 
      'setting the State = 1 (original) and building the Linked List Fwd/Bwd link pointers
      RecNbr=1
      edStart=RecNbr                                  'save starting pointer
      'initialize the first edRecTrak entry
      PutBit4(edRecTrak(RecNbr),1)                    'set State = Original
      PutInt12(edRecTrak(RecNbr),0,2)                 'set Fwd Link (points to entry at index 2)
      PutInt12(edRecTrak(RecNbr),1,0)                 'set Bwd Link (end of list - points to 0)
      PutInt16(edRecTrak(RecNbr),0)                   'set Pointer to UpdRec temp file = 0 (not used yet)
      PutInt20(edRecTrak(RecNbr),1)                   'set File Offset for this rec - 1 for first rec
    Loop
    
    NotifyWait(0)                                     'clear the '*LOADING*' status message
    
    edEnd=RecNbr                                      'save ending pointer
    edNewIdx=edRecCount+1                             'save index of the first extra edRecTrak record (for inserted records)
    
    CreateUpdFile()                                   'create and open the temp UpdRec file
    
    UpdEditSBPanel(6,Str$(RecNbr))
    edPrevCuRow=0                                     'initial settings
    edPrevCuCol=-1
    edCuRow=0
    edCuCol=0
    edHLRow=-1                                        'no Find Match highlighting at present
    edHLPos=-1
    DisplayEditLines(1,edStart)                       'display the first Edit screen of data
    
  end Function
  
  sub DrawEditScreen()
    'draws the screen layout used for Program Edit mode
    
    CLS BCblu
    TEXT mm.HRES\2,0,GetStr(190,ProgVer$),CT,2,1,FCwh,BCblu
    InsertMode=1                                      'start in Insert mode
    edUpdWarnState=0                                  'start in Warning State 0
    DrawStatusBar()
        
    'draw and initialize the Status Bar text panels (except Date & Time - already done)
    UpdEditSBPanel(1,edFN$)                    
    UpdEditSBPanel(2,"")
    UpdEditSBPanel(3,"1")
    UpdEditSBPanel(4,"1")
    UpdEditSBPanel(5,"1")
    UpdEditSBPanel(6,"0")
    UpdEditSBPanel(7,"0")
    
    'set size, position and other parameters for the Edit window
    edY=24                                            'Edit window top
    edH=(sbY-edY)-5                                   'Edit window height
    edMaxLines=edH\(fH_In+5)                          'Input font height + 5 pixels per line in the Output window
    edMaxChars=(mm.HRes-20)\fW_In                     'should be 78 chars
    edMaxTxt=EdMaxChars-7                             'max text chars per line excluding Rec Nbr
    edHScrlInc=59                                     'Horizontal scroll step value
    edPrevStartPos=1
    edStartPos=1                                      'Start display from leftmost char of record
    
    DrawEditWindow()
    
  end sub
  
  sub DrawEditWindow()
    'draw the Edit window
    Box 5,edY,(MM.HRes-10),edH,1,FCOut%,BCOut%        
    'draw the Line Nbr background box on the left side
    Box 6,edY+1,fW_In*6,edH-2,0,0,BC50
    
  end sub
  
  sub ExitEditor()
    'exit the Program File Editor
    
    NotifyWait(0)                                     'clear Notify Wait msg - just to be sure!
    
    On Error Skip 1
    Close #8                                          'ensure Program File is closed
    
    On Error Skip 1
    Close #9                                          'ensure Temporary UpdRec File is closed
    
    On error skip 1
    Kill edUpdFN$                                     'delete the temporary UpdRec file
    
    
    On Error SKIP 1
    Erase edRecTrak()                                 'erase RecTrak array
    
    edTargCuCol=-1                                    'clear Target Cursor Column
    edHLRow=-1                                        'clear Find HiLite trigger
    
    'exiting this mode - Note the Mode switch:
    Mode=0                                            'switch to Normal Mode 
    DrawScreen_Normal(0)                              're-draw the Normal Mode screen layout 
    UpdConsRxLock(0)                                  'disable Console Rx Lock
    
  End sub
  
  sub NotifyWait(ipState)
    'display a flashing message in top left of screen while
    'loading a file into the Editor, or searching for a Find match.
    Local FC,Txt$
    STATIC OnOff
    
    Txt$="           "
    If ipState=1 then Txt$=" *LOADING* "
    If ipState=2 then Txt$="*SEARCHING*"
    Fc=FCwh
    If ipState=0 Or OnOff Then FC=BCblu
    Text 3,5,Txt$,LT,Fnt_In,1,FC,BCblu
    If ipState=0 then OnOff=0 Else OnOff=NOT OnOff    'Reset or Toggle On/Off setting for Blink
    
  end Sub
  
  sub UpdEditSBPanel(ipWhich,spCaption$)
    'draw/clear the specified panel, and update the caption displayed in it
    '
    'Status Bar Panel Parameters
    '=============================
    ' sbp1X |   5 | sbp5X | 471 |
    '-------+-----|-------+-----|
    ' sbp1W | 310 | sbp5W |  40 |
    '-------+-----|-------+-----|
    ' sbp1C |   - | sbp5C | 491 |
    '-------+-----|-------+-----|
    ' sbp2X | 320 | sbp6X | 516 |
    '-------+-----|-------+-----|
    ' sbp2W |  72 | sbp6W |  48 |
    '-------+-----|-------+-----|
    ' sbp2C | 356 | sbp6C | 540 |
    '-------+-----|-------+-----|
    ' sbp3X | 397 | sbp7X | 569 |
    '-------+-----|-------+-----|
    ' sbp3W |  32 | sbp7W |  40 |
    '-------+-----|-------+-----|
    ' sbp3C | 413 | sbp7C | 589 |
    '-------+-----|-------+-----|
    ' sbp4X | 434 |       |     |
    '-------+-----|-------+-----|
    ' sbp4W |  32 |       |     |
    '-------+-----|-------+-----|
    ' sbp4C | 450 |       |     |
    '----------------------------
    
    Local FC,BC,AutoCaption$          
    
    Select case ipWhich
      Case 1                                          'Log File Name panel
        box 5,sbpY,310,sbpH,0,0,BC190                 'draw/re-draw empty panel
        Text 8,sbpTextY,"File: " + Left$(spCaption$, 32),LT,1,1,FCblk,BC190
        
      case 2                                          'Insert/Replace mode
        if InsertMode then
          AutoCaption$="Insert"
        Else
          AutoCaption$="Replace"
        Endif
        box 320,sbpY,72,sbpH,0,0,BC190
        Text 356,sbpTextY,AutoCaption$,CT,1,1,FCblk,BC190
        
      Case 3                                          'Current line number (for cursor line - screen relative) 
        box 397,sbpY,32,sbpH,0,0,BC190
        Text 413,sbpTextY,spCaption$,CT,1,1,FCblk,BC190
       
      Case 4                                          'HScroll value
        box 434,sbpY,32,sbpH,0,0,BC190
        Text 450,sbpTextY,spCaption$,CT,1,1,FCblk,BC190
       
      Case 5                                          'Char pos within record for Current Cursor pos
        box 471,sbpY,40,sbpH,0,0,BC190
        Text 491,sbpTextY,spCaption$,CT,1,1,FCblk,BC190
       
      Case 6                                          'File Length (in records)
        box 516,sbpY,48,sbpH,0,0,BC190
        Text 540,sbpTextY,spCaption$,CT,1,1,FCblk,BC190
       
      Case 7                                          'Pending Updates count
        FC=FCblk
        BC=RGB(Green)
        
        Select Case edUpdWarnState                    'set background colour based on Warning State
          Case 1
            BC=RGB(Yellow)
          Case 2
            BC=&HFF8C00                               'Dark Orange
          Case 3
            FC=FCwh
            BC=RGB(Red)
        End Select
        
        box 569,sbpY,40,sbpH,0,0,BC
        Text 589,sbpTextY,spCaption$,CT,1,1,FC,BC
        
    End Select
    
  end sub
  
  Function ChkUpdWarn()
    'checked whether to display a warning message regarding the
    'number of updates left before reaching the Maximum allowed.
    'Also updates the Warning State.
    '
    'Returns: 0 = no message box displayed
    '         1 = message box displayed (will need to be cleared)
    
    Local FC,BC,SC,S1,WT
    FC=FCblk
    ChkUpdWarn=0                                      'default return value
    
    if edUpdCnt >= EDMAXUPDS%-edUpdWarn then
      SC=256
      S1=257
      WT=edUpdWarn
      ChkUpdWarn=1                                    'Return value = 1 - msg box being displayed
      
      Select Case edUpdWarnState
        Case 0                                        'State = 0 (no current warning)
          'change to next state and issue first warning
          edUpdWarnState=1
          edUpdWarn=EDUPDWARNSTEP%                    'set next warning threshold (1x)
          BC=RGB(Yellow)
          
        Case 1                                        'State = 1 (first warning active)
          'change to next state and issue second warning
          edUpdWarnState=2
          edUpdWarn=0                                 'set next warning threshold (@max)
          BC=&HFF8C00                                 'Dark Orange
          
        Case 2                                        'State = 2 (second warning active)
          'change to next state and issue file is now READ ONLY message
          edUpdWarnState=3                            'change to State = 3 (Read Only)
          edUpdWarn=0
          FC=FCwh
          BC=RGB(RED)
          SC=258
          S1=259
          
        case 3                                        'State = 3 (file is READ ONLY, no updates allowed)
          Beep()
          FC=FCerr
          BC=BCerr
          SC=226
          S1=227
      end select
    endif
    
    If SC>0 then MessageBox(MM.HRES\2,opY+opH\2,GetStr(SC),GetStr(S1, Str$(WT)),GetStr(228),GetStr(229),1,FC,BC)
    
  end Function
  
  Sub CreateUpdFile()
    'create the temporary UpdRec file used while editing to store
    'data for modified and/or inserted records.
    
    'assign file name to the temporary UpdRec files
    edUpdFN$=TEMPDIR$ + "/Upd_" + Str$(Timer) + ".tmp"
    OpenFile(edUpdFN$,3,9)                            'open the temp file and check for open error
    
    edUpdPtr=1                                        'set pointer to start of first record
    edUpdCnt=0                                        'set # of records in the file
    edUpdWarn= EDUPDWARNSTEP% * 2                     'first edit updates left warning at 2x the Step value
    edUpdWarnState=0                                  'start in Warning State 0
    
  End Sub
  
  Sub WriteUpdFile(ipRecIdx,spTxt$)
    'write the modified record data (passed as spTxt$) to the temp UpdRec file.
    'to preserve any trailing spaces in the modified record
    'an ETB (CHR$(23) is appended to the record, unless the modified 
    'record is already 120 bytes long and the 120th byte is a space.
    'The ETB will be stripped off when the record is retrieved - see GetRec(..)
    Local UpdTxt$=spTxt$
    
    If Len(spTxt$) < 120 then
      UpdTxt$=spTxt$ + Chr$(23)                       'append ETB to end of record
      
    else  'LEN(spTxt$)=120
      if right$(spTxt$,1)=" " then                    '120th byte is a space -
        UpdTxt$=left$(spTxt$,119) + Chr$(23)          'replace with ETB
      endif
    endif
    
    Seek #9,GetInt16(edRecTrak(ipRecIdx))             'position to required record offset
    Print #9,UpdTxt$ + String$(EDMAXRECSZ%-LEN(UpdTxt$)," ")  'write data as a fixed length record
    
  end sub

  sub DisplayEditLines(ipRecNbr,ipRecIdx)
    'build the Edit screen display lines based on the supplied starting position arguments
    Local Ln,RecIdx,RecNbr,State,Rec$           
    
    DrawEditWindow()                                  'clear the previous data from the Edit Window
    edPrevHLRow=-1
    LnPtrX=fW_In
    TxtX=fW_In*2
    IndentX=fW_In*7
    
    'Declare a global array 1 Integer x edMaxLines to store the RecIdx values
    'for each line currently displayed in the Edit Window. This needs to be
    'global so it can be used by other subs/functions.
    'First erase any existing instance of this array.
    on error skip 1
    erase edLnPtrs()
    'now declare a new instance
    dim edLnPtrs(edMaxLines)                          'Integer array with edMaxLines elements
    
    Ln=0
    RecIdx=ipRecIdx                                   'set working values
    RecNbr=ipRecNbr
    edStrtRec=ipRecNbr                                'save these for potential
    edStrtIdx=ipRecIdx                                'refresh of this screen if scrolled
    TxtY=edY+5                                        'calc top (Y) for the top text line
    
    do
      Rec$=GetRec(RecIdx,State)                       'get the record data & state
      
      If State=0 then
        'OOPS!!! what happened here ????
        ? GetStr(192,Str$(ipRecNbr+Ln),Str$(RecIdx))
        exit sub
        
      ElseIf State<>4 then                            'not deleted line -
        Text TxtX,TxtY,STR$(RecNbr,4),LT,Fnt_In,1,FCwh,BC50 'Record Nbr
        
        If edStartPos < LEN(Rec$) then                'display if the text is long enough to be visible
          Text IndentX,TxtY,Mid$(Rec$,edStartPos,edMaxTxt),LT,Fnt_In,1,FCOut%,BCOut%
        endif
        
        If Ln=edCuRow then                            'this will be the Current Row
          edCurrRec=ipRecNbr+Ln                       'so save Current RecNbr,
          edCurrIdx=RecIdx                            'RecIdx,
          edRec$=Rec$                                 'line content and
          edState=State                               'State value for this line
          
          If edTargCuCol<>-1 then                     'set Cursor column to Target or End of Line      
            edCuCol=MIN(edTargCuCol,((Len(edRec$)-edStartPos)+1))
          endif
        endif
        
        edLnPtrs(Ln)=RecIdx                           'save RecIdx for this line in the edLnPtrs array
        edEndRec=RecNbr                               'save the End Rec and Ptr values
        edEndIdx=RecIdx
        TxtY=TxtY+fH_In+5                             'move down 1 line
        RecNbr=RecNbr+1
        
        if Ln=edHLRow Then ShowHiLite()               'highlight Find Target text on this line
        Ln=Ln+1                                       'increment Line nbr
      endif
      
      'find the index of the next record
      RecIdx=GetRecTrakPtr(RecIdx,1,0)                'get next Fwd Link value, skipping any deleted recs
      
      If RecIdx=0 OR Ln=edMaxLines then               
        'reached Start/End of file or filled this screen
        Exit Do                                       'exit the loop now
      endif
    Loop
    
    MoveCursor_Edit()    
    UpdEditSBPanel(4,Str$(edStartPos))                'HScroll value
    UpdEditSBPanel(6,Str$(edRecCount))                'Record Count
    UpdEditSBPanel(7,STR$(edUpdCnt))                  'Count of Updates made
    
  End Sub

  Sub MoveCursor_Edit()
    'move the Edit cursor to a new position, optionally clearing the previous cursor
    lOCAL cuX,cuY           
    
    If InsertMode Then                                'insert mode cursor = vertical bar
      If edPrevCuCol > -1 then
        'clear the previous cursor
        cuY=edY+((fH_In+5)*edPrevCuRow)+5
        cuX=(fW_In*(7+edPrevCuCol))-1
        Line cuX,cuY-1,cuX,cuY+fH_In,2,BCblk
      Endif
      
      if edCuCol > -1 then                            'don't show the cursor if it is off screen
        'draw the new cursor
        cuY=edY+((fH_In+5)*edCuRow)+5
        cuX=(fW_In*(7+edCuCol))-1
        Line cuX,cuY-1,cuX,cuY+fH_In,2,cuFC
      endif
      
    Else                                              'overwrite mode cursor = underline
      If edPrevCuCol > -1 then
        'clear the previous cursor
        cuY=edY+((fH_In+5)*(edPrevCuRow+1))
        cuX=(fW_In*(7+edPrevCuCol))
        Line cuX,cuY,cuX+fW_In,cuY,2,BCblk
      endif
      
      if edCuCol > -1 then                            'don't show the cursor if it is off screen
        'draw the new cursor
        cuY=edY+((fH_In+5)*(edCuRow+1))
        cuX=(fW_In*(7+edCuCol))
        Line cuX,cuY,cuX+fW_In,cuY,2,cuFC
      endif
    endif
    
    'clear the previous row indicator
    text LnPtrX,edY+((fH_In+5)*edPrevCuRow)+5,Chr$(127),LT,Fnt_In,1,BC50,BC50 
    'display/redisplay the current row indicator
    text LnPtrX,edY+((fH_In+5)*edCuRow)+5,Chr$(127),LT,Fnt_In,1,cuFC,BC50 
    
    edPrevCuRow=edCuRow
    edPrevCuCol=edCuCol
    UpdEditSBPanel(3,STR$(edCuRow+1))                 'display as 1 relative (per screen, not total file)
    UpdEditSBPanel(5,STR$(edCuCol+edStartPos))        'current char pos within the record
    
  End sub
  
  sub UpdateEditLine()
    'update the displayed text for the current line when no Horizontal scrolling is required.    
    
    TxtY=edY+((fH_In+5)*edCuRow)+5                    'calc Y coordinate for current row
    box IndentX-2,TxtY-2,MM.HRES-74,fH_In+5,0,0,0     'clear all data on the line
    edPrevCuCol=-1                                    'don't need to clear prev cursor    
    Text IndentX,TxtY,Mid$(edRec$,edStartPos,edMaxTxt),LT,Fnt_In,1,FCOut%,BCOut%
    If edCuRow=edHLRow then ShowHiLite()              'redisplay Find HiLite if required.
    MoveCursor_Edit()
    UpdEditSBPanel(4,Str$(edStartPos))                'HScroll value
    
  End sub
  
  FUNCTION MoveCursor_UpDown(ipDirn)
    'move the cursor 1 row up or down
    'ipDirn - 0 = Down
    '       - 1 = Up
    Local RowInc,Idx           
    
    IF ipDirn=0 then                                  'Down
      RowInc=1                                        'increment cursor row
      
    else                                              'Up  
      RowInc=-1                                       'decrement cursor row 
    Endif
    
    'get edRecTrak pointer for the line we are about to move to
    Idx=GetRecTrakPtr(edCurrIdx,ABS(RowInc),ipDirn)
    
    If Idx=0 then
      'next line is not valid - either before Start of File or after End of File
      MoveCursor_UpDown=0                             'return value = 0 (failed)
      
    else  'ok to move
      edPrevCuRow=edCuRow
      edCuRow=edCuRow+RowInc                          'increment/decrement row
      edCurrRec=edStrtRec+edCuRow                     'calc Rec Nbr for the new line
      edCurrIdx=Idx                                   'get edRecTrak index for the new line
      edRec$=GetRec(edCurrIdx,edState)                'get data (and State) for new record
      
      If edTargCuCol<>-1 then                         'set Cursor column to Target or End of Line      
        edCuCol=MIN(edTargCuCol,((Len(edRec$)-edStartPos)+1))
      endif
      
      MoveCursor_UpDown=1                             'return value = 1 (success)
    endif
    
  end Function
  
  Sub HideCursor_Edit()
    'hide the Edit Cursor (used while in GetSaveAsName Mode)
    lOCAL cuX,cuY            
    
    If InsertMode Then                                'insert mode cursor = vertical bar
      'clear the cursor
      cuX=(fW_In*(7+edCuCol))-1
      cuY=edY+((fH_In+5)*edCuRow)+5
      Line cuX,cuY-1,cuX,cuY+fH_In,2,BCblk
      
    Else                                              'overwrite mode cursor = underline
      'clear the cursor
      cuX=(fW_In*(7+edCuCol))
      cuY=edY+((fH_In+5)*(edCuRow+1))
      Line cuX,cuY,cuX+fW_In,cuY,2,BCblk
    endif
    
  End sub
  
  sub ShowHiLite()
    'highlights the Find Target text at the specified position.
    Local L,S,X,Y,XOff,Rec$    
    
    XOff=edHLPos-edStartPos                           'calc X offset (in chars) for HiLite text start
    
    If XOff>=0 AND XOff<=edMaxTxt then                'if HiLite starts in the visible part of the screen
      X=IndentX+XOff*fW_In                            'calc actual X coordinate for HiLite text start
      Y=edY+((fH_In+5)*edHLRow)+5                     'calc Y coordinate for HiLite row
      L=MIN((edStartPos+edMaxTxt)-edHLPos,Len(edFndTarg$))  'calc length of HiLite
      Rec$=GetRec(edLnPtrs(edHLRow),S)                'get record data for HiLite row
      Text X,Y,Mid$(Rec$,edHLPos,L),LT,Fnt_In,1,FCwh,BCblu  'display Hilite text
    EndIf
    
    edPrevHLRow=edHLRow                               'set Prev HiLite row to this row
    
  end sub
  
  sub ClrPrevHiLite()
    'clears previous highlighting
    if edPrevHLRow<0 then exit sub
    
    Local S,Y,Rec$ 
    
    Y=edY+((fH_In+5)*edPrevHLRow)+5                   'calc Y coordinate for previous HiLite row
    box IndentX-2,Y-2,MM.HRES-74,fH_In+5,0,0,0        'clear all data on the line
    Rec$=GetRec(edLnPtrs(edPrevHLRow),S)              'get record data for previous HiLite row
    Text IndentX,Y,Mid$(Rec$,edStartPos,edMaxTxt),LT,Fnt_In,1,FCOut%,BCOut%
    
  end sub
  
  Function GetRecTrakPtr(ipStrtIdx,ipLines,ipDirn)
    'determines the value of the index into edRecTrak 
    'a specified number of lines from a given starting point
    'in either a forward or backward direction, and skipping
    'any deleted records in the Linked List along the way.
    'ipDirn - 0 = Down (Forward)
    '         1 = Up (Backward)
    
    If ipLines=0 then 
      GetRecTrakPtr=ipStrtIdx
      exit Function
    endif
    
    local Idx,Cnt           
    
    Idx=ipStrtIdx
    Cnt=0
    
    do
      Idx=GetInt12(edRecTrak(Idx),ipDirn)             'Dirn - 0 = Forward / 1 = Backward
      If Idx=0 then                                   'Reached start or end of linked List
        GetRecTrakPtr=0
        Exit Function
      endif
      If GetBit4(edRecTrak(Idx))<>4 then              'skip entries for Deleted records
        Cnt=Cnt+1      
        If Cnt=ipLines then                           'done enough lines
          GetRecTrakPtr=Idx                           'return index
          exit Function
        endif
      endif
    Loop
    
  End Function
  
  Function GetRec(ipIdx,ipState) As String
    'retrieve a copy of the data for the specified line
    'updating ipState argument with the State value
    Local RecTrak,Rec$,c$           
    
    GetRec=""                                         'default return - empty string
    RecTrak=edRecTrak(ipIdx)                          'get edRecTrak entry for the specified record
    ipState=GetBit4(RecTrak)                          'get State for the specified record
    
    if ipState=1 then                                 'get data from the file record
      Seek #8,GetInt20(RecTrak)
      Line Input #8,GetRec                            'get record data
      
    Elseif ipState=2 or ipState=3 then                'get data from the temporary UpdRec file
      Seek #9,GetInt16(RecTrak)                       'set pointer to reqd record in the file
      Line Input #9,Rec$                              'get record data from file
      for i=EDMAXRECSZ% to 1 Step -1                  'scan from end of record to trim trailing spaces
        c$=Mid$(Rec$,i,1)                             'check character at position i
        If c$<>" " then
          If c$=Chr$(23) then i=i-1                   'if character is ETB, decrement i to before ETB
          exit For                                    'found non-space char
        EndIf
      next i  
      GetRec=LefT$(Rec$,i)                            'return data up to last non-space char (& before ETB)
    endif
    
    'Deleted records (ipState=4) will just return the empty string
    'if this function is called for one of those.
    
  end function
  
  Sub GetScrollUpStart(ipStrtRec,ipStrtIdx,ipLn)
    'sets the edStrtRec and edStrtIdx values for starting
    'a new edit lines display, scrolled up by ipLn lines.
    local j,Idx=ipStrtIdx
    
    For j=1 to ipLn
      Idx=GetRecTrakPtr(Idx,1,1)                      'get index for previous record (skipping deleteds)
      If Idx=0 then exit for                          'reached the start of the Linked List
    next j
    
    If Idx=0 then                                     'not enough records to scroll ipLn lines - start at #1
      edStrtIdx=edStart
      edStrtRec=1
    Else
      edStrtIdx=Idx
      edStrtRec=ipStrtRec-ipLn
    endif
    
  end sub
  
  Sub SaveModifiedRecord()
    'handles assigning the next entry in the UpdRec$ array to track a 
    'modified record (if this is the first modification to this line)
    'and/or storing the modified data in the assigned UpdRec$ array entry. 
    
    If edState=1 then
      'no previous modification - change the State in the edRecTrak entry 
      'for the Current Record to show the record has been modified. 
      PutBit4(edRecTrak(edCurrIdx),2)                 'State = 2 indicates Modified record
      'update the saved State value
      edState=2
      'update the UpdRec Ptr to point to the start of the next record in the UpdRec file
      PutInt16(edRecTrak(edCurrIdx),edUpdPtr)
      'increment the UpdRec Ptr to the next record to be assigned (records are fixed EDMAXRECSZ% bytes + Cr/Lf)
      edUpdPtr=edUpdPtr+(EDMAXRECSZ%+2)
      'increment the UpdCnt counter
      edUpdCnt=edUpdCnt+1
      UpdEditSBPanel(7,STR$(edUpdCnt))                'Count of Updates made
    Endif
    
    WriteUpdFile(edCurrIdx,edRec$)                    'save modified data in UpdRec file
    edRecMod=0                                        'reset the Record Modified flag
    
    If edModFlg=0 then
      edModFlg=1                                      'set File Modified flag
      UpdEditSBPanel(1,edFN$ + "*")                   'show file as modified 
    endif
    
  end sub
  
  Sub InsertNewRecord(ipTxtLen,ipTxtPtr)
    'handles inserting a new record (line) following the current cursor
    'line, assigning the next record in the UpdRec temporary file and
    'lnserting an entry with a pointer to track the new record into the Linked List.
    Local SaveNewIdx,CurrFwdIdx,Temp$
    
    CurrFwdIdx=GetInt12(edRecTrak(edCurrIdx),0)       'current FWD Link
    PutInt12(edRecTrak(edCurrIdx),0,edNewIdx)         'update CurrIdx FWD Link to NewIdx
    PutInt12(edRecTrak(CurrFwdIdx),1,edNewIdx)        'update BWD Link in CurrFwdIdx rec to NewIdx
    PutInt12(edRecTrak(edNewIdx),0,CurrFwdIdx)        'update FWD Link in NewIdx to CurrFwdIdx
    PutInt12(edRecTrak(edNewIdx),1,edCurrIdx)         'update BWD Link in NewIdx to point to CurrIdx
    PutInt16(edRecTrak(edNewIdx),edUpdPtr)            'update UpdRec pointer in NewIdx to point to 
    '                                                 'the assigned UpdRec file record offset
    PutBit4(edRecTrak(edNewIdx),3)                    'set State for NewIdx = 3 (Inserted Record)
    
    If CurrFwdIdx=0 then                              'inserted record is at the end of the file
      edEnd=edNewIdx                                  'need to update the End Pointer to the new end record
    endif
    
    'save then increment edNewIdx to the next value to be used
    SaveNewIdx=edNewIdx
    edNewIdx=edNewIdx+1    
    'increment the UpdRec Ptr to the next record to be assigned (records are fixed EDMAXRECSZ% byte + Cr/Lf)
    edUpdPtr=edUpdPtr+(EDMAXRECSZ%+2)
    'increment the UpdCnt counter
    edUpdCnt=edUpdCnt+1
    UpdEditSBPanel(7,STR$(edUpdCnt))                  'Count of Updates made
    
    edRecCount=edRecCount+1                           'increment Record Count
    
    'save any data after the cursor on the current line
    If ipTxtLen > ipTxtPtr then                       'text exists to the right of the cursor
      Temp$=Mid$(edRec$,ipTxtPtr)                     'move it to the new record
      WriteUpdFile(SaveNewIdx,Temp$)                  'and write it to the UpdRec file  
      edRec$=Mid$(edRec$,1,ipTxtPtr-1)                'and delete it from the current record
      SaveModifiedRecord()                            'and save modified current record
      
    Else
      Temp$=""
      WriteUpdFile(SaveNewIdx,Temp$)                  'write a blank new record to the UpdRec file
    endif
    
    'set the newly inserted record as the Current Record 
    edCurrRec=edCurrRec+1
    edCurrIdx=SaveNewIdx
    edRec$=GetRec(SaveNewIdx,edState)                 'get any data and State for the newly inserted record
  end sub
  
  sub DeleteRecord(ipRecIdx)
    'handles deleting a specified record - 
    '- mostly the de-linking from the Linked List if it is
    'the first or last record in the list and additionally
    'the complication of the next or previous record(s)
    'already being in deleted state. 
    local Idx
    
    If GetInt12(edRecTrak(ipRecIdx),0)=0 then         'check Fwd Link - is this the last record?
      Idx=GetRecTrakPtr(ipRecIdx,1,1)                 'find previous non-deleted record
      PutInt12(edRecTrak(Idx),0,0)                    'set Fwd Link in prev non-deleted rec to 0
      edEnd=Idx                                       'and set prev non-deleted rec as End record now
      
    else  
      If GetInt12(edRecTrak(ipRecIdx),1)=0 then       'check Bwd Link - is this the first record?
        Idx=GetRecTrakPtr(ipRecIdx,1,0)               'find next non-deleted record
        PutInt12(edRecTrak(Idx),1,0)                  'set Bwd Link in next non-deleted rec to 0
        edStart=Idx                                   'and set next non-deleted rec as Start record now
      Endif
    endif
    
    PutBit4(edRecTrak(ipRecIdx),4)                    'set State = 4 for the deleted record
    edRecCount=edRecCount-1                           'decrement Record Count
    
  end sub
  
'  sub PrintLinkedList()
'    'for debug purposes - Print the current Linked List (edRecTrak array) contents
'    Local i,j
'
'    ? "RecTrak Linked List Contents:"
'    ? "edRecCount: " + Str$(edRecCount) + ", edUpdPtr: " + Str$(edUpdPtr);
'    ? ", edStart: " + STR$(edStart) + ", edEnd: " + STR$(edEnd)
'    i=1
'    do
'      ? Str$(i,3) + ": " + Str$(GetBit4(edRecTrak(i)));
'      For j=0 to 1
'        ? ", " + STR$(GetInt12(edRecTrak(i),j));
'      next j
'      ? ", " + STR$(GetInt16(edRecTrak(i)));
'      ? ", " + STR$(GetInt20(edRecTrak(i)));
'      ? ""
'      i=i+1
'      If GetBit4(edRecTrak(i))=0 then                 'State=0 - unused record
'        'end of the linked list - exit
'        exit do
'      endif
'    loop
'
'  end sub
  
  Sub GetSaveAsName(ipInitial)
    'get the Save As file name
    Local h,w,x,y,Txt$
    
    if ipInitial then
      edSaveFN$=edFN$                                 'start with the original File Name
      HideCursor_Edit()                               'hide the edit cursor
    endif
    
    h=(fH_Mnu+2)*7+fH_In+34
    w=fW_Mnu*44                                       'allows 40 chars + 2 leading & trailing blanks
    x=(MM.HRES-w)\2
    y=(edH-h)\2
    
    'calculate coordinates for text
    TxtX=x+fW_Mnu*2
    IndentX=x+fW_Mnu*4
    TxtY=y+fH_Mnu\2
    
    Rbox x,y,w,h,10,FCblk,BC210
    
    Txt$=GetStr(193)                                                              '0
    
    For i=0 to 5
      Text TxtX,TxtY,Txt$,LT,Fnt_Mnu,1,FCblk,BC210
      Txt$=GetStr(194+i)                              '196 gets overwritten below (has insert)
      
      Select Case i
        Case 0
          TxtYInc(0)
          Line TxtX,TxtY,TxtX+(fW_Mnu*17),TxtY,Fnt_Mnu,FCblk
          TxtYInc(2,5)
        Case 1
          TxtYInc(1)
        Case 2
          TxtYInc(0)
          Txt$=GetStr(196,PROGDIR$)
        Case 3
          TxtYInc(1)
          'save location/size parameters for the File Name text input box
          inpX=TxtX
          inpY=TxtY+1
          inpW=fW_Mnu*40
          inpH=fH_In+8
          
          TxtYInc(2,inpH+7)
        case 4
          TxtYInc(1)
      End Select
    Next i
    
    'draw the Save As File Name text input box
    BOX inpX,inpY,inpW,inpH,1,FCwh,BCgry
    
    'setup parameters for text in the textbox
    inpMaxLen=MAXFNLEN%                               'max allowed file name length
    inpMaxChars=((fW_Mnu*39)\fW_In)-1                 'max # file name chars that can be displayed 
    inpHScrlInc=(inpMaxChars\4)*3                     'horizontal scroll inc is 3/4 input box length
    inp_Txt$=edSaveFN$                                       
    inpStartPos=1                                     'not scrolled
    inpCuPos=0                                        'cursor at home
    inpPrevCuPos=-1
    UpdateText_INP() 
    
  end sub
  
  SUB SaveEditedFile(ipType)
    'save the edited file
    'ipType =   0 - Save As method - no duplicate output file
    '           1 - Save method - original file still exists, need to handle dup name
    Local tmpFN$,Rec$,FNLen,RecIdx,RecCnt,RecBytes,RecState
    
    MessageBox(MM.HRES\2,edH\2,GetStr(199),GetStr(200),"","",0,FCwh,BCblu)
    
    'we will save the file with the .tmp extension first
    'then rename it to the final name later.
    FNLen=Len(edSaveFN$)                              'get length of the file name to save as
    tmpFN$=Left$(edSaveFN$,FNLen-4) + ".tmp"
    OpenFile(tmpFN$,1,7)                              'open the .tmp output file and check for open error
    'the original program file is still open for Random as #8
    'as is the temporary UpdRec file (for Random as #9)
    'both of these are used within the GetRec(...) function. 
    
    'iterate through the RecTrak array via the Linked List to 
    'find the records, in the correct order and from the correct
    'sources, to create the new output file
    RecCnt=0
    RecIdx=edStart
    
    do
      Rec$=GetRec(RecIdx,RecState)                    'get record Data and State
      
      If RecState <> 4 then                           'if not a Deleted record (State 4 records are skipped) 
        Print #7, Rec$                                'write the record to the output file
        RecCnt=RecCnt+1                               'increment record count
      endif
      
      RecIdx=GetInt12(edRecTrak(RecIdx),0)            'get the index of the next linked record in the list
      
      If RecIdx=0 then                                'reached the end of the Linked List
        exit do
      endif
    Loop
    
    RecBytes=LOF(#7)                                  'get saved file length (in bytes)
    CLOSE #7,#8,#9                                    'Close the output, original source & temp UpdRec files
    
    If ipType=1 then                                  'Save method used - need to delete the original file
      Kill edFN$                                      'before renaming the temporary save file.
    Endif
    
    Name tmpFN$ As edSaveFN$                          'rename .tmp file to final name
    
    MessageBox(MM.HRES\2,edH\2,GetStr(201),GetStr(202,edSaveFN$),GetStr(203,Str$(RecCnt),STR$(RecBytes)),"",1,FCwh,BCblu)
    
  end SUB
  
  '======================================================================================================
  '     E D I T O R    F I N D    &    R E P L A C E    F U N C T I O N S    &    S U B R O U T I N E S
  '======================================================================================================
  
  sub DispFindReplParams(ipInitial)
    'allows specification of the Find Target string
    'and optionally the Replace Value string.
    Local X,Y,W,H,tX,Txt$
    
    'calculate the size and coordinates for the DispFindReplParams box
    W=fW_Mnu*17+fW_In*48
    H=(fH_Mnu+2)*9+40
    X=(MM.HRES-W)\2
    Y=edY+(edH-H)\2
    
    'draw the DispFindReplParams box
    RBOX X,Y,W,H,10,FCblk,BC210
    'set text position coordinates
    TxtX=X+fW_Mnu*2
    TxtY=Y+fH_Mnu\2                                   'top for top (caption) line
    
    If Fnt_Mnu=1 then                                 'using the small font
      'need a few more pixel rows to get the line alignment correct
      TxtYInc(2,4)                                    'push text down an extra 4 pixel rows
    endif
    
    tX=TxtX
    
    For i=0 to 7
      Text tX,TxtY,GetStr(206+i),LT,Fnt_Mnu,1,FCblk,BC210
      
      Select Case i
        Case 0
          TxtYInc(0)
          Line TxtX,TxtY,TxtX+(fW_Mnu*Len(Txt$)),TxtY,Fnt_Mnu,FCblk
          TxtYInc(2,10)
        Case 1
          'save left and top for the Find text input box
          edFndX=TxtX+fW_Mnu*13
          edFndY=TxtY-3
          tX=edFndX                                   'use Text box x coord for next display line also
          TxtYInc(1)
        Case 2
          tX=TxtX                                     'back to TxtX coord for the rest
          TxtYInc(1)
        Case 3
          'save top for the Replace text input box
          edReplY=TxtY-3
          TxtYInc(1)
        Case 4,5,6
          TxtYInc(1)
      end Select
    next i
    
    If ipInitial then
      'initialize input field parameters and clear Find flags
      edFndCuPos=0
      edFndPrevCuPos=-1
      edReplCuPos=0
      edReplPrevCuPos=-1
      edFndReplFlg=0                                  'Find Target text input box has focus
      fnd1st=0
      fndUseCurr=0
      fndFlg=0
    endif  
    
    DispFindReplInputFlds()                           'display the input text boxes
    
  end sub  
  
  sub DispFindReplInputFlds()
    'sets up the display for the Find Target and Replace With input fields,
    'with the active field determined by the edFndReplFlg value.
    '
    'edFndReplFlg = 0 Find Target field is active
    '             = 1 Replace With field is active
    Local BCtmp,tmpY,tmpTxt$
    
    inpX=edFndX
    inpW=fW_In*48
    inpH=fH_In+8
    inpStartPos=1
    inpMaxLen=47 
    inpMaxChars=inpMaxLen
    
    'draw the Find Target field
    if edFndReplFlg=0 then                            
      BCtmp=BCgry                                     'Find Target field is active
      inpY=edFndY
      inp_Txt$=edFndTarg$
      inpCuPos=edFndCuPos
      inpPrevCuPos=edFndPrevCuPos
    Else
      BCtmp=BC190                                     'Find Target field is inactive
      tmpY=edFndY
      tmpTxt$=edFndTarg$
    endif
    
    BOX inpX,edFndY,inpW,inpH,1,FCwh,BCtmp
    
    'draw the Replace With field
    if edFndReplFlg=1 then                            
      BCtmp=BCgry                                     'Replace With field is active
      inpY=edReplY
      inp_Txt$=edReplVal$
      inpCuPos=edReplCuPos
      inpPrevCuPos=edReplPrevCuPos
    Else
      BCtmp=BC190                                     'Replace With field is inactive
      tmpY=edReplY
      tmpTxt$=edReplVal$
    endif
    
    BOX inpX,edReplY,inpW,inpH,1,FCwh,BCtmp
    
    UpdateText_INP()
    
    'display the text in the Inactive text box
    Text inpX+(fW_In\2),tmpY+3,Mid$(tmpTxt$,1,inpMaxChars),LT,Fnt_In,1,FCblk,BC190
    
  end sub
  
  Function DoFindNext()
    'manages the Find/Find Next function & processing the results
    Local c,k,m1,m2,r
   
    DoFindNext=5                                      'default return value
    NotifyWait(2)                                     'initiate Blinking '*SEARCHING*' status msg
    
    do
      FindNext()                                      'Find Initial / Find Next
      
      If fndFlg=0 or fndFlg=2 then                    'Find Target NOT found
        If fndFlg=0 then
          c=215
        else
          c=218
        endif
        
        m1=216
        m2=217
        k=13                                          'MsgBox waits for 'Enter' key
        fndNxtRec=1                                   'reset Nxt pointers to start at beginning of file
        fndNxtIdx=edStart
        fndNxtPos=1
        
        If fndFlg=2 then                              'reached EOF
          If fndStrtIdx=edStart and fndStrtPos=1 then 'searched the complete file
            'nothing
          Else                                        'but started part way thru - 
            m2=219                                    'so continue checking from the beginning
            k=155                                     'MsgBox waits for 'F11'
            r=1                                       'need to refresh screen if another match is found
          endif
        endif
        
        MessageBox(MM.Hres\2,edY+edH\2,GetStr(c),GetStr(m1),GetStr(m2),"",1,FCwh,BCblu,k,42)
        
        if m2 <> 219 then                             'only m2=219 continues checking - so exit the loop
          edHLRow=-1                                  'no Find match exists
          edFndTarg$=""                               'clear Find Target
          edReplVal$=""                               'and Replace With text
          fnd1st=1                                    'treat next Find Next as Initial Find
          exit do
        endif
        
      else  'fndFlg=1 - Match Found
        'is the matched record on the currently displayed Edit Window?
        if fndNxtIdx >= edStrtIdx And fndNxtIdx <= edEndIdx then
          'on current screen, no need to adjust start pointers.
          'adjust the values associated with the 'Current' record
          'and calc the row for the cursor and the HiLite row (same as cursor)
          edCurrRec=fndNxtRec
          edCurrIdx=fndNxtIdx
          edRec$=GetRec(edCurrIdx,edState)
          edCuRow=fndNxtRec-edStrtRec
          edHLRow=edCuRow
          if r=0 then DoFindNext=7                    'return value for just moving the highlight
          
        Else  'need to display a different screen
          If fndNxtRec > 5 then                       'set new start pointers (5 lines prior to the target)
            edStrtRec=fndNxtRec-5
            edStrtIdx=GetRecTrakPtr(fndNxtIdx,5,1)    'get Index 5 records prior to Target
            edCuRow=5                                 'set the Target row as the current cursor row
            edHLRow=5                                 'and the HiLite row
            
          else  'less than 5 lines from start of file - just display from record 1
            edStrtRec=1
            edStrtIdx=edStart
            edCuRow=fndNxtRec-edStrtRec               'set the Target row as the current cursor row
            edHLRow=edCuRow                           'and the HiLite row
          endif
        endif
        
        'now determine any Horizontal scrolling required to position the Target in the visible portion
        If edStartPos=1 then
          if fndNxtPos > edMaxTxt then                'need to scroll right to include Target text
            edStartPos=edHScrlInc+1                   'set new start pos
            DoFindNext=5                              'must refresh entire screen if scrolled right
          endif
          
        else  'edStartPos=edHScrlInc+1                'already scrolled
          If fndNxtPos <= edMaxTxt then               'need to scroll back to the left to include Target text
            edStartPos=1
            DoFindNext=5                              'must refresh entire screen if scrolled left
          endif
        endif
        
        edTargCuCol=-1                                'reset saved scroll target cursor pos
        edHLPos=fndNxtPos                             'save HiLite pos start within the record 
        edCuCol=fndNxtPos-edStartPos                  'and new cursor position on displayed line
        exit do                                       'exit the loop  
      endif
    loop
    
    fndNxtPos=fndNxtPos+1                             'increment Nxt Start Pos by 1.
    NotifyWait(0)                                     'disable and clear wait notifications for Search
    
  end Function 
  
  Sub FindNext()
    'scans from the current cursor position (edCurrRec/edCurrIdx/edStartPos+edCuCol) 
    'for Initial Find or from fndNxtRec/fndNxtIdx/fndNxtPos for Find Next looking  
    'for a match on the Find Target (edFndTarg$) text.
    'if found, sets the fndFlg=1 and the fndNxtRec,fndNxtIdx & fndNxtPos values
    'identify the position of the match.
    'if the end of the edRecTrak Linked List is reached, fndFlg will be set to 2
    'and the fndNxt... values should be ignored.
    Local n,p,s,Rec$
    
    fndFlg=0                                          'clear the Found flag
    n=1
    
    if fndUseCurr then                                'use current Cursor Pos as Find starting point    
      fndNxtRec=edCurrRec
      fndNxtIdx=edCurrIdx
      fndNxtPos=edStartPos+edCuCol
      fndUseCurr=0
      fnd1st=1                                        'ensure it is also treated as Initial Find
    endif
    
    if fnd1st then                                    'Initial Find - save starting point
      fndStrtRec=fndNxtRec
      fndStrtIdx=fndNxtIdx
      fndStrtPos=fndNxtPos
      n=0
    endif
    
    do
      Rec$=GetRec(fndNxtIdx,s)                        'get the first/next record via the Linked List
      
      if s <> 4 then                                  'not deleted record
        p=Instr(fndNxtPos,UCASE$(Rec$),UCASE$(edFndTarg$))  'check for a Target match in this record (from NxtPos)
        
        if n>0 then                                   'don't check this on the initial iteration
          If fndNxtIdx=fndStrtIdx And fndNxtPos <= fndStrtPos and (p=0 or p=>fndStrtPos) then  
            'done full circle
            fndFlg=0                                  'no match, entire file scanned
            exit do
          endif
        endif
        
        if p>0 then                                   'match found
          fndNxtPos=p                                 'set position on line where Target text starts
          fndFlg=1                                    'set Found flag = 1 (success)
          exit do
        endif
      endif
      
      'no match in (remainder of) this record - move to next record
      fndNxtIdx=GetRecTrakPtr(fndNxtIdx,1,0)          'get index of next record      
      
      If fndNxtIdx=0 then                             'reached end of the Linked List
        fndFlg=2                                      'set Found flag = 2 to indicate reached EOF
        exit do
      endif
      
      fndNxtRec=fndNxtRec+1                           'increment Rec Nbr
      fndNxtPos=1                                     'reset Start position to scan from pos 1
      n=n+1                                           'increment iteration counter
      
      if n MOD 75=0 then NotifyWait(2)                'show Blinking '*SEARCHING*' status msg
    Loop
    
    fnd1st=0                                          'next Find Next will be Next not Initial
    
  end sub  
  
  '===========================================================================================
  '     F I L E    H A N D L I N G     F U N C T I O N S    &    S U B R O U T I N E S
  '===========================================================================================

  Function SDCardPresent()
    'checks whether the SD Card is configured and present
    '
    'Returns: 1 - Success
    '         0 - Failed (Error Message (either "SD card not configured" or "SD card not found")
    '                     will be saved in flErrMsg$)
    
    local FN$          
    
    SDCardPresent=1                                   'default return value - success
    
    ON Error skip 1
    FN$=DIR$("*", DIR)                                'attempt to list directories
    If MM.ERRNO <> 0 then                             'error occurred
      SDCardPresent=0                                 'return value - failed
      flErrMsg$=MM.ErrMsg$                            'save error msg
      on error clear                                  'clear error indicators
    Endif
    
  End Function
  
  function FileExists(spFN$)
    'checks whether the specified File Name already exists
    '
    'Returns: 1 - File exists
    '         0 - File does not exist
    
    local TestFN$          
    
    FileExists=0                                      'default return value - file does not exist
    
    'Note:  Assumes the Current Working Directory has already
    '=====  been set to the directory that is to be checked.
    TestFN$=DIR$(spFN$,file)                          'look for the specified file name  
    If UCASE$(TestFN$)=UCASE$(spFN$) then
      'file exists - return True (1)
      FileExists=1
    endif
    
  end function
  
  Function ShowDupFNOpts(ipAllowAppend)
    'displays the options for handling a dup filename situation
    'and returns the value identifying the user's choice.
    'The ipAllowAppend argument controls whether the F3 option 
    '(append to existing file) is displayed or not.
    '
    'Returns: -1  - Esc key (return to prev screen to enter a different log file name)
    '          1  - F3 key (append new log data to existing log file) - if ipAllowAppend arg = 1
    '          2  - F7 key (delete existing log file and create new one with same name)
    
    Local W,H,X,Y,n,Rslt=0,TxtX,Txt$
    
    'determine number of lines required
    n=9+ipAllowAppend                                 '9 or 10 lines needed
    
    'calculate sizes and positions
    W=fW_Mnu*50
    H=(fH_Mnu*n)+41
    X=(MM.Hres-W)\2
    Y=(MM.VRes-H)\2
    
    TxtX=X+(fW_Mnu*2)
    IndentX=X+(fW_Mnu*4)
    TxtY=Y+(fH_Mnu\2)
    
    'draw the Duplicate File Name box - center screen
    RBox X,Y,W,H,10,FCblk,RGB(WHITE)
    'display the text
    Txt$=GetStr(30)
    
    For i=0 to 10
      If Txt$ <> "" then
        Text TxtX,TxtY,Txt$,LT,Fnt_Out,1,RGB(Red),RGB(WHITE)
      Endif
      
      Txt$=GetStr(31+i)
      
      Select Case i
        Case 0
          TxtYInc(0)
          Line TxtX,TxtY,TxtX+(fW_Mnu*26),TxtY,1,RGB(Red)
          TxtYInc(2, 5)
        Case 1
          TxtYInc(1)
        Case 2
          If ipAllowAppend Then
            TxtYInc(1)
          Else
            Txt$=""
          endif
          TxtX=IndentX
        Case 3
          TxtYInc(1)
          If Mode <> 70 Then Txt$=""
        Case 4
          If Mode=70 then
            TxtYInc(0)
          Else
            Txt$=""
          endif
        Case 5
          If Mode=70 Then Txt$=""
        Case 6
          If Mode<>70 then        
            TxtYInc(0)
          Else
            Txt$=""
          endif
        Case 7
          TxtYInc(1)
        Case 8,9
          TxtYInc(0)
      end select
    Next i
      
    'need to wait here until the F5, F7 or Esc key is pressed
    Do
      In_Count=Loc(#0)
      
      If In_Count > 0 Then
        In_Char_Val=ASC(Input$(1,#0))
        
        select case In_Char_Val
          Case 27                                     'ESC key - return to re-enter log file name
            Rslt=-1                                   'return to prev screen
            
          Case 149                                    'F5 key - append to existing file
            if ipAllowAppend then                     'only valid if ipAllowAppend = 1
              Rslt=1
            else              
              Beep()
            endif
            
          case 151                                    'F7 key - replace existng file
            Rslt=2
            
          case Else
            Beep()                                    'invalid key presed
        End Select
      endif
      
      if Rslt <> 0 then                               'result is set - valid key has been pressed
        exit do                                       'exit loop now
      endif
     
      pause 100
    Loop      
    
    ShowDupFNOpts=Rslt                                'return result
    
  end function
  
  sub ShowFileError(spErrMsg1$,spErrMsg2$,ipFatal)
    'displays a error message box to report a file handling related error
    
    MessageBox(MM.Hres\2,opY+opH\2,"Error:",spErrMsg1$,spErrMsg2$,"",1,FCerr,BCerr,0,0,ipFatal)
    
  End sub
  
  Sub OpenFile(spFN$,ipMode,ipN)
    'opens the specified File for the specified Mode of access as the specified File Number
    'and includes checking for/reporting File Open errors.
    'All file open errors are Fatal and the program will be terminated!!
    '
    'ipMode:  0 = INPUT
    '         1 = OUTPUT
    '         2 = APPEND
    '         3 = RANDOM
    
    SELECT CASE ipMode
      Case 0                                          'For Input
        ON ERROR SKIP 1
        OPEN spFN$ FOR INPUT AS #ipN
      Case 1                                          'For Output
        ON ERROR SKIP 1
        OPEN spFN$ FOR OutPUT AS #ipN
      Case 2                                          'For Append
        ON ERROR SKIP 1
        OPEN spFN$ FOR APPEND AS #ipN
      Case 3                                          'For Random
        ON ERROR SKIP 1
        OPEN spFN$ FOR RANDOM AS #ipN
    END SELECT
  
    IF MM.ERRNO<>0 THEN
      LOCAL c$="SDCard Access Error: " + MM.ERRMSG$
      MessageBox(MM.HRES\2,MM.VRES\2,c$,GetStr(18),GetStr(19),"",1,FCerr,BCerr,,,1)
      Pause 250
      CLS RGB(Blue)
      ? "Program Terminated due to error."
      end                                             'Terminate the program
    ENDIF
    
  end SUB
  
  Sub GetFileInfo() 
    'scans the current directory counting the number of LOG files it contains
    'and determining the longest file name in the list.
    'Assumes current working directory is set to either the CONSLOGS directory
    'or the PROGS directory, depending on the current Mode
    
    Local FN$,FNLen           
    
    FileCnt=0                                         'reset file count
    FN_MaxLen=0                                       'and maximum file name length
    
    If Mode=20 OR Mode=25 then
      'Logging Setup or Select Log Modes
      FN$=DIR$("*.log",file)                          'start looking for .LOG files
      
    Else  'Select Program File Mode
      FN$=DIR$("*.bas",file)                          'start looking for program (.BAS) files
    Endif
    
    do WHILE FN$ <> "" 
      FNLen=LEN(FN$)                                  'get length of this file name
      FN_MaxLen=MAX(FN_MaxLen,FNLen)                  'save max length so far
      FileCnt=FileCnt+1                               'increment file count
      FN$=DIR$()                                      'get next file name from the list
    Loop
    
  End Sub
  
  Sub GetProgFileInfo(spFN$,ipRecCount,ipFileLen)
    'scans the selected program file to obtain file length (in bytes) and number of records
    Local Rec$          
    
    MessageBox(MM.HRES\2,opY+(opH\2),GetStr(141),GetStr(142),"","",0,FCwh,BCblu)  'useful if the file is large
    
    ipRecCount=0
    OpenFile(spFN$,0,5)                               'open the file and check for file open errors
    
    Do
      Line Input #5,Rec$
      If EOF(#5) then exit do                         'reached End Of File - exit loop now
      ipRecCount=ipRecCount+1                         'increment record count
    Loop
    
    ipFileLen=LOF(#5)                                 'get file length (in bytes)
    
    Close #5 
    
  end sub
  
  sub BuildFileList(spMtchChrs$)
    'build a list of File Names, optionally matching the spMtchChrs$ argument
    
    'declare a tailored array sufficient to contain the full File List (may not use all entries)
    'NOTE:  This is a global declaration (DIM) as the array needs to be accessible across multiple subroutines
    '=====  It is therefore necessary to ERASE the old array before attempting to declare it again.
    '       The ERASE is done following an ON ERROR SKIP, so that if the array is not found
    '       the resulting error doesn't cause a crash!
    ON Error skip 1
    Erase FNames$()                                   'kill the old array, if it exists
    on error clear
    DIM FNames$(MAX(FileCnt,1)) Length MAX(FN_MaxLen,1)   'declare new array for the File List
    
    GetFileNames(spMtchChrs$)                         'populate the File Names array
    ShowFileList(0)                                   'show the file list starting from the first entry
    If flMaxIdx > -1 then                             'at least 1 entry exists
      SelectFileName(0)                               'select the first entry
      
    else
      If spMtchChrs$ <> "" then                       'this is only applicable to LoggingSetup Mode
        'no matching files found - display message
        ShowNoMatchingFiles(spMtchChrs$)
        inpCuPos=0
        inpStartPos=1
        UpdateText_INP()
        
      Else
        'no log/program files found - display message
        Text flX+fW_Mnu,flY+4,GetStr(67),LT,Fnt_Mnu,1,RGB(Red),BC190
      endif
      
      flCurrSelPtr=-1                                 'no files - nothing can be selected
    Endif
    
  End sub
  
  Sub GetFileNames(spFN$) 
    'scans the current directory populating the list of Log (.LOG) files
    'or Program (.BAS) files depending on the current Mode.
    Local SrchArg$,FN$,idx           
    
    If Mode=20 Or Mode=25 Then
      'Logging Setup or Select Log Modes
      'determine the Search Parameter to use based on what is in spFN$ argument
      If Len(spFN$)=0 then
        'spFN$ is empty - search for all .LOG files
        SrchArg$="*.log"
      ElseIf UCASE$(Right$(spFN$,4))=".LOG" then
        'full file name has been specified
        SrchArg$=spFN$
      ElseIf UCASE$(Right$(spFN$,3))=".LO" then
        'almost the full file name specified - complete it
        SrchArg$=spFN$ + "g"
      ElseIf UCASE$(Right$(spFN$,2))=".L" then
        'almost the full file name specified - complete it
        SrchArg$=spFN$ + "og"
      ElseIf UCASE$(Right$(spFN$,1))="." then
        'almost the full file name specified - complete it
        SrchArg$=spFN$ + "log"
      Else
        'partial file name specified - use wildcard search
        SrchArg$=spFN$ + "*.log"
      endif
      
    Else  'Select Program File Mode
      SrchArg$="*.bas"                                'search for program (.BAS) files
    endif
    
    idx=0
    
    FN$=DIR$(SrchArg$,file)                           'start looking for files
    do WHILE FN$ <> ""
      FNames$(idx)=FN$                                'put file name into the array entry
      idx=idx+1                                       'increment array entry pointer
      FN$=DIR$()                                      'get next file name from the list
    Loop
    
    flMaxIdx=idx-1                                    'max valid index into the file name array - will be
    '                                                 '-1 if NO files found matching the SearchParams$  
    SortStrArray(FNames$(),flMaxIdx)                  'sort file name list  
    
  End Sub
 
  sub ShowFileList(ipStrtPtr)
    'display file names in the File List box
    'starting (top line) at the specified list index
    Local flDispLines           
    
    'redraw the File List box to clear previous entries
    BOX flX,flY,flW,flH,1,FCblk,BC190    
    
    flCurrStrtPtr=ipStrtPtr                           'save the current list start pointer
    TxtY=flY+4                                        'calc top (Y coordinate) of top line in the list
    TxtX=flX+fW_Mnu
    flDispLines=MIN((flMaxIdx-ipStrtPtr),(flMaxLines-1))
    
    For i=0 to flDispLines
      Text TxtX,TxtY,Left$(FNames$(i+ipStrtPtr),flMaxChars),LT,Fnt_Mnu,1,FCblk,BC190
      TxtYInc(0)
    next i
    
    'calc new TxtX and TxtY coordinates for the following instructional text
    TxtX=flX-(fW_Mnu*16)
    TxtY=flY+((fH_Mnu*3)+10)
    
    Text TxtX,TxtY,GetStr(59),LT,Fnt_Mnu,1,FCblk,BC210 
    'draw up arrow in the above text cuz it isn't in the font
    DrawUpDownArrow(1,(TxtX+(fW_Mnu*8)),TxtY)
    'draw down arrow in the above text cuz it isn't in the font either
    DrawUpDownArrow(0,(TxtX+(fW_Mnu*14)),TxtY) 
    TxtYInc(0)
    
    For i=0 to 3
      Text TxtX,TxtY,GetStr(60+i),LT,Fnt_Mnu,1,FCblk,BC210 
      TxtYInc(0)
    Next i
   
  end sub
  
  sub DrawUpDownArrow(ipWhich,ipX,ipY)
    'draw an up or down arrow symbol (emulating the font)
    Local Col, Row, Inc, Bot           
    
    If fW_Mnu > 8 then
      'big font (width more than 8 pixels) - draw bigger arrow
      Col=ipX+(fW_Mnu\2)-4
      Bot=((ipY+fH_Mnu)-3)
      If ipWhich=1 then                               'UP arrow
        Row=ipY+6
        Inc=-2
      Else                                            'DOWN arrow
        Row=ipY+fH_Mnu-10
        Inc=2
      endif
      
      Line Col,Row,(Col+6),Row,2,FCblk
      Col=Col+1
      Row=Row+Inc
      
    Else
      'smaller font - draw smaller arrow
      Col=ipX+(fW_Mnu\2)-3 
      Bot=((ipY+fH_Mnu)-2)
      If ipWhich=1 then                               'UP arrow
        Row=ipY+4
        Inc=-2
      Else                                            'DOWN arrow
        Row=(ipY+fH_Mnu)-7
        Inc=2
      endif
    endif  
    
    Line Col,Row,(Col+4),Row,2,FCblk
    Col=Col+1
    Row=Row+Inc
    Line Col,Row,(Col+2),Row,2,FCblk
    Col=Col+1
    Line Col,ipY,Col,Bot,1,FCblk
    
  End sub
  
  Sub ShowNoMatchingFiles(spMtchChrs$)
    'display the "No files found" message in place of the file list
    local PartFN$          
    
    PartFN$=spMtchChrs$
    TxtX=flX+fW_Mnu                                   'calc left (X coordinate) of the text lines
    TxtY=flY+4                                        'calc top (Y coordinate) of top line in the list
    
    For i=0 to 1
      Text TxtX,TxtY,GetStr(65+i),LT,Fnt_Mnu,1,RGB(Red),BC190
      TxtYInc(0)
    Next i
    
    TxtX=TxtX+(fW_Mnu*2)
    
    do 
      Text TxtX,TxtY,LEFT$(PartFN$,flMaxChars-2),LT,Fnt_Mnu,1,RGB(Red),BC190
      TxtYInc(0)
      If LEN(PartFN$) > flMaxChars-2 then
        PartFN$=Mid$(PartFN$,flMaxChars-1)
      Else
        PartFN$=""
      Endif
    Loop until PartFN$=""
    
  end sub
  
  sub SelectFileName(ipPtr)
    'Selects the File Name displayed on the line
    'specified via ipPtr - this highlights this line.
    '
    'If LoggingSetup Mode is active, the selected File Name
    'is also copied to the Log File Name text box.
    
    flCurrSelPtr=flCurrStrtPtr+ipPtr
    
    Text flX+fW_Mnu,(flY+(ipPtr*(fH_Mnu+2)))+4,Left$(FNames$(flCurrSelPtr),flMaxChars),LT,Fnt_Mnu,1,FCwh,BCblu
    
    if Mode=20 then
      'Logging Setup Mode
      inp_Txt$=FNames$(flCurrSelPtr)
      inpCuPos=0
      inpStartPos=1
      UpdateText_INP()
    endif
    
  end sub
  
  sub UnselectFileName(ipPtr)
    'Unselects the previously selected File Name   
    '(as displayed on the line specified via ipPtr) 
    '- this removes the highlight from this line.
    
    Local PrevSelectPtr=flCurrStrtPtr+ipPtr
    
    Text flX+fW_Mnu,(flY+(ipPtr*(fH_Mnu+2)))+4, Left$(FNames$(PrevSelectPtr),flMaxChars),LT,Fnt_Mnu,1,FCblk,BC190
    
  end sub

  sub MoveFileSelection(ipDirn)
    'move the selection one row further UP or DOWN the 
    'log file list, scrolling the list if necessary.
    '
    'ipDirn: 0 = Down
    '        1 = Up
    
    flPrevSelPtr=flCurrSelPtr                         'save current pointer as previous
    
    if IpDirn=1 then                                  'move selection 1 position UP the list
      flCurrSelPtr=flCurrSelPtr-1 
      
      If flCurrSelPtr > -1 then
        'not passed start of list yet
        If flCurrSelPtr-flCurrStrtPtr < 0 then
          'past the first visible entry in the displayed portion
          'of the list - need to scroll the list up
          ShowFileList(flCurrStrtPtr-flMaxLines)
          'then select the bottom entry in the displayed list
          'NOTE: flCurrSelPtr value was changed by the call to ShowFileList (above)
          SelectFileName(flCurrSelPtr-flCurrStrtPtr)
          
        Else
          'still within the visible portion of the displayed list
          'need to unselect the previously selected entry
          UnselectFileName(flPrevSelPtr-flCurrStrtPtr)
          'now select the new line
          SelectFileName(flCurrSelPtr-flCurrStrtPtr)
        endif
        
      Else
        'past first entry in Log File Name List        
        '- can't perform this navigation
        flCurrSelPtr=0                                'reset pointer to first entry
        Beep()
      ENDIF  
    
    Else                                              'move selection 1 position DOWN the list  
      flCurrSelPtr=flCurrSelPtr+1
      
      If flCurrSelPtr <= flMaxIdx then
        'not passed end of list yet
        If flCurrSelPtr-flCurrStrtPtr=flMaxLines then
          'past the last visible entry in the displayed portion
          'of the list - need to scroll the list dowm
          ShowFileList(flCurrStrtPtr+flMaxLines)
          'then select the top entry in the displayed list
          SelectFileName(0)
          
        Else
          'still within the visible portion of the displayed list
          'need to unselect the previously selected entry
          UnselectFileName(flPrevSelPtr-flCurrStrtPtr)
          'now select the new line
          SelectFileName(flCurrSelPtr-flCurrStrtPtr)
        endif
        
      Else
        'past last entry in Log File Name List        
        '- can't perform this navigation
        flCurrSelPtr=flMaxIdx                         'reset pointer to last entry
        Beep()
      ENDIF  
    endif
    
  End sub  


  '===========================================================================================
  '     G E N E R A L    P U R P O S E     F U N C T I O N S    &    S U B R O U T I N E S
  '===========================================================================================
  
  sub TxtYInc(ipIncType,ipCustomAmt)
    'increments the TxtY pointer based on the IncType requested
    '
    'IncType: 0 - standard line spacing (Font Height + 2)
    '         1 - paragraph line spacing (Font Height + 7)
    '         2 - custom line spacing - ipCustomAmt increment
    
    If ipIncType=0 then
      TxtY=TxtY+(fH_Mnu+2)
      
    elseIf ipIncType=1 then
      TxtY=TxtY+(fH_Mnu+7)
      
    elseIf ipIncType=2 then
      TxtY=TxtY+ipCustomAmt
    endif
    
  end sub
  
  sub OutYInc(ipIncType,ipCustomAmt)
    'increments the OutY pointer based on the IncType requested
    '
    'IncType: 0 - standard line spacing (Font Height + 2)
    '         1 - paragraph line spacing (Font Height + 7)
    '         2 - custom line spacing - ipCustomAmt increment
    
    If ipIncType=0 then
      OutY=OutY+(fH_Out+2)
      
    elseIf ipIncType=1 then
      OutY=OutY+(fH_Out+7)
      
    elseIf ipIncType=2 then
      OutY=OutY+ipCustomAmt
    endif
    
  end sub
 
  Sub Beep()
    'sound the beeper when a key is invalid / ignored
    'or on certain errors.
    
    If BeepVol > 0 then
      If PIN_BEEP%=0 then
        'using GUI BEEP function
        ON ERROR SKIP 1                               'in case Touch Click pin is not configured
        GUI BEEP BeepVol
      Else
        'using Piezo Beeper directly
        on error skip 1                               'in case the Beep pin is in use as the Touch Click pin
        Pulse PIN_BEEP%,BeepVol
      Endif
    Endif
    
  end Sub
  
  Sub DrawStatusBar()
    'draws the Status Bar on the bootom line of the screen (incl Date & Time panels)
    
    'Status Bar - NOTE: the Status Bar ONLY USES FONT #1
    sbH=25                                            'Font 1 height + 12
    sbY=mm.Vres-sbH
    Box 0,sbY,mm.Hres,sbH,0,0,BC160                   'draw the Status Bar
    
    'Initialize paramteres for the Status Bar Panels
    sbpY=sbY+4                                        'Panels top
    sbpTextY=sbY+6                                    'Panels Text top
    sbpH=sbH-8                                        'Panels height
   
    'draw the Date & Time Status Bar text panels
    box mm.Hres-186,sbpY,96,sbpH,0,0,BC190
    box mm.Hres-85,sbpY,80,sbpH,0,0,BC190
    
  end sub
  
  Sub UpdDtTm()
    'update the date & time on the Status Bar
    
    Text mm.Hres-178,sbpTextY,Date$,LT,1,1,FCblk,BC190
    Text mm.Hres-77,sbpTextY,Time$,LT,1,1,FCblk,BC190
    
  end sub
  
  sub UpdateText_INP()
    'updates the display of the Input Text field anytime the text content is changed
    
    'clear input display field
    BOX inpX,inpY,inpW,inpH,1,FCwh,BCgry              'includes clearing the previous cursor
    'display updated contents
    Text inpX+(fW_In\2),inpY+3,Mid$(inp_Txt$,inpStartPos,inpMaxChars),LT,Fnt_In,1,FCwh,BCgry
    'update the cursor display
    inpPrevCuPos=-1                                   'previous cursor already cleared
    MoveCursor_INP()
    
  End Sub

  Sub MoveCursor_INP()
    'move the cursor to a new position in the Input Text Box, optionally clearing the previous cursor
    Local lnX,lnY
    
    If InsertMode Then                                'insert mode cursor = vertical bar
      If inpPrevCuPos > -1 then
        'clear the previous cursor
        lnX=inpX+(inpPrevCuPos*fW_In)+(fW_In\2)
        Line lnX,inpY+1,lnX,inpY+inpH-2,2,BCgry
      Endif
      'draw the new cursor
      lnX=inpX+(inpCuPos*fW_In)+(fW_In\2)
      Line lnX,inpY+1,lnX,inpY+inpH-2,2,cuFC
      
    Else                                              'overwrite mode cursor = underline
      If inpPrevCuPos > -1 then
        'clear the previous cursor
        lnX=inpX+(inpPrevCuPos*fW_In) +(fW_In\2)
        lnY=inpY+inpH-4
        Line lnX,lnY,lnX+fW_In,lnY,2,BCgry
      endif
      'draw the new cursor
      lnX=inpX+(inpCuPos*fW_In)+(fW_In\2)
      lnY=inpY+inpH-4
      Line lnX,lnY,lnX+fW_In,lnY,2,cuFC
    endif
    
  End sub

  Sub UpdChkBox(cbx,cbY,Checked)
    'draws the checkbox and updates the content based on the Checked flag value
    local j,k,x           
    
    'draw the check box
    BOX cbX,cbY,fW_Mnu*2,fH_Mnu+3,1,FCblk,BC190
    
    If Checked=1 then
      'draw a 'tick' in the check box
      If fH_Mnu < 14 then
        'small font - draw small tick
        k=9
        for j=0 to 6
          x=cbX+(j+5)
          If j < 3 then
            Line x,cbY+(j+9),x,cbY+(j+10),1,FCblk 
            
          else
            Line x,cbY+k,x,cbY+(k+2),1,FCblk
            k=k-2
          endif
        next j
        
      else
        'big font - draw large tick
        k=15
        for j=0 to 10
          x=cbX+(j+7)
          If j < 4 then
            Line x,cbY+(j+14),x,cbY+(j+16),1,FCblk 
            
          else
            Line x,cbY+k,x,cbY+(k+3),1,FCblk
            k=k-2
          endif
        next j
      endif
    endif
    
  end sub
  
  sub MessageBox(Xc,Yc,spCaption$,spMsg1$,spMsg2$,spMsg3$,ipWait,msgFC,msgBC,ipKey,ipFixedW,ipFatal)
    'display the specified message and optionally wait for the specified (or 'Enter') key
    
    'NOTE: ipKey MUST specify one of the following key values:
    '        absent or  0 - default ('Enter' key)
    '                  13 - 'Enter' key
    '                  27 - 'Esc' key
    '        145 thru 156 - 'F1' thru 'F12' key
    ' 
    local H,L,X,Y,W,KeyName$,Txt$
    
    If spMsg2$="" then L=4 Else L=5
    If spMsg3$<>"" then L=L+1
    If ipWait=0 then L=L-1
    If ipFatal then L=L+1
    IF ipKey=0 or ipKey=13 then
      KeyName$="'Enter'"
    Elseif ipKey=27 Then
      KeyName$="'Esc'"
    ElseIf ipKey > 144 and ipKey < 157 Then
      KeyName$="'F" + Str$(ipKey-144) + "'"
    endif
    
    if ipFixedW>37 then
      W=fW_Mnu*ipFixedW
    else
      If ipWait=1 then
        W=fW_Mnu*(MAX(34,Len(spCaption$),LEN(spMsg1$),LEN(spMsg2$),LEN(spMsg3$))+5)
      Else
        W=fW_Mnu*(MAX(Len(spCaption$),LEN(spMsg1$),LEN(spMsg2$),LEN(spMsg3$))+5)
      endif
    endif
    
    H=(fH_Mnu+2)*L+10
    X=Xc-(W\2)
    Y=Yc-(H\2)
    
    TxtX=X+(fW_Mnu*2)
    TxtY=Y+(fH_Mnu\2)
    
    RBox X,Y,W,H,10,msgFC,msgBC
    
    Txt$=spCaption$
    
    for i=0 to 5
      If Txt$ <> "" Then Text TxtX,TxtY,Txt$,LT,Fnt_Mnu,1,msgFC,msgBC
      
      Txt$=""
      
      Select Case i
        Case 0
          TxtYInc(0)
          Line TxtX,TxtY,TxtX+(fW_Mnu*LEN(spCaption$)),TxtY,1,msgFC
          TxtYInc(2,7)
          Txt$=spMsg1$
        Case 1
          If spMsg2$ <> "" then
            TxtYInc(0)
            Txt$=spMsg2$
          Endif 
        Case 2  
          If spMsg3$ <> "" then
            TxtYInc(0)
            TxT$=spMsg3$
          Endif 
        Case 3
          If ipWait=1 then
            TxtYInc(1)
            If StrCnt < 7 then
              'String #7 not yet loaded - use default message text
              Txt$="Press the " + KeyName$ + " key to continue." 
            Else
              Txt$=GetStr(7,KeyName$)
            Endif
          endif
        Case 4
          If ipFatal then
            TxtYInc(1)
            If StrCnt < 2 then
              'String #2 not yet loaded - use default message text
              Txt$="The program will terminate."
            Else
              Txt$=GetStr(2)
            endif
          endif
      End Select
    Next i
      
    If ipWait=1 then
      'need to wait here until the specified key is pressed - 'Enter' key is default
      WaitForKey(ipKey)
    endif
    
  end sub
  
  sub ErrorMsg(Xc,Yc,W,spErr1$,spErr2$)
    'display the specified error message and wait for the 'Enter' key
    
    MessageBox(Xc,Yc,"ERROR:",spErr1$,spErr2$,"",1,FCerr,BCerr,0,W)
    
  end sub
  
  sub WaitForKey(ipKey)
    'waits until the specified (or 'Enter') key is pressed then returns to the caller
    Local Key$
    
    if ipKey=0 then ipKey=13                          'ENTER key is default if ipKey value not specified
    
    Do
      In_Count=Loc(#0)
      
      If In_Count > 0 Then
        Key$=Input$(1,#0)
        If ASC(Key$)=ipKey then                       'specified Key -
          exit do                                     'exit Do Loop now
        Else
          Beep()                                      'invalid key pressed
        Endif
      endif
        
      pause 100
    Loop
    
  End sub
  
  Function WaitForKeys(ipKey1,ipKey2)
    'waits until one of the specified keys is pressed then reports which key to the caller
    Local Key$
    Do
      In_Count=Loc(#0)
      
      If In_Count > 0 Then
        Key$=Input$(1,#0)
        If ASC(Key$)=ipKey1 then                      'specified Key1      
          WaitForKeys=ipKey1
          exit do                                     
        ElseIf ASC(Key$)=ipKey2 then                  'specified Key2      
          WaitForKeys=ipKey2
          exit do                                     
        Else
          Beep()                                      'invalid key pressed
        Endif
      endif
        
      pause 100
    Loop
    
  End Function


  '================================================================================================
  '
  '     D A T A    S T R I N G S    S T O R A G E    &    R E T R E I V A L     R O U T I N E S
  '
  '================================================================================================
  
  'Supports storing data strings used within the program in a file 
  'on SD Card and loading this file at startup to a Data Array.
  'It also provides a function for retrieving a specified string
  '(by index number) and inserting any run-time variable data into
  'placeholders embedded in the string.
  '
  'NOTE:  The first 20 Strings are classified Critical Strings as they 
  '=====  are reserved for messages relating to SD Card access problems.
  '       These 20 strings are stored in memory in the CritStrs$ array
  '       to ensure they are accessible even if the SD Card is not.
  
  Function GetStr(ipStrNbr,spTxt1$,spTxt2$,spTxt3$,spTxt4$) as String
    'retrieves the data string indicated by the specified ipStrNbr argument.
    'and optionally inserts up to 4 run-time variables (as strings) 
    'replacing placeholders embedded in the data string.
    '
    'Insert Placeholders are: {n} embedded in the string at the appropriate
    'place. The value of 'n' in the placeholder can be 1 thru 4.
    
    Local Dat$,Ins$,i,j,k
    
    If ipStrNbr > StrCnt then                         'requested String # not loaded!!!!
      Disp_StrErr(ipStrNbr)                           'report fatal error and TERMINATE program! 
      
    Elseif ipStrNbr < 21 then                         'get data from CritStrs$ array
      Dat$=CritStrs$(ipStrNbr)
      
    Else                                              'get data from Strings.dat file
      If NOT StringsOpen then
        'Open the Literal Strings file.
        on error skip 1
        Open StrFN$ FOR Random AS #10                 'Open the Literal Strings file.
        If MM.ERRNO <> 0 then                         'error occurred
          flErrMsg$=MM.ErrMsg$                        'save error msg
          on error clear                              'clear error indicators
          Disp_SDCardErr()                            'report fatal error and TERMINATE program!
        endif
        
        StringsOpen=1                                 'set file open flag
      Endif
      
      on error skip 1
      Seek #10,StrPtr(ipStrNbr)                       'set file position pointer to start of reqd record
      If MM.ERRNO <> 0 then                           'error occurred
        flErrMsg$=MM.ErrMsg$                          'save error msg
        on error clear                                'clear error indicators
        Disp_SDCardErr()                              'report fatal error and TERMINATE program!
      endif
      
      Line Input #10,Dat$                             'retrieve specified data string from the file
    endif
    
    j=LEN(spTxt1$)                                    'get the length of the spTxt1$ argument
    i=1
    
    do while j > 0                                    'current insert argument (spTxtn$) is not empty
      k=Instr(Dat$,"{" + Str$(i) + "}")               'find current insert placeholder in the string
      
      If k=0 then                                     'no placeholder for this insert number found 
        'quit trying to insert
        Exit Do
      Endif
      
      Select Case i      
        Case 1
          Ins$=spTxt1$
          j=LEN(spTxt2$)
        Case 2
          Ins$=spTxt2$
          j=LEN(spTxt3$)
        Case 3
          Ins$=spTxt3$
          j=LEN(spTxt4$)
        Case 4
          Ins$=spTxt4$
          j=0
      End Select
        
      'use the insert text to replace this insert placeholder
      Dat$=Left$(Dat$,k-1) + Ins$ + MID$(Dat$,k+3)
      
      i=i+1
    Loop
    
    GetStr=Dat$                                       'return the composite string
    
  end Function
  
  Function LoadStringPtrs()
    '
    Local Rec$,p,sp,fl    
    
    on error skip 1
    Open StrFN$ FOR INPUT AS #10                      'Open the Literal Strings file.
    If MM.ERRNO <> 0 then                             'error occurred
      flErrMsg$=MM.ErrMsg$                            'save error msg
      on error clear                                  'clear error indicators
      Disp_SDCardErr()                                'report fatal error and TERMINATE program!
    endif
    
    p=1                                               'at rec #1
    sp=5                                              'rec #1 start (skipping 1st 4 chars - Rec Nbr)
    fl=LOF(#10)                                       'length of the file (in bytes)
    
    Do
      StrPtr(p)=sp                                    'save the pointer to the next (or first) record
      Line Input #10,Rec$
      'the LOC(#10) pointer AFTER the LINE INPUT stmt will point to the start of the NEXT record.
      sp=LOC(#10)+5                                   'remember the pointer to the next record -
      '                                               'skipping the LF + first 4 chars (Rec Nbr).
      if p<21 then CritStrs$(p)=Mid$(Rec$,5)          'save first 20 strings in CritStrs$ array.
      
      If sp>fl then                                   'reached the end of file
        exit do                                       '- exit loop now
      endif 
      
      p=p+1                                           'increment record nbr
    loop
    
    Close #10                                         'close the file
    
    LoadStringPtrs=p                                  'return value = # of records
    
  end Function
  
  Sub Disp_SDCardErr()
    'displays an error message if the SD Card is not configured/present.
    LOCAL c$,m1$,m2$,m3$
    Settick 0,0,4                                     'disable timer interrupt for updating date & time
    'NOTE:  cannot use text from the Strings.dat file here as this
    '=====  code may be called during program initialization and
    '       BEFORE any strings have been loaded (e.g. the SDCard is
    '       not available at program startup). Also need to use
    '       hard coded colors here as the program variables for the
    '       colors may not have been initialized yet either!!
    c$="FATAL ERROR: " + flErrMsg$
    m1$="Please ensure the SD Card containing the"
    m2$=StrFN$ + " file is inserted and"
    m3$="remains available while the program is running."
    CLS RGB(Blue)
    MessageBox(MM.HRES\2,75,c$,m1$,m2$,m3$,0,RGB(White),RGB(Blue),,,1)
    TEXT 0,160," ",LT,2
    Pause 500
    
    end                                               'Terminate the program
    
  end sub

  Sub Disp_StrErr(ipStrNbr)
    'displays an error message if the requested String # > max # loaded.
    LOCAL c$,m1$,m2$,m3$
    Settick 0,0,4                                     'disable timer interrupt for updating date & time
    c$="FATAL ERROR: Strings Access"
    m1$=GetStr(15,Str$(ipStrNbr))
    m2$=GetStr(16,STR$(StrCnt))
    m3$=GetStr(17,StrFN$)
    CLS RGB(Blue)
    MessageBox(MM.HRES\2,175,c$,m1$,m2$,m3$,0,RGB(White),RGB(Blue),,,1)
    TEXT 0,175," ",LT,2
    Pause 500
    
    end                                               'Terminate the program
    
  end sub