Option Explicit
Option Default None

Sub SineScrollTest
 Local rows as Integer
 rows = 20
 Local sp(rows) As Integer
 Local i% As Integer
 Local x% As Integer

	Do
	' Calcuate sine wave spaces
		For i%= 1 To rows
			sp(i%) = 38 + Sin((i% + x%) / 5) * 38
		Next i%

	' Draw it	
		Cls
		? "PRESS ANY KEY to Quit"
		For i%= 1 To rows
			? Space$(sp(i%));(i%+x%) mod rows + 1
		Next i

		' Delay to reduce flicker.
		Pause 100
		x% = x% + 1
	Loop While Inkey$="" Or x% <50
End Sub

Sub ShowAscii
 Local i% As Integer
	For i%=0 To 255
		? HEX$(i%,2);":";
		If i%<7 Or i%=11 Or i%=12 Or i%>13 Then
			? Chr$(i%);  ' OK to print.
		Else 'BEL,BS,HT,LF or CR
			? " ";
		EndIf
		If i% Mod 16 = 15 Then
			?
		Else
			? " ";
		EndIf
	Next i%
End Sub

Sub OverwriteTest
 Local i% As Integer
	
	? "OverWrite Line Test:"
	For i%=70 To 0 Step -1
		? Space$(i%);"Hello ";
		Pause 100
		? Chr$(13);
		If Inkey$ <> "" Then Exit For
	Next i%
	?
End Sub

Sub TestKeyPress
 Local a$
	? " Press any key & see it's Hex, Dec and printable character (in single quotes)"
	? " Press q to exit"
	Do
		a$ = Inkey$
		If a$ <> "" Then
			? "Hex Dec Chr:";HEX$(Asc(a$),2);Asc(a$);" '";a$;"'"
		EndIf
	Loop While Ucase$(a$) <> "Q"
End Sub

Sub SystemCmd
 Local a$
	? "Enter a DOS command (empty line to return to menu)"
	Do
		Line Input Chr$(175)+ " ", a$
		System "" + a$
	Loop While Len(a$)
End Sub

Dim arr$(20)

Sub DrawTable()
 Local vl As String = Chr$(179)'186) 'vert.line
 Local tl As String = Chr$(218)'201) ' top-left
 Local rd As String = Chr$(180)'185) ' Right divider
 Local tr As String = Chr$(191)'187) ' top-right
 Local bl As String = Chr$(192)'200) ' bottom-left
 Local bd As String = Chr$(193)'202) ' bottom-divider
 Local td As String = Chr$(194)'203) ' top-divider
 Local ld As String = Chr$(195)'204) ' left-divider
 Local hl As String = Chr$(196)'205) ' horiz.line
 Local cr As String = Chr$(197)'206) ' cross
 Local br As String = Chr$(217)'188) ' bottom-right
 Local sp As String = " "
 Local i%, mx% ' Maximum string length
 Local x$

	mx%=0
	For i%=0 to 20
		If Len(arr$(i%))>mx% Then mx%=Len(arr$(i%))
	Next i%
	? tl;hl;td;String$(mx%,hl);tr	'top row
	For i%=0 To 20
		x$=arr$(i%)
		If x$="-" Then
			'Print internal horizontal divider
			? ld;hl;cr;String$(mx%,hl);rd
		ElseIf x$ = "" then
			Exit For
		Else
			? vl;Left$(x$,1);vl;Mid$(x$,2);Space$(mx%-Len(x$)+1);vl
		EndIf
	Next i%
	? bl;hl;bd; String$(mx%,hl);br	'bottom row
End Sub

Sub Menu
 Local a$, bad%
	arr$(0)=" Main Menu"
	arr$(1)="-"
	arr$(2)="1SineScrollTest"
	arr$(3)="2ShowAscii"
	arr$(4)="3OverwriteTest"
	arr$(5)="4TestKeyPress"
	arr$(6)="5System Command"
	arr$(7)="-"
	arr$(8)="AAll Tests (1-3)"
	arr$(9)="-"
	arr$(10)="XeXit"

	Do
		Cls
		DrawTable
		'? "Main Menu"
		'? "1...SineScrollTest"
		'? "2...ShowAscii"
		'? "3...OverwriteTest"
		'? "4...TestKeyPress"
		'? "5...System Command"
		'?
		'? "A...All tests 1-3"
		'?
		'? "X...Exit"
		?
		? "Press Key for selection Choice, empty or X to Exit ";
		Do	' Wait for key press
			a$=Inkey$
		Loop while a$ = ""
		? a$
		
		Select Case Ucase$(a$)
		Case "1": SineScrollTest
		Case "2": ShowAscii
		Case "3": OverwriteTest
		Case "4": TestKeyPress
		Case "5": SystemCmd
		Case "A": SineScrollTest: ShowAscii: OverwriteTest
		Case Chr$(13),"X": Exit Sub
		Case Else
			bad% = 1
		End Select
		If bad% Then
			' Beep and reset error
			? "Bad Choice:";a$;Chr$(7)
			bad%=0
		EndIf
		?
		? "Press any key to continue.."
		Do:Loop While Inkey$=""
	Loop
End Sub
Menu
'LOAD "DOSSCREENTESTS.BAS",R
