Option Explicit
Option Default None

DIM AS STRING sErr
DIM AS INTEGER iErr

DIM AS STRING sTMPFILE="~!TMP.~D"

FUNCTION CURRDIR$()
 LOCAL AS STRING sLnBf
 LOCAL AS STRING sTF="CD"+sTMPFILE
	SYSTEM "DIR > "+sTF
	OPEN sTF FOR INPUT AS #9
	DO
		LINE INPUT #9, sLnBf
    IF LEFT$(sLnBf,14)=" Directory of " THEN
			CURRDIR$=MID$(sLnBf,15)+"\"
      EXIT DO
		ENDIF
	LOOP UNTIL EOF(#9)
  CLOSE #9
  KILL sTF
END FUNCTION

DIM AS INTEGER iLBcnt=20
Dim AS STRING saListBox(iLBcnt)

FUNCTION SelectFile$(Mask$,InitDir$)
 LOCAL AS INTEGER iCount
 LOCAL AS STRING sCWD=CURRDIR$()
 LOCAL AS STRING sLnBf
 LOCAL AS STRING sK ' STRING kEY
 LOCAL AS INTEGER iSel ' Selected Key
  IF Mask$="" THEN Mask$="*.*"
  IF InitDir$="" THEN InitDir$=sCWD
  ON ERROR SKIP
  CHDIR InitDir$ 'Chdir
  iErr=MM.ERRNO:sErr=MM.ERRMSG$ 
  IF iErr>0 THEN
    ? "Error ";STR$(iErr);": ";sErr
    EXIT FUNCTION
  ENDIF
  DO
    iCount=1
    KILL sCWD+sTMPFILE
    ON ERROR SKIP 3 ' If no files it generate an error
    SYSTEM "DIR /AD >"+sCWD+sTMPFILE '(directories)
    SYSTEM "DIR /-C "+Mask$+ " >>"+sCWD+sTMPFILE
    OPEN sCWD+sTMPFILE FOR INPUT AS #1
    saListBox(0)="K"+CURRDIR$()
    saListBox(1)="-"
    DO WHILE NOT(EOF(#1))
      LINE INPUT #1, sLnBf
      IF LEFT$(sLnBf+" ",1)<>" " AND RIGHT$(sLnBf,2)<>" ." THEN
        iCount=iCount+1
        saListBox(iCount)=CHR$(63+iCount)+sLnBf
        ' Does it already exist?
        FOR iSel=1 to iCount-1
          IF INSTR(saListBox(iSel),sLnBf)>0 THEN iCount=iCount-1
        NEXT iSel
        IF iCount=iLBcnt-2 THEN EXIT DO
      ENDIF
    LOOP
    CLOSE #1
    IF iCount<iLBCnt THEN
      saListBox(iCount+1)="-"
      saListBox(iCount+2)="XeXit this menu"
      IF iCount<iLBcnt-2 THEN saListBox(iCount+3)=""
    ENDIF
    DrawTable
    ?
    ? "Press Key for selection Choice, empty or X to Exit ";
    Do	' Wait for key press
      sK=Inkey$
    Loop while sK = ""
    sK=UCASE$(sK)
    iSel=ASC(sK)-63
    ? sK
    IF sK="X" THEN
      CHDIR sCWD
      EXIT FUNCTION
    ENDIF
    sK=MID$(saListBox(iSel),2)
    iCount=INSTR(sK,"<DIR>")
    IF iCount>0 THEN
      sK=Trim$(MID$(sK,iCount+5))
      CHDIR sK
    ELSE
      sK=Trim$(MID$(sK,24))
      iCount=INSTR(sK," ")
      sK=MID$(sK,iCount+1)
      SelectFile$=Trim$(MID$(saListBox(0),2))+sK
      CHDIR sCWD  ' Restore directory path
      EXIT FUNCTION
    ENDIF
  LOOP
END FUNCTION

Sub SineScrollTest
 Local i% As Integer
 Local x% As Integer
	Do
		CLS
		? "PRESS ANY KEY to Exit SineScrollTest"
    For i%= 1 To 24
      ? Space$(38 + Sin((i% + x%) / 5) * 38);(x%+i%)
		Next i
' Delay to reduce flicker.
		Pause 100
		x% = x% + 1
	Loop While Inkey$="" AND x% <77
End Sub

Sub ShowAscii
 Local i% As Integer
	For i%=0 To 255
		? HEX$(i%,2);":";
		If i%<>27 AND (i%<7 Or i%=11 Or i%=12 Or i%>13) Then
			? Chr$(i%);  ' OK to print.
		Else 'BEL,BS,HT,LF or CR
			? " ";
		EndIf
		If i% Mod 16 = 15 Then
			?
		Else
			? " ";
		EndIf
	Next i%
End Sub

Sub OverwriteTest
 Local i% As Integer
	
	? "OverWrite Line Test:"
	For i%=70 To 0 Step -1
		? Space$(i%);"Hello ";
		Pause 100
		? Chr$(13);
		If Inkey$ <> "" Then Exit For
	Next i%
	?
End Sub

Sub TestKeyPress
 Local a$
	? " Press any key & see it's Hex, Dec and printable character (in single quotes)"
	? " Press x to exit"
	Do
		a$ = Inkey$
		If a$ <> "" Then
			? "Hex Dec Chr:";HEX$(Asc(a$),2);Asc(a$);" '";a$;"'"
		EndIf
	Loop While Ucase$(a$) <> "X"
End Sub

Sub SystemCmd
 Local a$
	CLS
  ? "Enter a DOS command (empty line to return to menu)"
	Do
		Line Input Chr$(175)+ " ", a$
		If Len(a$)=0 Then
			Exit Do
		Else
			ON ERROR SKIP
      SYSTEM a$
      sErr=MM.ERRMSG$: iErr=MM.ERRNO
      IF iERR>0 THEN ? "Error ";STR$(iErr);": ";sErr
		EndIf
	Loop
End Sub

Sub DrawTable()
 Local vl As String = Chr$(179)'186) 'vert.line
 Local tl As String = Chr$(218)'201) ' top-left
 Local rd As String = Chr$(180)'185) ' Right divider
 Local tr As String = Chr$(191)'187) ' top-right
 Local bl As String = Chr$(192)'200) ' bottom-left
 Local bd As String = Chr$(193)'202) ' bottom-divider
 Local td As String = Chr$(194)'203) ' top-divider
 Local ld As String = Chr$(195)'204) ' left-divider
 Local hl As String = Chr$(196)'205) ' horiz.line
 Local cr As String = Chr$(197)'206) ' cross
 Local br As String = Chr$(217)'188) ' bottom-right
 Local sp As String = " "
 Local i%, mx% ' Maximum string length
 Local x$
'Get maximum width required for List Box
	mx%=0
	For i%=0 to 20
		If Len(saListBox(i%))>mx% Then mx%=Len(saListBox(i%))+2
	Next i%
	? tl;hl;td;String$(mx%,hl);tr	'top row
	For i%=0 To 20
		x$=saListBox(i%)
		If x$="-" Then
			'Print internal horizontal divider
			? ld;hl;cr;String$(mx%,hl);rd
		ElseIf x$ = "" then
			Exit For
		Else
      ' Print this row's data with dividers
			? vl; Left$(x$,1); vl; " "; Mid$(x$,2); Space$(mx%-Len(x$)); vl
		EndIf
	Next i%
	? bl;hl;bd; String$(mx%,hl);br	'bottom row
End Sub

DIM AS string sdb_name = "test.dat"

SUB DBMenu
	saListBox(0)="KSimple DB Main Menu"
	saListBox(1)="-"
	saListBox(2)="lList DBs"
	saListBox(3)="aAdd New DB"
	saListBox(4)="-"
	saListBox(5)=""
	saListBox(14)="-"
	saListBox(15)="XeXit to Main Menu"
END SUB

FUNCTION Ltrim$(sTxt AS STRING, sChrs AS STRING)
 LOCAL AS INTEGER i
 LOCAL AS STRING sChs=sChrs
  IF sChs="" THEN sChs=" "+CHR$(0)+CHR$(8)
  for i=1 TO LEN(sTxt)
    IF INSTR(sChs,MID$(sTxt,i,1))=0 THEN
      Ltrim$=MID$(sTxt,i)
      EXIT FUNCTION
    ENDIF
  NEXT i
END FUNCTION

FUNCTION Rtrim$(sTxt AS STRING, sChrs AS STRING)
 LOCAL AS INTEGER i
 LOCAL AS STRING sChs=sChrs
  IF sChs="" THEN sChs=" "+CHR$(0)+CHR$(8)
  for i=LEN(sTxt) TO 1 STEP -1
    IF INSTR(sChs,MID$(sTxt,i,1))=0 THEN
      Rtrim$=LEFT$(sTxt,i)
      EXIT FUNCTION
    ENDIF
  NEXT i
END FUNCTION

FUNCTION Trim$(sTxt AS STRING, sChrs AS STRING) AS STRING
  Trim$=Ltrim$(Rtrim$(sTxt, sChrs), sChrs)
END FUNCTION

FUNCTION EditLine$(s$,nohelp%)
 LOCAL k$,wk$,p%,ovr%  'keypress, Working String, position in working string,insert mode flag
  If nohelp%=0 THEN
    ? CHR$(13)+"Edit below use: Lft,Rt,Home,End,Del,Bkspc,INS toggle, Enter=Accept, Esc=Cancel:"
  ENDIF
  wk$=s$
  DO
    wk$=LEFT$(wk$,79)
    ? CHR$(13)+wk$+SPACE$(79-LEN(wk$));
    ? CHR$(13)+LEFT$(wk$,p%);
    DO
      k$=INKEY$
    LOOP WHILE k$=""
    SELECT case asc(k$)
    CASE 130: p%=p%-1: IF p%<0 THEN p%=0: ? CHR$(7); 'Left
    CASE 131: p%=p%+1: IF p%>LEN(wk$) THEN p%=LEN(wk$): ? CHR$(7); 'Right
    CASE 132: ovr%=NOT(ovr%) ' Insert Mode
    CASE 134: p%=0 'Home
    CASE 135: p%=LEN(wk$) 'End
    CASE 13: EditLine$=wk$:? CHR$(13);wk$;: EXIT FUNCTION 'Enter
    CASE 27: EditLine$=s$:? CHR$(13);s$+SPACE$(79-LEN(s$));CHR$(13);s$;:EXIT FUNCTION 'Esc
    CASE 8 'BackSpace
      IF p%>0 THEN
        wk$=LEFT$(wk$,p%-1) + MID$(wk$,p%+1):p%=p%-1
      ELSE
        ? CHR$(7);
      ENDIF
    CASE 127 'Del
      IF p%<LEN(wk$) THEN
        wk$=LEFT$(wk$,p%) + MID$(wk$,p%+2)
      ELSE
        ? CHR$(7);
      ENDIF
    CASE ELSE
      wk$=LEFT$(wk$,p%) + k$ + MID$(wk$,p%+1+ovr%)
      p%=p%+1
    END SELECT
  LOOP
END FUNCTION

SUB SimpleDB
' Original DEMO by Geoff Graham
' Some enhancements by Phil Dobber
 LOCAL AS INTEGER RecLen=64
 LOCAL cmd$, dat$
 LOCAL AS INTEGER nbr, nRecs,l
	ON ERROR SKIP 1
	sdb_name=SelectFile$("*.sdb")
  if sdb_name="" THEN EXIT SUB
  OPEN sdb_name FOR RANDOM AS #1
	CLS
  nRecs=LOF(#1)/RecLen
  SEEK #1, 1
  ? "SimpleDB - Editing ";sdb_name
  FOR nbr=1 TO nRecs
    ? STR$(nbr,4,0);": ";INPUT$(RecLen, #1)
  NEXT nbr
  DO
		abort: PRINT
    nRecs=LOF(#1)/RecLen
		PRINT "Number of records in the file =" nRecs
		? "Command (r = read, w = write, a = append, e = edit, d = display all, x = exit): ";
		DO
      cmd$=INKEY$
    LOOP WHILE LEN(cmd$)=0
    cmd$=LCase$(cmd$)
    ? cmd$
		IF cmd$ = "x" THEN CLOSE #1 : EXIT SUB
		IF cmd$ = "a" THEN
			SEEK #1, LOF(#1) + 1
		ELSEIF INSTR("wre",cmd$) > 0 THEN
			INPUT "Record Number: ", nbr
			IF nbr < 1 or nbr > LOF(#1)/RecLen THEN PRINT "Invalid record" : GOTO abort
			SEEK #1, RecLen * (nbr - 1) + 1
		ENDIF
		IF cmd$ = "r" THEN
			PRINT "The record = " INPUT$(RecLen, #1)
    ELSEIF cmd$="e" then
      dat$=LEFT$(EditLine$(Trim$(INPUT$(RecLen, #1))),RecLen)
			SEEK #1, RecLen * (nbr - 1) + 1
      PRINT #1, dat$ + SPACE$(RecLen-LEN(dat$));
		ELSEIF cmd$ = "w" or cmd$ = "a" THEN
			LINE INPUT "Enter the data to be written: ", dat$
			IF LEN(dat$) > RecLen THEN
				? "**Warning** length is >";RecLen;"characters: data truncated to:"
				dat$ = LEFT$(dat$,RecLen)
				? "'";dat$;"'"
			ENDIF
			PRINT #1,dat$ + SPACE$(RecLen - LEN(dat$));
		ELSEIF cmd$="d" THEN 'display/dump all records
      SEEK #1,1
      for nbr=1 to nRecs
        ? STR$(nbr,4,0);": ";INPUT$(RecLen, #1)
      NEXT nbr
    ELSE
			? "Invalid command...";CHR$(7);
		ENDIF
	LOOP
	CLOSE #1
END SUB

Sub Menu
 Local a$, bad%
	Do
		Cls
    saListBox(0)="KMain Menu"
    saListBox(1)="-"
    saListBox(2)="1SineScrollTest"
    saListBox(3)="2ShowAscii"
    saListBox(4)="3OverwriteTest"
    saListBox(5)="4TestKeyPress"
    saListBox(6)="5System Command"
    saListBox(7)="6SimpleDB"
    saListBox(8)="-"
    saListBox(9)="AAll Tests (1-3)"
    saListBox(10)="-"
    saListBox(11)="XeXit this menu"
    saListBox(12)="QQuit MMBASIC"
    saListBox(13)=""
		DrawTable
		?
		? "Press Key for selection Choice, empty or X to Exit ";
		Do	' Wait for key press
			a$=Inkey$
		Loop while a$ = ""
		? a$
		a$=UCASE$(a$)
		Select Case a$
		Case "1": SineScrollTest
		Case "2": ShowAscii
		Case "3": OverwriteTest
		Case "4": TestKeyPress
		Case "5": SystemCmd
    CASE "6": SimpleDB
		Case "A": SineScrollTest: ShowAscii: OverwriteTest
    CASE "Q": QUIT
		Case Chr$(13),"X", CHR$(27): Exit Sub
		Case Else
			bad% = 1
		End Select
		If bad% Then
			' Beep and reset error
			? "Bad Choice:";a$;Chr$(7)
			bad%=0
		EndIf
		if INSTR("124A",a$) THEN
      ?
      ? "Press any key to continue.."
      Do:Loop While Inkey$=""
    ENDIF
	Loop
End Sub
Menu

SUB Tst
  LOCAL AS STRING testStr="Hello"
  TestStr= EditLine$("Hello")
  ? "='";TestStr;"', Length is";LEN(TestStr)
  ? "Trim$('AABA23BBAA','AB') is '"; Trim$("AABA23BBAA", "AB");"' should be 23"
  SYSTEM "DIR /AD" '(directories)
  SYSTEM "DIR /-C" ' file-sizes without commas
  ? SelectFile$("","C:\Users\phil\Apps\")
END SUB
'Following method uses Notepad (works properly but is a pain)
      'OPEN sTmpFile FOR OUTPUT AS #2
      'PRINT #2, Trim$(INPUT$(RecLen, #1))
      'CLOSE #2
      'SYSTEM "Notepad "+sTmpFile
      'OPEN sTmpFile FOR INPUT AS #2
      'l=LOF(#2)
      'IF l > RecLen THEN l=RecLen
			'SEEK #1, RecLen * (nbr - 1) + 1
      'PRINT #1, INPUT$(l, #2)+SPACE$(RecLen-l);
      'CLOSE #2

'LOAD "DOSSCREENTESTS.BAS",R
