Option Explicit
Option Default None

DIM AS STRING sErr
DIM AS INTEGER iErr

DIM AS STRING sTMPFILE="~!TMP.~D"
CONST MAXW=79

FUNCTION CURRDIR$()
 LOCAL AS STRING sLnBf
 LOCAL AS STRING sTF="CD"+sTMPFILE
	SYSTEM "DIR > "+sTF
	OPEN sTF FOR INPUT AS #9
	DO
		LINE INPUT #9, sLnBf
    IF LEFT$(sLnBf,14)=" Directory of " THEN
			CURRDIR$=MID$(sLnBf,15)+"\"
      EXIT DO
		ENDIF
	LOOP UNTIL EOF(#9)
  CLOSE #9
  KILL sTF
END FUNCTION

DIM AS INTEGER iLBcnt=20
Dim AS STRING saListBox(iLBcnt)

FUNCTION SelectFile$(Mask$,InitDir$)
 LOCAL AS INTEGER iCount
 LOCAL AS STRING sCWD=CURRDIR$()
 LOCAL AS STRING sLnBf
 LOCAL AS STRING sK ' STRING kEY
 LOCAL AS INTEGER iSel ' Selected Key
  TblDvdr="|"
  IF Mask$="" THEN Mask$="*.*"
  IF InitDir$="" THEN InitDir$=sCWD
  ON ERROR SKIP
  CHDIR InitDir$ 'Chdir
  iErr=MM.ERRNO:sErr=MM.ERRMSG$ 
  IF iErr>0 THEN
    ? "Error ";STR$(iErr);": ";sErr
    EXIT FUNCTION
  ENDIF
  DO
    iCount=1
    ON ERROR SKIP 4 ' If no files it generate an error
    KILL sCWD+sTMPFILE
    SYSTEM "DIR /AD >"+sCWD+sTMPFILE '(directories)
    SYSTEM "DIR /-C "+Mask$+ " >>"+sCWD+sTMPFILE
    OPEN sCWD+sTMPFILE FOR INPUT AS #1 'THIS WILL CRASH IF LAST 2 STATEMENTS BOTH FAIL
    saListBox(0)="Key"+TblDvdr+CURRDIR$()
    saListBox(1)="-"
    DO WHILE NOT(EOF(#1))
      LINE INPUT #1, sLnBf
      IF LEFT$(sLnBf+" ",1)<>" " AND RIGHT$(sLnBf,2)<>" ." THEN
        iCount=iCount+1
        saListBox(iCount)=CHR$(63+iCount)+"|"+sLnBf
        ' Does it already exist?
        FOR iSel=1 to iCount-1
          IF INSTR(saListBox(iSel),sLnBf)>0 THEN iCount=iCount-1
        NEXT iSel
        IF iCount=iLBcnt-2 THEN EXIT DO
      ENDIF
    LOOP
    CLOSE #1
    IF iCount<iLBCnt THEN
      saListBox(iCount+1)="-"
      saListBox(iCount+2)="X"+TblDvdr+"eXit this menu"
      IF iCount<iLBcnt-2 THEN saListBox(iCount+3)=""
    ENDIF
    DrawTable
    ?
    ? "Press Key for selection Choice, empty or X to Exit ";
    Do	' Wait for key press
      sK=Inkey$
    Loop while sK = ""
    sK=UCASE$(sK)
    iSel=ASC(sK)-63
    ? sK
    IF sK="X" THEN
      CHDIR sCWD
      EXIT FUNCTION
    ENDIF
    sK=MID$(saListBox(iSel),2)
    iCount=INSTR(sK,"<DIR>")
    IF iCount>0 THEN ' This is a directory, change to it.
      sK=Trim$(MID$(sK,iCount+5))
      CHDIR sK
    ELSE 'This is a file, return it
      sK=Trim$(MID$(sK,25))
      iCount=INSTR(sK," ")
      sK=MID$(sK,iCount+1)
      SelectFile$=Trim$(GetField$(saListBox(0),2,TblDvdr))+sK
      ? SelectFile$
      CHDIR sCWD  ' Restore directory path
      EXIT FUNCTION
    ENDIF
  LOOP
END FUNCTION

Sub SineScrollTest
 Local i% As Integer
 Local x% As Integer
	Do
		CLS
		? "PRESS ANY KEY to Exit SineScrollTest"
    For i%= 1 To 24
      ? Space$(MAXW\2 + Sin((i% + x%) / 5) * MAXW\2);(x%+i%)
		Next i
' Delay to reduce flicker.
		Pause 100
		x% = x% + 1
	Loop While Inkey$="" AND x% <77
End Sub

Sub ShowAscii
 Local i%,r%
 LOCAL a$=""
	TblDvdr=CHR$(8)
  For i%=1 to 16
    a$=a$+"Hx"+TblDvdr+"C"+TblDvdr
  NEXT i%
  saListBox(0)=a$
  r%=1
  saListBox(r%)="-"  'Divider
  a$=""
  For i%=0 To 255
    a$=a$+HEX$(i%,2)+TblDvdr
		If i%<>27 AND (i%<7 Or i%=11 Or i%=12 Or i%>13) Then
			a$=a$+Chr$(i%)  ' OK to print.
		Else 'BEL,BS,HT,LF or CR
			a$=a$+" "
		EndIf
    IF i% MOD 16<15 THEN
      a$=a$+TblDvdr
    ELSE
      r%=r%+1
      saListBox(r%)=a$
      a$=""
    ENDIF
  NEXT i%
  DrawTable
End Sub

Sub OverwriteTest
 Local i% As Integer
	? "OverWrite Line Test:"
	For i%=70 To 0 Step -1
		? Space$(i%);"Hello ";
		Pause 100
		? Chr$(13);
		If Inkey$ <> "" Then Exit For
	Next i%
	?
End Sub

Sub TestKeyPress
 'I think something like this was in original Maximite demo program
 Local a$
	? " Press any key & see it's Hex, Dec and printable character (in single quotes)"
	? " Press x to exit"
	Do
		a$ = Inkey$
		If a$ <> "" Then
			? "Hex Dec Chr:";HEX$(Asc(a$),2);Asc(a$);" '";a$;"'"
		EndIf
	Loop While Ucase$(a$) <> "X"
End Sub

Sub SystemCmd
 Local a$
	CLS
	Do
  ? "Enter a DOS command (empty line to return to menu)"
		Line Input Chr$(175)+ " ", a$
		If Len(a$)=0 Then
			Exit Do
		ENDIF
    ON ERROR SKIP
    SYSTEM a$
    sErr=MM.ERRMSG$: iErr=MM.ERRNO
    IF iERR>0 THEN ? "Error ";STR$(iErr);": ";sErr
	Loop
End Sub

DIM AS STRING TblDvdr
Sub DrawTable()
 Local As String vl = Chr$(179)'186) 'vert.line
 Local As String tl = Chr$(218)'201) ' top-left
 Local As String rd = Chr$(180)'185) ' Right divider
 Local As String tr = Chr$(191)'187) ' top-right
 Local As String bl = Chr$(192)'200) ' bottom-left
 Local As String bd = Chr$(193)'202) ' bottom-divider
 Local As String td = Chr$(194)'203) ' top-divider
 Local As String ld = Chr$(195)'204) ' left-divider
 Local As String hl = Chr$(196)'205) ' horiz.line
 Local As String cr = Chr$(197)'206) ' cross
 Local As String br = Chr$(217)'188) ' bottom-right
 Local As String sp = " "
 LOCAL AS INTEGER MAXCOLS=(MAXW-1)\2
 Local i%, j%, l%, mx%(MAXCOLS) ' Maximum string lengths for each column
 Local x$,y$,tmp$
  tmp$=dfltdelim$
  dfltdelim$=TblDvdr
'Get maximum widths required for each field in List Box
	FOR j%=1 to MAXCOLS
    For i%=0 to 20
      IF LEN(saListBox(i%))=0 THEN EXIT FOR
      l%=Len(GetField$(saListBox(i%),j%))
      If l%>mx%(j%) Then mx%(j%)=l%
    Next i%
  NEXT j%
  ' Get column count
  FOR l%=MAXCOLS TO 1 STEP -1
    if mx%(l%)<>0 THEN EXIT FOR
  NEXT l%
  ? tl;  'Top row
  FOR j%=1 to l%
    ? STRING$(mx%(j%),hl);
    IF j%=l% THEN
      ? tr
    ELSE
      ? td;
    ENDIF
  NEXT j%
  For i%=0 To 20  'intermdiate rows
     x$=saListBox(i%)
    If x$="-" Then
      'Print internal horizontal divider
      ? ld;
      FOR j%=1 to l%
        ? STRING$(mx%(j%),hl);
        IF j%=l% THEN
          ? rd
        ELSE
          ? cr;
        ENDIF
      NEXT j%
    ElseIf x$ = "" then
      Exit For
    Else
      ' Print this row's data with dividers
      ? vl;
      FOR j%=1 TO l%
        y$=GetField$(x$,j%)
        ? y$;Space$(mx%(j%)-Len(y$)); vl;
      NEXT j%
      ?
    ENDIF
  Next i%
	? bl; 'bottom row
  FOR j%=1 to l%
    ? STRING$(mx%(j%),hl);
    IF j%=l% THEN ? br ELSE ? bd; :ENDIF
  NEXT j%
  dfltdelim$=tmp$ 'Restore default delimiter for GetField$
End Sub

FUNCTION Ltrim$(sTxt AS STRING, sChrs AS STRING)
 LOCAL AS INTEGER i
 LOCAL AS STRING sChs=sChrs
  IF sChs="" THEN sChs=" "+CHR$(0)+CHR$(8)
  for i=1 TO LEN(sTxt)
    IF INSTR(sChs,MID$(sTxt,i,1))=0 THEN
      Ltrim$=MID$(sTxt,i)
      EXIT FUNCTION
    ENDIF
  NEXT i
END FUNCTION

FUNCTION Rtrim$(sTxt AS STRING, sChrs AS STRING)
 LOCAL AS INTEGER i
 LOCAL AS STRING sChs=sChrs
  IF sChs="" THEN sChs=" "+CHR$(0)+CHR$(8)
  for i=LEN(sTxt) TO 1 STEP -1
    IF INSTR(sChs,MID$(sTxt,i,1))=0 THEN
      Rtrim$=LEFT$(sTxt,i)
      EXIT FUNCTION
    ENDIF
  NEXT i
END FUNCTION

FUNCTION Trim$(sTxt AS STRING, sChrs AS STRING) AS STRING
  Trim$=Ltrim$(Rtrim$(sTxt, sChrs), sChrs)
END FUNCTION

FUNCTION FindLast(sSearchStr AS STRING, sToFind AS STRING, iIgnoreCase AS INTEGER) AS INTEGER
  LOCAL i%
  LOCAL AS INTEGER iLss=LEN(sSearchStr)
  LOCAL AS INTEGER iLtf=LEN(sToFind)
  LOCAL AS STRING sSS=sSearchStr
  LOCAL AS STRING sTF=sToFind

  IF iLtf>iLss THEN EXIT FUNCTION
  IF iIgnoreCase<>0 THEN
    sSS=UCASE$(sSearchStr)
    sTF=UCASE$(sToFind)
  ENDIF
  FOR i%=iLss-iLtf+1 to 1 STEP -1
    IF MID$(sSS,i%,iLtf)=sTF THEN FindLast=i%: EXIT FUNCTION
  NEXT i%
END FUNCTION

DIM AS STRING dfltdelim$

FUNCTION GetField$(rc$,fld%,delim$)
 LOCAL AS INTEGER p1
 LOCAL AS INTEGER p2
 LOCAL AS INTEGER c
  IF delim$="" THEN delim$=dfltdelim$ 'if not provided
  IF delim$="" THEN delim$="," 'if no default, use comma
  DO WHILE p2<LEN(rc$)
    c=c+1
    p2=INSTR(p1+1,rc$,delim$)
    if p2=0 then p2=LEN(rc$)+1
    IF c=fld% THEN
      GetField$=MID$(rc$,p1+1,p2-p1-1)
      EXIT FUNCTION
    ENDIF
    p1=p2
  LOOP
END FUNCTION

FUNCTION ChrCnt(s$,ch$) AS INTEGER
LOCAL p%
  DO
    p%=INSTR(p%+1,s$,ch$)
    IF p%>0 THEN
      ChrCnt=ChrCnt+1
      p%=p%+LEN(ch$)-1
    ELSE
      EXIT DO
    ENDIF
  LOOP
END FUNCTION

FUNCTION EditLine$(s$,nohelp%)
 LOCAL k$,wk$,p%,ovr%  'keypress, Working String, position in working string,insert mode flag
  If nohelp%=0 THEN
    ? CHR$(13)+"Edit below use: Lft,Rt,Home,End,Del,Bkspc,INS toggle, Enter=Accept, Esc=Cancel:"
  ENDIF
  wk$=s$
  DO
    wk$=LEFT$(wk$,MAXW)
    ? CHR$(13)+wk$+SPACE$(MAXW-LEN(wk$));
    ? CHR$(13)+LEFT$(wk$,p%);
    DO
      k$=INKEY$
    LOOP WHILE k$=""
    SELECT case asc(k$)
    CASE 130: p%=p%-1: IF p%<0 THEN p%=0: ? CHR$(7); 'Left
    CASE 131: p%=p%+1: IF p%>LEN(wk$) THEN p%=LEN(wk$): ? CHR$(7); 'Right
    CASE 132: ovr%=NOT(ovr%) ' Insert Mode
    CASE 134: p%=0 'Home
    CASE 135: p%=LEN(wk$) 'End
    CASE 13: EditLine$=wk$:? CHR$(13);wk$;: EXIT FUNCTION 'Enter
    CASE 27: EditLine$=s$:? CHR$(13);s$+SPACE$(MAXW-LEN(s$));CHR$(13);s$;:EXIT FUNCTION 'Esc
    CASE 8 'BackSpace
      IF p%>0 THEN
        wk$=LEFT$(wk$,p%-1) + MID$(wk$,p%+1):p%=p%-1
      ELSE
        ? CHR$(7);
      ENDIF
    CASE 127 'Del
      IF p%<LEN(wk$) THEN
        wk$=LEFT$(wk$,p%) + MID$(wk$,p%+2)
      ELSE
        ? CHR$(7);
      ENDIF
    CASE ELSE
      wk$=LEFT$(wk$,p%) + k$ + MID$(wk$,p%+1+ovr%)
      p%=p%+1
    END SELECT
  LOOP
END FUNCTION

SUB SimpleDB
' Original DEMO by Geoff Graham
' Some enhancements by Phil Dobber
 LOCAL AS INTEGER RecLen=64
 LOCAL cmd$, dat$
 LOCAL AS INTEGER nbr, nRecs,l
 LOCAL AS STRING sdb_name
	ON ERROR SKIP 1
	sdb_name=SelectFile$("*.sdb")
  if sdb_name="" THEN EXIT SUB
  OPEN sdb_name FOR RANDOM AS #1
	CLS
  nRecs=LOF(#1)/RecLen
  SEEK #1, 1
  ? "SimpleDB - Editing ";sdb_name
  FOR nbr=1 TO nRecs
    ? STR$(nbr,4,0);": ";INPUT$(RecLen, #1)
  NEXT nbr
  DO
		abort: PRINT
    nRecs=LOF(#1)/RecLen
		PRINT "Number of records in the file =" nRecs
		? "Command (r=read, w=write, a=append, e=edit, l=list all, d=display deleted, x=exit): ";
		DO
      cmd$=INKEY$
    LOOP WHILE LEN(cmd$)=0
    cmd$=LCase$(cmd$)
    ? cmd$
		IF cmd$ = "x" THEN CLOSE #1 : EXIT SUB
		IF cmd$ = "a" THEN
			SEEK #1, LOF(#1) + 1
		ELSEIF INSTR("wre",cmd$) > 0 THEN
			INPUT "Record Number: ", nbr
			IF nbr < 1 or nbr > LOF(#1)/RecLen THEN PRINT "Invalid record" : GOTO abort
			SEEK #1, RecLen * (nbr - 1) + 1
		ENDIF
		IF cmd$ = "r" THEN
			PRINT "The record = " INPUT$(RecLen, #1)
    ELSEIF cmd$="e" then
      dat$=LEFT$(EditLine$(Trim$(INPUT$(RecLen, #1))),RecLen)
			SEEK #1, RecLen * (nbr - 1) + 1
      PRINT #1, dat$ + SPACE$(RecLen-LEN(dat$));
		ELSEIF cmd$ = "w" or cmd$ = "a" THEN
			LINE INPUT "Enter the data to be written: ", dat$
			IF LEN(dat$) > RecLen THEN
				? "**Warning** length is >";RecLen;"characters: data truncated to:"
				dat$ = LEFT$(dat$,RecLen)
				? "'";dat$;"'"
			ENDIF
			PRINT #1,dat$ + SPACE$(RecLen - LEN(dat$));
		ELSEIF cmd$="l" OR cmd$="d" THEN 'list/display/dump all records
      SEEK #1,1
      for nbr=1 to nRecs
        dat$=INPUT$(RecLen, #1)
        'Hide deleted unless d pressed
        IF LEFT$(dat$,1)<>"#" OR cmd$="d" THEN ? STR$(nbr,4,0);": ";dat$
      NEXT nbr
    ELSE
			? "Invalid command...";CHR$(7);
		ENDIF
	LOOP
	CLOSE #1
END SUB

SUB Info
 LOCAL AS STRING bar=STRING$(60,"-")
  CLS
  ? "MicroMite ";MM.DEVICE$;" Version ";MM.VER
  ? bar
  MEMORY
  ? bar
  ?
  ? "Running on System: ";:SYSTEM "hostname"
  ? "...as user ";:SYSTEM "ECHO %USERNAME%"
  ? "Current Host Directory: ";:SYSTEM "CD"
  ? bar
END SUB

Sub Menu
 Local a$, bad%
	Do
		Cls
    saListBox(0)="Key|Main Menu|A demo of some features of DOS MMBASIC"
    saListBox(1)="-"
    saListBox(2)="1|SineScrollTest"
    saListBox(3)="2|ShowAscii|now uses SUB DrawTable()"
    saListBox(4)="3|OverwriteTest|this shows that editing a line is possible"
    saListBox(5)="4|TestKeyPress|some keys still may generate double codes"
    saListBox(6)="5|System Command|...i.e. a DOS command, like DIR"
    saListBox(7)="6|SimpleDB|Geoff's demo plus string editing"
    saListBox(8)="7|MakeTestWrapper|Proof of concept - work in progress"
    saListBox(9)="-"
    saListBox(10)="A|All Tests (1-3)"
    saListbox(11)="I|System info|Basic info on MM & DOS environments"
    saListBox(12)="-"
    saListBox(13)="X|eXit this menu"
    saListBox(14)="Q|Quit MMBASIC|Closes the DOS window"
    saListBox(15)=""
    TblDvdr="|"
		DrawTable
		?
		? "Press Key for selection Choice, empty or X to Exit ";
		Do	' Wait for key press
			a$=Inkey$
		Loop while a$ = ""
		? a$
		a$=UCASE$(a$)
		Select Case a$
		Case "1": SineScrollTest
		Case "2": ShowAscii
		Case "3": OverwriteTest
		Case "4": TestKeyPress
		Case "5": SystemCmd
    CASE "6": SimpleDB
    CASE "7": MakeTestWrapper
		Case "A": SineScrollTest: ShowAscii: OverwriteTest
    CASE "I": Info
    CASE "Q": QUIT
		Case Chr$(13),"X", CHR$(27): Exit Sub
		Case Else
			bad% = 1
		End Select
		If bad% Then
			' Beep and reset error
			? "Bad Choice:";a$;Chr$(7)
			bad%=0
		EndIf
		if INSTR("124A7I",a$) THEN
      ?
      ? "Press any key to continue..";
      Do:Loop While Inkey$=""
      ?
    ENDIF
	Loop
End Sub
Menu

SUB MakeTestWrapper(flnm$)
 LOCAL AS STRING teststr
 LOCAL AS STRING q=CHR$(34)
 if flnm$="" THEN flnm$=SelectFile$()
 LOCAL iSlash AS INTEGER
  ? flnm$
  iSlash=FindLast(flnm$,"\")
  IF iSlash=0 THEN
    ? "No file selected"
    EXIT SUB
  ENDIF
 LOCAL AS STRING toflnm$=LEFT$(flnm$,iSlash)+"~"+MID$(flnm$,iSlash+1)
? "toflnm$='";toflnm$;"'"
  OPEN flnm$ for INPUT as #1
  OPEN toflnm$ for OUTPUT as #2
' Collect SUBs & FUNCTIONs
  DO WHILE NOT EOF(#1)
    line input #1, teststr
    IF UCASE$(LEFT$(Ltrim$(teststr),4))="SUB " THEN
      ? teststr
    ELSEIF UCASE$(LEFT$(Ltrim$(teststr),9))="FUNCTION " THEN
      ? teststr
    ENDIF
    ? #2, teststr
  LOOP
  CLOSE #1
  ? #2, "SUB _._TEST."
  ? #2, "  ? ";q;" Testting Wrapper";q
  ? #2, "END SUB"
  ? #2, "_._TEST."
  CLOSE #2
  ? "Do you want to run "+toflnm$+"(Y/N)?";
  INPUT q
  IF UCASE$(q)="Y" THEN LOAD toflnm$,R
END SUB

SUB Tst
 LOCAL AS STRING testStr="Hello"
  TestStr= EditLine$("Hello")
  ? "='";TestStr;"', Length is";LEN(TestStr)
  ? "Trim$('AABA23BBAA','AB') is '"; Trim$("AABA23BBAA", "AB");"' should be 23"
  SYSTEM "DIR /AD" '(directories)
  SYSTEM "DIR /-C" ' file-sizes without commas
  ? SelectFile$("","C:\Users\phil\Apps\")
  MakeTestWrapper ' "DosScreenTests.bas"
END SUB

sub tstGF()
 LOCAL  xxx$="Field1#fld2#3##five#six"
 LOCAL iii%
  for iii%=0 to 7
    ? "'";GetField$(xxx$,iii%,"#");"'"
  next iii%
END SUB

'Following method uses Notepad (works properly but is a pain)
      'OPEN sTmpFile FOR OUTPUT AS #2
      'PRINT #2, Trim$(INPUT$(RecLen, #1))
      'CLOSE #2
      'SYSTEM "Notepad "+sTmpFile
      'OPEN sTmpFile FOR INPUT AS #2
      'l=LOF(#2)
      'IF l > RecLen THEN l=RecLen
			'SEEK #1, RecLen * (nbr - 1) + 1
      'PRINT #1, INPUT$(l, #2)+SPACE$(RecLen-l);
      'CLOSE #2

'LOAD "DOSSCREENTESTS.BAS",R
