'Simple terminal program v 0.1 by Rich Martin (datawiz) 11:13pm 02 Oct 2020
'Also code from Flashback.bas 1.0.0 by Rich Martin (datawiz)
'Version 1.5 John Crutti Jr 10-26-2020
' GetFileName Demonstration Program
' Shows usage for the GetFileName dialog function.
'
' by vegipete, October 2020
'   version 1.0   Original release
'   version 1.1   all navigation by arrow keys only, can return directory names too
'   version 1.2   remembers selection when moving back up directories, can specify
'                 file criteria, forcing selection type
'
'===================
' required setup for function of getfile routines
OPTION EXPLICIT
CONST DIRCOUNT = 50   ' max number of sub-directories
CONST FILCOUNT = 255  ' max number of files
CONST NAMELENGTH = 64
dim dir_dirs$(DIRCOUNT) length NAMELENGTH  ' store list of directories
dim dir_fils$(FILCOUNT) length NAMELENGTH  ' store list of files
dim dir_hist$(DIRCOUNT) length 8 ' store directory number visited along path
' end of setup for funtion
'===================
dim comportnum% = 1 ' COM port number as an integer for COM Port subroutine.
dim comportstr$ = "COM1" ' COM port as a string for COM Port subroutine.
dim comchoice% = 1 ' used in COM selection subroutine.
dim comspeedchoice% = 9 ' used in COM Speed selection subroutine.
dim comspeed$ = "115200" ' COM Speed as a string for COM Speed subroutine.
dim CHAR_OUT$
dim altflag% 
dim winflag%
dim CHARS_IN$
dim fixedchars$ ' not
dim echo% = 0
dim width%
dim height%
dim onlineflag% = 1
dim soundflag% = 0
dim fwidth% = mm.info(fontwidth)
dim fheight% = mm.info(fontheight)
dim xpos% = 0
dim ypos% = 0
dim echostr$
dim receivefile$
dim sendfile$
dim textchoice% = 0
dim textcolor = 1
dim C$
dim kp%, kl%, kf%
dim modemresetstring$ = "ATZ"
dim modeminitstring$ = "ATE1V1X0Q0&K0S0=7"
dim modeminfostring$ = "ATI"
'setup RTS/CTS pins
setpin 32,DOUT
setpin 33,DIN
PIN(32) = 0
dim TERM_COLOR1 = 255
dim TERM_COLOR2 = 255
dim TERM_COLOR3 = 255
dim TEXT_COLOR
dim debug%

'main function
cls
'load png "intro4.png"
introscreen
pause 2500
cls
welcomebanner
setcomport
setcomspeed
pickcolor
setupcolor
startcomport
terminalonline
modemreset
pause 500
modeminit
pause 500
modeminfo
do 'user input routine
CHAR_OUT$ = INKEY$
if CHAR_OUT$ <> "" then
  if CHAR_OUT$ = chr$(137) then download
    end if
  if CHAR_OUT$ = chr$(136) then upload
    end if
 C$ = getchar$()
  if altflag% = 1 then
  select case lcase$(C$)
      case "b"
        onlineflag% = 0
        cls
        close #5
        setcomport
        setcomspeed
        terminalonline
        startcomport
      case "c"
        text 400,300, "  CLEARING SCREEN  ", "CM",1,1, RGB(BLACK), RGB(WHITE)
        pause 750  
        welcomebanner      
      case "d"
        if winflag% = 1 then
          if debug% = 0 then 
            colour rgb(black), rgb(red)
            print "*** Debug Mode On *** (NOT IMPLEMENTED)"
          setupcolor
          debug% = 1
          else
            colour rgb(black), rgb(red)
            print "*** Debug Mode Off *** (NOT IMPLEMENTED)"
          setupcolor
          debug% = 0
          end if
        end if
      case "f"
        pickcolor
        setupcolor
      case "i"
        colour rgb(black), rgb(red)
        print "*** SENDING MODEM INITIALIZATION ***"
        setupcolor
        modeminit
      case "x"
        echo% = 0
        hangup
      case "q"
        termexit
      case "s"
        if soundflag% = 0 then
          print "Sound On"
          soundflag% = 1
        else
          print "Sound Off"
          soundflag% = 0
        end if
      case "h"
          cls
          dialogHelp
      case "e"    
        if echo% = 1 then
          colour rgb(black), rgb(red)
          print chr$(13); chr$(10); "*** Local Echo Off ***"
          setupcolor
          echo% = 0 
        else
          colour rgb(black), rgb(red)
          print chr$(13); chr$(10); "*** Local Echo On ***"
          setupcolor
          echo% = 1
        end if  
      case "p"
        comsettings  
      case "v"
        if winflag% = 1 then
          credits
        end if
      case "r"
        colour rgb(black), rgb(red)
        print "*** RESETTING MODEM ***"
        setupcolor
        modemreset
        pause 250
        modeminit
        pause 250
        modeminfo  
    end select
  else
    if C$ <> "" then    
      if soundflag% = 1 then play tone 1600, 1600, 10
    end if  
print #5, CHAR_OUT$;
end if
  if echo% = 1 AND CHAR_OUT$ <> "" then    
    echostr$ = INKEY$ 
print INKEY$  
end if
loop
end




function getchar$() as string
  altflag% = 0
  winflag% = 0
  getchar$ = ""
  if keydown(7) > 0 then
    kf% = keydown(7)
    if (kf% AND &b00000001) = &b00000001 then altflag% = 1 
    if (kf% AND &b00010000) = &b00010000 then altflag% = 1
    if (kf% AND &b00000100) = &b00000100 then winflag% = 1
    if (kf% AND &b00100000) = &b01000000 then winflag% = 1
  end if
  kp% = keydown(0)
  if kp% > 0 then
    kp% = keydown(1)
    if kl% <> kp% then
      getchar$ = chr$(kp%)    
      timer = 0
    else
      'if timer > kreprate then
       ' getchar$ = chr$(kp%)
        timer = 0
      end if
    end if
    kl% = kp%
    pause 10
  end if
end function


sub introscreen
  const ox = 35
  const oy = 15
  cls
  box ox*fwidth%, oy*fheight%, 28*fwidth%, 14*fheight%, 1,,rgb(black)
  print @((ox+2)*fwidth%,(oy+1)*fheight%) "        MAXITERM";
  print @((ox+2)*fwidth%,(oy+2)*fheight%) "        --------";
  print @((ox+2)*fwidth%,(oy+3)*fheight%) "";
  print @((ox+2)*fwidth%,(oy+4)*fheight%) "        for  the";
  print @((ox+2)*fwidth%,(oy+5)*fheight%) "    Color Maximite 2";
  print @((ox+2)*fwidth%,(oy+6)*fheight%) "";
  print @((ox+2)*fwidth%,(oy+7)*fheight%) "       Version 1.5";
  print @((ox+2)*fwidth%,(oy+8)*fheight%) "           by";
  print @((ox+2)*fwidth%,(oy+9)*fheight%) "       John Crutti";
  print @((ox+2)*fwidth%,(oy+10)*fheight%)"          2020";
  print @((ox+2)*fwidth%,(oy+11)*fheight%)"        Support at";
  print @((ox+2)*fwidth%,(oy+12)*fheight%)"   recstudio@gmail.com";
end sub

sub welcomebanner
cls
print "Terminal running. ALT-Q to Exit. ALT-H for Help."
end sub



sub pickcolor
print ""
input "Which color do you want 1.White [DEFAULT], 2.Amber, or 3.Green "; textchoice%
  if textchoice% = 0 then
  print "White Selected."
  textcolor = 1 
  elseif textchoice% > 3 then
  print "Invalid Selection."
  pickcolor
  else
  TEXT_COLOR = textchoice%
end if
end sub



sub setcomport
print ""
input "Which COM Port, COM 1 [DEFAULT] or 2 "; comchoice%
  if  comchoice% = 0 then
      comportstr$ = "COM1"
      comportnum% = 1
      print "COM1 Selected."
  elseif  comchoice% = 1 then
      comportstr$ = "COM1"
      comportnum% = 1
  elseif  comchoice% = 2 then 
      comportstr$ = "COM2"
      comportnum% = 2
  elseif  comchoice% > 2 then
      print "Invalid COM port, please try again."
      setcomport
  end if
end sub


sub setcomspeed
print ""
print "Select COM Port Speed"
print "1) 1200 BPS"
print "2) 2400 BPS"
print "3) 4800 BPS"
print "4) 9600 BPS"
print "5) 19200 BPS"
print "6) 38400 BPS"
print "7) 57600 BPS"
print "8) 115200 BPS [DEFAULT]"
input "Make Selection: ", comspeedchoice%
  if comspeedchoice% = 0 then
    print "115200 Selected."
      comspeed$ = "115200"
  elseif comspeedchoice% > 8 then
    print "Invalid selection. Please try again."
      setcomspeed
  elseif comspeedchoice% = 1 then
    comspeed$ = "1200"
  elseif comspeedchoice% = 2 then
    comspeed$ = "2400"
  elseif comspeedchoice% = 3 then
    comspeed$ = "4800"
  elseif comspeedchoice% = 4 then
    comspeed$ = "9600"
  elseif comspeedchoice% = 5 then
    comspeed$ = "19200"
  elseif comspeedchoice% = 6 then
    comspeed$ = "38400"
  elseif comspeedchoice% = 7 then
    comspeed$ = "57600"
  elseif comspeedchoice% = 8 then
    comspeed$ = "115200"
end if
onlineflag% = 1
end sub



sub setupcolor
if TEXT_COLOR = 1 then 
TERM_COLOR1 = 255
TERM_COLOR2 = 255
TERM_COLOR3 = 255
end if
if TEXT_COLOR = 2 then
TERM_COLOR1 = 255
TERM_COLOR2 = 176
TERM_COLOR3 = 0
end if
if TEXT_COLOR = 3 then
TERM_COLOR1 = 51
TERM_COLOR2 = 255
TERM_COLOR3 = 0
end if 
colour rgb(TERM_COLOR1,TERM_COLOR2,TERM_COLOR3), rgb(black)
end sub



sub startcomport
'close #5
open comportstr$+":"+comspeed$+","+"256"+",get_serial_input" as 5
end sub



sub modemreset
print #5; modemresetstring$
end sub


sub modeminit
print #5; modeminitstring$
end sub


sub modeminfo
print #5; modeminfostring$
end sub


sub get_serial_input
CHARS_IN$ = input$(LOC(#5),#5)
if onlineflag% = 1 then
   print CHARS_IN$;
end if
end sub



sub terminalonline
    colour rgb(black), rgb(red)
    print chr$(13); chr$(10); "*** TERMINAL ONLINE ***"
    setupcolor
end sub



sub download
cls
  print "Xmodem Download (REQUIRES 5.05.06 or higher firmware)"
  input "Enter Filename: "; receivefile$
  print "Please wait, downloading "; receivefile$
  XMODEM R receivefile$, comportnum% 
  print "Download Complete."
end sub



sub upload
cls
print "Xmodem Upload (REQUIRES 5.05.06 or higher firmware)"
input "Enter Filename: "; sendfile$  
  if sendfile$ = "" then
    colour rgb(black), rgb(red)
    print chr$(13); chr$(10); "*** Upload Cancelled ***"
    setupcolor
    pause 1500
    exit sub
  else
    print "Please wait, uploading "; sendfile$
    XMODEM S sendfile$, comportnum% 
    print "Upload Complete."
'sendfile$ = GetFileName(15,"*")
'MakeBox(75,30,550,50)
'text 115,40,"Uploading: "+sendfile$+"", "CM", 1, 1, RGB(WHITE), -1
end if
end sub



sub hangup
  colour rgb(black), rgb(red)
  print chr$(13); chr$(10); "*** DISCONNECTING ***"
  colour rgb(white), rgb(black)  
    onlineflag% = 0 'disable incoming data display while hanging up
      print #5; chr$(13); chr$(10)
      pause 1200 'take our time. too fast and modem will ignore
      print #5; chr$(43);chr$(43);chr$(43); 
      pause 1500 'take our time. too fast and modem will ignore
      print ""
      print #5;"ATH0"
  colour rgb(black), rgb(red)
    print "*** DISCONNECTED ***"
      setupcolor        
onlineflag% = 1
end sub

sub termexit
  colour rgb(red), rgb(black)
  close #5
  colour rgb(black), rgb(red)
  print chr$(13); chr$(10); "*** EXITING TERMINAL ***"
  setupcolor
pause 750
exit
end sub


sub comsettings
  local C$
  const ox = 20
  const oy = 15
  cls
  box ox*fwidth%, oy*fheight%, 50*fwidth%, 14*fheight%, 1,,rgb(black)
  print @((ox+2)*fwidth%,(oy+1)*fheight%) "CURRENT COM PORT SETTINGS";
  print @((ox+2)*fwidth%,(oy+2)*fheight%) "-------------------------";
  print @((ox+2)*fwidth%,(oy+3)*fheight%) "A.COM PORT      :", comportstr$
  print @((ox+2)*fwidth%,(oy+4)*fheight%) "B.BAUD RATE     :", comspeed$
  print @((ox+2)*fwidth%,(oy+5)*fheight%) "C.CONFIGURATION : 8-N-1 ";
  print @((ox+2)*fwidth%,(oy+6)*fheight%) "D.DATA BITS     : 8";
  print @((ox+2)*fwidth%,(oy+7)*fheight%) "E.PARITY        : NONE";
  print @((ox+2)*fwidth%,(oy+8)*fheight%) "F.FLOW CONTROL  : (NOT IMPLEMENTED)";
  print @((ox+2)*fwidth%,(oy+9)*fheight%) "G.STOP BITS     : 1";
  print @((ox+2)*fwidth%,(oy+10)*fheight%)"H.";
  print @((ox+2)*fwidth%,(oy+11)*fheight%)"I.INIT STRING   :", modeminitstring$
  print @((ox+2)*fwidth%,(oy+12)*fheight%)"To change settings, hit ALT-B in Terminal.";
  do while inkey$ = "" : loop
welcomebanner
end sub


sub dialogHelp
  local C$
  const ox = 30
  const oy = 15
  box ox*fwidth%, oy*fheight%, 38*fwidth%, 20*fheight%, 1,,rgb(black)
  print @((ox+2)*fwidth%,(oy+1)*fheight%) "ALT-B Change COM Port Settings";
  print @((ox+2)*fwidth%,(oy+2)*fheight%) "ALT-C Clear Screen";
  print @((ox+2)*fwidth%,(oy+3)*fheight%) "ALT-E Local Echo on/off";
  print @((ox+2)*fwidth%,(oy+4)*fheight%) "ALT-F Change the Font Color";
  print @((ox+2)*fwidth%,(oy+5)*fheight%) "ALT-H Help Menu";
  print @((ox+2)*fwidth%,(oy+6)*fheight%) "ALT-I Send Modem Initialization";
  print @((ox+2)*fwidth%,(oy+7)*fheight%) "ALT-P Show COM Port Settings";
  print @((ox+2)*fwidth%,(oy+8)*fheight%) "ALT-Q Quit and Exit Terminal";
  print @((ox+2)*fwidth%,(oy+9)*fheight%) "ALT-R Reset the Modem";
  print @((ox+2)*fwidth%,(oy+10)*fheight%) "ALT-S Key Sound on/off";
  print @((ox+2)*fwidth%,(oy+11)*fheight%) "ALT-X Disconnect Session";
  print @((ox+2)*fwidth%,(oy+12)*fheight%) "";
  print @((ox+2)*fwidth%,(oy+13)*fheight%) "Page UP = Upload File";
  print @((ox+2)*fwidth%,(oy+14)*fheight%)"Page DOWN = Download File";
  print @((ox+2)*fwidth%,(oy+15)*fheight%) "";
  print @((ox+2)*fwidth%,(oy+16)*fheight%)"ALT+WIN-D Toggle debug on/off";
  print @((ox+2)*fwidth%,(oy+17)*fheight%)"ALT+WIN-V Show Version info";
  do while inkey$ = "" : loop
welcomebanner
end sub

sub credits
  local C$
  const ox = 33
  const oy = 15
  box ox*fwidth%, oy*fheight%, 40*fwidth%, 13*fheight%, 1,,rgb(black)
  print @((ox+2)*fwidth%,(oy+1)*fheight%) "Maxiterm for the Color Maximite 2";
  print @((ox+2)*fwidth%,(oy+2)*fheight%) "---------------------------------";
  print @((ox+2)*fwidth%,(oy+3)*fheight%) "Version 1.5";
  print @((ox+2)*fwidth%,(oy+4)*fheight%) "John Crutti 2020";
  print @((ox+2)*fwidth%,(oy+5)*fheight%) "";
  print @((ox+2)*fwidth%,(oy+6)*fheight%) "";
  print @((ox+2)*fwidth%,(oy+7)*fheight%) "";
  print @((ox+2)*fwidth%,(oy+8)*fheight%) "Special thanks to Rich Martin and";
  print @((ox+2)*fwidth%,(oy+9)*fheight%) "vegipete from The Back Shed for";
  print @((ox+2)*fwidth%,(oy+10)*fheight%)"code and inspiration.";
  print @((ox+2)*fwidth%,(oy+11)*fheight%)"Support email: recstudio@gmail.com";
  do while inkey$ = "" : loop
welcomebanner
end sub



sub blinkcursor
  local x%, y%
  x% = xpos%
  y% = ypos%
  select case cursortype%
  case 0
    print @((x%+xoffset%)*fwidth%,(y%+yoffset%)*fheight%) " ";
    print @((x%+xoffset%)*fwidth%,(y%+yoffset%)*fheight%) "_";
  case 1
    print @((x%+xoffset%)*fwidth%,(y%+yoffset%)*fheight%) "/";
    print @((x%+xoffset%)*fwidth%,(y%+yoffset%)*fheight%) "-";
    print @((x%+xoffset%)*fwidth%,(y%+yoffset%)*fheight%) "\";
    print @((x%+xoffset%)*fwidth%,(y%+yoffset%)*fheight%) "|";
  case 2
    print @((x%+xoffset%)*fwidth%,(y%+yoffset%)*fheight%) ":";
    print @((x%+xoffset%)*fwidth%,(y%+yoffset%)*fheight%) "-";
  case 3
    print @((x%+xoffset%)*fwidth%,(y%+yoffset%)*fheight%) "<";
    print @((x%+xoffset%)*fwidth%,(y%+yoffset%)*fheight%) "^";
    print @((x%+xoffset%)*fwidth%,(y%+yoffset%)*fheight%) ">";
    print @((x%+xoffset%)*fwidth%,(y%+yoffset%)*fheight%) "v";
  end select
  print @((x%+xoffset%)*fwidth%,(y%+yoffset%)*fheight%) scr_text$(x%,y%);
end sub

' Draw a pleasant box on the screen. Background is not saved!
sub MakeBox(x,y,w,h)
  rbox x    , y    , w     , h     , 10,  &h4040E0, &h4040E0  ' frame
  rbox x + 5, y + 5, w - 10, h - 10,  5,  &h202080, &h202080  ' text area
end sub

' Fill the screen with something
sub FillBackground
  dim integer xorg(6) = (-10,-5,5,10,5,-5,-10)
  dim integer xgon(6)
  dim integer ygon(6) = (0,9,9,0,-9,-9,0)

  for j = 1 to 28
    for v = 0 to 6

      xgon(v) = xorg(v)
      ygon(v) = ygon(v) + 9
    next v

    for i = 1 to 26
      for v = 0 to 6
        xgon(v) = xgon(v) + 30
      next v
      polygon 6, xgon(), ygon(),rgb(white),rgb(rnd*255,rnd*255,rnd*255)
    next i

    for v = 0 to 6
      xgon(v) = xorg(v) + 15
      ygon(v) = ygon(v) + 9
    next v

    for i = 1 to 25
      for v = 0 to 6
        xgon(v) = xgon(v) + 30
      next v
      polygon 6, xgon(), ygon(),rgb(white),rgb(rnd*255,rnd*255,rnd*255)
    next i

  next j
end sub

'*****************************************************************
' Function GetFileName(vsize,spec$)
'
'   version 1.0    Original release vegipete, Oct 2020
'   version 1.1    all navigation by arrow keys only, can return directory names too
'
' This funtion displays a centered dialog box on the screen, allows
' the user to choose a file and returns the full path of the chosen
' file. The underlying screen is restored when the dialog closes.
' UP and DOWN arrows to select, ENTER to choose selection
' ESC to cancel, LEFT arrow to go up directory
'
' Input:  vsize: number of directory items to list vertically
'         spec$: currently unused, hopefully later it will allow file filtering
'
' Output: string containing full path of file chosen, or "" if nothing
'         Note: the directory part of the path will be capitalized. This is just
'         how the CWD$ function works. Fortunately, MMBasic is case insensitive.
'
' The following global variables should be declared before use:
' CONST DIRCOUNT = 50   ' max number of sub-directories
' CONST FILCOUNT = 255  ' max number of files
' CONST NAMELENGTH = 64
' dim dir_dirs$(DIRCOUNT) length NAMELENGTH  ' store list of directories
' dim dir_fils$(FILCOUNT) length NAMELENGTH  ' store list of files
' dim dir_hist$(DIRCOUNT) length 8 ' store directory number visited along path
' dim dir_notroot  ' used internally to indicate root directory or not
'
' Routines Used:  (included below)
'   sub ReadDir   ' reads current directory into the above arrays
'   sub ListDir(first, nlines, hilite)  ' shows a portion of the current directory
'
function GetFileName(vsize,spec$) as string
  ' dialog box dimensions
  d_shadow = &h303030   ' dark sort-of gold
  d_frame =  &hA0A040   ' sort-of gold
  d_back  =  &h101010   ' really dark grey
  d_lines = vsize
  d_height = 50 + (d_lines - 1) * MM.INFO(FONTHEIGHT)
  d_width = 300
  d_x = (MM.HRES - d_width)/2
  d_y = (MM.VRES - d_height)/2

  d_startdir$ = cwd$      ' save starting directory
  for d_k = 1 to DIRCOUNT ' set all elements to 1 - 1st item selected
    dir_hist$(d_k) = "1,1"
  next d_k
  dir_hist$(0) = "1"      ' initially at top directory level
  if d_startdir$ <> "A:/" then  ' determine starting directory depth
    d_startdir$ = d_startdir$ + "/"
    for d_k = 1 to len(d_startdir$)
      if mid$(d_startdir$,d_k,1) = "/" then
        dir_hist$(0) = str$(val(dir_hist$(0)) + 1) ' another level deeper
      endif
    next d_k
  endif

  ' save underlying screen image in buffer #64
  blit read 64, d_x, d_y, d_width, d_height
  ' draw dialog box
  rbox d_x + 7, d_y +  7, d_width -  8, d_height -  8, 10, d_shadow, d_shadow
  rbox d_x    , d_y     , d_width -  8, d_height -  8, 10,  d_frame, d_frame
  rbox d_x + 5, d_y + 22, d_width - 18, d_height - 34,  5,   d_back, d_back  ' text area
  if ucase$(spec$) = "<DIR>" then
    text d_x+10,d_y+6,"Select Directory...", "LT", 1, 1, 0, -1
  else
    text d_x+10,d_y+6,"Select File...", "LT", 1, 1, 0, -1
  endif
  dir_dirs$(0)=chr$(146)+chr$(147)+chr$(149)+" "+chr$(148)+"/Ent/Esc"   'temp
  text d_x+d_width-15,d_y+6,dir_dirs$(0), "RT", 1, 1, 0, -1

  '--------------------
  ReadDir(spec$,d_top_item,d_sel_item,d_top_last)
  ListDir(d_top_item, d_lines, d_sel_item)  ' populate the dialog box

  do
    d_k = asc(inkey$)
    d_changed = 0
    select case d_k
      case  27  ' ESC
        GetFileName$ = ""  ' Cancel so return blank
        exit do
      case 128  ' UP arrow
        if d_sel_item = 1 then  ' is the top item selected?
          if d_top_item > 1 then  ' at top of list?
            d_top_item = d_top_item - 1  ' no so shift list up one
            d_changed = 1
          endif
        else
          d_sel_item = d_sel_item - 1  ' shift selection up one
          d_changed = 1
        endif
      case 129  ' DOWN arrow
        if d_sel_item = d_lines then  ' is the bottom item selected?
          if d_top_item < d_top_last then  ' at bottom of list?
            d_top_item = d_top_item + 1  ' no so shift list down one
            d_changed = 1
          endif
        else if d_sel_item < val(dir_dirs$(0)) + val(dir_fils$(0)) then
          ' don't shift down past last item
          d_sel_item = d_sel_item + 1  ' shift selection down one
          d_changed = 1
        endif
      case 130  ' LEFT Arrow - directory up if not root
        if cwd$ <> "A:/" then ' in a sub-directory?
          chdir ".."     'directory up chosen
          ReadDir(spec$,d_top_item,d_sel_item,d_top_last)
          dir_hist$(0) = str$(val(dir_hist$(0)) - 1)
          d_top_item = val(field$(dir_hist$(val(dir_hist$(0))),1,","))
          d_sel_item = val(field$(dir_hist$(val(dir_hist$(0))),2,","))
          d_changed = 1
        endif
      case 131  ' RIGHT Arrow - directory down if directory selected
        d_chosen = d_top_item + d_sel_item - 1
        if d_chosen <= val(dir_dirs$(0)) then ' item number in directory range?

          dir_hist$(val(dir_hist$(0))) = str$(d_top_item) + "," + str$(d_sel_item)
          'dir_hist$(dir_hist$(0)) = d_chosen    ' save selection number if we come back up
          dir_hist$(0) = str$(val(dir_hist$(0)) + 1)

          if right$(cwd$,1) = "/" then
            chdir cwd$ + dir_dirs$(d_chosen)  ' tunnel down a directory from root
          else
            chdir cwd$ + "/" + dir_dirs$(d_chosen)  ' tunnel down a directory
          endif
          ReadDir(spec$,d_top_item,d_sel_item,d_top_last)
          d_changed = 1
        endif

      case  13  ' ENTER - something has been selected
        d_chosen = d_top_item + d_sel_item - 1
        if d_chosen <= val(dir_dirs$(0)) then ' item number in directory range?
          if ucase$(spec$) = "<DIR>" then   ' was directory selection chosen?
            if right$(cwd$,1) = "/" then
              GetFileName$ = cwd$ + dir_dirs$(d_chosen) + "/"  ' directory at root level
            else
              GetFileName$ = cwd$ + "/" + dir_dirs$(d_chosen) + "/"   ' directory deeper
            endif     ' Note: cwd$ returns all uppercase
            exit do
          endif
        else    ' Yahoo! A filename has been chosen
          if ucase$(spec$) <> "<DIR>" then   ' was other than directory selection chosen?
            d_chosen = d_chosen - val(dir_dirs$(0))
            if dir_fils$(d_chosen) <> "" then  ' in case directory has no (specified) file
              if right$(cwd$,1) = "/" then
                GetFileName$ = cwd$ + dir_fils$(d_chosen)  ' filename at root level
              else
                GetFileName$ = cwd$ + "/" + dir_fils$(d_chosen)  ' filename deeper
              endif     ' Note: cwd$ returns all uppercase
              exit do
            endif
          endif
        endif
    end select
    if d_changed then   ' something changed so redisplay directory list
      ListDir(d_top_item, d_lines, d_sel_item)
    endif
  loop
  '--------------------

  ' restore original screen image
  box d_x, d_y, d_width, d_height, 1, 0, 0 ' must clear to black first
  blit write 64, d_x, d_y   ' now restore all non-black pixels
  blit close 64

  ' restore starting directory
  chdir d_startdir$

end function

'*****************************************************************
' Read directories and specified files in the current directory
sub ReadDir(spec$,d_top_item,d_sel_item,d_top_last)
  local item_cnt, i

  for i = 1 to DIRCOUNT
    dir_dirs$(i) = ""   ' clear the array
  next i
  for i = 1 to FILCOUNT
    dir_fils$(i) = ""   ' clear the array
  next i

  ' read directories first
  dir_dirs$(0) = ""  ' 0 items to begin
  item_cnt = 1
  dir_dirs$(item_cnt) = left$(Dir$("*", DIR),NAMELENGTH) ' WARNING - possible truncation
  Do While dir_dirs$(item_cnt) <> "" and item_cnt < DIRCOUNT - 1
    If dir_dirs$(item_cnt) <> "." Then item_cnt = item_cnt + 1 ' ignore "."
    dir_dirs$(item_cnt) = Dir$()
  Loop
  if dir_dirs$(item_cnt) = "" then item_cnt = item_cnt - 1

  ' Sort directories
  Sort dir_dirs$()    ' note:  "" < "A"
  ' shift non-blank entries to front of array
  for i = 1 to item_cnt
    dir_dirs$(i) = dir_dirs$(DIRCOUNT-item_cnt+i)
  next i
  dir_dirs$(0) = str$(item_cnt)   ' store number of items

  ' now read files
  dir_fils$(0) = ""  ' 0 items to begin
  item_cnt = 1
  if ucase$(spec$) = "<DIR>" then
    dir_fils$(item_cnt) = left$(Dir$("*", FILE),NAMELENGTH) ' WARNING - possible truncation
  else
    dir_fils$(item_cnt) = left$(Dir$(spec$, FILE),NAMELENGTH) ' WARNING - possible truncation
  endif
  Do While dir_fils$(item_cnt) <> "" and item_cnt < FILCOUNT - 1
    If dir_fils$(item_cnt) <> "." Then item_cnt = item_cnt + 1 ' ignore "."
    dir_fils$(item_cnt) = Dir$()
  Loop
  if dir_fils$(item_cnt) = "" then item_cnt = item_cnt - 1

  ' Sort files and shift non-blank entries to front of array
  Sort dir_fils$()
  for i = 1 to item_cnt
    dir_fils$(i) = dir_fils$(FILCOUNT-item_cnt+i)
  next i
  dir_fils$(0) = str$(item_cnt)   ' store number of items

  d_top_item = 1
  d_sel_item = 1
  d_top_last = val(dir_dirs$(0)) + val(dir_fils$(0)) - d_lines + 1

end sub

'*****************************************************************
' Display (part of) directory
' Show 'nlines' number of items, starting with item 'first',
' hilite given item
' The magic number "33" should be altered to correspond to the magic
' number "300" used above for d_width.
sub ListDir(first, nlines, hilite)



















