' ============================================================
' Raycaster Demo Game for PicoMite MMBasic (RP2350)
' Press ESC at any time to quit
' Thank you Peter!
' ============================================================
Option EXPLICIT
MODE 2
CLS

' ---- Map dimensions ----
Const MAP_W = 42
Const MAP_H = 30
Const FOV = 66

' ---- Start position ----
Const START_X = 2.5
Const START_Y = 2.5
Const START_A = 0

' ---- Variables ----
Dim INTEGER x%, y%, i%, cx%, cy%, door_x%, door_y%, door_wall%, sploc%
Dim INTEGER colx%, coly%
Dim k$
Dim FLOAT moveSpeed, rotSpeed

moveSpeed = 0.2
rotSpeed = 5.625   ' exactly 90 degrees per 16 steps


' ---- Read map data into 1D array ----
Dim INTEGER world%(MAP_W * MAP_H - 1)
Restore MapData1
For y% = 0 To MAP_H - 1
 Read k$
 k$ = k$ + "1"
 For x% = 0 To MAP_W - 1
   world%(y% * MAP_W + x%) = Val(Mid$(k$, x% + 1, 1))
 Next x%
Next y%

' ---- Set up framebuffer & raycaster ----
FRAMEBUFFER CREATE
FRAMEBUFFER WRITE F
Ray MAP MAP_W, MAP_H, world%()
'this sets floor-fg,ceil-fg,flr-bk,cel-bk,flr-patrn,cel-patrn colors/patterns
Ray COLOUR 2, 1, 0, 5, 1, 1
'this sets wall pattern,forground col,backrnd col,fill pattrn
Ray Define 1, 8, 15, 28 ' #1 red brick wall
Ray Define 2, 1, 12, 22 ' #2 blue
Ray Define 3, 4, 14, 19 ' #3 Midgreen
Ray Define 4, 12, 10, 21 ' #4 brown
Ray Define 5, 13, 15, 28 ' #5 Lilac
Ray Define 6, 10, 12, 22 ' #6 Rust
Ray Define 7, 2, 14, 19 ' #7 Myrtle
Ray Define 8, 3, 12, 21 ' #8 Cobalt
Ray Define 9, 14, 15, 28 ' #9 Yellow

' ---- Load 4bpp RGB121 sprite images via SPRITE LOADARRAY ----
Const C_BLK = &h000000  ' index 0 - transparent
Const C_RED = &hFF0000  ' index 8
Const C_GRN = &h00FF00  ' index 6
Const C_BLU = &h0000FF  ' index 1
Const C_YEL = &hFFFF00  ' index 14
Const C_CYN = &h00FFFF  ' index 7
Const C_MAG = &hFF00FF  ' index 9
Const C_WHT = &hFFFFFF  ' index 15

Sprite SET TRANSPARENT 0  ' index 0 (black) is transparent
Dim INTEGER spr%(63)   ' reusable 8x8 pixel array


' Sprite 5: White ring on black background
For i% = 0 To 63: spr%(i%) = C_BLK: Next i%
For i% = 2 To 5: spr%(0 * 8 + i%) = C_WHT: spr%(7 * 8 + i%) = C_WHT: Next i%
For i% = 2 To 5: spr%(i% * 8 + 0) = C_WHT: spr%(i% * 8 + 7) = C_WHT: Next i%
spr%(1 * 8 + 1) = C_WHT: spr%(1 * 8 + 6) = C_WHT
spr%(6 * 8 + 1) = C_WHT: spr%(6 * 8 + 6) = C_WHT
Sprite LOADARRAY 1, 8, 8, spr%()
Sprite LOADARRAY 2, 8, 8, spr%()
Sprite LOADARRAY 3, 8, 8, spr%()
Sprite LOADARRAY 4, 8, 8, spr%()
For i% = 0 To 63: spr%(i%) = C_BLK: Next i%
For i% = 2 To 5: spr%(0 * 8 + i%) = C_RED: spr%(7 * 8 + i%) = C_RED: Next i%
For i% = 2 To 5: spr%(i% * 8 + 0) = C_RED: spr%(i% * 8 + 7) = C_RED: Next i%
spr%(1 * 8 + 1) = C_RED: spr%(1 * 8 + 6) = C_RED
spr%(6 * 8 + 1) = C_RED: spr%(6 * 8 + 6) = C_RED
Sprite LOADARRAY 5, 8, 8, spr%()

' ---- Place billboard sprites in the open area ----
' RAY SPRITE id, spritenum, x!, y!
Ray SPRITE 0, 1, 14, 20.5   '
Ray SPRITE 1, 2, 15, 20.5   '
Ray SPRITE 2, 3, 16, 20.5   '
Ray SPRITE 3, 4, 17, 20.5   '
Ray SPRITE 4, 5, 13, 20.5   'end game sprite red


' ============================================================
' MAIN LOOP - runs until ESC
' ============================================================
 ' ---- Reset camera to start position ----
 Ray CAMERA START_X, START_Y, START_A, FOV
 sploc% = 1
Do
 Ray Render
 Ray MINIMAP 5,5,40
 FRAMEBUFFER Copy F, N
     k$ = Inkey$
     If k$ = Chr$(27) Then GoTo Done
     If k$ = "w" Then Ray Move 0.1
     If k$ = "s" Then Ray MOve -0.1
     If k$ = "a" Then Ray Turn -5
     If k$ = "d" Then Ray Turn 5
 sploc% = sploc% + 0.5
   If sploc% > 35 Then sploc% = 1
  End If
Ray Sprite 0, 1, sploc%, 9
Ray Sprite 1, 2, sploc%, 14
Ray Sprite 2, 3, sploc%, 19
Ray Sprite 3, 4, sploc%, 27
Ray Sprite 4, 5, sploc%, 29
' check for sprite collisions
   colx% = Ray(CAMX)
   coly% = Ray(CAMY)
   If colx% = sploc% And coly% = 2 Then
     Ray CAMERA 2.5, 2.5, 66
   End If
   If colx% = sploc% And coly% = 14 Then
     Ray CAMERA 2.5, 2.5, 66
   End If
   If colx% = sploc% And coly% = 19 Then
     Ray CAMERA 2.5, 2.5, 66
   End If
   If colx% = sploc% And coly% = 27 Then
     Ray CAMERA 2.5, 2.5, 66
   End If
   If colx% = sploc% And coly% = 29 Then
   GoTo Win
  End If
'reset camera
' Brief pause before restarting the loop
 Pause 50
Loop

Done:
Ray CLOSE
FRAMEBUFFER CLOSE
CLS
Print "The End!"
End
Win:
Ray CLOSE
FRAMEBUFFER CLOSE
CLS
Print "You Won!!!!!"
End

MapData1:
Data "111111111111112222222222333333333333333333"
Data "111111111122220000000000333333144411144441"
Data "100011111200000023333300000031400411400004"
Data "101000111200220021113003333003400414004404"
Data "101000001200220021130031113331400440041404"
Data "100000111200222002130031111111400400041404"
Data "100011112000000002130031111111400004441404"
Data "101000112002222002130031111111400004444404"
Data "101000112002222002130033333333400400444404"
Data "101010112002220002333003333333400440044404"
Data "100001112002220002111300000333400414004404"
Data "100000000022222222233333300000000444444404"
Data "111555555556666666555777777755888888855404"
Data "555500000000000000000000000000000000000004"
Data "555505555555555555555555555555555555555555"
Data "111500000560066600000000000071800000888888"
Data "115000555160066600677007777711800800000008"
Data "150005511160066600617007777111800880088808"
Data "155005511160000000617000000711800880008808"
Data "111500055160000000617007777111800880008808"
Data "111155000560066600617007777111800880080808"
Data "115550000560066600617007777111800000808808"
Data "150000056660066600617000000711800088111808"
Data "115550000000666666611777770788808811111808"
Data "111116666666611111111111190000009199999808"
Data "119999999999999999999999999999999900000009"
Data "119000000000000000000000000000000000999999"
Data "119000000000000000000000000000000000999999"
Data "119000000000000000000000000000000000999999"
Data "119999999999999999999999999999999999999999"
