' ============================================================
' Raycaster DodgeBall Game for PicoMite MMBasic (RP2350)
' Press ESC at any time to quit
' Enemy speeds up over time
' ============================================================
Option EXPLICIT
MODE 2
CLS
Load image "dodgeball.bmp"
Pause 5000
Load image "Game Intro.bmp"
Pause 5000
CLS

' ---- Map dimensions ----
Const MAP_W = 12
Const MAP_H = 13
Const FOV = 66

' ---- Start position ----
Const START_X = 1.5
Const START_Y = 1.5
Const START_A = 0

' ---- Variables ----
Dim INTEGER x%, y%, i%, cx%, cy%, door_x%, door_y%, door_wall%, sploc%
Dim INTEGER colx%, coly%, temp, damage, score
Dim k$
Dim spx(6), spy(6), dx(6), dy(6), sht, swid, frame_count
Dim FLOAT moveSpeed, rotSpeed

moveSpeed = 0.2
rotSpeed = 5.625   ' exactly 90 degrees per 16 steps


' ---- Read map data into 1D array ----
Dim INTEGER world%(MAP_W * MAP_H - 1)
Restore MapData1
For y% = 0 To MAP_H - 1
 Read k$
 k$ = k$ + "1"
 For x% = 0 To MAP_W - 1
   world%(y% * MAP_W + x%) = Val(Mid$(k$, x% + 1, 1))
 Next x%
Next y%

' ---- Set up framebuffer & raycaster ----
FRAMEBUFFER CREATE
FRAMEBUFFER WRITE F
Ray MAP MAP_W, MAP_H, world%()
'this sets floor-fg,ceil-fg,flr-bk,cel-bk,flr-patrn,cel-patrn colors/patterns
Ray COLOUR 2, 1, 0, 5, 1, 1
'this sets wall pattern,forground col,backrnd col,fill pattrn
Ray Define 1, 8, 15, 28 ' #1 red brick wall
Ray Define 2, 1, 12, 22 ' #2 blue
Ray Define 3, 4, 14, 19 ' #3 Midgreen
Ray Define 4, 12, 10, 21 ' #4 brown
Ray Define 5, 13, 15, 28 ' #5 Lilac
Ray Define 6, 10, 12, 22 ' #6 Rust
Ray Define 7, 2, 14, 19 ' #7 Myrtle
Ray Define 8, 3, 12, 21 ' #8 Cobalt
Ray Define 9, 14, 15, 28 ' #9 Yellow

' ---- Load 4bpp RGB121 sprite images via SPRITE LOADARRAY ----
Const C_BLK = &h000000  ' index 0 - transparent
Const C_RED = &hFF0000  ' index 8
Const C_GRN = &h00FF00  ' index 6
Const C_BLU = &h0000FF  ' index 1
Const C_YEL = &hFFFF00  ' index 14
Const C_CYN = &h00FFFF  ' index 7
Const C_MAG = &hFF00FF  ' index 9
Const C_WHT = &hFFFFFF  ' index 15

Sprite SET TRANSPARENT 0  ' index 0 (black) is transparent
Dim INTEGER spr%(63)   ' reusable 8x8 pixel array


' Sprite 5: White ring on black background
For i% = 0 To 63: spr%(i%) = C_BLK: Next i%
spr%(2*8+2) = C_WHT:spr%(2*8+5)=C_WHT
spr%(3*8+3) = C_WHT:spr%(3*8+4)=C_WHT
spr%(4*8+3) = C_WHT:spr%(4*8+4)=C_WHT
spr%(5*8+2) = C_WHT:spr%(5*8+5)=C_WHT
Sprite LOADARRAY 1, 8, 8, spr%()
Sprite LOADARRAY 2, 8, 8, spr%()
Sprite LOADARRAY 3, 8, 8, spr%()
Sprite LOADARRAY 4, 8, 8, spr%()
For i% = 0 To 63: spr%(i%) = C_BLK: Next i%
spr%(2*8+2) = C_RED:spr%(2*8+5)=C_RED
spr%(3*8+3) = C_RED:spr%(3*8+4)=C_RED
spr%(4*8+3) = C_RED:spr%(4*8+4)=C_RED
spr%(5*8+2) = C_RED:spr%(5*8+5)=C_RED
Sprite LOADARRAY 5, 8, 8, spr%()
Sprite LOADARRAY 6, 8, 8, spr%()


' ---- Place sprites in the open area ----
' RAY SPRITE id, spritenum, x!, y!
For temp = 0 To 5
  spx(temp) = 10 - Int(Rnd*10)
  spy(temp) = 12 - Int(Rnd*12)
   dx(temp) = 0.5
   dy(temp) = 0.5
Next temp
Ray SPRITE 0, 1, 5, 5.5   '
Ray SPRITE 1, 2, 6, 5.5   '
Ray SPRITE 2, 3, 5, 6.5   '
Ray SPRITE 3, 4, 6, 6.5   '
Ray SPRITE 4, 5, 5, 7.5   'end game sprite red
Ray Sprite 5, 6, 6, 7.5
damage = 0
score = 0
' ============================================================
' MAIN LOOP - runs until ESC
' ============================================================
 ' ---- Reset camera to start position ----
 Ray CAMERA START_X, START_Y, START_A, FOV
 sploc% = 1
Do
 Ray Render
 Ray MINIMAP 5,5,40
 FRAMEBUFFER Copy F, N
     k$ = Inkey$
     If k$ = Chr$(27) Then GoTo Done
     If k$ = "w" Then Ray Move 0.1
     If k$ = "s" Then Ray MOve -0.1
     If k$ = "a" Then Ray Turn -5
     If k$ = "d" Then Ray Turn 5
  End If
frame_count=frame_count+1
   If frame_count=15 Then
      frame_count=0
   GoSub Smove
   End If
' check For sprite collisions
   colx% = Ray(CAMX)
   coly% = Ray(CAMY)
   If colx% = spx(0) And coly% = spy(0) Then
   Ray CAMERA 1.5, 1.5, 0
   damage = damage +1
   End If
   If colx% = spx(1) And coly% = spy(1) Then
     Ray CAMERA 1.5, 1.5, 0
   damage = damage +1
   End If
   If colx% = spx(2) And coly% = spy(2) Then
     Ray CAMERA 1.5, 1.5, 0
   damage = damage +1
   End If
   If colx% = spx(3) And coly% = spy(3) Then
     Ray CAMERA 1.5, 1.5, 0
   damage = damage +1
   End If
   If colx% = spx(4) And coly% = spy(4) Then
   Ray CAMERA 1.5, 1.5, 66
   score =score +1
   End If
   If colx% = spx(5) And coly% = spy(5) Then
   Ray CAMERA 1.5, 1.5, 66
   score = score +1
   End If
'reset camera
' Brief pause before restarting the loop
   If damage = 10 Then
   GoSub Done
   End If
   If score = 10 Then
   GoSub win
   End If
   Pause 20
Loop
Smove:
For temp=0 To 5
   If spx(temp)>10 Then
      dx(temp)=0-dx(temp)
   ElseIf spx(temp)<2 Then
      dx(temp)=0-dx(temp)
   End If
   If spy(temp)>12 Then
      dy(temp)=0-dy(temp)
   ElseIf spy(temp)<2 Then
      dy(temp)=0-dy(temp)
   End If
  spx(temp)=spx(temp)+dx(temp): spy(temp)=spy(temp)+dy(temp)
Ray sprite temp, temp+1, spx(temp), spy(temp)
Next temp
End Sub

Done:
Ray CLOSE
FRAMEBUFFER CLOSE
CLS
Print "The End!"
Print "Damage =",damage
Print "Score = ",score
End
Win:
Ray CLOSE
FRAMEBUFFER CLOSE
CLS
Print "You Won!!!!!"
Print "Score = ",score
Print "Damage =",damage
End

MapData1:
Data "111111111111"
Data "100000000001"
Data "100200002001"
Data "100000000001"
Data "100003300001"
Data "100000000001"
Data "104000000401"
Data "100000000001"
Data "100005500001"
Data "100000000001"
Data "106000000601"
Data "100000000001"
Data "111111111111"
