' graphique test for micromite, picromite, armmite
'v 0.1d 25/04/19  by goc
' for pic32mx, pi-cromite
'
'  --- Updates ----
' 25/04/19 v1.2a
'  add tmtyptest to make script  
'  add script minimum (type mx170) (test "M")
'  add pixel function
'  add gui bitmap
'  add test rounded rectangles and circles 1 pixel not filled and circle rnd pixel width not filled
 
'26/04/19 v1.2cv
'  add proc stm32F407 and f4 "generic" (with type4 script)
'  add "unknown proc" with script "test minimum"
'  update pixel function'

'27/04/19 v1.2d'
'  add database test
'  update: in minimum test "cls" function is not tested
'
'27/04/19 v1.2e'
'  add MM.info$
'  update save function 
'
'28/04/19  v1.2f
'  add test if no lcd panel friver installed
'  update test for MZ proc without lcd driver buffered (not sprit test) 
'  some minors bugs
'
'----------------------
'This program is a synthese of some others progs graphics; thanks are due to
'Geoff Graham,Peter Mather, TassyJim.

'prog tested on
' - Pic32Mx170  *
' - Pic32mx470  *
' - Pic32mz2048 *
' - Stm32H746   *
' - Stm32L476RG *

'prog not tested on
' - Pi Cromite

'screens
' - LCD 1.3" ST7789 240x240
' - LCD 2,8" ILI9341 SPI 240x320
' - LCD 5" ST9369 16b 800x480

Option explicit
Option default NONE

Const vvmaj=1
Const vvmin=2
Const vvsm=5
'(c) GOC-CMI7 23/04/2019
'-----------------------------------


Dim t%, x%, y%, r%, red%, green%, blue%, c%, b%
Dim x1%,y1%,la%
Dim x2%,y2%
Dim integer k
Dim integer maxx
Dim integer maxy
Dim vtim As float
Dim nbx%
Dim a As float
Dim nts As integer
Dim ttp As integer  'time to pause
Dim timtot As float  'total time test
Dim npass As integer
Dim drtri As integer  'drawing triangle
Dim flgblit As integer
Dim flgsprit As integer
Dim txt As string
dim vfonmsg as integer   'font use for messages in screen
dim vcoulfmsg as integer  'foreground color of messages
dim vcoulbmsg as integer   'backcolor of messages

const nbmxtst = 33  'nb max tests
const nbmaxdb=40  'nb max string in file database'
dim tmtitle(nbmxtst) as string  'title of test
dim tmtst(nbmxtst) as integer  'flag if run this test
dim tmtst1(nbmxtst) as integer  'save flags of tmtst
dim tmtst2(nbmxtst) as integer  'num of module for databae
'dim tmtxdb(nbmaxdb) as string   'database to save'
dim tmtxdb as string
dim nbtxdb as integer          'nb string to save'
dim txdrvlcd as string
dim flgtouch as integer
dim vnbus as integer   'type of lcd bus (1=SPI,2=I2c,3=16b,4=8b,5=other)
dim flgsavdb as integer

dim i as integer
dim j as integer
dim n as integer
dim n2 as integer
dim txt1$ as string
dim txt2$ as string
dim txt21$ as string
dim txt3$ as string
dim txversion$ as string

'---- vars for stars
dim etx%(9),etxd%(9)
dim ety%(9),etyd%(9)
dim integer eti,etc,etf, etxp, etyp
dim float ets

'---- vars for elipses/polygones
dim INTEGER elx(60), ely(60), elxd(60), elyd(60) , elxe(60), elye(60)
dim integer elc, elf, elxp, elyp,eli2,eli1
dim float ela, els, ele, sine, cosine

'---- vars for gauges
Dim integer gax1(1),gay1(1),gax2(1),gay2(1),gax3(1),gay3(1)
Dim integer gac(1)=(0,RGB(yellow)),gac2(1)=(0,RGB(yellow))
Dim integer gax1s,gay1s,gax2s,gay2s,gax3s,gay3s
dim integer gai,gai1,gai2
dim integer gaposx, gaposy, gasizx,gasizy


dim rep$ as string  'buffer input keyboard
dim nbrep as integer  'nb max wrongs answers
dim nbtest as integer  'number of tests
dim nbfon as integer   'number of font loaded
dim tmfon(16,2) as integer  'size each font
dim tmfon2(16) as integer   'num of each font loaded (if not all fonts used)
dim txtref as string      'dtring to print in texte tests
dim posx as integer
dim posy as integer
'-----------------------------------
const nbtypproc=17  'nb type of processors
const nbmaxinfo=6
dim tmdevice(nbtypproc) as string
dim nbdev as integer
dim numdevice as integer
dim ntdevice as string
dim tmtyptest(nbtypproc) as integer
dim numtyp as integer  'type of proc
dim tminfo(nbmaxinfo,2) as string   'texte infos (mm.info$)
dim tmvinfo(nbmaxinfo) as integer
dim nbinfo as integer
dim flginfo as integer

dim txfic1 as string
dim txfic2 as string

dim px%(99),py%(99),pc%(99), pxi%,pj%

nbtxdb=0          'nb string to save'

txtref="Hello Word"
txversion$=Str$(vvmaj)+"."+Str$(vvmin)+Chr$(vvsm+&h61)

'---- if no driver lcd finish prog
On error ignore
CLS
On error abort
If MM.Errno<>0 Then
  print "you must install LCD Panel driver to run tests, Bye...!"
  end
end if


Print Chr$(27)+"[2J"+Chr$(27)+"[0;0H";
On error ignore
k=0
For i=1 To 16
  tmfon(i,1)=0
  tmfon(i,2)=0
  Font i,1
  If MM.Errno=0 Then 
    k=k+1
    tmfon(i,1)=MM.fontheight
    tmfon(i,2)=MM.fontwidth
    tmfon2(k)=i  'if all fonts are not loaded
  end if
Next i
nbfon=k
print "nb fonts loaded : ";str$(nbfon)
print
ON error ABORT
print "Test Fonts"
posy=10
posx=10
for i=1 to nbfon
  posx=10
  j=tmfon2(i)
  if j>0 then
    txt1$="Font "+str$(j)
    TEXT posx,posy, txt1$, LM, 1, 1,rgb(white)
    posx=posx+(tmfon(1,2)*len(txt1$))+10
    'print posx,tmfon(1,2),len(txt1$)
    txt="01:23:45."+txtref
    TEXT posx,posy, txt, LM, j, 1,rgb(white)
    posy=posy+tmfon(j,1)+10
  'pause(100)
  end if
next i
pause(500)

Print "***************************"
Print "     TEST GRAPHIQUES     "
Print "     version:";txversion$
Print "***************************"
print


i=0
i=i+1:tmdevice(i)="Maximite":tmtyptest(i)=1  'nb min of functions tested
i=i+1:tmdevice(i)="Colour Maximite":tmtyptest(i)=1
i=i+1:tmdevice(i)="DuinoMite":tmtyptest(i)=1
i=i+1:tmdevice(i)="DOS":tmtyptest(i)=1
i=i+1:tmdevice(i)="Generic PIC32":tmtyptest(i)=1
i=i+1:tmdevice(i)="Micromite":tmtyptest(i)=1
i=i+1:tmdevice(i)="Micromite MkII":tmtyptest(i)=2
i=i+1:tmdevice(i)="Micromite Plus":tmtyptest(i)=3
i=i+1:tmdevice(i)="Micromite eXtreme":tmtyptest(i)=4
i=i+1:tmdevice(i)="ARMmite H7":tmtyptest(i)=5
i=i+1:tmdevice(i)="ARMmite F407":tmtyptest(i)=6
i=i+1:tmdevice(i)="ARMmite F4":tmtyptest(i)=6
i=i+1:tmdevice(i)="ARMmite L4":tmtyptest(i)=7
i=i+1:tmdevice(i)="Pi-cromite":tmtyptest(i)=0  'not tested

i=i+1:tmdevice(i)="Unknown Proc":tmtyptest(i)=2

nbdev=i

txt2$=MM.device$
txt3$=str$(MM.ver)
numdevice=-1
numtyp=0
for i=1 to nbdev
  j=len(tmdevice(i))
  if tmdevice(i)="Micromite" then  'because one of device is "Micromite"
    if txt2$=tmdevice(i) then numdevice=i:numtyp=tmtyptest(i):exit for
  else 
    if left$(txt2$,j)=left$(tmdevice(i),j) then numdevice=i:numtyp=tmtyptest(i):exit for
  end if
next i
if numdevice=-1 then
  print "device not found"
  numdevice=nbdev
	numtyp=tmtyptest(numdevice)
end if
 ntdevice=tmdevice(numdevice)
 Print "Device type=";ntdevice;" OK"
'---  add v1_2e----

On error ignore
  txt=MM.INFO$(AUTORUN)
On error ABORT

if MM.ERRNO<>0 then
  flginfo=0
  for i=1 to nbmaxinfo:tminfo(i,1)="":tminfo(i,2)="":next i   'raz tminfo 
  nbinfo=0
else
  flginfo=1
  i=0
  i=i+1:tminfo(i,1)="AutoRun":tminfo(i,2)=MM.INFO$(AUTORUN)
    if tminfo(i,2)="On" then tmvinfo(i)=1
  i=i+1:tminfo(i,1)="CPU Speed":tminfo(i,2)=MM.INFO$(CPUSPEED)
    tmvinfo(i)=val(tminfo(i,2))
  i=i+1:tminfo(i,1)="LcdPanel":tminfo(i,2)=MM.INFO$(LCDPANEL) 'SSD1963_5_BUFF, VGA
    if tminfo(i,2)<>"" then tmvinfo(i)=1
    if tminfo(i,2)="Disabled" then tmvinfo(i)=0
  i=i+1:tminfo(i,1)="SDCard":tminfo(i,2)=MM.INFO$(SDCARD)  'Ready or Disabled
    if tminfo(i,2)="Ready" then tmvinfo(i)=1
  i=i+1:tminfo(i,1)="Touch":tminfo(i,2)=MM.INFO$(TOUCH)   'Disabled Not calibrated or Ready
    if tminfo(i,2)="Not calibrated" then tmvinfo(i)=1
    if tminfo(i,2)="Ready" then tmvinfo(i)=2
  nbinfo=i
  
  for i=1 to nbinfo
    print tminfo(i,1);" = ";tminfo(i,2)
  next i
end if
if (tmvinfo(3)=0 and nbinfo>0) then
  print "You must install LCD Panel to run test, bye!"
end
end if
scriptt  'define script of test for proc installed

vfonmsg =1   'font use for messages in screen
vcoulfmsg = RGB(WHITE)  'foreground color of messages
vcoulbmsg = rgb(Black)   'backcolor of messages
maxy=MM.VRes-1
maxx=MM.HRes-1
t% = MM.HRes  \ 7
flgsavdb=0
txt=""

'----  SDCARD present -------
txfic1="Image4c.bmp"  'bmp file1 to load for sprites
txfic2="logom4.png"   ' png file2 to load

'--- test if files exist
flgsprit=0
if ntdevice="Micromite MkII" then 
  print "*** files function not used for sprite test ***"
  print
  txt="No Sprites"
else  
  ON error ignore  'this also raz errno
  txt1$=dir$("image4c.bmp",file)  'files "Image4c.*"
  ON error ABORT
  if mm.errno=0 then 
    flgsprit=1 
  end if
  ON error ignore
  txt1$=dir$("logom4.png",file)  'files "Image4c.*"
  ON error ABORT
  if mm.errno=0 then 
    flgsprit=flgsprit+1 
  end if  
  if flgsprit<2 then
    if (flgsprit<=0 and tmvinfo(4)=0) then print "*** SdCard for Sprite function is not present ***":txt="No files for Sprites"
    if flgsprit=1 then print "*** 1 File missing for Sprite function ***":txt="1 file need for Sprites"
    print "*** Function Sprite NOT aviable ***"
  else
    print "- Function SPRITE aviable "
    txt="Sprites OK"
  end if
  print
end if


if (tmvinfo(4)=1 or flgsprit=2) then   'if sdcard present
txt21$=""
etq3:
  input "Do you want to save results in file (Y or N) - default=N ",rep$
  if rep$="" then rep$="N"
  if rep$="y" then rep$="Y"
  if rep$="n" then rep$="N"
  if (rep$<>"Y" and rep$<>"N") then
    print "You must answer Y or N"
    goto etq3
  end if
  if rep$="N" then
    flgsavdb=0
    txdrvlcd=tminfo(3,2)    'lcdinfo
    flgtouch=tmvinfo(5)  'flag touch installed
    goto etq2
  end if 
'---- file to save -------
etq4b:    
      txt21$="Fgt"+right$(date$,2)+mid$(date$,4,2)+left$(date$,2)+left$(time$,2)+mid$(time$,4,2)+"_db.dat"
      txt1$="Name file to save data  (default:"+txt21$+")"
      print txt1$;
      input rep$
      if rep$="" then rep$=txt21$ else txt21$=rep$
      'on error ignore
      txt=""
      txt=dir$(rep$,FILE)
      'on error abort
      if MM.errno<>0 then
        print "*** error file name (error n:";str$(MM.ERRNo);")"
        goto etq4b
      end if
      if txt<>"" then
etq4e:        
        print "file ";txt;" exist do-you want to replace (Y or N)";
        input rep$
        if rep$="y" then rep$="Y"
        if rep$="n" then rep$="N"
        if (rep$<>"Y" and rep$<>"N") then
          print "You must answer Y or N"
          goto etq4e
        end if
        if rep$="N" then goto etq4b
        txt21$=txt
      end if
etq4f: 
      flgsavdb=1
      open txt21$ for output as #1
      'for i=1 to nbtxdb
      '  print #1,tmtxdb(i)
      '  'print tmtxdb(i)
      'next i
 etq4a:


'--------------------------  
end if

etq31:    
if nbinfo>0 then   'if function MM.info exist
  txdrvlcd=tminfo(3,2)    'lcdinfo
  flgtouch=tmvinfo(5)  'flag touch installed
  txt=tminfo(2,2)   'speed
  goto etq2
else  
  txt="0"  'speed unkown  
     
  txdrvlcd="No driver"    'name of driver lcd'
  flgtouch =0            'flag if touch active'
  vnbus=0   'num of lcd bus'
  if flgsavdb=0 then goto etq2
  input "What is your LCD driver (ex: ILI9341)",txdrvlcd
  if txdrvlcd="" then txdrvlcd="No driver":goto etq2
etq1:
  input "have-you Touch function active (Y or N)", rep$
  if rep$="y" then rep$="Y"
  if rep$="n" then rep$="N"
  if (rep$<>"Y" and rep$<>"N") then
    print "You must answer Y or N"
    goto etq1
  end if
  if rep$="Y" then flgtouch=1
etq1a:
  input "what type of bus (1=SPI,2=I2c,3=16b,4=8b,5=other)", rep$
  vnbus=val(rep$)
  if (vnbus<1 or vnbus>5) then
    print "you have to answer number from 1 to 5"
    goto etq1a
  end if
end if

etq2: 
 
nbtxdb=0
nbtxdb=nbtxdb+1:tmtxdb=str$(nbtxdb)+";01;"+"graftest"+";"+date$+";"+time$+";"+txversion$+";":spwritdb(tmtxdb) 'datbase string
nbtxdb=nbtxdb+1:tmtxdb=str$(nbtxdb)+";02;"+str$(numdevice)+";"+ntdevice+";"+txt2$+";"+txt3$+";":spwritdb(tmtxdb) 'datbase string
nbtxdb=nbtxdb+1:tmtxdb=str$(nbtxdb)+";03;"+txdrvlcd+";"+str$(vnbus)+";"+str$(maxx+1)+";"+str$(maxy+1)+";":spwritdb(tmtxdb) 'datbase string
nbtxdb=nbtxdb+1:tmtxdb=str$(nbtxdb)+";04;"+txt+";"+str$(nbfon)+";"+str$(flgtouch)+";"+str$(nbinfo)+";":spwritdb(tmtxdb) 'datbase string


npass=0
ttp=500  'time to pause between each test (time to see result text)


'----------------------------
print

for i=0 to 60 'store coordinates for a 60 point closed circle, radius 100
  elx(i)=sin(rad(i*6)) * 100
  ely(i)=COS(rad(i*6)) * 100
next i

for eti=0 to 9 step 2
  etx%(eti)=-(SIN(rad(eti*36))*200)
  ety%(eti)=-(COS(rad(eti*36))*200)
  etx%(eti+1)=-(SIN(rad((eti+1)*36))*76)
  ety%(eti+1)=-(COS(rad((eti+1)*36))*76)
next eti


MEMORY

i=0
nbrep=0
nbx%=100
sui1:
print "do you want to test all function minimal unctions or only some function :"
input "A(ll test)  M(inimum) or S(ome) default=A)",rep$
if rep$="" then rep$="A"
if rep$="a" then rep$="A"
if rep$="s" then rep$="S"
if rep$="m" then rep$="M"
if (rep$<>"A" and rep$<>"M" and rep$<>"S") then
  print "You must answer A or M or S"
  nbrep=nbrep+1
  if nbrep>3 then end
  goto sui1
end if 
if rep$="S" then 
  print "You have choice somes functions to test"
  print
  txt="some tests"
  goto sui5    
end if  
if rep$="M" then 
  print "You have choice minumum functions to test like for mx170"  'M= use to comparer from all procs
  print
  numtyp=2
  scriptt  'redefine script for mx170
  txt="Minimum tests"
  goto sui2
end if  
if rep$="A" then
   txt="All tests"
end if

print "You have choice All functions to tests"
print
sui2:

rep$="" 
nbrep=0
input "How many loop do you want in each function (default=100)",rep$
if rep$="" then rep$="100"   'goto sui3
if (val(rep$)<=0 or val(rep$)>5000) then
	print "You must answer number between 1 and 5000"
	nbrep=nbrep+1
	if nbrep>3 then end
	goto sui2
 end if
 nbx%=val(rep$)
 
 '+++++++++++++++++++++++++++++++++++++++++++++++++
sui3: 
 print "You have choice ";str$(nbx%);" loop(s) for each function to test"
 print


cls
Print "      --- CONFIGURATION --- "
print "device:";txt2$
print "Micromite ver:";txt3$
print "      ----------------------"
print

Option list
Print "      ----------------------"
Print "resolution:";Str$(maxx);"-";Str$(maxy)

'----def test
Print Chr$(27)+"[2J"+Chr$(27)+"[0;0H"
'print
'*** k is type of loop test: 0 you want only 1 pass with all printable results, 1= loop with all printable result, 2= loop with only total time for each pass
k=0  '0 if write result, 1 if loop test and result, 2 loop and no results
  'number or drawing objet for each test (loop for i..next i)
'------------
If k=0 Then Print " 1 pass and all results"
If k=1 Then Print "loop and all results"
If k=2 Then Print "Loop and total time result only"
'Print Str$(nbx%);" time drawing object"
Print
Print "**************************"
Print "*  Begin graphique test  *"
Print "**************************"
nbtxdb=nbtxdb+1:tmtxdb=str$(nbtxdb)+";05;"+txt+";"+str$(nbx%)+";"+str$(numtyp)+";"+str$(k)+";":spwritdb(tmtxdb) 'datbase string

'+++++++++++++++++++++++++++++++++++++++++++++++++
runtest:   
if k=0 then
  txt=""
  for i=1 to nbmxtst
    if tmtst(i)=0 then txt=txt+"0" else txt=txt+"1"
  next i
end if
nbtxdb=nbtxdb+1:tmtxdb=str$(nbtxdb)+";06;"+txt+";"+str$(nbx%)+";"+str$(nbmxtst)+";"+str$(k)+";":spwritdb(tmtxdb) 'datbase string

If k=>1 Then
Do
End If

n=0
n2=0
npass=npass+1
If k=1 Then Print "***************  Pass ";Str$(npass,3,0,"0");"  *******************"
timtot=0

'----- test 1 gui bitmap
n=n+1
If tmtst(n) <>0 Then  'if  proc this test
  if flgsprit=>10 then  'waiting for prog
    CLS RGB(black)
    writtitle(tmtitle(n))
    Timer=0


    vtim=Timer/1000: timtot=timtot+vtim
    writresult(vtim)
  end if
end if
'---- test 2 : draw 10x nbtest pixels in color 1pixel width
n=n+1
If tmtst(n) <>0 Then  'if  proc this test
  on error ignore
  pixel px%(),py%(),pc%() 
  on error abort
  if MM.errno<>0 then 
    
    tmtst(n)=0
    writtitle(tmtitle(n))
    vtim=-1
    writresult(vtim)
    vtim=0
    timer=0
  else  
	  CLS RGB(black)
	  writtitle(tmtitle(n))

	  Timer=0
	  For i%=1 To nbx%
		for j=0 to 99
		  px%(j)=rnd()*maxx  'i%
		  py%(j)= rnd()*maxy  'sin(rad(i%/800.0*720.0*pi))*50 +240
		  pc%(j)=Rnd()*&hffffff
		next j
		pixel px%(),py%(),pc%() 
	  Next i%
	  vtim=Timer/1000: timtot=timtot+vtim
	  writresult(vtim)
  end if
End If


'---- test 3 : draw x lines in white only and 1pixel width
n=n+1
If tmtst(n) <>0 Then  'if  proc this test
  CLS RGB(black)
  writtitle(tmtitle(n))

  Timer=0
  For i%=1 To nbx%
    x%=Rnd()*maxx
    y%=Rnd()*maxy
    x1%=Rnd()*maxx
    y1%=Rnd()*maxy
    c%=&hffffff
    Line x%,y%,x1%,y1%,1,c%
  Next i%
  vtim=Timer/1000: timtot=timtot+vtim
  writresult(vtim)
End If

'---- test 4 : draw x lines in random color and 1pixel width
n=n+1
If tmtst(n) <>0 Then  'if  proc this test
  CLS RGB(black)
  writtitle(tmtitle(n))
  
  Timer=0
  For i%=1 To nbx%
    x%=Rnd()*maxx
    y%=Rnd()*maxy
    x1%=Rnd()*maxx
    y1%=Rnd()*maxy
    c%=Rnd()*&hffffff
    Line x%,y%,x1%,y1%,1,c%
  Next i%
  vtim=Timer/1000: timtot=timtot+vtim
  writresult(vtim)
End If

'---- test 5 : draw x lines vertical or horizontal in random color and random pixels width
n=n+1
If tmtst(n) <>0 Then  'if  proc this test
  CLS RGB(black)
  writtitle(tmtitle(n))
  
  Timer=0
  For i%=1 To nbx%
    x%=Rnd()*maxx
    y%=Rnd()*maxy
    x1%=Rnd()*maxx
    y1%=Rnd()*maxy
    c%=Rnd()*&hffffff
    la%=(Rnd()*20)+1  'to ignore la=0
    If (i% Mod 2)=1 Then  'draw vertical or horizontal line each time
      x1%=x%
    Else
      y1%=y%
    End If
    Line x%,y%,x1%,y1%,la%,c%
  Next i%
  vtim=Timer/1000: timtot=timtot+vtim
  writresult(vtim)
End If

'---- test 6 : draw x rectangles in white color only and 1pixel width
n=n+1
If tmtst(n) <>0 Then  'if  proc this test
  CLS RGB(black)
  writtitle(tmtitle(n))
  
  Timer=0
  For i%=1 To nbx%
    x%=Rnd()*maxx
    y%=Rnd()*maxy
    x1%=Rnd()*maxx
    y1%=Rnd()*maxy
    c%=&hffffff
    la%=1  'rnd()*20
    Box x%,y%,x1%,y1%,la%,c%
  Next i%
  vtim=Timer/1000: timtot=timtot+vtim
  writresult(vtim)
End If

'---- test 7 : draw x rectangles in random bordure color and random background color  and 1pixel width
n=n+1
If tmtst(n) <>0 Then  'if  proc this test
  CLS RGB(black)
  writtitle(tmtitle(n))
  
  Timer=0
  For i%=1 To nbx%
    x%=Rnd()*maxx
    y%=Rnd()*maxy
    x1%=Rnd()*maxx
    y1%=Rnd()*maxy
    c%=Rnd()*&hffffff
    b%=Rnd()*&hffffff
    la%=1
    Box x%,y%,x1%,y1%,la%,c%,b%
  Next i%
  vtim=Timer/1000: timtot=timtot+vtim
  writresult(vtim)
End If

'---- test 8 : draw x rounded rectangles in random bordure color and random background color  and 1pixel width
n=n+1
If tmtst(n) <>0 Then  'if  proc this test
  CLS RGB(black)
  writtitle(tmtitle(n))
  
  Timer=0
  For i%=1 To nbx%
    x%=Rnd()*maxx
    y%=Rnd()*maxy
    x1%=Rnd()*maxx
    y1%=Rnd()*maxy
    c%=Rnd()*&hffffff
    b%=Rnd()*&hffffff
    la%=rnd()*25
      'size of corner
    rBox x%,y%,x1%,y1%,la%,c%,b%
  Next i%
  vtim=Timer/1000: timtot=timtot+vtim
  writresult(vtim)
End If


'---- test 9 : draw x rectangles in random bordure color and random background color  and random pixel width
n=n+1
If tmtst(n) <>0 Then  'if  proc this test
  CLS RGB(black)
  writtitle(tmtitle(n))
  
  Timer=0
  For i%=1 To nbx%
    x%=Rnd()*maxx
    y%=Rnd()*maxy
    x1%=Rnd()*maxx
    y1%=Rnd()*maxy
    c%=Rnd()*&hffffff
    b%=Rnd()*&hffffff
    la%=(Rnd()*10)+1  'to ignore la=0r
    Box x%,y%,x1%,y1%,la%,c%,b%
  Next i%
  vtim=Timer/1000: timtot=timtot+vtim
  writresult(vtim)
End If

'---- test 10 : draw x circle in 1pixel bordure color and not filled 1pixel width
n=n+1
If tmtst(n) <>0 Then  'if  proc this test
  CLS RGB(black)
  writtitle(tmtitle(n))
  
  Timer=0
  For i%=1 To nbx%
    x%= Rnd()*10000 Mod MM.HRes
    y%= Rnd()*10000 Mod MM.VRes
    r%= Rnd()*10000 Mod t% + t%\5
    c%= Rnd()*&hffffff  '(red%<<16) + (green%<<8) + blue%
    Circle x%,y%,r%,1,,c%,RGB(black)
  Next i%
  vtim=Timer/1000: timtot=timtot+vtim
  writresult(vtim)
End If

'---- test 11 : draw x circle in  random pixel bordure color and not filled
n=n+1
If tmtst(n) <>0 Then  'if  proc this test
  CLS RGB(black)
  writtitle(tmtitle(n))
  
  Timer=0
  For i%=1 To nbx%
    x%= Rnd()*10000 Mod MM.HRes
    y%= Rnd()*10000 Mod MM.VRes
    r%= Rnd()*10000 Mod t% + t%\5
    c%= Rnd()*&hffffff  '(red%<<16) + (green%<<8) + blue%
    la%=(Rnd()*20)+1  'to ignore la=0
    Circle x%,y%,r%,la%,,c%,RGB(black)
  Next i%
  vtim=Timer/1000: timtot=timtot+vtim
  writresult(vtim)
End If


'---- test 12 : draw x circle in black bordure color and random background color  and 1pixel width
n=n+1
If tmtst(n) <>0 Then  'if  proc this test
  CLS RGB(black)
  writtitle(tmtitle(n))
  
  Timer=0
  For i%=1 To nbx%
    x%= Rnd()*10000 Mod MM.HRes
    y%= Rnd()*10000 Mod MM.VRes
    r%= Rnd()*10000 Mod t% + t%\5
    c%= Rnd()*&hffffff  '(red%<<16) + (green%<<8) + blue%
    Circle x%,y%,r%,1,,RGB(black),c%
  Next i%
  vtim=Timer/1000: timtot=timtot+vtim
  writresult(vtim)
End If

'---- test 13 : draw x ellipses in random bordure color and random background color  and 1pixel width
n=n+1
If tmtst(n) <>0 Then  'if  proc this test
  CLS RGB(black)
  writtitle(tmtitle(n))
  
  Timer=0
  For i%=1 To nbx%
    x%= Rnd()*10000 Mod MM.HRes
    y%= Rnd()*10000 Mod MM.VRes
    r%= Rnd()*10000 Mod t% + t%\5
    la%=(Rnd()*20)+1  'to ignore la=0
    a=Int(Rnd()*5)
    If (i% Mod 2) = 1 Then  'draw vertical ellipse or horizontale ellipse
    a= a/10
    End If
    'red%= RND()*255
    'green%= RND()*255
    'blue%= rnd()*255
    c%= Rnd()*&hffffff  '(red%<<16) + (green%<<8) + blue%
    b%=Rnd()*&hffffff
    Circle x%,y%,r%,1,a,c%,b%
  Next i%
  vtim=Timer/1000: timtot=timtot+vtim
  writresult(vtim)
End If

'---- test 14 : color cls  (screen is RGB565 in 16-bit mode)
n=n+1
If tmtst(n) <>0 Then  'if  proc this test
  CLS RGB(black)
  Text MM.HRes\2, MM.VRes\2,"--- test clear screen ---",CM,vfonmsg,1,vcoulfmsg,vcoulbmsg
  pause(500)
  writtitle(tmtitle(n))
  Timer=0
  For i%=0 To 255   'nbx%
    CLS RGB(i%,i%,i%)
     'pause(10)
  Next i%
  
    For j%=8 To 255 Step 8
      CLS RGB(j%,0,0)
    Next j%
    For j%=8 To 255 Step 8
      CLS RGB(0,j%,0)
    Next j%
    For i%=8 To 255 Step 8   'nbx%
      CLS RGB(0,0,i%)
    Next i%
  vtim=Timer/1000: timtot=timtot+vtim
  writresult(vtim)
End If

'---- test 15 : draw x text "hello word" in random position white color and same font (font nB01) size=1
n=n+1
If tmtst(n) <>0 Then  'if  proc this test
  CLS RGB(black)
  writtitle(tmtitle(n))
  
  Timer=0
  For i%=1 To nbx%
    x%=Rnd()*maxx
    y%=Rnd()*maxy
    x1%=(Rnd()*6)+1
    y1%=(Rnd()*3)+1
    c%=&hffffff
   Text x%,y%,txtref,CM,1,1,c%
  Next i%
  vtim=Timer/1000: timtot=timtot+vtim
  writresult(vtim)
End If

'---- test 16 : draw x text "hello word" in random position white color and random font (font nB01) size=1
n=n+1
If tmtst(n) <>0 Then  'if  proc this test
  CLS RGB(black)
  writtitle(tmtitle(n))
  
  Timer=0
  For i%=1 To nbx%
    x%=Rnd()*maxx
    y%=Rnd()*maxy
    x2%=(Rnd()*nbfon)+1
    x1%=tmfon2(x2%)  'use font loaded
    y1%=(Rnd()*3)+1
    c%=&hffffff
    if x1%>0 then Text x%,y%,txtref,CM,x1%,1,c%
  Next i%
  vtim=Timer/1000: timtot=timtot+vtim
  writresult(vtim)
End If

'---- test 17 : draw x text "hello word" in random position random foreground and background color and random font (font nB01) size=1
n=n+1
If tmtst(n) <>0 Then  'if  proc this test
  CLS RGB(black)
  writtitle(tmtitle(n))
  
  Timer=0
  For i%=1 To nbx%
    x%=Rnd()*maxx
    y%=Rnd()*maxy
    x2%=(Rnd()*nbfon)+1
    x1%=tmfon2(x2%)  'use font loaded
    y1%=1 '(RND()*3)+1
    c%=Rnd()*&hffffff
    b%=Rnd()*&hffffff
    if x1%>0 then Text x%,y%,txtref,CM,x1%,y1%,c%,b%
  Next i%
  vtim=Timer/1000: timtot=timtot+vtim
  writresult(vtim)
End If

'---- test 18 : draw x text "hello word" in random position random foreground and background color and random font (font nB01) size=1
n=n+1
If tmtst(n) <>0 Then  'if  proc this test
  CLS RGB(black)
  writtitle(tmtitle(n))
  
  Timer=0
  For i%=1 To nbx%
    x%=Rnd()*maxx
    y%=Rnd()*maxy
    x2%=(Rnd()*nbfon)+1
    x1%=tmfon2(x2%)  'use font loaded
    y1%=(Rnd()*3)+1
    c%=Rnd()*&hffffff
    b%=Rnd()*&hffffff
    if x1%>0 then Text x%,y%,txtref,CM,x1%,y1%,c%,b%
  Next i%
  vtim=Timer/1000: timtot=timtot+vtim
  writresult(vtim)
End If

'---- test 19 : draw x text "hello word" in random position random foreground and background color and random font (font nB01) size=1 rotated text
n=n+1
If tmtst(n) <>0 Then  'if  proc this test
  CLS RGB(black)
  writtitle(tmtitle(n))
  
  Timer=0
  For i%=1 To nbx%
    x%=Rnd()*maxx
    y%=Rnd()*maxy
    x2%=(Rnd()*nbfon)+1
    x1%=tmfon2(x2%)  'use font loaded
    y1%=(Rnd()*3)+1
    x2%=(i% Mod 5)
    If x2%=0 Then txt="CMN"
    If x2%=1 Then txt="CMV"
    If x2%=2 Then txt="CMI"
    If x2%=3 Then txt="CMU"
    If x2%=4 Then txt="CMD"
    c%=Rnd()*&hffffff
    b%=Rnd()*&hffffff
    if x1%>0 then Text x%,y%,txtref,txt,x1%,y1%,c%,b%
  Next i%
  vtim=Timer/1000: timtot=timtot+vtim
  writresult(vtim)
End If

'---- test 20 : draw x text "hello word" in random position random foreground and background transparent and random font (font nB01) size=1
n=n+1
If tmtst(n) <>0 Then  'if  proc this test
  CLS RGB(black)
  writtitle(tmtitle(n))
  
  Timer=0
  For i%=1 To nbx%
    x%=Rnd()*maxx
    y%=Rnd()*maxy
    x2%=(Rnd()*nbfon)+1
    x1%=tmfon2(x2%)  'use font loaded
    y1%=(Rnd()*3)+1
    c%=Rnd()*&hffffff
    if x1%>0 then Text x%,y%,txtref,CM,x1%,y1%,c%,-1
  Next i%
  vtim=Timer/1000: timtot=timtot+vtim
  writresult(vtim)
End If

  '---- test 21 : test triangle no background
n=n+1
If tmtst(n) <>0 Then  'if  proc this test
	CLS RGB(black)
	writtitle(tmtitle(n))
  
    Timer=0
    For i%=1 To nbx%
      x%=Rnd()*maxx
      y%=Rnd()*maxy
      x1%=Rnd()*maxx
      y1%=Rnd()*maxy
      x2%=Rnd()*maxx
      y2%=Rnd()*maxy
      c%=Rnd()*&hffffff
      Triangle x%,y%,x1%,y1%,x2%,y2%,c%,-1
    Next i%
    vtim=Timer/1000: timtot=timtot+vtim
    writresult(vtim)
End If

  '---- test 22 : test triangle background color
n=n+1
If tmtst(n) <>0 Then  'if  proc this test
	CLS RGB(black)
	writtitle(tmtitle(n))
  
  Timer=0
  For i%=1 To nbx%
     x%=Rnd()*maxx
     y%=Rnd()*maxy
     x1%=Rnd()*maxx
     y1%=Rnd()*maxy
     x2%=Rnd()*maxx
     y2%=Rnd()*maxy
     c%=Rnd()*&hffffff
     b%=Rnd()*&hffffff
     Triangle x%,y%,x1%,y1%,x2%,y2%,c%,b%
  Next i%
  vtim=Timer/1000: timtot=timtot+vtim
  writresult(vtim)
End If

 '---- test 23 : test sprite command
n=n+1
If tmtst(n) <>0 Then  'if  proc this test
  on error ignore
  SPRITE load 1,txfic2 
  on error abort
  if MM.errno<>0 then   'if sprite not wot (no buffered ot no rd signal)
    tmtst(n)=0
    writtitle(tmtitle(n))
    vtim=-1
    writresult(vtim)
    vtim=0
    timer=0
  else  

    if flgsprit=2 then  'if file1 and file2 exist then run this test
      CLS RGB(black)
      Text MM.HRes\2, MM.VRes\2,"Wait loading files .... ",CM,vfonmsg,1,vcoulfmsg,vcoulbmsg
      writtitle(tmtitle(n))
      
      Timer=0      
      Load image txfic1  
      SPRITE load 1,txfic2 
      SPRITE load 2,txfic2 
      Dim float fx1,fy1,fx2, fy2, fi
      Dim crash As integer
      Box 8,98,304,304,2
      Box 328,98,304,304,2
      SPRITE show 1,200,200,1
      SPRITE show 2,450,200,1
      For fi=0 To Pi*2-Pi/50 Step Pi/50
        fx1=Sin(fi)*100+160-sprite(w,2)\2
        fy1=Cos(fi)*100+250-sprite(h,2)\2
        fx2=Sin(fi)*100+480-sprite(w,2)\2
        fy2=-Cos(fi)*100+250-sprite(h,2)\2
        SPRITE next 1,fx1,fy1
        SPRITE next 2,fx2,fy2
        SPRITE scrollr 10,100,300,300,1,1
        SPRITE scrollr 330,100,300,300,-1,-1
      Next fi
      vtim=Timer/1000: timtot=timtot+vtim
      writresult(vtim)
    end if
  end if  
End If

'---- test 24 : draw x stars in random color and 1pixel width
n=n+1
If tmtst(n) <>0 Then  'if  proc this test
  CLS RGB(black)
  writtitle(tmtitle(n))
  
  Timer=0
  For i%=1 To nbx%
    etc=rnd()*255 + ((rnd()* 255)<<8) + ((rnd()* 255)<<16)
    etf=rnd()*255 + ((rnd()* 255)<<8) + ((rnd()* 255)<<16)
    etxp=rnd()*mm.hres
    etyp=rnd()*mm.vres
    ets=rnd()
    for eti=0 to 9
      etxd%(eti)=etx%(eti)*ets+etxp
      etyd%(eti)=ety%(eti)*ets+etyp
      'print etxd%(eti),etyd%(eti)
    next eti
    polygon etxd%(), etyd%(), etc, etf
  Next i%
  vtim=Timer/1000: timtot=timtot+vtim
  writresult(vtim)
End If

'---- test 25 : draw x elipses
n=n+1
If tmtst(n) <>0 Then  'if  proc this test
  CLS RGB(black)
  writtitle(tmtitle(n))
  
  Timer=0
  For i%=1 To nbx%
    elc=rnd()*255 + ((rnd()* 255)<<8) + ((rnd()* 255)<<16) ' random colour for border
    elf=rnd()*255 + ((rnd()* 255)<<8) + ((rnd()* 255)<<16) ' random colour for fill
    elxp=rnd()*mm.hres 'random x position of centre
    elyp=rnd()*mm.vres 'random y position of centre
    els=rnd() 'random size
    ela=rnd()* 360 'random angle
    sine=sin(rad(ela)): cosine=cos(rad(ela))  
    ele=rnd()* 8/3  + (1/3) ' random aspect ratio between one third and three
    for eti=0 to 60 ' first convert the aspect ratio and resize the coordinates
      elxd(eti)=elx(eti) * els *ele
      elyd(eti)=ely(eti) *els
    next eti
    for eti=0 to 60 ' now rotate the coordinates by an angle between 0 and 360 degrees
      elxe(eti)=elxd(eti)*cosine - elyd(eti) * sine + elxp  
      elye(eti)=elyd(eti)*cosine + elxd(eti) * sine + elyp  
    next eti
    polygon elxe(), elye(), elc, elf 'plot a filled ellipse
  Next i%
  vtim=Timer/1000: timtot=timtot+vtim
  writresult(vtim)
End If

'---- test 26 : draw x arcs color and 1pixel width
n=n+1
If tmtst(n) <>0 Then  'if  proc this test
  CLS RGB(black)
  writtitle(tmtitle(n))
  
  Timer=0
  For i%=1 To nbx%
    x%=Rnd()*maxx
    y%=Rnd()*maxy
    x1%=Rnd()*maxx
    y1%=Rnd()*maxy
    c%=Rnd()*&hffffff
    els=rnd()*360 'random size
    ela=rnd()* 360 'random angle
    Arc x%,y%,x1%,,els,ela,c%
  Next i%
  vtim=Timer/1000: timtot=timtot+vtim
  writresult(vtim)
End If
'---- test 27 : draw x arcs color and rnd pixel width
n=n+1
If tmtst(n) <>0 Then  'if  proc this test
  CLS RGB(black)
  writtitle(tmtitle(n))
  
  Timer=0
  For i%=1 To nbx%
    x%=Rnd()*maxx
    y%=Rnd()*maxy
    x1%=Rnd()*maxx
    y1%=x1%+(Rnd()*30)
    if y1%=x1% then y1%=x1%+1
    c%=Rnd()*&hffffff
    els=rnd()*360 'random size
    ela=rnd()* 360 'random angle
    Arc x%,y%,x1%,y1%,els,ela,c%
  Next i%
  vtim=Timer/1000: timtot=timtot+vtim
  writresult(vtim)
End If

'---- test 28 : draw x bezier lines color and 1 pixel width
n=n+1
If tmtst(n) <>0 Then  'if  proc this test
  CLS RGB(black)
  writtitle(tmtitle(n))
  
  Timer=0
  For i%=1 To nbx%
    x%=Rnd()*maxx
    y%=Rnd()*maxy
    x1%=Rnd()*maxx
    y1%=Rnd()*maxy
    x2%=Rnd()*maxx
    y2%=Rnd()*maxy
    elxp=rnd()*maxx 'random x position of centre
    elyp=rnd()*maxy 'random y position of centre
    c%=Rnd()*&hffffff
    bezier x%,y%,x1%,y1%,x2%,y2%,elxp,elyp,c%
  Next i%
  vtim=Timer/1000: timtot=timtot+vtim
  writresult(vtim)
End If

'---- test 29 : gauges
n=n+1
If tmtst(n) <>0 Then  'if  proc this test
  CLS RGB(black)
  writtitle(tmtitle(n))
  gai2=(300/nbx%)*2
  gaposx=0:gaposy=0
  if (MM.hres<240 or mm.vres<240) then
    gasizx=MM.HRES:gasizy=MM.VRES
    if gasizy>gasizx then gasizy=gasizx else gasizx=gasizy
  else
    gasizx=240:gasizy=240
  end if
  
  Timer=0
  gax1(1)=(gasizx\2)-6+gaposx  :gax1(0)=gax1(1) :gax1s=gax1(0)
  gay1(1)=(gasizy\2)+gaposy    :gay1(0)=gay1(1) :gay1s=gay1(0)
  gax2(1)=(gasizx\2)+6+gaposx  :gax2(0)=gax2(1) :gax2s=gax2(0)
  gay2(1)=(gasizy\2)+gaposy     :gay2(0)=gay2(1) :gay2s=gay2(0)
  gax3(1)=(gasizx\2)+gaposx    :gax3(0)=gax3(1) :gax3s=gax3(0)
  gay3(1)=(gasizy\2)+gaposy-((gasizx\2)-45) :gay3(0)=gay3(1) :gay3s=gay3(0)
  Arc (gasizx\2)+gaposx,(gasizy\2)+gaposy,(gasizx\2)-21,(gasizx\2)-19,210,150  '99,101
  Arc (gasizx\2)+gaposx,(gasizy\2)+gaposy,(gasizx\2)-36,(gasizx\2)-34,210,150  '84,86
  Arc (gasizx\2)+gaposx,(gasizy\2)+gaposy,(gasizx\2)-34,(gasizx\2)-21,210,90,RGB(green) '86,99
  Arc (gasizx\2)+gaposx,(gasizy\2)+gaposy,(gasizx\2)-34,(gasizx\2)-21,90,150,RGB(red)  '86,99
  'Pause 100
  rotatetriangle  -150,(gasizx\2)+gaposx, (gasizy\2)+gaposy

  For gai=-150 To 150 step gai2
    gai1=(gai+150)/3  'value in % (0-100%)
    If(gai>90)Then
      gac2(1)=RGB(red)
      gac(1)=RGB(yellow)
    Else
      gac2(1)=RGB(yellow)
      gac(1)=RGB(red)
    EndIf
    rotatetriangle  gai,(gasizx\2)+gaposx, (gasizy\2)+gaposy
    Triangle gax1(),gay1(),gax2(),gay2(),gax3(),gay3(),gac(),gac2()
    text (gasizx\2)+gaposx,(gasizy)+gaposy," "+str$(gai1)+" ",CB,1,2,gac2(1)
  Next gai
  
  For gai=150 To -150 step -gai2
    gai1=(gai+150)/3  'value in % (0-100%)
    If(gai>90)Then
      gac2(1)=RGB(red)
      gac(1)=RGB(yellow)
    Else
      gac2(1)=RGB(yellow)
      gac(1)=RGB(red)
    EndIf
    rotatetriangle  gai,(gasizx\2)+gaposx, (gasizy\2)+gaposy
    Triangle gax1(),gay1(),gax2(),gay2(),gax3(),gay3(),gac(),gac2()
    text (gasizx\2)+gaposx,(gasizy)+gaposy," "+str$(gai1)+" ",CB,1,2,gac2(1)
  Next gai
  
  vtim=Timer/1000: timtot=timtot+vtim
  writresult(vtim)
End If



if k<2 then
  Text MM.HRes\2, MM.VRes\2,"*** END of TESTS ***",CM,vfonmsg,2,vcoulfmsg,vcoulbmsg
  Text MM.HRes\2, (MM.VRes\2)+30,"Total time test: "+Str$(timtot,2,3,"0")+" Sec",CM,vfonmsg,1,rgb(CYAN),vcoulbmsg
  
  Print "-------------------------------------------------------------------"
  Print "Total time test :                                 "+Str$(timtot,2,3,"0")+" Seconds"
  Print
  if nbtxdb<nbmaxdb then nbtxdb=nbtxdb+1:tmtxdb=str$(nbtxdb)+";08;"+str$(n2)+";end of test;Total time test;"+str$(timtot)+";":spwritdb(tmtxdb) 'datbase string

end if
If k=>1 Then
  Loop
End If

rep$="" 
nbrep=0
j=-1
sui4:
input "do you want to start a test again (Y or N) ",rep$
if rep$="" then goto sui4
if rep$="y" then rep$="Y"
if rep$="n" then rep$="N"

if (rep$<>"Y" and rep$<>"N") then
  print "You must answer Y or N"
  nbrep=nbrep+1
  if nbrep>3 then end
  goto sui4
end if

if rep$="N" then
  print "GoodBye"
  if (txt21$<>"" and flgsavdb=1) then   'if
    close #1
    print
    print "Save datas in file ";txt21$;"  ";str$(nbtxdb);" lines"
    print
  end if
  'memory
  clear
  end
end if
    
sui5:
for i=1 to nbmxtst
 tmtst(i)=0  'raz ref tests
next i
sui7:
rep$="" 
nbrep=0
sui6:
txt="num of test you want to play (from 1 to "+str$(nbtest)+") or 0 to run test"
print txt
txt="or -1 to run in loop mode"
print txt

input rep$
if rep$="" then goto sui6
if val(rep$)=-1 then
  k=2  'run loop test
  goto sui9
end if
k=0  'run 1 time each function
if val(rep$)=0 then goto sui9
 if (val(rep$)<1 or val(rep$)> nbtest) then
	print "You must answer number between 1 and ";str$(nbtest)
	nbrep=nbrep+1
	if nbrep>3 then end
	goto sui6
 end if
j=val(rep$)
 tmtst(j)=1
 goto sui7
sui9:
'if j=-1 then end  'if no test then end

rep$="" 
nbrep=0
sui21:
txt="How many loop do you want in each test (default="+str$(nbx%)+")"
print txt
input rep$

if rep$="" then rep$=str$(nbx%)   'goto sui3
if (val(rep$)<=0 or val(rep$)>5000) then
	print "You must answer number between 1 and 5000"
	nbrep=nbrep+1
	if nbrep>3 then end
	goto sui21
 end if
 nbx%=val(rep$) 
goto runtest


sub writtitle(tx as string)
local tx1$
  if k<2 then
    tx1$="Test "+str$(n)+" "+tx+"                                              "
    tx1$=left$(tx1$,50)
    Print tx1$;
    if nbtxdb<nbmaxdb then
    end if
  end if
end sub

sub writresult(t1 as float)
    If k<2 Then
      if t1<=0 then
        Text MM.HRes\2, MM.VRes\2,"** Test not executed **",CM,vfonmsg,1,vcoulfmsg,vcoulbmsg
        Print "** Not used **"
      else
        Text MM.HRes\2, MM.VRes\2,"text test in "+Str$(t1)+" Seconds",CM,vfonmsg,1,vcoulfmsg,vcoulbmsg
        Print Str$(t1,2,3,"0")+" Seconds"
      end if
      n2=n2+1
      if nbtxdb<nbmaxdb then nbtxdb=nbtxdb+1:tmtxdb=str$(nbtxdb)+";07;"+str$(n2)+";"+str$(tmtst2(n))+";"+tmtitle(n)+";"+str$(t1)+";":spwritdb(tmtxdb) 'datbase string
      Pause(ttp)
    End If
    CLS

end sub

sub scriptt()
for i=1 to nbmxtst
 tmtst(i)=0  'raz ref tests
next i
i=0
if numtyp=0 then goto fint  'for secur
i=i+1:tmtitle(i)="Test GUI BITMAP (1x) in":tmtst(i)=0  'prog sleep (in progress) 
i=i+1:tmtitle(i)="pixel test colored in":tmtst(i)=1
  if numtyp<=2 then tmtst(i)=0  'pixel function not used
i=i+1:tmtitle(i)="Line test B/W (1pixel) in":tmtst(i)=1
i=i+1:tmtitle(i)="Line test Color (1pixel) in":tmtst(i)=1
i=i+1:tmtitle(i)="H/V Line test (rnd pixel) in":tmtst(i)=1
i=i+1:tmtitle(i)="Rectangle test 1pixel b/w not filled in":tmtst(i)=1
i=i+1:tmtitle(i)="Rectangle test 1pixel colored in":tmtst(i)=1
i=i+1:tmtitle(i)="Rectangle test rounded 1pixel in":tmtst(i)=1
i=i+1:tmtitle(i)="Rectangle test rnd width, color in":tmtst(i)=1
i=i+1:tmtitle(i)="Circle test 1pixel not filled in":tmtst(i)=1
i=i+1:tmtitle(i)="circle test rnd width not filled in":tmtst(i)=1
i=i+1:tmtitle(i)="Circle test colored not filled 1pixel in":tmtst(i)=1
i=i+1:tmtitle(i)="elipse test filled 1pixel in":tmtst(i)=1
  if numtyp=1 then tmtst(i)=0
i=i+1:tmtitle(i)="Cls color test in":tmtst(i)=1
if numtyp<=2 then tmtst(i)=0
i=i+1:tmtitle(i)="text test simple b/w size=1 font=1 in":tmtst(i)=1
i=i+1:tmtitle(i)="text test xfonts b/w size=1 all fonts in":tmtst(i)=1
i=i+1:tmtitle(i)="text test color size=1 in":tmtst(i)=1
  if numtyp=1 then tmtst(i)=0
i=i+1:tmtitle(i)="text test colored rnd*size in":tmtst(i)=1
  if numtyp<=2 then goto fint  'if mx170 not all tests
i=i+1:tmtitle(i)="text rotate test in":tmtst(i)=1
i=i+1:tmtitle(i)="text transparent test in":tmtst(i)=1
i=i+1:tmtitle(i)="Triangles no bg test in":tmtst(i)=1
i=i+1:tmtitle(i)="Triangles color bg test in":tmtst(i)=1
  if numtyp=3 then goto fint  'if mx470 not all tests
i=i+1:tmtitle(i)="SPRITE function test in":tmtst(i)=1
   if numtyp=6 then tmtst(i)=0  'if F4 no sprties function
i=i+1:tmtitle(i)="Stars function test in":tmtst(i)=1
i=i+1:tmtitle(i)="elipses rnd function test in":tmtst(i)=1
i=i+1:tmtitle(i)="Arcs function (1 pixel) test in":tmtst(i)=1
i=i+1:tmtitle(i)="Arcs function (x pixels) test in":tmtst(i)=1
i=i+1:tmtitle(i)="Beziers function test in":tmtst(i)=1
  if (numtyp=7 or numtyp=4) then tmtst(i)=0  'if mz no bezier function
i=i+1:tmtitle(i)="Gauges function test in":tmtst(i)=1

fint:
nbtest=i
for i=1 to nbtest
 tmtst1(i)=tmtst(i)    'save ref tests
next i
j=0
for i=1 to nbmxtst
 if tmtst(i)<>0  then
    j=j+1
    tmtst2(j)=i  'for database
end if
next i

end sub

sub spwritdb(tx as string)
if flgsavdb=1 then
  print #1,tx
'else
  'print tx   'for info and copy/paste from console
end if
end sub

Sub rotatetriangle(angle As float, x As integer, y As integer)
   Local float sine=Sin(Rad(angle)),cosine=Cos(Rad(angle))
   Local integer x1a=gax1s-x, y1a=gay1s-y
   Local integer x2a=gax2s-x, y2a=gay2s-y
   Local integer x3a=gax3s-x, y3a=gay3s-y
   gax1(0)=gax1(1):gax2(0)=gax2(1):gax3(0)=gax3(1)
   gay1(0)=gay1(1):gay2(0)=gay2(1):gay3(0)=gay3(1)
   gax1(1)= x1a*cosine - y1a * sine + x
   gay1(1)= y1a*cosine + x1a * sine + y
   gax2(1)= x2a*cosine - y2a * sine + x
   gay2(1)= y2a*cosine + x2a * sine + y
   gax3(1)= x3a*cosine - y3a * sine + x
   gay3(1)= y3a*cosine + x3a * sine + y
End Sub
End