' 3D Very Simple Raycaster - 2024/02
' by homa [Matthias] for my son hoko
' use the PicoMiteVGA MMBasic Version 5.08.00
'
' [w] [a] [s] [d] to move / [m] toggle map & 3d
'
' My first raycaster based on the youtube tutorial by 3dsage.
' https://youtu.be/gYRrGTC7GtA
' The speed of the PicoMiteVGA leaves a lot to be desired :-)
' But it's all in BASIC, so there's a lot to optimise.
' I am open for suggestions, ideas and tricks.
'
Option explicit
MODE 2
'
' FRAMEBUFFER -- color 0-15:
' Black, Blue, Myrtle, Cobalt, Midgreen, Cerulean, green, cyan, red,
' magenta, rust, fuschia, brown, lilac, yellow And white
'
FRAMEBUFFER CREATE
FRAMEBUFFER write f
CLS RGB(cyan)
'
'Pi is here with Pi=3.141592654
'
Const mapX=8
Const mapY=8
Const mapS=64
Const mS = mapS/2                'this screen only 320x240 !!
'
Dim showmap=0
Dim integer map(63)
Read map()                       'see DATA 0 floor / 1 wall
'
Dim integer px, py
Dim float pdx, pdy, pa
'
init
Do While 1=1
  FRAMEBUFFER write F
  If showmap=1 Then drawMap2d
  drawPlayer
  drawRays2d
  FRAMEBUFFER copy f,n,b
  keyboard
Loop
'
Pause 3000
MODE 1
End
'
' init
Sub init
  px=150 : py=400 : pa=FixAng(90)
  pdx=Cos(Rad(pa)) : pdy=-Sin(Rad(pa))
End Sub
'
Function FixAng(a As integer)
   If a>359 Then Inc a,-360
   If a<=0   Then Inc a, 360  'fixed by me due div0 see below
   FixAng = a
End Function
'
Sub drawPlayer
  Local integer pxd=px/2
  Local integer pyd=py/2
  Box pxd-2,pyd-2,5,5,0,RGB(yellow),RGB(cyan)
End Sub
'
Sub keyboard
  Local key$ = Inkey$
  Local integer xo, yo    ', mxp, myp, mxn, myn
  If key$="m" Then
    If showmap=1 Then showmap=0 Else showmap=1
    CLS RGB(cyan)
  EndIf
  If key$="a" Then 'Inc px,-1
    Inc pa, 5 : pa=FixAng(pa)
    pdx=Cos(Rad(pa)) : pdy=-Sin(Rad(pa))
  EndIf
  If key$="d" Then 'Inc px, 1
    Inc pa,-5 : pa=FixAng(pa)
    pdx=Cos(Rad(pa)) : pdy=-Sin(Rad(pa))
  EndIf
  ' collision check
  xo=0 : If pdx<0 Then xo=-10 Else xo=10
  yo=0 : If pdy<0 Then yo=-10 Else yo=10
  'p ositiv  AND  n egativ
  If key$="w" Then 'Inc py,-1  'move forward,  check with positive offset
    If map((py>>6)*mapX+((px+xo)>>6))=0 Then Inc px, pdx*5
    If map(((py+yo)>>6)*mapX+(px>>6))=0 Then Inc py, pdy*5
  EndIf
  If key$="s" Then 'Inc py, 1  'move backward, check with negative offset
    If map((py>>6)*mapX+((px-xo)>>6))=0 Then Inc px,-(pdx*5)
    If map(((py-yo)>>6)*mapX+(px>>6))=0 Then Inc py,-(pdy*5)
  EndIf
End Sub
'
Sub drawMap2d
  Local integer x, y, xo, yo
  For y=0 To mapY-1
    For x=0 To mapX-1
      xo=x*mS : yo=y*mS
      If map(y*mapX+x)=1 Then
        Box xo+1, yo+1, mS-1, mS-1, 0, RGB(cyan), RGB(white)
      Else
        Box xo+1, yo+1, mS-1, mS-1, 0, RGB(black), RGB(black)
      EndIf
    Next x
  Next y
End Sub
'
Sub drawRays2d
  Local integer r, mx, my, mp, dof, side
  Local float vx, vy, rx, ry, ra, xo, yo, disV, disH
  Local float mTan          '? for my Tan
  Local integer myc
  Local integer pxd, pyd, rxd, ryd
  'for 3d
  Local integer ca, lineH, lineOff
  If showmap=0 Then CLS RGB(cyan) 'if 3d on
  '
  ra = Fix(pa+32)
  r=0
  For r=0 To 64 Step 1
    '---Vertical---
    dof=0 : side=0 : disV=100000
    mTan=Tan(Rad(ra))
    If Cos(Rad(ra)) > 0.001 Then 'looking right
      rx = (((px)>>6)<<6)+64
      ry = (px-rx)*mTan+py
      xo=64
      yo=-xo*mTan
    ElseIf Cos(Rad(ra)) < -0.001 Then 'looking left
      rx = (((px)>>6)<<6)-1
      ry = (px-rx)*mTan+py
      xo=-64
      yo=-xo*mTan
    Else
      rx=px : ry=py : dof=8
    EndIf
    '
    Do While dof<8
      mx=rx>>6 : my=ry>>6 : mp=my*mapX+mx
      If (mp>=0) And (mp < (mapX*mapY)) Then
        If map(mp)=1 Then
          dof=8
          disV=Cos(Rad(ra))*(rx-px)-Sin(Rad(ra))*(ry-py) 'hit
          Exit
        Else
           Inc rx,xo : Inc ry,yo : Inc dof,1
        EndIf
      Else
        Inc rx,xo : Inc ry,yo : Inc dof,1
      EndIf
    Loop
    vx=rx : vy=ry
    '
    '--Horizontal---
    dof=0 : disH=100000
    mTan=1/Tan(Rad(ra))
    If Sin(Rad(ra)) > 0.001 Then 'looking up
      ry = (((py)>>6)<<6) -1 '-0.001
      rx = (py-ry)*mTan+px
      yo=-64
      xo=-yo*mTan
    ElseIf Sin(Rad(ra)) < -0.001 Then 'lookung down
      ry = (((py)>>6)<<6)+64
      rx = (py-ry)*mTan+px
      yo= 64
      xo=-yo*mTan
    Else
      rx=px : ry=py : dof=8
    EndIf
    '
    Do While dof<8
      mx=rx>>6 : my=ry>>6 : mp=my*mapX+mx
      If (mp>=1) And (mp < (mapX*mapY)) Then
        If map(mp)=1 Then
          dof=8
          disH=Cos(Rad(ra))*(rx-px)-Sin(Rad(ra))*(ry-py) 'hit
          Exit
        Else
          Inc rx,xo : Inc ry,yo : Inc dof,1
        EndIf
      Else
        Inc rx,xo : Inc ry,yo : Inc dof,1
      EndIf
    Loop
    'horizontal hit first
    If disV<disH Then
      rx=vx : ry=vy : disH=disV : myc=RGB(cerulean)
    Else
      myc=RGB(blue)
    EndIf
    '
    '2D map with view field
    If showmap=1 Then
      pxd=px/2
      pyd=py/2
      rxd=rx/2
      ryd=ry/2
      Line pxd,pyd,rxd,ryd,1,RGB(cyan)
    Else
    '3D
      ca=FixAng(pa-ra)
      disH=disH*Cos(Rad(ca))
      lineH = mapS*240/disH
      If (lineH>240) Then lineH=240
      lineOff = 120 - (lineH>>1)
      Line r*5+0, lineOff , r*5+0, lineOff+lineH, 5, myc
    EndIf
    '
    ra=FixAng(ra-1)
  Next r
End Sub
'a simple 8 x 8 room
Data 1,1,1,1,1,1,1,1
Data 1,0,0,0,0,0,0,1
Data 1,0,1,1,1,1,0,1
Data 1,0,1,0,0,0,0,1
Data 1,0,0,0,0,0,0,1
Data 1,0,0,0,0,1,0,1
Data 1,0,0,0,0,0,0,1
Data 1,1,1,1,1,1,1,1
