'==========================================================
' (C)2023 JAVAVIUA  PMMP Ver1.2 - PicoMite MusicPlayer
'==========================================================
DRV$ ="B:"
PATH$="/"
Const PLIST_SIZE=100 'Play List Size

'PLAYpin=22:SetPin PLAYpin,DIN,PULLUP 'Pin for [PLAY]
'STOPpin=21:SetPin STOPpin,DIN,PULLUP 'Pin for [STOP]
'PREVpin=20:SetPin PREVpin,DIN,PULLUP 'Pin for [PREV]
'NEXTpin=19:SetPin NEXTpin,DIN,PULLUP 'Pin for [NEXT]

'==========================================================
Option base 1
Dim PList$(PLIST_SIZE) length 32  'Play List FileName Size
Dim Pmode$(4)=("*.MOD","*.WAV","*.FLAC","*.MP3") length 6
'==========================================================
PrintPROGRAM_NAME
plFN=1
CTRLstat=6:CTRLtout=100:CTRLbtout=100:CTRLvol=100:CTRLmode=1
'----------------------------------------------------------
CONTROL_LOOP:
If CTRLtout>0 Then
   CTRLtout=CTRLtout-1  'Wait timeout
Else
  Select Case CTRLstat  'State Control
  Case 0  'EMPTY LOOP
    'Wait for key control
  Case 1  'PLAY One
    PLAYER plFN
    CTRLstat=2
  Case 2
    If MM.Info(SOUND)="OFF" Or MM.Info(SOUND)="PAUSED" Then
      CTRLstat=0
    EndIf
  Case 3  'PLAY All
    PLAYER plFN
    CTRLstat=4
  Case 4  'PLAY CONTINUE
    If MM.Info(SOUND)="OFF" Or MM.Info(SOUND)="PAUSED" Then
      If plFN<>plQT Then plFN=plFN+1 Else plFN=1
      PLAYER plFN
    EndIf
  Case 5  'STOP
    Play STOP
    Print "STOP"
    CTRLstat=0
  Case 6  'Play List SEARCH
    PlayLIST_SEARCH Pmode$(CTRLmode)
    CTRLstat=5
  End Select
EndIf
'----------------------------------------------------------
key=Asc(Inkey$)

''Button Key Player Control
'If CTRLbtout>0 Then
'   CTRLbtout=CTRLbtout-1  'Wait key debonce timeout
'Else
'   CTRLbtout=100
'   If Pin(PLAYpin)=0 Then key=128  'PLAY
'   If Pin(STOPpin)=0 Then key=129  'STOP
'   If Pin(PREVpin)=0 Then key=130  'PREV
'   If Pin(NEXTpin)=0 Then key=131  'NEXT
'EndIf

If key=0 Then GoTo CONTROL_LOOP
'==========================================================
'Print key;
If MM.Info(SOUND)="OFF" Then Play TONE 1000,2000,50
'----------------------------------------------------------
Select Case key
Case 13,128,151 '[PLAY]
  CTRLstat=1
Case 32,129,149 '[STOP]
  CTRLstat=5
Case 130,150    '[<<]
  If plFN<>1 Then plFN=plFN-1 Else plFN=plQT
  CTRLtout=5000:CTRLstat=3
  PrintFN
Case 131,152    '[>>]
  If plFN<plQT Then plFN=plFN+1 Else plFN=1
  CTRLtout=5000:CTRLstat=3
  PrintFN
Case 145        '[F1]-Help
  PrintHELP
Case 146        '[F2]-VolumeDN
  If CTRLvol>0 Then CTRLvol=CTRLvol-1
  Play VOLUME CTRLvol,CTRLvol
Case 147        '[F3]-VolumeUP
  If CTRLvol<100 Then CTRLvol=CTRLvol+1
  Play VOLUME CTRLvol,CTRLvol
Case 148        '[F4]-VolumeMUTE
  If CTRLvol=0 Then CTRLvol=100 Else CTRLvol=0
  If CTRLvol=0 Then Print "MUTE" Else Print "LOUD"
  Play VOLUME CTRLvol,CTRLvol
Case 153        '[F9]-PlayMODE
  If CTRLmode<4 Then Inc CTRLmode Else CTRLmode=1
  Print Pmode$(CTRLmode)
  CTRLtout=2000:CTRLstat=6
Case 154        '[F10]-PlayList
  PrintPLAYLIST
Case 27         '[ESC]-Quit
  Play STOP
  Print "QUIT"
  End
Case Else       'Eny Key
  'Print key;
End Select
GoTo CONTROL_LOOP

'==========================================================
Sub PlayLIST_SEARCH(sStr$)
  Drive DRV$: Chdir PATH$
  plQT=0:plFM=0
  FNAME$=Dir$(sStr$,FILE)
  Do While FNAME$<>""
    If plQT=PLIST_SIZE Then Exit
    Inc plQT
    PList$(plQT)=FNAME$
    FNAME$=Dir$()
  Loop
  Print DRV$ PATH$ sStr$ plQT " files"
  If plQT>0 Then plFM=1 Else Print "No Files!"
End Sub
'----------------------------------------------------------
Sub PLAYER(plFNum)
  Play STOP
  If plQT=0 Then Print "No Files!":End Sub
  Select Case CTRLmode
    Case 1
      Play MODFILE PList$(plFNum) , ISR_PlayMOD_End
    Case 2
      Play WAV PList$(plFNum)
    Case 3
      Play FLAC PList$(plFNum)
    Case 4
      Print "MP3 not working yet!"
  End Select
  Print "PLAY >  " plFNum ". " DRV$ PATH$ PList$(plFNum)
End Sub
'----------------------------------------------------------
Sub ISR_PlayMOD_End
End Sub
'----------------------------------------------------------
Sub PrintPLAYLIST
  For n=1 To plQT
    Print n". ",Plist$(n)
  Next n
End Sub
'----------------------------------------------------------
Sub PrintFN
  Print plFN". ",Plist$(plFN)
End Sub
'----------------------------------------------------------
Sub PrintPROGRAM_NAME
  Colour RGB(black),RGB(cyan)
  Print " (C)2023 JAVAVI  PMMP Ver 1.2 - PicoMite MusicPlayer   [F1]-Help "
  Colour RGB(white),RGB(black)
  Print "================================================================="
End Sub
'----------------------------------------------------------
Sub PrintHELP
  'PrintPROGRAM_NAME
  Print "Volume: " CTRLvol, "SOUND: " MM.Info(SOUND)
  Print DRV$ PATH$ plQT " files " Pmode$(CTRLmode)
  Print "PLAYER CONTROL KEYS:"
  Print "PLAY     --  [Enter] [UP] [F7]"
  Print "STOP     --  [Space] [DN] [F5]"
  Print "NEXT     --  [RIGHT] [F8]"
  Print "PREV.    --  [LEFT]  [F6]"
  Print "Help     --  [F1]"
  Print "Volume   --  [F2] -- [F3] ++"
  Print "Mute     --  [F4]"
  Print "PlayMode --  [F9]"
  Print "PlayList --  [F10]"
  Print "Quit     --  [ESC]"
  Print "-----------------------------------"
End Sub
          