  '============================================================================|"
  ' PicoRocks in Space - Teaser
  '
  '
  ' needs:
  ' OPTION CPUSPEED 252000 (KHz)

  '============================================================================

  Option DEFAULT INTEGER
  Option LCDPANEL NOCONSOLE
  Option angle degrees
  MODE 1
  CLS 0
  Font 1

  'Iinit NES-Controller on port DB9 of Murmulator
  Const NES_PULSE!  = 0.012 ' 12uS
  Const NES_A_CLOCK = MM.Info(PinNo GP14)
  Const NES_A_LATCH = MM.Info(PinNo GP15)
  Const NES_A_DATA  = MM.Info(PinNo GP16)
  SetPin NES_A_CLOCK, DOut
  SetPin NES_A_LATCH, DOut
  SetPin NES_A_DATA,  DIn
  NES_Ctrl=0

  Function Reading_NES_Ctrl()
    Local bits, i
    Pulse NES_A_LATCH, NES_PULSE!
    For i = 0 To 7
      If Not Pin(NES_A_DATA) Then bits=bits Or 2^i
      Pulse NES_A_CLOCK, NES_PULSE!
    Next
    Reading_NES_Ctrl=bits
  End Function


  Const MAXROCKS = 50
  Dim float rock(MAXROCKS,7) ' 50 rocks: scale,angle,x,y,vx,vy,a,da
  Dim trock(MAXROCKS)   ' type of rock
  Math set 0, rock()    ' erase them all to start
  Math set 0,trock()
  Dim float v(1)        ' for math
  Dim bult(5,3)         ' 6 bullets
  Math set 0,bult()     ' no bullets flying around

  ' rock vector shapes
  ' Note: any resemblance to a country is purely coincidental
  Dim r1x(14)=( 5, 5, 1,-1, 4, 5, 5,-5,-5,-1, 1,-4,-5,-5, 5)  'Z
  Dim r1y(14)=( 5, 3, 0,-3,-3,-2,-5,-5,-3, 0, 3, 3, 2, 5, 5)
  Dim r2x(14)=( 0, 4, 5, 4, 0, 0,-3, 0, 3, 0, 0,-4,-5,-4, 0)  'O
  Dim r2y(14)=( 5, 4, 0,-4,-5,-4, 0, 4, 0,-4,-5,-4, 0, 4, 5)
  Dim r3x(14)=( 1, 3, 2, 5, 5, 2, 1,-1,-2,-5,-5,-2,-3,-1, 1)  'V
  Dim r3y(14)=(-2, 3, 5, 5, 3,-4,-5,-5,-4, 4, 5, 5, 3,-2,-2)
  Dim r4x(14)=( 1, 2, 5, 5, 2, 2, 5, 5, 3,-3,-5,-5,-3,-3, 1)  'T
  Dim r4y(14)=( 5, 3, 3, 2, 2, 0,-1,-3,-5,-5,-3, 0, 0, 5, 5)

'  Dim r1x(14)=( 0, 3, 4, 3, 5, 4, 1,-2,-4,-5,-3,-5,-3,-2, 0)
'  Dim r1y(14)=( 5, 4, 3, 1, 0,-4,-5,-4,-4,-1,-1, 2, 3, 5, 5)
'  Dim r2x(14)=( 0,-2,-3,-4,-5,-4,-4,-3,-1, 4, 4, 5, 4, 2, 0)
'  Dim r2y(14)=(-6,-4,-3,-4,-1, 2, 3, 3, 5, 3, 1, 0,-3,-4,-6)
'  Dim r3x(14)=( 1,-2,-2,-4,-4,-5,-5,-3,-2, 0, 4, 3, 5, 3, 1)
'  Dim r3y(14)=(-4,-5,-3,-4,-2, 0, 3, 4, 3, 5, 3, 2, 1,-5,-4)
'  Dim r4x(14)=( 0,-2,-4,-4,-5,-3,-1, 2, 1, 3, 5, 3, 4, 3, 0)
'  Dim r4y(14)=(-5,-4,-4,-1, 1, 4, 5, 5, 3, 4, 1,-2,-3,-4,-5)

  ' player ship and exhaust flame shapes @Volhout *2
  Dim shpx(4)=(0,-6,0,6,0)
  Dim shpy(4)=(-10,10,6,10,-10)
  Dim flmx(4)=(0,-2,0,2,0)
  Dim flmy(4)=(8,10,14,10,8)

  FRAMEBUFFER Create   ' hidden layer to draw scene
  FRAMEBUFFER Write F : CLS

  Dim float pv,px,py,pvx,pvy

  ph = 0 : pv = 0
  px = MM.HRes/2-6 : pvx = 0
  py = MM.VRes/2-6 : pvy = 0
  smash=0:newrun=0'1
  fire=0        '@Volhout copy from CMM2
  bspd=3        'bullet speed
  ships=5      'to start with
  timeout=3000  'respawn time out
  score=0       'start with 0

  'copied from CMM2 sound
  Play modfile "RISsound.mod"

  ' create 10 random rocks
  k = 1
  For i = 1 To 8 '10
    trock(i)  = 1 + (k And 3) ' rock type (0=doesn't exist)
    rock(i,0) = 2 + Int(Rnd*6)' rock size @Volhout *2
    Do  'initial place rocks 100 pix away from ship
      rock(i,2) = Rnd*MM.HRes   ' x location
      rock(i,3) = Rnd*MM.VRes   ' y location
    Loop While ((rock(i,2)-MM.HRes/2)^2 + (rock(i,3)-MM.VRes/2)^2)<100*100
    rock(i,4) = 1-Rnd*2   ' x velocity
    rock(i,5) = 1-Rnd*2   ' y velocity
    rock(i,6) = Rnd*360   ' starting angle
    rock(i,7) = 3-Rnd*6   ' rotation speed
    Inc k
  Next

  mot = Timer 'motor on timer

Do
tm=Timer

NES_Ctrl=Reading_NES_Ctrl()
If NES_Ctrl And 1 Then fire=1:DrawFire:Play modsample 3,1
If NES_Ctrl And 16 Then Inc pvx,Sin(ph)/2:Inc pvy,-Cos(ph)/2:Play modsample 9,2:mot=Timer+200
If NES_Ctrl And 64  Then Inc ph,-5:If ph<0 Then ph=355
If NES_Ctrl And 128 Then Inc ph,5:If ph>355 Then ph=0


    'extract last key from key buffer
    Do
      k=e:e=Asc(Inkey$)
    Loop Until e=0

    If k Then
      burn = 0
      Select Case k
        Case 128  ' up
          Inc pvx, Sin(ph)/2
          Inc pvy,-Cos(ph)/2
          Play modsample 9,2'@Martin
          mot = Timer + 200   ' keep flame visible for a while
        Case 130  ' left
          Inc ph,-5
          If ph < 0 Then ph = 355
        Case 131  ' right
          Inc ph,5
          If ph > 355 Then ph = 0
        Case 32 'space for fire '102 'f'for fire
          fire=1:DrawFire
          Play modsample 3,1'@Martin
          'print "fire"
        Case 27
          Print : End
      End Select
    EndIf

    Inc px,pvx-(MM.HRes+10)*(px > MM.HRes)+(MM.HRes+10)*(px<5)'@Martin

    Inc py,pvy-(MM.VRes+10)*(py > MM.VRes)+(MM.VRes+10)*(py<0)'@Martin

    ' velocity decays away slowly
    pvx = pvx * .99 '@Volhout .995
    pvy = pvy * .99 '@Volhout .995

    ' move rocks
    For i = 0 To MAXROCKS
      If trock(i) Then   ' rock exists

        'move rocks and keep in window
        Inc rock(i,2),rock(i,4)
        rock(i,2)=(rock(i,2)+MM.HRes) Mod MM.HRes 'original
        Inc rock(i,3),rock(i,5)
        rock(i,3)=(rock(i,3)+MM.VRes) Mod MM.VRes ' original

        'move bullets and check if something is hit
        For j = 0 To 5
          ' test for player bullet hitting asteroid
          If bult(j,0) Then ' does this bullet exist?

            'move it, when off-screen then skip bullet
            Inc bult(j,1),bspd*Sin(bult(j,3))
            If bult(j,1)>MM.HRes Or bult(j,1)<0 Then bult(j,0)=0
            Inc bult(j,2),-bspd*Cos(bult(j,3))
            If bult(j,2)>MM.VRes Or bult(j,2)<0 Then bult(j,0)=0

            'check for hit
            v(1) = bult(j,1) - rock(i,2) '- rock(i,0)   'coordinate compare
            v(0) = bult(j,2) - rock(i,3) '- rock(i,0)   'y coordinate compare
            If Math(magnitude v()) < 5*rock(i,0) Then
              bult(j,0) = 0   ' end of bullet
              AstHit(i,j)
              Continue For
            EndIf
          EndIf
        Next

        If (smash = 0) And (newrun = 0) Then
          ' test for asteroid hit player ship
          v(0) = px - rock(i,2) '@Volhout
          v(1) = py - rock(i,3) '@Volhout
          If Math(magnitude v()) < 10 + 5*rock(i,0) Then
            Print "hit" 'debug
            smash = 1
            ships=Max(0,ships-1)
            'sprd = 5    ' start the debris field
            Play modsample 6,4              ' player explosion
            thit=Timer                      ' for respawn delay
            'new start location = centre
            px = MM.HRes/2-6 : pvx = 0
            py = MM.VRes/2-6 : pvy = 0
            AstHit(i,0) 'damage to asteroid also
            Continue For
          EndIf
        EndIf
      EndIf
    Next i

    'check win
    If Math(sum trock())=0 Then Math set 0,bult()

    CLS
    DrawShip
    DrawRocks
    DrawBullet
    DrawFleet
    Text 0,1,Str$(score,6,0)
    Text 590,1,Str$(Timer-tm,3,0) '@Volhout game loop time in ms
    FRAMEBUFFER copy F,N,B

  Loop


Sub AstHit(n,m)
  Local i
  Print "astroid ";n;" hit" 'debug

  Inc score,10
  Play modsample 6,3'@Martin

  'handle bullet
  bult(m,0)=0 'bullet does not fly any further

  'handle rock
  If rock(n,0)<3 Then

    trock(n)=0  'remove from game play

  Else

    'split the asteroid in 2 equal pieces half the size
    For i = 0 To MAXROCKS    'find second free slot
      If trock(i)=0 Then Exit For
    Next

    'rock n modify, and rock i is the new ones
    trock(i)=trock(n)                                  'same type of asteroid
    rock(i,0)=Max(rock(n,0)-2,2):rock(n,0)=rock(i,0)   'both half size
    rock(i,2) = rock(n,2)   ' x location
    rock(i,3) = rock(n,3)   ' y location
    rock(i,4) = Cos(bult(m,3)):rock(n,4) = -Cos(bult(m,3)) ' x velocity
    rock(i,5) = Sin(bult(m,3)):rock(n,5) = -Sin(bult(m,3)) ' y velocity
    rock(i,6) = Rnd*360     ' starting angle random
    rock(i,7) = rock(n,7)   ' rotation speed

  End If
End Sub

Sub DrawBullet
  Local i
  For i=0 To 5
    If bult(i,0) Then Pixel bult(i,1),bult(i,2)
  Next
End Sub

Sub DrawShip
  Local x(4),y(4)
  If smash=1 Then
    If Timer-thit>timeout Then smash=0  'you can fly again
  Else
    'this is the ship
    Math scale shpx(),1,x()
    Math scale shpy(),1,y()
    Math v_rotate 0,0,ph,x(),y(),x(),y()
    Math add x(),px,x()  ' position ship
    Math add y(),py,y()
    Polygon 5,x(),y()
    'this is the exhaust flame
    If mot > Timer Then
      Math scale flmx(),1,x()
      Math scale flmy(),1,y()
      Math v_rotate 0,0,ph,x(),y(),x(),y()
      Math add x(),px,x()  ' position rocket flame
      Math add y(),py,y()
      Polygon 5,x(),y()
    EndIf
  End If
End Sub

Sub DrawFleet
  Local x(4),y(4),i,textx=30,texty=30,textw=16
  Math add shpx(),textx,x()
  Math add shpy(),texty,y()
  For i=1 To ships,x(),y()
    Polygon 5,x(),y()
    Math add x(),textw,x()
  Next
End Sub

  ' Go through the list of rocks and draw any that exist
Sub DrawRocks
  Local i
  Local x(14),y(14)

  For i = 0 To MAXROCKS
    If trock(i) Then   ' rock exists
      Inc rock(i,6),rock(i,7) ' spin rock
      If rock(i,6) > 360 Then Inc rock(i,6),-360
      If rock(i,6) < 0 Then Inc rock(i,6),360

      Select Case trock(i) ' what shape of rock is it?
        Case 1
          Math scale r1x(),rock(i,0),x()
          Math scale r1y(),rock(i,0),y()
        Case 2
          Math scale r2x(),rock(i,0),x()
          Math scale r2y(),rock(i,0),y()
        Case 3
          Math scale r3x(),rock(i,0),x()
          Math scale r3y(),rock(i,0),y()
        Case 4
          Math scale r4x(),rock(i,0),x()
          Math scale r4y(),rock(i,0),y()
      End Select
      Math v_rotate 0,0,rock(i,6),x(),y(),x(),y()
      Math add x(),rock(i,2),x()  ' position rock
      Math add y(),rock(i,3),y()
      Polygon 15,x(),y()
    EndIf
  Next i
End Sub

Sub DrawFire
  Local i
  If fire Then
    For i=0 To 5
      If bult(i,0)=0 Then
        bult(i,0)=1:bult(i,1)=px:bult(i,2)=py:bult(i,3)=ph
        fire=0:Exit For
      End If
    Next
  End If
End Sub
