'DiskInfo v026 by twofingers 2-2025
'based on Epsilons MAR 0.3 archiver for CMM2
'for MMBasic >= V6.00.02
Option explicit
Option default integer
Option BASE 0

Const TRUE     = 1,FALSE=TRUE=0
Const FW=MM.Info(FONTWIDTH), FH=MM.Info(FONTHEIGHT)
Const VERSION$ = "0.26"
Dim   PON      = TRUE 'Print to screen, FALSE = only summary
Dim   P2D      = FALSE'TRUE 'Print to disk
Dim OutFile$   = "B:\diskinfo.txt"
Dim QUIET      = FALSE'TRUE=Don't pause the screen output
If PON=FALSE Then QUIET = TRUE
Dim recLvl     = 0
Dim string dirToView$,shortCwd$
Dim integer FS_total=0, FN_total=0,DN_total=0,mxRec=0,key
Dim cmdLine$,DR$,oldDR$=MM.Info(drive),oldCWD$=Cwd$

CLS
cprint(0,,80,2)
cprint(1,"DiskInfo v"+VERSION$+" based on Epsilons MAR 0.3 archiver For CMM2",80,2)
cprint(2,,80,2)

Print
Print
cmdLine$ = MM.CMDLINE$
Print "Print to Disk is               ";@(Pos*FW,,2)Choice(P2D,"ON","OFF");
If P2D Then Print "  Dest. is: ";Chr$(34);OutFile$;Chr$(34) Else Print
Print "Print to Screen is             ";@(Pos*FW,,2)Choice(PON,"ON","OFF")
Print "Pause the screen output is     ";@(Pos*FW,,2)Choice(QUIET,"OFF","ON")
Print
If (cmdLine$ = "") Then
Print "(Hit '*' to exit or '?' to config)"
  Do
    Print "Directory to check ";Chr$(34);Cwd$;Chr$(34);": ";
    Input "",dirToView$
    If dirToView$="" Then dirToView$="."
    If dirToView$="*" Then End
    If dirToView$="?" Then
       setConfig
    Else
      If Mid$(dirToView$,2,1)<>":" Then dirToView$=Cwd$+dirToView$
      If MM.Info(EXISTS DIR dirToView$) Then
        Exit Do
      Else
        Print Chr$(34);dirToView$;Chr$(34);" not found! Another try ... (* = exit)"
        Print
      EndIf
    EndIf
  Loop
Else
  Print "Directory to check ";Chr$(34);cmdLine$;Chr$(34)
  Pause 1000
  If Right$(cmdLine$,2)=".." Then cmdLine$=Left$(cmdLine$,Len(cmdLine$)-2)+"."
  dirToView$ = cmdLine$
EndIf

DR$=Left$(UCase$(dirToView$),2)
If DR$="A:" Or DR$="B:" Then Drive DR$

If MM.Info(EXISTS DIR dirToView$) Then
  If P2D Then
    On error skip
    Open OutFile$ For output As #1
    If MM.Errno Then
       P2D=FALSE
       Print "Print-to-Disk error!"
       Pause 2000
    Else
      Print #1
      Print #1,"Directory to check ";Chr$(34);dirToView$;Chr$(34)
      Print #1
    EndIf
    EndIf
  EndIf
  processDir dirToView$
  pauseScreen(37)
  Print
  Print String$(80,Chr$(196))
  Print Chr$(34);MM.Info(drive);Chr$(34)" Free:";MM.Info(free space),
  Print "Used:";FS_total,"Files:";
  Print FN_total,"(Sub)Dirs:";DN_total, "MxRec:";mxRec
  If P2D Then
    Print #1
    Print #1,Chr$(34);MM.Info(drive);Chr$(34)" Free:";MM.Info(free space),
    Print #1,"Used:";FS_total,"Files:";
    Print #1,FN_total,"(Sub)Dirs:";DN_total,"MxRec:";mxRec
  EndIf
Else
  Print "Directory not found. Aborting..."
EndIf
On error skip
Close #1
Print
Drive oldDR$:Chdir oldCWD$
cprint(39,"Finished! Press any key to return to FM! Or CTRL+C to end.")
mywait

'End '"run"+Chr$(34)+"a:\fm.bas"+Chr$(34)
End "flash run 2"
'*************************************************
End

Sub setConfig '#c
Local k,vp=MM.Info(vpos)
Do
Print @(0,vp);
Print
Print "(1) Print to Disk is           ";@(Pos*FW,,2)Choice(P2D,"ON ","OFF");
If P2D Then
  Print "  Dest. is: ";Chr$(34);OutFile$;Chr$(34)
Else
 Print Space$(30)
EndIf

Print "(2) Print to Screen is         ";@(Pos*FW,,2)Choice(PON,"ON ","OFF");
If PON=FALSE Then Print "  Summary only" Else Print
Print "(3) Pause the screen output is ";@(Pos*FW,,2)Choice(QUIET,"OFF","ON ")
Print
k=getKey("Select 1,2 or 3 or [ENTER] to exit",MM.Info(vpos)/FH)
Select Case k
  Case Asc("1")
    P2D=Not P2D
  Case Asc("2")
    PON=Not PON
     If PON Then QUIET=FALSE
  Case Asc("3")
    QUIET=Not QUIET
  Case Else
End Select
If PON=FALSE Then QUIET= TRUE
Loop While k<>13
Print
Print
dirToView$=""
End Sub

Function getKey(msg$,ln) As integer
  If msg$="-" Then
    msg$="Press any key!"
  EndIf
  If ln=0 Then ln=39
  cprint(ln,msg$)
  Do :getKey=Asc(Inkey$):Loop While getKey=0
End Function


'This subroutine processes the contents of given file
Sub processFile(fileToProcess$)
  Local dots$
  pauseScreen(37)
  If PON Then Print Space$(recLvl*2);fileToProcess$;
  dots$=String$(60-Len(fileToProcess$)-recLvl*2,".")
  If PON Then Print " ";dots$;MM.Info(filesize fileToProcess$)
  If P2D Then
    Print #1,Space$(recLvl*2) "" fileToProcess$;
    Print #1," ";dots$;MM.Info(filesize fileToProcess$)
  EndIf
End Sub

'This subroutine processes the contents of given directory
Sub processDir(dirToProcess$)
  Local numSubDirs = 0,dpos
  Inc recLvl
  Chdir dirToProcess$
  pauseScreen(37)
  shortCwd$=Cwd$
  dpos=recLvl*2+Len(Cwd$)
  If dpos>60 Then
    shortCwd$=Left$(Cwd$,28-recLvl)+" "+Chr$(149)+Chr$(148)+" "+Right$(Cwd$,28-recLvl)
  EndIf
  If PON Then Print
  If PON Then Print Space$(recLvl*2) "DIR: >";shortCwd$;"<"
  If P2D Then
    Print #1
    Print #1,Space$(recLvl*2) "DIR: >";shortCwd$;"<"
  EndIf

'files
  Local fileToProcess$ = Dir$("*", FILE)
  If fileToProcess$ <>"" Then
     Inc FS_total,MM.Info(filesize fileToProcess$)
     Inc FN_total
  EndIf
  Do While fileToProcess$ <> ""
    processFile fileToProcess$
    fileToProcess$ = Dir$()
    If fileToProcess$ <>"" Then
        Inc FS_total,MM.Info(filesize fileToProcess$)
        Inc FN_total
    EndIf
    If MM.Errno <> 0 Then End
  Loop

'* dirs
  Local subDir$ = Dir$("*", DIR)
  If subDir$ <>"" Then Inc DN_total

  Do While subDir$ <> ""
    Inc numSubDirs
    subDir$ = Dir$()
    If subDir$ <>"" Then Inc DN_total
    If MM.Errno <> 0 Then End
  Loop

  If numSubDirs >= 1 Then
    Local subDirList$(numSubDirs)
    subDir$ = Dir$("*", DIR)
    Local listIdx = 0

    Do While subDir$ <> ""
      subDirList$(listIdx) = subDir$
      subDir$ = Dir$()
      If MM.Errno <> 0 Then End
      Inc listIdx
    Loop
    For listIdx=0 To numSubDirs-1
      processDir subDirList$(listIdx)
    Next listIdx
  EndIf

  Chdir ".."
  Inc recLvl, - 1
  If mxRec<recLvl Then mxRec=recLvl
End Sub

Sub mywait
  Do :Loop While Inkey$=""
End Sub

Sub CPrint(ln,msg$,cl,invers)
  Print @((Int(80-cl)/2)*FW,ln*FH,invers)Space$(cl);
  Print @((Int(80-Len(msg$))/2)*FW,ln*FH,invers)msg$;
End Sub

Sub pauseScreen(ln)
If MM.Info(vpos)>=ln*FH And Not QUIET Then
  If Not QUIET Then
    cprint(39,"Press any key!")
    mywait
    CLS
    Print @(0)
  EndIf
EndIf
End Sub                                                                                                                      