'File Manager V1.70 for PicoMiteVGA/HDMI by JAVAVI (c)2025
DATA_USER_COMMANDS:
Data ".."
Data "MEMORY      'List the amount of memory currently in use."
Data "OPTION LIST 'Display list the settings of option that have been changed."
Data "FLASH LIST  'Display a list of flash including the first line."
Data "LIST PINS   'List Pins with assigned functions."
Data "PRINT Time$, Date$, Day$(Date$)"
Data "PRINT \qRAM HEAP =\q;MM.Info(HEAP)/1024"
Data "SetPin GP25, DOUT"
Data "OPTION HEARTBEAT OFF"
Data "> '------------------------------------------------------------------"
Data "> FILES \q*\q,name  'List files in current directories, sort by name."
Data "> FILES \q*\q,size  'List files in current directories, sort by size."
Data "> FILES \q*\q,time  'List files in current directories, sort by time."
Data "> FILES \q*\q,type  'List files in current directories, sort by type."
Data "> LIST COMMANDS"
Data "> LIST FUNCTIONS"
Data "> LIST VARIABLES"
Data "> '------------------------------------------------------------------"
Data "> 'For start FM from flash memory enter this instructions"
Data "> FLASH ERASE ALL   'Erase all flash program location."
Data "> FLASH SAVE 2      'Save this program to the flash location 2"
Data "> OPTION F9 \qFLASH RUN 2\q+Chr$(13) 'Runs flash 2 when a F9 pressed."
Data ""
'================================================
Clear
Option ESCAPE
Option default integer
MODE 1:Font 1:TILE HEIGHT MM.Info(FONTHEIGHT)
'------------------------------------------------
'Global Configuration
Const DnFColor=0  'Dirs & Files Color (0=Colorer ON)
Const SelColor=14 'Color of selected files
Const SOMAX=8     'Max number of Sort Order options
Const RMAX=199    'Max number of Records in File List (255 max)
Const SStimeout=60000
'------------------------------------------------
Const FW=MM.Info(FONTWIDTH):FH=MM.Info(FONTHEIGHT)
Const CHRES=MM.HRES\FW:CVRES=MM.VRES\FH
Const PANW=CHRES\2:PANW1=PANW+1:PANH=CVRES-2
Const PFLW=PANW-2:PFLN=PANH-6
'------------------------------------------------
Dim integer mpIndx
Dim integer CKey,Tick1s,i,cx,cy
Dim integer PSide=1'Current Panel Side (Left=1,Right=0)
Dim integer LIndx,RIndx'Current File List Index
Dim integer c(15)=(0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15)
Dim integer FLS(8,1)=(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)
'File List Struct - FLS(Parameter,Side) Side=[1-Left/0-Right]
'RecQt,DirQt,FileQt,SelQt,cPos,cTop,SrtOrder,FColor,pView
'------------------------------------------------
Dim string  TMP$
Dim string  LDisk$="A:"    LENGTH 2
Dim string  RDisk$="A:"    LENGTH 2
Dim string  LDir$="/"      LENGTH 127
Dim string  RDir$="/"      LENGTH 127
Dim string  LFList$(RMAX)  LENGTH 63
Dim string  RFList$(RMAX)  LENGTH 63
'FList$ String 63Byte=[58 Chars + 1 ATR + 4 Size]
'================================================
BEGIN:
'Set defoult Config for Left(1) & Right(0) Panel
FLS(6,1)=1  : FLS(6,0)=1  'Sort Order (1: Name>)
FLS(7,1)=0  : FLS(7,0)=0  'D&F  Color (0: Colorer)
FLS(8,1)=1  : FLS(8,0)=1  'Panel View (1: +Size)
Colour Map  c(),c()       'Color Map
'------------------------------------------------
Timer =0
SetTick 1000,ISR_Tick1s,1
If MM.Info(SDCARD)="Ready" Then RDisk$="B:"
PanelsReStart()
'================================================
' MAIN CONTROL PANEL FUNCTIONS
'================================================
Do
GetCKey
Select Case CKey
Case 0'No Key Pressed
Case 9'TAP
  SetPControl("TAB")
Case 10,13'ENTER'
  EnterControl
Case 27'ESCAPE
  W_QUIT
  PanelsReStore
Case 32,132'SPACE'Ins
  SetPControl("SEL")
Case 42'PrtScr
  Save Image "PrtScr"
Case 65 To 90,97 To 122
  Color c(7),0:Print @(0,PANH*FH);
  EnterCommandLine(Chr$(CKey))
  PanelsReStore
Case 96'~
  SortSwitch
Case 128'Up
  SetPControl("UP")
Case 129'Dn
  SetPControl("DWN")
Case 130'Left
  SetPControl("PREV")
Case 131'Right
  SetPControl("NEXT")
Case 134'Home
  SetPControl("TOP")
Case 135'End
  SetPControl("BOT")
Case 136'PgUp
  SetPControl("PREV")
Case 137'PgDn
  SetPControl("NEXT")
Case 139,8'Alt
  SetAltPControl
Case 145'F1 Help
  W_F1_Help
  PanelsReStore
Case 146'F2 Menu
  W_F2_Menu
  PanelsReStart
Case 147'F3 View
  W_F3_View
Case 148'F4 Edit
  SetPControl("DIS")
  W_F4_Edit
Case 149'F5 Copy
  SetPControl("DIS")
  W_F5_Copy
  PanelsReStart
Case 150'F6 RenMov
  SetPControl("DIS")
  W_F6_RenMOVE
  PanelsReStart
Case 151'F7 MkDir
  SetPControl("DIS")
  W_F7_MkDIR
  PanelsReStart
Case 152'F8 Delete
  SetPControl("DIS")
  W_F8_DELETE
  PanelsReStart
Case 153'F9 Menu
  W_F9_USER_COMMANDS
  PanelsReStart
Case 154'F10 Exit
  CLS : End
Case 158,19'Pause
  Play Stop
Case 179'Shift+F3
  Changing_Panel_View
Case Else
  'Print @(0,PANH*FH,2)CKey;
End Select
'----------------------
If CKey=148 And TMP$<>"" Then
  Edit File TMP$
  PanelsReStart
EndIf
'----------------------
If CKey Then Timer =0
If Tick1s Then PrintTime
If Timer>SStimeout Then
  SSMatrix
  CLS :Timer =0
  PanelsReStore
EndIf
Loop
'------------------------------------------------
'ALT CONTROL PANEL FUNCTIONS
Sub  SetAltPControl
PrintFKeyMenu("DATA_FKeyAlt1")
Do :GetCKey: Loop Until CKey
Select Case CKey
Case 145'F1 L.Disk
  SetPControl("DIS")
  WDiskSelect(1):LDir$="/"
  LPanelShow():SetPControl("ENA")
Case 146'F2 R.Disk
  SetPControl("DIS")
  WDiskSelect(0):RDir$="/"
  RPanelShow():SetPControl("ENA")
Case 147'F3 View
'  W_AltF3_View2
  PanelsReStore
Case 149'F5 XSEND
  CLS
  End "?\qXMODEM -->\q: XMODEM SEND "+"\q"+GetCurrFileName$()+"\q"
Case 150'F6 XREVIVE
  CLS
  End "?\qXMODEM <--\q: XMODEM RECIVE "+"\q"+GetCurrFileName$()+"\q"
Case 151'F7 Find
  SetPControl("DIS")
  W_AltF7_Find
  PanelsReStore
End Select
PrintFKeyMenu("DATA_FKeyMain")
End Sub
'================================================
' SET PANELS CONTROL
'================================================
Sub SetPControl(CTRL$)
Local SIZE
If PSide Then
'---- Left Panel Control --------
Select Case CTRL$
Case "TAB"
  PSide=0
  SetPControl("DIS")
  SetPControl("ENA")
Case "SEL"
  SelectingFile(LFList$(),LIndx)
  PrintSelectedFilesNum(1)
  SetPControl("DWN")
Case "UP"
  PFNAPrint(1)
  If LIndx>0 Then
    Inc LIndx,-1
    If FLS(4,1)>0 Then
      Inc FLS(4,1),-1
    Else
      If FLS(5,1)>0 Then Inc FLS(5,1),-1
      PFLPrint(1)
    EndIf
  EndIf
  PFNAPrint(1,2,7)
Case "DWN"
  PFNAPrint(1)
  If LIndx<FLS(0,1) Then
    Inc LIndx
    If FLS(4,1)<PFLN Then
      Inc FLS(4,1)
    Else
      Inc FLS(5,1)
      PFLPrint(1)
    EndIf
  EndIf
  PFNAPrint(1,2,7)
Case "TOP"
  LIndx=0:FLS(5,1)=0:FLS(4,1)=0
  PFLPrint(1)
  PFNAPrint(1,2,7)
Case "BOT"
  LIndx=FLS(0,1)
  If FLS(0,1)>PFLN Then
    FLS(4,1)=PFLN:FLS(5,1)=FLS(0,1)-PFLN
  Else
    FLS(4,1)=FLS(0,1)-FLS(5,1)
  EndIf
  PFLPrint(1)
  PFNAPrint(1,2,7)
Case "PREV"
  If LIndx>=PFLN  And FLS(5,1)>=PFLN Then
    Inc FLS(5,1),-PFLN:Inc LIndx,-PFLN
  Else
    LIndx=0:FLS(5,1)=0:FLS(4,1)=0
  EndIf
  PFLPrint(1)
  PFNAPrint(1,2,7)
Case "NEXT"
  If (LIndx-FLS(4,1))+PFLN<FLS(0,1) Then
    Inc FLS(5,1),PFLN:Inc LIndx,PFLN
    If FLS(5,1)+FLS(4,1)>FLS(0,1) Then LIndx=FLS(0,1):FLS(4,1)=LIndx-FLS(5,1)
  Else
    LIndx=FLS(0,1):FLS(4,1)=FLS(0,1)-FLS(5,1)
  EndIf
  PFLPrint(1)
  PFNAPrint(1,2,7)
End Select
'---- Right Panel Control -------
Else
Select Case CTRL$
Case "TAB"
  PSide=1
  SetPControl("DIS")
  SetPControl("ENA")
Case "SEL"
  SelectingFile(RFList$(),RIndx)
  PrintSelectedFilesNum(0)
  SetPControl("DWN")
Case "UP"
  PFNAPrint(0)
  If RIndx>0 Then
    Inc RIndx,-1
    If FLS(4,0)>0 Then
      Inc FLS(4,0),-1
    Else
      If FLS(5,0)>0 Then Inc FLS(5,0),-1
      PFLPrint(0)
    EndIf
  EndIf
  PFNAPrint(0,2,7)
Case "DWN"
  PFNAPrint(0)
  If RIndx<FLS(0,0) Then
    Inc RIndx
    If FLS(4,0)<PFLN Then
      Inc FLS(4,0)
    Else
      Inc FLS(5,0)
      PFLPrint(0)
    EndIf
  EndIf
  PFNAPrint(0,2,7)
Case "TOP"
  RIndx=0:FLS(5,0)=0:FLS(4,0)=0
  PFLPrint(0)
  PFNAPrint(0,2,7)
Case "BOT"
  RIndx=FLS(0,0)
  If FLS(0,0)>PFLN Then
    FLS(4,0)=PFLN:FLS(5,0)=FLS(0,0)-PFLN
  Else
    FLS(4,0)=FLS(0,0)-FLS(5,0)
  EndIf
  PFLPrint(0)
  PFNAPrint(0,2,7)
Case "PREV"
  If RIndx>=PFLN And FLS(5,0)>=PFLN Then
    Inc FLS(5,0),-PFLN:Inc RIndx,-PFLN
  Else
    RIndx=0:FLS(5,0)=0:FLS(4,0)=0
  EndIf
  PFLPrint(0)
  PFNAPrint(0,2,7)
Case "NEXT"
  If (RIndx-FLS(4,0))+PFLN<FLS(0,0) Then
    Inc FLS(5,0),PFLN:Inc RIndx,PFLN
    If FLS(5,0)+FLS(4,0)>FLS(0,0) Then RIndx=FLS(0,0):FLS(4,0)=RIndx-FLS(5,0)
  Else
    RIndx=FLS(0,0):FLS(4,0)=FLS(0,0)-FLS(5,0)
  EndIf
  PFLPrint(0)
  PFNAPrint(0,2,7)
End Select
EndIf
'---- Common Actions --------
Select Case CTRL$
Case "DIS"
  PFNAPrint(1)
  PFNAPrint(0)
Case "ENA"
  If PSide Then
    Drive LDisk$
    Chdir LDir$
    PFNAPrint(1,2,7)
  Else
    Drive RDisk$
    Chdir RDir$
    PFNAPrint(0,2,7)
  EndIf
End Select
'Print Command Line ---------
PrintComLine(">")
'Print Panels Info ----------
If PSide Then
  WClear(1,PANH-3,PFLW,2)
  Print @(FW,(PANH-2)*FH);
  If LIndx Then
    TMP$=LFList$(LIndx)
    If Mid$(TMP$,1,1)="/" Then
      Print " <DIR>"
    Else
      Print "Size:";MM.Info(FILESIZE TMP$)
    EndIf
    Print @((PANW-21)*FW,(PANH-2)*FH);MM.Info(MODIFIED TMP$)
    If Len(TMP$)<PFLW+1 Then
      TMP$=Mid$(TMP$,1,PFLW)
      TMP$=TMP$+Space$(PFLW-Len(TMP$))
    Else
      TMP$=Mid$(TMP$,1,PFLW-1)+"~"
    EndIf
    Print @(FW,(PANH-3)*FH);TMP$;
  Else
    Print " <..>"
  EndIf
Else
  WClear(PANW1,PANH-3,PFLW,2)
  Print @(PANW1*FW,(PANH-2)*FH);
  If RIndx Then
    TMP$=RFList$(RIndx)
    If Mid$(TMP$,1,1)="/" Then
      Print " <DIR>"
    Else
      Print "Size:";MM.Info(FILESIZE TMP$)
    EndIf
    Print @((CHRES-21)*FW,(PANH-2)*FH);MM.Info(MODIFIED TMP$)
    If Len(TMP$)<PFLW+1 Then
      TMP$=Mid$(TMP$,1,PFLW)
      TMP$=TMP$+Space$(PFLW-Len(TMP$))
    Else
      TMP$=Mid$(TMP$,1,PFLW-1)+"~"
    EndIf
    Print @(PANW1*FW,(PANH-3)*FH);TMP$;
  Else
    Print " <..>"
  EndIf
EndIf
End Sub
'================================================
' ENTER KEY CONTROLS
'================================================
Sub EnterControl
Local prevDir$ Length 63
If PSide Then TMP$=LFList$(LIndx) Else TMP$=RFList$(RIndx)
'Change Directory
If TMP$=".." Or Left$(TMP$,1)="/" Then
  If TMP$=".." Then
    Chdir ".."
    If PSide Then TMP$=LDir$ Else TMP$=RDir$
    TMP$=Left$(TMP$,Len(TMP$)-1)
    i=Len(Cwd$)-2: If i>1 Then Inc i
    prevDir$=Mid$(TMP$,i,255)
  Else
    Chdir Mid$(TMP$,2,63)
  EndIf
  TMP$=Cwd$:TMP$=Mid$(TMP$,3,63)
  If Len(TMP$)>1 Then TMP$=TMP$+"/"
  If PSide Then
    LDir$=TMP$
    LIndx=0:FLS(4,1)=0:FLS(5,1)=0
    GetFList(LDisk$,LDir$,LFList$(),1)
    FColorer(LFList$(),FLS(0,1),FLS(7,1))
    If prevDir$<>"" Then LIndx=IsInFList(1,prevDir$):FLS(4,1)=LIndx
    If LIndx>PFLN Then FLS(4,1)=LIndx Mod PFLN: FLS(5,1)=(LIndx\PFLN)*PFLN
    LPrintPanel
  Else
    RDir$=TMP$
    RIndx=0:FLS(4,0)=0:FLS(5,0)=0
    GetFList(RDisk$,RDir$,RFList$(),0)
    FColorer(RFList$(),FLS(0,0),FLS(7,0))
    If prevDir$<>"" Then RIndx=IsInFList(0,prevDir$):FLS(4,0)=RIndx
    If RIndx>PFLN Then FLS(4,0)=RIndx Mod PFLN: FLS(5,0)=(RIndx\PFLN)*PFLN
    RPrintPanel
  EndIf
  SetPControl("ENA")
  Exit Sub
EndIf
'Action with files
Select Case LCase$(Right$(TMP$,4))
Case ".bas"
  Run TMP$
End Select
W_F3_View
End Sub
'-----------------------
Sub EnterCommandLine(CMD$)
  Print Cwd$;">";
  CMD$=InputE$(CMD$,CHRES-2-Len(Cwd$))
  If CMD$="" Then Exit Sub
  CLS : End CMD$
End Sub
'================================================
' FUNCTION KEY WINDOWS
'================================================
Sub W_F1_Help
Local integer i,cx=2*FW,cy=2*FH
Color c(15),c(1)
OpenWindow("Help",0,0,CHRES,CVRES)
Restore DATA_HELP
Do
  Read TMP$
  If TMP$="" Then Exit Do
  Print @(cx,cy+FH*i)TMP$
  Inc i
Loop
Color 0,c(7): Print @((CHRES-7)*FW,2*FH);"    "
Color 0,c(14):Print @((CHRES-7)*FW,3*FH);"    "
Do :Loop Until Inkey$<>""
Color c(15),0
End Sub
'-----------------------
Sub W_F2_Menu
Local integer n,i=1
If PSide Then cx=1 Else cx=PANW+1
WClear(cx,1,PFLW,PFLN+1)
PrintFKeyMenu("DATA_FKeyZero")
Color c(7),c(0)
Restore DATA_MENU_COMMANDS
For n=1 To PFLN+1
  Read TMP$
  If TMP$="" Then Inc n,-1: Exit For
  Print @(cx*FW,n*FH);"> "+Mid$(TMP$,1,PFLW-2)
Next
Do
If CKey Then
  TMP$="> "+GetRecordFromData$("DATA_MENU_COMMANDS",i)
  Print @(cx*FW,i*FH,2)TMP$;Space$(PFLW-Len(TMP$));
EndIf
CKey=Asc(Inkey$)
Select Case CKey
Case 0 'NOP
Case 10,13'ENTER
  TMP$=GetRecordFromData$("DATA_MENU_COMMANDS",i)
  If TMP$=".." Then Exit Sub
  Call TMP$
  Exit Do
Case 27'ESC
  Exit Sub
Case 128'UP
  Print @(cx*FW,i*FH)TMP$;Space$(PFLW-Len(TMP$));
  If i>1  Then Inc i,-1
Case 129'DN
  Print @(cx*FW,i*FH)TMP$;Space$(PFLW-Len(TMP$));
  If i<n Then Inc i,1
Case Else
  Exit Sub
End Select
Loop
End Sub
'-----------------------
Sub W_F3_View
TMP$=Choice(PSide,LFList$(LIndx),RFList$(RIndx))
On ERROR ignore
Select Case LCase$(Right$(TMP$,4))
Case ".bmp",".jpg",".png"
  ImageViewer(TMP$)
Case ".mod",".mp3",".wav","flac"
  MusicPlayer("START")
Case Else
  CLS : List TMP$
  Do : Loop While Inkey$=""
  PanelsReStart
  SetPControl("ENA")
End Select
W_ERROR_MSG : If MM.Errno Then On ERROR CLEAR:PanelsReStart
End Sub
'----------------------------
Sub MusicPlayer(command$)
Local  B%
Select Case command$
Case "STOP"
  Play Stop: Exit Sub
Case "START"
  mpIndx=0:Play Stop
  mpIndx=Choice(PSide,LIndx,RIndx)
  If FLS(3,PSide) Then
    Inc mpIndx,-1
    MusicPlayer("NEXT")
    Exit Sub
  EndIf
Case "NEXT"
  If FLS(3,PSide) Then
    Do
      Inc mpIndx :If mpIndx>FLS(0,PSide) Then mpIndx=1
      B=Choice(PSide,Peek(VAR LFList$(mpIndx),59),Peek(VAR RFList$(mpIndx),59))
    Loop Until B And 128'Selected
  Else
    Exit Sub
  EndIf
End Select
command$=Choice(PSide,LFList$(mpIndx),RFList$(mpIndx))
'------Play Music File
On ERROR ignore
Select Case LCase$(Right$(command$,4))
Case "flac"
  Play FLAC command$,ISR_MPlayer
Case ".mod"
  Play MODFILE command$,ISR_MPlayer
Case ".wav"
  Play WAV command$,ISR_MPlayer
Case ".mp3"
  Play MP3 command$,ISR_MPlayer
End Select
W_ERROR_MSG : If MM.Errno Then On ERROR CLEAR:PanelsReStart
End Sub

Sub ISR_MPlayer
  If mpIndx<>0 Then MusicPlayer("NEXT")
End Sub
'----------------------------
Sub ImageViewer(fname$)
If Instr(MM.DEVICE$,"RP2350") Then MODE 3 Else MODE 1
On ERROR ignore
Select Case LCase$(Mid$(fname$,Len(fname$)-3,4))
Case ".bmp"
  Load IMAGE fname$
Case ".jpg"
  Load JPG fname$
Case ".png"
  Load PNG fname$
End Select
If MM.Errno Then
  MODE 1:Font 1:TILE HEIGHT MM.Info(FONTHEIGHT)
  W_ERROR_MSG : If MM.Errno Then On ERROR CLEAR
Else
  Do : Loop While Inkey$=""
  MODE 1:Font 1:TILE HEIGHT MM.Info(FONTHEIGHT)
EndIf
PanelsReStore
End Sub
'----------------------
Sub W_F4_Edit
TMP$=GetCurrFileName$()
If TMP$=".." Then
  Color c(15),c(1)
  CXCY(72,7,1):OpenWindow("EDIT New File",cx,cy,72,7)
  CXCY(2,2):Print GetCurrFullPath$();
  CXCY(4,4):Print ">"
  Color c(14),c(0)
  CXCY(5,4):Print Space$(64);
  CXCY(5,4):TMP$=InputE$("",64)
  Color c(15),c(0)
Else
  If Mid$(TMP$,1,1)="/" Then TMP$=""
EndIf
End Sub
'-----------------------
Sub W_F5_Copy
Local FLAG%=1
Do
If FLS(3,PSide) Then 'Multi Select
   FLS(3,PSide)=FLS(3,PSide)-1
   FLAG=0
 If PSide Then
   LIndx=FindAndClearAtrFlag(LFList$(),FLS(0,1),128)
 Else
   RIndx=FindAndClearAtrFlag(RFList$(),FLS(0,0),128)
 EndIf
EndIf
Chdir GetCurrFullPath$()
Color c(15),c(1)
CXCY(72,13,1):OpenWindow("Copy file:",cx,cy,72,13)
CXCY(2,3):Print GetCurrFullPath$();
CXCY(2,5):Print "to";
CXCY(2,7):Print GetFullPath$(OpSide());
CXCY(3,8):Print ">";
TMP$=GetCurrFileName$()
Color c(15),c(0)
CXCY(5,4):Print Space$(64);:CXCY(5,4):Print TMP$;
CXCY(5,8):Print Space$(64);:CXCY(5,8):Print TMP$;
Color c(14),c(0):CXCY(5,8)
If FLAG And 1 Then TMP$=InputE$(GetCurrFileName$(),64)
Color c(15),c(0)
If IsInFList(OpSide(),TMP$) Then
  Color c(15),c(8)
  CXCY(5,10):Print " Warning!  File already exists. To Overwrite, press [ENTER]"
  Color c(15),c(0)
  Do
    CKey=Asc(Inkey$)
    If CKey=10 Or CKey=13 Then Exit Do
    If CKey>0  Then Exit Sub
  Loop
EndIf
If TMP$<>"" Then
  If Mid$(TMP$,1,1)="/" Then
    CopyDir(GetFullPath$(PSide)+TMP$,GetFullPath$(OPSide())+TMP$)
  Else
    TMP$=GetFullPath$(OpSide())+TMP$
    On ERROR ignore
    Copy GetCurrFileName$() To TMP$
    W_ERROR_MSG : If MM.Errno Then On ERROR CLEAR
  EndIf
EndIf
Loop While FLS(3,PSide)
End Sub
'-----------------------
Sub W_F6_RenMOVE
Local FLAG%=1
Do
If FLS(3,PSide) Then 'Multi Select
   FLS(3,PSide)=FLS(3,PSide)-1
   FLAG=0
 If PSide Then
   LIndx=FindAndClearAtrFlag(LFList$(),FLS(0,1),128)
 Else
   RIndx=FindAndClearAtrFlag(RFList$(),FLS(0,0),128)
 EndIf
EndIf
Color c(15),c(1)
CXCY(72,13,1):OpenWindow("Rename/Move:",cx,cy,72,13)
CXCY(2,3):Print GetCurrFullPath$();
CXCY(2,5):Print "to";
CXCY(2,7):Print GetFullPath$(OpSide());
CXCY(3,8):Print ">";
TMP$=GetCurrFileName$()
Color c(15),c(0)
CXCY(5,4):Print Space$(64);:CXCY(5,4):Print TMP$;
CXCY(5,8):Print Space$(64);:CXCY(5,8):Print TMP$;
Color c(14),c(0):CXCY(5,8)
If FLAG And 1 Then TMP$=InputE$(GetCurrFileName$(),64)
Color c(15),c(0)
If IsInFList(OpSide(),TMP$) Then
  Color c(15),c(8)
  CXCY(5,10):Print " Warning! File already exists. To Overwrite, press [ENTER]"
  Color c(15),c(0)
  Do
    CKey=Asc(Inkey$)
    If CKey=10 Or CKey=13 Then Exit Do
    If CKey>0  Then Exit Sub
  Loop
EndIf
If TMP$<>"" Then
  If Mid$(TMP$,1,1)="/" Then
    CopyDir(GetFullPath$(PSide)+TMP$,GetFullPath$(OPSide())+TMP$)
    DeleteDir(GetFullPath$(PSide)+TMP$)
  Else
    TMP$=GetFullPath$(OpSide())+TMP$
    On ERROR ignore
    Copy GetCurrFullPathFile$() To TMP$
    If Not MM.Errno Then
      Kill GetCurrFullPathFile$()
    EndIf
    W_ERROR_MSG : If MM.Errno Then On ERROR CLEAR
  EndIf
EndIf
Loop While FLS(3,PSide)
End Sub
'----------------------
Sub W_F7_MkDIR
  TMP$=GetCurrFullPath$():Chdir TMP$
  Color c(15),c(1)
  CXCY(72,7,1):OpenWindow("Make a Directory:",cx,cy,72,7)
  CXCY(2,2):Print TMP$
  CXCY(3,4):Print "> ";
  Color c(14),c(0):Print Space$(64);
  CXCY(5,4): TMP$=InputE$("",64)
  Color c(15),c(0)
  If TMP$<>"" Then Mkdir TMP$
End Sub
'----------------------
Sub W_F8_DELETE
Local FLAG%=1
Do
If FLS(3,PSide) Then 'Multi Select
   FLS(3,PSide)=FLS(3,PSide)-1
   FLAG=0
   If PSide Then
    LIndx=FindAndClearAtrFlag(LFList$(),FLS(0,1),128)
   Else
    RIndx=FindAndClearAtrFlag(RFList$(),FLS(0,0),128)
   EndIf
EndIf
  Chdir GetCurrFullPath$()
  Color c(15),c(1)
  CXCY(72,7,1):OpenWindow("Delete:",cx,cy,72,7)
  CXCY(2,2):Print GetCurrFullPath$();
  CXCY(3,4):Print ">";
  Color c(8),c(0)
  CXCY(5,4):Print Space$(64);
  CXCY(5,4):Print GetCurrFileName$();
  Color c(15)
  If Flag And 1 Then
    Do
      CKey=Asc(Inkey$)
      If CKey=10 Or CKey=13 Then Exit Do
      If CKey>0 Then Exit Sub
    Loop
  EndIf
  On ERROR ignore
  If Mid$(GetCurrFileName$(),1,1)="/" Then
    DeleteDir(GetCurrFullPathFile$())
  Else
    Kill GetCurrFileName$()
    W_ERROR_MSG : If MM.Errno Then On ERROR CLEAR
  EndIf
Loop While FLS(3,PSide)
End Sub
'----------------------
Sub W_F9_USER_COMMANDS
Local i,n
Do
PrintFKeyMenu("DATA_FKeyAlt2")
Color c(7),0
OpenWindow("User Commands Menu",0,0,CHRES,PANH)
Restore DATA_USER_COMMANDS
For n=1 To PANH-2
  Read TMP$
  If TMP$="" Then Inc n,-1: Exit For
  Print @(FW,n*FH);Mid$(TMP$,1,CHRES-2);
Next
i=1
Do
If CKey Then
  TMP$=GetRecordFromData$("DATA_USER_COMMANDS",i)
  Print @(FW,i*FH,2)TMP$;Space$(CHRES-2-Len(TMP$));
  PrintComLine(">"+TMP$)
  Color c(7)
EndIf
CKey=Asc(Inkey$)
Select Case CKey
Case 0 'NOP
Case 13'ENTER
  If TMP$=".." Then Exit Sub
  If Mid$(TMP$,1,2)="> " Then
    CLS
    End Mid$(TMP$,3,Len(TMP$))
  Else
    CLS : Color c(7)
    Execute TMP$
    Do : Loop While Inkey$=""
    Exit Do
  EndIf
Case 27'ESC
  Exit Sub
Case 128'UP
  Print @(FW,i*FH)TMP$;Space$(CHRES-2-Len(TMP$));
  If i>1  Then Inc i,-1
Case 129'DN
  Print @(FW,i*FH)TMP$;Space$(CHRES-2-Len(TMP$));
  If i<n Then Inc i,1
Case 145'F1
  End "Files"
Case 154'F10
  Exit Sub
End Select
Loop :Loop
End Sub
'----------------------
Sub W_QUIT
Color c(15),c(8)
CXCY(30,8,1):OpenWindow(" Quit ",cx,cy,30,8)
CXCY(2,2):Print " Do you want to quit FM ?";
CXCY(2,4):Print "'Yes'- Press [ENTER] Key";
CXCY(2,5):Print " 'No' - Press any Key";
Color c(15),c(0)
Do
  Select Case Asc(Inkey$)
  Case 0
  Case 10,13,154'ENTER'
    CLS : End
  Case Else
    Exit Do
  End Select
Loop
End Sub
'WINDOW DISCK SELECT -------------------
Sub WDiskSelect(SIDE%)
Local N
Local DSK$(1) LENGTH 39
cy=(PANH-6)\2
If SIDE Then cx=(PANW-36)\2 Else cx=(PANW-36)\2+PANW
Color c(15),c(1):OpenWindow("DISK",cx,cy,36,6)
CXCY(1,1):Print "    Drive   |   Size   |   Free   "
CXCY(1,2):Print "------------+----------+----------"
Drive "A:"
TMP$=" A: FlashFS |"
TMP$=TMP$+Str$(MM.Info(DISK SIZE)\1024,9)+" |"
TMP$=TMP$+Str$(MM.Info(FREE SPACE)\1024,9)+" "
DSK$(0)=TMP$
On ERROR SKIP 1
If MM.Info(SDCARD)="Ready" Then Inc N
On ERROR CLEAR
If N>0 Then
  Drive "B:"
  TMP$=" B: SD Card |"
  TMP$=TMP$+Str$(MM.Info(DISK SIZE)\1024,9)+" |"
  TMP$=TMP$+Str$(MM.Info(FREE SPACE)\1024,9)+" "
Else
  TMP$=" B: SD Card |   NO Disk Drive !   "
EndIf
DSK$(1)=TMP$
CXCY(1,3,2)
Print @(cx*FW,(cy+0)*FH,2);DSK$(0);
Print @(cx*FW,(cy+1)*FH,0);DSK$(1);
i=0
Do
  CKey=Asc(Inkey$)
  Select Case CKey
  Case 0
  Case 10,13
    Color c(15),0
    Exit Do
  Case 27
    Color c(15),0
    Exit Sub
  Case Else
    Print @(cx*FW,(cy+i)*FH,0);DSK$(i);
    Inc i: If i>N Then i=0
    Print @(cx*FW,(cy+i)*FH,2);DSK$(i);
  End Select
Loop
If i=0 Then TMP$="A:" Else TMP$="B:"
If SIDE Then LDisk$=TMP$ Else RDisk$=TMP$
PSide=SIDE
End Sub
'WINDOW ALT VIEW FILE  ----------------
Sub W_AltF3_View2
  CLS c(1):Color c(15),c(7)
  TMP$=GetCurrFullPathFile$()
  Print TMP$+Space$(CHRES-Len(TMP$))
  Color c(15),c(1)
  TMP$=GetCurrFileName$()
  HEX_Editor TMP$,0
End Sub
'======================================
Sub HEX_Editor(fname$,Amode%)
Local LoF%,PoF%,FF%
Local BUFF$
CLS c(1):Color c(15),c(7)
Print fname$+Space$(CHRES-Len(fname$))
Color c(15),c(1)
  Open fname$ For INPUT As #1
  Seek #1,1
  LoF=Lof(#1)'Length of file
  PoF=Loc(#1)'Position pointer


  Print Hex$(PoF-1,8);":  ";
  BUFF$=Input$(16,#1)
  For i=1 To 16
    FF=Peek(VAR BUFF$,i)
    Print Hex$(FF,2);
    If (i Mod 4) Then Print " "; Else Print "  ";
  Next
  Print " ";BUFF$


Do : Loop While Inkey$=""
Close 1
End Sub

'WINDOW FILE FIND ---------------------
Sub W_AltF7_Find
  TMP$=GetCurrFullPath$():Chdir TMP$
  Color c(15),c(1)
  CXCY(70,8,1):OpenWindow("Find File:",cx,cy,70,8)
  CXCY(2,2):Print "> ";
  CXCY(2,4):Print "Starting from this folder:";
  Color c(14),c(0)
  CXCY(2,5):Print Space$(66);
  CXCY(2,5):Print TMP$;
  CXCY(4,2):Print Space$(64);
  CXCY(4,2):TMP$=InputE$("*",64)
  If TMP$="" Then Exit Sub
  TMP$=FindFile$(TMP$)
  If TMP$="" Then
    Color c(15),c(8)
    CXCY(16,6):Print "No files found matching your request!";
    Do : Loop While Inkey$=""
  Else
    Local string FName$=TMP$
    If PSide Then
      LDir$=Mid$(Cwd$,3)
      GetFList(LDisk$,LDir$,LFList$(),1)
      FColorer(LFList$(),FLS(0,1),FLS(7,1))
      LIndx=IsInFList(1,FName$):FLS(4,1)=LIndx:FLS(5,1)=0
      If LIndx>PFLN Then FLS(4,1)=LIndx Mod PFLN:FLS(5,1)=(LIndx\PFLN)*PFLN
    Else
      RDir$=Mid$(Cwd$,3)
      GetFList(RDisk$,RDir$,RFList$(),0)
      FColorer(RFList$(),FLS(0,0),FLS(7,0))
      RIndx=IsInFList(0,FName$):FLS(4,0)=RIndx:FLS(5,0)=0
      If RIndx>PFLN Then FLS(4,0)=RIndx Mod PFLN:FLS(5,0)=(RIndx\PFLN)*PFLN
    EndIf
  EndIf
End Sub
'Window ERROR MSG -----------
Sub W_ERROR_MSG
Local integer l
If MM.Errno Then
  l=Len(MM.ErrMsg$)+4
  Color c(15),c(8)
  CXCY(l,6,1):OpenWindow("ERROR:",cx,cy,l,6)
  CXCY(2,2):Print MM.ErrMsg$;
  Color c(15),c(0)
  Do : Loop While Inkey$=""
EndIf
On ERROR ABORT
End Sub
'================================================
' PANEL WORKING SUBROUTINS
'================================================
Sub GetCKey
Static AltFlag
    CKey=Asc(Inkey$)
    On ERROR SKIP
    If KeyDown(7) And &H11 Then Inc AltFlag Else AltFlag=0
    If MM.Errno Then On ERROR CLEAR
    If AltFlag=1 Then CKey=139'ALT
End Sub
'----------------------
Sub CXCY(inCX%,inCY%,sMode%)
  Select Case sMode
  Case 0'Set Offset Pos Print @(x,y)
    Print @((cx+inCX)*FW,(cy+inCY)*FH);
  Case 1'Set Pos of Left Corner Window (W,H,1)
    cx=(CHRES-inCX)\2:cy=(CVRES-inCY)\2
  Case 2'Add & Set Offset Pos
    Inc cx,inCX:Inc cy,inCY
    Print @(cx*FW,cy*FH);
  Case 3'Set CX & CY
    cx=inCX:cy=inCY
  End Select
End Sub
'----------------------
Sub Changing_Panel_View
  Inc FLS(8,PSide)
  If FLS(8,PSide)>1 Then FLS(8,PSide)=0
  If PSide Then LPrintPanel Else RPrintPanel
  SetPControl("ENA")
End Sub
'----------------------
Sub SortSwitch
Local integer x,SS,TR=1
If PSide Then SS=FLS(6,1) Else SS=FLS(6,0)
Inc SS: If SS>SOMAX Then SS=0
Timer =0
Do :If Timer>1000 Then Exit Do
If TR Then
  If PSide Then x=2 Else x=PANW+2
  Print @(x*FW,(PANH-4)*FH,2)GetRecordFromData$("DATA_SORT",SS+1);
  TR=0
EndIf
Select Case Asc(Inkey$)
Case 128,131,96'Up
  Timer =0: TR=1: Inc SS, 1: If SS>SOMAX Then SS=0
Case 129,130'Dn
  Timer =0: TR=1: Inc SS,-1: If SS<0 Then SS=SOMAX
End Select
Loop
If PSide Then
  FLS(6,1)=SS:LPanelShow:SetPControl("ENA")
Else
  FLS(6,0)=SS:RPanelShow:SetPControl("ENA")
EndIf
End Sub
'----------------------
Sub SelectingFile(FList$(),Indx)
If Indx=0 Then Exit Sub
Local N%,Atr%
  Atr=Peek(VAR FList$(Indx),59)
  Atr=Atr Xor 128'Sel.Flag
  Poke VAR FList$(Indx),59,Atr
  N=FLS(3,PSide)
  If Atr And 128 Then Inc N Else Inc N,-1
  FLS(3,PSide)=N
End Sub
'------------------------------------------------
'Panels Interface ReWrite
Sub PanelsReStart
  PrintFKeyMenu("DATA_FKeyMain")
  LPanelShow
  RPanelShow
  SetPControl("ENA")
End Sub
'Panels Interface Restore
Sub PanelsReStore
  PrintFKeyMenu("DATA_FKeyMain")
  LPrintPanel
  RPrintPanel
  SetPControl("ENA")
End Sub
'----------------------LPanel
Sub LPanelShow
  LIndx=0:FLS(4,1)=0:FLS(5,1)=0
  GetFList(LDisk$,LDir$,LFList$(),1)
  FColorer(LFList$(),FLS(0,1),FLS(7,1))
  LPrintPanel
End Sub
Sub LPrintPanel
  OpenWindow(GetTrimPath$(1,PANW-4),0,0,PANW,PANH)
  PFLPrint(1)
  WHBar(0,PANH-4,PANW)
  If FLS(8,1) Then WVBar(PANW-10,0,PANH-3)
  Print @(2*FW,(PANH-4)*FH,2)GetRecordFromData$("DATA_SORT",FLS(6,1)+1);
  Print @(8*FW,(PANH-1)*FH,2)"Folders:";FLS(1,1);", Files:";FLS(2,1);
  If FLS(0,1)>=RMAX-1 Then Color c(15),c(8):Print "!";:Color c(15),0
  PrintSelectedFilesNum(1)
End Sub
'----------------------RPanel
Sub RPanelShow
  RIndx=0:FLS(4,0)=0:FLS(5,0)=0
  GetFList(RDisk$,RDir$,RFList$(),0)
  FColorer(RFList$(),FLS(0,0),FLS(7,0))
  RPrintPanel
End Sub
Sub RPrintPanel
  OpenWindow(GetTrimPath$(0,PANW-4),PANW,0,PANW,PANH)
  PFLPrint(0)
  WHBar(PANW,PANH-4,PANW)
  If FLS(8,0) Then WVBar(CHRES-10,0,PANH-3)
  Print @((PANW+2)*FW,(PANH-4)*FH,2)GetRecordFromData$("DATA_SORT",FLS(6,0)+1);
  Print @((PANW+8)*FW,(PANH-1)*FH,2)"Folders:";FLS(1,0);", Files:";FLS(2,0);
  If FLS(0,0)>=RMAX-1 Then Color c(15),c(8):Print "!";:Color c(15),0
  PrintSelectedFilesNum(0)
End Sub
'============================
Sub OpenWindow(Titl$,xc,yc,wc,hc)
  WFrame(xc,yc,wc,hc)
  Print @((xc+2)*FW,yc*FH,2)Titl$;
End Sub
'----------------------
Sub WClear(xc,yc,wc,hc)
Local integer x=xc*FW,y=yc*FH
  For y=yc*FH To (yc+hc-1)*FH Step FH
    Print @(x,y) Space$(wc);
  Next
End Sub
'----------------------
Sub WFrame(xc,yc,wc,hc)
Local integer y,x=xc*FW
  Print @(x,yc*FH)Chr$(201);String$(wc-2,205);Chr$(187);
  For y=(yc+1)*FH To (yc+hc-2)*FH Step FH
    Print @(x,y)Chr$(186);Space$(wc-2);Chr$(186);
  Next
  Print @(x,y)Chr$(200);String$(wc-2,205);Chr$(188);
End Sub
'----------------------
Sub WHBar(xc,yc,wc)
  Print @(xc*FW,yc*FH)Chr$(199);String$(wc-2,196);Chr$(182);
End Sub
'----------------------
Sub WVBar(xc,yc,hc)
  xc=xc*FW:yc=yc*FH
  Print @(xc,yc)Chr$(209);
  For i=1 To hc-2
  Inc yc,FH:Print @(xc,yc)Chr$(179);
  Next
  Inc yc,FH:Print @(xc,yc)Chr$(193);
End Sub
'======================================
'PRINT FILE LIST ON PANEL
Sub PFLPrint(SIDE)
Local integer wid
wid=Choice(FLS(8,SIDE),PFLW-9,PFLW)
  If SIDE Then
    PrintFL(LFList$(),FLS(0,1),FLS(5,1),1,1,wid,PFLN)
    If FLS(8,1) Then
      Drive LDisk$:Chdir LDir$
      PrintFLSize(LFList$(),FLS(0,1),FLS(5,1),PANW-9,1,8,PFLN)
    EndIf
  Else
    PrintFL(RFList$(),FLS(0,0),FLS(5,0),PANW1,1,wid,PFLN)
    If FLS(8,0) Then
      Drive RDisk$:Chdir RDir$
      PrintFLSize(RFList$(),FLS(0,0),FLS(5,0),CHRES-9,1,8,PFLN)
    EndIf
  EndIf
End Sub
'----------------------------
Sub PrintFL(FList$(),Fmax,top,xc,yc,wc,hc)
Local integer y,x,Indx,FC
Indx=top:x=xc*FW
For y=yc To yc+hc
  Print @(x,y*FH);
  If Indx<=Fmax Then
    TMP$=FList$(Indx)
    TMP$=Left$(TMP$,wc)
    TMP$=TMP$+Space$(wc-Len(TMP$))
    FC=Peek(VAR FList$(Indx),59)'Get Atr.
    If FC And 128 Then FC=SelColor Else FC=FC And 15 'Selected
    If Indx Then Color c(FC)
    Print TMP$;
    Inc Indx
  Else
    Print Space$(wc);
  EndIf
Next
Color c(15)
End Sub
'----------------------------
Sub PrintFLSize(FList$(),Fmax,top,xc,yc,wc,hc)
Local integer sigROOT=&HFFFFFFFF,sigDIR=&HFFFFFFFE
Local integer y,x,Indx,fSize
Indx=top:x=xc*FW
For y=yc To yc+hc
  Print @(x,y*FH);
  If Indx<=Fmax Then
    fSize=Peek(WORD Peek(VARADDR FList$(Indx))+60)
    If fSize=0 Then
      TMP$=FList$(Indx)
      If Indx=0 Then
        fSize=sigROOT
      Else
        If Left$(TMP$,1)="/" Then
          fSize=sigDIR
        Else
          fSize=MM.Info(FILESIZE TMP$)
        EndIf
      EndIf
      Poke WORD Peek(VARADDR FList$(Indx))+60,fSize
    EndIf
    Select Case fSize
    Case IS<sigDIR
      Print Str$(fSize,wc)
    Case sigDIR
      Print " <DIR>  ";
    Case sigROOT
      Print @(x,y*FH,2)"__Size__";
    End Select
    Inc Indx
  Else
    Print Space$(wc);
  EndIf
Next
End Sub
'--------------------------------------
'PRINT FILE NAME WITH ATRIBUTE ON PANEL
Sub PFNAPrint(SIDE,M,BC)
Local pView=FLS(8,SIDE)
Local width=Choice(FLS(8,SIDE),PFLW-9,PFLW)
If SIDE Then
  FNAPrint(LFList$(),LIndx,M,BC,pView,1,FLS(4,1)+1,width)
Else
  FNAPrint(RFList$(),RIndx,M,BC,pView,PANW1,FLS(4,0)+1,width)
EndIf
End Sub
'----------------------------
Sub FNAPrint(FList$(),Indx,M,BC,pView,xc,yc,wc)
Local FC
  TMP$=Left$(FList$(Indx),wc)
  TMP$=TMP$+Space$(wc-Len(TMP$))
  If Indx Then
    FC=Peek(VAR FList$(Indx),59)'Get Atr.
    If FC And 128 Then FC=SelColor Else FC=FC And 15 'Selected
    If M Then
      If FC=BC Then Color c(BC),c(0) Else Color c(BC),c(FC)
    Else
      If FC=BC Then Color c(0),c(BC) Else Color c(FC),c(BC)
    EndIf
  Else
    If M Then Color c(BC),c(0) Else Color c(15),c(BC)
  EndIf
  cx=xc*FW:cy=yc*FH
  Select Case pView
  Case 0
    Print @(cx,cy,M)TMP$;
  Case 1
    Print @(cx,cy,M)TMP$;
    If M Then Color c(BC),c(0) Else Color c(15),c(BC)
    Local fSize,sigROOT=&HFFFFFFFF,sigDIR=&HFFFFFFFE
    cx=cx+(wc+1)*FW
    fSize=Peek(WORD Peek(VARADDR FList$(Indx))+60)
    Select Case fSize
    Case IS<sigDIR
      Print @(cx,cy,M)Str$(fSize,8);
    Case sigDIR
      Print @(cx,cy,M)" <DIR>  ";
    Case sigROOT
      Print @(cx,cy,2)"__Size__";
    Case 2
      '***
    End Select
  End Select
  Color c(15),0
End Sub
'----------------------------
'PRINT COMMAND LINE
Sub PrintComLine(COM$)
Local String CL$
If Len(COM$)>CHRES-3 Then COM$=Mid$(COM$,1,CHRES-4)+"}"
If PSide Then CL$=LDisk$+LDir$ Else CL$=RDisk$+RDir$
CL$=CL$+COM$
If Len(CL$)>CHRES Then CL$=Mid$(CL$,1,CHRES-2-Len(COM$))+"~/"+COM$
Color c(7)
Print @(0,PANH*FH);CL$+Space$(CHRES-Len(CL$))
Color c(15)
End Sub
'----------------------------
'PRINT FUNCTION KEY MENU
Sub PrintFKeyMenu(LineLabel$)
Local x=0,y=(PANH+1)*FH:N=(CHRES+1)\9
Color c(15),0:Print @(0,y);
For i=1 To 9
  Print "F";Str$(i);
  If i<9 Then Print Space$(N-2);
Next
Print Space$(CHRES-2-N*8);
Color c(7),c(0):x=2*FW
Restore LineLabel$
For i=1 To 9
 Read LineLabel$
 Print @(x,y,2)LineLabel$;
 Inc x,N*FW
Next
Color c(15),0
End Sub
'----------------------------
'PRINT SELECTED FILES NUMBER
Sub PrintSelectedFilesNum(SIDE%)
  If SIDE Then CXCY((PANW-12)\2,PANH-4,3) Else CXCY((PANW-12)\2+PANW,PANH-4,3)
  If FLS(3,SIDE) Then
    Print @(cx*FW,cy*FH,2)"Selected:";Str$(FLS(3,SIDE),3);
  Else
    Print @(cx*FW,cy*FH)String$(13,196);'-------'
  EndIf
End Sub
'------------------------------------------------
'PRINT Watch Time
Sub PrintTime
  Tick1s=0
  Colour c(14),c(1)
  Print @((CHRES-5)*FW,0);Mid$(Time$,1,5);
  Colour c(15),c(0)
End Sub
'INTERRUP ROUTINES
Sub ISR_Tick1s
  Inc Tick1s
End Sub
'============================
'SCREEN SAVER - Matrix
Sub SSMatrix
Local matr(CHRES),fade(CHRES),clr,x
For x=1 To CHRES:matr(x)=CVRES*Rnd:fade(x)=&hF*Rnd:Next
Do
  For x=1 To CHRES
    clr=&h1000*(fade(x)-&hF) And &hFF00
    Colour clr
    Print @(x*FW-FW,matr(x)*FH)Chr$(Rnd*223+32);
    If matr(x)>CVRES  Then matr(x)=0 Else Inc matr(x)
    If fade(x)=&hF0 Then fade(x)=0 Else Inc fade(x)
  Next
  Pause 10
Loop While Inkey$=""
Colour c(15)
End Sub
'------------------------------------------------
Sub GetFList(Disk$,Folder$,FList$(),SIDE%)
Local integer RQt,DQt,FQt,i,FS
Drive Disk$: Chdir Folder$
FList$(RQt)=".."
TMP$=Dir$("*",DIR)
Do While TMP$<>""
  If RQt=RMax Then Exit Do
  Inc RQt: Inc DQt
  FList$(RQt)="/"+Left$(TMP$,57)
  TMP$=Dir$()
Loop
TMP$=Dir$("*",FILE)
Do While TMP$<>""
  If RQt=RMax Then Exit Do
  Inc RQt: Inc FQt
  FList$(RQt)=Left$(TMP$,58)
  TMP$=Dir$()
Loop
FLS(0,SIDE)=RQt:FLS(1,SIDE)=DQt:FLS(2,SIDE)=FQt:FLS(3,SIDE)=0
If RQt=0 Then Exit Sub
'Sorting--------------------
Local integer SO=FLS(6,SIDE)
Select Case SO
Case 3,4'Date
  Local string  FDate$(RQt) LENGTH 19
  Local integer SIndx%(RQt)
  For i=1 To DQt
    TMP$=Mid$(FList$(i),2)
    FDate$(i)=MM.Info(MODIFIED TMP$)
  Next
  For i=DQt+1 To RQt
    TMP$=FList$(i)
    FDate$(i)=MM.Info(MODIFIED TMP$)
  Next
Case 5,6'Size
  Local integer FSize%(RQt)
  Local integer SIndx%(RQt)
  For i=1 To DQt
    FSize%(i)=-1
  Next
  For i=DQt+1 To RQt
    TMP$=FList$(i)
    FSize%(i)=MM.Info(FILESIZE TMP$)
  Next
Case 7,8'Extention
  Local string  FDate$(RQt) LENGTH 19
  Local integer SIndx%(RQt)
  For i=1 To DQt
    TMP$=Mid$(FList$(i),2)
    FDate$(i)="*"
  Next
  For i=DQt+1 To RQt
    TMP$=FList$(i)
    FDate$(i)=LCase$(Mid$(TMP$,Len(TMP$)-3,4))
  Next
End Select
If SO=1 Then Sort FList$(),,2,1,RQt
If SO=2 Then Sort FList$(),,3,1,RQt
If SO=3 Then Sort FDate$(),SIndx%(),0,1,RQt
If SO=4 Then Sort FDate$(),SIndx%(),1,1,RQt
If SO=5 Then Sort FSize%(),SIndx%(),0,1,RQt
If SO=6 Then Sort FSize%(),SIndx%(),1,1,RQt
If SO=7 Then Sort FDate$(),SIndx%(),0,1,RQt
If SO=8 Then Sort FDate$(),SIndx%(),1,1,RQt
If SO>2 Then ArrangeByIndex(FList$(),SIndx%(),RQt):FList$(0)=".."
End Sub
'------------------------------------------------
Sub ArrangeByIndex(A$(),Ind%(),Size%)
Local i,Ci,Vi
For i=1 To Size%
  Vi=Ind%(i)
  If Vi=i Or Vi=0 Then Ind%(i)=0:Continue For
  A$(0)=A$(i): Ci=i
  Do
    Ind%(Ci)=0
    If Vi=i Then A$(Ci)=A$(0):Exit Do
    A$(Ci)=A$(Vi):Ci=Vi
    Vi=Ind%(Ci)
  Loop
Next
End Sub
'Colorer-----------------------------------------
Sub FColorer(FList$(),Fmax%,FColor%)
Local i,FC%=FColor And 15
If FC Then
  For i=1 To Fmax
    Poke VAR FList$(i),59,FC
    Poke WORD Peek(VARADDR FList$(i))+60,0
  Next
Else 'Colorer ON
  For i=1 To Fmax
    TMP$=FList$(i)
    If Left$(TMP$,1)="/" Then
      FC=15
    Else
      Select Case LCase$(Right$(TMP$,4))
      Case ".bas"
        FC=7
      Case ".zip",".dat"
        FC=8
      Case ".txt",".cfg",".opt"
        FC=12
      Case ".mp3",".mod",".wav","flac"
        FC=6
      Case ".bmp",".jpg",".png"
        FC=9
      Case Else
        FC=15
      End Select
    EndIf
    Poke VAR FList$(i),59,FC
    Poke WORD Peek(VARADDR FList$(i))+60,0
  Next
EndIf
End Sub
'------------------------------------------------
Sub DeleteDir(path$)
Local string file$, subdir$
On ERROR IGNORE
For i=0 To 2 'Check twice, why?
  file$=Dir$(path$+"/",FILE)
  Do While file$<>""
    Kill path$+"/"+file$
    file$=Dir$()
  Loop
Next
Delete_Do:
  subdir$=Dir$(path$+"/*",DIR)
  If subdir$="" Then GoTo Delete_Lend
  DeleteDir(path$+"/"+subdir$)
  GoTo Delete_Do '--loop--
Delete_Lend:
  Rmdir path$
  Chdir ".."
  W_ERROR_MSG : If MM.Errno Then On ERROR CLEAR
End Sub
'------------------------------------------------
Sub CopyDir(src$,dest$)
Local string file$ LENGTH 63
Drive Left$(dest$,2)
If Not MM.Info(EXISTS DIR dest$) Then On ERROR SKIP: Mkdir dest$
W_ERROR_MSG :If MM.Errno Then On ERROR CLEAR: Exit Sub
Drive Left$(src$,2): Chdir src$
'CopyDir Files
file$=Dir$(src$+"/*",FILE)
Do While file$<>""
  On ERROR SKIP
  Copy src$+"/"+file$ To dest$+"/"+file$
  W_ERROR_MSG :If MM.Errno Then On ERROR CLEAR: Exit Sub
  file$=Dir$()
Loop
'CopyDir Dirs
Local dCount=0,i=0
Local STRING subDir$=Dir$("*",DIR)
Do While subDir$<>""
  Inc dCount
  subDir$=Dir$()
Loop
If dCount>=1 Then
  Local sDirs$(dCount) LENGTH 63
  subDir$=Dir$("*",DIR)
  Do While subDir$<>""
    sDirs$(i)=subDir$
    Inc i
    subDir$=Dir$()
  Loop
  For i=0 To dCount-1
    CopyDir(src$+"/"+sDirs$(i), dest$+"/"+sDirs$(i))
  Next i
EndIf
End Sub
'================================================
' FUNCTIONS
'================================================
Function GetFullPath$(SIDE%) As string
If SIDE Then GetFullPath$=LDisk$+LDir$ Else GetFullPath$=RDisk$+RDir$
End Function
'----------------------
Function GetCurrFullPath$() As string
If PSide Then
  GetCurrFullPath$=LDisk$+LDir$
Else
  GetCurrFullPath$=RDisk$+RDir$
EndIf
End Function
'----------------------
Function GetCurrFileName$() As string
If PSide Then
  GetCurrFileName$=LFList$(LIndx)
Else
  GetCurrFileName$=RFList$(RIndx)
EndIf
End Function
'----------------------
Function GetCurrFullPathFile$() As string
If PSide Then
  GetCurrFullPathFile$=LDisk$+LDir$+LFList$(LIndx)
Else
  GetCurrFullPathFile$=RDisk$+RDir$+RFList$(RIndx)
EndIf
End Function
'----------------------
Function OpSide() As integer
If PSide Then OpSide=0 Else OpSide=1
End Function
'----------------------
Function GetTrimPath$(SIDE%,N%) As string
Local TEMP$
If SIDE Then TEMP$=LDisk$+LDir$ Else TEMP$=RDisk$+RDir$
If Len(TEMP$)<=N% Then
  GetTrimPath$=TEMP$
Else
  GetTrimPath$=Mid$(TEMP$,1,N%-1)+"~"
EndIf
End Function
'----------------------
Function IsInFList(SIDE%,FName$) As integer
If SIDE Then
  IsInFList=FindInFList(LFList$(),FName$,FLS(0,SIDE))
Else
  IsInFList=FindInFList(RFList$(),FName$,FLS(0,SIDE))
EndIf
End Function
'-----------------------
Function FindInFList(Flist$(),FName$,Fmax%) As integer
Local i=0
  Do
    If Flist$(i)=Fname$ Then Exit Do
    Inc i:If i>Fmax Then i=0: Exit Do
  Loop
  FindInFList=i
End Function
'-----------------------
Function FindAndClearAtrFlag(FList$(),Deep%,Flag%) As integer
Local B%,answer%=0
For i=1 To Deep
  B=Peek(VAR FList$(i),59)
  If B And Flag Then
    Poke VAR FList$(i),59,B Xor Flag
    answer=i
    Exit For
  EndIf
Next
FindAndClearAtrFlag=answer
End Function
'-----------------------
Function GetRecordFromData$(DataLabel$,Ind%) As string
Local i
  Restore DataLabel$
  For i=1 To Ind%
    Read GetRecordFromData$
  Next
End Function
'Find One File in FS----
Function FindFile$(fspec$)
Local string  DName$
Local integer n,Depth,NDir(20)
Do
  If ""<>Dir$(fspec$,FILE) Then
    FindFile$=Dir$(fspec$,FILE)
    Exit Function
  EndIf
  DName$=Dir$("*",DIR)
  For n=1 To NDir(Depth)
    DName$=Dir$()
  Next
  If DName$<>"" Then Inc NDir(Depth)
  If DName$<>"" Then
    Chdir DName$:Inc Depth
  Else
    If Depth=0 Then Exit Do
    Chdir "..":NDir(Depth)=0:Inc Depth,-1
  EndIf
Loop
FindFile$=""
End Function
'INPUT Line EDITOR --------------------------------
Function InputE$(inString$,maxLen As integer)
Local string  s$=inString$,k$ length 1
Local integer tLen=Len(s$),cPos=tLen
Local integer x=MM.Info(hPos),y=MM.Info(vPos)
Local integer delFlg,printFlg=1,ovrOn=1
If maxLen=0 Then maxLen=tLen
Do
If printFlg Then
  Print @(x,y);s$;" ";
  If cPos<tLen Then
    Print @(x+cPos*MM.Info(FONTWIDTH),y,2)Mid$(s$,cPos+1,1);
    If delFlg Then delFlg=0
  Else
    Print @(x+cPos*MM.Info(FONTWIDTH),y,2)" ";
    If delFlg Then delFlg=0:Print " ";Chr$(8);
  EndIf
  Print Chr$(8);
EndIf
printFlg=1:k$=Inkey$
Select Case Asc(k$)
Case 0
  printFlg=0
Case 8'BSpace
  If tLen>0 And cPos>0 Then
    s$=Left$(s$,cPos -1) +Mid$(s$,cPos+1)
    Inc cPos,-1:Inc tLen,-1:delFlg=1
  EndIf
Case 10,13'ENTER
  InputE$=s$
  Exit Function
Case 27'ESC
  InputE$=""
  'maxLen=-1
  'InputE$=inString$
  Exit Function
Case 32 To 126
  If cPos<tLen And ovrOn Then
     s$=Left$(s$,cPos) +k$ +Mid$(s$,cPos+2)
     Inc cPos
  ElseIf tLen<maxLen Then
     s$=Left$(s$,cPos) +k$ +Mid$(s$,cPos+1)
     Inc cPos:Inc tLen
  EndIf
Case 127'DEL
  If cPos <tLen Then
    s$=Left$(s$,cPos) +Mid$(s$,cPos+2)
    Inc tLen,-1:delFlg=1
 EndIf
Case 130'LEFT
  If cPos >0 Then Inc cPos,-1
Case 131'RIGHT
  If cPos <tLen Then Inc cPos
Case 132'INSERT
  ovrOn=ovrOn=0
Case 134'HOME
  cPos =0
Case 135'END
  cPos =tLen
End Select
Loop
End Function

'================================================
' MENU PROGRAMMS
'================================================
Sub Set_Time_And_Date
Local integer i,y,x
Color c(15),c(1)
CXCY(52,12,1):OpenWindow(" Set Time & Date ",cx,cy,52,12)
CXCY(4,2):Print "Time (HH:MM:SS)"
CXCY(4,4):Print "Date (DD-MM-YY)"
CXCY(4,6):Print "RTC GET TIME"
CXCY(4,8):Print "RTC SET TIME"
Do
x=cx+22:y=i*2+cy+2
If Timer>1000 Then Timer =0: CKey=1
If CKey Then
  Print @(x*FW,y*FH)"-->"
  Print @((cx+28)*FW,(cy+2)*FH,2)Time$;" ";
  Print @((cx+28)*FW,(cy+4)*FH,2)Date$;" ";
  Print " ";Day$(Date$);
  Print @((cx+28)*FW,(cy+6)*FH,2)"Get I2C RTC Time ";
  Print @((cx+28)*FW,(cy+8)*FH,2)"DD/MM/YYYY HH:MM ";
EndIf
CKey=Asc(Inkey$)
Select Case CKey
Case 0 'NOP
Case 13'ENTER
  Color c(14),c(0)
  Select Case i
  Case 0
    CXCY(28,2):TMP$=InputE$(Time$,9)
    On ERROR ignore: Time$=TMP$
  Case 1
    CXCY(28,4):TMP$=InputE$(Date$,19)
    On ERROR ignore: Date$=TMP$
  Case 2
    On ERROR ignore: RTC GETTIME
  Case 3
    CXCY(28,8):TMP$=InputE$("DD/MM/YYYY HH:MM",17)
    On ERROR ignore: RTC SETTIME TMP$
  End Select
  Color c(15),c(1)
  W_ERROR_MSG : If MM.Errno Then On ERROR CLEAR: Exit Sub
Case 128,136'Up
  Print @(x*FW,y*FH);"   ";
  If i>0  Then Inc i,-1
Case 129,137'Dn
  Print @(x*FW,y*FH);"   ";
  If i<3 Then Inc i,1
Case Else
  Exit Sub
End Select
Loop
End Sub
'------------------------------------------------
Sub Sort_Order
Local integer SO,x,y,i
If PSide Then
  SO=FLS(6,1):x=0
Else
  SO=FLS(6,0):x=PANW
EndIf
Color c(0),c(15)
OpenWindow("Sort:",x,PFLN-SOMAX,10,SOMAX+3)
Timer =0:x=x+2
Do
If CKey Then
  y=PFLN-SOMAX
  For i=0 To SOMAX
    Inc y
    If i=SO Then
      Print @(x*FW,y*FH,2)GetRecordFromData$("DATA_SORT",i+1);
    Else
      Print @(x*FW,y*FH)GetRecordFromData$("DATA_SORT",i+1);
    EndIf
  Next
EndIf
CKey=Asc(Inkey$)
Select Case CKey
Case 0
Case 128,131,136'Up
  Timer =0:Inc SO,-1:If SO<0 Then SO=SOMAX
Case 129,130,137'Dn
  Timer =0:Inc SO, 1:If SO>SOMAX Then SO=0
Case Else
  Exit Do
End Select
If Timer>10000 Then Exit Do
Loop
If PSide Then FLS(6,1)=SO Else FLS(6,0)=SO
End Sub
'------------------------------------------------
Sub ASCII_PicoMite_Font1_Table
Local integer row,col
Print @(0,((CVRES-32)\2)*FH);
Color c(15),c(1)
For col=0 To 31
  For row=1 To 7
    i=(32*row)+col
    Color c(15):Print "| ";
    If i<100 Then Print " ";
    Color c(7):Print i;"  ";
    Color c(14):Print Chr$(i);"  ";
  Next
  Color c(15):Print "  |"
Next
Color c(15),0
Do : Loop While Inkey$=""

End Sub
'================================================
' DATA OF PROGRAMM
'================================================
DATA_MENU_COMMANDS:
Data ".."
Data "Sort_Order"
Data "Set_Time_and_Date"
Data "ASCII_PicoMite_Font1_Table"
Data ""
DATA_SORT:
Data "UnSort","Name >","Name <","Date >","Date <"
Data "Size >","Size <","Extn >","Extn <"
DATA_FKeyMain:
Data "Help  ","Menu  ","View  ","Edit  ","Copy  ","RenMov","MkDir ","Delete","User  "
DATA_FKeyAlt1:
Data "Left  ","Right ","View2 ","Edit  ","X.SEND","X.RCVE","Find  ","      ","      "
DATA_FKeyAlt2:
Data "FILES ","      ","      ","      ","      ","      ","      ","      ","      "
DATA_FKeyZero:
Data "      ","      ","      ","      ","      ","      ","      ","      ","     "
DATA_HELP:
Data "File Manager  v1.70 for PicoMiteVGA/HDMI MMBasic Ver.> 6.00.01"
Data " "
Data "by Jatlov Vadim (c)2025         @javavi ( javavict@gmail.com )"
Data " "
Data "my thanks for help to @twofingers, @dddns, @Volhout."
Data " "
Data "-------------------------------------------------------------"
Data "[Arrows],[PgUp],[PgDn],[Home],[End] Keys - Navigation."
Data "[Tab]   Key - Switches between Left & Right panels."
Data "[~]     Key - File Sort Order Switch"
Data "[Shift]+[F3]  Keys - Changing Panel View."
Data "[F1] ... [F9] Keys - Main Conrol Functions."
Data "[Alt] or [BS] Keys - Switching to Alternate Conrol Functions."
Data "[Enter] Key - Entering a folder, Running a file."
Data "[Space] Key - Selecting files on the panel."
Data "[Pause] Key - Stop Playing music files."
Data "[<][>][Home][End][Del][BS][Insert] Keys for Input line editor."
Data "[Esc]   Key - Escape from input & Exit to command prompt."
Data " "
Data "[F1 ] This Help text window."
Data "[F2 ] Menu of build-in subprograms for expanding the functionality."
Data "[F3 ] Viewing text files, images, listen to music files, etc."
Data "[F4 ] Edit text, programm file (.. Create a New text file)."
Data "[F5 ] Copy one file or multiple selected files."
Data "[F6 ] Move one file or multiple selected files."
Data "[F7 ] Make a folfer with entered name."
Data "[F8 ] Delete one file or multiple selected files."
Data "[F9 ] User menu of castom commands to add frequenly used commands."
Data "[F10] Quiet Exit from the File Manager."
Data ""
