'#DEFINE "DBG ", "'"
#DEFINE "DBG ", ""
#MMDEBUG ON

OPTION BREAK 0
DBG OPTION BREAK 3


'Texter
CONST VERSION. = "0.02"


CONST MIN_VERSION.NC = 5.06

OPTION EXPLICIT
OPTION DEFAULT NONE
OPTION BASE 0

#INCLUDE "GRF.INC"
#INCLUDE "TUI.INC"

FONT.TUI = 1
DIM STRING CWD.T = MM.INFO$(PATH), dialog
CONST fnt = 1

FONT fnt
DIM INTEGER W.T, H.T, FH.T = MM.INFO(FONTHEIGHT), FW.T = MM.INFO(FONTWIDTH)
DIM INTEGER FhalfH.T = FH.T \ 2, FhalfW.T = FW.T \ 2
DIM INTEGER ASCII.T(255, 4), xxx, yyy

T.prepareAscii(fnt)
IF T.load(1) THEN
  
  PAGE COPY 1 TO 0
  IF GRF.blackWhite(1, 0, 0, W.T, H.T, 1, 2, 1) THEN
    GRF.saveBMP("DITHERED.BMP", 0, 0, W.T, H.T, 2)
    FOR yyy = 0 TO H.T - 1 STEP FH.T
      FOR xxx = 0 TO W.T - 1 STEP FW.T
        TEXT xxx, yyy, CHR$(T.getAscii(fnt, 0, xxx, yyy, 2)), "LT",fnt,,RGB(WHITE),RGB(NOTBLACK)
      NEXT xxx
    NEXT yyy
    GRF.saveBMP("ASCIImode0.BMP", 0, 0, W.T, H.T, 0)
    TUIwaitForKey
  
    FOR yyy = 0 TO H.T - 1 STEP FH.T
      FOR xxx = 0 TO W.T - 1 STEP FW.T
        TEXT xxx, yyy, CHR$(T.getAscii(fnt, 1, xxx, yyy, 2)), "LT",fnt,,RGB(WHITE),RGB(NOTBLACK)
      NEXT xxx
    NEXT yyy
    GRF.saveBMP("ASCIImode1.BMP", 0, 0, W.T, H.T, 0)
  ENDIF
  TUIwaitForKey
ENDIF
END

FUNCTION T.load(pg AS INTEGER) AS INTEGER

  LOCAL STRING filePath = TUIfileSelect(CWD.T, ".PNG,.JPG,.BMP,.GIF")
  T.load = 0
  IF filePath <> "" THEN
    LOCAL STRING info = GRF.getImgInfo(CWD.T + filePath)
    IF info <> "" THEN
      W.T = VAL(FIELD$(info, 1, ","))      
      H.T = VAL(FIELD$(info, 2, ","))
      IF W.T <= MM.HRES THEN
        IF H.T <= MM.VRES THEN
          PAGE WRITE 1
          CLS RGB(NOTBLACK)
          PAGE WRITE 0
          IF GRF.loadImg(CWD.T + filePath, 0, 0, pg, 1) THEN
            T.load = 1
          ELSE
            TUIwarning("SOURCE IMAGE LOAD", "Image couldn't be loaded")
          ENDIF
        ENDIF
      ENDIF      
    ENDIF
  ENDIF
END FUNCTION

SUB T.prepareAscii(f AS INTEGER)
  'prepare luma array ASCII.T(char, 4) for every char in font
  'ASCII.T(char, 0) = total luma, ASCII.T(char, 1-4) = luma in 4 parts of char

  LOCAL INTEGER ch, i, x, y, mx = 127, part

  IF f = 1 OR f = 4 THEN mx = 255
  PAGE WRITE 1
  CLS RGB(BLACK)
  FOR ch = 32 TO mx
    FOR i = 0 TO 4  
      ASCII.T(ch, i) = 0
    NEXT i
    TEXT 0, 0, CHR$(ch), "LT", f,,RGB(WHITE),RGB(BLACK)
    FOR y = 0 TO FH.T - 1
      FOR x = 0 TO FW.T - 1
        IF x < FhalfW.T THEN
          part = 1
        ELSE
          part = 2
        ENDIF
        IF y >= FhalfH.T THEN INC part, 2        
        IF GRF.getLuma(x, y, 1) > 127 THEN
          INC ASCII.T(ch, part)
        ENDIF
      NEXT x
    NEXT y
    FOR i = 1 TO 4
      INC ASCII.T(ch, 0), ASCII.T(ch, i)
    NEXT i
  NEXT ch
  PAGE WRITE 0
END SUB

FUNCTION T.getAscii(f AS INTEGER, m AS INTEGER, x AS INTEGER, y AS INTEGER, pg AS INTEGER) AS INTEGER
  'return BEST character from font f and mode m
  'mode 0 = whole character, 1 = character split to 4 parts

  LOCAL INTEGER xx, yy, i, j, l(4), mm = 1000000, mi = 32, mx = 127, part, tot
  
  IF f = 1 OR f = 4 THEN mx = 255
  IF m < 1 THEN
    FOR yy = y TO y + FH.T - 1
      FOR xx = x TO x + FW.T - 1
        IF GRF.getLuma(xx, yy, pg) > 127 THEN
          INC l(0)
        ENDIF
      NEXT xx
    NEXT yy
    FOR i = 32 TO mx
      IF ABS(ASCII.T(i, 0) - l(0)) < mm THEN
        mm = ABS(ASCII.T(i, 0) - l(0))
        mi = i
      ENDIF
    NEXT i
    T.getAscii = mi

  ELSE
    FOR yy = y TO y + FH.T - 1
      FOR xx = x TO x + FW.T - 1
        IF xx - x < FhalfW.T THEN
          part = 1
        ELSE
          part = 2
        ENDIF
        IF yy - y >= FhalfH.T THEN 
          INC part, 2
        ENDIF
        IF GRF.getLuma(xx, yy, pg) > 127 THEN
          INC l(part)
        ENDIF
      NEXT xx
    NEXT yy
    FOR i = 32 TO mx
      tot = 0
      FOR j = 1 TO 4
        INC tot, ABS(ASCII.T(i, j) - l(j))
      NEXT j
      IF tot < mm THEN
        mm = tot
        mi = i
      ENDIF
    NEXT i
    T.getAscii = mi

  ENDIF
END FUNCTION


