SetPin 20, 2 'Digital Input for SPI Out
SetPin 19, 8 'Digital Output for SPI In
SetPin 18, 8 'Digital Output for SPI Clk
SetPin 17, 8 'Digital output for Chip Select
SetPin 16, 9 'Open Collector Output for ECU
SetPin 10, 8 'Digital Output For LED
SetPin 1, 1 'Analog input from Knock Sensor

Option ERROR CONTINUE
Option VIDEO OFF
Option USB OFF

Dim IntTime(32)
Dim BandPass(64)
Dim Gain(64)
Dim SPIData(5)

PWM 262, 16    ' Int/Hold

I2CEN 100,100 ' Enable I2C
I2CAddr  = &H20        ' this is the 23017 I2C address
                       ' A2=A1=A0=0 <-> x100 000x
Dim TBL(16)         ' an array to hold table data
Dim C_LineStart(4)  ' an array to hold the start addresses for each line
C_Lines = 0     ' variable to hold the number of lines on the LCD
C_LineLength = 0  ' variable to hold the line length of the LCD

Buttons = &h0
PortAStatus = 0
PortBStatus = 0

RSCMDmask = &B00000000 ' Select Command register
RSDATmask = &B10000000 ' Select Data register
Emask = &B00100000 ' Enable
BlueLed = &B00000001 ' Blue Backlight

InitLCDVariables(16, 2) ' <<<<<<<<<<-------

Checkbuttons
If MM.I2C <> 0 Then
I2CDIS
NoLCD = 1
EndIf

GoSub ReadData
GoSub ReadFile


PreScaler=&B01000000 ' 4MHZ SDO Active
Channel=&B11100000 ' Channel 1
BandPassB=&B00000000 ' BandPass Center Frequency
GainB=&B10000000     ' Gain
IntTimeB=&B11000000  ' Intergaration Time
GoSub WriteSPI

If NoLcd = 1 GoTo Knock
GoSub Init23017
InitLCD
PrintLCD 1, "KnocK Detector"

CheckButtons
If GetBit(Buttons, 0) = 0 Then GoTo SysSetup

Menu:

CheckButtons
If GetBit(Buttons, 0) = 0 Then PrintLCD 2, "Select"
If GetBit(Buttons, 4) = 0 Then PrintLCD 2, "Left"
If GetBit(Buttons, 3) = 0 Then PrintLCD 2, "Up"
If GetBit(Buttons, 2) = 0 Then PrintLCD 2, "Down"
If GetBit(Buttons, 1) = 0 Then GoTo SysSetup
'If(Buttons And &B111111) = &B111111 Then PrintLCD 2, "      "
PrintLCD 2, Left$(Str$(Knock), 4)

Knock:

GoSub CheckKnock

'Print Knock
If Knock >= (3.1 * (ADC/(100-ADC))) Then
'PrintLCD 2, "KNOCK!!!!!!"
Pin(10)=1 ' LED On
Pause Sustain
Else
Pin(10) = 0 ' Knock LED Off
EndIf

If NoLCD = 1 Then GoTo knock
GoTo Menu


WriteSPI:

SPIData(1) = PreScaler
SPIData(2) = Channel Or Sensor
SPIData(3) = BandPassB Or Freq
SPIData(4) = GainB Or Gain
SpiData(5) = IntTimeB Or IntTime


SPI_ByteOut:
PWM Stop

For I = 1 To 5
Pin(17)=0
 Junk =  SPI(20, 19, 18, SPIData(I), , 1)     ' datapin datapout clock
Pause 50
Pin(17)=1
Pause 50
Next I

PWM 262, 16  ' Start PWM

Return

CheckKnock:
Do While Loopcount < 10
knock = knock + Pin(1)
Loopcount = Loopcount + 1
Loop
Loopcount = 0
knock = knock / 10
Return


SysSetup:
Pin(10) = 1 'LED on
PWM Stop


Do While GetBit(Buttons, 0) = 0
CheckButtons
Loop

 PrintLCD 1,  "Select Parameter"


Freq:

PrintLCD 2,  "Freq = "
Pause 100
CheckButtons
Do While GetBit(Buttons, 0) = 1
CheckButtons
PrintLCD 2, Str$(BandPass(Freq)), 7
If GetBit(Buttons, 3) = 0 Then Freq=Freq+1
If GetBit(Buttons, 2) = 0 Then Freq=Freq-1
If Freq <= 0 Then Freq = 0
If Freq >= 63 Then Freq = 63
Pause 250
Loop


Gain:

PrintLCD 2,  "Gain = "
Pause 100
CheckButtons
Do While GetBit(Buttons, 0) = 1
CheckButtons
PrintLCD 2, Str$(Gain(Gain)), 7
If GetBit(Buttons, 3) = 0 Then Gain=Gain-1
If GetBit(Buttons, 2) = 0 Then Gain=Gain+1
If Gain =< 0 Then Gain = 0
If Gain => 63 Then Gain = 63
Pause 250
Loop


IntTime:

PrintLCD 2,  "Int Time = "
Pause 100
CheckButtons
Do While GetBit(Buttons, 0) = 1
CheckButtons
PrintLCD 2, Str$(IntTime(IntTime)), 11
If GetBit(Buttons, 3) = 0 Then IntTime=IntTime+1
If GetBit(Buttons, 2) = 0 Then IntTime=IntTime-1
If IntTime =< 0 Then IntTime = 0
If IntTime => 31 Then IntTime =31
Pause 250
Loop


Sensor:
PrintLCD 2,  "Sensor # = "
Pause 100
Sensor = Sensor + 1
CheckButtons
Do While GetBit(Buttons, 0) = 1
CheckButtons
PrintLCD 2, Str$(Sensor), 11
If GetBit(Buttons, 3) = 0 Then Sensor = 2
If GetBit(Buttons, 2) = 0 Then Sensor = 1
If Sensor =< 1 Then Sensor = 1
If Sensor => 2 Then Sensor = 2

Pause 250
Loop
Sensor = Sensor -1

ADC:
PrintLCD 2,  "ADC % = "
Pause 100
CheckButtons
Do While GetBit(Buttons, 0) = 1
CheckButtons
PrintLCD 2, Str$(ADC), 8
If GetBit(Buttons, 3) = 0 Then ADC=ADC+1
If GetBit(Buttons, 2) = 0 Then ADC=ADC-1
If ADC =< 0 Then ADC = 0
If ADC => 100 Then ADC = 100
Pause 250
Loop

Sustain:
PrintLCD 2,  "Sustain = "
Pause 100
CheckButtons
Do While GetBit(Buttons, 0) = 1
CheckButtons
PrintLCD 2, Str$(Sustain), 10
If GetBit(Buttons, 3) = 0 Then Sustain= Sustain + 10
If GetBit(Buttons, 2) = 0 Then Sustain= Sustain - 10
If Sustain => 250 Then Sustain = 250
If Sustain =< 0 Then Sustain = 0
Pause 250
Loop


GoSub WriteFile
Pin(10) = 0 ' Turn LED Off

Pause 1500
Run "knock.bas"

End


'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Initialise the variables for this application
' (C_Prefix indicates constants).
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub InitLCDVariables(LCD_LineLength, LCD_Lines)

    C_LineLength = LCD_LineLength
    C_Lines = LCD_Lines

    C_LineStart(1) = 0        ' Start address for line 1
    C_LineStart(2) = 64       ' Start address for line 2
    C_LineStart(3) = 20       ' Start address for line 3
    C_LineStart(4) = 84       ' Start address for line 4

End Sub


'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Initialise the LCD hardware
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub InitLCD
    LCD_Nibble &B0011, 0, 5           ' reset
    LCD_Nibble &B0011, 0, 5           ' reset
    LCD_Nibble &B0011, 0, 5           ' reset
    LCD_Nibble &B0010, 0, 2           ' 4 bit mode
    LCD_Nibble &B101000, 0
    LCD_Nibble &B1100, 0   ' display on, cursor on
    LCD_Nibble &B0110, 0
    LCD_Nibble &B0001, 0, 2
End Sub


'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Display a line on the LCD
' argument #1 is the line to be used (1 to 4)
' argument #2 is the line to display (can be any length)
' Note: The text has to be padded out with spaces, otherwise
' 'odd' characters are displayed on the LCD.
' The code does the padding for you.
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub PrintLCD ( LineNumber, Line$, Posn)
  Local i, c, fillSpaces, fullLine$

  curPosn = Posn + 128 + C_LineStart(LineNumber)


 ' first, send the cursor position (in two nibbles)
     LCD_Nibble Int(curPosn), 0

  fillSpaces = C_LineLength - Len(Line$) ' is the line full?
  If fillSpaces > 0 Then
    fullLine$ = Line$ + Space$(fillSpaces)
  Else
    fullLine$ = Line$
  EndIf

  ' then send the text character by character (two nibbles per character)
  For i = 1 To C_LineLength
    c = Asc(Mid$(fullLine$, i, 1))
  LCD_Nibble c, 1

  Next i

End Sub

'Addafruit LCD Plate
'RS=GPB7 EN=GPB5
'D4 - D7 = GPB4-GPB1
'RW=GPB6

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Send the lower 4 bits (called a nibble) to the LCD
' argument #1 is the nibble to send
' argument #2 is 1 if data, 0 if command (default is data)
' argument #3 is delay after the data has been sent (default is zero)
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub LCD_Nibble (Data, Flag, Wait_mSec)
  If Flag = 0 Then rsbit = RSCMDmask
  If Flag = 1 Then rsbit = RSDATmask

   ' put MSB OUT 1st
    temp = (Data \ &B10000)
    temp = TBL(temp) Or rsbit
    If Bon = 1 Then temp = temp Or &B00000001 ' Blue Led
GoSub DirectSendCmd

    ' put LSB
    temp = Data And &H0F
    temp = TBL(temp) Or rsbit
    If Bon = 1 Then temp = temp Or &B00000001 ' Blue LED

DirectSendCmd:
    temp = temp Xor Emask             ' E=1
 I2CSEND i2caddr, 0, 2, &H19, temp    ' send to 23017
    temp = temp Xor Emask             ' E=0
 I2CSEND i2caddr, 0, 2, &H19, temp
Return

If Wait_mSec > 0 Then Pause Wait_mSec ' modified 30/1/2012. Restore to Wait_mSec when Pause 0 bug corrected.
End Sub

Sub CheckButtons
I2CRCV i2caddr, 0, 1, Buttons, 1, &H09
End Sub


Sub SetRGB ( GLed, RLed, BLed )

I2CRCV i2caddr, 0, 1, PortAStatus, 1, &H19
I2CRCV i2caddr, 0, 1, PortBStatus, 1, &H09

If Gled = 0 Then PortAStatus = PortAStatus And &B01111111
If Gled = 1 Then PortAStatus = PortAStatus Or &B10000000

If Rled = 0 Then PortAStatus = PortAStatus And &B10111111
If Rled = 1 Then PortAStatus = PortAStatus Or &B01000000

If Bled = 0 Then PortBStatus = PortBStatus And &B11111110
If Bled = 1 Then PortBStatus = PortBStatus Or &B00000001
If Bled = 1 Then Bon = 1

I2CSEND i2caddr, 0, 2, &H09, PortAStatus    ' send to 23017
I2CSEND i2caddr, 0, 2, &H19, PortBStatus    ' send to 23017


End Sub


Function GetBit(byte_in, bit)
  ' Return the value (0/1) of a specified bit in a given byte
    GetBit = (byte_in And (2 ^ bit)) > 0
End Function

Sub SetBit(byte_in, bit)
  byte_in = byte_in Or (2 ^ bit)
End Sub


Init23017:

I2CSEND i2caddr, 0, 2, &H0A, &B10100000
I2CSEND i2caddr, 0, 2, &H0B, &B10100000

I2CSEND i2caddr, 0, 2, &H05, &B10100000
I2CSEND i2caddr, 0, 2, &H00, &B00111111
I2CSEND i2caddr, 0, 2, &H06, &B00111111

I2CSEND i2caddr, 0, 2, &H10, &B00000000
I2CSEND i2caddr, 0, 2, &H19, &B00000000

Return

Writefile:
PrintLCD 1, "Saving....."
PrintLCD 2, "                "

Open "A:Saved.dat" For Output As #1
 For I = 1 To 6
Print #1, Freq;",";Gain;","IntTime;",";Sensor;","ADC;",";Sustain;","
  Next I
Close #1
Pause 200
Return

ReadFile:
Open "A:Saved.dat" For INPUT As #1
If MM.Errno = 6 Then
WriteFile
EndIf

For I = 1 To 6
    Input #1, Freq;Gain;IntTime;Sensor;ADC;Sustain;
Next I
Close #1

Return

ReadData:

For I = 0 To 31
Read IntTime(I)
Next I

For I = 32 To 95
Read  BandPass(I - 32)
Next I

For I = 96 To 159
Read Gain(I - 96)
Next I

For I = 160 To 175
 Read TBL(I-160)
Next I

Return

'Intergrator Time
Data 40,45,50,55,60,65,70,75,80,90,100,110,120,130,140,150
Data 160,180,200,220,240,260,280,300,320,360,400,440,480,520,560,600

'BandPass Frequency
Data 1.22,1.26,1.31,1.35,1.4,1.45,1.51,1.57,1.63,1.71,1.78,1.87,1.96,2.07
Data 2.18,2.31,2.46,2.54,2.62,2.71,2.81,2.92,3.03,3.15,3.28,3.43,3.59,3.76
Data 3.95,4.16,4.39,4.66,4.95,5.12,5.29,5.48,5.68,5.9,6.12,6.37,6.64,6.94
Data 7.27,7.63,8.02,8.46,8.95,9.5,10.12,10.46,10.83,11.22,11.65,12.1,12.6
Data 13.14,13.72,14.36,15.07,15.84,16.71,17.67,18.76,19.98

' Gain
Data 2.0,1.882,1.778,1.684,1.6,1.523,1.455,1.391,1.333,1.28,1.231,1.185,1.143
Data 1.063,1,0.944,0.895,0.85,0.81,0.773,0.739,0.708,0.68,0.654,0.63,0.607
Data 0.586,0.567,0.548,0.5,0.471,0.444,0.421,0.4,0.381,0.364,0.348,0.333
Data 0.32,0.308,0.296,0.286,0.276,0.267,0.258,0.25,0.236,0.222,0.211,0.2
Data 0.19,0.182,0.174,0.167,0.16,0.154,0.148,0.143,0.138,0.133,0.129,0.125
Data 0.118,0.111


'LCD Data
Data &B00000000,&B00010000,&B00001000,&B00011000,&B00000100,&B00010100
Data &B00001100,&B00011100,&B00000010,&B00010010,&B00001010,&B00011010
Data &B00000110,&B00010110,&B00001110,&B00011110
