'Jman's code for the FM3164/FM31256
'No alarms or Calibration yet
'Calculation to set Day of the week  (Thanks to TZ Advantage)
'Goto settime from the console will set the RTC with the current
'time and date
' Still to do
' Calibration setup
' Store Day of week data in Fram
' Please NOTE this is untested as of 5/10/2014 "DD/MM/YY"


' I2C RTC based On FM3126

' GoTo Settime    ' Uncomment to set the time

Dim RTCbuff(7)
Dim Days$(7)
GoSub Days

I2caddr = &h68 ' FM31256 I2C address
I2C open 400,100 ' Enable I2C
I2C write I2caddr, 0, 2, &H00 ,&B1  ' Copy time to registers
I2C write I2caddr, 0, 1, &H02       ' Set Start Location
I2C Read I2caddr, 0, 7, RTCbuff(0)  ' Read Time
I2C write I2caddr, 0, 2, &H00, &B0  ' Reset read time bit for next read
I2C Close


BCDTEMP = RTCBuff(0)
BCDtoDec BCDTEMP
sec$ = Str$(decimal)

BCDTEMP = RTCBuff(1)
BCDtoDec BCDTEMP
min$ = Str$(decimal)

BCDTEMP = RTCBuff(2)
BCDtoDec BCDTEMP
hours$ = Str$(decimal)

BCDTEMP = RTCBuff(3)
BCDtoDec BCDTEMP
DayOfWeek = decimal


BCDTEMP = RTCBuff(4)
BCDtoDec BCDTEMP
Dat$ = Str$(decimal)

bcdtemp = rtcbuff(5)
BCDtoDec BCDTEMP
month$ = Str$(decimal)

bcdtemp = rtcbuff(6)
BCDtoDec BCDTEMP
year$ = Str$(decimal + 2000 )

t$ = hours$+":"+min$+":"+sec$
D$ = Dat$+"/"+month$+"/"+year$
Time$ = T$
Date$ = D$

Print "Time has been set to ";Time$
Print "Date has been set to ";Date$
Print "Today is ";Days$(DayOfWeek)

End

'Convert to Decimal
Sub BCDtoDec (BCDTEMP)
Decimal = Fix(BCDTemp / 16) * 10
Decimal = Decimal + (BCDTEMP And &hF)
End Sub

Days:
 For I = 0 To 6
  Read Days$(I)
 Next I
Return

Data  "Sunday"
Data  "Monday"
Data  "Tuesday"
Data  "Wednesday"
Data  "Thursday"
Data  "Friday"
Data  "Saturday"

SetTime:        ' Use this t set the RTC time
' Get time from time$ and date$
tempdec = Val(Left$(Time$, 2))
DECtoBCD TempDec
hours = BCD

tempdec = Val(Mid$(Time$, 4, 2))
DECtoBCD TempDec
minutes = BCD

tempdec = Val(Right$(Time$, 2))
DECtoBCD TempDec
seconds = BCD

tempdec = Val(Left$(Date$, 2))
DECtoBCD TempDec
day = BCD

tempdec = Val(Mid$(Date$, 4, 2))
DECtoBCD TempDec
month = BCD

tempdec = (Val(Right$(Date$, 4)) - 2000)
DECtoBCD TempDec
year = BCD

DayOfWeek

i2caddr = &h68 ' FM31256 I2C address
I2C open 400,100 ' Enable I2C

I2C write I2Caddr, 0, 2, &H09, &H0     ' Clear Flags
I2C write I2Caddr, 0, 2, &H01, &B0     ' Start Oscillators
I2C write I2caddr, 0, 2, &H00, &B11    ' Freeze clock
I2C write I2caddr, 0, 8, &H02, seconds,minutes,hours,dow,day,month,year 'Load registers
I2C write I2caddr, 0, 2, &H00, &H00    ' Set the time
I2C Close

If MM.I2C = 0 Then
Print "I2C Data write success"
Print "RTC has been set to ";Time$;" ";Date$
Else
Print "I2C Write error"
EndIf

End

'Calculate Day Of Week TZAdvantage's DOW Calculation
Sub DayOfWeek
  A = Int((14-Val(Mid$(Date$,4,2)))/12)
  M = Val(Mid$(Date$,4,2)) + 12*a - 2
  Y = Val(Mid$(Date$,7,4)) -a
  D = Val(Mid$(Date$,1,2))
Dow=(D+Y+Int(Y/4)-Int(y/100)+Int(Y/400)+Int(31*M/12)) Mod 7

End Sub

' Convert to BCD
Sub DECtoBCD TempDec
BCD = Fix(tempdec / 10) * 16
BCD = BCD Or ((tempdec / 10) - (Fix(tempdec / 10))) * 10
Return                                                                                                