'Write array to 24C32 EEprom
'John Gerrard
' Standard Font Array Size = 816


CData=824         'Number of items in the array
S=Int(Cdata/256)  'Number of 256 blocks
Dim Codes(CData)  'Dimension array
Dim Code$(7)

IT=1
GoSub Codes       'Read array


WriteEE:      'Rem WRITE TO AT24C32

I2CADDR=&H50      'Address of 24c32
I2C Open 100,100 'ENABLE I2C
BC=&HFF           'Complete block

  For J=&h0 To S                'Number of blocks to write
If J=S Then BC = CData-(S*256)  'Full block or remainder
 For I=&h0 To BC


  I2C Write I2CADDR, 0,3,J,I,Codes(Cnt) 'Write to EE

Pause 10                        'Small delay for EE
 Cnt = cnt + 1                  'Increment array counter
 Next i: Next j

I2C Write I2CADDR, 0,4,&Hf,&HFE,BC,S  'Write item count to EE
Pause 10                              'Small delay for EE
I2C Close


ReadTotal:                            ' To make sure its ok

I2C Open 100,100 'ENABLE I2C
I2C Write I2CADDR, 0,2,&Hf,&HFE       'EEprom location
I2C Read I2CADDR, 0,1,C
I2C Read I2CADDR, 0,1,D

 Print "EEProm HAS BEEN WRITTEN with "; (D*256)+C ;"  Codes";

 End


Codes:
Read cnt
Codes(IT) = cnt

 For I = 1 To 7
   Read Code$(I)
   Codes(IT+I)=Val("&b"+Code$(I))
 Next I

IT = IT + 8
If IT < 824 Then GoTo Codes

cnt = 0
i = 0
j = 0

Return

'=================================================================
  '------------------------------------------------------------
  '**** Font Table
  '**** !!!! Warning - This is a proportional spaced font!!!
  '****                Not all characters are the same width.  The number
  '****                at the begining of each line is to aid the proper
  '****                spacing of characters
  Data 6, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000     '32 - space
  Data 4, 00000000, 10111111, 00000000, 00000000, 00000000, 00000000, 00000000     '33 - !
  Data 6, 00000000, 00000111, 00000000, 00000111, 00000000, 00000000, 00000000     '34 - "
  Data 6, 00100100, 11111111, 00100100, 11111111, 00100100, 00000000, 00000000     '35 - #
  Data 6, 01000100, 11001011, 01010010, 11010011, 00100010, 00000000, 00000000     '36 - $
  Data 6, 10000011, 01100011, 00011000, 11000110, 11000001, 00000000, 00000000     '37 - %
  Data 6, 01100010, 10010101, 10001001, 01010001, 10100010, 00000000, 00000000     '38 - &
  Data 4, 00000000, 00000100, 00000011, 00000000, 00000000, 00000000, 00000000     '39 - '
  Data 6, 00000000, 00000000, 00111100, 01000010, 10000001, 00000000, 00000000     '40 - (
  Data 6, 10000001, 01000010, 00111100, 00000000, 00000000, 00000000, 00000000     '41 - )
  Data 6, 00101010, 00011100, 01111111, 00011100, 00101010, 00000000, 00000000     '42 - *
  Data 6, 00001000, 00001000, 00111110, 00001000, 00001000, 00000000, 00000000     '43 - +
  Data 5, 00000000, 10000000, 01100000, 00000000, 00000000, 00000000, 00000000     '44 - ,
  Data 6, 00001000, 00001000, 00001000, 00001000, 00001000, 00000000, 00000000     '45 - -
  Data 2, 10000000, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000     '46 - .
  Data 6, 10000000, 01100000, 00011000, 00000110, 00000001, 00000000, 00000000     '47 - /
  Data 6, 01111110, 10100001, 10011001, 10000101, 01111110, 00000000, 00000000     '48 - 0
  Data 6, 10000000, 10000010, 11111111, 10000000, 10000000, 00000000, 00000000     '49 - 1
  Data 6, 11000010, 10100001, 10010001, 10001001, 10000110, 00000000, 00000000     '50 - 2
  Data 6, 01000010, 10000001, 10001001, 10001001, 01110110, 00000000, 00000000     '51 - 3
  Data 6, 00011111, 00010000, 00010000, 11111111, 00010000, 00000000, 00000000     '52 - 4
  Data 6, 10001111, 10001001, 10001001, 10001001, 01110001, 00000000, 00000000     '53 - 5
  Data 6, 01111110, 10001001, 10001001, 10001001, 01110010, 00000000, 00000000     '54 - 6
  Data 6, 00000001, 11100001, 00010001, 00001001, 00000111, 00000000, 00000000     '55 - 7
  Data 6, 01110110, 10001001, 10001001, 10001001, 01110110, 00000000, 00000000     '56 - 8
  Data 6, 01000110, 10001001, 10001001, 10001001, 01111110, 00000000, 00000000     '57 - 9
  Data 2, 00100100, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000     '58 - :
  Data 4, 00000000, 10000000, 01100100, 00000000, 00000000, 00000000, 00000000     '59 - ;
  Data 6, 00000000, 00010000, 00101000, 01000100, 10000010, 00000000, 00000000     '60 - <
  Data 6, 00010100, 00010100, 00010100, 00010100, 00010100, 00000000, 00000000     '61 - =
  Data 6, 00000000, 10000010, 01000100, 00101000, 00010000, 00000000, 00000000     '62 - >
  Data 6, 00000010, 00000001, 10110001, 00001001, 00000110, 00000000, 00000000     '63 - ?
  Data 6, 01111110, 10000001, 10001101, 10010101, 10001110, 00000000, 00000000     '64 - @
  Data 6, 11111100, 00010010, 00010001, 00010010, 11111100, 00000000, 00000000     '65 - A
  Data 6, 11111111, 10001001, 10001001, 10001001, 01110110, 00000000, 00000000     '66 - B
  Data 6, 01111110, 10000001, 10000001, 10000001, 01000010, 00000000, 00000000     '67 - C
  Data 6, 11111111, 10000001, 10000001, 01000010, 00111100, 00000000, 00000000     '68 - D
  Data 6, 11111111, 10001001, 10001001, 10001001, 10000001, 00000000, 00000000     '69 - E
  Data 6, 11111111, 00001001, 00001001, 00001001, 00000001, 00000000, 00000000     '70 - F
  Data 6, 01111110, 10000001, 10000001, 10010001, 01110010, 00000000, 00000000     '71 - G
  Data 6, 11111111, 00001000, 00001000, 00001000, 11111111, 00000000, 00000000     '72 - H
  Data 6, 10000001, 10000001, 11111111, 10000001, 10000001, 00000000, 00000000     '73 - I
  Data 6, 01100000, 10000000, 10000000, 10000000, 01111111, 00000000, 00000000     '74 - J
  Data 6, 11111111, 00011000, 00100100, 01000010, 10000001, 00000000, 00000000     '75 - K
  Data 6, 11111111, 10000000, 10000000, 10000000, 10000000, 00000000, 00000000     '76 - L
  Data 6, 11111111, 00000010, 00000100, 00000010, 11111111, 00000000, 00000000     '77 - M
  Data 6, 11111111, 00000110, 00011000, 01100000, 11111111, 00000000, 00000000     '78 - N
  Data 6, 01111110, 10000001, 10000001, 10000001, 01111110, 00000000, 00000000    '79 - O
  Data 6, 11111111, 00010001, 00010001, 00010001, 00001110, 00000000, 00000000     '80 - P
  Data 6, 01111110, 10000001, 10100001, 01000001, 10111110, 00000000, 00000000     '81 - Q
  Data 6, 11111111, 00010001, 00110001, 01010001, 10001110, 00000000, 00000000     '82 - R
  Data 6, 01000110, 10001001, 10001001, 10001001, 01110010, 00000000, 00000000    '83 - S
  Data 6, 00000001, 00000001, 11111111, 00000001, 00000001, 00000000, 00000000     '84 - T
  Data 6, 01111111, 10000000, 10000000, 10000000, 01111111, 00000000, 00000000     '85 - U
  Data 6, 00111111, 01000000, 10000000, 01000000, 00111111, 00000000, 00000000    '86 - V
  Data 6, 01111111, 10000000, 01100000, 10000000, 01111111, 00000000, 00000000     '87 - W
  Data 6, 11000011, 00100100, 00011000, 00100100, 11000011, 00000000, 00000000     '88 - X
  Data 6, 00000111, 00001000, 11110000, 00001000, 00000111, 00000000, 00000000     '89 - Y
  Data 6, 11000001, 10100001, 10011001, 10000101, 10000011, 00000000, 00000000     '90 - Z
  Data 6, 00000000, 00000000, 11111111, 10000001, 10000001, 00000000, 00000000     '91 - [
  Data 6, 00000001, 00000110, 00011000, 01100000, 10000000, 00000000, 00000000     '92 - \
  Data 6, 10000001, 10000001, 11111111, 00000000, 00000000, 00000000, 00000000     '93 - ]
  Data 6, 00000100, 00000010, 00000001, 00000010, 00000100, 00000000, 00000000     '94 - ^
  Data 6, 10000000, 10000000, 10000000, 10000000, 10000000, 00000000, 00000000     '95 - _
  Data 4, 00000000, 00000011, 00000100, 00000000, 00000000, 00000000, 00000000     '96 - `
  Data 6, 01000000, 10100100, 10100100, 10100100, 11111000, 00000000, 00000000     '97 - a
  Data 6, 11111111, 10001000, 10001000, 10001000, 01110000, 00000000, 00000000     '98 - b
  Data 6, 01111000, 10000100, 10000100, 10000100, 01001000, 00000000, 00000000    '99 - c
  Data 6, 01110000, 10001000, 10001000, 10001000, 11111111, 00000000, 00000000     '100 - d
  Data 6, 01111000, 10010100, 10010100, 10010100, 00011000, 00000000, 00000000     '101 - e
  Data 6, 00010000, 11111110, 00010001, 00000001, 00000010, 00000000, 00000000     '102 - f
  Data 6, 00011000, 10100100, 10100100, 10100100, 01111000, 00000000, 00000000     '103 - g
  Data 6, 11111111, 00010000, 00001000, 00001000, 11110000, 00000000, 00000000     '104 - h
  Data 4, 10000000, 11111010, 10000000, 00000000, 00000000, 00000000, 00000000     '105 - i
  Data 6, 01000000, 10000000, 10000000, 10000000, 01111010, 00000000, 00000000     '106 - j
  Data 6, 11111110, 00010000, 00101000, 01000100, 10000000, 00000000, 00000000    '107 - k
  Data 4, 10000010, 11111110, 10000000, 00000000, 00000000, 00000000, 00000000     '108 - l
  Data 6, 11111000, 00000100, 11111000, 00000100, 11111000, 00000000, 00000000     '109 - m
  Data 6, 11111000, 00000100, 00000100, 00000100, 11111000, 00000000, 00000000    '110 - n
  Data 6, 01111000, 10000100, 10000100, 10000100, 01111000, 00000000, 00000000     '111 - o
  Data 6, 11111100, 00100100, 00100100, 00100100, 00011000, 00000000, 00000000     '112 - p
  Data 6, 00011000, 00100100, 00100100, 01111100, 10000000, 00000000, 00000000     '113 - q
  Data 6, 11111100, 00001000, 00000100, 00000100, 00001000, 00000000, 00000000     '114 - r
  Data 6, 10001000, 10010100, 10010100, 10010100, 01100100, 00000000, 00000000     '115 - s
  Data 6, 00000100, 00000100, 01111111, 10000100, 01000100, 00000000, 00000000     '116 - t
  Data 6, 01111100, 10000000, 10000000, 10000000, 01111100, 00000000, 00000000     '117 - u
  Data 6, 00111100, 01000000, 10000000, 01000000, 00111100, 00000000, 00000000     '118 - v
  Data 6, 01111100, 10000000, 01000000, 10000000, 01111100, 00000000, 00000000     '119 - w
  Data 6, 10000100, 01001000, 00110000, 01001000, 10000100, 00000000, 00000000     '120 - x
  Data 6, 00011100, 10100000, 10100000, 10100000, 01111100, 00000000, 00000000     '121 - y
  Data 6, 10000100, 11000100, 10100100, 10010100, 10001100, 00000000, 00000000     '122 - z
  Data 6, 00000000, 00000000, 00001000, 00110110, 01000001, 00000000, 00000000     '123 - {
  Data 6, 00000000, 00000000, 11111111, 00000000, 00000000, 00000000, 00000000     '124 - |
  Data 6, 01000001, 00110110, 00001000, 00000000, 00000000, 00000000, 00000000     '125 - }
  Data 6, 00000110, 00000001, 00000010, 00000100, 00000011, 00000000, 00000000     '126 - ~
  Data 6, 00000110, 00001001, 00001001, 00000110, 00000000, 00000000, 00000000     '127 - degree
  Data 6, 00001111, 00000101, 00000001, 00000000, 00000000, 00000000, 00000000     '128 - mini F
  Data 6, 00001111, 00001001, 00001001, 00000000, 00000000, 00000000, 00000000     '129 - mini C
  Data 4, 00011110, 00000101, 00011110, 00000000, 00000000, 00000000, 00000000     '130 - mini A
  Data 4, 11110000, 01010000, 01110000, 00000000, 00000000, 00000000, 00000000     '131 - mini P
  Data 4, 00000000, 00000010, 00000101, 00000010, 00000000, 00000000, 00000000     '132 - Alarm1 (part1)
  Data 4, 00000000, 00000101, 00000010, 00000101, 00000000, 00000000, 00000000     '133 - Alarm2 (part2)
  Data 4, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000     '134 - small space

'============================================================================================                                                                                                    