'  ===========================================================
  '*      MAX7219 LED DISPLAY for 28pin Mite 150 or 170     *
  '===========================================================
  '
  '  See message threads which inspired this program:
  '  http://www.thebackshed.com/forum/forum_posts.asp?TID=4861
  '  http://www.thebackshed.com/forum/forum_posts.asp?TID=6685
  '
  '  Also see: http://www.thebackshed.com/forum/forum_posts.asp?TID=7057&KW
  '            TassyJim's Data logger program for enabling the PCF8563 clock
  '            interupt output at one second intervals

'Notes:
  '  - Load data to ALL LED modules before pulsing the CS line

  CPU 48 'Set maximum speed for a MicroMite-150
         '!!!! The values for the govenor variable needs to be recalcuated  !!!!
         '!!!! if the CPU speed is changed.                                 !!!!

SetTick (60*30)*1000, GetRTC 'Read Time @ 30 minutes intverals

  'Set RTC Clock using current Micromite time
'  thetime$ = Time$
'  thedate$ = Date$
'  yr = Val(Right$(thedate$,2))
'  mth = Val(Mid$(thedate$,4,2))
'  day = Val(Left$(thedate$,2))
'  hr = Val(Left$(thetime$,2))
'  mn = Val(Mid$(thetime$,4,2))
'  sc = Val(Right$(thetime$,2))
'  RTC Settime yr, mth, day, hr, mn, sc
 RTC Gettime  'Comment this out if not using a supported RTC chip

  I2CADDR = &H50          'Address of EEprom
  I2C Open 400,100                'ENABLE I2C

  'SPI PINS
  SPI Open 5000000, 3, 16
  'pin 3 is SPI Out
  'pin 25 is SPI Clock
  'Pin 14 is SPI In, not needed for this application
  PLOAD=26  'pin 26  is used to pulse the CS line loading data into the MAX7219 chips
  SetPin PLOAD,Dout


  MaxLEDs = 5 ' Total # of 8x8 Matrix Modules Installed (Max allowed 31)
  maxbytes = 1530 ' Total number of bytes allowed to hold the entire message
                  ' A 255 char message with 6 btyes per char (255*6 = 1530)
  Sptr = 1 'Pointer for start of buffer
  Eptr = 1 'Pointer for end of buffer
  Cptr = 1 'Pointer for current place in the buffer
  military = 1  '0 = 12 hour time, 1 = 24 hour time

  Dim digi(8), clkcol(8,2), ASCIIptr(150,2), govenor(6)
  Dim MsgData(maxbytes), MsgData2(MaxLEDs*8), MsgData3(MaxLEDs*8), ShiftL(8), ShiftR(8)
  '  Dim ShiftBuffer(MaxLEDs*8)

  'Load data for clock digit positions and sizes
  For i = 1 To 8
    For j = 1 To 2
      Read clkcol(i,j)
    Next j
  Next i
  Data 1, 6, 7, 6, 13, 2, 15, 6, 21, 6, 27, 2, 29, 6, 35, 6  'clock character positionw and sizes

  'Divider values for a 8 bit left shift
  For i = 1 To 8
    Read ShiftL(i)
  Next i
  Data 128, 64, 32, 16, 8, 4, 2, 1

  'Divider values for a 8 bit right shift
  For i = 1 To 8
    Read ShiftR(i)
  Next i
  Data 2, 4, 8, 16, 32, 64, 128, 256


  'The govenor variable is used to compensate for the different scroll rates.
  'Scrolling 6 digits takes longer that scrolling just one.  At 48MHz it takes
  'about 32ms longer to scroll two digits than just one digit, and scrolling
  '6 digits takes about 160ms longer than one digit.  To insure take the scroll
  'rate remanins constant a total of 160ms needs to be added to a single digit
  'scroll.  Therefore one eighth of 160ms (20ms) needs to be added to each step
  'of the scroll.  Two digits scrolling needs an adjustment of 16ms between each step
  '128ms / 8 = 16ms.  When all 6 digits are scrolling, no delay is needed.
  For i = 1 To 6
    Read govenor(i)
  Next i
  Data 19, 16, 12, 8, 4, 0

  '** Load Font Table data

  '----------------------MAIN----------------------------

  M7219_INIT   'Initialize modules
  ERASE_ALL    'Clear displays
  msg$ = "  --MicroMite Powered Clock--   "

  CharToBits    'Convert ASCII characters into bit patterns
 For Cptr = 1 To Eptr - (8*MaxLEDs)
    Show_Text
    Pause 75
  Next Cptr
  Pause 500

SmallScroll:
 msg$="       "+Left$(Time$,5)+"   "
 CharToBits
  For Cptr = 1 To Eptr - (8*MaxLEDs)
     Show_Text
     Pause 125
  Next Cptr
 Pause 50
' GoTo SmallScroll    ' Rem this for normal display


 'Preliminary setup for clock display... Makes for a cool looking startup
 oldtime$ = "  :  :   "    'non scrolling part of the clock display
 msg$ = oldtime$
 CharToBits
 Show_Text


  'Gather clock info and display the time... endless loop
Clock:
'  RTC Gettime  'Comment this out if not using a supported RTC chip
  'copy old bit pattern to use for vertical scroll
  For i = Sptr To (MaxLEDs*8)
    MsgData2(i) = MsgData(i)
    MsgData3(i) = MsgData(i)
  Next i
  'Read time and parse it for display
  time1$=Time$
  If military = 1 Then
    LH$ = Left$(time1$,1)
    RH$ = Mid$(time1$,2,1)
    If LH$ = "0" Then LH$ = " " ' eliminate extra leading zero if exists
   Else
    tmp = Val(Left$(time1$,2))
    If tmp > 12 Then tmp = tmp - 12
    If tmp = 0 Then tmp = 12
    RH$ = Right$(Str$(tmp),1)
    If tmp > 9 Then
      LH$ = "1"
     Else
      LH$ = " "
    EndIf
  EndIf
  LM$ = Mid$(time1$,4,1)
  RM$ = Mid$(time1$,5,1)
  LS$ = Mid$(time1$,7,1)
  RS$ = Mid$(time1$,8,1)
  msg$ = LH$ + RH$ + ":" + LM$ + RM$ +":" + LS$ + RS$ ' + Chr$(134)
  CharToBits
'  timer = 0      'reset timer for timing the scrolling of the digits
  Show_Time
'  Print timer    'show how long it took to update the display  (used to calculate govenor() variable)
  While time1$ = Time$ : Wend  'wait for time to change
  oldtime$ = msg$ 'save last time to displayed, use to find which digits need to be updated
  GoTo Clock



  '=====================================================
Sub M7219_INIT
  Local i
  For i = 1 To MaxLEDs
    AA=SPI(&H0C00): Pulse PLOAD, 0.1 'SHUTDOWN
    AA=SPI(&H0900): Pulse PLOAD, 0.1 'BCD DECODE DIGITS  00 = NO DECODE, FF = DECODE ALL
    AA=SPI(&H0A02): Pulse PLOAD, 0.1 'BRIGHTNESS 0 TO F
    AA=SPI(&H0B07): Pulse PLOAD, 0.1 '8 DIGITS
    AA=SPI(&H0F00): Pulse PLOAD, 0.1 'TEST OFF
    AA=SPI(&H0C01): Pulse PLOAD, 0.1 'RUN
  Next i
End Sub


  '--------------------------------------------------------------
Sub ERASE_ALL
  Local I, AA, J
  For I=1 To 8
    For J =1 To MaxLEDs
      AA=SPI(I*256+&H00): Pulse PLOAD,1
    Next J
  Next I
End Sub

  '--------------------------------------------------------------
  '*** Assemble string to bit data
Sub CharToBits
  Local i, j, k, tmp
  '**Reset ring buffer
'  For i=1 To maxbytes
'    MsgData(i) = 0
'  Next i
  Sptr = 1 'Start of ring buffer
  Eptr = 0 'End of ring buffer
  Cptr = 1 'Current place in the ring buffer
  'TotalLen = 0
  '*** Copy character bits into MsgData array


  GetMsgData  'Use I2C to get font

  'add extra bits for and even multiple of 8 for LED Matrix data
  tmp = Eptr Mod 8
  If tmp <> 0 Then
    tmp = 8 - tmp
    For k = 1 To tmp
      Eptr = Eptr + 1
      MsgData(Eptr) = 0
    Next k
  EndIf
  'Be sure there is at least enough data for all the LED matrix modules
  If (8*MaxLEDs) > (Eptr) Then
    tmp = (8*MaxLEDs) - (Eptr)
    For k = 1 To tmp
      Eptr = Eptr + 1
      MsgData(Eptr) = 0
    Next k
  EndIf
End Sub

  '--------------------------------------------------------------
Sub Show_Text
  Local i, j, k, Cptr2
  Cptr2  = Cptr
  For i = 1 To 8
    For j=Cptr2 To (MaxLEDs*8)+ Cptr-1 Step 8
      AA=SPI(i*256+MsgData(j))' print MsgData()
    Next j
    Pulse PLOAD,0.1
    Cptr2 = Cptr2 + 1
  Next i
End Sub

  '--------------------------------------------------------------
Sub Show_Time
  Local i, j, k, m, dc  'do not make k, m  Local here
  dc = 0
  For i = 1 To 8
    If Mid$(msg$, i,1) <> Mid$(oldtime$,i,1) Then  ' what digit changed?
      digi(i) = 1
      dc = dc + 1
     Else
      digi(i) = 0 'reset back to 0
    EndIf
  Next i
    ' Prepare data for bit shifting to vertical scroll a character up or down
  For i = 1 To 8
    If digi(i) = 1 Then
      If i = 1 Or i = 4 Or i = 7 Then
        For j = clkcol(i,1) To clkcol(i,1) + clkcol(i,2) - 1
          MsgData3(j) = (256*MsgData(j)) + MsgData2(j)
        Next j
       Else
        If i = 2 Or i = 5 Or i = 8 Then
          For j = clkcol(i,1) To clkcol(i,1) + clkcol(i,2) - 1
            MsgData3(j) = (256*MsgData2(j)) + MsgData(j)
          Next j
        EndIf
      EndIf
    EndIf
  Next i
  For k = 1 To 8
    For m = 1 To 8
      If digi(m) = 1 Then ShiftIt(k,m)
    Next m
    Cptr2  = Cptr
    For i = 1 To 8
      For j=Cptr2 To (MaxLEDs*8)+ Cptr-1 Step 8
        AA=SPI(i*256+MsgData(j))' print MsgData()
      Next j
      Pulse PLOAD,0.1
      Cptr2 = Cptr2 + 1
    Next i
    Pause govenor(dc) 'a variable delay so all digits scroll evenly
  Next k
End Sub


 '------------------------------------------------------------------

 ' Shift data Left or Right for scrolling of numbers up or down
Sub ShiftIt(z,m)
  Local i
  If m = 1 Or m = 4 Or m = 7 Then
    For i = clkcol(m,1) To clkcol(m,1) + clkcol(m,2) - 2 'for clock, only 5 of 6 columns need shifting
      MsgData(i) = (MsgData3(i) \ ShiftR(z)) And &HFF
    Next i
  Else
    For i = clkcol(m,1) To clkcol(m,1) + clkcol(m,2) - 2 'for clock, only 5 of 6 columns need shifting
      MsgData(i) = (MsgData3(i) \ ShiftL(z)) And &HFF
    Next i
  EndIf

End Sub

'------------------------------------------------------------
GetRTC:
  RTC Gettime  'Comment this out if not using a supported RTC chip
IReturn
'------------------------------------------------------------

Sub  GetMsgData
Local K,I,J,Length
K=0                           'To Ensure we start at 0

For I=1 To Len(msg$)
 cv = (Asc(Mid$(msg$, i, 1)) - 32) * 8  ' Character value

 If cv <= 256 Then K = 0
 If cv > 256 Then K = 1
 If cv > 512 Then K = 2
 If cv > 768 Then K = 3

 I2C Write I2CADDR, 0,2,K,cv+1
 I2C Read I2CADDR, 0,1,Length

  For j = 1 To length
   Eptr=Eptr+1
   I2C Write I2CADDR, 0,2,K,cv+j+1
   I2C Read I2CADDR, 0,1,MsgData(Eptr)
  Next j
Next I

End Sub

'------------------------------------------------------------