Print Time$ :  Timer = 0  'Some test code to see how long it takes to get things setup
CPU 48 'Set maximum speed for a MicroMite-170
'SPI PINS
SPI Open 5000000, 3, 16
'pin 3 is SPI Out
'pin 25 is SPI Clock
'Pin 14 is SPI In, not needed for this application
PLOAD=26  'pin 26  is used to pulse the CS line loading data into the MAX7219 chips
SetPin PLOAD,Dout

 I2CADDR = &H50                  'Address of EEprom
 I2C Open 400,100                'ENABLE I2C

MaxLEDs = 2 ' Total # of 8x8 Matrix Modules Installed (Max allowed 31)
maxbytes = 16 ' Total number of bytes allowed to hold the entire message
' A 2 char message with 8 btyes per char (2*8 = 16)
Sptr = 1 'Pointer for start of buffer
Eptr = 1 'Pointer for end of buffer
Cptr = 1 'Pointer for current place in the buffer

' chars() holds the bytes of character data.  This demo effectively has 119 characters of 8 bytes each
'         Therefore chars() needs to be dimensioned for 952 elements  (119*8 = 952)
' Eyes(-,9) holds the animation steps.  There are 9 pieces of information needed for each step.
'          Eyes(-,9) needs to be dimensioned large enough to hold all the steps. the demo has
'          932 steps.
Dim chars(1072), MsgData(maxbytes)
Dim Eyes(950,9), ASCIIptr(125,2)
'Initialize modules as soon as possible in order to clear random garbage caused by Micromite startup
M7219_INIT   'Initialize modules
ERASE_ALL    'Clear displays
'** Load Font Table data
i = 0

GoSub Codes

'Read cnt
'While cnt<> 99999
' For j = 1 To cnt
'   Read x$
'   bytecnt = bytecnt + 1
'   Chars(bytecnt) = Val("&b"+x$) 'convert string of 1s and 0s into a number
' Next j
'    ASCIIptr(i,1) = bytecnt - cnt + 1 'storge to position of the character data
'    ASCIIptr(i,2) = cnt  ' how may bytes make up the character
'    Read cnt
'   i = i+1
'Wend

Print : Print "Total number of characters loaded - "; Ani

'** Load Animation Data **
'****** Beware!!  Large amounts of Data take a LONG time to load    ******
'****** This Demo takes over 4.5 minutes to load 1050 lines of Data ******
'i = 1
'Read Eyes(i,1)
'While Eyes(i,1) <> 99999
' For j=2 To 9
'  Read Eyes(i,j)
' Next j
'  Animation = i
 ' i = i + 1
 ' Read Eyes(i,1)
'Wend

Print : Print Time$; "   "; Timer/1000; " Seconds"
Print "Total # of animation lines - "; i
Memory 'show memory status

'----------------------MAIN----------------------------
Loopit:
  For z = 1 To Animation
    CharToBits
    Show_Text
    Pause Eyes(z,9)
  Next z
GoTo Loopit
  '=====================================================
Sub M7219_INIT
  Local i
  For i = 1 To MaxLEDs
    ' First byte is the command, second byte is the data value
    AA=SPI(&H0C00): Pulse PLOAD, 0.1 'SHUTDOWN
    AA=SPI(&H0900): Pulse PLOAD, 0.1 'BCD DECODE DIGITS  00 = NO DECODE, FF = DECODE ALL
    AA=SPI(&H0A00): Pulse PLOAD, 0.1 'BRIGHTNESS 0 TO F
    AA=SPI(&H0B07): Pulse PLOAD, 0.1 '8 DIGITS
    AA=SPI(&H0F00): Pulse PLOAD, 0.1 'TEST OFF
    AA=SPI(&H0C01): Pulse PLOAD, 0.1 'RUN
  Next i
End Sub
  '--------------------------------------------------------------
  'Clear the displays by send sending zeros
Sub ERASE_ALL
  Local I, AA, J
  For I=1 To 8
    For J =1 To MaxLEDs
      AA=SPI(I*256+&H00): Pulse PLOAD,1
    Next J
  Next I
End Sub
  '--------------------------------------------------------------
  '*** Covert character string to data for 8x8 display
Sub CharToBits
  Local i, j, k, tmp
  Sptr = 1 'Start of buffer
  Eptr = 0 'End of buffer
  Cptr = 1 'Current place in the  buffer
  '*** Copy character bits into MsgData array
  For i=1 To 5 Step 4 'The "STEP 4"  exposes the data for the left eye then the right eye
    cv = Eyes(z,i) ' Character value provides location where data is to be found
    cv2 = Eyes(z,i+1)
    tmp = ASCIIptr(cv2,1) 'pointer to Eyeball data
    For j = ASCIIptr(cv,1) To ASCIIptr(cv,1) + ASCIIptr(cv,2)-1

  Eptr = Eptr + 1
      MsgData(Eptr) = chars(j) Or (chars(tmp)\(2^Eyes(z,i+2)))
      tmp = tmp + 1
    Next j
  Next i
  'Be sure there is at least enough data for all the LED matrix modules
  If (8*MaxLEDs) > (Eptr) Then
    tmp = (8*MaxLEDs) - (Eptr)
    For k = 1 To tmp
      Eptr = Eptr + 1
      MsgData(Eptr) = 0
    Next k
  EndIf
End Sub
  '--------------------------------------------------------------
Sub Show_Text
  Local i, j, k, Cptr2
  Cptr2  = Cptr
  AA=SPI(&H0A*256+Eyes(z,4)) 'BRIGHTNESS for Left Module
  AA=SPI(&H0A*256+Eyes(z,8)): Pulse PLOAD, 0.1 'BRIGHTNESS For Right Module
  For i = 1 To 8
    For j=Cptr2 To (MaxLEDs*8)+ Cptr-1 Step 8
      AA=SPI(i*256+MsgData(j))' print MsgData()
    Next j
    Pulse PLOAD,0.1
    Cptr2 = Cptr2 + 1
  Next i
End Sub
  '------------------------------------------------------------
 Codes:                            'Rem READ From AT24C32

I2C Write I2CADDR, 0,2,0,1      'Set start at 00

SmallArray:
I2C Read I2CADDR, 0,1,cnt
For j = 1 To cnt
  I2C Read I2CADDR, 0,1,Temp
  bytecnt = bytecnt + 1
    Chars(bytecnt) = Temp
Next j
    ASCIIptr(i,1) = bytecnt - cnt + 1 'storge to position of the character data
    ASCIIptr(i,2) = cnt         ' how may bytes make up the character
    Ani = i
  i = i+1
If I <=119 Then GoTo SmallArray


 I2C Read I2CADDR, 0,1,Temp
 i = 1
 Eyes(i,1)=Temp

BigArray:
For j=2 To 9
  I2C Read I2CADDR, 0,1,Temp
  Eyes(i,j)=Temp
Next j
  Animation = i
  i = i + 1
  I2C Read I2CADDR, 0,1,Temp
  Eyes(i,1)=Temp
If I < 931 GoTo BigArray

I2C Close

Return