' Write array to 24C32 EEprom
' John Gerrard

CData=9451        'Number of items in the array
S=Int(Cdata/256)  'Number of 256 blocks
Dim Codes(CData)  'Dimension array
Dim Code$(8)

IT=1
GoSub Codes       'Read array
WriteEE:          'Rem WRITE TO AT24C32

I2CADDR=&H50      'Address of 24c32
I2C Open 400,100 'ENABLE I2C
BC=&HFF           'Complete block

For J=&h0 To S                'Number of blocks to write
 If J=S Then BC = CData-(S*256)  'Full block or remainder
  For I=&h0 To BC
   I2C Write I2CADDR, 0,3,J,I,Codes(Cnt) 'Write to EE
   Pause 10                        'Small delay for EE
   Cnt = cnt + 1                  'Increment array counter
Next i: Next j

I2C Write I2CADDR, 0,4,&H7f,&HFE,BC,S  'Write item count to EE
Pause 10                              'Small delay for EE
I2C Close


ReadTotal:                            ' To make sure its ok

I2C Open 400,100 'ENABLE I2C
I2C Write I2CADDR, 0,2,&H7f,&HFE       'EEprom location
I2C Read I2CADDR, 0,1,C
I2C Read I2CADDR, 0,1,D

 Print "EEProm HAS BEEN WRITTEN with "; (D*256)+C ;"  Codes";

 End


Codes:
 Read cnt
If cnt  = 99999 Then GoTo Codes2

 Codes(IT) = cnt
  For I = 1 To 8
    Read Code$(I)
    Codes(IT+I)=Val("&b"+Code$(I))
   Next I
 IT = IT + 9

GoTo codes

Codes2:

Print "IT " ;it

IT=IT +1

 For I = IT To 9451
  Read Codes(I)
 Next I

cnt = 0
i = 0

Return

'=================================================================
'**** Font Table
  Data 8, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000  'Blank
  Data 8, 00011000, 00100100, 01000010, 10000001, 10000001, 01000010, 00100100, 00011000  'Eye 1 Diamond
  Data 8, 00011000, 00100100, 01000010, 10000010, 10000010, 01000010, 00100100, 00011000  'Blink 1A
  Data 8, 00011000, 00100100, 01000100, 10000100, 10000100, 01000100, 00100100, 00011000  'Blink 1B
  Data 8, 00011000, 00101000, 01001000, 10001000, 10001000, 01001000, 00101000, 00011000  'Blink 1C
  Data 8, 00010000, 00110000, 01010000, 10010000, 10010000, 01010000, 00110000, 00010000  'Blink 1D
  Data 8, 00010000, 00100000, 01100000, 10100000, 10100000, 01100000, 00100000, 00010000  'Blink 1E
  Data 8, 00010000, 00100000, 01000000, 11000000, 11000000, 01000000, 00100000, 00010000  'Blink 1F
  Data 8, 00010000, 00100000, 01000000, 10000000, 10000000, 01000000, 00100000, 00010000  'Blink 1G
  Data 8, 00111100, 01000010, 10000001, 10000001, 10000001, 10000001, 01000010, 00111100  'Eye 2 Round
  Data 8, 00111100, 01000010, 10000010, 10000010, 10000010, 10000010, 01000010, 00111100  'Blink 2A
  Data 8, 00111100, 01000100, 10000100, 10000100, 10000100, 10000100, 01000100, 00111100  'Blink 2B
  Data 8, 00111000, 01001000, 10001000, 10001000, 10001000, 10001000, 01001000, 00111000  'Blink 2C
  Data 8, 00110000, 01010000, 10010000, 10010000, 10010000, 10010000, 01010000, 00110000  'Blink 2D
  Data 8, 00100000, 01100000, 10100000, 10100000, 10100000, 10100000, 01100000, 00100000  'Blink 2E
  Data 8, 00000000, 01000000, 11000000, 11000000, 11000000, 11000000, 01000000, 00000000  'Blink 2F
  Data 8, 00000000, 01000000, 10000000, 10000000, 10000000, 10000000, 01000000, 00000000  'Blank 2G
  Data 8, 11100000, 10011000, 10000110, 10000001, 10000001, 10000110, 10011000, 11100000  'Eye 3 Triangle
  Data 8, 11100000, 10011000, 10000110, 10000010, 10000010, 10000110, 10011000, 11100000  'Eye 3A
  Data 8, 11100000, 10011000, 10000100, 10000100, 10000100, 10000100, 10011000, 11100000  'Eye 3B
  Data 8, 11100000, 10011000, 10001000, 10001000, 10001000, 10001000, 10011000, 11100000  'Eye 3C
  Data 8, 11100000, 10010000, 10010000, 10010000, 10010000, 10010000, 10010000, 11100000  'Eye 3D
  Data 8, 11100000, 10100000, 10100000, 10100000, 10100000, 10100000, 10100000, 11100000  'Eye 3E
  Data 8, 11100000, 11000000, 11000000, 11000000, 11000000, 11000000, 11000000, 11100000  'Eye 3F
  Data 8, 11100000, 10000000, 10000000, 10000000, 10000000, 10000000, 10000000, 11100000  'Eye 3G
  Data 8, 11111111, 10000001, 10000001, 10000001, 10000001, 10000001, 10000001, 10000001  'Left box
  Data 8, 10000001, 10000001, 10000001, 10000001, 10000001, 10000001, 10000001, 11111111  'Right box
  Data 8, 11000000, 11000000, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000  'Pupil 1 Square 2x2
  Data 8, 00000000, 11000000, 11000000, 00000000, 00000000, 00000000, 00000000, 00000000  'Pupil 1 Left step2
  Data 8, 00000000, 00000000, 11000000, 11000000, 00000000, 00000000, 00000000, 00000000  'Pupil 1 Left step3
  Data 8, 00000000, 00000000, 00000000, 11000000, 11000000, 00000000, 00000000, 00000000  'Pupil 1 Centered
  Data 8, 00000000, 00000000, 00000000, 00000000, 11000000, 11000000, 00000000, 00000000  'Pupil 1 Right step1
  Data 8, 00000000, 00000000, 00000000, 00000000, 00000000, 11000000, 11000000, 00000000  'Pupil 1 Right step2
  Data 8, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000, 11000000, 11000000  'Pupil 1 Right step3
  Data 8, 10000000, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000  'Pupil 2 (half) 2x1
  Data 8, 10000000, 10000000, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000  'Pupil 2B
  Data 8, 00000000, 10000000, 10000000, 00000000, 00000000, 00000000, 00000000, 00000000  'Pupil 2C
  Data 8, 00000000, 00000000, 10000000, 10000000, 00000000, 00000000, 00000000, 00000000  'Pupil 2D
  Data 8, 00000000, 00000000, 00000000, 10000000, 10000000, 00000000, 00000000, 00000000  'Pupil 2E
  Data 8, 00000000, 00000000, 00000000, 00000000, 10000000, 10000000, 00000000, 00000000  'Pupil 2F
  Data 8, 00000000, 00000000, 00000000, 00000000, 00000000, 10000000, 10000000, 00000000  'Pupil 2G
  Data 8, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000, 10000000, 10000000  'Pupil 2H
  Data 8, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000, 10000000  'Pupil 2I
  Data 8, 10000000, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000  'Pupil 3 \ 2x2
  Data 8, 01000000, 10000000, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000  'Pupil 3B
  Data 8, 00000000, 01000000, 10000000, 00000000, 00000000, 00000000, 00000000, 00000000  'Pupil 3C
  Data 8, 00000000, 00000000, 01000000, 10000000, 00000000, 00000000, 00000000, 00000000  'Pupil 3D
  Data 8, 00000000, 00000000, 00000000, 01000000, 10000000, 00000000, 00000000, 00000000  'Pupil 3E
  Data 8, 00000000, 00000000, 00000000, 00000000, 01000000, 10000000, 00000000, 00000000  'Pupil 3F
  Data 8, 00000000, 00000000, 00000000, 00000000, 00000000, 01000000, 10000000, 00000000  'Pupil 3G
  Data 8, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000, 01000000, 10000000  'Pupil 3H
  Data 8, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000, 01000000  'Pupil 3I
  Data 8, 01000000, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000  'Pupil 4 / 2x2
  Data 8, 10000000, 01000000, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000  'Pupil 4B
  Data 8, 00000000, 10000000, 01000000, 00000000, 00000000, 00000000, 00000000, 00000000  'Pupil 4C
  Data 8, 00000000, 00000000, 10000000, 01000000, 00000000, 00000000, 00000000, 00000000  'Pupil 4D
  Data 8, 00000000, 00000000, 00000000, 10000000, 01000000, 00000000, 00000000, 00000000  'Pupil 4E
  Data 8, 00000000, 00000000, 00000000, 00000000, 10000000, 01000000, 00000000, 00000000  'Pupil 4F
  Data 8, 00000000, 00000000, 00000000, 00000000, 00000000, 10000000, 01000000, 00000000  'Pupil 4G
  Data 8, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000, 10000000, 01000000  'Pupil 4H
  Data 8, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000, 10000000  'Pupil 4I
  Data 8, 01100000, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000  'Pupil 5 o 4x4
  Data 8, 10010000, 01100000, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000  'Pupil 5B
  Data 8, 10010000, 10010000, 01100000, 00000000, 00000000, 00000000, 00000000, 00000000  'Pupil 5C
  Data 8, 01100000, 10010000, 10010000, 01100000, 00000000, 00000000, 00000000, 00000000  'Pupil 5D o 4x4
  Data 8, 00000000, 01100000, 10010000, 10010000, 01100000, 00000000, 00000000, 00000000  'Pupil 5E
  Data 8, 00000000, 00000000, 01100000, 10010000, 10010000, 01100000, 00000000, 00000000  'Pupil 5F
  Data 8, 00000000, 00000000, 00000000, 01100000, 10010000, 10010000, 01100000, 00000000  'Pupil 5G
  Data 8, 00000000, 00000000, 00000000, 00000000, 01100000, 10010000, 10010000, 01100000  'Pupil 5H
  Data 8, 00000000, 00000000, 00000000, 00000000, 00000000, 01100000, 10010000, 10010000  'Pupil 5I
  Data 8, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000, 01100000, 10010000  'Pupil 5J
  Data 8, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000, 01100000  'Pupil 5K
  Data 8, 01000000, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000  'Pupil 5.1 o 4x4 Alternating Dots
  Data 8, 00010000, 01000000, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000  'Pupil 5.1B
  Data 8, 10000000, 00010000, 01000000, 00000000, 00000000, 00000000, 00000000, 00000000  'Pupil 5.1C
  Data 8, 00100000, 10000000, 00010000, 01000000, 00000000, 00000000, 00000000, 00000000  'Pupil 5.1D o 4x4
  Data 8, 00000000, 00100000, 10000000, 00010000, 01000000, 00000000, 00000000, 00000000  'Pupil 5.1E
  Data 8, 00000000, 00000000, 00100000, 10000000, 00010000, 01000000, 00000000, 00000000  'Pupil 5.1F
  Data 8, 00000000, 00000000, 00000000, 00100000, 10000000, 00010000, 01000000, 00000000  'Pupil 5.1G
  Data 8, 00000000, 00000000, 00000000, 00000000, 00100000, 10000000, 00010000, 01000000  'Pupil 5.1H
  Data 8, 00000000, 00000000, 00000000, 00000000, 00000000, 00100000, 10000000, 00010000  'Pupil 5.1I
  Data 8, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000, 00100000, 10000000  'Pupil 5.1J
  Data 8, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000, 00100000  'Pupil 5.1K
  Data 8, 00100000, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000  'Pupil 5.2 o 4x4 Alternating Dots
  Data 8, 10000000, 00100000, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000  'Pupil 5.2B
  Data 8, 00010000, 10000000, 00100000, 00000000, 00000000, 00000000, 00000000, 00000000  'Pupil 5.2C
  Data 8, 01000000, 00010000, 10000000, 00100000, 00000000, 00000000, 00000000, 00000000  'Pupil 5.2D o 4x4
  Data 8, 00000000, 01000000, 00010000, 10000000, 00100000, 00000000, 00000000, 00000000  'Pupil 5.2E
  Data 8, 00000000, 00000000, 01000000, 00010000, 10000000, 00100000, 00000000, 00000000  'Pupil 5.2F
  Data 8, 00000000, 00000000, 00000000, 01000000, 00010000, 10000000, 00100000, 00000000  'Pupil 5.2G
  Data 8, 00000000, 00000000, 00000000, 00000000, 01000000, 00010000, 10000000, 00100000  'Pupil 5.2H
  Data 8, 00000000, 00000000, 00000000, 00000000, 00000000, 01000000, 00010000, 10000000  'Pupil 5.2I
  Data 8, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000, 01000000, 00010000  'Pupil 5.2J
  Data 8, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000, 01000000  'Pupil 5.2K
  Data 8, 00000000, 00000000, 01100000, 10000000, 10000000, 01100000, 00000000, 00000000  'Pupil 5 blink use after 5F
  Data 8, 00000000, 00000000, 01000000, 10000000, 10000000, 01000000, 00000000, 00000000  'Pupil 5B blink
  Data 8, 00000000, 00000000, 00000000, 10000000, 10000000, 00000000, 00000000, 00000000  'Pupil 5C blink
  Data 8, 11000000, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000  'Pupil 6 | 1x2
  Data 8, 00000000, 11000000, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000  'Pupil 6B
  Data 8, 00000000, 00000000, 11000000, 00000000, 00000000, 00000000, 00000000, 00000000  'Pupil 6C
  Data 8, 00000000, 00000000, 00000000, 11000000, 00000000, 00000000, 00000000, 00000000  'Pupil 6D
  Data 8, 00000000, 00000000, 00000000, 00000000, 11000000, 00000000, 00000000, 00000000  'Pupil 6E
  Data 8, 00000000, 00000000, 00000000, 00000000, 00000000, 11000000, 00000000, 00000000  'Pupil 6F
  Data 8, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000, 11000000, 00000000  'Pupil 6G
  Data 8, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000, 11000000  'Pupil 6H
  Data 8, 01100000, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000  'Pupil 7 o  4x4 solid
  Data 8, 11110000, 01100000, 00000000, 00000000, 00000000, 00000000, 00000000, 00000000  'Pupil 7B
  Data 8, 11110000, 11110000, 01100000, 00000000, 00000000, 00000000, 00000000, 00000000  'Pupil 7C
  Data 8, 01100000, 11110000, 11110000, 01100000, 00000000, 00000000, 00000000, 00000000  'Pupil 7D
  Data 8, 00000000, 01100000, 11110000, 11110000, 01100000, 00000000, 00000000, 00000000  'Pupil 7E
  Data 8, 00000000, 00000000, 01100000, 11110000, 11110000, 01100000, 00000000, 00000000  'Pupil 7F
  Data 8, 00000000 ,00000000, 00000000, 01100000, 11110000, 11110000, 01100000, 00000000  'Pupil 7G
  Data 8, 00000000, 00000000 ,00000000, 00000000, 01100000, 11110000, 11110000, 01100000  'Pupil 7H
  Data 8, 00000000, 00000000, 00000000 ,00000000, 00000000, 01100000, 11110000, 11110000  'Pupil 7I
  Data 8, 00000000, 00000000, 00000000, 00000000 ,00000000, 00000000, 01100000, 11110000  'Pupil 7J
  Data 8, 00000000, 00000000, 00000000, 00000000, 00000000 ,00000000, 00000000, 01100000  'Pupil 7K
  Data 8, 00000000, 00000000, 01100000, 11100000, 11100000, 01100000, 00000000, 00000000  'Pupil e blink use after 7F
  Data 8, 00000000, 00000000, 01000000, 11000000, 11000000, 01000000, 00000000, 00000000  'Pupil 7B blink
  Data 8, 00000000, 00000000, 00000000, 10000000, 10000000, 00000000, 00000000, 00000000  'Pupil 7C blink
  Data 99999

'Animation Data
'Left Eye shape, Left Eye Pupil, Left Pupil y position, Left Eye brightness,  Right Eye shape, Right Eye Pupil, Right Pupil y position, Right Eye brightness, Pause

 'Diamond eye  and block pupil  look up and down
  Data 01, 30, 3, 0, 01, 30, 3, 0, 1500
  Data 01, 30, 2, 0, 01, 30, 2, 0, 100
  Data 01, 30, 1, 0, 01, 30, 1, 0, 250
  Data 01, 30, 2, 0, 01, 30, 2, 0, 100
  Data 01, 30, 3, 0, 01, 30, 3, 0, 100
  Data 01, 30, 4, 0, 01, 30, 4, 0, 100
  Data 01, 30, 5, 0, 01, 30, 5, 0, 100
  Data 01, 30, 6, 0, 01, 30, 6, 0, 250
  Data 01, 30, 5, 0, 01, 30, 5, 0, 100
  Data 01, 30, 4, 0, 01, 30, 4, 0, 100
  Data 01, 30, 3, 0, 01, 30, 3, 0, 100
  'Diamond eye  and block pupil Blink
  Data 01, 30, 3, 0, 01, 30, 3, 0, 1500
  Data 02, 30, 3, 0, 02, 30, 3, 0, 0
  Data 03, 30, 3, 0, 03, 30, 3, 0, 0
  Data 04, 30, 3, 0, 04, 30, 3, 0, 0
  Data 05, 00, 3, 0, 05, 00, 3, 0, 0
  Data 06, 00, 3, 0, 06, 00, 3, 0, 0
  Data 07, 00, 3, 0, 07, 00, 3, 0, 0
  Data 08, 00, 3, 0, 08, 00, 3, 0, 0
  Data 07, 00, 3, 0, 07, 00, 3, 0, 0
  Data 06, 00, 3, 0, 06, 00, 3, 0, 0
  Data 05, 00, 3, 0, 05, 00, 3, 0, 0
  Data 04, 30, 3, 0, 04, 30, 3, 0, 0
  Data 03, 30, 3, 0, 03, 30, 3, 0, 0
  Data 02, 30, 3, 0, 02, 30, 3, 0, 0
  'Diamond eye  and block pupil  look left and right
  Data 01, 30, 3, 0, 01, 30, 3, 0, 100
  Data 01, 29, 3, 0, 01, 29, 3, 0, 100
  Data 01, 28, 3, 0, 01, 28, 3, 0, 100
  Data 01, 27, 3, 0, 01, 27, 3, 0, 250
  Data 01, 28, 3, 0, 01, 28, 3, 0, 100
  Data 01, 29, 3, 0, 01, 29, 3, 0, 100
  Data 01, 30, 3, 0, 01, 30, 3, 0, 100
  Data 01, 31, 3, 0, 01, 31, 3, 0, 100
  Data 01, 32, 3, 0, 01, 32, 3, 0, 100
  Data 01, 33, 3, 0, 01, 33, 3, 0, 250
  Data 01, 32, 3, 0, 01, 32, 3, 0, 100
  Data 01, 31, 3, 0, 01, 31, 3, 0, 100
  '  Data 01, 30, 3, 0, 01, 30, 3, 0, 0

  'Diamond eye  and block pupil Blink
  Data 01, 30, 3, 0, 01, 30, 3, 0, 1500
  Data 02, 30, 3, 0, 02, 30, 3, 0, 0
  Data 03, 30, 3, 0, 03, 30, 3, 0, 0
  Data 04, 30, 3, 0, 04, 30, 3, 0, 0
  Data 05, 00, 3, 0, 05, 00, 3, 0, 0
  Data 06, 00, 3, 0, 06, 00, 3, 0, 0
  Data 07, 00, 3, 0, 07, 00, 3, 0, 0
  Data 08, 00, 3, 0, 08, 00, 3, 0, 0
  Data 07, 00, 3, 0, 07, 00, 3, 0, 0
  Data 06, 00, 3, 0, 06, 00, 3, 0, 0
  Data 05, 00, 3, 0, 05, 00, 3, 0, 0
  Data 04, 30, 3, 0, 04, 30, 3, 0, 0
  Data 03, 30, 3, 0, 03, 30, 3, 0, 0
  Data 02, 30, 3, 0, 02, 30, 3, 0, 0
  '  Data 01, 30, 3, 0, 01, 30, 3, 0, 0
  Data 01, 30, 3, 0, 01, 30, 3, 0, 0
  Data 02, 30, 3, 0, 02, 30, 3, 0, 0
  Data 03, 30, 3, 0, 03, 30, 3, 0, 0
  Data 04, 30, 3, 0, 04, 30, 3, 0, 0
  Data 05, 00, 3, 0, 05, 00, 3, 0, 0
  Data 06, 00, 3, 0, 06, 00, 3, 0, 0
  Data 07, 00, 3, 0, 07, 00, 3, 0, 0
  Data 08, 00, 3, 0, 08, 00, 3, 0, 0
  Data 07, 00, 3, 0, 07, 00, 3, 0, 0
  Data 06, 00, 3, 0, 06, 00, 3, 0, 0
  Data 05, 00, 3, 0, 05, 00, 3, 0, 0
  Data 04, 30, 3, 0, 04, 30, 3, 0, 0
  Data 03, 30, 3, 0, 03, 30, 3, 0, 0
  Data 02, 30, 3, 0, 02, 30, 3, 0, 0

  'Diamond eye  and block pupil Look up left
  Data 01, 30, 3, 0, 01, 30, 3, 0, 100
  Data 01, 29, 4, 0, 01, 29, 4, 0, 100
  Data 01, 30, 5, 0, 01, 30, 5, 0, 100
  Data 01, 31, 4, 0, 01, 31, 4, 0, 100
  Data 01, 32, 3, 0, 01, 32, 3, 0, 100
  Data 01, 31, 2, 0, 01, 31, 2, 0, 100
  Data 01, 30, 1, 0, 01, 30, 1, 0, 100
  Data 01, 29, 2, 0, 01, 29, 2, 0, 100
  Data 01, 28, 3, 0, 01, 28, 3, 0, 100
  Data 01, 29, 3, 0, 01, 29, 3, 0, 100
  Data 01, 30, 3, 0, 01, 30, 3, 0, 100
  Data 01, 31, 2, 0, 01, 30, 3, 0, 100
  Data 01, 32, 3, 0, 01, 29, 4, 0, 100
  Data 01, 31, 4, 0, 01, 30, 5, 0, 100
  Data 01, 30, 5, 0, 01, 31, 4, 0, 100
  Data 01, 29, 4, 0, 01, 32, 3, 0, 100
  Data 01, 28, 3, 0, 01, 31, 2, 0, 100
  Data 01, 29, 2, 0, 01, 30, 1, 0, 100
  Data 01, 30, 1, 0, 01, 29, 2, 0, 100
  Data 01, 31, 2, 0, 01, 28, 3, 0, 100
  Data 01, 32, 3, 0, 01, 29, 3, 0, 100
  'Data 01, 30, 3, 0, 01, 30, 3, 0, 100

  'Diamond eye  and block pupil Blink
  Data 01, 30, 3, 0, 01, 30, 3, 0, 1500
  Data 02, 30, 3, 0, 02, 30, 3, 0, 0
  Data 03, 30, 3, 0, 03, 30, 3, 0, 0
  Data 04, 30, 3, 0, 04, 30, 3, 0, 0
  Data 05, 00, 3, 0, 05, 00, 3, 0, 0
  Data 06, 00, 3, 0, 06, 00, 3, 0, 0
  Data 07, 00, 3, 0, 07, 00, 3, 0, 0
  Data 08, 00, 3, 0, 08, 00, 3, 0, 0
  Data 07, 00, 3, 0, 07, 00, 3, 0, 0
  Data 06, 00, 3, 0, 06, 00, 3, 0, 0
  Data 05, 00, 3, 0, 05, 00, 3, 0, 0
  Data 04, 30, 3, 0, 04, 30, 3, 0, 0
  Data 03, 30, 3, 0, 03, 30, 3, 0, 0
  Data 02, 30, 3, 0, 02, 30, 3, 0, 0
  '  Data 01, 30, 3, 0, 01, 30, 3, 0, 0
  Data 01, 30, 3, 0, 01, 30, 3, 0, 0
  Data 02, 30, 3, 0, 02, 30, 3, 0, 0
  Data 03, 30, 3, 0, 03, 30, 3, 0, 0
  Data 04, 30, 3, 0, 04, 30, 3, 0, 0
  Data 05, 00, 3, 0, 05, 00, 3, 0, 0
  Data 06, 00, 3, 0, 06, 00, 3, 0, 0
  Data 07, 00, 3, 0, 07, 00, 3, 0, 0
  Data 08, 00, 3, 0, 08, 00, 3, 0, 0
  Data 07, 00, 3, 0, 07, 00, 3, 0, 0
  Data 06, 00, 3, 0, 06, 00, 3, 0, 0
  Data 05, 00, 3, 0, 05, 00, 3, 0, 0
  Data 04, 30, 3, 0, 04, 30, 3, 0, 0
  Data 03, 30, 3, 0, 03, 30, 3, 0, 0
  Data 02, 30, 3, 0, 02, 30, 3, 0, 0
  Data 01, 30, 3, 0, 01, 30, 3, 0, 1000

  'strobing Pupils (part closed full eyes and round pupils)
  Data 11, 77, 1, 0, 11, 77, 1, 0, 75
  Data 11, 88, 1, 0, 11, 88, 1, 0, 75
  Data 11, 77, 1, 0, 11, 77, 1, 0, 75
  Data 11, 88, 1, 0, 11, 88, 1, 0, 75
  Data 11, 77, 1, 0, 11, 77, 1, 0, 75
  Data 11, 88, 1, 0, 11, 88, 1, 0, 75
  Data 11, 77, 1, 0, 11, 77, 1, 0, 75
  Data 11, 88, 1, 0, 11, 88, 1, 0, 75
  Data 11, 77, 1, 0, 11, 77, 1, 0, 75
  Data 11, 88, 1, 0, 11, 88, 1, 0, 75
  Data 11, 77, 1, 0, 11, 77, 1, 0, 75
  Data 11, 88, 1, 0, 11, 88, 1, 0, 75
  Data 11, 77, 1, 0, 11, 77, 1, 0, 75
  Data 11, 88, 1, 0, 11, 88, 1, 0, 75
  Data 11, 77, 1, 0, 11, 77, 1, 0, 75
  Data 11, 88, 1, 0, 11, 88, 1, 0, 75
  Data 11, 77, 1, 0, 11, 77, 1, 0, 75
  Data 11, 88, 1, 0, 11, 88, 1, 0, 75
  Data 11, 77, 1, 0, 11, 77, 1, 0, 75
  Data 11, 88, 1, 0, 11, 88, 1, 0, 75
  Data 11, 77, 1, 0, 11, 77, 1, 0, 75
  Data 11, 88, 1, 0, 11, 88, 1, 0, 75
  Data 11, 77, 1, 0, 11, 77, 1, 0, 75
  Data 11, 88, 1, 0, 11, 88, 1, 0, 75
  Data 11, 77, 1, 0, 11, 77, 1, 0, 20
  Data 11, 88, 1, 0, 11, 88, 1, 0, 20
  Data 11, 77, 1, 0, 11, 77, 1, 0, 20
  Data 11, 88, 1, 0, 11, 88, 1, 0, 20
  Data 11, 77, 1, 0, 11, 77, 1, 0, 20
  Data 11, 88, 1, 0, 11, 88, 1, 0, 20
  Data 11, 77, 1, 0, 11, 77, 1, 0, 20
  Data 11, 88, 1, 0, 11, 88, 1, 0, 20
  Data 11, 77, 1, 0, 11, 77, 1, 0, 20
  Data 11, 88, 1, 0, 11, 88, 1, 0, 20
  Data 11, 77, 1, 0, 11, 77, 1, 0, 20
  Data 11, 88, 1, 0, 11, 88, 1, 0, 20
  Data 11, 77, 1, 0, 11, 77, 1, 0, 20
  Data 11, 88, 1, 0, 11, 88, 1, 0, 20
  Data 11, 77, 1, 0, 11, 77, 1, 0, 20
  Data 11, 88, 1, 0, 11, 88, 1, 0, 20
  Data 11, 77, 1, 0, 11, 77, 1, 0, 20
  Data 11, 88, 1, 0, 11, 88, 1, 0, 20
  Data 11, 77, 1, 0, 11, 77, 1, 0, 20
  Data 11, 88, 1, 0, 11, 88, 1, 0, 20
  Data 11, 77, 1, 0, 11, 77, 1, 0, 20
  Data 11, 88, 1, 0, 11, 88, 1, 0, 20
  Data 11, 77, 1, 0, 11, 77, 1, 0, 20
  Data 11, 88, 1, 0, 11, 88, 1, 0, 20
  Data 11, 77, 1, 0, 11, 77, 1, 0, 20
  Data 11, 88, 1, 0, 11, 88, 1, 0, 20
  Data 11, 77, 1, 0, 11, 77, 1, 0, 20
  Data 11, 88, 1, 0, 11, 88, 1, 0, 20
  Data 11, 77, 1, 0, 11, 77, 1, 0, 20
  Data 11, 88, 1, 0, 11, 88, 1, 0, 20
  Data 11, 77, 1, 0, 11, 77, 1, 0, 20
  Data 11, 88, 1, 0, 11, 88, 1, 0, 20
  Data 11, 77, 1, 0, 11, 77, 1, 0, 20
  Data 11, 88, 1, 0, 11, 88, 1, 0, 20
  Data 11, 77, 1, 0, 11, 77, 1, 0, 20
  Data 11, 88, 1, 0, 11, 88, 1, 0, 20

  'strobing Pupils (part closed full eyes and square pupils)
  Data 12, 47, 2, 0, 12, 47, 2, 0, 20
  Data 12, 56, 2, 0, 12, 56, 2, 0, 20
  Data 12, 47, 2, 0, 12, 47, 2, 0, 20
  Data 12, 56, 2, 0, 12, 56, 2, 0, 20
  Data 12, 47, 2, 0, 12, 47, 2, 0, 20
  Data 12, 56, 2, 0, 12, 56, 2, 0, 20
  Data 12, 47, 2, 0, 12, 47, 2, 0, 20
  Data 12, 56, 2, 0, 12, 56, 2, 0, 20
  Data 12, 47, 2, 0, 12, 47, 2, 0, 20
  Data 12, 56, 2, 0, 12, 56, 2, 0, 20
  Data 12, 47, 2, 0, 12, 47, 2, 0, 20
  Data 12, 56, 2, 0, 12, 56, 2, 0, 20
  Data 12, 47, 2, 0, 12, 47, 2, 0, 20
  Data 12, 56, 2, 0, 12, 56, 2, 0, 20
  Data 12, 47, 2, 0, 12, 47, 2, 0, 20
  Data 12, 56, 2, 0, 12, 56, 2, 0, 20
  Data 12, 47, 2, 0, 12, 47, 2, 0, 20
  Data 12, 56, 2, 0, 12, 56, 2, 0, 20
  Data 12, 47, 2, 0, 12, 47, 2, 0, 20
  Data 12, 56, 2, 0, 12, 56, 2, 0, 20
  Data 12, 47, 2, 0, 12, 47, 2, 0, 20
  Data 12, 56, 2, 0, 12, 56, 2, 0, 20
  Data 12, 47, 2, 0, 12, 47, 2, 0, 20
  Data 12, 56, 2, 0, 12, 56, 2, 0, 20
  Data 12, 47, 2, 0, 12, 47, 2, 0, 20
  Data 12, 56, 2, 0, 12, 56, 2, 0, 20
  Data 12, 47, 2, 0, 12, 47, 2, 0, 20
  Data 12, 56, 2, 0, 12, 56, 2, 0, 20
  Data 12, 47, 2, 0, 12, 47, 2, 0, 20
  Data 12, 56, 2, 0, 12, 56, 2, 0, 20
  Data 12, 47, 2, 0, 12, 47, 2, 0, 20
  Data 12, 56, 2, 0, 12, 56, 2, 0, 20
  Data 12, 47, 2, 0, 12, 47, 2, 0, 20
  Data 12, 56, 2, 0, 12, 56, 2, 0, 20
  Data 12, 47, 2, 0, 12, 47, 2, 0, 20
  Data 12, 56, 2, 0, 12, 56, 2, 0, 20
  Data 12, 47, 2, 0, 12, 47, 2, 0, 20
  Data 12, 56, 2, 0, 12, 56, 2, 0, 20
  Data 12, 47, 2, 0, 12, 47, 2, 0, 20
  Data 12, 56, 2, 0, 12, 56, 2, 0, 20
  Data 12, 47, 2, 0, 12, 47, 2, 0, 20
  Data 12, 56, 2, 0, 12, 56, 2, 0, 20
  Data 12, 47, 2, 0, 12, 47, 2, 0, 20
  Data 12, 56, 2, 0, 12, 56, 2, 0, 20
  Data 12, 47, 2, 0, 12, 47, 2, 0, 20
  Data 12, 56, 2, 0, 12, 56, 2, 0, 20
  Data 12, 47, 2, 0, 12, 47, 2, 0, 20
  Data 12, 56, 2, 0, 12, 56, 2, 0, 20
  Data 12, 47, 2, 0, 12, 47, 2, 0, 20
  Data 12, 56, 2, 0, 12, 56, 2, 0, 20
  Data 12, 47, 2, 0, 12, 47, 2, 0, 20
  Data 12, 56, 2, 0, 12, 56, 2, 0, 20
  Data 12, 47, 2, 0, 12, 47, 2, 0, 20
  Data 12, 56, 2, 0, 12, 56, 2, 0, 20
  Data 12, 47, 2, 0, 12, 47, 2, 0, 20
  Data 12, 56, 2, 0, 12, 56, 2, 0, 20
  Data 12, 47, 2, 0, 12, 47, 2, 0, 20
  Data 12, 56, 2, 0, 12, 56, 2, 0, 20
  Data 12, 47, 2, 0, 12, 47, 2, 0, 20
  Data 12, 56, 2, 0, 12, 56, 2, 0, 20
  Data 12, 47, 2, 0, 12, 47, 2, 0, 20
  Data 12, 56, 2, 0, 12, 56, 2, 0, 20
  Data 12, 47, 2, 0, 12, 47, 2, 0, 20
  Data 12, 56, 2, 0, 12, 56, 2, 0, 20
  Data 12, 47, 2, 0, 12, 47, 2, 0, 20
  Data 12, 56, 2, 0, 12, 56, 2, 0, 20
  Data 12, 47, 2, 0, 12, 47, 2, 0, 20
  Data 12, 56, 2, 0, 12, 56, 2, 0, 20
  Data 12, 47, 2, 0, 12, 47, 2, 0, 20
  Data 12, 56, 2, 0, 12, 56, 2, 0, 20
  Data 12, 47, 2, 0, 12, 47, 2, 0, 20
  Data 12, 56, 2, 0, 12, 56, 2, 0, 20
  Data 12, 47, 2, 0, 12, 47, 2, 0, 20
  Data 12, 56, 2, 0, 12, 56, 2, 0, 20
  Data 12, 47, 2, 0, 12, 47, 2, 0, 20
  Data 12, 56, 2, 0, 12, 56, 2, 0, 20
  Data 12, 47, 2, 0, 12, 47, 2, 0, 20
  Data 12, 56, 2, 0, 12, 56, 2, 0, 20
  Data 12, 47, 2, 0, 12, 47, 2, 0, 20
  Data 12, 56, 2, 0, 12, 56, 2, 0, 20

 'Round Eye with Round pupil blink
  Data 09, 66, 2, 0, 09, 66, 2, 0, 1500
  Data 10, 66, 2, 0, 10, 66, 2, 0, 0
  Data 11, 94, 2, 0, 11, 94, 2, 0, 0
  Data 12, 95, 2, 0, 12, 95, 2, 0, 0
  Data 13, 96, 2, 0, 13, 96, 2, 0, 0
  Data 14, 00, 2, 0, 14, 00, 2, 0, 0
  Data 15, 00, 2, 0, 15, 00, 2, 0, 0
  Data 16, 00, 2, 0, 16, 00, 2, 0, 0
  Data 15, 00, 2, 0, 15, 00, 2, 0, 0
  Data 14, 00, 2, 0, 14, 00, 2, 0, 0
  Data 13, 96, 2, 0, 13, 96, 2, 0, 0
  Data 12, 95, 2, 0, 12, 95, 2, 0, 0
  Data 11, 94, 2, 0, 11, 94, 2, 0, 0
  Data 10, 66, 2, 0, 10, 66, 2, 0, 0
  Data 09, 66, 2, 0, 09, 66, 2, 0, 0
  Data 09, 66, 2, 0, 09, 66, 2, 0, 0
  Data 10, 66, 2, 0, 10, 66, 2, 0, 0
  Data 11, 94, 2, 0, 11, 94, 2, 0, 0
  Data 12, 95, 2, 0, 12, 95, 2, 0, 0
  Data 13, 96, 2, 0, 13, 96, 2, 0, 0
  Data 14, 00, 2, 0, 14, 00, 2, 0, 0
  Data 15, 00, 2, 0, 15, 00, 2, 0, 0
  Data 16, 00, 2, 0, 16, 00, 2, 0, 0
  Data 15, 00, 2, 0, 15, 00, 2, 0, 0
  Data 14, 00, 2, 0, 14, 00, 2, 0, 0
  Data 13, 96, 2, 0, 13, 96, 2, 0, 0
  Data 12, 95, 2, 0, 12, 95, 2, 0, 0
  Data 11, 94, 2, 0, 11, 94, 2, 0, 0
  Data 10, 66, 2, 0, 10, 66, 2, 0, 0
  Data 09, 66, 2, 0, 09, 66, 2, 0, 0
  'Data 99999

  'spinning eyes (full eyes and pupils) left to right
  Data 09, 66, 2, 0, 09, 66, 2, 0, 15
  Data 09, 67, 2, 0, 09, 67, 2, 0, 15
  Data 09, 68, 2, 0, 09, 68, 2, 0, 15
  Data 09, 69, 2, 0, 09, 69, 2, 0, 15
  Data 09, 70, 2, 0, 09, 70, 2, 0, 15
  Data 09, 71, 2, 0, 09, 71, 2, 0, 15
  Data 09, 61, 2, 0, 09, 61, 2, 0, 15
  Data 09, 62, 2, 0, 09, 62, 2, 0, 15
  Data 09, 63, 2, 0, 09, 63, 2, 0, 15
  Data 09, 64, 2, 0, 09, 64, 2, 0, 15
  Data 09, 65, 2, 0, 09, 65, 2, 0, 15
  Data 09, 66, 2, 0, 09, 66, 2, 0, 15
  Data 09, 67, 2, 0, 09, 67, 2, 0, 15
  Data 09, 68, 2, 0, 09, 68, 2, 0, 15
  Data 09, 69, 2, 0, 09, 69, 2, 0, 15
  Data 09, 70, 2, 0, 09, 70, 2, 0, 15
  Data 09, 71, 2, 0, 09, 71, 2, 0, 15
  Data 09, 61, 2, 0, 09, 61, 2, 0, 15
  Data 09, 62, 2, 0, 09, 62, 2, 0, 15
  Data 09, 63, 2, 0, 09, 63, 2, 0, 15
  Data 09, 64, 2, 0, 09, 64, 2, 0, 15
  Data 09, 65, 2, 0, 09, 65, 2, 0, 15

  'spinning eyes (full eyes and pupils)right to left
  Data 09, 66, 2, 0, 09, 66, 2, 0, 15
  Data 09, 65, 2, 0, 09, 65, 2, 0, 15
  Data 09, 64, 2, 0, 09, 64, 2, 0, 15
  Data 09, 63, 2, 0, 09, 63, 2, 0, 15
  Data 09, 62, 2, 0, 09, 62, 2, 0, 15
  Data 09, 61, 2, 0, 09, 61, 2, 0, 15
  Data 09, 71, 2, 0, 09, 71, 2, 0, 15
  Data 09, 70, 2, 0, 09, 70, 2, 0, 15
  Data 09, 69, 2, 0, 09, 69, 2, 0, 15
  Data 09, 68, 2, 0, 09, 68, 2, 0, 15
  Data 09, 67, 2, 0, 09, 67, 2, 0, 15
  Data 09, 66, 2, 0, 09, 66, 2, 0, 15
  Data 09, 65, 2, 0, 09, 65, 2, 0, 15
  Data 09, 64, 2, 0, 09, 64, 2, 0, 15
  Data 09, 63, 2, 0, 09, 63, 2, 0, 15
  Data 09, 62, 2, 0, 09, 62, 2, 0, 15
  Data 09, 61, 2, 0, 09, 61, 2, 0, 15
  Data 09, 71, 2, 0, 09, 71, 2, 0, 15
  Data 09, 70, 2, 0, 09, 70, 2, 0, 15
  Data 09, 69, 2, 0, 09, 69, 2, 0, 15
  Data 09, 68, 2, 0, 09, 68, 2, 0, 15
  Data 09, 67, 2, 0, 09, 67, 2, 0, 15

  'spinning eyes (full eyes and pupils) Center to outside
  Data 09, 66, 2, 0, 09, 66, 2, 0, 15
  Data 09, 65, 2, 0, 09, 67, 2, 0, 15
  Data 09, 64, 2, 0, 09, 68, 2, 0, 15
  Data 09, 63, 2, 0, 09, 69, 2, 0, 15
  Data 09, 62, 2, 0, 09, 70, 2, 0, 15
  Data 09, 61, 2, 0, 09, 71, 2, 0, 15
  Data 09, 71, 2, 0, 09, 61, 2, 0, 15
  Data 09, 70, 2, 0, 09, 62, 2, 0, 15
  Data 09, 69, 2, 0, 09, 63, 2, 0, 15
  Data 09, 68, 2, 0, 09, 64, 2, 0, 15
  Data 09, 67, 2, 0, 09, 65, 2, 0, 15
  Data 09, 66, 2, 0, 09, 66, 2, 0, 15
  Data 09, 65, 2, 0, 09, 67, 2, 0, 15
  Data 09, 64, 2, 0, 09, 68, 2, 0, 15
  Data 09, 63, 2, 0, 09, 69, 2, 0, 15
  Data 09, 62, 2, 0, 09, 70, 2, 0, 15
  Data 09, 61, 2, 0, 09, 71, 2, 0, 15
  Data 09, 71, 2, 0, 09, 61, 2, 0, 15
  Data 09, 70, 2, 0, 09, 62, 2, 0, 15
  Data 09, 69, 2, 0, 09, 63, 2, 0, 15
  Data 09, 68, 2, 0, 09, 64, 2, 0, 15
  Data 09, 67, 2, 0, 09, 65, 2, 0, 15

  'spinning eyes (full eyes and pupils) outside to center
  Data 09, 66, 2, 0, 09, 66, 2, 0, 15
  Data 09, 67, 2, 0, 09, 65, 2, 0, 15
  Data 09, 68, 2, 0, 09, 64, 2, 0, 15
  Data 09, 69, 2, 0, 09, 63, 2, 0, 15
  Data 09, 70, 2, 0, 09, 62, 2, 0, 15
  Data 09, 71, 2, 0, 09, 61, 2, 0, 15
  Data 09, 61, 2, 0, 09, 71, 2, 0, 15
  Data 09, 62, 2, 0, 09, 70, 2, 0, 15
  Data 09, 63, 2, 0, 09, 69, 2, 0, 15
  Data 09, 64, 2, 0, 09, 68, 2, 0, 15
  Data 09, 65, 2, 0, 09, 67, 2, 0, 15
  Data 09, 66, 2, 0, 09, 66, 2, 0, 15
  Data 09, 67, 2, 0, 09, 65, 2, 0, 15
  Data 09, 68, 2, 0, 09, 64, 2, 0, 15
  Data 09, 69, 2, 0, 09, 63, 2, 0, 15
  Data 09, 70, 2, 0, 09, 62, 2, 0, 15
  Data 09, 71, 2, 0, 09, 61, 2, 0, 15
  Data 09, 61, 2, 0, 09, 71, 2, 0, 15
  Data 09, 62, 2, 0, 09, 70, 2, 0, 15
  Data 09, 63, 2, 0, 09, 69, 2, 0, 15
  Data 09, 64, 2, 0, 09, 68, 2, 0, 15
  Data 09, 65, 2, 0, 09, 67, 2, 0, 15
  Data 09, 66, 2, 0, 09, 66, 2, 0, 15
  Data 09, 67, 2, 0, 09, 65, 2, 0, 15
  Data 09, 68, 2, 0, 09, 64, 2, 0, 15
  Data 09, 69, 2, 0, 09, 63, 2, 0, 15
  Data 09, 70, 2, 0, 09, 62, 2, 0, 15
  Data 09, 71, 2, 0, 09, 61, 2, 0, 15
  Data 09, 61, 2, 0, 09, 71, 2, 0, 15
  Data 09, 62, 2, 0, 09, 70, 2, 0, 15
  Data 09, 63, 2, 0, 09, 69, 2, 0, 15
  Data 09, 64, 2, 0, 09, 68, 2, 0, 15
  Data 09, 65, 2, 0, 09, 67, 2, 0, 15
  Data 09, 66, 2, 0, 09, 66, 2, 0, 15
  Data 09, 67, 2, 0, 09, 65, 2, 0, 15
  Data 09, 68, 2, 0, 09, 64, 2, 0, 15
  Data 09, 69, 2, 0, 09, 63, 2, 0, 15
  Data 09, 70, 2, 0, 09, 62, 2, 0, 15
  Data 09, 71, 2, 0, 09, 61, 2, 0, 15
  Data 09, 61, 2, 0, 09, 71, 2, 0, 15
  Data 09, 62, 2, 0, 09, 70, 2, 0, 15
  Data 09, 63, 2, 0, 09, 69, 2, 0, 15
  Data 09, 64, 2, 0, 09, 68, 2, 0, 15
  Data 09, 65, 2, 0, 09, 67, 2, 0, 15
  Data 09, 66, 2, 0, 09, 66, 2, 0, 15
  Data 09, 67, 2, 0, 09, 65, 2, 0, 15
  Data 09, 68, 2, 0, 09, 64, 2, 0, 15
  Data 09, 69, 2, 0, 09, 63, 2, 0, 15
  Data 09, 70, 2, 0, 09, 62, 2, 0, 15
  Data 09, 71, 2, 0, 09, 61, 2, 0, 15
  Data 09, 61, 2, 0, 09, 71, 2, 0, 15
  Data 09, 62, 2, 0, 09, 70, 2, 0, 15
  Data 09, 63, 2, 0, 09, 69, 2, 0, 15
  Data 09, 64, 2, 0, 09, 68, 2, 0, 15
  Data 09, 65, 2, 0, 09, 67, 2, 0, 15
  Data 09, 66, 2, 0, 09, 66, 2, 0, 15
  Data 09, 67, 2, 0, 09, 65, 2, 0, 15
  Data 09, 68, 2, 0, 09, 64, 2, 0, 15
  Data 09, 69, 2, 0, 09, 63, 2, 0, 15
  Data 09, 70, 2, 0, 09, 62, 2, 0, 15
  Data 09, 71, 2, 0, 09, 61, 2, 0, 15
  Data 09, 61, 2, 0, 09, 71, 2, 0, 15
  Data 09, 62, 2, 0, 09, 70, 2, 0, 15
  Data 09, 63, 2, 0, 09, 69, 2, 0, 15
  Data 09, 64, 2, 0, 09, 68, 2, 0, 15
  Data 09, 65, 2, 0, 09, 67, 2, 0, 15
  Data 09, 66, 2, 0, 09, 66, 2, 0, 15
  Data 09, 67, 2, 0, 09, 65, 2, 0, 15
  Data 09, 68, 2, 0, 09, 64, 2, 0, 15
  Data 09, 69, 2, 0, 09, 63, 2, 0, 15
  Data 09, 70, 2, 0, 09, 62, 2, 0, 15
  Data 09, 71, 2, 0, 09, 61, 2, 0, 15
  Data 09, 61, 2, 0, 09, 71, 2, 0, 15
  Data 09, 62, 2, 0, 09, 70, 2, 0, 15
  Data 09, 63, 2, 0, 09, 69, 2, 0, 15
  Data 09, 64, 2, 0, 09, 68, 2, 0, 15
  Data 09, 65, 2, 0, 09, 67, 2, 0, 15
  Data 09, 66, 2, 0, 09, 66, 2, 0, 15
  Data 09, 67, 2, 0, 09, 65, 2, 0, 15
  Data 09, 68, 2, 0, 09, 64, 2, 0, 15
  Data 09, 69, 2, 0, 09, 63, 2, 0, 15
  Data 09, 70, 2, 0, 09, 62, 2, 0, 15
  Data 09, 71, 2, 0, 09, 61, 2, 0, 15
  Data 09, 61, 2, 0, 09, 71, 2, 0, 15
  Data 09, 62, 2, 0, 09, 70, 2, 0, 15
  Data 09, 63, 2, 0, 09, 69, 2, 0, 15
  Data 09, 64, 2, 0, 09, 68, 2, 0, 15
  Data 09, 65, 2, 0, 09, 67, 2, 0, 15
  Data 09, 66, 2, 0, 09, 66, 2, 0, 15

 'Round Eye blink left then right change pupils to large pupil
  Data 09, 66, 2, 0, 09, 66, 2, 0, 1500
  Data 10, 66, 2, 0, 09, 66, 2, 0, 0
  Data 11, 94, 2, 0, 09, 66, 2, 0, 0
  Data 12, 95, 2, 0, 09, 66, 2, 0, 0
  Data 13, 96, 2, 0, 09, 66, 2, 0, 0
  Data 14, 00, 2, 0, 09, 66, 2, 0, 0
  Data 15, 00, 2, 0, 09, 66, 2, 0, 0
  Data 16, 00, 2, 0, 09, 66, 2, 0, 0
  Data 15, 00, 2, 0, 09, 66, 2, 0, 0
  Data 14, 118, 2, 0, 09, 66, 2, 0, 0
  Data 13, 117, 2, 0, 09, 66, 2, 0, 0
  Data 12, 116, 2, 0, 09, 66, 2, 0, 0
  Data 11, 110, 2, 0, 09, 66, 2, 0, 0
  Data 10, 110, 2, 0, 09, 66, 2, 0, 0
  Data 09, 110, 2, 0, 09, 66, 2, 0, 0

  Data 09, 110, 2, 0, 09, 66, 2, 0, 0
  Data 09, 110, 2, 0, 10, 66, 2, 0, 0
  Data 09, 110, 2, 0, 11, 94, 2, 0, 0
  Data 09, 110, 2, 0, 12, 95, 2, 0, 0
  Data 09, 110, 2, 0, 13, 96, 2, 0, 0
  Data 09, 110, 2, 0, 14, 00, 2, 0, 0
  Data 09, 110, 2, 0, 15, 00, 2, 0, 0
  Data 09, 110, 2, 0, 16, 00, 2, 0, 0
  Data 09, 110, 2, 0, 15, 00, 2, 0, 0
  Data 09, 110, 2, 0, 14, 118, 2, 0, 0
  Data 09, 110, 2, 0, 13, 117, 2, 0, 0
  Data 09, 110, 2, 0, 12, 116, 2, 0, 0
  Data 09, 110, 2, 0, 11, 110, 2, 0, 0
  Data 09, 110, 2, 0, 10, 110, 2, 0, 0
  Data 09, 110, 2, 0, 09, 110, 2, 0, 1500

  'Look left and right then Remove left pupil and Eye then Remove Right eye
  Data 09, 110, 2, 0, 09, 110, 2, 0, 50
  Data 09, 111, 2, 0, 09, 111, 2, 0, 50
  Data 09, 112, 2, 0, 09, 112, 2, 0, 50
  Data 09, 113, 2, 0, 09, 113, 2, 0, 250
  Data 09, 112, 2, 0, 09, 112, 2, 0, 50
  Data 09, 111, 2, 0, 09, 111, 2, 0, 50
  Data 09, 110, 2, 0, 09, 110, 2, 0, 50
  Data 09, 109, 2, 0, 09, 109, 2, 0, 50
  Data 09, 108, 2, 0, 09, 108, 2, 0, 50
  Data 09, 107, 2, 0, 09, 107, 2, 0, 250
  Data 09, 108, 2, 0, 09, 108, 2, 0, 50
  Data 09, 109, 2, 0, 09, 109, 2, 0, 50
  Data 09, 110, 2, 0, 09, 110, 2, 0, 1500
  Data 09, 109, 2, 0, 09, 110, 2, 0, 50
  Data 09, 108, 2, 0, 09, 110, 2, 0, 50
  Data 09, 107, 2, 0, 09, 110, 2, 0, 50
  Data 09, 106, 2, 0, 09, 110, 2, 0, 50
  Data 09, 105, 2, 0, 09, 110, 2, 0, 50
  Data 09, 000, 2, 0, 09, 110, 2, 0, 1500
  'Look  right and left using right eye
  Data 09, 000, 2, 0, 09, 110, 2, 0, 50
  Data 09, 000, 2, 0, 09, 111, 2, 0, 50
  Data 09, 000, 2, 0, 09, 112, 2, 0, 50
  Data 09, 000, 2, 0, 09, 113, 2, 0, 250
  Data 09, 000, 2, 0, 09, 112, 2, 0, 50
  Data 09, 000, 2, 0, 09, 111, 2, 0, 50
  Data 09, 000, 2, 0, 09, 110, 2, 0, 50
  Data 09, 000, 2, 0, 09, 109, 2, 0, 50
  Data 09, 000, 2, 0, 09, 108, 2, 0, 50
  Data 09, 000, 2, 0, 09, 107, 2, 0, 250
  Data 09, 000, 2, 0, 09, 108, 2, 0, 50
  Data 09, 000, 2, 0, 09, 109, 2, 0, 50
  Data 09, 000, 2, 0, 09, 110, 2, 0, 1500
  'Blink both eyes, Only right pupil remains
  Data 10, 000, 2, 0, 10, 110, 2, 0, 0
  Data 11, 000, 2, 0, 11, 110, 2, 0, 0
  Data 12, 000, 2, 0, 12, 116, 2, 0, 0
  Data 13, 000, 2, 0, 13, 117, 2, 0, 0
  Data 14, 000, 2, 0, 14, 118, 2, 0, 0
  Data 15, 000, 2, 0, 15, 000, 2, 0, 0
  Data 16, 000, 2, 0, 16, 000, 2, 0, 0
  Data 15, 000, 2, 0, 15, 000, 2, 0, 0
  Data 14, 000, 2, 0, 14, 118, 2, 0, 0
  Data 13, 000, 2, 0, 13, 117, 2, 0, 0
  Data 12, 000, 2, 0, 12, 116, 2, 0, 0
  Data 11, 000, 2, 0, 11, 110, 2, 0, 0
  Data 10, 000, 2, 0, 10, 110, 2, 0, 0
  Data 09, 000, 2, 0, 09, 110, 2, 0, 1000
  'move right pupil off from right eye through left
  Data 09, 000, 2, 0, 09, 109, 2, 0, 20
  Data 09, 000, 2, 0, 09, 108, 2, 0, 20
  Data 09, 115, 2, 0, 09, 107, 2, 0, 20
  Data 09, 114, 2, 0, 09, 106, 2, 0, 20
  Data 09, 113, 2, 0, 09, 105, 2, 0, 20
  Data 09, 112, 2, 0, 09, 000, 2, 0, 20
  Data 09, 111, 2, 0, 09, 000, 2, 0, 20
  Data 09, 110, 2, 0, 09, 000, 2, 0, 20
  Data 09, 109, 2, 0, 09, 000, 2, 0, 20
  Data 09, 108, 2, 0, 09, 000, 2, 0, 20
  Data 09, 107, 2, 0, 09, 000, 2, 0, 20
  Data 09, 106, 2, 0, 09, 000, 2, 0, 20
  Data 09, 105, 2, 0, 09, 000, 2, 0, 20
  Data 09, 000, 2, 0, 09, 000, 2, 0, 1500

  'blink empty round eyeball away
  Data 09, 000, 2, 0, 09, 000, 2, 0, 0
  Data 10, 000, 2, 0, 10, 000, 2, 0, 0
  Data 11, 000, 2, 0, 11, 000, 2, 0, 0
  Data 12, 000, 2, 0, 12, 000, 2, 0, 0
  Data 13, 000, 2, 0, 13, 000, 2, 0, 0
  Data 14, 000, 2, 0, 14, 000, 2, 0, 0
  Data 15, 000, 2, 0, 15, 000, 2, 0, 0
  Data 16, 000, 2, 0, 16, 000, 2, 0, 0
  Data 15, 000, 2, 0, 15, 000, 2, 0, 0
  Data 14, 000, 2, 0, 14, 000, 2, 0, 0
  Data 13, 000, 2, 0, 13, 000, 2, 0, 0
  Data 12, 000, 2, 0, 12, 000, 2, 0, 0
  Data 11, 000, 2, 0, 11, 000, 2, 0, 0
  Data 10, 000, 2, 0, 10, 000, 2, 0, 0
  Data 09, 000, 2, 0, 09, 000, 2, 0, 0
  Data 10, 000, 2, 0, 10, 000, 2, 0, 0
  Data 11, 000, 2, 0, 11, 000, 2, 0, 0
  Data 12, 000, 2, 0, 12, 000, 2, 0, 0
  Data 13, 000, 2, 0, 13, 000, 2, 0, 0
  Data 14, 000, 2, 0, 14, 000, 2, 0, 0
  Data 15, 000, 2, 0, 15, 000, 2, 0, 0
  Data 16, 000, 2, 0, 16, 000, 2, 0, 0
  Data 15, 000, 2, 0, 15, 000, 2, 0, 0
  Data 14, 000, 2, 0, 14, 000, 2, 0, 0
  Data 13, 000, 2, 0, 13, 000, 2, 0, 0
  Data 12, 000, 2, 0, 12, 000, 2, 0, 0
  Data 11, 000, 2, 0, 11, 000, 2, 0, 0
  Data 10, 000, 2, 0, 10, 000, 2, 0, 0
  Data 09, 000, 2, 0, 09, 000, 2, 0, 1500
  Data 10, 000, 2, 0, 10, 000, 2, 0, 0
  Data 11, 000, 2, 0, 11, 000, 2, 0, 0
  Data 12, 000, 2, 0, 12, 000, 2, 0, 0
  Data 13, 000, 2, 0, 13, 000, 2, 0, 0
  Data 14, 000, 2, 0, 14, 000, 2, 0, 0
  Data 15, 000, 2, 0, 15, 000, 2, 0, 0
  Data 16, 000, 2, 0, 16, 000, 2, 0, 0
  Data 00, 000, 2, 0, 00, 000, 2, 0, 2000

  'Cylon Eye
  Data 00, 105, 2, 00, 00, 000, 2, 00, 35
  Data 00, 106, 2, 02, 00, 000, 2, 00, 35
  Data 00, 107, 2, 04, 00, 000, 2, 00, 35
  Data 00, 108, 2, 06, 00, 000, 2, 00, 35
  Data 00, 109, 2, 08, 00, 000, 2, 00, 35
  Data 00, 110, 2, 10, 00, 000, 2, 00, 35
  Data 00, 111, 2, 12, 00, 000, 2, 00, 35
  Data 00, 112, 2, 14, 00, 000, 2, 00, 35
  Data 00, 113, 2, 15, 00, 105, 2, 15, 35
  Data 00, 114, 2, 15, 00, 106, 2, 15, 35
  Data 00, 115, 2, 14, 00, 107, 2, 15, 35
  Data 00, 000, 2, 00, 00, 108, 2, 14, 35
  Data 00, 000, 2, 00, 00, 109, 2, 12, 35
  Data 00, 000, 2, 00, 00, 110, 2, 10, 35
  Data 00, 000, 2, 00, 00, 111, 2, 08, 35
  Data 00, 000, 2, 00, 00, 112, 2, 06, 35
  Data 00, 000, 2, 00, 00, 113, 2, 04, 35
  Data 00, 000, 2, 00, 00, 114, 2, 02, 35
  'Data 00, 000, 2, 00, 00, 115, 2, 00, 250
  Data 00, 000, 2, 00, 00, 115, 2, 00, 250
  Data 00, 000, 2, 00, 00, 114, 2, 02, 35
  Data 00, 000, 2, 00, 00, 113, 2, 04, 35
  Data 00, 000, 2, 00, 00, 112, 2, 06, 35
  Data 00, 000, 2, 00, 00, 111, 2, 08, 35
  Data 00, 000, 2, 00, 00, 110, 2, 10, 35
  Data 00, 000, 2, 00, 00, 109, 2, 12, 35
  Data 00, 000, 2, 00, 00, 108, 2, 14, 35
  Data 00, 115, 2, 14, 00, 107, 2, 15, 35
  Data 00, 114, 2, 15, 00, 106, 2, 15, 35
  Data 00, 113, 2, 15, 00, 105, 2, 15, 35
  Data 00, 112, 2, 14, 00, 000, 2, 00, 35
  Data 00, 111, 2, 12, 00, 000, 2, 00, 35
  Data 00, 110, 2, 10, 00, 000, 2, 00, 35
  Data 00, 109, 2, 08, 00, 000, 2, 00, 35
  Data 00, 108, 2, 06, 00, 000, 2, 00, 35
  Data 00, 107, 2, 04, 00, 000, 2, 00, 35
  Data 00, 106, 2, 02, 00, 000, 2, 00, 35
  'Data 00, 105, 2, 00, 00, 000, 2, 00, 250
  'Cylon Eye
  Data 00, 105, 2, 00, 00, 000, 2, 00, 250
  Data 00, 106, 2, 02, 00, 000, 2, 00, 35
  Data 00, 107, 2, 04, 00, 000, 2, 00, 35
  Data 00, 108, 2, 06, 00, 000, 2, 00, 35
  Data 00, 109, 2, 08, 00, 000, 2, 00, 35
  Data 00, 110, 2, 10, 00, 000, 2, 00, 35
  Data 00, 111, 2, 12, 00, 000, 2, 00, 35
  Data 00, 112, 2, 14, 00, 000, 2, 00, 35
  Data 00, 113, 2, 15, 00, 105, 2, 15, 35
  Data 00, 114, 2, 15, 00, 106, 2, 15, 35
  Data 00, 115, 2, 14, 00, 107, 2, 15, 35
  Data 00, 000, 2, 00, 00, 108, 2, 14, 35
  Data 00, 000, 2, 00, 00, 109, 2, 12, 35
  Data 00, 000, 2, 00, 00, 110, 2, 10, 35
  Data 00, 000, 2, 00, 00, 111, 2, 08, 35
  Data 00, 000, 2, 00, 00, 112, 2, 06, 35
  Data 00, 000, 2, 00, 00, 113, 2, 04, 35
  Data 00, 000, 2, 00, 00, 114, 2, 02, 35
  'Data 00, 000, 2, 00, 00, 115, 2, 00, 250
  Data 00, 000, 2, 00, 00, 115, 2, 00, 250
  Data 00, 000, 2, 00, 00, 114, 2, 02, 35
  Data 00, 000, 2, 00, 00, 113, 2, 04, 35
  Data 00, 000, 2, 00, 00, 112, 2, 06, 35
  Data 00, 000, 2, 00, 00, 111, 2, 08, 35
  Data 00, 000, 2, 00, 00, 110, 2, 10, 35
  Data 00, 000, 2, 00, 00, 109, 2, 12, 35
  Data 00, 000, 2, 00, 00, 108, 2, 14, 35
  Data 00, 115, 2, 14, 00, 107, 2, 15, 35
  Data 00, 114, 2, 15, 00, 106, 2, 15, 35
  Data 00, 113, 2, 15, 00, 105, 2, 15, 35
  Data 00, 112, 2, 14, 00, 000, 2, 00, 35
  Data 00, 111, 2, 12, 00, 000, 2, 00, 35
  Data 00, 110, 2, 10, 00, 000, 2, 00, 35
  Data 00, 109, 2, 08, 00, 000, 2, 00, 35
  Data 00, 108, 2, 06, 00, 000, 2, 00, 35
  Data 00, 107, 2, 04, 00, 000, 2, 00, 35
  Data 00, 106, 2, 02, 00, 000, 2, 00, 35
  'Data 00, 105, 2, 00, 00, 000, 2, 00, 250
  'Cylon Eye
  Data 00, 105, 2, 00, 00, 000, 2, 00, 250
  Data 00, 106, 2, 02, 00, 000, 2, 00, 35
  Data 00, 107, 2, 04, 00, 000, 2, 00, 35
  Data 00, 108, 2, 06, 00, 000, 2, 00, 35
  Data 00, 109, 2, 08, 00, 000, 2, 00, 35
  Data 00, 110, 2, 10, 00, 000, 2, 00, 35
  Data 00, 111, 2, 12, 00, 000, 2, 00, 35
  Data 00, 112, 2, 14, 00, 000, 2, 00, 35
  Data 00, 113, 2, 15, 00, 105, 2, 15, 35
  Data 00, 114, 2, 15, 00, 106, 2, 15, 35
  Data 00, 115, 2, 14, 00, 107, 2, 15, 35
  Data 00, 000, 2, 00, 00, 108, 2, 14, 35
  Data 00, 000, 2, 00, 00, 109, 2, 12, 35
  Data 00, 000, 2, 00, 00, 110, 2, 10, 35
  Data 00, 000, 2, 00, 00, 111, 2, 08, 35
  Data 00, 000, 2, 00, 00, 112, 2, 06, 35
  Data 00, 000, 2, 00, 00, 113, 2, 04, 35
  Data 00, 000, 2, 00, 00, 114, 2, 02, 35
  'Data 00, 000, 2, 00, 00, 115, 2, 00, 250
  Data 00, 000, 2, 00, 00, 115, 2, 00, 250
  Data 00, 000, 2, 00, 00, 114, 2, 02, 35
  Data 00, 000, 2, 00, 00, 113, 2, 04, 35
  Data 00, 000, 2, 00, 00, 112, 2, 06, 35
  Data 00, 000, 2, 00, 00, 111, 2, 08, 35
  Data 00, 000, 2, 00, 00, 110, 2, 10, 35
  Data 00, 000, 2, 00, 00, 109, 2, 12, 35
  Data 00, 000, 2, 00, 00, 108, 2, 14, 35
  Data 00, 115, 2, 14, 00, 107, 2, 15, 35
  Data 00, 114, 2, 15, 00, 106, 2, 15, 35
  Data 00, 113, 2, 15, 00, 105, 2, 15, 35
  Data 00, 112, 2, 14, 00, 000, 2, 00, 35
  Data 00, 111, 2, 12, 00, 000, 2, 00, 35
  Data 00, 110, 2, 10, 00, 000, 2, 00, 35
  Data 00, 109, 2, 08, 00, 000, 2, 00, 35
  Data 00, 108, 2, 06, 00, 000, 2, 00, 35
  Data 00, 107, 2, 04, 00, 000, 2, 00, 35
  Data 00, 106, 2, 02, 00, 000, 2, 00, 35
  'Data 00, 105, 2, 00, 00, 000, 2, 00, 250
  'Cylon Eye
  Data 00, 105, 2, 00, 00, 000, 2, 00, 250
  Data 00, 106, 2, 02, 00, 000, 2, 00, 35
  Data 00, 107, 2, 04, 00, 000, 2, 00, 35
  Data 00, 108, 2, 06, 00, 000, 2, 00, 35
  Data 00, 109, 2, 08, 00, 000, 2, 00, 35
  Data 00, 110, 2, 10, 00, 000, 2, 00, 35
  Data 00, 111, 2, 12, 00, 000, 2, 00, 35
  Data 00, 112, 2, 14, 00, 000, 2, 00, 35
  Data 00, 113, 2, 15, 00, 105, 2, 15, 35
  Data 00, 114, 2, 15, 00, 106, 2, 15, 35
  Data 00, 115, 2, 14, 00, 107, 2, 15, 35
  Data 00, 000, 2, 00, 00, 108, 2, 14, 35
  Data 00, 000, 2, 00, 00, 109, 2, 12, 35
  Data 00, 000, 2, 00, 00, 110, 2, 10, 35
  Data 00, 000, 2, 00, 00, 111, 2, 08, 35
  Data 00, 000, 2, 00, 00, 112, 2, 06, 35
  Data 00, 000, 2, 00, 00, 113, 2, 04, 35
  Data 00, 000, 2, 00, 00, 114, 2, 02, 35
  'Data 00, 000, 2, 00, 00, 115, 2, 00, 250
  Data 00, 000, 2, 00, 00, 115, 2, 00, 250
  Data 00, 000, 2, 00, 00, 114, 2, 02, 35
  Data 00, 000, 2, 00, 00, 113, 2, 04, 35
  Data 00, 000, 2, 00, 00, 112, 2, 06, 35
  Data 00, 000, 2, 00, 00, 111, 2, 08, 35
  Data 00, 000, 2, 00, 00, 110, 2, 10, 35
  Data 00, 000, 2, 00, 00, 109, 2, 12, 35
  Data 00, 000, 2, 00, 00, 108, 2, 14, 35
  Data 00, 115, 2, 14, 00, 107, 2, 15, 35
  Data 00, 114, 2, 15, 00, 106, 2, 15, 35
  Data 00, 113, 2, 15, 00, 105, 2, 15, 35
  Data 00, 112, 2, 14, 00, 000, 2, 00, 35
  Data 00, 111, 2, 12, 00, 000, 2, 00, 35
  Data 00, 110, 2, 10, 00, 000, 2, 00, 35
  Data 00, 109, 2, 08, 00, 000, 2, 00, 35
  Data 00, 108, 2, 06, 00, 000, 2, 00, 35
  Data 00, 107, 2, 04, 00, 000, 2, 00, 35
  Data 00, 106, 2, 02, 00, 000, 2, 00, 35
  'Data 00, 105, 2, 00, 00, 000, 2, 00, 250

  'move right pupil through left eye into right
  Data 00, 105, 2, 02, 00, 000, 2, 02, 250
  Data 00, 106, 2, 02, 00, 000, 2, 02, 35
  Data 00, 107, 2, 02, 00, 000, 2, 02, 35
  Data 00, 108, 2, 02, 00, 000, 2, 02, 35
  Data 00, 109, 2, 02, 00, 000, 2, 02, 35
  Data 00, 110, 2, 02, 00, 000, 2, 02, 35
  Data 00, 111, 2, 02, 00, 000, 2, 02, 35
  Data 00, 112, 2, 02, 00, 000, 2, 02, 35
  Data 00, 113, 2, 02, 00, 105, 2, 02, 35
  Data 00, 114, 2, 02, 00, 106, 2, 02, 35
  Data 00, 115, 2, 02, 00, 107, 2, 02, 35
  Data 00, 000, 2, 02, 00, 108, 2, 02, 35
  Data 00, 000, 2, 02, 00, 109, 2, 02, 35
  Data 00, 000, 2, 02, 00, 110, 2, 02, 500
  'move left pupil in position
  Data 00, 105, 2, 02, 00, 110, 2, 02, 35
  Data 00, 106, 2, 02, 00, 110, 2, 02, 35
  Data 00, 107, 2, 02, 00, 110, 2, 02, 35
  Data 00, 108, 2, 02, 00, 110, 2, 02, 35
  Data 00, 109, 2, 02, 00, 110, 2, 02, 35
  Data 00, 110, 2, 02, 00, 110, 2, 02, 1000

  'Vary the brightness of eye
  Data 00, 110, 2, 03, 00, 110, 2, 03, 100
  Data 00, 110, 2, 04, 00, 110, 2, 04, 100
  Data 00, 110, 2, 05, 00, 110, 2, 05, 100
  Data 00, 110, 2, 06, 00, 110, 2, 06, 100
  Data 00, 110, 2, 07, 00, 110, 2, 07, 100
  Data 00, 110, 2, 08, 00, 110, 2, 08, 100
  Data 00, 110, 2, 09, 00, 110, 2, 09, 100
  Data 00, 110, 2, 10, 00, 110, 2, 10, 100
  Data 00, 110, 2, 11, 00, 110, 2, 11, 100
  Data 00, 110, 2, 12, 00, 110, 2, 12, 100
  Data 00, 110, 2, 13, 00, 110, 2, 13, 100
  Data 00, 110, 2, 14, 00, 110, 2, 14, 100
  Data 00, 110, 2, 15, 00, 110, 2, 15, 100
  Data 00, 110, 2, 14, 00, 110, 2, 14, 100
  Data 00, 110, 2, 13, 00, 110, 2, 13, 100
  Data 00, 110, 2, 12, 00, 110, 2, 12, 100
  Data 00, 110, 2, 11, 00, 110, 2, 11, 100
  Data 00, 110, 2, 10, 00, 110, 2, 10, 100
  Data 00, 110, 2, 09, 00, 110, 2, 09, 100
  Data 00, 110, 2, 08, 00, 110, 2, 08, 100
  Data 00, 110, 2, 07, 00, 110, 2, 07, 100
  Data 00, 110, 2, 06, 00, 110, 2, 06, 100
  Data 00, 110, 2, 05, 00, 110, 2, 05, 100
  Data 00, 110, 2, 04, 00, 110, 2, 04, 100
  Data 00, 110, 2, 03, 00, 110, 2, 03, 100
  Data 00, 110, 2, 02, 00, 110, 2, 02, 100
  Data 00, 110, 2, 01, 00, 110, 2, 01, 100
  Data 00, 110, 2, 00, 00, 110, 2, 00, 100
  Data 00, 110, 2, 01, 00, 110, 2, 01, 100
  Data 00, 110, 2, 02, 00, 110, 2, 02, 100
  Data 00, 110, 2, 03, 00, 110, 2, 03, 100
  Data 00, 110, 2, 04, 00, 110, 2, 04, 100
  Data 00, 110, 2, 05, 00, 110, 2, 05, 100
  Data 00, 110, 2, 06, 00, 110, 2, 06, 100
  Data 00, 110, 2, 07, 00, 110, 2, 07, 100
  Data 00, 110, 2, 08, 00, 110, 2, 08, 100
  Data 00, 110, 2, 09, 00, 110, 2, 09, 100
  Data 00, 110, 2, 10, 00, 110, 2, 10, 100
  Data 00, 110, 2, 11, 00, 110, 2, 11, 100
  Data 00, 110, 2, 12, 00, 110, 2, 12, 100
  Data 00, 110, 2, 13, 00, 110, 2, 13, 100
  Data 00, 110, 2, 14, 00, 110, 2, 14, 100
  Data 00, 110, 2, 15, 00, 110, 2, 15, 100
  Data 00, 110, 2, 14, 00, 110, 2, 14, 100
  Data 00, 110, 2, 13, 00, 110, 2, 13, 100
  Data 00, 110, 2, 12, 00, 110, 2, 12, 100
  Data 00, 110, 2, 11, 00, 110, 2, 11, 100
  Data 00, 110, 2, 10, 00, 110, 2, 10, 100
  Data 00, 110, 2, 09, 00, 110, 2, 09, 100
  Data 00, 110, 2, 08, 00, 110, 2, 08, 100
  Data 00, 110, 2, 07, 00, 110, 2, 07, 100
  Data 00, 110, 2, 06, 00, 110, 2, 06, 100
  Data 00, 110, 2, 05, 00, 110, 2, 05, 100
  Data 00, 110, 2, 04, 00, 110, 2, 04, 100
  Data 00, 110, 2, 03, 00, 110, 2, 03, 100
  Data 00, 110, 2, 02, 00, 110, 2, 02, 100
  Data 00, 110, 2, 01, 00, 110, 2, 01, 100
  Data 00, 110, 2, 00, 00, 110, 2, 00, 100
  Data 00, 110, 2, 01, 00, 110, 2, 01, 100
  Data 00, 110, 2, 02, 00, 110, 2, 02, 100
  Data 00, 110, 2, 03, 00, 110, 2, 03, 100
  Data 00, 110, 2, 04, 00, 110, 2, 04, 100
  Data 00, 110, 2, 05, 00, 110, 2, 05, 100
  Data 00, 110, 2, 06, 00, 110, 2, 06, 100
  Data 00, 110, 2, 07, 00, 110, 2, 07, 100
  Data 00, 110, 2, 08, 00, 110, 2, 08, 100
  Data 00, 110, 2, 09, 00, 110, 2, 09, 100
  Data 00, 110, 2, 10, 00, 110, 2, 10, 100
  Data 00, 110, 2, 11, 00, 110, 2, 11, 100
  Data 00, 110, 2, 12, 00, 110, 2, 12, 100
  Data 00, 110, 2, 13, 00, 110, 2, 13, 100
  Data 00, 110, 2, 14, 00, 110, 2, 14, 100
  Data 00, 110, 2, 15, 00, 110, 2, 15, 100
  Data 00, 110, 2, 14, 00, 110, 2, 14, 100
  Data 00, 110, 2, 13, 00, 110, 2, 13, 100
  Data 00, 110, 2, 12, 00, 110, 2, 12, 100
  Data 00, 110, 2, 11, 00, 110, 2, 11, 100
  Data 00, 110, 2, 10, 00, 110, 2, 10, 100
  Data 00, 110, 2, 09, 00, 110, 2, 09, 100
  Data 00, 110, 2, 08, 00, 110, 2, 08, 100
  Data 00, 110, 2, 07, 00, 110, 2, 07, 100
  Data 00, 110, 2, 06, 00, 110, 2, 06, 100
  Data 00, 110, 2, 05, 00, 110, 2, 05, 100
  Data 00, 110, 2, 04, 00, 110, 2, 04, 100
  Data 00, 110, 2, 03, 00, 110, 2, 03, 100
  Data 00, 110, 2, 02, 00, 110, 2, 02, 100
  Data 00, 110, 2, 01, 00, 110, 2, 01, 100
  Data 00, 110, 2, 00, 00, 110, 2, 00, 100
  Data 00, 110, 2, 01, 00, 110, 2, 01, 100
  Data 00, 110, 2, 02, 00, 110, 2, 02, 100
  Data 00, 110, 2, 03, 00, 110, 2, 03, 100
  Data 00, 110, 2, 04, 00, 110, 2, 04, 100
  Data 00, 110, 2, 05, 00, 110, 2, 05, 100
  Data 00, 110, 2, 06, 00, 110, 2, 06, 100
  Data 00, 110, 2, 07, 00, 110, 2, 07, 100
  Data 00, 110, 2, 08, 00, 110, 2, 08, 100
  Data 00, 110, 2, 09, 00, 110, 2, 09, 100
  Data 00, 110, 2, 10, 00, 110, 2, 10, 100
  Data 00, 110, 2, 11, 00, 110, 2, 11, 100
  Data 00, 110, 2, 12, 00, 110, 2, 12, 100
  Data 00, 110, 2, 13, 00, 110, 2, 13, 100
  Data 00, 110, 2, 14, 00, 110, 2, 14, 100
  Data 00, 110, 2, 15, 00, 110, 2, 15, 100
  Data 00, 110, 2, 14, 00, 110, 2, 14, 100
  Data 00, 110, 2, 13, 00, 110, 2, 13, 100
  Data 00, 110, 2, 12, 00, 110, 2, 12, 100
  Data 00, 110, 2, 11, 00, 110, 2, 11, 100
  Data 00, 110, 2, 10, 00, 110, 2, 10, 100
  Data 00, 110, 2, 09, 00, 110, 2, 09, 100
  Data 00, 110, 2, 08, 00, 110, 2, 08, 100
  Data 00, 110, 2, 07, 00, 110, 2, 07, 100
  Data 00, 110, 2, 06, 00, 110, 2, 06, 100
  Data 00, 110, 2, 05, 00, 110, 2, 05, 100
  Data 00, 110, 2, 04, 00, 110, 2, 04, 100
  Data 00, 110, 2, 03, 00, 110, 2, 03, 100
  Data 00, 110, 2, 02, 00, 110, 2, 02, 100
  Data 00, 110, 2, 01, 00, 110, 2, 01, 100
  Data 00, 110, 2, 00, 00, 110, 2, 00, 1000

  'Blink round eye back on
  Data 16, 110, 2, 02, 16, 110, 2, 02, 0
  Data 15, 110, 2, 02, 15, 110, 2, 02, 0
  Data 14, 110, 2, 02, 14, 110, 2, 02, 0
  Data 13, 110, 2, 02, 13, 110, 2, 02, 0
  Data 12, 110, 2, 00, 12, 110, 2, 00, 0
  Data 11, 110, 2, 00, 11, 110, 2, 00, 0
  Data 10, 110, 2, 00, 10, 110, 2, 00, 0
  Data 09, 110, 2, 00, 09, 110, 2, 00, 1000

  'Round Eye blink with change pupil to round
  Data 09, 110, 2, 0, 09, 110, 2, 0, 0
  Data 10, 110, 2, 0, 10, 110, 2, 0, 0
  Data 11, 110, 2, 0, 11, 110, 2, 0, 0
  Data 12, 116, 2, 0, 12, 116, 2, 0, 0
  Data 13, 117, 2, 0, 13, 117, 2, 0, 0
  Data 14, 118, 2, 0, 14, 118, 2, 0, 0
  Data 15, 00, 2, 0, 15, 00, 2, 0, 0
  Data 16, 00, 2, 0, 16, 00, 2, 0, 0
  Data 15, 00, 2, 0, 15, 00, 2, 0, 0
  Data 14, 00, 2, 0, 14, 00, 2, 0, 0
  Data 13, 00, 2, 0, 13, 00, 2, 0, 0
  Data 12, 00, 2, 0, 12, 00, 2, 0, 0
  Data 11, 66, 2, 0, 11, 66, 2, 0, 0
  Data 10, 66, 2, 0, 10, 66, 2, 0, 0
  Data 09, 66, 2, 0, 09, 66, 2, 0, 1500

  'Round Eye blink left then right change pupil \ /
  Data 09, 66, 2, 0, 09, 66, 2, 0, 1500
  Data 10, 66, 2, 0, 09, 66, 2, 0, 0
  Data 11, 94, 2, 0, 09, 66, 2, 0, 0
  Data 12, 95, 2, 0, 09, 66, 2, 0, 0
  Data 13, 96, 2, 0, 09, 66, 2, 0, 0
  Data 14, 00, 2, 0, 09, 66, 2, 0, 0
  Data 15, 00, 2, 0, 09, 66, 2, 0, 0
  Data 16, 00, 2, 0, 09, 66, 2, 0, 0
  Data 15, 00, 2, 0, 09, 66, 2, 0, 0
  Data 14, 00, 2, 0, 09, 66, 2, 0, 0
  Data 13, 00, 2, 0, 09, 66, 2, 0, 0
  Data 12, 00, 2, 0, 09, 66, 2, 0, 0
  Data 11, 47, 3, 0, 09, 66, 2, 0, 0
  Data 10, 47, 3, 0, 09, 66, 2, 0, 0
  Data 09, 47, 3, 0, 09, 66, 2, 0, 0
  Data 09, 47, 3, 0, 09, 66, 2, 0, 0
  Data 09, 47, 3, 0, 10, 66, 2, 0, 0
  Data 09, 47, 3, 0, 11, 94, 2, 0, 0
  Data 09, 47, 3, 0, 12, 95, 2, 0, 0
  Data 09, 47, 3, 0, 13, 96, 2, 0, 0
  Data 09, 47, 3, 0, 14, 00, 2, 0, 0
  Data 09, 47, 3, 0, 15, 00, 2, 0, 0
  Data 09, 47, 3, 0, 16, 00, 2, 0, 0
  Data 09, 47, 3, 0, 15, 00, 2, 0, 0
  Data 09, 47, 3, 0, 14, 00, 2, 0, 0
  Data 09, 47, 3, 0, 13, 00, 2, 0, 0
  Data 09, 47, 3, 0, 12, 00, 2, 0, 0
  Data 09, 47, 3, 0, 11, 56, 3, 0, 0
  Data 09, 47, 3, 0, 10, 56, 3, 0, 0
  Data 09, 47, 3, 0, 09, 56, 3, 0, 1500

  'Round Eye blink with change pupil to square
  Data 09, 47, 3, 0, 09, 56, 3, 0, 0
  Data 10, 47, 3, 0, 10, 56, 3, 0, 0
  Data 11, 47, 3, 0, 11, 56, 3, 0, 0
  Data 12, 00, 2, 0, 12, 00, 2, 0, 0
  Data 13, 00, 2, 0, 13, 00, 2, 0, 0
  Data 14, 00, 2, 0, 14, 00, 2, 0, 0
  Data 15, 00, 2, 0, 15, 00, 2, 0, 0
  Data 16, 00, 2, 0, 16, 00, 2, 0, 0
  Data 15, 00, 2, 0, 15, 00, 2, 0, 0
  Data 14, 00, 2, 0, 14, 00, 2, 0, 0
  Data 13, 00, 2, 0, 13, 00, 2, 0, 0
  Data 12, 00, 2, 0, 12, 00, 2, 0, 0
  Data 11, 30, 3, 0, 11, 30, 3, 0, 0
  Data 10, 30, 3, 0, 10, 30, 3, 0, 0
  Data 09, 30, 3, 0, 09, 30, 3, 0, 1500

  ' close round eye and open as diamond
  Data 10, 30, 3, 0, 10, 30, 3, 0, 0
  Data 11, 30, 3, 0, 11, 30, 3, 0, 0
  Data 12, 30, 3, 0, 12, 30, 3, 0, 0
  Data 13, 00, 2, 0, 13, 00, 2, 0, 0
  Data 14, 00, 2, 0, 14, 00, 2, 0, 0
  Data 15, 00, 2, 0, 15, 00, 2, 0, 0
  Data 16, 00, 2, 0, 16, 00, 2, 0, 0
  Data 08, 00, 3, 0, 08, 00, 3, 0, 0
  Data 07, 00, 3, 0, 07, 00, 3, 0, 0
  Data 06, 00, 3, 0, 06, 00, 3, 0, 0
  Data 05, 00, 3, 0, 05, 00, 3, 0, 0
  Data 04, 30, 3, 0, 04, 30, 3, 0, 0
  Data 03, 30, 3, 0, 03, 30, 3, 0, 0
  Data 02, 30, 3, 0, 02, 30, 3, 0, 0

  'Data 99999       