'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
' Super Clock
' Geoff Graham, April 2016
' WiFi and MP3 added by Jman
' Requires MMBasic 5.1 or later and an ILI9341 based LCD panel with touch
' Plus a DS3231 Real Time Clock or a GPS module or a ESP8266 WiFi module
'
PWM 2, 1000, 65         'LCD Backlight
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Option Explicit
Option Default None
Option AutoRun On

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Special options
Const maxclocks = 19            ' the number of clocks is this plus 1
Const OptionDisplayDate = 1     ' set to zero if you do not want the day/date

' position and size of the analogue clock dial
Const ana.x = MM.HRes/2
Const ana.y = MM.VRes/2 + 11
Const ana.r = MM.VRes/2 - 14
'
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Don't like the colour scheme?  You can change the colours here!
'
Const c.background = RGB(black) ' background colour of the clock
Const c.title = RGB(255, 255 ,255)' the title on each clock

' colours used in the analogue clock
Const c.face = RGB(32, 32, 96)
Const c.bezel = RGB(white)
Const c.majormark = RGB(green)
Const c.minormark = RGB(green)
Const c.hourhand = RGB(yellow)
Const c.minutehand = RGB(cyan)
Const c.secondhand = RGB(red)

Const c.digital = RGB(cyan)    ' colours used in the digital clock
Const c.date = RGB(0, 244, 0)  ' colour of the day/date

' colours used in the menus
Const c.caption = RGB(green)
Const c.button = RGB(cyan)
Const c.save = RGB(white)
Const c.delete = RGB(magenta)
Const c.entry = RGB(yellow)
Const c.special = RGB(red)
Const c.ghosttext = RGB(gray)

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

' these variables ase saved and restored by the VAR command
Dim Float ClockNbr = 0
Dim Integer TZ(maxclocks)
Dim Float ClockType(maxclocks) = (3, 1, 1, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
Dim String Title(maxclocks) Length 14 = ("UTC/GMT","PERTH (WST)","SYDNEY (EST)","NEW YORK","PARIS","#6","#7","#8","#9","#10","#11","#12","#13","#14","#15","#16","#17","#18","#19","#20")
Dim Float SM(maxclocks), SW(maxclocks), SD(maxclocks)
Dim Float EM(maxclocks), EW(maxclocks), ED(maxclocks)


'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

' general global variables
Dim string arg$(20), OldTime$
Dim Float PrevClockType, TimeSource
Dim Integer i, PrevSec, NotSyncTime

' globals used by Sub DrawButton
Dim Integer key_coord(17, 5)
Dim String key_caption(17)

' globals used by CSub DrawTriangles
Dim Integer x1(3), y1(3), x2(3), y2(3), x3(3), y3(3)
Dim Integer c(3) = (c.face, c.face, c.hourhand, c.minutehand)

' various arrayed constants
Dim string baud(5) LENGTH 8 = ("", "4800", "9600", "14400", "19200", "38400")
Dim Integer md(12) = (0, 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334)
Dim String mths(12) LENGTH 8 = ("Disabled", "Jan", "Feb", "March", "April", "May", "June", "July", "Aug", "Sept", "Oct", "Nov", "Dec")
Dim String days(6) LENGTH 10 = ("Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday")
Dim String abrevdays(6) LENGTH 8 = ("Sunday", "Monday", " Tues ", " Wedn ", "Thurs ", "Friday", " Sat  ")
Dim String dstdow(3) LENGTH 8 = ("1st ", "2nd ", "3rd ", "Last ")

' globals holding the current time (updated every second)
Dim Integer UTC    ' tracks UTC time in seconds since midnight 1st Jan 2014
Dim Integer tyear, tmth, tday, tdow, thour, tmin, tsec, tdst
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Added by Jman For WiFi
Dim Integer Lcount, LEAP, Jan2014 ,Year ,SecondsInYear, Echo, LeapMnth
Dim Integer SecondsInMonth, Month, Day, Hour, Min, Sec, DST, Timeout
Dim Integer Error
Dim LB%, LB1%, LB2%
Dim Integer Months(12)
Dim String Lines$(48)           'UDP data array
Dim String SSID$, Passwd$, NTP$, Channel$, a$, s$, IP$
Dim String lw1$, lw2$, lw3$, lw4$, cmd$, Resp$, Addr$

Timeout=5000
Echo=0                         ' Set debug off=0 on=1
Error=0
Channel$="1"
Lines$(1)=Chr$(27)             '1st byte Minimum requirement for valid respone
Lines$(2)=""                   'Incase we end up back here
NTP$="192.168.0.100"           ' "time.nist.gov"           'NTP Server
LeapMnth=2505600               'Seconds in Leap Year February
Lcount=48

For I = 1 To 47                'Load next 47 bytes with null
 Lines$(2)=Lines$(2)+Chr$(0)
Next I

For I=1 To 12
 Read Months(I)
Next I
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Added by Jman for MP3
Dim Integer CCMD(10)              'MP3 Module array
Dim Integer F, FOLDER, TRACK, CCMDADD, CHECKSUM
Dim Integer MP3busy, Vol, MP3Hour, MP3Minute, STVol, MP3
Dim String  REPLY$, RP$

CCMD(1)=&H7E:CCMD(2)=&HFF  'MP3 Module commands
CCMD(3)=&H06:CCMD(4)=&H00
CCMD(5)=&H00:CCMD(6)=&H00
CCMD(7)=&H00:CCMD(8)=&H00
CCMD(9)=&H00:CCMD(10)=&HEF

Open "COM2:9600" As #2   'Open serial port for MP3 Module

MP3Busy = 31             'MP3 Module Busy Signal Pin
SetPin (MP3Busy), DIN    'MP3 Busy Signal
MP3 = 1                  '1 to enable MP3
If MP3 = 1 Then SetupMP3 'Prep MP3 Module

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' start of the program
CLS
If Touch(X) <> -1 Then WiFiSetup        'WiFi Setup if screen touced on start

' test if the RTC is present
I2C Open 100, 200, PU
I2C Write &H68, 0, 1, 0
If MM.I2C <> 0 Then I2C Write &H51, 0, 1, 2
If MM.I2C = 0 Then
  TimeSource = 1
  RTC GetTime
  If Date$ = "01-01-2000" Then
    MessageBox "RTC has invalid", "date and time"
    RTC SetTime 16, 1, 1, 0, 0, 0
    Time$ = "00:00:00" : Date$ = "01/01/16"
  EndIf
  SetTick 600000, RtcSetTime     ' update the internal clock every 10 minutes
Else
  CLS
  Text MM.HRes/2, MM.VRes/2 - 20, "RTC not found", CM, 1, 2, RGB(white)
  Text MM.HRes/2, MM.VRes/2 + 20, "Checking for WiFi", CM, 1, 2, RGB(white)
  WatchDog 6000
  CheckWiFI                      'Check WiFi Module and Connection
  If TimeSource = 2 Then
   SetTick 600000, GetNTP        ' update the internal clock every 10 minutes
   GoTo ExitGPS
  EndIf

  CLS
  Text MM.HRes/2, MM.VRes/2 - 20, "WiFi not found", CM, 1, 2, RGB(white)
  Text MM.HRes/2, MM.VRes/2 + 20, "Checking for GPS", CM, 1, 2, RGB(white)
  For i = 1 To 5
    WatchDog 4000
    Open "COM1:" + baud(i) As #1
    Pause 1000
    If Instr(Input$(255, #1), "$GP") > 0 Then TimeSource = 3 : GoTo ExitGPS
    Close #1
    WatchDog 4000
    Open "COM1:" + baud(i) + ",INV" As #1
    Pause 1000
    If Instr(Input$(255, #1), "$GP") > 0 Then TimeSource = 3 : GoTo ExitGPS
    Close #1
  Next i

 CLS
  MessageBox "No Time Source", "Time is not set"
  TimeSource = 0
  Time$ = "00:00:00" : Date$ = "01/01/16"
EndIf

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
ExitGPS:

If TimeSource = 3 Then
  Do
    WatchDog 4000
    GetRMCRecord
    If arg$(2) = "V" Then                      ' "V" means not locked on
      CLS
      Text MM.HRes/2, MM.VRes/2 - 20, "Searching For", CM, 1, 2, RGB(white)
      Text MM.HRes/2, MM.VRes/2 + 20, "Satellites", CM, 1, 2, RGB(white)
      Continue Do                              ' go around again and keep looking
    EndIf
  Loop While arg$(2) = "V"
EndIf

If TimeSource = 2 Then GetNTP                'Use WiFi for NTP

' initially set UTC
UTC = GetSec(Val(Right$(Date$, 2)), Val(Mid$(Date$, 4, 2)), Val(Left$(Date$, 2)), Val(Left$(Time$, 2)), Val(Mid$(Time$, 4, 2)), Val(Right$(Time$, 2)))
GetLocalTime

' set the initial defaults, these will be overwritten if VAR SAVE has been used
TZ(1) = 28800 : TZ(2) = 36000 : TZ(3) = -18000 : TZ(4) = 3600
SM(2) = 10 : EM(2) = 4
SM(3) = 3 : SW(3) = 1 : EM(3) = 11
SM(4) = 3 : SW(4) = 3 : EM(4) = 10 : EW(4) = 3
VAR Restore

' setup the initial display.
InitClock

' the main program loop
Do
  WatchDog 5000                               ' reset after 5 seconds of no activity

  ' once a second get the time
  ' this will exit immediately if the screen is touched so that the following code can process the touch
  If TimeSource < 3 Then
    Do While OldTime$ = Time$ And Touch(x) = -1 : Loop
    OldTime$ = Time$
  Else
    arg$(0) = ""
    GetRMCRecord
    If arg$(2) = "A" Then                      ' "A" means locked on
      NotSyncTime = UTC
    Else
      ' if we have not got sync after 24 hours reset CPU
      If UTC - NotSyncTime > 24 * 3600 Then CPU Reset
    EndIf
  EndIf

  ' check if we need to process a touch or simply update the time
  Select Case Touch(X)
    Case 0 To 120
      ' previous clock
      Do : Loop Until Touch(X) = -1           ' wait for the touch to be lifted
      Do
     If MP3 = 0 Then
      ClockNbr = ClockNbr - 1
       If ClockNbr < 0 Then ClockNbr = maxclocks
     Loop While ClockType(ClockNbr) = 0
     VAR Save ClockNbr
     InitClock
     Else
      SayTime                   ' Play the time
    EndIf
    Case 121 To 219
      ' configure
      Do : Loop Until Touch(X) = -1           ' wait for the touch to be lifted
       ConfigureMenu
       PrevClockType = 0
       InitClock
    Case 220 To 340
      ' next clock
      Do : Loop Until Touch(X) = -1           ' wait for the touch to be lifted
      Do
        ClockNbr = (ClockNbr + 1) Mod (maxclocks + 1)
      Loop While ClockType(ClockNbr) = 0
      VAR Save ClockNbr
      InitClock
    Case Else
    ' update the time display.  the maximum time needed to excute the update is 80mS
    UTC = GetSec(Val(Right$(Date$, 2)), Val(Mid$(Date$, 4, 2)), Val(Left$(Date$, 2)), Val(Left$(Time$, 2)), Val(Mid$(Time$, 4, 2)), Val(Right$(Time$, 2)))
    GetLocalTime
    If ClockType(ClockNbr) = 1 Then
      UpdateAnalog tsec, tmin, thour
    Else
      If ClockType(ClockNbr) = 2 And tmin = 0 And tsec = 0 And (thour = 1 Or thour = 10 Or thour = 13 Or thour = 22) Then PrevClockType = 0 : InitClock
      UpdateDigital tsec, tmin, thour
    EndIf
  End Select
Loop


''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' subroutine to get a GPS record into the array arg$()
Sub GetGPSRecord
  Local integer i
  Local string x$
  Do
    Do While Input$(1, #1) <> "$"
      If Touch(x) <> -1 Then Exit Sub      ' exit if the screen has been touched
    Loop   ' wait for the start
    For i = 0 To 20
      arg$(i) = ""                         ' clear ready for data
      Do                                   ' loops until a specific exit
        If Touch(x) <> -1 Then Exit Sub    ' exit if the screen has been touched
        x$ = Input$(1, #1)                 ' get the character
        If x$ = "," Then Exit Do           ' new data item, new field
        If x$ = "*" Then Exit Sub          ' end of record, so return with it
        arg$(i) = arg$(i) + x$             ' add to the data
      Loop                                 ' keep going
    Next i                                 ' increment the field
  Loop
End Sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' subroutine to get a GPS record into the array arg$()
Sub GetRMCRecord
  Do
    If Touch(x) <> -1 Then Exit Sub      ' exit if the screen has been touched
    GetGPSRecord
  Loop Until arg$(0) = "GPRMC"           ' we only want the RMC record
  If Val(Right$(arg$(9), 2)) >= 16 Then  ' sanity check
    ' set the date
    Date$ = Left$(arg$(9), 2) + "/" + Mid$(arg$(9), 3, 2) + "/" + Right$(arg$(9), 2)
    Time$ = Left$(arg$(1), 2) + ":" + Mid$(arg$(1), 3, 2) + ":" + Mid$(arg$(1), 5, 2)
  Else
    arg$(2) = "V"
  EndIf
End Sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Added by Jman
'Sub to get time from NTP Server
Sub GetNTP
Open "COM1:115200, 1024" As #1  'Module must be set to same rate
ClearBuffer
Timer=0
SendCmd "AT+CIPMUX=1", "OK" : Delay
SendCmd "AT+CIPSTART=1,"+Chr$(34)+"UDP"+Chr$(34)+","+Chr$(34)+NTP$+Chr$(34)+",123","OK"
Delay
Print #1, "AT+CIPSEND=1,48" : Delay
Print #1, Lines$(1)+Lines$(2) : Delay
Print #1,"AT+CIPCLOSE=1" : Delay
s$=""

Do
a$=""
a$ = Input$(1, #1)

If Len(s$) >= 254 Then s$ = Right$(s$, 125)
If Asc(a$) >= 32 Then s$ = s$ + a$
Loop Until Right$(s$,10)="+IPD,1,48:"

IP$ = Input$(48, #1)

lw1$=Str$(Asc(Mid$(ip$,41,1)))  'Extract 1st Byte
lw2$=Str$(Asc(Mid$(ip$,42,1)))  'Extract 2nd Byte
lw3$=Str$(Asc(Mid$(ip$,43,1)))  'Extract 3rd Byte
lw4$=Str$(Asc(Mid$(ip$,44,1)))  'Extract 4th Byte
lb1% = Val(lw1$) << 8
lb1% = (lb1% Or Val(lw2$)) <<16 'MSB 32 Bit Number
lb2% = Val(lw3$) << 8
lb2% = lb2% Or Val(lw4$)        'LSB 32 Bit Number

LB% = LB1% Or LB2%
LB% = LB% - 2208988800          ' - 70 Years start @ 1/1/1970 Epoch time
LB% = LB% + Cint(Timer/1000)    'Add time lost during conversion

Jan2014 = LB% - 1388534400      'Start at Jan 1/1/2014
Year=2014                       'Set Year to 2014

GetYear:
 Leap = Year Mod 4              '0 if leap year
   If LEAP = 0 Then
    SecondsInYear = 31622400    '366*60*60*24
   Else
    SecondsInYear = 31536000    '365*60*60*24
   EndIf
  If Jan2014 > SecondsInYear Then
   Jan2014 = Jan2014 - SecondsInyear
   Year = Year + 1
    GoTo GetYear
  EndIf

Month = 1 ' Start with Month = 1

GetMonth:
SecondsInMonth = Months(Month)
 If Leap = 0 Then
   If Month = 2 Then
   SecondsInMonth=LeapMnth
 EndIf
   EndIf
 If Jan2014 >= SecondsInMonth Then
   Jan2014 = Jan2014 - SecondsInMonth
   Month = Month+1
   GoTo GetMonth
 EndIf

FindDays:
Day = Int(Jan2014/86400)
Jan2014 = Jan2014 Mod 86400
Hour = Int(Jan2014/3600)
Jan2014 = Jan2014 Mod 3600
Min = Int(Jan2014/60)
Jan2014 = Jan2014 Mod 60
Sec = Jan2014
Day = Day + 1


Date$=Str$(Day)+"/"+Str$(Month)+"/"+Str$(Year)

If Hour=24 Then hour=0
Time$=Str$(Hour)+":"+Str$(Min)+":"+Str$(Sec)

Close #1
End Sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' subroutines involved with updating the clock display
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

' initial setup of the clock (either analogue or digital)
Sub InitClock
  Local Float i, y, xx, yy, r1, r2, tim
  GetLocalTime
  If ClockType(ClockNbr) = 1 Then   ' if analogue
    If PrevClockType = 1 Then       ' if the previous clock was analogue
      Text MM.HRes/2, -3, "      " + Title(ClockNbr) + "      ", CT, 1, 2, c.title, c.background
      Circle ana.x, ana.y, ana.r - 21, 0, 1, 0, c.face
    Else
      ' draw the full analogue clock face
      CLS c.background
      Text MM.HRes/2, -3, "      " + Title(ClockNbr) + "      ", CT, 1, 2, c.title, c.background
      Circle ana.x, ana.y, ana.r, 5, 1, c.bezel, c.face
      For i = 0 To 59
        If i Mod 15 = 0 Then
          For y = -2 To +2
            tim = (i + y/10) : xx = Cos(Rad(tim * 6)) : yy = Sin(Rad(tim * 6))
            r1 = ana.r - 20 : r2 = ana.r - 5
            Line  ana.x + xx*r1, ana.y - yy*r1, ana.x + xx*r2, ana.y - yy*r2, 1, c.majormark
          Next y
        ElseIf i Mod 5 = 0 Then
          For y = -2 To +2
            tim = (i + y/10) : xx = Cos(Rad(tim * 6)) : yy = Sin(Rad(tim * 6))
            r1 = ana.r - 15 : r2 = ana.r - 5
            Line  ana.x + xx*r1, ana.y - yy*r1, ana.x + xx*r2, ana.y - yy*r2, 1, c.majormark
          Next y
        Else
          tim = i : xx = Cos(Rad(tim * 6)) : yy = Sin(Rad(tim * 6))
          r1 = ana.r - 10 : r2 = ana.r - 5
          Line  ana.x + xx*r1, ana.y - yy*r1, ana.x + xx*r2, ana.y - yy*r2, 1, c.majormark
        EndIf
      Next i
    EndIf
    UpdateAnalog -1, tmin, thour
    UpdateAnalog -1, tmin, thour
  Else
    CLS c.background
    Text MM.HRes/2, 5, "      " + Title(ClockNbr) + "      ", CT, 2, 1, c.title, c.background
    UpdateDigital -1, tmin, thour
  EndIf
  PrevClockType = ClockType(ClockNbr)
End Sub



' update/draw the digital clock
Sub UpdateDigital s As Float, m As Float, h As Float
  Local Float sec = s, min = m, hr = h, offset
  Local String st
  If ClockType(ClockNbr) = 2 Then
    If Not ((hr >= 10 And hr < 13) Or hr >= 22 Or hr = 0) Then offset = -20
    If sec <= 0 Then
      If hr < 12 Then st = "AM" Else st = "PM"
      Text MM.HRes + 3 + offset, 54, st, RT, 2, 1, c.digital
      If hr > 12 Then hr = hr - 12
      If hr = 0 Then hr = 12
    EndIf
  Else
    offset = 6
  EndIf
'  EndIf
  If sec <= 0 Then
    If ClockType(ClockNbr) = 2 Then
      Text -8 + offset, 50, Str$(hr, 2), , 3, 1, c.digital
    Else
      Text -8 + offset, 50, Str$(hr, 2, 0, "0"), , 3, 1, c.digital
    EndIf
    Text 141 + offset, 50, Str$(min, 2, 0, "0"),, 3, 1, c.digital
    Circle 130 + offset, 80, 6, 0, 1, 0, c.digital
    Circle 130 + offset, 122, 6, 0, 1, 0, c.digital
    If OptionDisplayDate Then
      Text MM.HRes/2, MM.VRes - 40, "   " + days(tdow) + "   ", CB, 2, 1, c.date
      Text MM.HRes/2, MM.VRes - 5, "   " + Str$(tday) + " " + mths(tmth) + " " + Str$(tyear + 2000) + "   ", CB, 2, 1, c.date
    EndIf
  EndIf
  If ClockType(ClockNbr) = 3 Then offset = 3
  If sec >= 0 Then Text MM.HRes + 2 + offset, 152, Str$(sec, 2, 0, "0"), RB, 2, 1, c.digital
End Sub


' update/draw the analogue clock
Sub UpdateAnalog s As Float, m As Float, h As Float
  Local Float minutes = m - 15, hour = (h - 3) + m/60, sec = s - 15
  If hour >= 12 Then hour = hour - 12
  Line ana.x, ana.y, GetX(PrevSec, ana.r - 21), GetY(PrevSec, ana.r - 21), 1, c.face
  PrevSec = sec
  If s > 0 Then
    Circle ana.x, ana.y, ana.r * 0.075, 1, 1, c.hourhand, c.hourhand
    If x1(0) <> 0 Then DrawTriangles 2, x1(2), y1(2), x2(2), y2(2), x3(2), y3(2), c(2)
  Else
    ' setup the parameters for drawing four triangles
    ' the first two erase the old minute and hour hands, the next two draw the new ones
    ' the CSub DrawTriangles draws all four simultaneously
    x1(0) = x1(2) : x1(1) = x1(3) : y1(0) = y1(2) : y1(1) = y1(3)
    x2(0) = x2(2) : x2(1) = x2(3) : y2(0) = y2(2) : y2(1) = y2(3)
    x3(0) = x3(2) : x3(1) = x3(3) : y3(0) = y3(2) : y3(1) = y3(3)
    x1(2) = GetX((hour * 5) - 15, ana.r * 0.075)
    y1(2) = GetY((hour * 5) - 15, ana.r * 0.075)
    x2(2) = GetX((hour * 5) + 15, ana.r * 0.075)
    y2(2) = GetY((hour * 5) + 15, ana.r * 0.075)
    x3(2) = GetX(hour * 5, ana.r * 0.55)
    y3(2) = GetY(hour * 5, ana.r * 0.55)
    x1(3) = GetX(minutes - 15, ana.r * 0.05)
    y1(3) = GetY(minutes - 15, ana.r * 0.05)
    x2(3) = GetX(minutes + 15, ana.r * 0.05)
    y2(3) = GetY(minutes + 15, ana.r * 0.05)
    x3(3) = GetX(minutes, ana.r - 21)
    y3(3) = GetY(minutes, ana.r - 21)
    Circle ana.x, ana.y, ana.r * 0.075, 1, 1, c.hourhand, c.hourhand
    If x1(0) <> 0 Then DrawTriangles 4, x1(), y1(), x2(), y2(), x3(), y3(), c()
    If OptionDisplayDate Then
      Text 47, MM.VRes, abrevdays(tdow), CB, 1, 2, c.date
      Text MM.HRes + 1, MM.VRes, Str$(tday) + " " + Left$(mths(tmth), 3), RB, 1, 2, c.date
    EndIf
  EndIf
  If s >= 0 Then Line ana.x, ana.y, GetX(sec, ana.r - 21), GetY(sec, ana.r - 21), 1, c.secondhand
  Circle ana.x, ana.y, ana.r * 0.05, 1, 1, c.minutehand, c.minutehand
End Sub


' utility to get the x coord of a vector on the analogue clock
Function GetX(tim As Float, r As Float) As Integer 'Float
  Local Float t = tim
  If t > 359 Then t = t - 360
  If t < 0 Then t = t + 360
  GetX = ana.x + Cos(Rad(t * 6)) * r
End Function


' utility to get the y coord of a vector on the analogue clock
Function GetY(tim As Float, r As Float) As Integer 'Float
  Local Float t = tim
  If t > 359 Then t = t - 360
  If t < 0 Then t = t + 360
  GetY = ana.y + Sin(Rad(t * 6)) * r
End Function



''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' subroutines involved with configuring the clock
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

' the main configuration menu
Sub ConfigureMenu
  Local Float i, j, btn
  Local String modes(3) LENGTH 16 = ("Hidden     ", "Analogue   ", "Digital 12h", "Digital 24h")
  redisplay:
  WatchDog 1200000
  CLS
  Font 1, 2
  Text MM.HRes/2, 0, Title(ClockNbr), CT, 2, 1, c.title, c.background
  Text 5, 40, modes(ClockType(ClockNbr)), , , , c.caption
  DrawButton 0, 0, MM.HRes - 120, 38, 120, 30, c.button, "CHANGE"
  DrawButton 1, 0, 30, 85, 260, 30, c.button, "CONFIGURE CLOCK"
  If TimeSource < 3 Then
    DrawButton 2, 0, 10, 140, 140, 30, c.button, "SET DATE"
    DrawButton 3, 0, MM.HRes - 150, 140, 140, 30, c.button, "SET TIME"
    Text MM.HRes/2, 172, "Setting date and time will also adjust",C ,1 ,1 , c.entry
    Text MM.HRes/2, 185, "all other clocks based on their timezone",C ,1 ,1 , c.entry
  Else
    Text MM.HRes/2, 130, "GPS Time", C, 1, 2, c.entry
    If UTC - NotSyncTime = 0 Then
      Text MM.HRes/2, 158, "Synchronised", C, 1, 2, c.entry
    Else
      Text 0, 158, "No sync for " + Str$((UTC - NotSyncTime + 36)/3600, 1, 2) + " hrs", , 1, 2, c.entry
    EndIf
  EndIf
  DrawButton 4, 0, 0, 211, 90, 30, c.special, "PREV"
  DrawButton 5, 0, 110, 211, 100, 30, c.save, "EXIT"
  DrawButton 6, 0, MM.HRes-90, 211, 90, 30, c.special, "NEXT"
  Do
    btn = CheckButtonPress(0, 6)
    If btn >= 0 Then
      Timer = 0
      Pause 200
      If btn = 3 Then
        Do While TimeSource = 1 And Touch(x) <> -1 And Timer < 3000 : Loop
        If Timer >= 3000 Then
          TrimAging
          GoTo redisplay
        EndIf
      EndIf
      CheckButtonRelease btn
    EndIf
    Select Case btn
      Case 0
        ClockType(ClockNbr) = (ClockType(ClockNbr) + 1) Mod 4
        Text 5, 40, modes(ClockType(ClockNbr)), , , , c.caption
      Case 1
        ConfigureClock
        GoTo redisplay
      Case 2
        GetDateTime 1
        GoTo redisplay
      Case 3
        GetDateTime 0
        GoTo redisplay
      Case 4
        ClockNbr = ClockNbr - 1
        If ClockNbr < 0 Then ClockNbr = maxclocks
        Text MM.HRes/2, 0, "     " + Title(ClockNbr) + "     ", CT, 2, 1, c.title, c.background
        Text 5, 40, modes(ClockType(ClockNbr)), , , , c.caption
      Case 5
        j = 0
        For i = 0 To maxclocks : j = j + ClockType(i) : Next i
        If j = 0 Then ClockType(0) = 1
        Do While ClockType(ClockNbr) = 0
          ClockNbr = (ClockNbr + 1) Mod (maxclocks + 1)
        Loop
        VAR Save ClockNbr, ClockType()
        Exit Do
      Case 6
        ClockNbr = (ClockNbr + 1) Mod (maxclocks + 1)
        Text MM.HRes/2, 0, "     " + Title(ClockNbr) + "     ", CT, 2, 1, c.title, c.background
        Text 5, 40, modes(ClockType(ClockNbr)), , , , c.caption
    End Select
  Loop
End Sub


' setup menu for an individual clock
Sub ConfigureClock
  Local String StartDst, EndDst
  Local Integer btn
  restartmenu:
  StartDst = dstdow(SW(ClockNbr)) + Left$(days(SD(ClockNbr)), 3) + " in " + Left$(mths(SM(ClockNbr)), 3)
  EndDst = dstdow(EW(ClockNbr)) + Left$(days(ED(ClockNbr)), 3) + " in " + Left$(mths(EM(ClockNbr)), 3)
  If SM(ClockNbr) = 0 Then StartDst = "Disabled"
  If EM(ClockNbr) = 0 Then EndDST = "Disabled"
  CLS
  Font 1, 2
  Text 0, 0, "Title:", , , , c.caption
  Text 0, 26, Title(ClockNbr), , , , c.entry
  DrawButton 0, 0, MM.HRes - 75, 8, 75, 30, c.button, "SET"
  Text 0, 60, "TimeZone:", , , , c.caption
  Text 152, 60, Str$(TZ(ClockNbr)/3600, -1, 1), , , , c.entry
  DrawButton 1, 0, MM.HRes - 75, 58, 35, 30, c.button, "-"
  DrawButton 2, 0, MM.HRes - 35, 58, 35, 30, c.button, "+"
  Text 0, 94, "DST Start:", , , , c.caption
  Text 0, 118, StartDst, , , , c.entry
  DrawButton 3, 0, MM.HRes - 75, 116, 75, 30, c.button, "SET"
  Text 0, 152, "DST End:", , , , c.caption
  Text 0, 176, EndDst, , , , c.entry
  DrawButton 4, 0, MM.HRes - 75, 172, 75, 30, c.button, "SET"
  DrawButton 5, 0, 100, MM.VRes - 30, 120, 30, c.save, "SAVE"
  Do
    btn = CheckButtonPress(0, 6)
    Select Case btn
      Case 0
        Pause 200
        CheckButtonRelease btn
        GetString Title(ClockNbr)
        GoTo restartmenu
      Case 1
        TZ(ClockNbr) = TZ(ClockNbr) - (3600/2)
        If TZ(ClockNbr) < (-12 * 3600) Then TZ(ClockNbr) = (-12 * 3600)
        Text 152, 60, Left$(Str$(TZ(ClockNbr)/3600, -1, 1), 5), , , , c.entry
        Pause 200
        CheckButtonRelease btn
      Case 2
        TZ(ClockNbr) = TZ(ClockNbr) + (3600/2)
        If TZ(ClockNbr) > (12 * 3600) Then TZ(ClockNbr) = (12*3600)
        Text 152, 60, Left$(Str$(TZ(ClockNbr)/3600, -1, 1), 5), , , , c.entry
        Pause 200
        CheckButtonRelease btn
      Case 3
        Pause 200
        CheckButtonRelease btn
        GetDSTSettings 1
        GoTo restartmenu
      Case 4
        Pause 200
        CheckButtonRelease btn
        GetDSTSettings 0
        GoTo restartmenu
      Case 5
        VAR Save TZ(), Title()
        Exit Do
    End Select
  Loop
End Sub


' menu to get the daylight saving settings
Sub GetDSTSettings st As Float
  Local Integer btn
  Local Float m, w, d
  CLS
  Font 1, 2
  If st Then
    Text MM.HRes/2, 0, "DST Start", C, , , RGB(brown)
    m = SM(ClockNbr) : w = SW(ClockNbr) : d = SD(ClockNbr)
  Else
    Text MM.HRes/2, 0, "DST End", C, , , RGB(brown)
    m = EM(ClockNbr) : w = EW(ClockNbr) : d = ED(ClockNbr)
  EndIf
  Text 0, 32, "Month:", , , , c.caption
  Text 20, 58, mths(m), , , , c.entry
  DrawButton 0, 0, MM.HRes - 105, 56, 50, 30, c.button, "-"
  DrawButton 1, 0, MM.HRes - 50, 56, 50, 30, c.button, "+"
  Text 0, 90, "Day:", , , , c.caption
  Text 20, 116, days(d), , , , c.entry
  DrawButton 2, 0, MM.HRes - 105, 114, 50, 30, c.button, "-"
  DrawButton 3, 0, MM.HRes - 50, 114, 50, 30, c.button, "+"
  Text 0, 148, "Week:", , , , c.caption
  Text 20, 174, dstdow(w), , , , c.entry
  DrawButton 4, 0, MM.HRes - 105, 172, 50, 30, c.button, "-"
  DrawButton 5, 0, MM.HRes - 50, 172, 50, 30, c.button, "+"
  DrawButton 6, 0, 100, MM.VRes - 30, 120, 30, c.save, "SAVE"
  Do
    btn = CheckButtonPress(0, 6)
    Select Case btn
      Case 0
        m = m - 1
        If m < 0 Then m = 12
        Text 20, 58, Left$(mths(m) + "      ", 8), , , , c.entry
     Case 1
        m = m + 1
        If m > 12 Then m = 0
        Text 20, 58, Left$(mths(m) + "      ", 8), , , , c.entry
      Case 2
        d = d - 1
        If d < 0 Then d = 6
        Text 20, 116, days(d) + "   ", , , , c.entry
      Case 3
        d = d + 1
        If d > 6 Then d = 0
        Text 20, 116, days(d) + "   ", , , , c.entry
      Case 4
        w = w - 1
        If w < 0 Then w = 3
        Text 20, 174, dstdow(w), , , , c.entry
      Case 5
        w = w + 1
        If w > 3 Then w = 0
        Text 20, 174, dstdow(w), , , , c.entry
      Case 6
        If st Then
          SM(ClockNbr) = m : SW(ClockNbr) = w : SD(ClockNbr) = d
          VAR Save SM(), SW(), SD()
        Else
          EM(ClockNbr) = m : EW(ClockNbr) = w : ED(ClockNbr) = d
          VAR Save EM(), EW(), ED()
        EndIf
        Exit Do
    End Select
    If btn >= 0 Then Pause 200 : CheckButtonRelease btn
  Loop
End Sub



' menu to get a date or time
' this can handle either date (dt = 1) or time (dt = 0)
Sub GetDateTime dt As Integer
  Local Integer digit, i, b, d, m, y
  Local String SCap(9) LENGTH 8 = ("7","8","9","4","5","6","1","2","3","0")
  Local String str, strold
  Const bh = MM.VRes\5, bw = MM.HRes\5

  If dt Then strold = "dd/mm/yy" Else strold = "hh:mm:ss"
  str = strold
  digit = 1

  Font 1, 2
  CLS
  For i = 0 To 8
    DrawButton i, 0, bw + bw * (i Mod 3) + 2, bh + bh * (i \ 3) + 2, bw - 4, bh - 4, c.button, SCap(i)
  Next i
  DrawButton 9, 0, bw*2 + 2, bh*4 + 2, bw - 4, bh - 4, c.button, "0"
  DrawButton 10, 0, 0, bh*4 + 2, bw * 2 - 4, bh - 4, c.delete, "DELETE"
  DrawButton 11, 0, bw*3 + 2, bh*4 + 2, bw * 2 - 4, bh - 4, c.save, "SAVE"
  DisplayDateTimeStr str

  Do
    If Timer > 700 Then Line 40 + digit * 24, 43, 64 + digit * 24, 43, 2, c.entry : Timer = 0
    b = CheckButtonPress(0, 11)
    If Timer > 500 Or b > 0 Then Line 40 + digit * 24, 43, 64 + digit * 24, 43, 2, 0
      Select Case b
        Case 0 To 9
          If digit < 9 Then
            str = Left$(str, digit-1) + SCap(b) + Mid$(str, digit+1, 9)
            digit = digit + 1
            If digit = 3 Or digit = 6 Then digit = digit + 1
            DisplayDateTimeStr str
          EndIf
          Pause 150
          CheckButtonRelease b
        Case 10
          If digit > 1 Then
            digit = digit - 1
            If digit = 3 Or digit = 6 Then digit = digit - 1
            str = Left$(str, digit-1) + Mid$(strold, digit)
            DisplayDateTimeStr str
          EndIf
          Pause 150
          CheckButtonRelease b
        Case 11
          Pause 150
          CheckButtonRelease b
          d = Val(Left$(str, 2))
          m = Val(Mid$(str, 4, 2))
          y = Val(Right$(str, 2))
          If dt Then
            If y < 16 Or m < 1 Or m > 12 Or d < 1 Or d > 31 Then
              MessageBox "Invalid", "Date"
            Else
              GetLocalTime
              UTC = GetSec(y, m, d, thour, tmin, tsec) - TZ(ClockNbr) - tdst
              GetLocalTime
              UTC = GetSec(y, m, d, thour, tmin, tsec) - TZ(ClockNbr) - tdst
            EndIf
          Else
            If Mid$(str, 5, 1) = "m" Or y > 59 Or m > 59 Or d > 23 Then
              MessageBox "Invalid", "Time"
            Else
              GetLocalTime
              UTC = GetSec(tyear, tmth, tday, d, m, y) - TZ(ClockNbr) - tdst
              GetLocalTime
              UTC = GetSec(tyear, tmth, tday, d, m, y) - TZ(ClockNbr) - tdst
            EndIf
          EndIf
          If TimeSource = 1 Then
            RTC SetTime GetYear(UTC), GetMonth(UTC), GetDay(UTC), (UTC \ 3600) Mod 24, (UTC \ 60) Mod 60, UTC Mod 60
          EndIf
          Date$ = Str$(GetDay(UTC)) + "/" + Str$(GetMonth(UTC)) + "/" + Str$(GetYear(UTC))
          Time$ = Str$((UTC \ 3600) Mod 24) + ":" + Str$((UTC \ 60) Mod 60) + ":" + Str$(UTC Mod 60)
          Exit Do
      End Select
    EndIf
  Loop
End Sub


' utility sub to display formatted date or time
Sub DisplayDateTimeStr s As String
  Local Float i
  For i = 1 To 8
    If i = 3 Or i = 6 Then
      Text 40 + 24 * i, 10, Mid$(s, i, 1), , 2, 1, RGB(white), 0
    ElseIf Mid$(s, i, 1) > "9" Then
      Text 40 + 24 * i, 10, Mid$(s, i, 1), , 2, 1, c.ghosttext, 0
    Else
      Text 40 + 24 * i, 10, Mid$(s, i, 1), , 2, 1, c.entry, 0
    EndIf
  Next i
End Sub



' menu to get a clock's title
Sub GetString str As String
  Local Integer i, b, y, xt, yt, SIndex
  Local String strOriginal = str
  Local String SCap(47) LENGTH 4 = ("A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","1","2","3","4","5","6","7","8","9","0",",",".","?","-",":",";","(",")","@","#","$","&")
  Const bh = MM.VRes\5, bw = MM.HRes\6

  CLS
  SIndex = 0
  Text 0, 10, str, , 2, 1, c.entry, 0

  y = (MM.VRes / 5) * 4 + 5
  DrawButton 0, 0, 0, y, 64, 36, c.delete, "DEL"
  DrawButton 1, 0, 80, y, 96, 36, c.button, "SPACE"
  DrawButton 2, 0, MM.HRes - 113, y, 112, 36, c.save, "SAVE"

  For i = 0 To 11
    DrawButton i + 3, 0, bw + bw * (i Mod 4) + 2, bh + bh * (i \ 4) + 2, bw - 4, bh - 4, c.button, SCap(i)
  Next i
  DrawRArrow bw, bh
  DrawLArrow bw, bh

  Do
    If Timer > 700 Then Text 0, 10, str + "_", , 2, 1, c.entry, 0 : Timer = 0
    If Timer > 500 Then Text 0, 10, str + " ", , 2, 1, c.entry, 0
    If Touch(x) <> -1 Then
      xt = Touch(x)
      yt = Touch(y)
      If xt > bw * 5 + 10 And yt > (bh/2) * 3 And yt < (bh/2) * 7 And SIndex < 32 Then
        DrawRArrowFilled bw, bh
        SIndex = SIndex + 12
        For i = 0 To 11
          DrawButton i + 3, 0, bw + bw * (i Mod 4) + 2, bh + bh * (i \ 4) + 2, bw - 4, bh - 4, c.button, SCap(i + SIndex)
        Next i
        Do While Touch(x) <> -1 : Loop
        DrawRArrow bw, bh
        Continue do
      EndIf
      If xt < bw And yt > (bh/2) * 3 And yt < (bh/2) * 7 And SIndex > 0 Then
        DrawLArrowFilled bw, bh
        SIndex = SIndex - 12
        For i = 0 To 11
          DrawButton i + 3, 0, bw + bw * (i Mod 4) + 2, bh + bh * (i \ 4) + 2, bw - 4, bh - 4, c.button, SCap(i + SIndex)
        Next i
        Do While Touch(x) <> -1 : Loop
        DrawLArrow bw, bh
        Continue do
      EndIf
      b = CheckButtonPress(0, 14)
      Select Case b
        Case 0
          If Len(str) > 0 Then
            str = Left$(str, Len(str) - 1)
            Text 0, 10, str + "  ", , 2, 1, c.entry, 0
          EndIf
          CheckButtonRelease 0
        Case 1
          If Len(str) < 12 Then
            str = str + " "
            Text 0, 10, str, , 2, 1, c.entry, 0
          EndIf
          CheckButtonRelease 1
        Case 2
          CheckButtonRelease 2
          If str = "" Then str = strOriginal
          Exit Do
        Case 3 To 14
          If Len(str) < 12 Then
            str = str + SCap(SIndex + b - 3)
            Text 0, 10, str, , 2, 1, c.entry, 0
          EndIf
          CheckButtonRelease b
      End Select
    EndIf
  Loop
End Sub


' utility subs to draw the arrows
Sub DrawRArrow bw As Integer, bh As Integer
  Box bw * 5 + 10, (bh/2) * 3, bw, bh * 2, 1, 0, 0
  Line bw * 5 + 10, (bh/2) * 3, MM.HRes - 1, (bh/2) * 5, 1, c.special
  Line bw * 5 + 10, (bh/2) * 3, bw * 5 + 10, (bh/2) * 7, 1, c.special
  Line bw * 5 + 10, (bh/2) * 7, MM.HRes - 1, (bh/2) * 5, 1, c.special
End Sub

Sub DrawLArrow bw As Integer, bh As Integer
  Box 0, (bh/2) * 3, bw, bh * 2, 1, 0, 0
  Line bw - 10, (bh/2) * 3, 0, (bh/2) * 5, 1, c.special
  Line bw - 10, (bh/2) * 3, bw - 10, (bh/2) * 7, 1, c.special
  Line bw - 10, (bh/2) * 7, 0, (bh/2) * 5, 1, c.special
End Sub

Sub DrawRArrowFilled bw As Integer, bh As Integer
  Local Integer x, y
  For x = bw * 5 + 10 To MM.HRes - 1
    y = bh * ((x - (bw * 5 + 10)) / ((MM.HRes - 1) - (bw * 5 + 10)))
    Line x, (bh/2) * 3 + y, x, (bh/2) * 7 - y, 1, c.special
  Next x
End Sub

Sub DrawLArrowFilled bw As Integer, bh As Integer
  Local Integer x, y
  For x = 0 To bw - 10
    y = bh * (x / (bw - 10))
    Line x, bh/2 * 5 - y, x, bh/2 * 5 + y, 1, c.special
  Next x
End Sub


' menu to get and set the aging trim for the DS3231
Sub TrimAging
  Local Integer r ,b
  Local Float n
  CLS
  Font 2, 1
  Text MM.HRes/2, 10, "DS3231", CT, 2 ,1, c.caption
  Text MM.HRes/2, 45, "Aging Offset", CT, 2, 1, c.caption
  RTC GetReg &H10, r
  If MM.I2C > 0 Then
    MessageBox "Error reading", "from RTC"
    Exit Sub
  EndIf
  If r > 127 Then
    n = r - 256
  Else
    n = r
  EndIf
  Text 50, 100, Str$(n, 4, 0, "0"), , 2, 1, c.entry
  If n >= 0 Then Text 50, 100, "+", , 2, 1, c.entry
  DrawButton 0, 0, 200, 95, 50, 42, c.button, "-"
  DrawButton 1, 0, 260, 95, 50, 42, c.button, "+"
  Text MM.HRes/2, 142, "Positive values will slow the clock,", CT, 1, 1, c.entry
  Text MM.HRes/2, 157, "negative values will speed it up", CT, 1, 1, c.entry
  DrawButton 2, 0, 0, MM.VRes - 50, 150, 50, c.special, "CANCEL"
  DrawButton 3, 0, MM.HRes - 150, MM.VRes - 50, 150, 50, c.save, "SAVE"
  Do While Touch(x) <> -1 : Loop
  Do
    b = CheckButtonPress(0, 14)
    Select Case b
      Case 0
        n = n - 1
        If n < -127 Then n = -127
        Text 50, 100, Str$(n, 4, 0, "0"), , 2, 1, c.entry
        If n >= 0 Then Text 50, 100, "+", , 2, 1, c.entry
        CheckButtonRelease 0
      Case 1
        n = n + 1
        If n > 127 Then n = 127
        Text 50, 100, Str$(n, 4, 0, "0"), , 2, 1, c.entry
        If n >= 0 Then Text 50, 100, "+", , 2, 1, c.entry
        CheckButtonRelease 1
      Case 2
        Exit Do
      Case 3
        r = n And &B11111111
        RTC SetReg &H10, r
        If MM.I2C > 0 Then
          MessageBox "Error writing", "to RTC"
        EndIf
        Exit Do
    End Select
  Loop
End Sub


''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' subroutines involved with manipulating time
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

' find the local time (incl DST) from the UTC variable which is counting UTC time
' updates the global variables tyear, tmth, tday, tdow, thour, tmin, tsec, tdst
Sub GetLocalTime
  Local Integer t, ty, dststart, dstend
  tdst = 0
  t = UTC + TZ(ClockNbr)
  If SM(ClockNbr) <> 0 And EM(ClockNbr) <> 0 Then
    ty = GetYear(t)
'    ? "Start: ",;
    dststart = GetDST(ty, SM(ClockNbr), SW(ClockNbr), SD(ClockNbr))
'    ? "End: ",;
    dstend = GetDST(ty, EM(ClockNbr), EW(ClockNbr), ED(ClockNbr))
    If dststart > dstend Then
      If t < dstend Then
        dststart = GetDST(ty - 1, SM(ClockNbr), SW(ClockNbr), SD(ClockNbr))
      Else
        dstend = GetDST(ty + 1, EM(ClockNbr), EW(ClockNbr), ED(ClockNbr))
      EndIf
    EndIf
    If t >= dststart And t < dstend Then tdst = 3600
'    ? dststart, t, dstend, tdst,
    t = t + tdst
'    ? t
  EndIf
  tsec = t Mod 60
  tmin = (t \ 60) Mod 60
  thour = (t \ 3600) Mod 24
  tyear = GetYear(t)
  tmth = GetMonth(t)
  tday = GetDay(t)
  tdow = GetDOW(t)
End Sub



' calculate the seconds since midnight 1st Jan 2014
Function GetSec(yr As Integer, mth As Integer, day As Integer, hr As Integer, min As Integer, sec As Integer) As Integer
  GetSec = (yr - 14) * (365 * 24 * 60)
  GetSec = GetSec + ((yr - 13) \ 4) * (24 * 60)
  GetSec = GetSec + (md(mth) * (24 * 60))
  GetSec = GetSec + ((day - 1) * (24 * 60))
  GetSec = GetSec + (hr * 60)
  GetSec = ((GetSec + min) * 60) + sec
  If (yr - 16) Mod 4 = 0 And mth > 2 Then GetSec = GetSec + (24 * 3600)
End Function


' convert seconds to the year (two digits)
Function GetYear(seconds As Integer) As Float
  Local Float yr
  For yr = 14 To 99
   If seconds < GetSec(yr + 1, 1, 1, 0, 0, 0) Then Exit For
  Next yr
  GetYear = yr
End Function


' convert seconds to the month (Jan = 1)
Function GetMonth(seconds As Integer) As Float
  Local Float mth
  For mth = 1 To 12
    If seconds < GetSec(tyear, mth, 1, 0, 0, 0) Then Exit For
  Next mth
  GetMonth = mth - 1
End Function


' convert seconds to the day of the month
Function GetDay(seconds As Integer) As Float
  GetDay = ((seconds - GetSec(tyear, tmth, 1, 0, 0)) \ (24 * 3600)) +  1
End Function


' convert seconds to the day of the week (Sunday = 0)
Function GetDOW(seconds As Integer) As Float
  GetDOW = ((seconds \ (24 * 3600)) + 3) Mod 7
End Function


' get the seconds (since since midnight 1st Jan 2014) that DST will start or end in a year
Function GetDST(yr As Integer, mth As Integer, wk As Integer, dy As Integer) As Integer
  Local Integer d, m, hr = 2, ty = yr, tm = mth
  If TZ(ClockNbr) = 0 Then hr = 1
  m = GetSec(yr, mth, 1, hr, 0, 0)
  d = GetDOW(m)
  m = m + (((dy - d + 7) Mod 7) * 24 * 3600)
'  ? yr, mth, hr, d , ((dy - d + 7) mod 7) ,(wk * 7)
  GetDST = m + (wk * 7 * 24 * 3600)
  If wk = 3 Then
    tm = tm + 1
    If tm > 12 Then tm = 1 : ty = ty + 1
    If GetDST + (7 * 24 * 3600) < GetSec(ty, tm, 1, 0, 0, 0) Then GetDST = GetDST + (7 * 24 * 3600)
  EndIf
End Function




''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' misc utility subroutines
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''


' called by SetTick
Sub RtcSetTime
  RTC GetTime
End Sub


'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Draw buttons and get button presses
'
' The subrouting DrawButton will draw a button (normally used when drawing
' the screen for input).
'
' The function CheckButtonPress() will check if a button has been touched.
' If it has it will set it to selected (reverse video) and return with the
' button's number.
'
' The subroutine CheckButtonRelease will wait for the touch to be released
' and will then draw the button as normal.
'
' These routines use the global arrays key_coord() and key_caption() to
' track the coordinates and size of each button and save its caption.
'
' IMPORTANT: These routines set the watchdog to 20 minutes.  If a button
'            has not been pressed within this time the Micromite will
'            restart.
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

' draw a button
Sub DrawButton n As Integer, mode As Integer, x As Integer, y As Integer, w As Integer, h As Integer, c As Integer, s As String
  Local Integer bc, fc

  If mode = 0 Then
    key_coord(n,0) = x : key_coord(n,1) = y : key_coord(n,2) = w : key_coord(n,3) = h
    key_coord(n,4) = c : key_caption(n) = s
  EndIf

  If mode > 1 Then
    bc = key_coord(n,4) : fc = 0    ' draw in reverse video if it is being touched
  Else
    bc = 0 : fc = key_coord(n,4)    ' a normal (untouched) button
  EndIf

  RBox key_coord(n,0), key_coord(n,1), key_coord(n,2), key_coord(n,3), , key_coord(n,4), bc)
  Text key_coord(n,0) + key_coord(n,2)/2, key_coord(n,1) + key_coord(n,3)/2, key_caption(n), CM, , , fc, bc
End Sub


' check if a button has been touch and animate the button's image
' returns the button's number
Function CheckButtonPress(startn As Integer, endn As Integer) As Integer
  Local Integer xt, yellowt, n

  CheckButtonPress = -1
  If Touch(x) <> -1 Then
    ' we have a touch
    WatchDog 1200000
    xt = Touch(x)
    yellowt = Touch(y)
    ' scan the array key_coord() to see if the touch was within the
    ' boundaries of a button
    For n = startn To endn
      If xt > key_coord(n,0) And xt < key_coord(n,0) + key_coord(n,2) And yellowt > key_coord(n,1) And yellowt < key_coord(n,1) + key_coord(n,3) Then
        ' we have a button press
        ' draw the button as pressed
        DrawButton n, 2
        CheckButtonPress = n
        Exit For
      EndIf
    Next n
  EndIf
End Function


' wait for the touch to be released and then draw the button as normal
Sub CheckButtonRelease n As Integer
  ' if a button is currently down check if it has been released
  Do While Touch(x) <> -1 : Loop   ' wait for the button to be released
  DrawButton n, 1                  ' draw the button as normal (ie, not pressed)
End Sub



'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' this handy routine draws a message box with an OK button
' then waits for the button to be touched
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub MessageBox s1 As String, s2 As String
  Local Integer w
  If Len(s1) > Len(s2) Then w = Len(s1) Else w = Len(s2)
  w = w * 8     ' get the width of the text (used for the box width)

  ' draw the box and the message in it
  RBox MM.HRes/2 - w - 20, 60, w * 2 + 40, 130, , c.entry, 0
  Text MM.HRes/2, 70, s1, CT, 1, 2, RGB(white)
  Text MM.HRes/2, 100, s2, CT, 1, 2, RGB(white)

  ' draw the OK button
  RBox 110, 140, 100, 34, , c.button
  Text MM.HRes/2, 157, "OK", CM, 1, 2, c.button

  ' wait for the button to be touched
  WatchDog 1200000
  Do While Not (Touch(x) > 110 And Touch(x) < 210 And Touch(y) > 140 And Touch(y) < 180) : Loop

  ' draw the OK button as depressed
  RBox 110, 140, 100, 34, , c.button, c.button
  Text MM.HRes/2, 157, "OK", CM, 1, 2, 0, c.button

  ' wait for the touch to be removed
  Do While Touch(x) <> -1 : Loop
End Sub

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' this handy routine draws a message box with an OK button
' then waits for the button to be touched Modded by Jman
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub MessageBoxWiFi s1 As String, s2 As String, s3 As String
  Local Integer w
  If Len(s1) > Len(s2) Then w = Len(s1) Else w = Len(s2)
  w = w * 4     ' get the width of the text (used for the box width)

  ' draw the box and the message in it
  RBox MM.HRes/2 - w - 40, 20, w * 2 + 80, 170, , c.entry, 0
  Text MM.HRes/2, 40, s1, CT, 2, 1, RGB(white)
  Text MM.HRes/2, 80, s2, CT, 1, 1, RGB(white)
  Text MM.HRes/2, 110, s3, CT, 1, 1, RGB(white)

  ' draw the OK button
  RBox 110, 140, 100, 34, , c.button
  Text MM.HRes/2, 157, "OK", CM, 1, 2, c.button

  ' wait for the button to be touched
  Do While Not (Touch(x) > 110 And Touch(x) < 210 And Touch(y) > 140 And Touch(y) < 180) : Loop

  ' draw the OK button as depressed
  RBox 110, 140, 100, 34, , c.button, c.button
  Text MM.HRes/2, 157, "OK", CM, 1, 2, 0, c.button

  ' wait for the touch to be removed
  Do While Touch(x) <> -1 : Loop
End Sub
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Added by Jman
' clear the serial input buffer of any junk
Sub ClearBuffer
  Do : Loop Until Input$(255, #1) = ""
End Sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Added by Jman

Sub SendCmd cmd$, response$
  Local InputStr$
  If Error Then Exit Sub
  ClearBuffer
  Print #1, cmd$
 Do
  InputStr$ = GetLine$()
  If Echo <> 0 Then Print "From ESP ";InputStr$+" required ";response$
 Loop Until Instr(InputStr$, response$) > 0 Or Error = 1
 Resp$=InputStr$
End Sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Added by Jman
Function GetLine$()
  Local s$, c$
  Timer = 0
  Do
    c$ = Input$(1, #1)
    If echo Then Print c$;
    If Asc(c$) = 13 Or Len(s$) >= 254 Then
      GetLine$ = s$
    Else
      If Asc(c$) >= 32 Then s$ = s$ + c$
    EndIf
    If Timer > Timeout Then Error = 1
    Loop Until Asc(c$) = 13 Or Len(s$) >= 254 Or Error = 1
End Function

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Added by Jman
Sub CheckWiFi
 Open "COM1:115200, 1024" As #1  'Module must be set to same rate
 ClearBuffer : Resp$ = ""
 SendCMD "AT","OK"

If Resp$ <> "OK" Then Close #1 : Exit Sub
Resp$ = GetAddr$()

If Resp$ <> "+CIFSR:STAIP,"+Chr$(34)+"0.0.0.0"+Chr$(34) Then
 TimeSource=2 : Close #1
 Exit Sub
EndIf

WifiSetup               'Setup WiFi using Mobile
TimeSource=2

End Sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Added by Jman
' This will get the IP address of the module
Function GetAddr$()
  Local Integer i, j
  Local String s$
  If error Then Exit Function
    For i = 1 To 20
    ClearBuffer
        Print #1, "AT+CIFSR"
    For j = 1 To 3
      s$ = GetLine$()
      If error Then Exit For
      If echo Then Print s$
    Next j
    If Len(s$) > 5 Or error Then Exit For
    Pause 1000
  Next i
  GetAddr$ = s$
  Addr$=Mid$(s$, 15, Len(s$)-15)
End Function

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Added by Jman
Sub WiFiSetup               'Setup WiFi Using Mobile
 WatchDog (5*60*1000)       '5 Minutes to complete setup
 Open "COM1:115200, 1024" As #1  'Module must be set to same rate
 SendCMD "AT+RESTORE","OK" : Pause 5000
 ClearBuffer

 CLS
  MessageBoxWiFi "WiFi Setup", "Start ESP SmartConfig", "On Mobile"
  SendCMD "AT+CWMODE_DEF=1","OK" : Delay
  SendCMD "AT+CWSTARTSMART=1","OK" : Delay

Do
 a$=""
 a$ = Input$(1, #1)
 If Len(s$) >= 254 Then s$ = Right$(s$, 125)
 If Asc(a$) >= 32 Then s$ = s$ + a$
 If Echo Then Print s$
 Loop Until Right$(s$,26)="smartconfig connected wifi"

 SendCMD "AT+CWSTOPSMART","OK"
 Resp$ = GetAddr$()
 Close #1
 CLS
 MessageBoxWiFi "Success", "  IP Address  ", Mid$(Resp$,15,(Len(Resp$)-15))

End Sub

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub SayTime
  MP3Hour = THour + 100
  MP3Minute = TMin
 If MP3Hour = 0 And MP3Minute=0 Then MP3Hour = 200
  MP3PLAYFT 1, MP3Hour
 Do While Pin(MP3Busy) = 0
 Loop
  MP3PLAYFT 1, MP3Minute
End Sub

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Added by Jman
Sub SetupMp3
 Pause 500          'Allow MP3 Module to start
 WatchDog 2000      'Reset in case we get stuck here
 Mp3Vol (20)
End Sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Added by Jman
Sub GETREPLY
REPLY$=""
Pause 500

Do
 RP$=Input$(1,#2)
 REPLY$=REPLY$ + RP$
 Loop While Loc(#2) > 0
End Sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub MP3VOL STVOL  As Integer  'VOLUME = 1 - 30
If STVOL  > 30 Then STVOL = 30
If STVOL < 1 Then STVOL = 1
CCMD(4)=&H06
CCMD(7)=STVOL
Vol=STVol
If Echo Then Print "MP3 VOLUME = ";Vol
SENDCMDMP3
End Sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub MP3PLAYFT FOLDER As Integer, TRACK As Integer
CCMD(4)=&H0F
CCMD(6)=FOLDER
CCMD(7)=TRACK
SENDCMDMP3
CCMD(6)=0
End Sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub SENDCMDMP3
CCMDADD = 0
For I = 2 To 7
CCMDADD = CCMDADD + CCMD(I)
Next I
CHECKSUM = 0 - CCMDADD
CCMD(8)=CHECKSUM >> 8 And &HFF
CCMD(9)=CHECKSUM And &HFF
For I = 1 To 10
If Echo Then Print Hex$(CCMD(I))+" ";
Print #2, Chr$(CCMD(I));
Next I
Pause 150     'Small Delay to avoid lockup
End Sub

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Added by Jman
Sub Delay
 Pause 500
End Sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Added by Jman
Data 2678400,2419200,2678400,2592000,2678400,2592000,2678400
Data 2678400,2592000,2678400,2592000,2678400
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Routine to draw multiple triangles,
' written by Peter Mather (matherp on the Back Shed Forum)
' can be used to draw an existing triangle in the background colour and then re-write it somewhere else
'
' Parameters are:
'   number of triangles to draw
'   array x-coordinates of first points
'   array y-coordinates of first points
'   array x-coordinates of second points
'   array y-coordinates of second points
'   array x-coordinates of third points
'   array y-coordinates of third points
'   array colours of triangles
'
CSub DrawTriangles
     00000000
     27bdff90 afbf006c afbe0068 afb70064 afb60060 afb5005c afb40058 afb30054
     afb20050 afb1004c afb00048 afa40070 afa50074 afa60078 afa7007c 8c820004
     5c400007 afa00024 144000cc 8fbf006c 8c820000 104000ca 8fbe0068 afa00024
     afa0002c 3c159d00 8fa30074 8fa40024 00641021 8c510000 8fa50078 00a41021
     8c5e0000 8fa3007c 00641021 8c570000 8fa50080 00a41021 8c420000 afa20018
     8fa30084 00641021 8c420000 afa20028 8fa50088 00a41021 8c560000 8fa3008c
     00641021 8c540000 8fa40018 009e102a 10400008 8fa50018 03c01021 0080f021
     afa20018 02201021 02e08821 0040b821 8fa50018 02c5102a 10400007 8fa30018
     afb60018 00a0b021 02e01021 8fb70028 afa20028 8fa30018 007e102a 10400006
     03c01021 0060f021 afa20018 02201021 02e08821 0040b821 17d6001b 8fa50018
     02f1102a 14400006 02203821 0237102a 10400005 8fa40028 01000002 02e03821
     02e08821 8fa40028 0091102a 54400003 8fb10028 00e4102a 0082380b 8ea20048
     00fe3821 afb40010 8c420000 02202021 03c02821 02203021 0040f809 00f13823
     01000063 8fa4002c 00b61026 0002102b 00a21023 afa2001c 005e102a 1440002f
     03c08021 02f11023 afa20020 8fa30028 00711823 afa30030 00009021 00009821
     00be2023 afa40034 02def823 afbe0038 afb7003c afb60040 0060f021 0080b821
     03e0b021 0277001a 02e001f4 00002012 00912021 0256001a 02c001f4 00003012
     00d13021 00c4102a 50400005 8ea20048 00801021 00c02021 00403021 8ea20048
     afb40010 8c420000 02002821 0040f809 02003821 26100001 8fa20020 02629821
     8fa3001c 0070102a 1040ffe6 025e9021 8fbe0038 8fb7003c 8fb60040 02d0102a
     1440002a 8fa40028 00972023 afa4001c 8fa50018 02059023 72449002 8fa20028
     00511023 afa20020 021e9823 70539802 02c51023 afa20018 02def023 8fa30018
     0243001a 006001f4 00002012 00972021 027e001a 03c001f4 00003012 00d13021
     00c4102a 50400005 8ea20048 00801021 00c02021 00403021 8ea20048 afb40010
     8c420000 02002821 0040f809 02003821 26100001 8fa2001c 02429021 8fa30020
     02d0102a 1040ffe5 02639821 8fa4002c 24840001 afa4002c 8fa50024 24a50008
     afa50024 000417c3 8fa50070 8ca30004 0043182a 1460ff45 8fa30074 8ca30004
     14620006 8fbf006c 8ca20000 0082202b 1480ff3e 8fa30074 8fbf006c 8fbe0068
     8fb70064 8fb60060 8fb5005c 8fb40058 8fb30054 8fb20050 8fb1004c 8fb00048
     03e00008 27bd0070
End CSub