' V5.2
'OPTION LCDPANEL ILI9341, P, 27, 28, 24
'OPTION TOUCH 51, 33
'OPTION SDCARD 52

GoSub Splash

' Configuration Settings
echo=0                            ' Set to 1 for Diagnostic info
Timeout=6000                      ' Error timeout in milliseconds
WatchDog (2*60*1000)
SERVER$ = "Your.server.here"
PORT$ = "80"
RN$=Chr$(13)+Chr$(10)
WdataCount = 60
Dim WData$(WDataCount)
Dim IData$(5)

Const saverectangle=6
Const restorerectangle=7
Const buffersize=4000
Dim integer buff(buffersize)


'Insert key and set location
S1$="GET /weather.php?apiKey=your-key-here&lat=-43.49&lon=172.55&units=uk HTTP/1.1"+RN$ 'your lat and lon
S2$="Host:your.server.here"+RN$
S3$="GET /thing.php"+" HTTP/1.1"+RN$'Test"

Dim Months$(12)       'Array for Months Names
For I=1 To 12
 Read Months$(I)
Next

Start:
Error=0                      'Reset Error Flag in case we end up back here

If Touch(X) <> -1 Then WiFiSetup        'WiFi Setup if screen touced on start
Open "COM1:115200, 1024" As #1          'Module must be set to same rate
CheckWiFI                               'Check WiFi Module and Connection

SendCmd "AT+CIFSR","OK"
SendCmd "AT+CIPMUX=1", "OK"

Update:
GoSub GetWeather                        'Get the Weather Data

Screen1:
CLS
I=6 : Icon I, 0
Load image "bgrnd2.bmp"
Border
Load image Fn$, 180,5

i=ILI9341_MX470(saverectangle, buff(), 0, 0, 180, 60, 2476)
i=ILI9341_MX470(saverectangle, buff(), 80, 0, 15, 55, 0)

Do
 WatchDog (2*60*1000)
 If Time$="00:00:00" Then GoTo Update
 If Right$(Time$,5)="15:00" Then GoTo Update
 If Right$(Time$,5)="45:00" Then GoTo Update

If (Touch(X) < 50 And Touch(X) > 5 And Touch(Y) > 5 And Touch(Y) < 50) Then
   GoTo InFoScreen
EndIf

If (Touch(X) < 240 And Touch(X) > 195 And Touch(Y) > 1 And Touch(Y) < 60) Then
   WiFiSetUP : Exit Do
EndIf

 If Touch(X) <> -1 Then
   Pause 250 : GoTo Screen2
 EndIf

 If (Val(Right$(Time$,2)) Mod 2) = 1 Then
  Seperator$=":"
   Else
  Seperator$=" "
 EndIf

If  Seperator$=":" And Refresh=1 Then
  Refresh=0
EndIf

If  Seperator$=" " And Refresh=0 Then
  i=ILI9341_MX470(restorerectangle, buff(), 80, 0, 15, 55, 0)
  Refresh=1
EndIf

 If Mid$(Time$,4,2)<>RsTime$ Then
  i=ILI9341_MX470(restorerectangle, buff(), 0, 0, 180, 60, 2476)
  RsTime$=Mid$(Time$,4,2)
 EndIf

 Text 10,5,Left$(Time$,2),LT,8,1,RGB(Cyan),1
 Text 75,5,Seperator$,LT,4,2,RGB(Cyan),1
 Text 100,5,Mid$(Time$,4,2),LT,8,1,RGB(Cyan),1
Line 0,60,320,60,1,RGB(white)
 Text 15,65,Dow$,LT,7,2,RGB(green),1
 Text 125,65,DDay$,LT,7,2,RGB(green),1
 Text 195, 65, Nd$, LT, 7, 1, RGB(green),1
 Text 160,65,Mnth$,LT,1,2,RGB(green),1
Line 0,105,320,105,1,RGB(white)
 Text 120,108,"Indoors",CT,7,1,RGB(cyan),1

 Text 15,130,InTemp$,LT,8,1,RGB(yellow),1
 Text 80,130,"`C",LT,1,2,RGB(yellow),1
 Text 132,130,InHumid$,LT,8,1,RGB(yellow),1
 Text 200,130,"%",LT,1,2,RGB(yellow),1

Line 0,185,320,185,1,RGB(white)
 Text 120,190,"Christchurch",CT,7,1,RGB(cyan),1
 Text 120,205,"Airport",CT,7,1,RGB(cyan),1
 Text 15,232,Temp$,LT,8,1,RGB(yellow),1
 Text 80,232,"`C",LT,1,2,RGB(yellow),1

 Text 132,232,Humd$,LT,8,1,RGB(yellow),1
 Text 200,232,"%",LT,1,2,RGB(yellow),1

Line 0,288,320,288,1,RGB(white)
 Text 120,292,WData$(5),CT,3,1,RGB(Yellow),1

Loop

GoTo Screen1

''''''''''''''''''''''''''''''''''''''''''''''''''
Screen2:
CLS: Border
I=6 : Icon I, 1
Load image Fn$, 65,200


Do

WatchDog (2*60*1000)
 If Time$="00:00:00" Then GoTo Screen1
 If Right$(Time$,5)="15:00" Then GoTo Screen1
 If Right$(Time$,5)="45:00" Then GoTo Screen1

If I=6 Then
 If Touch(X) > 120 And Touch(Y) <> -1 Then
  Pause 500 : CLS : Border : I=15: Icon I, 1
   Load image Fn$, 65,200
   ElseIf Touch(X) < 120 And Touch(Y) <> -1 Then
    Pause 500 : GoTo Screen1
 EndIf
EndIf

If I = 15 Then
 If Touch(X) > 120 And Touch(Y) <> -1 Then
  Pause 500 : CLS : Border : I = 24: Icon I, 1
    Load image Fn$, 65,200
   ElseIf Touch(X) < 120 And Touch(Y) <> -1 Then
    Pause 500 : CLS : Border : I=6: Icon I, 1
    Load image Fn$, 65,200
 EndIf
EndIf

If I = 24 Then
 If Touch(X) > 120 And Touch(Y) <> -1 Then
  Pause 500 : CLS : Border : I = 33: Icon I, 1
    Load image Fn$, 65,200
   ElseIf Touch(X) < 120 And Touch(Y) <> -1 Then
    Pause 500 : CLS : Border : I=15: Icon I, 1
    Load image Fn$, 65,200
 EndIf
EndIf

If I = 33 Then
 If Touch(X) > 120 And Touch(Y) <> -1 Then
  Pause 500 : CLS : Border : I = 42: Icon I, 1
   Load image Fn$, 65,200
 ElseIf Touch(X) < 120 And Touch(Y) <> -1 Then
    Pause 500 : CLS : Border : I=24 : Icon I, 1
    Load image Fn$, 65,200
 EndIf
EndIf


If I = 42 Then
 If Touch(X) > 120 And Touch(Y) <> -1 Then
   Pause 500 : CLS : Border : I = 51: Icon I, 1
   Load image Fn$, 65,200
   ElseIf Touch(X) < 120 And Touch(Y) <> -1 Then
   Pause 500 : CLS : Border : I=33 : Icon I, 1
    Load image Fn$, 65,200
 EndIf
EndIf

If I = 51 Then
 If Touch(X) > 120 And Touch(Y) <> -1 Then
  Pause 500 : GoTo Screen1
   ElseIf Touch(X) < 120 And Touch(Y) <> -1 Then
    Pause 500 : CLS : Border : I=42: Icon I, 1
    Load image Fn$, 65,200
 EndIf
EndIf


Fullday Wdata$(I)

 Text 120,08,WData$(I),CT,9,1,RGB(green),RGB(black)
 Text 120,40,Right$(WData$(I+1),10),CT,3,1,RGB(green),RGB(black)
Line 0,64,320,64,1,RGB(white)
 Text 50,65,WData$(I+2),LT,3,1,RGB(0,153,255),RGB(black)
 Text 50,85,WData$(I+3),LT,3,1,RGB(0,153,255),RGB(black)
Line 0,110,320,110,1,RGB(white)


 Text 120,113,WData$(I+5),CT,3,1,RGB(0,255,255),RGB(black)
 Text 120,133,WData$(I+6),CT,3,1,RGB(0,255,255),RGB(black)
 Text 120,153,WData$(I+7),CT,3,1,RGB(Yellow),RGB(black)

LC = 173 : Pad = 0
LI = Int(Len(WData$(I+8)) / 13)
If LI > 4 Then LI = 4
For II = 0 To LI
  Forecst$=Mid$(WData$(I+8),((II*13)+1),13)
 If Left$(Forecst$,1)=" " Then
  Forecst$=Mid$(WData$(I+8),((II*13)+2),13)
  Pad=1
 EndIf
 If Pad=1 Then
  Forecst$=Mid$(WData$(I+8),((II*13)+2),13)
 EndIf
  Text 15,LC,Forecst$,LT,3,1,RGB(255,140,26),1
  LC=LC+25
Next II

Loop

'---------------------------------------------------
InfoScreen:
CLS : Border
 Text 120,20,"System Information",CM, 2, 1 ,RGB(Green),RGB(black)
 Text 10,50,MM.Device$,LT, 2, 1 ,RGB(Green),RGB(black)
 Text 10,80,"MM Basic Ver "+Str$(MM.Ver),LT, 2, 1 ,RGB(Green),RGB(black)
 Text 10,110,"Weather.bas Ver 2.1",LT, 2, 1 ,RGB(Green),RGB(black)
 Text 10,140,"MM Watchdog "+Str$(MM.Watchdog),LT, 2, 1 ,RGB(Green),RGB(black)

Delay                         'Allow time to lift Touch

Do While Touch(X) = -1
 Delay
Loop

GoTo Screen1

'---------------------------------------------------

Splash:
CLS
Dim Tex$(17)
Tex$(1)="Look Up Weather Server"
Tex$(2)="Initializing system"
Tex$(3)="Updating libraries"
Tex$(4)="Starting system Logger"
Tex$(5)="Initializing hardware"
Tex$(6)="Setting up modules"
Tex$(7)="Initializing network"
Tex$(8)="Setting up route"
Tex$(9)="Loading fc-cache"
Tex$(10)="Setting up Volumes"
Tex$(11)="Checking file systems"
Tex$(12)="Remounting root"
Tex$(13)="Mounting file system"
Tex$(14)="Enabling other stuff"
Tex$(15)="Setting fun stuff"
Tex$(16)="Setting up LCD Stuff"
Tex$(17)="jman@jman.net.nz"
For I = 1 To 17
 Text 0,I*12,Tex$(I),LT, 1, 1 ,RGB(white),RGB(black)
 Text 190,I*12,"[ OK ]",LT,1, 1, RGB(green),RGB(black)
Pause 500
Next I

Clear
Return

'---------------------------------------------------
Sub Border
 Box 0,0,MM.HRes,MM.VRes,1,RGB(white)
End Sub

'---------------------------------------------------

Sub DayType
Day=Val(DDay$)
  If Day=1 Then Nd$="st"
  If Day=2 Then Nd$="nd"
  If Day=3 Then Nd$="rd"
  If Day > 3 And Day < 21 Then Nd$="th"
  If Day=21 Then Nd$="st"
  If Day=22 Then Nd$="nd"
  If Day=23 Then Nd$="rd"
  If Day >23 And Day < 31 Then Nd$="th"
  If Day=31 Then Nd$="st"
End Sub
'''''''''''''''''''''''''''''''''''''''''''''''''''''''

GetWeather:
If Echo Then Print "Getting Current"
ClearBuffer
'WatchDog 40000
'Check if Link is alive
SendCmd "AT+PING="+Chr$(34)+"www.google.com"+Chr$(34),"OK"
If Error Then GoTo Start          'Restart Wifi Module
Channel$="1"
SendCmd "AT+CIPSTART=1,"+Chr$(34)+"TCP"+Chr$(34)+","+Chr$(34)+SERVER$+Chr$(34)+","+PORT$,"OK"
ServeLine S1$+S2$           'Send Get data to web page
Pause 500                   'Let the data arrive
GetData                     'Sub to read the data
SendCmd "AT+CIPCLOSE=1","OK"    'close the connection
Dow$ = Wdata$(1)
Time$ = Mid$(WData$(2),6,8)
Date$ = Mid$(WData$(2),15,10)
DDay$ = Left$(Date$,2)
DayType
If Echo Then Print Time$;" ";DDay$;" ";Date$
Temp$=Right$(WData$(3),2):Humd$=Right$(WData$(4),2)
Wdata$(5)="Pressure "+Mid$(WData$(5),10,(Len(WData$(5))-12))

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
GetIndoor:
If Echo Then Print "Getting Current Indoor"
'WatchDog 40000
ClearBuffer
Channel$="1"
SendCmd "AT+CIPSTART=1,"+Chr$(34)+"TCP"+Chr$(34)+","+Chr$(34)+SERVER$+Chr$(34)+","+PORT$,"OK"
ServeLine S3$+S2$           'Send Get data to web page
Pause 500                   'Let the data arrive
GetDataIndoor                     'Sub to read the data
SendCmd "AT+CIPCLOSE=1","OK"    'close the connection
InTemp$=IData$(2) : InHumid$=Idata$(3)
InTemp$=Str$(Fix(Val(InTemp$))):InHumid$=Str$(Fix(Val(InHumid$)))
If Len(InTemp$) = 1 Then InTemp$="0"+InTemp$
If Echo Then Print "Indoor ";InTemp$;" ";InHumid$
Return

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' This will get the version number of the firmware running on the module
Function GetVer$()
  Local s$, i
  If error Then Exit Function
  ClearBuffer
  Print #1, "AT+GMR"
  For i = 1 To 3
    s$ = GetLine$()
    If error Then Exit For
    If echo Then Print s$
  Next i
  GetVer$ = s$
End Function

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' This sub sends a single line
' It uses the global channel$ to identify the connection
Sub ServeLine lin$
  If echo Then Print "serveLine ";lin$
  If error Then Exit Sub
  Print #1, "AT+CIPSEND=" + channel$ + "," + Str$(Len(lin$)+2)
  Pause 10
  SendCmd lin$, "SEND OK"
End Sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub GetData

I=0 : c$=""
Do
 Line Input #1, C$
 If echo Then Print c$
Loop While C$ <> "START"
If echo Then Print "Start found ";C$

Do
 I=I+1
 Line Input #1, WData$(I)
 If Echo Then Print WData$(I)
 Loop While WData$(I) <> "END"
If Echo Then Print "End Found ";WData$(I)

End Sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub GetDataInDoor

I=0 : c$=""
Do
 Line Input #1, C$
 If Echo Then Print c$
Loop While C$ <> "START"
If echo Then Print "Start found ";C$

Do
 I=I+1
 Line Input #1, IData$(I)
 If Echo Then Print IData$(I)
 Loop While IData$(I) <> "END"
If Echo Then Print "End Found ";IData$(I)

End Sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

Data "Jan","Feb","Mar","Apr","May","Jun"
Data "Jul","Aug","Sep","Oct","Nov","Dec"

'-----------------------------------------------
'clear-day, clear-night, rain, snow, sleet, wind, fog, cloudy, partly-cloudy-day, or partly-cloudy-night"
Sub Icon (IC, Size)
 Fn$ = Wdata$(IC+4)
Select Case Fn$
 Case "clear-day"
  Fn$="sunny.bmp"
 Case "clear-night"
  Fn$="nclear.bmp"
 Case "rain"
  Fn$="rain.bmp"
 Case "snow"
  Fn$="snow.bmp"
 Case "sleet"
  Fn$="sleet.bmp"
 Case "wind"
  Fn$="windy.bmp"
 Case "fog"
  Fn$="fog.bmp"
 Case "cloudy"
  Fn$="cloudy.bmp"
 Case "partly-cloudy-day"
  Fn$="mcloudy.bmp"
 Case "partly-cloudy-night"
  Fn$="nmcloud.bmp"
 Case Else
 Fn$="blank"
End Select

 If Size=1 Then Fn$="B"+Fn$

 If Echo Then Print "Icon String ";Fn$
End Sub

'-----------------------------------------------
Sub FullDay (FD$)
If FD$="Mon" Then FD$="Monday"
If FD$="Tue" Then FD$="Tuesday"
If FD$="Wed" Then FD$="Wednesday"
If FD$="Thu" Then FD$="Thursday"
If FD$="Fri" Then FD$="Friday"
If FD$="Sat" Then FD$="Saturday"
If FD$="Sun" Then FD$="Sunday"
End Sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' clear the serial input buffer of any junk
Sub ClearBuffer
  Do : Loop Until Input$(255, #1) = ""
End Sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Added by Jman

Sub SendCmd cmd$, response$
  Local InputStr$
  If Error Then Exit Sub
  ClearBuffer
  Print #1, cmd$
 Do
  InputStr$ = GetLine$()
  If Echo <> 0 Then Print "From ESP ";InputStr$+" required ";response$
 Loop Until Instr(InputStr$, response$) > 0 Or Error = 1
 Resp$=InputStr$
End Sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Added by Jman
Function GetLine$()
  Local s$, c$
  Timer = 0
  Do
    c$ = Input$(1, #1)
    If echo Then Print c$;
    If Asc(c$) = 13 Or Len(s$) >= 254 Then
      GetLine$ = s$
    Else
      If Asc(c$) >= 32 Then s$ = s$ + c$
    EndIf
    If Timer > Timeout Then Error = 1
    Loop Until Asc(c$) = 13 Or Len(s$) >= 254 Or Error = 1
End Function

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub CheckWiFi
 Pause 1500                       'Allow Module to boot
 ClearBuffer : Resp$ = ""
 SendCMD "AT","OK"

If Resp$ <> "OK" Then WiFisetup

Resp$ = GetAddr$()

If Resp$ = "+CIFSR:APIP,"+Chr$(34)+"192.168.4.1"+Chr$(34) Then
   WiFiSetup
EndIf

If Resp$ <> "+CIFSR:STAIP,"+Chr$(34)+"0.0.0.0"+Chr$(34) Then
 ' Close #1
 Exit Sub
EndIf

WifiSetup               'Setup WiFi using Mobile

End Sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' This will get the IP address of the module
Function GetAddr$()
  Local Integer i, j
  Local String s$
  If error Then Exit Function
    For i = 1 To 20
    ClearBuffer
        Print #1, "AT+CIFSR"
    For j = 1 To 3
      s$ = GetLine$()
      If error Then Exit For
      If echo Then Print s$
    Next j
    If Len(s$) > 5 Or error Then Exit For
    Pause 1000
  Next i
  GetAddr$ = s$
  Addr$=Mid$(s$, 15, Len(s$)-15)
End Function

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Added by Jman
Sub WiFiSetup               'Setup WiFi Using Mobile
' Close #1
 WatchDog (5*60*1000)       '5 Minutes to complete setup
' Open "COM1:115200, 1024" As #1  'Module must be set to same rate
 Error=0                    'Reset Error Flag
 SendCMD "AT+RESTORE","OK" : Pause 5000
 ClearBuffer
 SendCmd "AT","OK"
 ClearBuffer

 CLS
  MessageBoxWiFi "WiFi Setup", "Start ESP SmartConfig", "On Mobile"
  SendCMD "AT+CWMODE_DEF=1","OK"
  SendCMD "AT+CWSTARTSMART=1","OK"

Do
 a$=""
 a$ = Input$(1, #1)
 If Len(s$) >= 254 Then s$ = Right$(s$, 125)
 If Asc(a$) >= 32 Then s$ = s$ + a$
 If Echo Then Print s$
 Loop Until Right$(s$,26)="smartconfig connected wifi"

 SendCMD "AT+CWSTOPSMART","OK"
 CLS
 SendCMD "AT+CWMODE_DEF=1","OK"
 Resp$ = GetAddr$()
 MessageBoxWiFi "Success", "  IP Address  ", Mid$(Resp$,15,(Len(Resp$)-15))

End Sub

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' this handy routine draws a message box with an OK button
' then waits for the button to be touched Modded by Jman
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub MessageBoxWiFi s1 As String, s2 As String, s3 As String
  Local Integer w
  If Len(s1) > Len(s2) Then w = Len(s1) Else w = Len(s2)
  w = w * 2     ' get the width of the text (used for the box width)

  ' draw the box and the message in it
  RBox 20, 20, 200, 220, 5, RGB(Yellow)
  Text MM.HRes/2, 40, s1, CT, 1, 1, RGB(white)
  Text MM.HRes/2, 80, s2, CT, 1, 1, RGB(white)
  Text MM.HRes/2, 110, s3, CT, 1, 1, RGB(white)

  ' draw the OK button
  RBox 70, 195, 100, 34, , RGB(Yellow), RGB(Yellow)
  Text 120, 212, "OK", CM, 1, 2, RGB(White)

  ' wait for the button to be touched
  Do While Not (Touch(x) > 80 And Touch(x) < 175 And Touch(y) > 200 And Touch(y) < 225) : Loop

  ' draw the OK button as depressed
  RBox 70, 195, 100, 34, , RGB(Yellow), RGB(White)
  Text 120, 212, "OK", CM, 1, 2, RGB(Yellow)

  ' wait for the touch to be removed
  Do While Touch(x) <> -1 : Loop
End Sub

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub Delay
 Pause 500
End Sub

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''