CPU 40
Option EXPLICIT
Option BASE 1
Option AUTORUN ON
'====================================================
' Commands for the MP3 Module
' MP3PlayRoot #			Plays Specified track in the root
' MP3Pause				Pause PlayBack
' MP3Play				Play Current Folder Track 1
' MP3PlayLoop #			Play Specified folder in a loop
' MP3STOP				Stop current Playback
' MP3PLAYFT #, #		Play Specified folder, track
' MP3Vol #				Set Playback Volume range 1-30

Dim CCMD(10)              'MP3 Module array
Dim F, TRACK, TOTALFOLDERS, CCMDADD, I, CHECKSUM, REPLY$, RP$
Dim Busyout, MP3Busy, Vol, Debug

CCMD(1)=&H7E:CCMD(2)=&HFF 'MP3 Module commands
CCMD(3)=&H06:CCMD(4)=&H00
CCMD(5)=&H00:CCMD(6)=&H00
CCMD(7)=&H00:CCMD(8)=&H00
CCMD(9)=&H00:CCMD(10)=&HEF

Debug = 0                  'Set to 1 enable debug

Open "COM1:9600" As #1
SetPin  31, DIN            'MP3 Busy Signal
MP3Busy=31                 'MP3 Module Busy Signal
Vol = 15                   'StartUp Volume

GoSub SetupMP3             'Setup Folders etc...

 MP3PlayRoot 1              'Play 1 track in the root

 Do While Pin(Mp3Busy)=0    'Wait for Track to finish
 Loop

 Mp3PlayFT 1, 2            'Play Track 2 from Folder 1

End


'====================================================
SetupMp3:     'Get Number Of Folders
Pause 2000    'Allow MP3 Module to start
CLEARBUFFER
MP3QTOTALF
GETREPLY

If Asc(Mid$(REPLY$,4,1)) = 64 Then
 MP3ERROR
  CPU Restart
EndIf

TotalFolders = Asc(Mid$(REPLY$,7,1))-1

If Debug Then Print "Total Folders ";TotalFolders

Local Tracksinfolder(TotalFolders)

For F = 1 To Totalfolders       'Get umber of tracks in each folder
ClearBuffer
 MP3QTRACKS F
 GETREPLY
 If Asc(Mid$(REPLY$,4,1)) = 64 Then
   TRACKSINFOLDER(F) = 0
  Else
   TRACKSINFOLDER(F) = Asc(Mid$(REPLY$,7,1))
 EndIf
Next F

If Debug Then Print "There are ";TOTALFOLDERS;" Total Folders"

If Debug Then
 For F = 1 To TOTALFOLDERS
 Print "In Folder";F;", There are";TRACKSINFOLDER(F);" Tracks"
 Next F
EndIf

Mp3Vol (Vol)

Return

'==========================================
Sub MP3ERROR
If Debug Then  Print "MP3 FOLDER ERROR"
  Timer=0
 Do While Timer < 5000
 Loop
End Sub

'====================================================
Sub CLEARBUFFER
 Do : Loop Until Input$(255, #1) = ""
End Sub

'====================================================
Sub GETREPLY
REPLY$=""
Pause 500

Do
 RP$=Input$(1,#1)
 REPLY$=REPLY$ + RP$
 Loop While Loc(#1) > 0
End Sub

'====================================================
Sub MP3Pause
 If Debug Then Print "Pause Sub"
 CCMD(4)=&H0E
 CCMD(7)=0
 SENDCMD
End Sub

'====================================================
Sub MP3Play
 If Debug Then Print "Play Sub"
 CCMD(4)=&H0D
 CCMD(7)=0
 SENDCMD
End Sub

'====================================================
Sub MP3PlayRoot (Track)
 If Debug Then Print "Play Root Sub"
 CCMD(4)=&H03
 CCMD(7)=Track
 SENDCMD
End Sub

'====================================================
Sub MP3PlayLoop (Folder)
 If Debug Then Print "Play Folder Loop"
 CCMD(4)=&H17
 CCMD(7)=Folder
 SENDCMD
End Sub

'====================================================
Sub MP3STOP
CCMD(4)=&H16
CCMD(7)=0
SENDCMD
End Sub

'====================================================
Sub MP3QTOTALF
 CCMD(4)=&H4F
 CCMD(7)=0
 SENDCMD
End Sub

'====================================================
Sub MP3QTRACKS (Folder)
CCMD(4)=&H4E
CCMD(7)=FOLDER
SENDCMD
CCMD(7)=0
End Sub

'====================================================
Sub MP3VOL (VOL) 'VOLUME = 1 - 30
If VOL  > 30 Then VOL = 30
If VOL < 1 Then VOL = 1
CCMD(4)=&H06
CCMD(7)=VOL
If Debug Then Print "MP3 VOLUME = ";Vol
SENDCMD
End Sub

'====================================================
Sub MP3PLAYFT FOLDER, TRACK
CCMD(4)=&H0F
CCMD(6)=FOLDER
CCMD(7)=TRACK
SENDCMD
CCMD(6)=0
End Sub

'====================================================
Sub SENDCMD
CCMDADD = 0
For I = 2 To 7
CCMDADD = CCMDADD + CCMD(I)
Next I
CHECKSUM = 0 - CCMDADD
CCMD(8)=CHECKSUM >> 8 And &HFF
CCMD(9)=CHECKSUM And &HFF
For I = 1 To 10
If Debug Then Print Hex$(CCMD(I))+" ";
Print #1, Chr$(CCMD(I));
Next I
Pause 100     'Small Delay to avoid lockup
End sub
'====================================================