''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Setup Pins and variables
Option Explicit

SetPin 2, DOut
SetPin 3, DOut
SetPin 4, DOut
SetPin 5, DOut

SetPin 21, DOut
SetPin 22, DOut
SetPin 23, DOut
SetPin 24, DOut
SetPin 25, DOut
SetPin 26, DOut

SetPin 6, Din, PullUp
SetPin 7, Din, PullUp
SetPin 9, Din, PullUp

Dim Hour(2), Minute(2), Second(2)
Dim Hours, Minutes, Seconds, SetUpM, SetUpS
Dim DelayTime
Dim TestTime$
DelayTime=2.5          'Led on time im MS

RTC GETTIME            'Read Time from RTC Module
Print Time$

 Test                  'Led Test
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Main loop
Do
 DisplayTime    'Display the Time
 If TestTime$ <> Time$ Then CalcBCD 'Check if we need to recalc the BCD
 If Pin(9) = 0 Then SetTime
 If Time$ = "00:00:00" Then RTC GETTIME	'Wait untill Midnight then re Read RTC
Loop          'Loop for ever

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Get the BCD from Time$
Sub CalcBCD
 TestTime$=Time$
 Hours=Val(Left$(Time$,2))
 Hour(1)= Fix(Hours/10)         'Fix is only the interger
 Hour(2)= Hours - (Hour(1) * 10)

 Minutes=Val(Mid$(Time$,4,2))
 Minute(1)= Fix(Minutes/10)       'Fix is only the interger
 Minute(2)= Minutes - (Minute(1) * 10)

 Seconds=Val(Right$(Time$,2))
 If SetUpS = 1 Then Seconds=0       'Check if in set time mode
 Second(1)= Fix(Seconds/10)       'Fix is only the interger
 Second(2)= Seconds - (Second(1) * 10)
End Sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Show Time on LED Matrix
Sub DisplayTime
'Hours
 Port(2, 4) = Hour(1)  'Set the Column on
 Pin(21)=1             'Turn on Hours Tens
 Delay
 Pin(21)=0             'Turn off Hours Tens

 Port(2, 4) = Hour(2)  'Set the Column on
 Pin(22)=1             'Turn on Hours UnitsDelay
 delay
 Pin(22)=0             'Turn off Hours Units

'Minutes
 Port(2, 4) = Minute(1)  'Set the Column on
 Pin(23)=1             'Turn on Minutes Tens
 Delay
 Pin(23)=0             'Turn off Minutes Tens

 Port(2, 4) = Minute(2)  'Set the Column on
 Pin(24)=1             'Turn on Minutes Units
 Delay
 Pin(24)=0             'Turn off Minutes Units

'Seconds
 Port(2, 4) = Second(1)  'Set the Column on
 Pin(25)=1             'Turn on Seconds Tens
 Delay
 Pin(25)=0               'Turn off Seconds Tens

 Port(2, 4) = Second(2)  'Set the Column on
 Pin(26)=1             'Turn on Seconds Units
 Delay
 Pin(26)=0             'Turn off Seconds Units

End Sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Delay for on Time
Sub Delay
 Timer=0
 Do While Timer < DelayTime 'Wait the set delay time
 Loop
End Sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Start LED Test
Sub Test
 Local I, B
 For I = 21 To 26 'Columns
 Pin(I) = 1
  For B = 2 To 5  'Rows
   Pin(B)=1
   Pause 100
   Pin(B)=0
  Next B
 Pin(I)=0
 Next I

 For I = 2 To 5   'Rows
 Pin(I) = 1
  For B = 21 To 26  'Columns
   Pin(B)=1
   Pause 100
   Pin(B)=0
  Next B
 Pin(I)=0
 Next I

End Sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Set the time using the buttons
Sub SetTime

 Debounce 9
 SetUpM = 0          'Reset minutes flag

Do
  SetUpS=1                'Stop Seconds Count
  CalcBCD
  DisplayTime

 If Pin(7) = 0 Then
 Debounce 7
   Hours = Hours - 1
   If Hours < 0 Then Hours = 23
   Time$=Str$(Hours)+":"+Str$(Minutes)+":00"
 End If

 If Pin(6) = 0 Then
  Debounce 6
   Hours = Hours + 1
   If Hours > 23 Then Hours = 0
   Time$=Str$(Hours)+":"+Str$(Minutes)+":00"
 End If

  Do While Pin(9) = 0     'Debounce Select Button
   Pause 150              'Debouce Time
   SetUpM=1
  Loop

 Do While SetUpM = 1      'Minutes adjust
  SetUpS=1                'Stop Seconds Count
  CalcBCD
  DisplayTime

  If Pin(7) = 0 Then
   Debounce 7
   Minutes = Minutes - 1
  If Minutes < 0 Then Minutes = 59
   Time$=Str$(Hours)+":"+Str$(Minutes)+":00"
  End If

 If Pin(6) = 0 Then
 Debounce 6
   Minutes = Minutes + 1
   If Minutes > 59 Then Minutes = 0
   Time$=Str$(Hours)+":"+Str$(Minutes)+":00"
  End If

 Do While Pin(9) = 0     'Check for setting completed
  Pause 150              'Debouce Time
  SetUpM=0: SetUpS=0
 Loop

 If SetUpS=0 Then
  RTC SETTIME Val(Right$(Date$,4)), Val(Mid$(Date$,4,2)), Val(Left$(Date$,2)), Hours, Minutes, Seconds
  CPU Restart            'Restart
 End If
 Loop

Loop

End Sub

'''''''''''''''''''''''''''''''''
'Debounce
Sub Debounce(I)
 Do While Pin(I) = 0  'Check for Debounce
  Pause 150
 Loop
End Sub