' mite-cnc.bas v1.5 (MicroMite Mk.1)
' Parallel input as per LinuxCNC
' --or--
' Serial input (console port) with...
' G-code parser: A sub-set of the most common commands
'
' Author: led-bloon
' Date: 1/4/2015
' I/P Pins 15,16,17 & 18 (limit switches) - commented code
'
DBG=0
Serial=1
Metric=0
DrawMode=1
'
ConstTimeDelay=10
ConstUnknown=999
'
Version$="v1.5": CurrentCmd$=""
'
PosnX=ConstUnknown: PosnY=ConstUnknown: PosnZ=ConstUnknown
CountX=0: CountY=0: CountZ=0
DirnX=0: DirnY=0: DirnZ=0
xMin=0: xMax=0: yMin=0: yMax=0: zMin=0: zMax=0
StepsPerInch=0: StepsPerMM=0: StepperDelay=0
LineNumber=0: Running=0
'
InitHardware
If Serial=0 Then
  While Inkey$=""
  Wend
Else
  DoMainLoop
  ShutDown
EndIf
Print "Program Exit!"
End
'
Sub DoMainLoop
Local i, A$, B$, C$

  Print"[";: Print LineNumber;: Print "] ";
  Do
    Line Input "RDY: ", B$
    A$=TidyInput$(B$): C$=""
    For i=1 To Len(A$)
      B$=Mid$(A$,i,1)
      If B$=" " Then
        If C$="G0" Or C$="G00" Or C$="G1" Or C$="G01" Then
          CurrentCmd$=C$: DoLineMove(A$): Print "ACK"
        ElseIf C$="G2" Or C$="G02" Or C$="G3" Or C$="G03" Then
          CurrentCmd$=C$: DoArcMove(A$): Print "ACK"
        ElseIf Left$(C$,1)="X" Or Left$(C$,1)="Y" Or Left$(C$,1)="Z" Then
          If CurrentCmd$="G0" Or CurrentCmd$="G00" Or CurrentCmd$="G1" Or CurrentCmd$="G01" Then
            DoLineMove(A$): Print "ACK"
          ElseIf CurrentCmd$="G2" Or CurrentCmd$="G02" Or CurrentCmd$="G3" Or CurrentCmd$="G03" Then
            DoArcMove(A$): Print "ACK"
          EndIf
        ElseIf C$="G20" Then
          Metric=0: Print "ACK"
        ElseIf C$="G21" Then
          Metric=1: Print "ACK"
        ElseIf C$="I" Then
          Print "Information:"
          Print "X: ";: Print PosnX;: Print "  Y: ";: Print PosnY;: Print "  Z: ";: Print PosnZ
        ElseIf C$="G17" Or C$="G90" Or C$="G90.1" Or C$="M3" Or C$="M03" Then
          Print "ACK"     '  default
        ElseIf C$="M6" Or C$="M06" Then
          DoToolChange: Print "ACK"
        ElseIf C$="G91" Or C$="G91.1" Then
          FatalError(1)
        ElseIf C$="M2" Or C$="M02" Or C$="M30" Then
          Print "ACK"
          Exit Do       ' Finished
        Else
          Print "NAK: ";: Print C$;: Print " Command not implemented!"
        EndIf
        Exit For
      ElseIf (B$="(") And (i=1) Then  ' Single line comment
        Exit For
      ElseIf (B$="#") And (i=1) Then  ' ???
        Exit For
      Else
        C$=C$+B$
      EndIf
    Next i
    LineNumber=LineNumber+1
    Print "[";: Print LineNumber;: Print "] ";
  Loop
End Sub
'
Function CalcSteps(distance)
Local NumSteps, multi
' MY ranges: .25in; 2.5in; anything above
  If Metric=1 Then multi=25.4 Else multi=1
  If distance<=0.25*multi Then
    NumSteps=10
  ElseIf distance<=2.5*multi Then
    NumSteps=100
  Else
    NumSteps=1000
  EndIf
  CalcSteps=NumSteps
End Function
'
Sub DoArcLine(Xend, Yend, I, J)
Local a, sqRadius, NumSteps, DeltaX, TempX
Local NewX, NewY, Offset

  DeltaX=Sqr((Xend-PosnX)*(Xend-PosnX)+(Yend-PosnY)(Yend-PosnY))
  NumSteps=CalcSteps(DeltaX)
  sqRadius=(PosnX-I)*(PosnX-I)+(PosnY-J)*(PosnY-J)
  NewX=PosnX: DeltaX=(Xend-PosnX)/NumSteps
  If CurrentCmd$="G2" Or CurrentCmd$="G02" Then
    If (PosnX>I) And (PosnY>=J) Then
      Offset=1      ' Q1
    ElseIf (PosnX<=I) And (PosnY>J) Then
      Offset=1      ' Q2
    ElseIf (PosnX<I) And (PosnY<=J) Then
      Offset=-1     ' Q3
    ElseIf (PosnX>=I) And (PosnY<J) Then
      Offset=-1     ' Q4
    Else
      Print "WTF CW Arc!"
      Exit Sub
    EndIf
  Else
    If (PosnX>=I) And (PosnY>J) Then
      Offset=1      ' Q1
    ElseIf (PosnX<I) And (PosnY>=J) Then
      Offset=1      ' Q2
    ElseIf (PosnX<=I) And (PosnY<J) Then
      Offset=-1     ' Q3
    ElseIf (PosnX>I) And (PosnY<=J) Then
      Offset=-1     ' Q4
    Else
      Print "WTF CCW Arc!"
      Exit Sub
    EndIf
  EndIf
  For a=1 To NumSteps-1
    NewX=NewX+DeltaX
    If NewX<I Then TempX=I-NewX Else TempX=NewX-I
    NewY=J+Offset*Sqr(sqRadius - (TempX*TempX))
    MoveToNewX(NewX): MoveToNewY(NewY)
  Next a
  MoveToNewX(Xend): MoveToNewY(Yend)
End Sub
'
Sub DoCircleMove(I, J)
Local a, Radius, deltaX, deltaY, StepInc, multi
Local SaveX, SaveY, SaveZ, NewX, NewY

  SaveX=PosnX: SaveY=PosnY: SaveZ=PosnZ
  deltaX=PosnX-I: deltaY=PosnY-J
  Radius=Sqr(deltaX*deltaX+deltaY*deltaY)
  NewX=I: NewY=J+Radius
  If Metric=1 Then multi=25.4 Else multi=1
  If Radius < 0.04*multi Then
    StepInc=10
  ElseIf Radius < 0.4*multi Then
    StepInc=1
  Else
    StepInc=0.1
  EndIf

  MoveToNewZ(0): MoveToNewX(NewX): MoveToNewY(NewY): MoveToNewZ(SaveZ)
  For a=1 To 360 Step StepInc
    deltaX=Radius*Sin(Rad(a)): deltaY=Radius*Cos(Rad(a))
    NewX=I+deltaX: NewY=J+deltaY
    MoveToNewX(NewX): MoveToNewY(NewY)
  Next a
  MoveToNewZ(0): MoveToNewX(SaveX): MoveToNewY(SaveY): MoveToNewZ(SaveZ)
End Sub
'
Sub DoArcMove(inp$)
Local A$, B$, i, Xend, Yend, ThisI, ThisJ

  If DrawMode=1 Or CurrentCmd$="G2" Or CurrentCmd$="G02" Then
    StepperDelay=0
  Else
    StepperDelay=ConstTimeDelay
  EndIf
  B$="": Xend=ConstUnknown: Yend=ConstUnknown
  ThisI=ConstUnknown: ThisJ=ConstUnknown
  For i=1 To Len(inp$)
    A$=Mid$(inp$,i,1)
    If A$=" " Then
      A$=Left$(B$,1)
      B$=Right$(B$, Len(B$)-1)
      If A$="X" Then
        Xend=Val(B$)
      ElseIf A$="Y" Then
        Yend=Val(B$)
      ElseIf A$="I" Then
        ThisI=Val(B$)
      ElseIf A$="J" Then
        ThisJ=Val(B$)
      ElseIf A$="G" Then
'       Do nothing with G start code
      Else
        Print "Info: Arc move ignoring ";: Print A$+B$
      EndIf
      B$=""
    Else
      B$=B$+A$
    EndIf
  Next i
  If ThisI=ConstUnknown Or ThisJ=ConstUnknown Then
    FatalError(2)
  EndIf
  If (Xend=ConstUnknown) And (Yend=ConstUnknown) Then
    DoCircleMove(ThisI, ThisJ)
  Else
    DoArcLine(Xend, Yend, ThisI, ThisJ)
  EndIf
End Sub
'
Sub DoDiagonalMove(EndX, EndY)
Local a, NumSteps, theta
Local SaveX, SaveY, NewX, NewY, DeltaX

  SaveX=PosnX: SaveY=PosnY
  DeltaX=Sqr((EndX-PosnX)*(EndX-PosnX)+(EndY-PosnY)*(EndY-PosnY))
  NumSteps=CalcSteps(DeltaX)
  DeltaX=(EndX-PosnX)/NumSteps
  theta=Atn((EndX-PosnX)/(EndY-PosnY))
  NewX=PosnX
  For a=1 To NumSteps-1
    NewX=NewX+DeltaX
    NewY=SaveY+((NewX-SaveX)/Tan(theta))
    MoveToNewX(NewX): MoveToNewY(NewY)
  Next a
  MoveToNewX(EndX): MoveToNewY(EndY)
End Sub
'
Sub DoLineMove(inp$)
Local A$, B$, i, NewX, NewY, NewZ

  If DrawMode=1 Or CurrentCmd$="G0" Or CurrentCmd$="G00" Then
    StepperDelay=0
  Else
    StepperDelay=ConstTimeDelay
  EndIf
  NewX=ConstUnknown: NewY=ConstUnknown: NewZ=ConstUnknown
  B$=""
  For i=1 To Len(inp$)
    A$=Mid$(inp$,i,1)
    If A$=" " Then
      If Len(B$)>0 Then
        A$=Left$(B$,1)
        B$=Right$(B$, Len(B$)-1)
        If A$="X" Then
          NewX=Val(B$)
        ElseIf A$="Y" Then
          NewY=Val(B$)
        ElseIf A$="Z" Then
          NewZ=Val(B$)
        ElseIf A$="G" Then
'         Do nothing with G start code
        Else
          Print "Info: Line move ignoring ";: Print A$+B$
        EndIf
        B$=""
      EndIf
    Else
      B$=B$+A$
    EndIf
  Next i
  If NewX=PosnX Then NewX=ConstUnknown
  If NewY=PosnY Then NewY=ConstUnknown
  If NewZ=PosnZ Then NewZ=ConstUnknown
  If (NewZ <> ConstUnknown) Then
    If (NewZ >= zMin) And (NewZ <= zMax) Then MoveToNewZ(NewZ)
    If (NewX=ConstUnknown) And (NewY=ConstUnknown) Then Exit Sub
  EndIf
  If (NewX <> ConstUnknown) And (NewY <> ConstUnknown) Then
    DoDiagonalMove(NewX, NewY)
  ElseIf (NewX <> ConstUnknown) And (NewY = ConstUnknown) Then
    MoveToNewX(NewX)
  ElseIf (NewY <> ConstUnknown) And (NewX = ConstUnknown) Then
    MoveToNewY(NewY)
  Else
    Print "Info: No movement needed - ";: Print inp$
  EndIf
End Sub
'
Sub DoToolChange
Local DelaySave, SaveZ

  Print "Tool change - standby"
  DelaySave=StepperDelay: StepperDelay=0
  SaveZ=PosnZ: MoveToNewZ(zMax)
  Print "Paused!"
  Print "Manually stop & start spindle ... ANY key to resume"
  Do While Inkey$=""
  Loop
  MoveToNewZ(SaveZ)
  StepperDelay=DelaySave
End Sub
'
Sub ManualControl
Local I$, mtr$, Delay, Paused

  Print "Manual control - Set 'H'ome location (X,Y & Z axes)"
  Print "X,Y or Z - Select motor"
  Print "'R'everse, 'P'ause, 'S'peed"
  Print "'H'ome (set),'Q'uit"
  DirnX=1: DirnY=0: DirnZ=0: StepperDelay=0
  mtr$="X": Paused=1: Delay=0
  Do
    I$=UCase$(Inkey$)
    If I$="X" Then
      mtr$="X"
    ElseIf I$="Y" Then
      mtr$="Y"
    ElseIf I$="Z" Then
      mtr$="Z"
    ElseIf I$="S" Then
      Delay=1-Delay
    ElseIf I$="P" Then
      Paused=1-Paused
    ElseIf I$="R" Then
      If mtr$="X" Then
        DirnX=1-DirnX
      ElseIf mtr$="Y" Then
        DirnY=1-DirnY
      ElseIf mtr$="Z" Then
        DirnZ=1-DirnZ
      EndIf
    ElseIf I$="Q" Then
      If PosnX=ConstUnknown Then
        Print "You must set 'H'ome position before exiting!"
      Else
        Exit Do
      EndIf
    ElseIf I$="H" Then
      PosnX=0: PosnY=0: PosnZ=0
    EndIf
    If Paused=0 Then
      If mtr$="X" Then
        DoStepX
      ElseIf mtr$="Y" Then
        DoStepY
      Else
        DoStepZ
      EndIf
      If Delay>0 Then Pause(ConstTimeDelay)
    EndIf
  Loop
  Running=1
End Sub
' Tidy G-code
Function TidyInput$(ip$)
Local i, j, numFlag, op$, A$, B$

  A$=""
  For i=1 To Len(ip$)           ' Non-printable?
    B$=Mid$(ip$,i,1)
    If B$=Chr$(9) Then B$=" "   ' TABs?
    If B$="(" Then Exit For     ' In-line comment?
    If (B$ >= " ") And (B$ <= "z") Then A$=A$+B$
  Next i
  A$=UCase$(A$): j=Len(A$): op$="": numFlag=0
  For i=1 To j                  ' Unwanted spaces?
    B$=Mid$(A$,i,1)
    If B$=" " Then
      If numFlag=1 Then
        numFlag=0: op$=op$+" "
      EndIf
    Else
      If ((B$ >= "0") And (B$ <= "9")) Or (B$=".") Then
        numFlag=1
      ElseIf B$="," Then
        B$=".": numFlag=1
      ElseIf numFlag=1 Then
        numFlag=0: op$=op$+" "
      EndIf
      op$=op$+B$
    EndIf
  Next i
  If Right$(op$,1) <> " " Then op$=op$+" "
  If Left$(op$,1)="N" Then  ' Line numbers?
    j=Len(op$)
    For i=2 To j
      If Mid$(op$,i,1)=" " Then
        TidyInput$=Right$(op$, j-i)
        Exit For
      EndIf
    Next i
  Else
    TidyInput$=op$
  EndIf
End Function
'
Sub SetDefaults()
Local a, multi, StepsPerRev, RevsPerInch, RevsPerMM
Local A$, B$, C$

  StepsPerRev=200: RevsPerInch=23.99: RevsPerMM=0.9445
  xMin = -7.00: xMax=0.025: yMin = -0.025: yMax=10.0: zMin = -0.025: zMax=2.5
  If Metric=1 Then
    Print "Using metric system"
    multi=25.4: C$=" mm"
    xMin=xMin*25.4: yMin=yMin*25.4: zMin=zMin*25.4
    xMax=xMax*25.4: yMax=yMax*25.4: zMax=zMax*25.4
  Else
    Print "Using imperial system"
    multi=1: C$=" in"
  EndIf
  B$="Set - Steps per Revolution (default "+Str$(StepsPerRev)+"): "
  Line Input B$, A$
  If A$<>"" Then
    a=Val(A$)
    If (a>50) And (a<500) Then StepsPerRev=Abs(a)
  EndIf
  If Metric=0 Then
    B$="Set - Revolutions per Inch (default "+Str$(RevsPerInch)+"): "
    Line Input B$, A$
    If A$<>"" Then
      a=Val(A$)
      If (a>10) And (a<100) Then RevsPerInch=a
    EndIf
    StepsPerInch=StepsPerRev*RevsPerInch
    StepsPerMM=StepsPerInch/25.4
  Else
    B$="Set - Revolutions per 10 mm (default "+Str$(RevsPerMM*10)+"): "
    Line Input B$, A$
    If A$<>"" Then
      a=Val(A$)
      If (a>1) And (a<100) Then RevsPerMM=a/10
    EndIf
    StepsPerMM=StepsPerRev*RevsPerMM
    StepsPerInch=StepsPerMM*25.4
  EndIf
  B$="Set - X axis minimum value (def: "+Str$(xMin)+C$+"): "
  Line Input B$, A$
  If A$<>"" Then
    a=Val(A$)
    If (a >= -7*multi) And (a < 0) Then xMin=a Else Print "Out of range!"
  EndIf
  B$="Set - X axis maximum value (def: "+Str$(xMax)+C$+"): "
  Line Input B$, A$
  If A$<>"" Then
    a=Val(A$)
    If (a >= 0) And (a < 0.5*multi) Then xMax=a Else Print "Out of range!"
  EndIf
  B$="Set - Y axis minimum value (def: "+Str$(yMin)+C$+"): "
  Line Input B$, A$
  If A$<>"" Then
    a=Val(A$)
    If (a >= -1*multi) And (a <= 0) Then yMin=a Else Print "Out of range!"
  EndIf
  B$="Set - Y axis maximum value (def: "+Str$(yMax)+C$+"): "
  Line Input B$, A$
  If A$<>"" Then
    a=Val(A$)
    If (a > 0) And (a <= 10*multi) Then yMax=a Else Print "Out of range!"
  EndIf
  B$="Set - Z axis minimum value (def: "+Str$(zMin)+C$+"): "
  Line Input B$, A$
  If A$<>"" Then
    a=Val(A$)
    If (a >= -1*multi) And (a <= 0) Then zMin=a Else Print "Out of range!"
  EndIf
  B$="Set - Z axis maximum value (def: "+Str$(zMax)+C$+"): "
  Line Input B$, A$
  If A$<>"" Then
    a=Val(A$)
    If (a > 0) And (a <= 4*multi) Then zMax=a
  EndIf
End Sub
'
Sub InitHardware()
  Print "Mite-CNC ";: Print Version$
  If Serial=0 Then     ' Parallel I/P uses interrupts
    Print "Parallel port mode";
    SetPin 2, inth, intStepX
    SetPin 3, inth, intStepY
    SetPin 4, inth, intStepZ
  Else
    Print "Serial port mode";
  EndIf
  If DBG=1 Then Print " with debug set!"
  Print

  SetPin 5, din: SetPin 6, din: SetPin 7, din
  SetPin 15, din: SetPin 16, din: SetPin 17, din: SetPin 18, din
  SetPin 9, dout: Pin(9)=0
  SetPin 10, dout: Pin(10)=0
  SetPin 14, dout: Pin(14)=0
  SetPin 21, dout: Pin(21)=0
  SetPin 22, dout: Pin(22)=0
  SetPin 23, dout: Pin(23)=0
  SetPin 24, dout: Pin(24)=0
  SetPin 25, dout: Pin(25)=0
  SetPin 26, dout: Pin(26)=0

  If Serial=1 Then
    SetDefaults
    ManualControl
  EndIf
End Sub
'
Sub ShutDown()
  StepperDelay=0
  MoveToNewZ(zMax)
  MoveToNewX(0)
  MoveToNewY(0)
  If Serial=0 Then
    SetPin 2, din: SetPin 3, din: SetPin 4, din
  EndIf
  Pin(21)=0: Pin(22)=0: Pin(23)=0
  Pin(24)=0: Pin(25)=0: Pin(26)=0
End Sub
'
Sub MoveToNewX(EndX)
Local i, j, travel

  If EndX>xMax Then FatalError(5)
  travel=EndX-PosnX
  If travel<0 Then
    DirnX=0: travel = -travel
  Else
    DirnX=1
  EndIf
  If Metric=0 Then j=travel*StepsPerInch Else j=travel*StepsPerMM
  For i=1 To j: DoStepX: Next i
  PosnX=EndX
End Sub
'
Sub MoveToNewY(EndY)
Local i, j, travel

  If EndY<yMin Then FatalError(6)
  travel=EndY-PosnY
  If travel<0 Then
    DirnY=0: travel = -travel
  Else
    DirnY=1
  EndIf
  If Metric=0 Then j=travel*StepsPerInch Else j=travel*StepsPerMM
  For i=1 To j: DoStepY: Next i
  PosnY=EndY
End Sub
'
Sub MoveToNewZ(EndZ)
Local i, j, travel

  If EndZ<zMin Or EndZ>zMax Then FatalError(7)
  travel=EndZ-PosnZ
  If travel<0 Then
    DirnZ=0: travel = -travel
  Else
    DirnZ=1
  EndIf
  If Metric=0 Then j=travel*StepsPerInch Else j=travel*StepsPerMM
  For i=1 To j: DoStepZ: Next i
  PosnZ=EndZ
End Sub
'
Sub DoStepX
'    If Pin(15)=1 Or Pin(18)=1 Then
'      If Running=0 Then
'        Print "'X' Stopped!"
'        Exit Sub
'      Else
'        FatalError(4)
'      EndIf
'    EndIf
  If DirnX=0 Then
    If CountX>2 Then CountX=0 Else CountX=CountX+1
  Else
    If CountX>0 Then CountX=CountX-1 Else CountX=3
  EndIf
  If CountX=0 Then
    Pin(9)=0: Pin(21)=1: Pin(22)=0
  ElseIf CountX=1 Then
    Pin(9)=0: Pin(21)=0: Pin(22)=1
  ElseIf CountX=2 Then
    Pin(9)=1: Pin(21)=1: Pin(22)=0
  Else
    Pin(9)=1: Pin(21)=0: Pin(22)=1
  EndIf
  If StepperDelay>0 Then Pause(StepperDelay)
End Sub
'
Sub DoStepY
'    If Pin(16)=1 Or Pin(18)=1 Then
'      If Running=0 Then
'        Print "'Y' Stopped!"
'        Exit Sub
'      Else
'        FatalError(4)
'      EndIf
'    EndIf
  If DirnY=1 Then    '  NB Y opposite to X&Z
    If CountY>2 Then CountY=0 Else CountY=CountY+1
  Else
    If CountY>0 Then CountY=CountY-1 Else CountY=3
  EndIf
  If CountY=0 Then
    Pin(10)=0: Pin(23)=1: Pin(24)=0
  ElseIf CountY=1 Then
    Pin(10)=0: Pin(23)=0: Pin(24)=1
  ElseIf CountY=2 Then
    Pin(10)=1: Pin(23)=1: Pin(24)=0
  Else
    Pin(10)=1: Pin(23)=0: Pin(24)=1
  EndIf
  If StepperDelay>0 Then Pause(StepperDelay)
End Sub
'
Sub DoStepZ
'    If Pin(17)=1 Or Pin(18)=1 Then
'      If Running=0 Then
'        Print "'Z' Stopped!"
'        Exit Sub
'      Else
'        FatalError(4)
'      EndIf
'    EndIf
  If DirnZ=0 Then
    If CountZ>2 Then CountZ=0 Else CountZ=CountZ+1
  Else
    If CountZ>0 Then CountZ=CountZ-1 Else CountZ=3
  EndIf
  If CountZ=0 Then
    Pin(14)=0: Pin(25)=1: Pin(26)=0
  ElseIf CountZ=1 Then
    Pin(14)=0: Pin(25)=0: Pin(26)=1
  ElseIf CountZ=2 Then
    Pin(14)=1: Pin(25)=1: Pin(26)=0
  Else
    Pin(14)=1: Pin(25)=0: Pin(26)=1
  EndIf
  If StepperDelay>0 Then Pause(StepperDelay)
End Sub
'
Sub FatalError(err)
  Print "MyCNC ";: Print Version$: Print
  Print "[";: Print LineNumber;
  Print "] Fatal error #";: Print err;: Print ": ";
  If err=1 Then
    Print "Relative mode not implemented"
  ElseIf err=2 Then
    Print "Arc move - invalid data"
  ElseIf err=3 Then
    Print "Line move - invalid data"
  ElseIf err=4 Then
    Print "DoStep[x,y or z]() - hard limit reached"
  ElseIf err=5 Then
    Print "minimum X axis!"
  ElseIf err=6 Then
    Print "minimum Y axis!"
  ElseIf err=7 Then
    Print "min/max Z axis!"
  EndIf
  ShutDown
  End
End Sub
' ######################
' Parallel port I/P interrupts
intStepX:
  If DBG=1 Then Print "x";
  DirnX=Pin(5)
  DoStepX
  IReturn
intStepY:
  If DBG=1 Then Print "y";
  DirnY=Pin(6)
  DoStepY
  IReturn
intStepZ:
  If DBG=1 Then Print "z";
  DirnZ=Pin(7)
  DoStepZ
  IReturn

