'
' WebCam.bas V1.4
'
' I2C interface to ArduCam
'   Default to I2C0 GP8/GP9
'   I2C address 0x30 -  My OV2642 image sensor
'   Image Modes:
'   160x120/176x144/320x240/352x288/640x480
'   800x600/1024x768/1280x1024/1600x1200
'
' SPI interface to ArduCam
'   Default to SPI0 GP2/GP3/GP4/GP5
'
' SPI2 GPIO for SDCard - IF fitted
'   (You can use any 4 GPIO for this)
'   "OPTION SDCARD GP13,GP14,GP15,GP12"
'   Set uSDCard=1 to use "B:" drive
'
Const DBG = 0
Const uSDCard = 0               ' Use B: drive? set to 1
Const tZone = 10                ' Australia
Const X_RES = 320               ' Default resolution JPEG_320x240
Const CS = MM.Info(PINNO GP5)   ' SPI CS
Const SHUTTER = 10000           ' 10 Secs Camera Max Timeout
Const FAVICON = 1               ' We have favicon.ico to send

Dim max_conns%=MM.Info(MAX CONNECTIONS)
Dim buff%(2048/8)               ' 2048 byte longstring buffer
Dim ttime$, psize$              ' Some WEB page data

WEB NTP tZone                   ' Update/set internal clock

InitCamera                      ' Exits on failure!

Select Case X_RES
  Case 160:  psize$="160x120"
  Case 176:  psize$="176x144"
  Case 320:  psize$="320x240"
  Case 352:  psize$="352x288"
  Case 640:  psize$="640x480"
  Case 800:  psize$="800x600"
  Case 1024: psize$="1024x768"
  Case 1280: psize$="1280x1024"
  Case 1600: psize$="1600x1200"
End Select

If uSDCard = 1 Then Drive "B:"
Pause 100

Print "WEB server started at "+Time$
Print "Press any key to exit!"

' NB Have reverted to polling for WEB comms
LongString CLEAR buff%()
Do
  WebService
  If Inkey$<>"" Then Exit
Loop

SPI CLOSE
I2C CLOSE
Print "I'm done!"
End

Sub WebService
Local a%, cnt%
Local tmp$

  For a%=1 To max_conns%
    WEB TCP READ a%,buff%()
    cnt%=LLen(buff%())
    If cnt%>0 Then
      If cnt%>64 Then cnt%=64
      tmp$=UCase$(LGetStr$(buff%(),1,cnt%))
      If DBG>0 Then Print "DBG: "+tmp$
      If Instr(tmp$," / ")>0 Or Instr(tmp$,"INDEX.HTM")>0 Then
        Print Time$+": Sending page"
        ttime$=Time$              ' Update WEB page data
        WEB TRANSMIT PAGE a%,"index.html"
      ElseIf Instr(tmp$,"TEST.JPG")>0 Then
        TakeOneShot
        Print Time$+": Sending picture"
        WEB TRANSMIT FILE a%,"Test.jpg","image/jpeg"
      ElseIf Instr(tmp$,"FAVICON.ICO")>0 Then
        If FAVICON=1 Then
          Print Time$+": Sending icon"
          WEB TRANSMIT FILE a%,"favicon.ico","image/vnd.microsoft.icon"
        Else
          WEB TRANSMIT CODE a%,404
        EndIf
      Else
        WEB TRANSMIT CODE a%,404     ' anything unexpected?
      EndIf
      LongString CLEAR buff%()
    EndIf
  Next a%
End Sub

'------------------------------------------------------------
Sub TakeOneShot
Local a%, b%, c%, lp%=1000

  WriteSPIReg(3,&H10)        ' Enable FIFO
  WriteSPIReg(4,&H31)        ' Clear FIFO 'done' flag & ptrs
  WriteSPIReg(1,1)           ' Capture one frame
  WriteSPIReg(4,2)           ' Start capture
  Pause 250                  ' Wait a tick or two
  Do
    lp%=lp%-1
    If lp%=0 Then
      Print : Print "Failed FIFO <done> check"
      WriteSPIReg(4,0)        ' Stop capture
      Exit Sub
    EndIf
  Loop Until (ReadSPIReg(&H41) And 8)=8
  ' File size?
  a%=ReadSPIReg(&H42): b%=ReadSPIReg(&H43): c%=ReadSPIReg(&H44)
  lp%=a%+(b%<<8)+((c% And 7)<<16)
  If DBG>0 Then Print "DBG: File size: "+Str$(lp%)
  If lp%>0 Then
    SaveImage(lp%)
  Else
    Print "No Data?"
  EndIf
  WriteSPIReg(4,0)           ' Stop capture
End Sub

' Write file to flash SPARINGLY!!
Sub SaveImage(siz%)
Local i%, j%, buf%(4096)

  Open "Test.jpg" For Output As #1
  j%=0: Timer = 0
  Pin(CS)=0
  SPI WRITE 1,&H3C           ' READ cmd on reg &H3C Burst mode
  Do
    If siz%<4096 Then
      SPI READ siz%, buf%()  ' Read the data
      For i%=0 To siz%-1: Print #1,Chr$(buf%(i%));: Next i%
      j%=j%+siz%: siz%=0
    Else
      SPI READ 4096, buf%()  ' Read the data
      For i%=0 To 4095: Print #1,Chr$(buf%(i%));: Next i%
      j%=j%+4096: siz%=siz%-4096
    EndIf
    If Timer>SHUTTER Then
      Print "Timeout: Bytes Rxed: "+Str$(j%)
      siz%=0                 ' Quick exit outa here!
    EndIf
  Loop Until siz%=0
  Pin(CS)=1                  ' Clean up
  Close #1                   ' ditto
End Sub

' Initialise and Test both interfaces
Sub InitCamera
  SetPin GP8,GP9,I2C
  I2C OPEN 100,250
  ' Terminates on I2C fail
  CheckSensor                 ' sensor on I2C channel

  SetPin GP4,GP3,GP2,SPI
  SetPin CS,DOUT
  Pin(CS)=1
  SPI OPEN 8000000,1,8        ' 8MHz, mode 1, 8bits
  ' Terminates on SPI fail
  CheckCamera                 ' Camera on SPI channel

  ConfigureSensor             ' Setup capture mode etc
End Sub

Sub CheckSensor
Local i, j As integer

' Select Register Bank1 (Table 13)
  If WriteI2CReg(&HFF,1)=0 Then
    i=ReadI2CReg(&H0A): j=ReadI2CReg(&H0B)
    If i=&H26 And (j=&H40 Or j=&H41 Or j=&H42) Then
      i=WriteI2CReg(0,&H55)         ' Write data to reg 0
      If ReadI2CReg(0)=&H55 Then    ' Read it back ok?
        i=WriteI2CReg(0,&HAA)       ' Again
        If ReadI2CReg(0)=&HAA Then  ' ok?
          i=WriteI2CReg(0,0)        ' Reset reg0
          i=WriteI2CReg(&HFF,0)     ' Reset to Bank0 (Table 12)
          Print "Camera I2C channel pass!"
          Exit Sub
        EndIf
      EndIf
    EndIf
  EndIf
' Fall thru if Fail!
  Print "Camera I2C channel failure...terminating!"
  I2C CLOSE
  End
End Sub

Sub CheckCamera
  WriteSPIReg(0,&H55)
  If ReadSPIReg(0)=&H55 Then
    WriteSPIReg(0,&HAA)
    If ReadSPIReg(0)=&HAA Then
      WriteSPIReg(0,0)
      Print "Camera SPI channel pass!"
      Exit Sub
    EndIf
  EndIf
  ' Fall through fail
  Print "Camera SPI channel failure .. terminating!"
  SPI CLOSE                     ' Shut it down
  I2C CLOSE                     ' Don't forget this
  End
End Sub

Sub ConfigureSensor
Local i, j, lp, reg, dat As integer

  j=WriteI2CReg(&HFF,1)          ' Bank1 (Register Table 13)
  j=WriteI2CReg(&H12,&H80)       ' Factory reset/restore
  Pause 100
  ' Set JPEG_INIT
  Restore JPEG_INIT
  Read lp                        ' Num pairs Reg/Data
  For i=1 To lp
    Read reg, dat                ' Read Reg/Data pair
    j=WriteI2CReg(reg, dat)
  Next i
  ' Set YUV422 - Flows on from the above
  Read lp                       ' Num pairs Reg/Data
  For i=1 To lp
    Read reg, dat               ' Read Reg/Data pair
    j=WriteI2CReg(reg, dat)
  Next i
  ' Set JPEG_COMN - Flows on from the above
  Read lp                       ' Num pairs Reg/Data
  For i=1 To lp
    Read reg, dat               ' Read Reg/Data pair
    j=WriteI2CReg(reg, dat)
  Next i
  j=WriteI2CReg(&HFF,1)         ' Bank1 (Register Table 13)
  j=WriteI2CReg(&H15,0)
  ' Select which jpg resolution to configure
  Select Case X_RES
    Case 160:   Restore JPEG_160
    Case 176:   Restore JPEG_176
    Case 320:   Restore JPEG_320
    Case 352:   Restore JPEG_352
    Case 640:   Restore JPEG_640
    Case 800:   Restore JPEG_800
    Case 1024:  Restore JPEG_1024
    Case 1280:  Restore JPEG_1280
    Case 1600:  Restore JPEG_1600
  End Select
  Read lp                        ' Num pairs Reg/Data
  For i=1 To lp
    Read reg, dat                ' Read Reg/Data pair
    j=WriteI2CReg(reg, dat)
  Next i
  Print "Camera sensor configured"
End Sub

Function ReadI2CReg(reg%)
Local dat%

  I2C WRITE &H30,1,1,reg%
  I2C READ &H30,1,1,dat%
  If MM.I2C>0 Then          'NAK or Timeout
    ReadI2CReg=-1
  Else
    ReadI2CReg=dat%
  EndIf
End Function

Function WriteI2CReg(reg%, dat%)
  I2C WRITE &H30,1,2,reg%,dat%
  If MM.I2C<>0 Then
    WriteI2CReg=-1
  Else
    WriteI2CReg=0
  EndIf
End Function

Function ReadSPIReg(reg%)
Local tmp%

  Pin(CS)=0
  SPI WRITE 1,reg%          ' READ cmd on reg%
  tmp%=SPI(reg%)            ' Read a byte
  Pin(CS)=1
  ReadSPIReg=tmp%
End Function

Sub WriteSPIReg(reg%, dat%)
Local wReg%=reg% Or &H80    ' Write cmd on reg%

  Pin(CS)=0
  SPI WRITE 2,wReg%,dat%
  Pin(CS)=1
End Sub

'--------------------------------------------------------------
'
' Data taken from original Arducam source on github
' https://github.com/ArduCAM/RPI-Pico-Cam
'
' sensor_reg OV2640_JPEG_INIT (190 reg/data pairs)
JPEG_INIT:
Data &HBE
Data &HFF, &H00, &H2C, &HFF, &H2E, &HDF, &HFF, &H01, &H3C, &H32
Data &H11, &H00, &H09, &H02, &H04, &H28, &H13, &HE5, &H14, &H48
Data &H2C, &H0C, &H33, &H78, &H3A, &H33, &H3B, &HFB, &H3E, &H00
Data &H43, &H11, &H16, &H10, &H39, &H92, &H35, &HDA, &H22, &H1A
Data &H37, &HC3, &H23, &H00, &H34, &HC0, &H36, &H1A, &H06, &H88
Data &H07, &HC0, &H0D, &H87, &H0E, &H41, &H4C, &H00, &H48, &H00
Data &H5B, &H00, &H42, &H03, &H4A, &H81, &H21, &H99, &H24, &H40
Data &H25, &H38, &H26, &H82, &H5C, &H00, &H63, &H00, &H61, &H70
Data &H62, &H80, &H7C, &H05, &H20, &H80, &H28, &H30, &H6C, &H00
Data &H6D, &H80, &H6E, &H00, &H70, &H02, &H71, &H94, &H73, &HC1
Data &H12, &H40, &H17, &H11, &H18, &H43, &H19, &H00, &H1A, &H4B
Data &H32, &H09, &H37, &HC0, &H4F, &H60, &H50, &HA8, &H6D, &H00
Data &H3D, &H38, &H46, &H3F, &H4F, &H60, &H0C, &H3C, &HFF, &H00
Data &HE5, &H7F, &HF9, &HC0, &H41, &H24, &HE0, &H14, &H76, &HFF
Data &H33, &HA0, &H42, &H20, &H43, &H18, &H4C, &H00, &H87, &HD5
Data &H88, &H3F, &HD7, &H03, &HD9, &H10, &HD3, &H82, &HC8, &H08
Data &HC9, &H80, &H7C, &H00, &H7D, &H00, &H7C, &H03, &H7D, &H48
Data &H7D, &H48, &H7C, &H08, &H7D, &H20, &H7D, &H10, &H7D, &H0E
Data &H90, &H00, &H91, &H0E, &H91, &H1A, &H91, &H31, &H91, &H5A
Data &H91, &H69, &H91, &H75, &H91, &H7E, &H91, &H88, &H91, &H8F
Data &H91, &H96, &H91, &HA3, &H91, &HAF, &H91, &HC4, &H91, &HD7
Data &H91, &HE8, &H91, &H20, &H92, &H00, &H93, &H06, &H93, &HE3
Data &H93, &H05, &H93, &H05, &H93, &H00, &H93, &H04, &H93, &H00
Data &H93, &H00, &H93, &H00, &H93, &H00, &H93, &H00, &H93, &H00
Data &H93, &H00, &H96, &H00, &H97, &H08, &H97, &H19, &H97, &H02
Data &H97, &H0C, &H97, &H24, &H97, &H30, &H97, &H28, &H97, &H26
Data &H97, &H02, &H97, &H98, &H97, &H80, &H97, &H00, &H97, &H00
Data &HC3, &HED, &HA4, &H00, &HA8, &H00, &HC5, &H11, &HC6, &H51
Data &HBF, &H80, &HC7, &H10, &HB6, &H66, &HB8, &HA5, &HB7, &H64
Data &HB9, &H7C, &HB3, &HAF, &HB4, &H97, &HB5, &HFF, &HB0, &HC5
Data &HB1, &H94, &HB2, &H0F, &HC4, &H5C, &HC0, &H64, &HC1, &H4B
Data &H8C, &H00, &H86, &H3D, &H50, &H00, &H51, &HC8, &H52, &H96
Data &H53, &H00, &H54, &H00, &H55, &H00, &H5A, &HC8, &H5B, &H96
Data &H5C, &H00, &HD3, &H00, &HC3, &HED, &H7F, &H00, &HDA, &H00
Data &HE5, &H1F, &HE1, &H67, &HE0, &H00, &HDD, &H7F, &H05, &H00
Data &H12, &H40, &HD3, &H04, &HC0, &H16, &HC1, &H12, &H8C, &H00
Data &H86, &H3D, &H50, &H00, &H51, &H2C, &H52, &H24, &H53, &H00
Data &H54, &H00, &H55, &H00, &H5A, &H2C, &H5B, &H24, &H5C, &H00

' sensor_reg OV2640_YUV422 (9 reg/data pairs)
YUV422:
Data &H09
Data &HFF, &H00, &H05, &H00, &HDA, &H10, &HD7, &H03, &HDF, &H00
Data &H33, &H80, &H3C, &H40, &HE1, &H77, &H00, &H00

' sensor_reg OV2640_JPEG (8 reg/data pairs)
JPEG_COMN:
Data &H08
Data &HE0, &H14, &HE1, &H77, &HE5, &H1F, &HD7, &H03, &HDA, &H10
Data &HE0, &H00, &HFF, &H01, &H04, &H08

' sensor_reg OV2640_QVGA  (193 Reg/data pairs)
' Not sure where this fits in!
JPEG_QVGA:
Data &HC1
Data &HFF, &H00, &H2C, &HFF, &H2E, &HDF, &HFF, &H01, &H3C, &H32
Data &H11, &H00, &H09, &H02, &H04, &HA8, &H13, &HE5, &H14, &H48
Data &H2C, &H0C, &H33, &H78, &H3A, &H33, &H3B, &HFB, &H3E, &H00
Data &H43, &H11, &H16, &H10, &H39, &H02, &H35, &H88, &H22, &H0A
Data &H37, &H40, &H23, &H00, &H34, &HA0, &H06, &H02, &H06, &H88
Data &H07, &HC0, &H0D, &HB7, &H0E, &H01, &H4C, &H00, &H4A, &H81
Data &H21, &H99, &H24, &H40, &H25, &H38, &H26, &H82, &H5C, &H00
Data &H63, &H00, &H46, &H22, &H0C, &H3A, &H5D, &H55, &H5E, &H7D
Data &H5F, &H7D, &H60, &H55, &H61, &H70, &H62, &H80, &H7C, &H05
Data &H20, &H80, &H28, &H30, &H6C, &H00, &H6D, &H80, &H6E, &H00
Data &H70, &H02, &H71, &H94, &H73, &HC1, &H3D, &H34, &H12, &H04
Data &H5A, &H57, &H4F, &HBB, &H50, &H9C, &HFF, &H00, &HE5, &H7F
Data &HF9, &HC0, &H41, &H24, &HE0, &H14, &H76, &HFF, &H33, &HA0
Data &H42, &H20, &H43, &H18, &H4C, &H00, &H87, &HD0, &H88, &H3F
Data &HD7, &H03, &HD9, &H10, &HD3, &H82, &HC8, &H08, &HC9, &H80
Data &H7C, &H00, &H7D, &H00, &H7C, &H03, &H7D, &H48, &H7D, &H48
Data &H7C, &H08, &H7D, &H20, &H7D, &H10, &H7D, &H0E, &H90, &H00
Data &H91, &H0E, &H91, &H1A, &H91, &H31, &H91, &H5A, &H91, &H69
Data &H91, &H75, &H91, &H7E, &H91, &H88, &H91, &H8F, &H91, &H96
Data &H91, &HA3, &H91, &HAF, &H91, &HC4, &H91, &HD7, &H91, &HE8
Data &H91, &H20, &H92, &H00, &H93, &H06, &H93, &HE3, &H93, &H03
Data &H93, &H03, &H93, &H00, &H93, &H02, &H93, &H00, &H93, &H00
Data &H93, &H00, &H93, &H00, &H93, &H00, &H93, &H00, &H93, &H00
Data &H96, &H00, &H97, &H08, &H97, &H19, &H97, &H02, &H97, &H0C
Data &H97, &H24, &H97, &H30, &H97, &H28, &H97, &H26, &H97, &H02
Data &H97, &H98, &H97, &H80, &H97, &H00, &H97, &H00, &HA4, &H00
Data &HA8, &H00, &HC5, &H11, &HC6, &H51, &HBF, &H80, &HC7, &H10
Data &HB6, &H66, &HB8, &HA5, &HB7, &H64, &HB9, &H7C, &HB3, &HAF
Data &HB4, &H97, &HB5, &HFF, &HB0, &HC5, &HB1, &H94, &HB2, &H0F
Data &HC4, &H5C, &HA6, &H00, &HA7, &H20, &HA7, &HD8, &HA7, &H1B
Data &HA7, &H31, &HA7, &H00, &HA7, &H18, &HA7, &H20, &HA7, &HD8
Data &HA7, &H19, &HA7, &H31, &HA7, &H00, &HA7, &H18, &HA7, &H20
Data &HA7, &HD8, &HA7, &H19, &HA7, &H31, &HA7, &H00, &HA7, &H18
Data &H7F, &H00, &HE5, &H1F, &HE1, &H77, &HDD, &H7F, &HC2, &H0E
Data &HFF, &H00, &HE0, &H04, &HC0, &HC8, &HC1, &H96, &H86, &H3D
Data &H51, &H90, &H52, &H2C, &H53, &H00, &H54, &H00, &H55, &H88
Data &H57, &H00, &H50, &H92, &H5A, &H50, &H5B, &H3C, &H5C, &H00
Data &HD3, &H04, &HE0, &H00, &HFF, &H00, &H05, &H00, &HDA, &H08
Data &HD7, &H03, &HE0, &H00, &H05, &H00

' sensor_reg OV2640_160x120_JPEG  (39 reg/data pairs)
JPEG_160:
Data &H27
Data &HFF, &H01, &H12, &H40, &H17, &H11, &H18, &H43, &H19, &H00
Data &H1A, &H4B, &H32, &H09, &H4F, &HCA, &H50, &HA8, &H5A, &H23
Data &H6D, &H00, &H39, &H12, &H35, &HDA, &H22, &H1A, &H37, &HC3
Data &H23, &H00, &H34, &HC0, &H36, &H1A, &H06, &H88, &H07, &HC0
Data &H0D, &H87, &H0E, &H41, &H4C, &H00, &HFF, &H00, &HE0, &H04
Data &HC0, &H64, &HC1, &H4B, &H86, &H35, &H50, &H92, &H51, &HC8
Data &H52, &H96, &H53, &H00, &H54, &H00, &H55, &H00, &H57, &H00
Data &H5A, &H28, &H5B, &H1E, &H5C, &H00, &HE0, &H00

' sensor_reg OV2640_176x144_JPEG  (39 reg/data pairs)
JPEG_176:
Data &H27
Data &HFF, &H01, &H12, &H40, &H17, &H11, &H18, &H43, &H19, &H00
Data &H1A, &H4B, &H32, &H09, &H4F, &HCA, &H50, &HA8, &H5A, &H23
Data &H6D, &H00, &H39, &H12, &H35, &HDA, &H22, &H1A, &H37, &HC3
Data &H23, &H00, &H34, &HC0, &H36, &H1A, &H06, &H88, &H07, &HC0
Data &H0D, &H87, &H0E, &H41, &H4C, &H00, &HFF, &H00, &HE0, &H04
Data &HC0, &H64, &HC1, &H4B, &H86, &H35, &H50, &H92, &H51, &HC8
Data &H52, &H96, &H53, &H00, &H54, &H00, &H55, &H00, &H57, &H00
Data &H5A, &H2C, &H5B, &H24, &H5C, &H00, &HE0, &H00

' sensor_reg OV2640_320x240_JPEG  (39 reg/data pairs)
JPEG_320:
Data &H27
Data &HFF, &H01, &H12, &H40, &H17, &H11, &H18, &H43, &H19, &H00
Data &H1A, &H4B, &H32, &H09, &H4F, &HCA, &H50, &HA8, &H5A, &H23
Data &H6D, &H00, &H39, &H12, &H35, &HDA, &H22, &H1A, &H37, &HC3
Data &H23, &H00, &H34, &HC0, &H36, &H1A, &H06, &H88, &H07, &HC0
Data &H0D, &H87, &H0E, &H41, &H4C, &H00, &HFF, &H00, &HE0, &H04
Data &HC0, &H64, &HC1, &H4B, &H86, &H35, &H50, &H89, &H51, &HC8
Data &H52, &H96, &H53, &H00, &H54, &H00, &H55, &H00, &H57, &H00
Data &H5A, &H50, &H5B, &H3C, &H5C, &H00, &HE0, &H00

' sensor_reg OV2640_352x288_JPEG  (39 reg/data pairs)
JPEG_352:
Data &H27
Data &HFF, &H01, &H12, &H40, &H17, &H11, &H18, &H43, &H19, &H00
Data &H1A, &H4B, &H32, &H09, &H4F, &HCA, &H50, &HA8, &H5A, &H23
Data &H6D, &H00, &H39, &H12, &H35, &HDA, &H22, &H1A, &H37, &HC3
Data &H23, &H00, &H34, &HC0, &H36, &H1A, &H06, &H88, &H07, &HC0
Data &H0D, &H87, &H0E, &H41, &H4C, &H00, &HFF, &H00, &HE0, &H04
Data &HC0, &H64, &HC1, &H4B, &H86, &H35, &H50, &H89, &H51, &HC8
Data &H52, &H96, &H53, &H00, &H54, &H00, &H55, &H00, &H57, &H00
Data &H5A, &H58, &H5B, &H48, &H5C, &H00, &HE0, &H00

' SENSOR_REG OV2640_640x480_JPEG  (40 reg/data pairs)
JPEG_640:
Data &H28
Data &HFF, &H01, &H11, &H01, &H12, &H00, &H17, &H11, &H18, &H75
Data &H32, &H36, &H19, &H01, &H1A, &H97, &H03, &H0F, &H37, &H40
Data &H4F, &HBB, &H50, &H9C, &H5A, &H57, &H6D, &H80, &H3D, &H34
Data &H39, &H02, &H35, &H88, &H22, &H0A, &H37, &H40, &H34, &HA0
Data &H06, &H02, &H0D, &HB7, &H0E, &H01, &HFF, &H00, &HE0, &H04
Data &HC0, &HC8, &HC1, &H96, &H86, &H3D, &H50, &H89, &H51, &H90
Data &H52, &H2C, &H53, &H00, &H54, &H00, &H55, &H88, &H57, &H00
Data &H5A, &HA0, &H5B, &H78, &H5C, &H00, &HD3, &H04, &HE0, &H00

' sensor_reg OV2640_800x600_JPEG  (40 reg/data pairs)
JPEG_800:
Data &H28
Data &HFF, &H01, &H11, &H01, &H12, &H00, &H17, &H11, &H18, &H75
Data &H32, &H36, &H19, &H01, &H1A, &H97, &H03, &H0F, &H37, &H40
Data &H4F, &HBB, &H50, &H9C, &H5A, &H57, &H6D, &H80, &H3D, &H34
Data &H39, &H02, &H35, &H88, &H22, &H0A, &H37, &H40, &H34, &HA0
Data &H06, &H02, &H0D, &HB7, &H0E, &H01, &HFF, &H00, &HE0, &H04
Data &HC0, &HC8, &HC1, &H96, &H86, &H35, &H50, &H89, &H51, &H90
Data &H52, &H2C, &H53, &H00, &H54, &H00, &H55, &H88, &H57, &H00
Data &H5A, &HC8, &H5B, &H96, &H5C, &H00, &HD3, &H02, &HE0, &H00

' sensor_reg OV2640_1024x768_JPEG  (38 Reg/data pairs)
JPEG_1024:
Data &H26
Data &HFF, &H01, &H11, &H01, &H12, &H00, &H17, &H11, &H18, &H75
Data &H32, &H36, &H19, &H01, &H1A, &H97, &H03, &H0F, &H37, &H40
Data &H4F, &HBB, &H50, &H9C, &H5A, &H57, &H6D, &H80, &H3D, &H34
Data &H39, &H02, &H35, &H88, &H22, &H0A, &H37, &H40, &H34, &HA0
Data &H06, &H02, &H0D, &HB7, &H0E, &H01, &HFF, &H00, &HC0, &HC8
Data &HC1, &H96, &H8C, &H00, &H86, &H3D, &H50, &H00, &H51, &H90
Data &H52, &H2C, &H53, &H00, &H54, &H00, &H55, &H88, &H5A, &H00
Data &H5B, &HC0, &H5C, &H01, &HD3, &H02

' sensor_reg OV2640_1280x1024_JPEG  (40 reg/data pairs)
JPEG_1280:
Data &H28
Data &HFF, &H01, &H11, &H01, &H12, &H00, &H17, &H11, &H18, &H75
Data &H32, &H36, &H19, &H01, &H1A, &H97, &H03, &H0F, &H37, &H40
Data &H4F, &HBB, &H50, &H9C, &H5A, &H57, &H6D, &H80, &H3D, &H34
Data &H39, &H02, &H35, &H88, &H22, &H0A, &H37, &H40, &H34, &HA0
Data &H06, &H02, &H0D, &HB7, &H0E, &H01, &HFF, &H00, &HE0, &H04
Data &HC0, &HC8, &HC1, &H96, &H86, &H3D, &H50, &H00, &H51, &H90
Data &H52, &H2C, &H53, &H00, &H54, &H00, &H55, &H88, &H57, &H00
Data &H5A, &H40, &H5B, &HF0, &H5C, &H01, &HD3, &H02, &HE0, &H00

' sensor_reg OV2640_1600x1200_JPEG  (40 reg/data pairs)
JPEG_1600:
Data &H28
Data &HFF, &H01, &H11, &H01, &H12, &H00, &H17, &H11, &H18, &H75
Data &H32, &H36, &H19, &H01, &H1A, &H97, &H03, &H0F, &H37, &H40
Data &H4F, &HBB, &H50, &H9C, &H5A, &H57, &H6D, &H80, &H3D, &H34
Data &H39, &H02, &H35, &H88, &H22, &H0A, &H37, &H40, &H34, &HA0
Data &H06, &H02, &H0D, &HB7, &H0E, &H01, &HFF, &H00, &HE0, &H04
Data &HC0, &HC8, &HC1, &H96, &H86, &H3D, &H50, &H00, &H51, &H90
Data &H52, &H2C, &H53, &H00, &H54, &H00, &H55, &H88, &H57, &H00
Data &H5A, &H90, &H5B, &H2C, &H5C, &H05, &HD3, &H02, &HE0, &H00

