'Outdoor Weather Station, Lewis G1RUN'''''''''''''''''''''''''''''''''''''''''
'Thanks to Geoffg(GPS CODE), Matherp, WhiteWizzard, MikeO, Microblocks''''''''
'robert.rozee and everyone else who helped me in getting the code working'''''
'Sorry if I have missed anyones name out but please accept my thanks here'''''
'********************V1.20****************************************************
Option EXPLICIT
Option DEFAULT NONE
Option ClockTrim -4         'Offset to make MY Micromite clock more accurate
OPTION AUTORUN ON                                 'Autorun upon power up (after first run)
WATCHDOG 1200000            'Set watchdog timer to 20 minutes (if error reboot within 20 minutes)
Const SI1145_PARAM_QUERY = &H80
Const SI1145_PARAM_SET = &HA0
Const SI1145_NOP = &H0
Const SI1145_RESET    = &H01
Const SI1145_BUSADDR    = &H02
Const SI1145_PS_FORCE    = &H05
Const SI1145_ALS_FORCE    = &H06
Const SI1145_PSALS_FORCE    = &H07
Const SI1145_PS_PAUSE    = &H09
Const SI1145_ALS_PAUSE    = &H0A
Const SI1145_PSALS_PAUSE    = &HB
Const SI1145_PS_AUTO    = &H0D
Const SI1145_ALS_AUTO   = &H0E
Const SI1145_PSALS_AUTO = &H0F
Const SI1145_GET_CAL    = &H12
Const SI1145_PARAM_I2CADDR = &H00
Const SI1145_PARAM_CHLIST   = &H01
Const SI1145_PARAM_CHLIST_ENUV = &H80
Const SI1145_PARAM_CHLIST_ENAUX = &H40
Const SI1145_PARAM_CHLIST_ENALSIR = &H20
Const SI1145_PARAM_CHLIST_ENALSVIS = &H10
Const SI1145_PARAM_CHLIST_ENPS1 = &H01
Const SI1145_PARAM_CHLIST_ENPS2 = &H02
Const SI1145_PARAM_CHLIST_ENPS3 = &H04
Const SI1145_PARAM_PSLED12SEL   = &H02
Const SI1145_PARAM_PSLED12SEL_PS2NONE = &H00
Const SI1145_PARAM_PSLED12SEL_PS2LED1 = &H10
Const SI1145_PARAM_PSLED12SEL_PS2LED2 = &H20
Const SI1145_PARAM_PSLED12SEL_PS2LED3 = &H40
Const SI1145_PARAM_PSLED12SEL_PS1NONE = &H00
Const SI1145_PARAM_PSLED12SEL_PS1LED1 = &H01
Const SI1145_PARAM_PSLED12SEL_PS1LED2 = &H02
Const SI1145_PARAM_PSLED12SEL_PS1LED3 = &H04
Const SI1145_PARAM_PSLED3SEL   = &H03
Const SI1145_PARAM_PSENCODE   = &H05
Const SI1145_PARAM_ALSENCODE  = &H06
Const SI1145_PARAM_PS1ADCMUX   = &H07
Const SI1145_PARAM_PS2ADCMUX   = &H08
Const SI1145_PARAM_PS3ADCMUX   = &H09
Const SI1145_PARAM_PSADCOUNTER   = &H0A
Const SI1145_PARAM_PSADCGAIN = &H0B
Const SI1145_PARAM_PSADCMISC = &H0C
Const SI1145_PARAM_PSADCMISC_RANGE = &H20
Const SI1145_PARAM_PSADCMISC_PSMODE = &H04
Const SI1145_PARAM_ALSIRADCMUX   = &H0E
Const SI1145_PARAM_AUXADCMUX   = &H0F
Const SI1145_PARAM_ALSVISADCOUNTER   = &H10
Const SI1145_PARAM_ALSVISADCGAIN = &H11
Const SI1145_PARAM_ALSVISADCMISC = &H12
Const SI1145_PARAM_ALSVISADCMISC_VRNG = &H20
Const SI1145_PARAM_ALSIRADCOUNTER   = &H1D
Const SI1145_PARAM_ALSIRADCGAIN = &H1E
Const SI1145_PARAM_ALSIRADCMISC = &H1F
Const SI1145_PARAM_ALSIRADCMISC_RANGE = &H20
Const SI1145_PARAM_ADCCOUNTER_511CLK = &H70
Const SI1145_PARAM_ADCMUX_SMALLIR  = &H00
Const SI1145_PARAM_ADCMUX_LARGEIR  = &H03
Const SI1145_REG_PARTID  = &H00
Const SI1145_REG_REVID  = &H01
Const SI1145_REG_SEQID  = &H02
Const SI1145_REG_INTCFG  = &H03
Const SI1145_REG_INTCFG_INTOE = &H01
Const SI1145_REG_INTCFG_INTMODE = &H02
Const SI1145_REG_IRQEN  = &H04
Const SI1145_REG_IRQEN_ALSEVERYSAMPLE = &H01
Const SI1145_REG_IRQEN_PS1EVERYSAMPLE = &H04
Const SI1145_REG_IRQEN_PS2EVERYSAMPLE = &H08
Const SI1145_REG_IRQEN_PS3EVERYSAMPLE = &H10
Const SI1145_REG_IRQMODE1 = &H05
Const SI1145_REG_IRQMODE2 = &H06
Const SI1145_REG_HWKEY  = &H07
Const SI1145_REG_MEASRATE0 = &H08
Const SI1145_REG_MEASRATE1  = &H09
Const SI1145_REG_PSRATE  = &H0A
Const SI1145_REG_PSLED21  = &H0F
Const SI1145_REG_PSLED3  = &H10
Const SI1145_REG_UCOEFF0  = &H13
Const SI1145_REG_UCOEFF1  = &H14
Const SI1145_REG_UCOEFF2  = &H15
Const SI1145_REG_UCOEFF3  = &H16
Const SI1145_REG_PARAMWR  = &H17
Const SI1145_REG_COMMAND  = &H18
Const SI1145_REG_RESPONSE  = &H20
Const SI1145_REG_IRQSTAT  = &H21
Const SI1145_REG_IRQSTAT_ALS  = &H01
Const SI1145_REG_ALSVISDATA0 = &H22
Const SI1145_REG_ALSVISDATA1 = &H23
Const SI1145_REG_ALSIRDATA0 = &H24
Const SI1145_REG_ALSIRDATA1 = &H25
Const SI1145_REG_PS1DATA0 = &H26
Const SI1145_REG_PS1DATA1 = &H27
Const SI1145_REG_PS2DATA0 = &H28
Const SI1145_REG_PS2DATA1 = &H29
Const SI1145_REG_PS3DATA0 = &H2A
Const SI1145_REG_PS3DATA1 = &H2B
Const SI1145_REG_UVINDEX0 = &H2C
Const SI1145_REG_UVINDEX1 = &H2D
Const SI1145_REG_PARAMRD = &H2E
Const SI1145_REG_CHIPSTAT = &H30
Const SI1145_ADDR = &H60
Const wSpeedPin = 6                              'Wind speed sensor
Const RainPin = 14                               'Rain sensor
Const wDirPin = 26                               'Direction sensor
Const WindFactor = 0.4166666666666667            'unique to each enenemeter type
Const RainFactor = 0.2794                        'mm rain for every switch closure
Const TestPause = 3000                           'Wind speed sample time
SetPin 24, AIN                                   'Battery Voltage
SetPin 26, AIN                                   'wind speed sensor
SetPin 23, DOUT                                  'GPS Power
SetPin 16, DOUT                                  'HC-12 Power
SetPin wSpeedPin,Intl,anemometerClick,Pullup
SetPin RainPin,Intl,rainguageClick,Pullup
'  BME280 routines and test harness
Const BME280_ADDRESS                    = &H77
Const BME280_REGISTER_T1                = &H88
Const BME280_REGISTER_P1                = &H8E
Const BME280_REGISTER_H1                = &HA1
Const BME280_REGISTER_H2                = &HE1
Const BME280_REGISTER_CHIPID            = &HD0
Const BME280_REGISTER_CONTROLHUMID      = &HF2
Const BME280_REGISTER_CONTROL           = &HF4
Const BME280_REGISTER_PRESSUREDATA      = &HF7
Const BME280_REGISTER_TEMPDATA          = &HFA
Const BME280_REGISTER_HUMIDDATA         = &HFD
Dim float UVindex
Dim integer s16=&HFFFFFFFFFFFF0000 , s16b=&H8000
Dim integer s12=&HFFFFFFFFFFFFF000 , s12b=&H800
Dim integer s8= &HFFFFFFFFFFFFFF00  , s8b=&H80
Dim INTEGER T1,T2,T3     'uint16_t, int16_t, int16_t
Dim INTEGER P1,P2,P3,P4,P5,P6,P7,P8,P9    'uint16_t, 8 x int16_t
Dim INTEGER H1,H2,H3,H4,H5,H6     'uint8_t, int16_t , uint8_t, int16_t, int16_t, int8_t
dim INTEGER t_fine  'used to store accurate temp reading from temp conversion for use in pressure and humidity conversions
Dim FLOAT anem_count,anem_last,wspeed,wcount,WRESULT,reading
Dim FLOAT anem_min=1000
Dim FLOAT Wgust
Dim FLOAT thistime
Dim FLOAT rain_count
Dim INTEGER TIMEZONE,USEDST,DHS,DHE,dms,dme,secs,MINS
Dim FLOAT wdir,rain_last,WDCOUNT
Dim i As INTEGER
Dim STRING x,LAT_DEG,lat_min,lat_sec,long_deg,long_min,long_sec
Dim INTEGER y
DIM FLOAT year1,month1,day1
Dim INTEGER YEAR
Dim INTEGER MONTH
Dim INTEGER yr
Dim INTEGER mth
Dim INTEGER hr
Dim INTEGER day
Dim INTEGER minutes
Dim INTEGER HOUR
Dim INTEGER MIN
Dim INTEGER SEC
Dim INTEGER wArray(10)
Dim INTEGER wdArray(10)
Dim AM$
DIM integer AA,BB,CC
Dim FLOAT Batt2,WHEADING2,WHEADING,WHEADING3,hgust,mmrain,mmrain2,LOWTEMP,HIGHTEMP,TEMP,PRESSURE,HUMIDITY,HIGHTEMP2,LOWTEMP2
Dim FLOAT BATT
Dim STRING LINE1
Dim STRING LINE2
Dim STRING TIME
Dim INTEGER md(12)
Dim STRING arg$(20)
Data 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334
For i = 1 To 12: Read md(i): Next i
anem_count=0
anem_last=0
anem_min=1000
HGust=0
rain_count=0
rain_last=0
wCount=1
wdCount=1
lowtemp = 60           ' Set lowest temp on startup to 60Deg C because the temp will never reach this here in the UK
hightemp = 0
TimeZone = 0.0        ' hours from GMT (+ or -)
UseDST = 1            ' set to 1 to enable daylight saving time (DST) adjust
dms = 3              ' the month that DST starts
dhs = 2               ' the hour that DST starts
dme = 10               ' the month that DST ends
dhe = 2               ' the hour that DST ends
'******************************************************************************************************************
Init:
'interupts
SetTick 1000 ,L1,1                                    'establish seconds "Tick Timer"
Pin(23) = 1                                           'GPS Power OFF
Pin(16) = 1                                           'HC-12 Power OFF
Open "COM2:9600"  As #1                                ' OPEN the GPS serial interface
'Open "COM1:19200" As #2                               'Open port for HC-12 TX/RX
Open "COM1:19200,S2" As #2


' ******************this is the main program loop, it never exits ******************************
Do
  If secs < 4 Then                           'IF Seconds is less than 4 then restart the GPS
  KeepSearching:
  Do
  Pin(23) = 0                                'TURN GPS Power ON
  Pin(16) = 0                                'Turn HC-12 Power ON
  pause 50
  GetGPSRecord                               ' get a GPS record
  Loop Until arg$(0) = "GPRMC"               ' we only want the RMC record
  If arg$(2) <> "A" Then                     ' "A" means val  id record
  Print "Searching For GPS signal"
  Print #2, "STXG" , "," , "*"
  GoTo KeepSearching                         ' go back and keep looking
  EndIf
  ' the GPS has the valid time
  ' first extract the elements of the date/time from the GPS record
  year = Val(Right$(arg$(9), 2))             ' extract the date
  month = Val(Mid$(arg$(9), 3, 2))
  day = Val(Left$(arg$(9), 2))
  hour = Val(Left$(arg$(1), 2))              ' extract the time
  min = Val(Mid$(arg$(1), 3, 2))
  sec = Val(Mid$(arg$(1), 5, 2))
  ' convert the time to minutes since midnight 1st Jan 2014
  ' then add/subtract the timezone and if required add daylight saving
  ' this calculation takes just 15mS at 40MHz
  
 mins = GetMins(year, month, day, hour, min) 
  mins = mins + TimeZone * 60                ' adjust for the timezone 
  IF UseDST THEN                             ' if we observe daylight saving 
    IF mins < GetDST(year, dme, dhe) AND mins > GetDST(year, dms, dhs) THEN 
      mins = mins + 60                       ' adjust for AWST DST 
    ENDIF 
  ENDIF 

  ' because we will display the time at the start of the next second
  ' we have to add 1 second to the current time
  sec = sec + 1
  If sec >= 60 Then sec = 0 : mins = mins + 1

  ' finally convert the minutes back into the current date/time
  Line1 = GetDate$(mins)
  Line2 = GetTime$(mins)

  ' we now have the date/time for the next second ready for display
  ' we have to wait for the end of the data stream from the GPS
  ' then we wait for the start of the next second and only then update the LCD
  Do : Loop While Timer < 950                ' wait for the data to finish
  Do : Loop While Input$(200, #1) <> ""      ' clear the input buffer
  Do While Input$(1, #1) <> "$" : Loop       ' wait for a new second to start
  Timer = 0
  ' display the date and time for this second
Time$ = LINE2$                            'Set TIME to GPS LOCAL time
DATE$ =  STR$(day,2,0,"0") + "/" + STR$(month,2,0,"0") + "/" + STR$(year,2,0,"0")
print date$
For AA = 1 to 5    'Send data 5 times in case the indoor unit misses the transmission
Pause 500          'wait half a second
PRINT #2, "STXT";STR$(day,2,0,"0");STR$(month,2,0,"0");STR$(year,2,0,"0");Left$(Time$,2);Mid$(TIME$,4,2);Right$(TIME$,2);"*"' Send correct date/time to Indoor unit to set RTC 
next AA              
Print Time$
  pause 1000          'Pause 1 second before turning the GPS and HC-12 off
  Pin(23) = 1                                  'Turn GPS Power OFF
  Pin(16) = 1                                  ' Turn HC-12 off
  End If

'****************End of GPS************************************
 
IF Time$ >= "08:00:00" AND Time$ <= "20:00:00" THEN ' IF time is between 8AM and 8PM

End If
 If secs  Mod 5 = 0 Then  'every 5 secs
 windSpeedProc                   'Process Wind Dpeed
 WindDirProc                     'Process Wind Direction
 rainProc                        'Process Rain sensor
 bme280_init                     'Turn BME280 on
End If

If secs  Mod 300 = 0 Then       'every  5 minutes
  Pin(16) = 0                  ' Turn HC-12 Power ON
  Pause 200
  BATTERY                      ' Measure Battery Voltage
  SendDataUpdate               'SEND DATA to HC-12 (and console)
  Pause 500
  Pin(16) = 1                  ' Turn HC-12 Power OFF
END IF
IF Time$ >= "20:00:01" AND Time$ <= "07:59:59" THEN ' IF time is between 8AM and 8PM                         'IF Time is between 8PM and 8Am 

If secs  Mod 30 = 0 Then       'every 30 seconds
 windSpeedProc
 WindDirProc
 rainProc
 bme280_init
End If

If secs  Mod 300 = 0 Then      'every  15 minutes seconds
  Pin(16) = 0                  ' Turn HC-12 Power ON
  Pause 200                    'Pause to give HC-12 chance to power up
  BATTERY                      ' Measure Battery Voltage
  SendDataUpdate               'SEND DATA to HC-12 (and console)
  Pause 100
  Pin(16) = 1                  ' Turn HC-12 Power OFF
End If
ENDIF

If Time$ = "06:00:00" Then                                'New Met Day
mmrain2 = mmrain                                          ' Rain Yesterday
lowtemp2 = lowtemp                                        'Lowest Temp Yesterday
hightemp2 = hightemp                                      'Highest Temp Yesterday
mmrain = 0
wgust = 0
hgust = 0
hightemp = 0
lowtemp = 40
End If
WATCHDOG 120000                'watchdog 2 minutes (if error reboot within 2 minutes)
Loop

End

'***** End main program loop********
' subroutine to get a GPS record into the array arg$()
Sub GetGPSRecord
  Do
    Do While Input$(1, #1) <> "$" : Loop   ' wait for the start
    For i = 0 To 20
      arg$(i) = ""                         ' clear ready for data
      Do                                   ' loops until a specific exit
        x$ = Input$(1, #1)                 ' get the character
        If x$ = "," Then Exit Do           ' new data item, new field
        If x$ = "*" Then Exit Sub          ' end of record, so return with it
        arg$(i) = arg$(i) + x$             ' add to the data
      Loop                                 ' keep going
    Next i                                 ' increment the field
  Loop
End Sub



''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' calculate the minutes since midnight 1st Jan 2014
Function GetMins(yr As integer, mth As integer, day As integer, hr As integer, min As integer) As integer
  GetMins = (yr - 14) * (365 * 24 * 60) + ((yr - 13) \ 4) * (24 * 60)
  GetMins = GetMins + (md(mth) * (24 * 60))
  GetMins = GetMins + ((day - 1) * (24 * 60))
  GetMins = GetMins + (hr * 60)
  GetMins = GetMins + min
  If (yr - 16) Mod 4 = 0 And mth > 2 Then GetMins = GetMins + (24 * 60)
End Function


' convert minutes back into the time (as a string)
Function GetTime$(minutes As INTEGER)
  Local hr As INTEGER, min As INTEGER, am$
   hr = (minutes \ 60) Mod 24
   If hr = 0 Then hr = 12
  min = minutes Mod 60
  GetTime$ = Str$(hr) + ":"
  GetTime$ = GetTime$ + Right$("0" + Str$(min), 2) + ":"
  GetTime$ = GetTime$ + Right$("0" + Str$(sec), 2) + " " + am$
End Function


' convert minutes back into the date (as a string)
Function GetDate$(minutes As INTEGER)
  Local yr As INTEGER, mth As INTEGER, day As INTEGER, mths$, days$
  mths$ = "  JanFebMarAprMayJunJulAugSepOctNovDec"
  days$ = "SunMonTueWedThuFriSat"
  For yr = 14 To 99
   If minutes < GetMins(yr + 1, 1, 1, 0, 0) Then Exit For
  Next yr
  For mth = 1 To 12
    If minutes < GetMins(yr, mth, 1, 0, 0) Then Exit For
  Next mth
  mth = mth - 1
  day = ((minutes - GetMins(yr, mth, 1, 0, 0)) \ (24 * 60)) +  1
  GetDate$ = Mid$(days$, ((((minutes \ (24 * 60)) + 3) Mod 7) * 3) + 1,3)+"  "
  GetDate$ = GetDate$ + Right$(" " + Str$(day), 2)
  GetDate$ = GetDate$ + "-" + Mid$(mths$,mth*3,3) + "-" + Str$(yr + 2000)
End Function


' get the minutes that GMT will start or end in a month
' modified for NORTH OF THE EQUATOR - FOR SOUTH USE THE FUNCTION BELOW THIS
Function GetDST(yr As INTEGER, mth As INTEGER, hr As INTEGER) As INTEGER
  Local As INTEGER d, m, n
  m = GetMins(yr, mth, 1, hr, 0)
  d = ((m \ (24 * 60)) + 3) Mod 7
  m =  m + (((7 - d) Mod 7) * 24 * 60)
  n = GetMins(yr, mth + 1, 1, 0, 0)
  Do While m + (7 * 24 * 60) < n
  m = m + (7 * 24 * 60)
  Loop
  GetDST = m
End Function

' get the minutes that DST will start or end in a month USE THIS FOR SOUTH OF THE EQUATOR
'FUNCTION GetDST(yr, mth, hr)
'  LOCAL d, m,  n
'  m = GetMins(yr, mth, 1, hr, 0)
'  d = ((m \ (24 * 60)) + 3) MOD 7
'  GetDST =  m + (((7 - d) MOD 7) * 24 * 60)
'END FUNCTION

'rainguage sensor interrupt
Sub rainguageClick
thistime=Timer-rain_last
rain_last=Timer
If thistime>10 Then
  rain_count=rain_count+1
  'Print "Rain click"         'Test so you can see if your rain device is working - REMOVE when not needed
End If
End Sub

'***********************************************************************************

'Wind speed sensor interrupt
Sub anemometerClick
thistime=Timer-anem_last  'thistime measures the time between pulses
anem_last=Timer
If thistime>5 Then                     'only process if > 5mSec, for switch debounce
  anem_count=anem_count+1              'Adds up pulses single pulse per/rotation
  'anem_count=anem_count+3              'Adds up pulses  '****similation for 3 pulses only - Rem when not used ****
  If thistime<anem_min Then            'If the time is less than 1 second
    anem_min=thistime 'gust            'then thistime = gust
  End If
  'Print "Wind click"               'Prints this EVERY time the reed switch closes=**TEST USE ONLY - DELETE WHEN happy its working properly
  'use this to check how many switch closures per revolution when turning by hand
End If
'print "Incr Anem counts:";anem_count;" This Pulse interval:";thistime;" Min Pulse interval:";anem_min ***While testing only***
End Sub
'**********************************************

Sub BATTERY
Batt2 = Pin(24)      'Battery volage is measured on Pin 24
Batt = Batt2 * 2     'Actual battery voltage is twice the value measured
temp = TEMPR(3)
If bme280_read_temp() < lowtemp Then
lowtemp = bme280_read_temp()
End If
If bme280_read_temp() > hightemp Then
hightemp = bme280_read_temp()
End If
End Sub


'****************************************


'************************************************************************************
'Wind Direction data process           ** Checked with multimeter 0-3.3v 0-360 deg*****
Sub WindDirProc
wheading2 = Pin(26)
wheading = wheading2 / 0.0091666666666667
wheading3 = wheading

 '***************************************************************************************
End Sub

'**********************************************************************************

'Wind Speed data process
Sub WindSpeedProc
wResult=0
'calc wind average
reading=anem_count
anem_count=0
wSpeed=(windfactor*reading)/(testpause/1000)
'calc Gust
reading=anem_min
anem_min=1000
wGust=(1/(reading/1000))*windfactor
For y = 1 To 9        'move data up array
  wArray(y) = wArray(y+1)
Next y
wArray(10) = wSpeed    'place latest reading in Array
For y = 1 To 10         'addup all data in array
  wResult = wResult + wArray(y)
Next y
wCount=wCount+1
If wCount>10 Then wCount=1
wSpeed=wResult/10           'get average the the last 10 wind samples
If wgust>hgust Then hgust=wgust
End Sub

'************************************************************************************

'Rain sensor process
Sub RainProc
reading=rain_count
rain_count=0
mmRain=mmRain + (reading*rainfactor)
End Sub

'*********************************************************************************************
Sub SendDataUpdate   'Transmit weather data to indoor unit
Print "*********************************"
Print Time$
Print " Battery Voltage   ";Str$(batt,3,2);" V"
Print " Direction:        ";Str$(wheading);" Degrees"
Print " WindSpeed:        ";Str$(wSpeed); " MPH"
Print " Gust              ";Str$(wgust,3,2); " MPH"
Print " Highest Gust      ";Str$(hgust,3,2); " MPH"
Print " Rain Today        ";Str$(mmrain,3,2);" mm"
Print " Rain Yesterday    ";Str$(mmrain2,3,2);" mm"
Print " Temperature       "; Str$(bme280_read_temp(),3,2)" C "
Print " Highest Temp      ";Str$(hightemp,3,2) " C"
Print " Lowest Temp       ";Str$(lowtemp,3,2) " C"
Print " Hi Temp Yesterday ";Str$(hightemp2,3,2) " C"
Print " LOW Temp Yesterday ";Str$(lowtemp2,3,2) " C"
Print " Pressure           "; Str$(bme280_read_pressure(),3,2)" mB "
Print " HUMIDITY           "; Str$(bme280_read_humidity(),3,2)"%"
Print " UV Index:          ";Str$(UVindex,3,2)
Print "*******************************"
for BB = 1 to 5  'Transmit data to indoor unit 5 times just in case the indoor unit misses it 1st time
Print #2, "STXW ," bme280_read_temp() "," bme280_read_pressure() ",";
Print #2, wheading "," wSpeed ",";
Print #2, wgust "," hgust "," mmrain "," mmrain2 "," hightemp ",";
Print #2, hightemp2 "," lowtemp "," lowtemp2 "," UVindex "," batt "," Str$(bme280_read_humidity(),3,2) "," "*"
pause 500 'Pause half a second
NEXT BB
End Sub

*****************************************************************************************

 'L1 - 1second Tick interrupt
Sub L1
secs=secs+1   'update seconds timer
If secs => 86400 Then     '24 hrs reached
  secs = 0                'reset counter
EndIf
End Sub

'*********************************************************************************************
Function  bme280_read_temp() As float
  Local integer var1,var2,adc_T
  Local adc%(2)
  I2C write BME280_ADDRESS,1,1,BME280_REGISTER_TEMPDATA
  I2C read BME280_ADDRESS,0,3,adc%()
  adc_T=((adc%(0)<<16) Or (adc%(1)<<8) Or adc%(2))>>4
  var1  = ((((adc_T>>3) - (T1 <<1))) * T2) \ q(11)
  var2  = (((((adc_T>>4) - (T1)) * ((adc_T\ q(4)) - (T1))) \ q(12)) * (T3)) \ q(14)
  t_fine = var1 + var2
  bme280_read_temp = ((t_fine * 5 + 128) \ q(8))/100.0
  End Function

Function  bme280_read_pressure() As float
  Local integer var1, var2, adc_P, p
  Local adc%(2)
  I2C write BME280_ADDRESS,1,1,BME280_REGISTER_PRESSUREDATA
  I2C read BME280_ADDRESS,0,3,adc%()
  adc_P=((adc%(0)<<16) Or (adc%(1)<<8) Or adc%(2))>>4
  var1 = t_fine - 128000
  var2 = var1 * var1 * P6
  var2 = var2 + ((var1 * P5)<<17)
  var2 = var2 + (P4 << 35)
  var1 = ((var1 * var1 * P3)\ q(8)) +    ((var1 * P2)<<12)
  var1 = ((1<<47)+var1)*P1\ q(33)
  If var1 = 0 Then
    bme280_read_pressure =  0' avoid exception caused by division by zero
    Exit Function
  EndIf
  p = 1048576 - adc_P
  p = (((p<<31) - var2)*3125) \ var1
  var1 = (P9 * (p\ q(13)) * (p\ q(13))) \ q(25)
  var2 = (P8 * p) \ q(19)
  p = ((p + var1 + var2) \ q(8)) + (P7<<4)
  bme280_read_pressure = p/25600.0
  pressure = bme280_read_pressure
End Function
'
Function  bme280_read_humidity() As float
  Local integer v_x1,adc_H
  Local adc%(1)
  I2C write BME280_ADDRESS,1,1,BME280_REGISTER_HUMIDDATA
  I2C read BME280_ADDRESS,0,2,adc%()
  adc_H=(adc%(0)<<8) Or adc%(1)
  v_x1 = t_fine - 76800
  v_x1=(((((adc_H<<14)-((H4)<<20)-(H5*v_x1))+16384)\ q(15))*(((((((v_x1*H6)\ q(10))*(((v_x1*H3)\ q(11))+32768))\ q(10))+2097152)*H2+8192)\ q(14)))
  v_x1 = (v_x1 - (((((v_x1 \ q(15)) * (v_x1 \ q(15))) \ q(7)) * (H1)) \ q(4)))
  If v_x1< 0 Then v_x1 = 0
  If v_x1 > 419430400 Then v_x1= 419430400
  bme280_read_humidity = (v_x1\ q(12)) / 1024.0
   humidity = bme280_read_humidity
End Function

Sub bme280_init
  local i%,cal%(17)   
  i2c open 400,1000 '400KHz bus speed   
  i2c write BME280_ADDRESS,1,1,BME280_REGISTER_CHIPID   
  i2c read BME280_ADDRESS,0,1,i%   
  if i%<>&H60 then print "Error BME280 not found"   
  '   
  i2c write BME280_ADDRESS,1,1,BME280_REGISTER_T1   
  i2c read BME280_ADDRESS,0,6,cal%()   
  T1=cal%(0) OR (cal%(1)<< 8)   
  T2=cal%(2) OR (cal%(3)<< 8):   if T2 and s16b then T2=T2 OR s16 'sign extend if required   
  T3=cal%(4) OR (cal%(5)<< 8):   if T3 and s16b then T3=T3 OR s16  
  '   
  i2c write BME280_ADDRESS,1,1,BME280_REGISTER_P1   
  i2c read BME280_ADDRESS,0,18,cal%()   
  P1=cal%(0) OR (cal%(1)<<8)   
  P2=cal%(2) OR (cal%(3)<<8):   if P2 and s16b then P2=P2 OR s16 'sign extend if required   
  P3=cal%(4) OR (cal%(5)<<8):   if P3 and s16b then P3=P3 OR s16 
  P4=cal%(6) OR (cal%(7)<<8):   if P4 and s16b then P4=P4 OR s16  
  P5=cal%(8) OR (cal%(9)<<8):   if P5 and s16b then P5=P5 OR s16 
  P6=cal%(10) OR (cal%(11)<<8):   if P6 and s16b then P6=P6 OR s16 
  P7=cal%(12) OR (cal%(13)<<8):   if P7 and s16b then P7=P7 OR s16 
  P8=cal%(14) OR (cal%(15)<<8):   if P8 and s16b then P8=P8 OR s16 
  P9=cal%(16) OR (cal%(17)<<8):   if P9 and s16b then P9=P9 OR s16 
  '   
  i2c write BME280_ADDRESS,1,1,BME280_REGISTER_H1   
  i2c read BME280_ADDRESS,0,1,H1   
  i2c write BME280_ADDRESS,1,1,BME280_REGISTER_H2   
  i2c read BME280_ADDRESS,0,7,cal%()   
  H2=cal%(0) OR (cal%(1)<< 8):   if H2 and s16b then H2=H2 OR s16 'sign extend if required   
  H3=cal%(2)   
  H6=cal%(6):   if H6 and s8b then H6=H6 OR s8 'sign extend if required   
  H4=(cal%(3)<<4) OR (cal%(4) and &H0F): if H4 and s12b then H4=H4 OR s12 'sign extend if required   
  H5=(cal%(5)<<4) OR (cal%(4)>>4):  if H5 and s12b then H5=H5 OR s12 
  '   
  i2c write BME280_ADDRESS,0,2,BME280_REGISTER_CONTROLHUMID,&H05 '16x oversampling humidity 
  i2c write BME280_ADDRESS,0,2,BME280_REGISTER_CONTROL,&HB7      '16x oversampling pressure/temp, normal mode    
  ' 
'*****************************SI1145***************************
If(read8(SI1145_REG_PARTID)<>&H45) Then
Print "SI1145 not found"
Print #2, "SI1145 not found"
Else
  reset_SI1145()
  start_SI1145()
End If
  UVindex = readUV()
  UVindex = UVindex /100.0

'************************************************************
End Sub
'
Function q(x As integer) As integer  'returns 2 raised to the power
  q=(1<<x)
End Function

'*******************************SI1145 Subroutines******************
Sub start_SI1145() 'set up the sensor and start it reading
  Local integer i
'    ***********************************
'   enable UVindex measurement coefficients!
  write8(SI1145_REG_UCOEFF0, &H29)
  write8(SI1145_REG_UCOEFF1, &H89)
  write8(SI1145_REG_UCOEFF2, &H02)
  write8(SI1145_REG_UCOEFF3, &H00)

'   enable UV sensor
  i=writeParam(SI1145_PARAM_CHLIST, SI1145_PARAM_CHLIST_ENUV Or SI1145_PARAM_CHLIST_ENALSIR Or SI1145_PARAM_CHLIST_ENALSVIS Or  SI1145_PARAM_CHLIST_ENPS1)
'   enable interrupt on every sample
  write8(SI1145_REG_INTCFG, SI1145_REG_INTCFG_INTOE)
  write8(SI1145_REG_IRQEN, SI1145_REG_IRQEN_ALSEVERYSAMPLE)

'****************************** Prox Sense 1

'   program LED current
  write8(SI1145_REG_PSLED21, &H03)'  20mA for LED 1 only
  i=writeParam(SI1145_PARAM_PS1ADCMUX, SI1145_PARAM_ADCMUX_LARGEIR)
'   prox sensor #1 uses LED #1
  i=writeParam(SI1145_PARAM_PSLED12SEL, SI1145_PARAM_PSLED12SEL_PS1LED1)
'   fastest clocks, clock div 1
  i=writeParam(SI1145_PARAM_PSADCGAIN, 0)
'   take 511 clocks to measure
  i=writeParam(SI1145_PARAM_PSADCOUNTER, SI1145_PARAM_ADCCOUNTER_511CLK)
'   in prox mode, high range
  i=writeParam(SI1145_PARAM_PSADCMISC, SI1145_PARAM_PSADCMISC_RANGE Or SI1145_PARAM_PSADCMISC_PSMODE)

  i=writeParam(SI1145_PARAM_ALSIRADCMUX, SI1145_PARAM_ADCMUX_SMALLIR)
 '  fastest clocks, clock div 1
  i=writeParam(SI1145_PARAM_ALSIRADCGAIN, 0)
 '  take 511 clocks to measure
  i=writeParam(SI1145_PARAM_ALSIRADCOUNTER, SI1145_PARAM_ADCCOUNTER_511CLK)
'   in high range mode
  i=writeParam(SI1145_PARAM_ALSIRADCMISC, SI1145_PARAM_ALSIRADCMISC_RANGE)



'   fastest clocks, clock div 1
  i=writeParam(SI1145_PARAM_ALSVISADCGAIN, 0)
'   take 511 clocks to measure
  i=writeParam(SI1145_PARAM_ALSVISADCOUNTER, SI1145_PARAM_ADCCOUNTER_511CLK)
'   in high range mode (not normal signal)
  i=writeParam(SI1145_PARAM_ALSVISADCMISC, SI1145_PARAM_ALSVISADCMISC_VRNG)


'************************

'   measurement rate for auto
  write8(SI1145_REG_MEASRATE0, &HFF)'  255 * 31.25uS = 8ms

'   auto run
  write8(SI1145_REG_COMMAND, SI1145_PSALS_AUTO)

End Sub

Sub reset_SI1145() 'Reset the sensor
  write8(SI1145_REG_MEASRATE0, 0)
  write8(SI1145_REG_MEASRATE1, 0)
  write8(SI1145_REG_IRQEN, 0)
  write8(SI1145_REG_IRQMODE1, 0)
  write8(SI1145_REG_IRQMODE2, 0)
  write8(SI1145_REG_INTCFG, 0)
  write8(SI1145_REG_IRQSTAT, &HFF)

  write8(SI1145_REG_COMMAND, SI1145_RESET)
  Pause 10
  write8(SI1145_REG_HWKEY, &H17)
  Pause 10
End Sub

' returns the UV index * 100 (divide by 100 to get the index)
Function readUV() As integer
 readUV= read16(&H2C)
End Function

' returns visible+IR light levels
Function readVisible() As integer
 readVisible = read16(&H22)
End Function

' returns IR light levels
Function readIR() As integer
 readIR = read16(&H24)
End Function

' returns "Proximity" - assumes an IR LED is attached to LED
Function readProx() As integer
 readProx = read16(&H26)
End Function

Function writeParam(p As integer, v As integer) As integer
  write8(SI1145_REG_PARAMWR, v)
  write8(SI1145_REG_COMMAND, p Or SI1145_PARAM_SET)
  writeParam = read8(SI1145_REG_PARAMRD)
End Function

Function readParam(uint8_t p) As integer
  write8(SI1145_REG_COMMAND, p Or SI1145_PARAM_QUERY)
  readParam = read8(SI1145_REG_PARAMRD)
End Function

Sub write8(reg As integer, myval As integer)
  I2C write SI1145_ADDR,0,2,reg,myval
End Sub

Function read8(reg As integer) As integer
  Local integer i
  I2C write SI1145_ADDR,1,1,reg
  I2C read SI1145_ADDR,0,1,i
  read8=i
End Function

Function read16(reg As integer) As integer
  Local integer i(1)
  I2C write SI1145_ADDR,1,1,reg
  I2C read SI1145_ADDR,0,2,i()
  read16=i(0) Or (i(1)<<8)
End Function
'***************************************************************
