  ﻿'Weather Station LCD Codef V1.0, Lewis G1RUN''''''''''''''''''''''''''''''''''''''''''
  'Thanks to Geoffg(GPS CODE), disco4now, Matherp, Palcal, WhiteWizzard, Microblocks, MikeO''''''''
  'and everyone else who helped me in getting the code working''''''''''''''''''''''''''
  'Sorry if I have missed anyones name out but please accept my thanks here'''''''''''''
  CLS RGB(blue)                         'Clear the screen to a Blue colour
  Const buffersize = 2500
  const Y_top = 0 'Y coordinate of top of the image file on the screen
  const X_left = 267 'X coordinate of left of the image file on the screen
  const Y_point = 110 'Y coordminate of the centre of the pointer relative to the image top
  const X_point = 130 'X coordinate of the centre of the pointer relative to the image left
  dim integer buff(buffersize)
  const SD_CS_PIN = 47 'Connection to CS on SD card
  const mount=0
  const fileopen=1
  const readfile=2
  const writefile=3
  const opendir=4
  const readdir=5
  sdcard mount,47,2
  DIM FLOAT temp, humidity
  HUMID 59, temp, humidity
  SETPIN 97, DOUT            '1/4 hour chime
  SETPIN 96, DOUT            '2/4 hour chime
  SETPIN 95, DOUT            '13/4 hour chime
  SETPIN 92, DOUT            '4/4 hour chime
  SETPIN 91, DOUT            'Hour chime
  SETPIN 90, DOUT            'Long Hour chime
  PIN(97) = 1                'Chime off
  PIN(96) = 1                'Chime off
  PIN(95) = 1                'Chime off
  PIN(92) = 1                'Chime off
  PIN(91) = 1                'Chime off
  PIN(90) = 1                'Chime off
  dim pics$(200) length 18, s$ length 18
  DIM ICON$ , ICON1$, ICON2$ , ICON3$ , ICON4$, speed0$, speed1$, speed2$, speed3$, speed4$
  DIM DESC0$ , DESC1$, DESC2$, DESC3$, DESC4$,  mint$, mint2$, mint3$, mint4$, maxt1$, maxt2$, maxt3$, maxt4$
  DIM TEMP0$, press0$, press1$, press2$, press3$, press4$, hum0$, hum1$, hum2$, hum3$, hum4$
  Dim DOW$(6) length 9
  DIM FieldArray$(50) 'Max number of fields recieved by serial port 2
  DIM FieldArray2$(50) 'Max number of fields recieved by serial port 1
  Dim CB$(10)
  Dim MinFlag  ' if you need to do someting every minute
  Dim EODFlag  ' if you need to know end of day
  Dim NewDataFlag
  dim integer nt=1 'Number of triangles used to define the pointer
  dim integer ptr(5)=(-7,0, 7,0, 0,-85)  ' define size of the pointers
  DIM INTEGER pcolour=(rgb(RED)) 'define the colour of the pointer
  DIM float heading
  const pivot=9 'diameter in pixels of the fulcrum of the pointer '
  dim integer bb
  dim integer xx0(nt),yy0(nt),xx1(nt),yy1(nt),xx2(nt),yy2(nt),tcol(nt)
  dim integer x,y,w,h
  cls rgb(BLUE)
  head = 1
  tail = 1
  SetTick 1000,UpDateTime    ' Call every second, print date/time
  ICON$  = "50d.ppm" : ICON1$  = "50d.ppm" : ICON2$  = "50d.ppm" : ICON3$  = "50d.ppm"
  day2$ = "xxx" : day3$ = "xxx" : day4$ = "xxx"
  RTC GETTIME                                              'Get the time from the RTC
  Year=Val(Mid$(Date$,7,4)):Month=Val(Mid$(Date$,4,2)):Day=Val(Mid$(Date$,1,2))
  CLS  BLUE                                                     'Clear the screen
  Font 1, 2 ' Set the default font
  Open "COM1:19200,1024,isr" As #1                           'Open port for HC-12 TX/RX
  OPEN "COM2:9600, 200" AS #2                                 'Open port for ESP8266
  '************** Background Pictures********************************
  DisplayPicture "TLeft.ppm",0,0        'Top left corner
  DisplayPicture "DIR.ppm",267,0        'Wind direction gauge
  DisplayPicture "TRight.ppm",534,0     'Top right corner
  DisplayPicture "BLeft.ppm",0,232      'Bottom left corner
  DisplayPicture "01d.ppm",267,232      'Weather icon
  DisplayPicture "BRight.ppm",533,232   'Bottom right corner
  '*******************************************************************
  TEXT 20 ,25, "IN  HUMID  OUT", LM, 1, 2, RGB(BLACK), RGB(49, 111, 170) 'Print Humidity
  Text 237 ,55, "%" , LM, 1, 2, RGB(BLACK), RGB(49, 111, 170)              'Print % symbl outdoor humid
  Text 100 ,55, "%" , LM, 1, 2, RGB(BLACK), RGB(49, 111, 170)              'Print % symbl indoor humid
  TEXT 20 ,255, "      Temp", LM, 1, 2, RGB(BLACK), RGB(172, 230, 50)     'Print Temp
  Text 220 ,285, "'C" , LM, 1, 2, RGB(BLACK), RGB(161, 216, 46)           'Print °C Outdoor
  Text 100 ,285, "'C" , LM, 1, 2, RGB(BLACK), RGB(161, 216, 46)           'Print °C Indoor
  GUI numberbox #2,165 ,40,65,30,RGB(BLACK),RGB(WHITE)  'numberbox outdoor humidity
  GUI numberbox #3,145 ,270,65,30,RGB(BLACK),RGB(WHITE) 'numberbox indoor temp
  GUI numberbox #4,25 ,40,65,30,RGB(BLACK),RGB(WHITE)  'numberbox indoor humidity
  GUI numberbox #5,25 ,270,65,30,RGB(BLACK),RGB(WHITE) 'numberbox outdoor temp
  getlimits(x, y, w, h)
  blit read #1, x, y, w, h
'''**********************Start of Main Program************************************************************************************
  Do
    If NewDataFlag = 1 then
      TEXT 280,235, TIME$+"          "+DATE$, LM, 1, 2, RGB(BLACK),RGB(white)
      Text 418,235, DOW$(DayOfWeek(Year, Month, Day)), LM, 1, 2, RGB(BLACK), RGB(WHITE)   'Print the Day of week
      'Text 170 ,55, Str$(humidity), RM, 1, 2, RGB(BLACK), RGB(49, 111, 170)   'Print the Humidity
      ' Text 173 ,285, Str$(temp), RM, 1, 2, RGB(BLACK), RGB(161, 216, 46)   'Print the Humidity
      NewDataFlag = 0
    EndIf
    '***********************Check Serial Ports for Data*********************
    If head<>tail Then                   ' collect sentence from buffer
      B$ = CB$(tail)
      tail = (tail Mod 10)+1
    EndIf
     if B$<>"" THEN SERIAL1
     B$ = ""
     END IF
  IF LOC(#2) > 0 THEN SERIAL2            'If data in Com1 then GOSUB Serial1
  END IF
   Heading = 180  'MAKE THE HEADING 180°
   drawpointer(heading)
   ctrlval(4)=humidity
   ctrlval(5)=temp
   ctrlval(2)=20.1 'test figure
   ctrlval(3)=20.4 'test figure
 LOOP
End

'********************End of Main program*********************************************************


'
Function GetFieldArray( Record$, Delimiter$, KeepQuotes )           'Function to get array from COM port
Local Index, Char, InQuote, Count
InQuote = 0
Count = 0
FieldArray$(Count) = ""
If Delimiter$ = "" Then Delimiter$ = ","
For Index = 1 To Len(Record$)
  Char = Asc(Mid$(Record$, Index, 1))
  If Char = 34 Then InQuote = Not InQuote
  If Not InQuote And Instr(Delimiter$, Chr$(char)) >= 1  Then
    Count = Count + 1
    FieldArray$(Count) = ""
  Else
    If Char <> 34 Or KeepQuotes Then
      FieldArray$(Count) = FieldArray$(Count) + Chr$(char)
    EndIf
  EndIf
Next
GetFieldArray = Count + 1
End Function


FUNCTION GetDirection(Dir As Integer) as String          'Function to change degrees to words for day2
LOCAL Directions(15) AS STRING =("North","NNE","NE","ENE","East","ESE","SE","SSE","South","SSW","SW","WSW","West","WNW","NW","NNW")
GetDirection = Directions((INT(Dir /22.5 + 16.5) MOD 16))
END FUNCTION


FUNCTION GetDirection1(Dir1 As Integer) as String           'Function to change degrees to words for day3
LOCAL Directions1(15) AS STRING =("North","NNE","NE","ENE","East","ESE","SE","SSE","South","SSW","SW","WSW","West","WNW","NW","NNW")
GetDirection1 = Directions1((INT(Dir1 /22.5 + 16.5) MOD 16))
END FUNCTION


FUNCTION GetDirection2(Dir2 As Integer) as String           'Function to change degrees to words for day4
LOCAL Directions2(15) AS STRING =("North","NNE","NE","ENE","East","ESE","SE","SSE","South","SSW","SW","WSW","West","WNW","NW","NNW")
GetDirection2 = Directions2((INT(Dir2 /22.5 + 16.5) MOD 16))
END FUNCTION


Function DayOfWeek(year AS INTEGER, month AS INTEGER, day AS INTEGER) AS INTEGER 'Day of Week Function
local integer a,m,y
a = Int((14-month)/12)
m = month + 12*a - 2
y = year - a
DayOfWeek = (day + y + Int(y/4)-Int(y/100)+Int(y/400)+Int(31*m/12)) Mod 7
End Function


'*******************End of Functions*******************************************************



'******************************PAGE 1 Draw Left 200 Pixels of screen**************************************
'SUB Page1                                                                  'Page 1
'CLS RGB(63, 133, 195)                                                      'Clear the screen to RGB(63, 133, 195)  Clear the screen
'DisplayPicture "4.ppm",0,0                                                 'Background Clock Image
'DisplayPicture "3.ppm",200,0                                               'Background Image
'TEXT 90 ,310, "Indoor", CM, 1, 2, RGB(BLACK), RGB(63, 133, 195)            'Indoor
'TEXT 70 ,350, "Humidity", CM, 1, 2, RGB(BLACK), RGB(70, 144, 205)          'Indoor
'Text 130 ,380, "%" , CM, 1, 2, RGB(BLACK), RGB(70, 144, 205)               '%
'Text 90,270, Date$, CM, 1, 2, RGB(BLACK), RGB(63, 133, 195)                'Date
'Text 80 ,380, Str$(humidity), CM, 1, 2, RGB(BLACK), RGB(70, 144, 205)      'Humidity
'Text 610 ,15, Str$(temp), CM, 1, 2, RGB(BLACK), RGB(48, 107, 167)          'Display the Indoor Temperature
'Text 660 ,15, "`C" , CM, 1, 2, RGB(BLACK), RGB(48, 107, 167)               'Display the C symbol
'Switch1                                                                    'Display the switch
'END SUB
'****************************End of Left 200 Pixels*********************************************


'************************* PAGE 2 Draw Remaining 600 Pixels of screen***********************************
SUB Page2                 'PAGE2
CLS RGB(63, 133, 195)     'Clear the screen to RGB(63, 133, 195)
DisplayPicture "4.ppm",0,0                   'Background Clock Image
TEXT 90 ,310, "Indoor", CM, 1, 2, RGB(BLACK), RGB(63, 133, 195)
TEXT 70 ,350, "Humidity", CM, 1, 2, RGB(BLACK), RGB(70, 144, 205)
Text 130 ,380, "%" , CM, 1, 2, RGB(BLACK), RGB(70, 144, 205)
TEXT 225, 10, "Tomorrow", CM, 1, 2, RGB(BLACK), RGB(63, 133, 195)           'day2
TEXT 570, 10, "Day 2", CM, 1, 2, RGB(BLACK), RGB(63, 133, 195)           'day3
TEXT 680, 10, "Day 3", CM, 1, 2, RGB(BLACK), RGB(63, 133, 195)           'day4
BOX 200, 20, 200, 460, 1, RGB(WHITE), RGB(63, 133, 195)                'Draw the box for data
BOX 400, 20, 200, 460, 1, RGB(WHITE), RGB(63, 133, 195)                'Draw the box for data
BOX  600, 20, 200, 460, 1, RGB(WHITE), RGB(63, 133, 195)               'Draw the box for data
Day2A                                                                  'Draw Pixels 201 - 400
Day3A                                                                  'Draw Pixels 401 - 600
Day4A                                                                  'Draw Pixels 601 - 800
Switch1                                                                'Gosub Switch1 (Draw the switch)
secs1 = 0
END SUB

Sub isr                                ' serial port handler
Local I, S$ length 80
S$ = Input$(72,#1)                   ' grab data into temporary buffer
Z$ = Right$(Z$,255-Len(S$))+S$       ' add to end of linear buffer
I = Instr(Z$,Chr$(13)+Chr$(10))      ' check for eol marker (CR+LF)
If I<>0 Then
  CB$(head) = Left$(Z$,I-1)          ' transfer into circular buffer
  head = (head Mod 10)+1
  If I<254 Then Z$ = Mid$(Z$,I+2) Else Z$=""
EndIf
End Sub



SUB SERIAL1
N = GetFieldArray(B$)
IF Left$(B$,4) = "STXG" THEN PRINT "Searching for gps lock"
IF Left$(B$,4) = "STXT" THEN TIME1
END IF
END IF
IF Left$(B$,4) = "STXW" THEN WEATHER
END IF
END SUB

SUB TIME1
Local year1 as integer, month1 as integer, day1 as integer, hour2 as integer, min2 as integer, secs as integer
year1 = VAL(MID$(B$,9, 2))
month1 = VAL(MID$(B$,7, 2))
day1 = VAL(MID$(B$,5, 2))
hour2 = VAL(MID$(B$,11, 2))
min2 = VAL(MID$(B$,13, 2))
sec2 = VAL(MID$(B$,15, 2))
PRINT B$   'Test print here to make sure B$ is being recieved
print MID$(B$,9, 2)","MID$(B$,7, 2)","MID$(B$,5, 2)","MID$(B$,11, 2)","MID$(B$,13, 2)","MID$(B$,15, 2)    'Set RTC to correct local time and date
RTC SETTIME year1,month1,day1,hour2,min2,sec2    'Set RTC to correct local time and date
RTC GETTIME
PRINT time$
print date$
Text 90,215, DOW$(DayOfWeek(Year, Month, Day)), CM, 1, 2, RGB(BLACK), RGB(63, 133, 195)   'Print the Day of week Under Big Ben
secs=sec2
mins=Val(Mid$(Time$,4,2))
hours=Val(Left$(Time$,2) )
END SUB

SUB WEATHER
LOCAL N as INTEGER
N = GetFieldArray(B$)
PRINT B$
'FieldArray$ values in order
'temperature,pressure,direction,speed,gust,highest gust,rain,rain yest,
'high temp,high temp yest, low temp, low temp yest, uv index, battery voltage, humidity
Text 690 ,1, "     " , TR, 1, 2, RGB(BLACK), RGB(48, 107, 167))        'clear the temp & °C symbol top right
Text 800 ,1, "`C" , TR, 1, 2, RGB(BLACK), RGB(48, 107, 167))           'Display  the "°C" symbol top right
Text 770 ,1, FieldArray$(1), TR, 1, 2, RGB(BLACK), RGB(48, 107, 167)   'Display the Outdoor Temperature top right
Text 610 ,15, "     ", CM, 1, 2, RGB(BLACK), RGB(48, 107, 167)         'Display the Indoor Temperature
Text 610 ,15, Str$(temp), CM, 1, 2, RGB(BLACK), RGB(48, 107, 167)      'Display the Indoor Temperature
Text 660 ,15, "`C" , CM, 1, 2, RGB(BLACK), RGB(48, 107, 167)           'Display the C symbol
Text 345 ,140, "MPH" , R, 1, 2, RGB(BLACK), RGB(54, 120, 181)          'Display "MPH"
Text 350 ,100, FieldArray$(5) , R, 1, 2, RGB(BLACK), RGB(53, 119, 180))'Display the Speed
Text 530 ,130, "mb" , R, 1, 2, RGB(BLACK), RGB(51, 119, 180))          'Display "mb" symbol
Text 575 ,100, FieldArray$(2) , R, 1, 2, RGB(BLACK), RGB(52, 116, 178))'Display the Pressure
Text 80 ,380, "      ", CM, 1, 2, RGB(BLACK), RGB(70, 144, 205)        'Clear Humidity
Text 80 ,380, Str$(humidity), CM, 1, 2, RGB(BLACK), RGB(70, 144, 205)  'Update Humidity bottom right screen
Text 530 ,380, "%" , CM, 1, 2, RGB(BLACK), RGB(142, 181, 210)           'Display the % symbol
Text 500 ,380, Str$(humidity) , CM, 1, 2, RGB(BLACK), RGB(142, 181, 210)'Display the Humidity
Text 300 ,380, FieldArray$(5) , CM, 1, 2, RGB(BLACK), RGB(71, 146, 204)'Display Average Speed
Text 680 ,370, FieldArray$(3) , CM, 1, 2, RGB(BLACK), RGB(139, 178, 207)'Display Wind Direction
Text 740 ,400, "'"  , CM, 1, 2, RGB(BLACK), RGB(155, 185, 209)         'Display Average Speed
Text 270,250, "Battery", LM, 1, 2, RGB(BLACK), RGB(63, 133, 195)
Text 380,250, FieldArray$(14), LM, 1, 2, RGB(BLACK), RGB(63, 133, 195)   'Battery voltage
Text 500,250, "V", RM, 1, 2, RGB(BLACK), RGB(63, 133, 195)

PRINT FieldArray$(1), "temp"
PRINT FieldArray$(2), "pressure"
PRINT FieldArray$(3), "direction"
PRINT FieldArray$(4), "Speed"
PRINT FieldArray$(5), "gust"
PRINT FieldArray$(6), "high gust"
PRINT FieldArray$(7), "rain"
PRINT FieldArray$(8), "rain yesterday"
PRINT FieldArray$(9), "highest temp"
PRINT FieldArray$(10), "highest temp yesterday"
PRINT FieldArray$(11), "lowest temp"
PRINT FieldArray$(12), "lowest temp yesterday"
PRINT FieldArray$(13), "UV index"
PRINT FieldArray$(14), "Battery"
PRINT FieldArray$(15), "Humidity"
PRINT "Weather String"
END SUB


SUB SERIAL2                                                       'Com2 ESP8266 Weather Forecast
Local D$                                                        'Get the data in arrays
LOCAL N as INTEGER
D$ = Input$(254, #2)                                            'Suck everything in buffer out
N = GetFieldArray(D$)
IF FieldArray$(0) = "Today" THEN T1                             'If the 1st array is "Today" then GOSUB T1
IF FieldArray$(0) = "Day2" THEN T2                              'If the 1st array is "Day2" then GOSUB T2                             'If the 1st array is "Day2" then GOSUB T2
IF FieldArray$(0) = "Day3" THEN T3                              'If the 1st array is "Day3" then GOSUB T3
IF FieldArray$(0) = "Day4" THEN T4                              'If the 1st array is "Day4" then GOSUB T4
End Sub



'**************************************Today************************************
SUB T1                                                            'T1  Today
desc0$ = FieldArray$(1)
temp0$ = FieldArray$(3)
press0$ = FieldArray$(4)
hum0$ = FieldArray$(7)
speed0$ = FieldArray$(5)
dir0$ = FieldArray$(6)
ICON$ = FieldArray$(2)
Select Case ICON$
  Case "01d"
    ICON$ = ICON$ + ".ppm"
  Case "01n"
    ICON$ = ICON$ + ".ppm"
  Case "02d"
    ICON$ = ICON$ + ".ppm"
  Case "02n"
    ICON$ = ICON$ + ".ppm"
  CASE "03d"
    ICON$ = ICON$ + ".ppm"
  CASE "03n"
    ICON$ = ICON$ + ".ppm"
  Case "04d"
    ICON$ = ICON$ + ".ppm"
  Case "04n"
    ICON$ = ICON$ + ".ppm"
  Case "09d"
    ICON$ = ICON$ + ".ppm"
  CASE "09n"
    ICON$ = ICON$ + ".ppm"
  CASE "10d"
    ICON$ = ICON$ + ".ppm"
  CASE "10n"
    ICON$ = ICON$ + ".ppm"
  CASE "11d"
    ICON$ = ICON$ + ".ppm"
  CASE "11n"
    ICON$ = ICON$ + ".ppm"
  CASE "13d"
    ICON$ = ICON$ + ".ppm"
  CASE "13n"
    ICON$ = ICON$ + ".ppm"
  CASE "50d"
    ICON$ = ICON$ + ".ppm"
  CASE "50n"
    ICON$ = ICON$ + ".ppm"
  Case Else
    ICON$  = "50d.ppm"
End Select

'****************Display Weather ICON on the left of the Screen***************
'DisplayPicture ICON$ , 150 , 340                                    'Display Today's Weather ICON
END SUB
'********************************End of Today*************************************************

'**********************************Tomorrow***************************************************
SUB T2                                     'T2 Tomorrow
ICON1$ = FieldArray$(3)                    'ICON
desc1$ = FieldArray$(2)                    'DESCRIPTION
mint1$ = FieldArray$(4)                    'MIN-TEMP
maxt1$ = FieldArray$(5)                    'MAX-TEMP
press1$ = FieldArray$(6)                   'PRESSURE
hum1$ = FieldArray$(7)                     'HUMIDITY
speed1$ = FieldArray$(8)                   'WIND SPEED
dir1$ = FieldArray$(9)                      'WIND DIRECTION
day2$ = LEFT$(FieldArray$(1), 3)           'DAY THE FORECAST RELATES TO
Select Case ICON1$                         'SELECT THE CORRECT ICON FOR TODAY
  Case "01d"
    ICON1$ = ICON1$ + ".ppm"
  Case "01n"
    ICON1$ = ICON1$ + ".ppm"
  Case "02d"
    ICON1$ = ICON1$ + ".ppm"
  Case "02n"
    ICON1$ = ICON1$ + ".ppm"
  CASE "03d"
    ICON1$ = ICON1$ + ".ppm"
  CASE "03n"
    ICON1$ = ICON1$ + ".ppm"
  Case "04d"
    ICON1$ = ICON1$ + ".ppm"
  Case "04n"
    ICON1$ = ICON1$ + ".ppm"
  Case "09d"
    ICON1$ = ICON1$ + ".ppm"
  CASE "09n"
    ICON1$ = ICON1$ + ".ppm"
  CASE "10d"
    ICON1$ = ICON1$ + ".ppm"
  CASE "10n"
    ICON1$ = ICON1$ + ".ppm"
  CASE "11d"
    ICON1$ = ICON1$ + ".ppm"
  CASE "11n"
    ICON1$ = ICON1$ + ".ppm"
  CASE "13d"
    ICON1$ = ICON1$ + ".ppm"
  CASE "13n"
    ICON1$ = ICON1$ + ".ppm"
  CASE "50d"
    ICON1$ = ICON1$ + ".ppm"
  CASE "50n"
    ICON1$ = ICON1$ + ".ppm"
  Case Else
    ICON1$  = "50d.ppm"
END SELECT
END SUB



SUB Day2A      ' Sub to display text for Tomorrow on Page2
Direction$ = getDirection(INT(VAL(dir1$)))
DisplayPicture ICON1$ , 280 , 35
TEXT 202, 110, desc1$ , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)           'description
TEXT 202, 170, "Tmin" , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)
TEXT 280, 170, mint1$ , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)              'minimum temp
TEXT 360, 170, "`C" , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)
TEXT 202, 228, "Tmax" , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)
TEXT 280, 228, maxt1$ , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)             'max temp
TEXT 360, 228, "`C" , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)
TEXT 202, 288, "Pres" , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)
TEXT 268, 288, press1$ , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)           'press
TEXT 348, 288, " mb" , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)
TEXT 202, 348, "Humidity" , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)
TEXT 333, 348, hum1$ , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)          'humidity
TEXT 398, 348, " %" , R, 1, 2, RGB(BLACK), RGB(63, 133, 195)
TEXT 202, 408, "Wind" , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)
TEXT 290, 408, speed1$(2,0), L, 1, 2, RGB(BLACK), RGB(63, 133, 195)           'speed
TEXT 398, 408, " MPH" , R, 1, 2, RGB(BLACK), RGB(63, 133, 195)
TEXT 202, 450, "Dir" , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)
TEXT 280, 450, dir1$, L, 1, 2, RGB(BLACK), RGB(63, 133, 195)            'direction
TEXT 398, 450, Direction$, R, 1, 2, RGB(BLACK), RGB(63, 133, 195)
End SUB
'******************End of Tomorrow*********************************************


'***************************Day after Tomorrow********************************

SUB T3                                    'T3 DAY AFTER TOMORROW
ICON2$ = FieldArray$(3)                    'ICON
desc2$ = FieldArray$(2)                    'DESCRIPTION
mint2$ = FieldArray$(4)                    'MIN-TEMP
maxt2$ = FieldArray$(5)                    'MAX-TEMP
press2$ = FieldArray$(6)                   'PRESSURE
hum2$ = FieldArray$(7)                     'HUMIDITY
speed2$ = FieldArray$(8)                   'WIND SPEED
dir2$ = FieldArray$(9)                     'WIND DIRECTION
day3$ = LEFT$(FieldArray$(1), 3)           'DAY THE FORECAST RELATES TO
Select Case ICON2$                         'SELECT THE CORRECT ICON FOR TODAY
  Case "01d"
    ICON2$ = ICON2$ + ".ppm"
  Case "01n"
    ICON2$ = ICON2$ + ".ppm"
  Case "02d"
    ICON2$ = ICON2$ + ".ppm"
  Case "02n"
    ICON2$ = ICON2$ + ".ppm"
  CASE "03d"
    ICON2$ = ICON2$ + ".ppm"
  CASE "03n"
    ICON2$ = ICON2$ + ".ppm"
  Case "04d"
    ICON2$ = ICON2$ + ".ppm"
  Case "04n"
    ICON2$ = ICON2$ + ".ppm"
  Case "09d"
    ICON2$ = ICON2$ + ".ppm"
  CASE "09n"
    ICON2$ = ICON2$ + ".ppm"
  CASE "10d"
    ICON2$ = ICON2$ + ".ppm"
  CASE "10n"
    ICON2$ = ICON2$ + ".ppm"
  CASE "11d"
    ICON2$ = ICON2$ + ".ppm"
  CASE "11n"
    ICON2$ = ICON2$ + ".ppm"
  CASE "13d"
    ICON2$ = ICON2$ + ".ppm"
  CASE "13n"
    ICON2$ = ICON2$ + ".ppm"
  CASE "50d"
    ICON2$ = ICON2$ + ".ppm"
  CASE "50n"
    ICON2$ = ICON2$ + ".ppm"
  Case Else
    ICON2$  = "50d.ppm"
End Select
END SUB


SUB Day3A   ' Sub to display text for Day after Tomorrow on Page2
Direction1$ = getDirection1(INT(VAL(dir2$)))
DisplayPicture ICON2$ , 480 , 35
TEXT 402, 110, desc2$ , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)           'description
TEXT 402, 170, "Tmin" , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)
TEXT 480, 170, mint2$ , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)              'minimum temp
TEXT 560, 170, "`C" , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)
TEXT 402, 228, "Tmax" , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)
TEXT 480, 228, maxt2$ , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)             'max temp
TEXT 560, 228, "`C" , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)
TEXT 402, 288, "Pres" , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)
TEXT 4768, 288, press2$ , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)           'press
TEXT 548, 288, " mb" , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)
TEXT 402, 348, "Humidity" , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)
TEXT 533, 348, hum2$ , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)          'humidity
TEXT 598, 348, " %" , R, 1, 2, RGB(BLACK), RGB(63, 133, 195)
TEXT 402, 408, "Wind" , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)
TEXT 490, 408, speed2$(2,0), L, 1, 2, RGB(BLACK), RGB(63, 133, 195)           'speed
TEXT 598, 408, " MPH" , R, 1, 2, RGB(BLACK), RGB(63, 133, 195)
TEXT 402, 450, "Dir" , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)
TEXT 480, 450, dir2$, L, 1, 2, RGB(BLACK), RGB(63, 133, 195)            'direction
TEXT 598, 450, Direction1$ , R, 1, 2, RGB(BLACK), RGB(63, 133, 195)
END SUB
'**************************End of Day after Tomorrow*****************************



'*******************************3 Days Time****************************************
SUB T4                                    'T2 3 DAYS TIME
ICON3$ = FieldArray$(3)                    'ICON
desc3$ = FieldArray$(2)                    'DESCRIPTION
mint3$ = FieldArray$(4)                    'MIN-TEMP
maxt3$ = FieldArray$(5)                    'MAX-TEMP
press3$ = FieldArray$(6)                   'PRESSURE
hum3$ = FieldArray$(7)                     'HUMIDITY
speed3$ = FieldArray$(8)                   'WIND SPEED
dir3$ = FieldArray$(9)                     'WIND DIRECTION
day4$ = LEFT$(FieldArray$(1), 3)           'DAY THE FORECAST RELATES TO
Select Case ICON3$                         'SELECT THE CORRECT ICON FOR TODAY
  Case "01d"
    ICON3$ = ICON3$ + ".ppm"
  Case "01n"
    ICON3$ = ICON3$ + ".ppm"
  Case "02d"
    ICON3$ = ICON3$ + ".ppm"
  Case "02n"
    ICON3$ = ICON3$ + ".ppm"
  CASE "03d"
    ICON3$ = ICON3$ + ".ppm"
  CASE "03n"
    ICON3$ = ICON3$ + ".ppm"
  Case "04d"
    ICON3$ = ICON3$ + ".ppm"
  Case "04n"
    ICON3$ = ICON3$ + ".ppm"
  Case "09d"
    ICON3$ = ICON3$ + ".ppm"
  CASE "09n"
    ICON3$ = ICON3$ + ".ppm"
  CASE "10d"
    ICON3$ = ICON3$ + ".ppm"
  CASE "10n"
    ICON3$ = ICON3$ + ".ppm"
  CASE "11d"
    ICON3$ = ICON3$ + ".ppm"
  CASE "11n"
    ICON3$ = ICON3$ + ".ppm"
  CASE "13d"
    ICON3$ = ICON3$ + ".ppm"
  CASE "13n"
    ICON3$ = ICON3$ + ".ppm"
  CASE "50d"
    ICON3$ = ICON3$ + ".ppm"
  CASE "50n"
    ICON3$ = ICON3$ + ".ppm"
  Case Else
    ICON3$  = "50d.ppm"
End Select
END SUB

SUB DAY4A       ' Sub to display text for 3rd day from now on Page2
Direction2$ = getDirection2(INT(VAL(dir3$)))
DisplayPicture ICON3$ , 680 , 35
TEXT 602, 110, desc3$ , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)           'description
TEXT 602, 170, "Tmin" , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)
TEXT 680, 170, mint3$ , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)              'minimum temp
TEXT 760, 170, "`C" , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)
TEXT 602, 228, "Tmax" , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)
TEXT 680, 228, maxt3$ , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)             'max temp
TEXT 760, 228, "`C" , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)
TEXT 602, 288, "Pres" , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)
TEXT 668, 288, press3$ , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)           'press
TEXT 748, 288, " mb" , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)
TEXT 602, 348, "Humidity" , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)
TEXT 733, 348, hum3$ , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)          'humidity
TEXT 798, 408, " %" , R, 1, 2, RGB(BLACK), RGB(63, 133, 195)
TEXT 602, 408, "Wind" , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)
TEXT 690, 408, speed3$(2,0), L, 1, 2, RGB(BLACK), RGB(63, 133, 195)           'speed
TEXT 798, 408, " MPH" , R, 1, 2, RGB(BLACK), RGB(63, 133, 195)
TEXT 604, 450, "Dir" , L, 1, 2, RGB(BLACK), RGB(63, 133, 195)
TEXT 680, 450, dir3$, L, 1, 2, RGB(BLACK), RGB(63, 133, 195)            'direction
TEXT 798, 450, Direction2$ , R, 1, 2, RGB(BLACK), RGB(63, 133, 195)
END SUB
'*******************************End of 3 Day's time***************************************





Sub DisplayPicture(PIC$, StartX%, StartY%)
LOCAL Buffer$,addbuffer$ length 3
LOCAL Result%=-1
LOCAL NumBytes%,a%,i%
local integer buff(511)
SDcard       fileopen,PIC$
'Read the first 128 bytes
Buffer$=STRING$(128," ")
SDcard readfile,buffer$,0,len(buffer$),NumBytes%
a%=instr(buffer$,chr$(10)) ' look for the first CR
if left$(buffer$,a%-1)="P6" then
  buffer$=right$(buffer$,len(buffer$)-a%)
  if left$(buffer$,1)="#" then
    a%=instr(buffer$,chr$(10)) ' look for the second CR
    buffer$=right$(buffer$,len(buffer$)-a%)
  endif
  a%=instr(buffer$,chr$(32)) ' look for the space between dimensions
  local width%=val(left$(buffer$,a%-1))
  buffer$=right$(buffer$,len(buffer$)-a%)
  a%=instr(buffer$,chr$(10)) ' look for the third CR
  LOCAL height%=val(left$(buffer$,a%-1))
  buffer$=right$(buffer$,len(buffer$)-a%)
  a%=instr(buffer$,chr$(10)) ' look for the fourth CR
  buffer$=right$(buffer$,len(buffer$)-a%)
  a%=len(buffer$) mod 3
  addBuffer$=STRING$(3-a%," ") ' we need to make sure we have a number of bytes divisible by three in the buffer
  SDcard readfile,addbuffer$,-1,len(addbuffer$),NumBytes%
  buffer$=buffer$+addbuffer$
  if (StartX%+width%>MM.HRES) OR (StartY%+height%>MM.VRES) then
    print pic$," too big", width%," x",height%
  else
    defineregionSSD StartX%, StartY%, width%, height%
    DisplayBufferSSD Buffer$
    do
      SDcard readfile,buff(),-1,4095,NumBytes%
      if numbytes%<>0 then DisplayBufferSSD Buff(),numbytes%
    loop while NumBytes%<>0
  endif
else
  Print "Invalid File Format"
endif

end sub

'*********************************************Enf of .ppm Sub

' Interrupt service routine
' Interrupt service routine
Sub UpDateTime ' called by 1 second interrupt from SetTick

Local hrs,mins,secs,day,month,year
hrs = Val(left$(Time$,2))
mins = Val(Mid$(Time$,4,2))
secs = Val(right$(Time$,2))
DOW$(0)="Sunday":DOW$(1)="Monday":DOW$(2)="Tuesday":DOW$(3)= "Wednesday":DOW$(4)="Thursday":DOW$(5)="Friday":DOW$(6)="Saturday" ' Day of the week
' Get the current time, extract the minutes component
If secs = 0 Then
  MinFlag = 1
Else
  MinFlag = 0
EndIf
' Get the current time, test for 00:00:00
If hrs = 2 And mins = 0 And secs = 1 Then
  RTC GETTIME
  EODFlag = 1
Else
  EODFlag = 0
EndIf
Year=Val(Mid$(Date$,7,4)):Month=Val(Mid$(Date$,4,2)):Day=Val(Mid$(Date$,1,2))
NewDataFlag = 1 ' set to indicate fresh data
End Sub
[/CODE]



sub getlimits(x as integer, y as integer, w as integer, h as integer)
Local integer i,max_x=0,min_x=MM.HRES,max_y=0,min_y=MM.VRES
for i=0 to  nt-1
  if(xx0(i)>max_x)then max_x=xx0(i)
  if(xx1(i)>max_x)then max_x=xx1(i)
  if(xx2(i)>max_x)then max_x=xx2(i)
  if(xx0(i)<min_x)then min_x=xx0(i)
  if(xx1(i)<min_x)then min_x=xx1(i)
  if(xx2(i)<min_x)then min_x=xx2(i)
  if(yy0(i)>max_y)then max_y=yy0(i)
  if(yy1(i)>max_y)then max_y=yy1(i)
  if(yy2(i)>max_y)then max_y=yy2(i)
  if(yy0(i)<min_y)then min_y=yy0(i)
  if(yy1(i)<min_y)then min_y=yy1(i)
  if(yy2(i)<min_y)then min_y=yy2(i)
next i
x=min_x
y=min_y
w=max_x-min_x+1
h=max_y-min_y+1
end sub

sub rotatetriangle(n as integer, col as integer, angle as float, x as integer, y as integer, x0 as integer, y0 as integer, x1 as integer, y1 as integer, x2 as integer, y2 as integer)
local float sine=sin(rad(angle)),cosine=cos(rad(angle))
local integer x0a,y0a,x1a,y1a,x2a,y2a
x0a= x0*cosine - y0 * sine + x
y0a= y0*cosine + x0 * sine + y
x1a= x1*cosine - y1 * sine + x
y1a= y1*cosine + x1 * sine + y
x2a= x2*cosine - y2 * sine + x
y2a= y2*cosine + x2 * sine + y
xx0(n)=x0a
yy0(n)=y0a
xx1(n)=x1a
yy1(n)=y1a
xx2(n)=x2a
yy2(n)=y2a
tcol(n)=col
end sub


Sub drawpointer(angle as float, offset as integer)
local integer last_x, last_y, last_w, last_h, i
for i=0 to nt-1
  'rotate the pointer into the drawing array for each triangle
  rotatetriangle(i,pcolour,angle,X_point+X_left,Y_point+Y_top,ptr(0),ptr(1),ptr(2),ptr(3),ptr(4),ptr(5))
NEXT i
last_x=x: last_y=y: last_w=w: last_h=h
getlimits(x, y, w, h)
blit WRITE #1, last_x, last_y, last_w, last_h   'update old rectangle with saved data
blit close #1                                   'free buffer
blit read #1, x, y, w, h                        'save the new rectangle to memory
local integer k
do
  k=getscanline()
loop while (k>200 AND k<350)
for i=0 to nt-1
  'write new triangle for each triangle
  triangle xx0(i), yy0(i)+offset, xx1(i), yy1(i)+offset, xx2(i), yy2(i)+offset, tcol(i),tcol(i)
NEXT i
drawpivot(offset)
End Sub

sub drawpivot(offset as integer) 'put anything you like here to draw the fulcrum as you wish
circle 397,110,pivot,0,,,rgb(54,54,54)
end sub



'*************Matherp's subs and CFUNCTIONS to draw .ppm pictures****************

Csub setrd
  00000000
  27BDFFE8 AFBF0014 AFB00010 3C109D00 8C830000 8E020090 24050008 00003021
  A043002D 8E030090 8E020010 0040F809 8064002D 8E030090 8E020010 24050065
  8064002D 0040F809 00003021 8E030090 8E02001C 24050006 0040F809 8064002D
  8FBF0014 8FB00010 03E00008 27BD0018
End Csub
  
  
  
  '
CSub DisplayBufferSSD '100-pin
  00000000
  14A00003 90880000 10000004 24050001 8CA80000 00002821 2508FFFF 00A8102A
  10400017 00852021 3C02BF88 24030200 90870000 24A50003 00A8302A 34E70300
  AC476430 AC436434 AC436438 90870001 34E70300 AC476430 AC436434 AC436438
  90870002 24840003 34E70300 AC476430 AC436434 AC436438 54C0FFEE 90870000
  03E00008 00000000
End CSub
  '
  
  
CSub defineregionSSD '100-pin
  00000000
  3C029D00 8C420090 8C830000 8CA50000 8CC40000 24080100 8CE60000 3C07BF88
  ACE86434 80420015 24A7FFFF 2468FFFF 00E63021 24070001 10470004 01042021
  24070003 14470005 3C029D00 00C03821 00604021 10000007 00803021 8C420094
  00A04021 8C470000 24E7FFFF 00E42823 00E33823 00086202 00065A02 3C02BF88
  24030200 24040100 00055202 34C60300 358C0300 35080300 356B0300 240D022A
  AC4D6430 00074A02 AC436434 34A50300 AC436438 354A0300 AC446438 AC4C6430
  AC436434 AC436438 AC486430 AC436434 AC436438 AC4B6430 AC436434 AC436438
  AC466430 2406022B AC436434 35290300 AC436438 34E70300 AC446434 AC466430
  AC436434 AC436438 AC446438 AC4A6430 AC436434 AC436438 AC456430 2405022C
  AC436434 AC436438 AC496430 AC436434 AC436438 AC476430 AC436434 AC436438
  AC446434 AC456430 AC436434 AC436438 AC446438 03E00008 00000000
End CSub
  
  'End CSub
  '
  
  
CSub sdcard '64-pin or 100-pin
  00000676
  'rcv_spi
  240300FF 3C02BF80 AC435A20 3C03BF80 8C625A10 30420080 1040FFFD 3C02BF80
  8C425A20 03E00008 304200FF
  'xmit_spi
  308400FF 3C02BF80 AC445A20 3C03BF80 8C625A10 30420080 1040FFFD 3C02BF80
  8C425A20 03E00008 304200FF
  'mem_set
  10C00006 00801021 00862021 A0450000 24420001 5444FFFE A0450000 03E00008
  00000000
  'mem_cmp
  2407FFFF 24C6FFFF 10C70008 00001021 80830000 80A20000 00621023 14400003
  24840001 1000FFF7 24A50001 03E00008 00000000
  'mystrlen
  80830000 10600006 00001021 24420001 00821821 80630000 5460FFFD 24420001
  03E00008 00000000
  'send_cmd
  27BDFFE0 AFBF001C AFB20018 AFB10014 AFB00010 309100FF 7C111420 04410009
  00A09021 24040077 00002821 0411FFF4 00000000 2C430002 10600034 8FBF001C
  3231007F 3C109D00 8E030090 8E02001C 80640030 0040F809 24050006 0411FFB2
  00000000 8E030090 8E02001C 80640030 0040F809 24050005 0411FFAB 00000000
  02202021 0411FFB3 00000000 00122602 0411FFB0 00000000 7E443C00 0411FFAD
  00000000 7E443A00 0411FFAA 00000000 324400FF 0411FFA7 00000000 24020040
  12220006 24040095 3A310048 24020001 24030087 00402021 0071200A 0411FF9D
  00000000 2410000A 0411FF8F 00000000 7C021C20 04610004 2610FFFF 321000FF
  1600FFF9 00000000 8FBF001C 8FB20018 8FB10014 8FB00010 03E00008 27BD0020
  'disk_readp
  27BDFFD8 AFBF0024 AFB40020 AFB3001C AFB20018 AFB10014 AFB00010 00809021
  00C09821 00E0A021 3C029D00 8C42008C 8C4300FC 30630008 00051240 24040051
  0043280A 0411FFA6 00000000 14400024 24100001 34109C40 241100FF 0411FF6A
  00000000 14510005 2610FFFF 1600FFFB 00000000 1000001A 24100001 240300FE
  14430017 24100001 00138823 26310202 12600006 02348823 0411FF5B 00000000
  2673FFFF 1660FFFC 00000000 02548021 0411FF55 00000000 A2420000 26520001
  1650FFFB 00000000 0411FF4F 00000000 2631FFFF 1620FFFC 00000000 00008021
  3C029D00 8C430090 8C42001C 80640030 0040F809 24050006 0411FF43 00000000
  02001021 8FBF0024 8FB40020 8FB3001C 8FB20018 8FB10014 8FB00010 03E00008
  27BD0028
  'clust2sect
  24A5FFFE 8C830008 2463FFFE 00A3182B 10600005 00001021 90830002 8C820014
  70A32002 00821021 03E00008 00000000
  'dir_rewind
  27BDFFE8 AFBF0014 AFB00010 00A08021 A4A00000 8CA50008 24030001 10A30015
  24020001 8C830008 00A3182B 50600012 8FBF0014 54A00008 AE05000C 90830000
  24020003 54620008 AE00000C 8C850010 10A00005 AE05000C 0411FFDD 00000000
  10000003 AE020010 8C820010 AE020010 00001021 8FBF0014 8FB00010 03E00008
  27BD0018
  'create_name
  27BDFFE0 AFBF001C AFB10018 AFB00014 00A08021 8C910004 02202021 24050020
  2406000B 0411FF18 00000000 8E080000 00002021 00001821 24070008 2409002F
  2406002E 240A0008 01031021 90420000 24630001 2C450021 14A00018 306300FF
  50490017 01031821 10460003 0087282B 14A00008 2445FF9F 54EA0011 01031821
  5446000F 01031821 01402021 1000FFEE 2407000B 30A500FF 2CA5001A 10A00003
  02242821 2442FFE0 304200FF A0A20000 24840001 1000FFE4 308400FF 01031821
  AE030000 2C420021 A222000B 00001021 8FBF001C 8FB10018 8FB00014 03E00008
  27BD0020
  'get_clust
  90840000 24020003 14820006 00001821 90A30015 00031A00 90A20014 00621825
  00031C00 90A2001B 00021200 90A4001A 00441025 03E00008 00621025
  'get_fat
  27BDFFE0 AFBF001C 2CA20002 1440001B 24030001 8C820008 00A2102B 10400018
  00601021 000519C2 8C82000C 30A6007F 27A40010 00622821 00063080 24070004
  0411FF31 00000000 1440000C 24030001 93A30013 00031E00 93A20012 00021400
  00621825 93A20010 00621825 93A20011 00021200 00621825 7C63D800 00601021
  8FBF001C 03E00008 27BD0020
  'dir_next
  27BDFFE0 AFBF001C AFB20018 AFB10014 AFB00010 00808821 00A08021 94B20000
  26520001 3252FFFF 12400028 24020003 8CA30010 50600026 8FBF001C 3242000F
  54400021 A6120000 24630001 ACA30010 8CA5000C 14A00007 00121902 94830004
  0243182B 14600017 24020003 10000018 8FBF001C 90820002 2442FFFF 00621024
  54400011 A6120000 0411FFBA 00000000 00402821 2C430002 1460000C 24020001
  8E230008 00A3182B 10600008 24020003 AE05000C 02202021 0411FF39 00000000
  AE020010 A6120000 00001021 8FBF001C 8FB20018 8FB10014 8FB00010 03E00008
  27BD0020
  'dir_find
  27BDFFD8 AFBF0024 AFB30020 AFB2001C AFB10018 AFB00014 00809821 00A08821
  00C09021 0411FF31 00000000 14400021 00408021 96260000 30C6000F 02402021
  8E250010 00063140 24070020 0411FED2 00000000 0002802B 16000017 02001021
  92420000 50400013 24100003 9242000B 30420008 14400008 02602021 02402021
  8E250004 2406000B 0411FE64 00000000 10400008 02602021 02202821 0411FF9F
  00000000 1040FFE3 00408021 10000002 02001021 02001021 8FBF0024 8FB30020
  8FB2001C 8FB10018 8FB00014 03E00008 27BD0028
  'follow_path
  27BDFFE0 AFBF001C AFB20018 AFB10014 AFB00010 00809021 00A08021 AFA7002C
  80E20000 24030020 14430006 00C08821 24E70001 AFA7002C 80E20000 5043FFFD
  24E70001 2403002F 54430004 AE000008 24E70001 AFA7002C AE000008 8FA2002C
  90420000 2C420020 10400008 02002021 02402021 02002821 0411FEE7 00000000
  1000001B A2200000 02002021 27A5002C 0411FF02 00000000 14400015 02402021
  02002821 02203021 0411FFA0 00000000 14400010 8FBF001C 8E030004 9063000B
  5460000D 8FB20018 9222000B 30420010 10400006 02402021 02202821 0411FF28
  00000000 1000FFE8 AE020008 24020003 8FBF001C 8FB20018 8FB10014 8FB00010
  03E00008 27BD0020
  'pf_lseek
  27BDFFD8 AFBF0024 AFB30020 AFB2001C AFB10018 AFB00014 00808021 1080004F
  24020005 90830001 30630001 1060004B 24020004 8C82001C 0045902B 00B2100A
  00409021 8C830018 AC800018 12400043 00001021 90910002 10600012 00118A40
  2463FFFF 2642FFFF 0051001B 022001F4 00001012 0071001B 022001F4 00002012
  0044102B 54400008 8E050020 00111023 00431824 AE030018 02439023 10000003
  8E050024 8E050020 AE050024 0232102B 10400018 00119823 02519023 02002021
  0411FEFC 00000000 00402821 2C420002 54400006 A2000001 8E020008 00A2102B
  54400004 AE050024 A2000001 1000001B 24020001 8E020018 00511021 AE020018
  02531021 00511821 0223182B 5460FFEB 00409021 8E020018 00529021 AE120018
  02002021 0411FE6E 00000000 54400004 92040002 A2000001 10000008 24020001
  2484FFFF 8E030018 00031A42 00831824 00431021 AE020028 00001021 8FBF0024
  8FB30020 8FB2001C 8FB10018 8FB00014 03E00008 27BD0028
  'pf_read
  27BDFFD0 AFBF002C AFB60028 AFB50024 AFB40020 AFB3001C AFB20018 AFB10014
  AFB00010 00808021 00A0A821 00E09821 ACE00000 1080004A 24020005 90830001
  30630001 10600046 24020004 8C92001C 8C820018 02429023 0246102B 00C2900A
  1240003F 00001021 00A0A021 24160200 8E020018 304301FF 5460001F 8E060018
  00021A42 92110002 2631FFFF 00718824 323100FF 1620000E 02002021 54400003
  8E050024 10000003 8E020020 0411FEA3 00000000 2C430002 50600004 AE020024
  A2000001 10000026 24020001 02002021 8E050024 0411FE24 00000000 14400004
  00518821 A2000001 1000001D 24020001 AE110028 8E060018 30C601FF 02C61023
  0052882B 0251100A 00408821 00002021 0295200B 8E050028 00403821 0411FDC9
  00000000 50400004 8E020018 A2000001 1000000B 24020001 00511021 AE020018
  02519023 8E620000 00511021 12400003 AE620000 1000FFC6 0291A021 00001021
  8FBF002C 8FB60028 8FB50024 8FB40020 8FB3001C 8FB20018 8FB10014 8FB00010
  03E00008 27BD0030
  'disk_initialize
  27BDFFD0 AFBF002C AFB30028 AFB20024 AFB10020 AFB0001C 2403003B 3C02BF80
  AC435A30 3C029D00 8C430090 8C42001C 80640030 0040F809 24050006 2410000A
  0411FD20 00000000 2610FFFF 321000FF 1600FFFB 24040040 00002821 0411FD4F
  00000000 24030001 14430061 3C029D00 24040048 240501AA 0411FD48 00000000
  24030001 14430037 240400E9 27B00010 27B10014 0411FD0B 00000000 A2020000
  26100001 1611FFFB 93A30012 24020001 1462004E 00008021 93A30013 240200AA
  1462004B 3C029D00 10000008 24112710 0040F809 24040064 2631FFFF 16200005
  240400E9 1000003F 00008021 3C109D00 240400E9 3C054000 0411FD28 00000000
  5440FFF3 8E020004 12200038 00008021 2404007A 00002821 0411FD20 00000000
  14400033 3C029D00 24110004 0411FCE5 00000000 27A40010 00901821 26100001
  1611FFFA A0620000 93B00010 32100040 2402000C 24030004 0070100A 10000023
  00408021 00002821 0411FD0C 00000000 2C420002 24030002 24100001 0062800B
  240300E9 24130041 0062980B 24112710 10000006 3C129D00 0040F809 24040064
  2631FFFF 52200011 00008021 02602021 00002821 0411FCF9 00000000 5440FFF6
  8E420004 52200009 00008021 24040050 24050200 0411FCF1 00000000 10000003
  0002800B 10000002 3C029D00 3C029D00 8C43008C AC7000FC 8C430090 8C42001C
  80640030 0040F809 24050006 0411FCAD 00000000 12000005 3C029D00 8C420090
  8043003C 3C02BF80 AC435A30 2E020001 8FBF002C 8FB30028 8FB20024 8FB10020
  8FB0001C 03E00008 27BD0030
  'disk_writep
  27BDFFE0 AFBF001C AFB20018 AFB10014 AFB00010 10800014 00808021 30A5FFFF
  10A00052 00009021 97828010 1040004F 00858821 92040000 26100001 0411FC99
  00000000 97828010 2442FFFF 3042FFFF 12110045 A7828010 5440FFF7 92040000
  10000042 00009021 10A00016 97908010 3C029D00 8C42008C 8C4300FC 30630008
  00051240 24040058 0043280A 0411FCB0 00000000 14400035 24120001 240400FF
  0411FC80 00000000 240400FE 0411FC7D 00000000 24020200 A7828010 1000002B
  00009021 26100002 12000008 2610FFFF 2411FFFF 00002021 0411FC72 00000000
  2610FFFF 1611FFFC 00002021 0411FC62 00000000 3042001F 24030005 14430010
  24120001 10000005 241207D0 0040F809 240403E8 10000003 2652FFFF 241100FF
  3C109D00 0411FC54 00000000 50510004 2E520001 5640FFF5 8E020004 24120001
  3C029D00 8C430090 8C42001C 80640030 0040F809 24050006 0411FC47 00000000
  10000003 02401021 00009021 02401021 8FBF001C 8FB20018 8FB10014 8FB00010
  03E00008 27BD0020
  'pf_write
  27BDFFD0 AFBF002C AFB60028 AFB50024 AFB40020 AFB3001C AFB20018 AFB10014
  AFB00010 00808021 00C09021 00E09821 ACE00000 1080007B 24020005 90830001
  30640001 10800077 24020004 14C00010 30630040 5060000A 92020001 00002021
  00002821 0411FF84 00000000 50400004 92020001 A2000001 1000006A 24020001
  304200BF A2020001 10000066 00001021 54600006 8E03001C 8E030018 2402FE00
  00621024 AE020018 8E03001C 8E020018 00621023 0052182B 14600005 00000000
  00A0A021 24150200 10000005 2416FFBF 1440FFFB 00409021 10000053 8FBF002C
  8E020018 304301FF 54600029 8E110018 00021A42 92110002 2631FFFF 00718824
  323100FF 1620000E 02002021 54400003 8E050024 10000003 8E020020 0411FD30
  00000000 2C430002 50600004 AE020024 A2000001 1000003B 24020001 02002021
  8E050024 0411FCB1 00000000 14400004 00512821 A2000001 10000032 24020001
  AE050028 00002021 0411FF43 00000000 50400004 92020001 A2000001 10000029
  24020001 34420040 A2020001 8E110018 323101FF 02B18823 0232102B 0242880A
  02802021 02202821 0411FF33 00000000 50400004 8E020018 A2000001 10000019
  24020001 00511021 AE020018 8E620000 00511021 AE620000 8E020018 304201FF
  5440000D 02519023 00002021 00002821 0411FF21 00000000 50400004 92020001
  A2000001 10000007 24020001 00561024 A2020001 02519023 1640FFB1 0291A021
  00001021 8FBF002C 8FB60028 8FB50024 8FB40020 8FB3001C 8FB20018 8FB10014
  8FB00010 03E00008 27BD0030
  'check_fs
  27BDFFE0 AFBF001C AFB10018 AFB00014 00808021 00A08821 240601FE 24070002
  0411FC1E 00000000 14400028 24030003 92040001 00042200 92020000 00822025
  7C042620 2402AA55 14820020 24030002 02002021 02202821 24060036 24070002
  0411FC0E 00000000 1440000A 02002021 92040001 00042200 92020000 00822025
  7C042620 24024146 10820010 00001821 02002021 02202821 24060052 24070002
  0411FBFE 00000000 14400008 24030001 92030001 00031A00 92020000 00621825
  7C031E20 38634146 0003182B 00601021 8FBF001C 8FB10018 8FB00014 03E00008
  27BD0020
  'pf_mount
  27BDFFB8 AFBF0044 AFB10040 AFB0003C 00808021 0411FE39 00000000 30420001
  14400087 24030002 27A40010 00002821 0411FFBA 00000000 24030001 1443001A
  00008821 27A40010 00002821 240601BE 24070010 0411FBD8 00000000 14400078
  24030001 93A20014 10400075 24030006 93B1001B 00118E00 93A2001A 00021400
  02228825 93A20018 02228825 93A20019 00021200 02228825 27A40010 02202821
  0411FF9E 00000000 24040003 10440064 24030001 14400062 24030006 27A40010
  02202821 2406000D 24070024 0411FBBA 00000000 1440005A 24030001 93A2001A
  00021200 93A30019 00431025 1440000C 93A30013 93A3002A 00031E00 93A20029
  00021400 00621025 93A30027 00431025 93A30028 00031A00 00431025 93A30013
  70431002 93A60012 00063200 93A30011 00C33025 02268821 AE11000C 93A50010
  A2050002 93A40015 00042200 93A30014 00832025 A6040004 93A30017 00031A00
  93A70016 00671825 1460000B 00042102 93A70026 00073E00 93A30025 00031C00
  00E31825 93A70023 00671825 93A70024 00073A00 00671825 00661823 00621823
  00641823 0065001B 00A001F4 00003012 24C50002 AE050008 24C6F00A 3407EFFF
  00C7302B 2CA70FF7 24030002 0066380B 3403FFF7 00A3282B 10A0001F 24030003
  10E00017 24030006 24030003 14E3000D A2070000 93A50032 00052E00 93A30031
  00031C00 00A32825 93A3002F 00A32825 93A30030 00031A00 00A31825 10000003
  AE030010 00511821 AE030010 02248821 02221021 AE020014 A2000001 00001821
  00601021 8FBF0044 8FB10040 8FB0003C 03E00008 27BD0048 1000FFE6 A2030000
  'pf_open
  27BDFFA0 AFBF005C AFB10058 AFB00054 00808821 00A03821 10800025 24100005
  A0800001 27A20024 AFA20014 27A50010 27A60030 0411FC97 00000000 1440001C
  00408021 93A20030 10400018 93A2003B 30420010 54400016 24100003 02202021
  27A50030 0411FBEB 00000000 AE220020 93A3004F 00031E00 93A2004E 00021400
  00621025 93A3004C 00431025 93A3004D 00031A00 00431025 AE22001C AE200018
  24020001 10000002 A2220001 24100003 02001021 8FBF005C 8FB10058 8FB00054
  03E00008 27BD0060
  'pf_opendir
  27BDFFB0 AFBF004C AFB10048 AFB00044 00808021 00A08821 00C03821 10800018
  24020005 27A20010 ACA20004 27A6001C 0411FC66 00000000 14400012 8FBF004C
  93A2001C 1040000B 02002021 93A30027 30630010 1060000A 24020003 02002021
  27A5001C 0411FBB9 00000000 AE220008 02002021 02202821 0411FB5A 00000000
  8FBF004C 8FB10048 8FB00044 03E00008 27BD0050
  'get_fileinfo
  8C830010 10600036 24C20009 90A30000 24040020 1064000E 00A02021 244A0008
  24090005 240800E5 10000003 240B0020 106B0007 24840001 00693826 0107180A
  A0430000 24420001 544AFFF9 90830001 90A40008 24030020 1083000A 2403002E
  A0430000 90A30008 24040020 1464001E 24420001 10000004 90A3000B A0430000
  24420001 90A3000B A0C30008 90A4001F 00042600 90A3001E 00031C00 00831825
  90A4001C 00641825 90A4001D 00042200 00641825 ACC30000 90A30019 00031A00
  90A40018 00641825 A4C30004 90A30017 00031A00 90A40016 00641825 A4C30006
  03E00008 A0400000 A0430000 90A30009 24040020 1064FFE3 24420001 A0430000
  90A3000A 1464FFDD 24420001 1000FFDE 90A3000B
  'dir_read
  27BDFFD8 AFBF0024 AFB40020 AFB3001C AFB20018 AFB10014 AFB00010 00809821
  00A08021 00C08821 24020003 241200E5 10000019 2414002E 30C6000F 02202021
  00063140 24070020 0411FAA7 00000000 0002102B 54400016 AE000010 92230000
  50600012 24020003 10720005 9224000B 10740003 30840008 1080000E 8FBF0024
  02602021 02002821 0411FB78 00000000 54400007 AE000010 8E050010 54A0FFE6
  96060000 10400003 8FBF0024 AE000010 8FBF0024 8FB40020 8FB3001C 8FB20018
  8FB10014 8FB00010 03E00008 27BD0028
  'pf_readdir
  27BDFFB0 AFBF004C AFB20048 AFB10044 AFB00040 00808821 00A08021 00C09021
  1080001B 24020005 27A20010 14C00005 ACA20004 0411FACD 00000000 10000015
  8FBF004C 27A6001C 0411FFB9 00000000 24030003 10430004 02002021 1440000D
  8FBF004C 02002021 27A5001C 02403021 0411FF6A 00000000 02202021 02002821
  0411FB46 00000000 38430003 0003100A 8FBF004C 8FB20048 8FB10044 8FB00040
  03E00008 27BD0050
  'getFPC
  27BDFFF8 AFBF0004 00852023 03E42021 ACC40000 8FBF0004 03E00008 27BD0008
  'errstring
  27BDFFE0 AFBF001C AFB00018 00808021 00002021 3C059D00 24A518D0 27A60010
  0411FFEF 00000000 8FA20010 1200003C 24030001 16030006 24030002 8FA30010
  3C049D00 24842468 10000012 00832021 56030006 3C049D00 8FA30010 3C049D00
  24842478 10000013 00832021 24842458 00822021 24020003 16020007 24020004
  8FA30010 3C049D00 24842484 10000011 00832021 24020004 16020007 24020005
  8FA30010 3C049D00 24842490 10000011 00832021 24020005 16020007 24020006
  8FA30010 3C049D00 248424A0 10000010 00832021 24020006 16020007 24020007
  8FA30010 3C049D00 248424B0 10000008 00832021 24020007 16020006 3C029D00
  8FA30010 3C049D00 248424C4 00832021 3C029D00 8C4200BC 0040F809 00000000
  8FBF001C 8FB00018 03E00008 27BD0020
  'main
  27BDFFA8 AFBF0054 AFBE0050 AFB7004C AFB60048 AFB50044 AFB40040 AFB3003C
  AFB20038 AFB10034 AFB00030 00808021 00A08821 00C0A821 00E09821 3C02BF80
  34038260 AC435A00 24030C00 AC435A40 3C039D00 8C640090 8084003C AC445A30
  8C72008C 26540050 8E060000 24020001 10C20006 26570078 24020006 10C20003
  24020007 14C20006 24020004 82250000 04A10007 00001021 1000000F 03A52821
  14C2001A 24020007 1000FFF9 82250000 27A40010 00821821 02222021 90840000
  A0640000 24420001 00A2182A 1060FFF9 27A40010 03A52821 24020006 14C20005
  A0A00011 3C029D00 8C4200C4 0040F809 00000000 8E060000 24020001 10C20007
  24020006 10C20005 24020007 10C20003 24020004 54C200A6 8E030000 3C029D00
  8C430090 80640030 8C430088 00041080 00431021 8C430000 24020065 10620003
  24040007 0411FF62 00000000 3C02BF81 8C43F220 7C63D800 3C020580 3442B053
  00621026 24030030 24040014 0082180B 00601021 3C039D00 8C630088 00431021
  8C430000 24020065 10620054 3C029D00 8C420010 3C03BF81 8C65F220 7CA5D800
  3C030580 3463B053 00A32826 2403000C 24040005 0065200A 24050008 0040F809
  00003021 3C029D00 8C420010 3C03BF81 8C65F220 7CA5D800 3C030580 3463B053
  00A32826 2403000C 24040005 0065200A 24050064 0040F809 00003021 3C029D00
  8C420010 3C03BF81 8C65F220 7CA5D800 3C030580 3463B053 00A32826 2403000B
  2404002F 0065200A 24050002 0040F809 00003021 3C029D00 8C420010 3C03BF81
  8C65F220 7CA5D800 3C030580 3463B053 00A32826 2403000B 2404002F 0065200A
  24050064 0040F809 00003021 3C029D00 8C420010 3C03BF81 8C65F220 7CA5D800
  3C030580 3463B053 00A32826 2403000A 24040004 0065200A 24050008 0040F809
  00003021 3C029D00 8C420010 3C03BF81 8C65F220 7CA5D800 3C030580 3463B053
  00A32826 2403000A 24040004 0065200A 24050064 0040F809 00003021 3C02BF81
  8C43F220 7C63D800 3C020580 3442B053 1462000C 3C02BF81 8C43FA90 24040001
  7C831804 AC43FA90 3C02BF81 8C43FCA0 24040006 7C831804 AC43FCA0 1000000B
  3C02BF80 8C43FA90 24040007 7C831804 AC43FA90 3C02BF81 8C43FC9C 24040006
  7C831804 AC43FC9C 3C02BF80 34038260 AC435A00 24030C00 AC435A40 3C029D00
  8C42008C AC4000F8 02802021 0411FD3E 00000000 00402021 0411FED5 00000000
  8E030000 24020001 1462000A 24020002 02802021 27A50011 0411FDCB 00000000
  00402021 0411FECA 00000000 8E030000 24020002 54620022 8E030000 8EA50000
  04A00006 02802021 0411FAA6 00000000 00402021 0411FEBE 00000000 8E660000
  28C20100 1040000B 02802021 26250001 27A70020 0411FAF9 00000000 00402021
  0411FEB3 00000000 8FA20020 10000008 A2220000 02202821 27A70020 0411FAEF
  00000000 00402021 0411FEA9 00000000 8FA30020 8FA20068 AC430000 8E030000
  24020003 5462007B 8E030000 8EA20000 04410005 3C029D00 8C42008C 8C4200F8
  AEA20000 3C029D00 8C42008C 8C4400F8 8E630000 00831821 AC4300F8 8EB60000
  241EFE00 02DEF024 02802021 03C02821 0411FA74 00000000 00402021 0411FE8C
  00000000 8E660000 28C20100 02221021 AFA2002C 8EA20000 105E004C 32D601FF
  AFB60028 3C029D00 8C420040 0040F809 24040200 0040B021 02802021 00402821
  24060200 27A70020 0411FABC 00000000 00402021 0411FE76 00000000 02802021
  03C02821 0411FA57 00000000 00402021 0411FE6F 00000000 8E650000 8FA20028
  00452821 2CA20201 14400003 0000F021 24BEFE00 24050200 8FA30028 0065102A
  10400009 8FA3002C 8FA40028 02C41021 02C52821 90640000 A0440000 24420001
  1445FFFC 24630001 02802021 02C02821 8FA60020 27A70020 0411FBEF 00000000
  00402021 0411FE52 00000000 13C0000D 02802021 8E650000 00BE2823 8FA2002C
  00452821 03C03021 27A70020 0411FBE2 00000000 00402021 0411FE45 00000000
  02802021 00002821 00003021 27A70020 0411FBD9 00000000 00402021 0411FE3C
  00000000 10000013 8E030000 02802021 8FA5002C 27A70020 0411FBCF 00000000
  00402021 0411FE32 00000000 02802021 00002821 00003021 27A70020 0411FBC6
  00000000 00402021 0411FE29 00000000 8E030000 24020004 5462000A 8E030000
  02802021 02E02821 27A60011 0411FD50 00000000 00402021 0411FE1D 00000000
  8E030000 24020005 5462003C 8E030000 265200A0 02802021 02E02821 02403021
  0411FDE1 00000000 00402021 0411FE10 00000000 92430008 24020016 5462000A
  82420009 02802021 02E02821 02403021 0411FDD5 00000000 00402021 0411FE04
  00000000 82420009 50400023 A2200000 92420008 30420010 54400006 2402003C
  24130001 02331821 00001021 1000000C 2405000C A2220001 24020044 A2220002
  24020069 A2220003 24020072 A2220004 2402003E A2220005 1000FFF2 24130006
  02422021 90840009 A0640000 24420001 1445FFFB 24630001 2402000C AFA20020
  26440009 0411F7E4 00000000 2673FFFF 02629821 A2330000 8E030000 24020006
  5462003E 8E030000 3C029D00 8C420040 0040F809 3404C800 0040B821 02802021
  27A50011 0411FCD0 00000000 00402021 0411FDCF 00000000 02802021 00002821
  0411F9B0 00000000 00402021 0411FDC8 00000000 02E09021 0000B021 24130001
  02802021 02402821 24060080 27A70020 0411FA02 00000000 00402021 0411FDBC
  00000000 8FA30020 1860000E 00001021 02421821 80630000 54600006 24420001
  52600004 24420001 AFA20020 00009821 24420001 8FA30020 0043202A 5480FFF5
  02421821 24020080 14620003 02C3B021 1000FFE3 26520080 02F6B021 A2C00000
  A2C00001 3C029D00 8C4200B8 02E02021 0040F809 00002821 8E030000 24020007
  5462004D 8E020000 02802021 27A50011 0411FC95 00000000 00402021 0411FD94
  00000000 02802021 00002821 0411F975 00000000 00402021 0411FD8D 00000000
  3C129D00 8E420040 0040F809 24040100 00409821 8E5600C0 24120001 3C179D00
  1000001D 241E000D 1452FFFF 02602021 8EE200C8 0040F809 02C02821 0040B021
  02602021 0411F77C 00000000 02621821 A07E0000 2404000A A0640001 02802021
  02602821 24460002 27A70020 0411FB0A 00000000 00402021 0411FD6D 00000000
  82C20000 14400005 00000000 82C20001 50400005 A2600000 82C20000 1440FFE2
  00000000 A2600000 A2600001 02802021 02602821 24060002 27A70020 0411FAF6
  00000000 00402021 0411FD59 00000000 02802021 00002821 00003021 27A70020
  0411FAED 00000000 00402021 0411FD50 00000000 8E020000 1440002D 3C029D00
  8C420090 92230000 12A00006 A0430030 3C029D00 8C420090 8EA30000 10000005
  A043003C 3C029D00 8C420090 24030002 A043003C 3C029D00 8C430090 80640030
  8C420088 00041880 00621021 8C430000 24020065 1062000B 3C109D00 8E020010
  24050008 0040F809 00003021 8E030090 8E020010 80640030 24050065 0040F809
  00003021 3C109D00 8E030090 8E02001C 80640030 0040F809 2405FFFD 8E030090
  8E02001C 80640030 0040F809 24050006 8FBF0054 8FBE0050 8FB7004C 8FB60048
  8FB50044 8FB40040 8FB3003C 8FB20038 8FB10034 8FB00030 03E00008 27BD0058
  '.rodata
  'err0
  6E6B6E55 206E776F 6F727265 000A0D72
  'err1
  6B736944 72724520 0A0D726F 00000000
  'err2
  20746F4E 64616552 000A0D79
  'err3
  46206F4E 0D656C69 0000000A 20746F4E 6E65704F 0A0D6465 00000000 20746F4E
  62616E45 0D64656C 0000000A 46206F4E 20656C69 74737953 0A0D6D65 00000000
  20746F4E 6E756F6D 0D646574 0000000A
End CSub
  
CSub HUMID integer, float, float
  0000002B 27BDFFF8 AFBF0004 00852023 03E42021 ACC40000 8FBF0004 03E00008
  27BD0008 27BDFFE0 AFBF001C 00002021 3C059D00 24A50040 27A60010 0411FFF1
  00000000 8FA30010 3C029D00 8C4200BC 3C049D00 24840414 0040F809 00832021
  8FBF001C 03E00008 27BD0020 00041080 000419C0 00621823 00642021 000418C0
  3C029D00 8C420000 3C047735 34849400 8C420000 0082001B 004001F4 00002012
  0064001B 008001F4 03E00008 00001012
  27BDFFB8 AFBF0044 AFBE0040 AFB7003C AFB60038 AFB50034 AFB40030 AFB3002C
  AFB20028 AFB10024 AFB00020 00808821 00A0A821 3C029D00 8C420000 8C430000
  3C020098 34429680 0062102B 10400003 00C0B021 0411FFC7 00000000 3C109D00
  8E02001C 8E240000 0040F809 24050006 8E020010 8E240000 24050009 0040F809
  00003021 8E02001C 8E240000 0040F809 2405000E 8E02001C 8E240000 0040F809
  24050005 8E020004 0040F809 240403E8 8E02001C 8E240000 0040F809 24050006
  8E020080 240403E8 0040F809 00002821 AEC20000 AEA20000 0411FFB8 24040190
  00409821 0000A021 40944800 00008021 10000005 3C129D00 40104800 0270102B
  1440008E 8FBF0044 8E420020 0040F809 8E240000 1440FFF8 00000000 10000007
  3C129D00 40104800 0270102B 50400004 8E420020 10000081 8FBF0044 8E420020
  0040F809 8E240000 1040FFF6 00000000 10000007 3C129D00 40104800 0270102B
  50400004 8E420020 10000074 8FBF0044 8E420020 0040F809 8E240000 1440FFF6
  00001021 00001821 AFA20010 AFA30014 0000B821 10000005 3C129D00 40104800
  0270102B 14400065 8FBF0044 8E420020 0040F809 8E240000 1040FFF8 00000000
  40944800 10000006 8E420020 40104800 0270102B 14400059 8FBF0044 8E420020
  0040F809 8E240000 1440FFF8 8FA30010 000317C2 8FA50014 0005F040 005EF025
  00031040 AFA20018 0411FF6C 24040032 0050102B 8FA30018 00431025 AFA20010
  26F70001 24050028 16E5FFE0 AFBE0014 001E1600 8FA50010 00052202 00442025
  001E1200 00058E02 00518825 7CA33C00 308200FF 00621821 322200FF 00621821
  93A50014 30A200FF 00621021 8FA30010 00431026 304200FF 1440002F 001EA603
  3C109D00 8E130064 8E020080 30847FFF 0040F809 00002821 00409021 8E020080
  2404000A 0040F809 00002821 02402021 0260F809 00402821 00408021 AEA20000
  3C020080 8FA50010 00451024 5040000C 3C109D00 3C029D00 8C520058 8C420080
  2404FFFF 0040F809 2405FFFF 02002021 0240F809 00402821 AEA20000 3C109D00
  8E120064 8E020080 02202021 0040F809 02802821 00408821 8E020080 2404000A
  0040F809 00002821 02202021 0240F809 00402821 AEC20000 8FBF0044 8FBE0040
  8FB7003C 8FB60038 8FB50034 8FB40030 8FB3002C 8FB20028 8FB10024 8FB00020
  03E00008 27BD0048 20555043 65657073 6F742064 6F6C206F 000A0D77
End CSub
  '*******  *******************Subs/CFUNCTIONS END*********************************************
