  CONST EERAMcr=&h18' address of 47x04/47x16 control register with A0=0 and A1=0
  CONST SRAMcb=&h50' address of 47x04/47x16 data register forSRAM with A0=0 and A1=0
  CONST COMMANDreg=&h55 ' address of 47x04/47x16 command register
  CONST STATUSreg=&h00  ' address of 47x04/47x16 status register
  CONST S_store=&h33    ' these are the two command register commands
  CONST S_recall=&hdd
  CONST SRAMsize = 512 ' size of 47x04, use 512 for 47x04
  r = setup() ' we only have to do this once for each chip
  r = writeDATA(10,"00000")  'Write "00000" to the Sram
  z$ = readDATA$(10,5) ' 5 bytes starting at address 10 (any address will do)
  print "Sram Check "+z$  'Check Sram says "00000"





  

  '****************Sram Functions******************
FUNCTION setup()
  x = readstatus() ' get the current status register
  x = x OR &b10 ' set bit 2 leaving the rest alone
  PRINT BIN$(x,8)
  r = writeCMD(STATUSreg,x) ' set autostore
  r =  readstatus()
  PRINT BIN$(r,8)
END FUNCTION
  
FUNCTION writeDATA(addr,D$)
  ' write string D$ to EERAM starting at addr
  LOCAL L
  addr = addr MOD SRAMsize ' keep address within chip capacity
  d$ = CHR$(addr\256)+CHR$(addr MOD 256)+D$
  L = LEN(D$)
  ON ERROR SKIP 1
  I2C WRITE SRAMcb,0,L,D$
END FUNCTION
  
FUNCTION readDATA$(addr,L)
  ' read string from EERAM starting at addr, L bytes
  LOCAL D$
  addr = addr MOD SRAMsize ' keep address within chip capacity
  ON ERROR SKIP 1
  I2C WRITE SRAMcb,1,2,addr\256,addr MOD 256 'Reset memory pointer to addr
  I2C READ SRAMcb,0,L,D$
  readDATA$ = D$
END FUNCTION
  
FUNCTION writeCMD(reg,EERAMcmd)
  'write command to the command or status register
  ON ERROR SKIP 1
  I2C WRITE EERAMcr,0,2,reg,EERAMcmd
END FUNCTION
  
FUNCTION readSTATUS()
  'read status register
  LOCAL status
  ON ERROR SKIP 1
  'I2C WRITE EERAMcr,1,2,STATUSreg,0
  I2C READ EERAMcr,0,1,status
  readSTATUS = status
END FUNCTION

