'Analogue clock module driver for Pi Zero W which will always have the correct time and can if needed show temp and day/date and battery voltage on an E-Ink display 
'Clock works by stripping time into seconds and advances the motor by 1 movement per second 
'Sram stores the position of the hands and if power is ever lost hands will automatically go to the correct time once power is restored
'Sram has capacitor with enough capaciity to write value to internal Eeprom once power is lost
  Option explicit
  I2C OPEN 400,1000 'used later after the E-Ink display is set uprun
  CONST EERAMcr=&h18' address of 47x04/47x16 control register with A0=0 and A1=0
  CONST SRAMcb=&h50' address of 47x04/47x16 data register forSRAM with A0=0 and A1=0
  CONST COMMANDreg=&h55 ' address of 47x04/47x16 command register
  CONST STATUSreg=&h00  ' address of 47x04/47x16 status register
  CONST S_store=&h33    ' these are the two command register commands
  CONST S_recall=&hdd
  CONST SRAMsize = 512 ' size of 47x04, use 512 for 47x04
  DIM hours, mins,seconds,secs,secs2,secs3,g,h,c,b,a,l,r,w,x,z$,t$,d$,temp
  SETPIN 12,INTL,reset1,PULLUP  ' Reset button
  SetPin 7, dout          'Motor pulse 1
  SetPin 8, dout          'Motor pulse 2
  setpin 13, DOUT            'Hearthbeat LED
  PIN(13) = 1 'Led off
  z$ = readDATA$(10,5) 'read 5 bytes starting at address 10 - where the hands were on Power Loss
  print z$
  secs2 = VAL(z$,"0") 'Position of hands on Power Up
  PIN(7) = 1
  PIN(8) = 0
   do
    secs3 = Val(Right$(Time$,2))
    secs=(Val(Left$(Time$,2)) Mod 12) * 3600 + Val(Mid$(Time$,4,2)) * 60 + Val(Right$(Time$,2)) ' total clock's seconds past midnight
    if secs > secs2 then 'New second hand need moving
      motor1
    end if
    
    if secs2 = 7199 and secs = 3600 then 'time has gone back 1 hour
      MOTORBACK
    end if
    
    if secs3 = 31 or secs3 = 01 then  ' Print Temperature (When E-Ink is connected this can be displayed)
      PRINT STR$(tempr(40))"`C", "Temperature" 'display the temperature every 30 seconds
    end if
    
    if secs = 0 then  'time is 00:00 we need to reset the secs2 counter to zero and pause 1 second
      motor1
      secs2 = 0
      r = writeDATA(10,"00000") 'Update Sram
      pause 1000
    end if
    
    if secs = 43200 then  'time is 12:00 we need to reset the secs2 counter to zero and pause 1 second
      motor1
      secs2 = 0
      r = writeDATA(10,str$(secs2)) 'Update Sram
      pause 1000
    end if
  loop
end
  
SUB motor1   'pulse clock motor once every second -
  PIN(7) = NOT PIN(7)   'change the state of pin(7)
  PIN(8) = NOT PIN(7)   'set PIN(8) to opposite of pin(7)
  PIN(13) = 0  'led on
  pause 50  'so the motor will actually move - too short a delay and it will miss steps
  PIN(13) = 1  'led off
  secs2 = secs2 +1 'advance value stored in Sram to = number of seconds +1
  r = writeDATA(10,str$(secs2,5,0,"0")) 'Update Sram
  print time$ 'Test to make sure it's working - delete when not needed
  print secs2 " secs2"
END SUB
  
  
SUB motorback   ' move clock back one hour becuuse of daylight change time
  for g = 7199 to 43200  'number of steps to get hands back to 12:00:00
    print secs, "Time has gone back an hour - catching up with the correct time" 'so we know the number of steps to clock hands have to move
    r = writeDATA(10,str$(secs2,5,0,"0")) 'Update Sram
    PIN(7) = NOT PIN(7)   'change the state of pin(7)
    PIN(8) = NOT PIN(7)   'set PIN(8) to opposite of pin(7)
    PIN(13) = 0  'led on
    pause 50  'so the motor will actually move - too short a delay and it will miss steps
    PIN(13) = 1 'Led off
    secs2 = secs2 +1
    print b, "secs2 - steps to align hands"
  next g
  secs2 = 0 'hands will now advance from 12:00:00 to the current time
END SUB
  
sub reset1
  IF PIN(12) = 0 THEN ' button down
    secs2 = 0
    t$=time$
    r = writeDATA(10,str$(secs2,5,0,"0")) 'Update Sram
    System "sudo reboot"
  end if
  
  '****************Sram Functions******************
FUNCTION setup()
  x = readstatus() ' get the current status register
  x = x OR &b10 ' set bit 2 leaving the rest alone
  PRINT BIN$(x,8)
  r = writeCMD(STATUSreg,x) ' set autostore
  r =  readstatus()
  PRINT BIN$(r,8)
END FUNCTION
  
FUNCTION writeDATA(addr,D$)
  ' write string D$ to EERAM starting at addr
  LOCAL L
  addr = addr MOD SRAMsize ' keep address within chip capacity
  d$ = CHR$(addr\256)+CHR$(addr MOD 256)+D$
  L = LEN(D$)
  ON ERROR SKIP 1
  I2C WRITE SRAMcb,0,L,D$
END FUNCTION
  
FUNCTION readDATA$(addr,L)
  ' read string from EERAM starting at addr, L bytes
  LOCAL D$
  addr = addr MOD SRAMsize ' keep address within chip capacity
  ON ERROR SKIP 1
  I2C WRITE SRAMcb,1,2,addr\256,addr MOD 256 'Reset memory pointer to addr
  I2C READ SRAMcb,0,L,D$
  readDATA$ = D$
END FUNCTION
  
FUNCTION writeCMD(reg,EERAMcmd)
  'write command to the command or status register
  ON ERROR SKIP 1
  I2C WRITE EERAMcr,0,2,reg,EERAMcmd
END FUNCTION
  
FUNCTION readSTATUS()
  'read status register
  LOCAL status
  ON ERROR SKIP 1
  'I2C WRITE EERAMcr,1,2,STATUSreg,0
  I2C READ EERAMcr,0,1,status
  readSTATUS = status
END FUNCTION
