' SDTest matherp
'option explicit 
option default none 
' Constants defining SD card calls 
const fileopen=1 
const readfile=2 
const writefile=3 
const opendir=4 
const readdir=5 
' 
'CONST CTRL_Z = 26 'Used in example as EOF marker 
'const CS_PIN=4 'Chip select pin conected to the SD card 
dim integer i,filepos,num 
dim s$ 
PRINT "matherp's sd test"
prepnumbers() 
' 
' Mount the disk 

' open directory 
SDcard opendir,""

'read the directory 
do 
  SDcard readdir,s$ 

  if s$<>"" then print s$ 
loop while s$<>""

' Open a file to use for write 
SDCard fileopen,"empty.txt"

' Write out a title line 
s$="Title: 73 times table "+chr$(13) 
SDcard writefile,s$,0,len(s$)

' maintain the file pointer - this must be done in the Basic program 
filepos=len(s$) 
num=0 

' write out 500 lines of output updating the file pointer as we go 
for i=1 to 500 
    s$=int2text$(num)+chr$(13) 
    num=num+73 
    SDcard writefile,s$,filepos,len(s$)
    filepos=filepos+len(s$) 
next i 

' write something we can recognise as the end of file 
s$=chr$(CTRL_Z) 'end of file marker CTRL-Z 
SDcard writefile,s$,filepos,len(s$)

' 
' Now lets read back the file to check it 

' Read in the first 240 characters positioning the filemarker to the beginning of the file 
SDcard readfile,s$,0,240,filepos
print s$; 
' loop through the file 
do 'NB we call readfile with  
  SDcard readfile,s$,-1,240,filepos
  if instr(s$,CHR$(CTRL_Z)) THEN 
    s$=left$(s$,instr(s$,CHR$(CTRL_Z))-1) 
    filepos=0 
  endif 
  print s$; 
loop while filepos<>0 'loop until the end of the physical file or our end-of-file marker 
print "" 
end 
FUNCTION int2Text$(number AS integer) 
    local num AS integer, outP AS STRING length 60, unit AS INTEGER 
    local tmpLng1 AS integer 
  
    IF 0 = number THEN 
        int2Text$ = "zero" 
        EXIT FUNCTION 
    END IF 
  
    num = ABS(number) 
  
    DO 
        tmpLng1 = num MOD 100 
        SELECT CASE tmpLng1 
            CASE 1 TO 19 
                outP = small(tmpLng1) + " " + outP 
            CASE 20 TO 99 
                SELECT CASE tmpLng1 MOD 10 
                    CASE 0 
                        outP = tens((tmpLng1 \ 10) - 2) + " " + outP 
                    CASE ELSE 
                        outP = tens((tmpLng1 \ 10) - 2) + "-" + small(tmpLng1 MOD 10) + " " + outP 
                END SELECT 
        END SELECT 
  
        tmpLng1 = (num MOD 1000) \ 100 
        IF tmpLng1 THEN 
            outP = small(tmpLng1) + " hundred " + outP 
        END IF 
  
        num = num \ 1000 
        IF num < 1 THEN EXIT DO 
  
        tmpLng1 = num MOD 1000 
        IF tmpLng1 THEN outP = big(unit) + " " + outP 
  
        unit = unit + 1 
    LOOP 
  
    IF number < 0 THEN outP = "negative " + outP 
    Do WHILE ASC(RIGHT$(outp,1))<=32 
       outp = LEFT$(outp,len(outp)-1)  
    loop 
    int2Text$ = outP 
END FUNCTION 
' 
sub prepnumbers 
'small 
  DATA "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten" 
  DATA "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen"
'tens 
  DATA "twenty", "thirty", "forty", "fifty", "sixty", "seventy", "eighty", "ninety" 
'big 
  DATA "thousand", "million", "billion" 
  dim small(19) AS STRING length 10, tens(7) AS STRING length 10, big(2) AS STRING length 10 
  FOR i = 1 TO 19 
    READ small(i) 
  NEXT 
  FOR i = 0 TO 7 
    READ tens(i) 
  NEXT 
  FOR i = 0 TO 2 
    READ big(i) 
  NEXT 
end sub 
'
