' definitions & initializations
  OPTION BASE 1 : OPTION DEFAULT FLOAT : OPTION EXPLICIT ' see MMBasic Manual
'  option baudrate 115200
  option autorun on
  CONST TRUE=1,FALSE=0,cON=TRUE
  const RTC_OK=TRUE 
  const SIMULATE=TRUE, NEXTIONDISPLAY=FALSE, HTMLDISPLAY=TRUE ' set run directions
  const debugNX=NEXTIONDISPLAY ' or FALSE to turn off debugging prints in Nextion routines
  CONST maxVars=83  ' max # html simulation output variables
  const hVarmax=26  ' max # html simulation update (input) variables
  const MaxLen=1024 ' max html input buffer length
  CONST longStringMaxLen=4096 ' maximum size of long string (e.g., html template text)
  const starttext$="HTTP" ' search html input for this to find end of command string
  const pnf$="<html><body>Page not Found</body></html>" ' page not found html code
  const cBackGroundON="#7fff00" ' chartreuse" ' html background color--relay off #7fff00
  const cBackGroundOFF="#ff0000" ' red"       ' html background color--relay on #ff0000
  CONST cOFF=0,cAUTO=1,cMANUAL=2   ' iOpMode values
  ' the following are indexes into sVarVals, data for the html & display pages
  const MODE_OFF=5,MODE_AUTO=6,MODE_MANUAL=7
  const CIRCULATOR=10,FAN_OUT=11,LOUVER_VENT=12,FAN_IN=13,MISTER=14,HEATER=15
  const OUTTEMP=30,INTEMP=31,OUTHUMI=32,INHUMI=33,CIRCSUPPLY=34,CIRCRETURN=35
  ' the following are pin numbers for relays
' LEDs: CIRC=Red,HEAT=Amber,FANIN=Green,FANOUT=Blue,MIST=White,LOUVER=Yellow
  CONST pCIRCULATOR=26, pLouver_Vent=25, pMister=24, pFan_Out=23, pFan_In=16, pHeater=15
  const nRelayPins=6
  const dspin=2 ' inside temperature
  CONST qt=chr$(34) ' double quote
  CONST cFF=chr$(255) ' 3 together used for send-to-nextion string indicator
  CONST cNotChecked="......."
  
initial:
  initialize
  
main:
  do
    watchdog 60000 ' lb if not executed in 60 seconds, restart
    if sMinuteDigit <> mid$(time$,5,1) then newMinute
    if SIMULATE then ProcessHTML    ' if simulating, get and process any html input
    if NEXTIONDISPLAY then GetUserInputs  ' get inputs from local display
    ReadSensors    ' get temperature and humidity
'    DisplayData
  loop

sub newMinute
  sMinuteDigit = mid$(time$,5,1)
  sVarVals(2)=mid$(time$,1,5) ' "20:52pm"
  if NEXTIONDISPLAY then
    sTmp = sVarVals(1)+" "+sVarVals(2) ' full date
    PRINT #2, "tDate.txt=";qt;sTmp;qt;sFF3; ' send date/time to Nextion display
  endif
end sub

sub GetUserInputs
  if LOC(2) > 1 then ' input buffer for Nextion has at least two bytes
    getNextionCommand
  ENDIF ' input available on serial port #2
end sub

sub ReadSensors
 if FALSE then
  if ds18B20timeout < timer then
    insideTemp=cint(tempr(dspin)) ' *10) 'read the temperature from the last conversion
    tempr start dspin,3 'start a new temperature conversion
    ds18B20timeout = timer+1000 ' wait 1 second before reading
  endif
  outsideTemp = insideTemp - 6.5 ' simulation only
  sVarVals(OUTTEMP)=str$(outsideTemp,0)
  sVarVals(INTEMP)=str$(insideTemp,0)
 endif
  if flagSensorChanged then : NXLoadSensorReadings : flagSensorChanged=FALSE : endif
end sub
  
SUB ProcessHTML
'    if debug1 then print "ProcessHTML"
  local a$,b$,pageX$
  iMasterLoopCount = iMasterLoopCount +1
  IF loc(#9)<>0 then
    pause 250 ' allow all characters to arrive
'    print "LOC(#9)="+str$(loc(#9));
    a$ = input$(min(245,loc(#9)),#9)
    b$= ""
'    print "; "+a$
    IF loc(#9)<>0 then b$ = input$(min(245,loc(#9)),#9) : print b$
'    SAddStr inbuf(),input$(min(255,loc(#9)),#9)
    SClear inbuf()
    SAddStr inbuf(),a$
    SAddStr inbuf(),b$
    htmlRequest$ = parsehtmldata$(nparams) ' builds arg$(1/2,nparams) name/value pairs
    print "nparams: ";nparams;": |";htmlRequest$;"|"
    if htmlRequest$ <> "" then
'      pageX$=ucase$(parsehtmldata$(nparams)) 'parse the html request and get the page requested
      pageX$=ucase$(htmlRequest$) 'parse the html request and get the page requested
'      pageX$=htmlRequest$ 'parse the html request and get the page requested
      if pageX$<>"" then 'real request so do something
        firstSend = 1 ' LB print first buffer of html code sent
        if pageX$="LIST" then ' list logfile
          sFrom="":sTo=""
          if arg$(1,1) = "A" then sFrom = arg$(2,1)
          if arg$(1,2) = "B" then sTo = arg$(2,2)
        elseif pageX$="G" then ' geothermal simulation variable update
         if flagNXUpdated = FALSE then ' haven't entered date from display, so process inputs
          if nparams<>0 then 'we have parameters to process
            print "nparams: "+str$(nparams)
            flagVarChanged = FALSE
            flagSensorChanged = FALSE
            flagHTMLupdated = FALSE
            iRelaySet1Ck=0
            for i = 50 to 55 : sVarVals(i) = "" : next i ' clear checkboxes
            for i = 1 to nparams
              htmlElementName=arg$(1,i) ' A-F,W,Y oTemp,iTemp,oHum,iHum,circSup,circRet
              if htmlElementName <> "" then
                htmlElementValue=arg$(2,i)
                print htmlElementName+"="+htmlElementValue+" ";
'                if i mod 10 = 0 then : print "" : endif
                if htmlElementName = "Y" then ' mode -- sVarVals(5.6.7.8) -- one only is "checked"
                  iOpMode = val(htmlElementValue) - val("0") ' 0, 1, or 2 for OFF, AUTO, MANUAL
                  j = iOpMode + 5 ' index into sVarVals
                  print "iOpMode = "+str$(iOpMode)
                  if sVarVals(j) = cNotChecked then ' wasn't checked; now should be
                    sVarVals(5) = cNotChecked: sVarVals(6) = cNotChecked: sVarVals(7) = cNotChecked
                    sVarVals(j) = "checked"
                    logToFile("Y", str$(iOpMode))
                    var save iOpMode
                    print "iOpMode = "+str$(iOpMode)
                    flagSensorChanged = TRUE
                  endif
                elseif htmlElementName = "W" then ' manual operation if iOpMode=2
                  j = asc(htmlElementValue)-asc("1") ' results in 0-5
                  sVarVals(j+50) = "checked" ' set appropriate check boxes
                  print "sVarVals(";j+50;") checked; ";htmlElementValue
'                  if iOpMode = cMANUAL then : sVarVals(j+10) = cBackGroundON : endif
                  iRelaySet1Ck = iRelaySet1Ck OR (1 << j) ' set bit 0-5
'                  print "W=";htmlElementValue;" ";j;" ";iRelaySet1Ck
                  flagSensorChanged = TRUE
                else ' all other named html elements ("A"-"V")
                  j = asc(htmlElementName)-asc("A")+30 ' index to receive this simulated value
'                print "i,j: "+str$(i)+" "+str$(j)+" |"+sVarVals(j)+"|"
                  if htmlElementValue <> "" and htmlElementValue <> sVarVals(j) then
                    print crlf+htmlElementName+": "+htmlElementValue+" updates "+str$(j)+" "+sVarVals(j)
                    sVarVals(j) = mid$(htmlElementValue,1,40)
                    logToFile(htmlElementName, sVarVals(j))
                    flagVarChanged = TRUE
                    flagSensorChanged = TRUE
                    select case htmlElementName
                      case "A": outsideTemp = val(sVarVals(j))
                      case "B": insideTemp = val(sVarVals(j))
                      case "C": iOutsideHumidity = val(sVarVals(j))
                      case "D": iInsideHumidity = val(sVarVals(j))
                      case "E": iCircSupplyTemp = val(sVarVals(j))
                      case "F": iCircReturnTemp = val(sVarVals(j))
                    end select
                  endif
                endif
              endif
            next i
            print ""
            if flagVarChanged then
'''              varSave ' save the temperature readings
            endif
          endif
'          if iRelaySet1Ck <> 0 then : print "iRelaySet1Ck: ";iRelaySet1Ck : endif
'        flagFirstPassAfterSim = TRUE
'''        setupSim
'''        setUpData
         endif ' flagNXUpdated = TRUE
         setRelays
         drawpage
        ' end of  pageX$="G" 
        elseif pageX$="A" then
          sTmp="<html><body>Bingo!</body></html>"
          i=LEN(sTmp)
          sendText "HTTP/1.0 200 OK"+crlf+"Content-type: text/html"+crlf
          sendText "Content-Length: "+str$(i)+crlf+"Connection: close"+crlf+crlf ' iContentLength
          sendText sTmp+crlf+crlf
        else
          i=LEN(pnf$)
          sendText "HTTP/1.0 200 OK"+crlf+"Content-type: text/html"+crlf
          sendText "Content-Length: "+str$(i)+crlf+"Connection: close"+crlf+crlf ' iContentLength
          SendText pnf$+crlf+crlf'invalid page
        endif
        EndSend 'clear the write buffer and terminate the write
      endif
    endif ' pageX$<>""
    do while loc(#9)>0  ' clear the TCP input buffer
      obuff$ = input$(min(250,loc(#9)),#9)
    loop
  endif ' if loc(#9)>0
  if flagSensorChanged = TRUE then ' update nextion
    flagHTMLUpdated = TRUE
    if iOpMode <> iNXMode then ' operating mode: OFF, AUTO, MANUAL
      PRINT #2,"r";str$(iNXMode);".val=0";sFF3; ' turn off old mode
      iNXMode = iOpMode
'      PRINT #2,"click r";str$(iOpMode);",0";sFF3;
'      IF debugNX THEN PRINT "click r";str$(iOpMode);",0"
      PRINT #2,"r";str$(iOpMode);".val=1";sFF3;
      IF debugNX THEN PRINT "r";str$(iOpMode);".val=1"
    endif
    sCheckboxSettings="" ' get checkbox settings ???
    for i = 0 to 5
      if sVarVals(i+50) <> "checked"  then
        sCheckboxSettings = sCheckboxSettings + "0" ' off
        PRINT #2,"u";str$(i);".bco=vRed.val";sFF3;
        IF debugNX THEN PRINT "t";str$(i);".bco=vRed.val"
        PRINT #2,"c";str$(i);".val=0";sFF3;
        IF debugNX THEN PRINT "c";str$(i);".val=0"
      else
        sCheckboxSettings = sCheckboxSettings + "1" ' onn
        if iOpMode = 0 then
          PRINT #2,"u";str$(i);".bco=vRed.val";sFF3;
          IF debugNX THEN PRINT "t";str$(i);".bco=vRed.val"
        else
          PRINT #2,"u";str$(i);".bco=vGreen.val";sFF3;
          IF debugNX THEN PRINT "t";str$(i);".bco=vGreen.val"
        endif
        PRINT #2,"c";str$(i);".val=1";sFF3;
        IF debugNX THEN PRINT "c";str$(i);".val=1"
      endif
    next i
    sCheckboxSettings=sCheckboxSettings+"00" ' checkbox settings last two bytes
    if sCheckboxSettings <> sOldCheckboxSettings then
      sOldCheckboxSettings = sCheckboxSettings
      var save sCheckboxSettings
    endif
    if flagVarChanged then
      NXLoadSensorReadings
    endif
  endif
  if fLoopCountTimeout <= TIMER then
    iTotalLoopPeriods = iTotalLoopPeriods + 1
    iTotalLoopCount = iTotalLoopCount + iMasterLoopCount
    i = iMasterLoopCount / fLoopCountLength
    sTmp = " "+str$(int(iTotalLoopCount/iTotalLoopPeriods/fLoopCountLength))+"c/s"
    if mid$(time$,5,1) = "0" then ' every 10 minutes
      print iMasterLoopCount; " Master Loop Passes this period;";i;"/second ";mid$(time$,1,5);
'      fLoopCountTimeout = TIMER + (86400 * 1000) ' 24 hours later
      print sTmp
    endif
'    if fLoopCountLength = 120 then : fLoopCountLength = 300 : endif ' 5 minutes after 1st
    fLoopCountTimeout = TIMER + (1000*fLoopCountLength)
    iMasterLoopCount = 0
  endif
END SUB
  
Function parsehtmldata$(paramcount as integer)
  local a$,b$,c$
  local FLOAT buf(Maxlen\4)
  local integer inpos,startparam,processargs
  paramcount=1 ' LB as array index, values starting from 1 instead of from 0
  c$=SGetStr(inbuf(),1,240)
'  print "HTML input: |"+c$+"|"
'  inpos=SInstr(inbuf(),"GET /",1)
'  if inpos=0 then
    inpos=instr(c$,"GET /")
'  endif
  if inpos=0 then
    parsehtmldata$=""
  else ' see Geo-lb.v3.715.bas for original using buf()
'    SMId buf(),inbuf(),inpos+5
    c$=mid$(c$,inpos+5)
    inpos=instr(c$,starttext$)
    if inpos > 0 then
      logToFile("!",mid$(c$, 1, inpos-1)) ' log input request
    endif
    print "PARSE: ";inpos;" "+mid$(c$, 1, 100)
    If inpos>2 Then 'page request found
      inpos=inpos-2
      a$=mid$(c$,1,inPos)
      inpos=Instr(a$,"?")
      If inpos<>0 Then 'parameters found
        processargs=1
        parsehtmldata$=Left$(a$,inpos-1)
        a$=Mid$(a$,inpos+1)
        Do
          arg$(1,paramcount)=""
          arg$(2,paramcount)=""
          inpos=Instr(a$,"=")
          if inpos > 0 then
            startparam=1
            arg$(1,paramcount)=Mid$(a$,startparam,inpos-startparam)
            startparam=inpos+1
            inpos=Instr(a$,"&")
            If inpos<>0 Then
              arg$(2,paramcount)=Mid$(a$,startparam,inpos-startparam)
              a$=Mid$(a$,inpos+1)
              paramcount=paramcount+1
            Else
              arg$(2,paramcount)=Mid$(a$,startparam)
              paramcount=paramcount+1
              processargs=0
            EndIf
          EndIf
        Loop while processargs
      Else
        parsehtmldata$=a$
      EndIf
    Else ' no page requested
      parsehtmldata$="INDEX"
    EndIf
  endif
End Function
  
sub setRelays
' if iOpMode = cMANUAL then : sVarVals(j+10) = cBackGroundON : endif
'print "setRelays: ";iOpMode;" ";iRelaySet1Ck
  select case iOpMode
    case cOFF ' off
      for i = 1 to nRelayPins
        sVarVals(i+9) = cBackGroundOFF
        pin(iRelayPins(i)) = cOFF
      next i
    case cAUTO ' auto mode
    case cMANUAL ' manual mode
      j = 1
      for i = 1 to nRelayPins
'        print "setRelays: i,j,ck&j: ";i;" ";j;" ";
        if (iRelaySet1Ck AND j) <> 0 then ' bit 0-5 on/off
          sVarVals(i+9) = cBackGroundON
          pin(iRelayPins(i)) = cON
        else
          sVarVals(i+9) = cBackGroundOFF
          pin(iRelayPins(i)) = cOFF
        endif
        j = j * 2
      next i
  end select
end sub

sub drawpage
  flagNXUpdated = FALSE ' only if still false upon html update receive is data updated
  if mid$(DATE$,1,1)="0" then : sDay = mid$(date$,2,1) : else : sDay = mid$(date$,1,2) : endif
  if iToday <> val(sDay) then
    newday
  endif
'  sendText "HTTP/1.1 200 OK"+crlf+crlf
  sendText "HTTP/1.1 200 OK"+crlf+"Content-type: text/html"+crlf
  sendText "Content-Length: "+sContentLength$(i)+crlf+"Connection: close"+crlf+crlf ' iContentLength
  iContentLength=0
  sendText "<!DOCTYPE html>"+crlf
  putHTML
 
  sendText crlf+crlf+"                  "+crlf+crlf
  print "html page output complete "+mid$(TIMe$,1,5)
  print "sContentLength: ;"+sContentLength+"; counted: "+STR$(iContentLength)

  print "Ready for user input"
end sub
  
sub putHTML
  n = 1
  i = 1
  j = nVarNdx(n)
  do while j <> 99999
    k = j - i
    do while k > 250
      sendText SGetStr(htmlBuffer(),i,250)
      k = k - 250
      i = i + 250
    loop
'    sendText mid(htmlBuffer,i,j-i)+sVarVals(nVarNos(n))
    sendText SGetStr(htmlBuffer(),i,k)
    sendText sVarVals(nVarNos(n))
    n = n + 1
    i = j + 3
    j = nVarNdx(n)
  loop
'  sendText mid(htmlBuffer,i)
  sendText SGetStr(htmlBuffer(),i,255)
end sub
  
sub SendText(a$) ' buffer to speed up html output
  local b$
  iContentLength = iContentLength + Len(a$)
  if flagNoOutput then ' first pass only--count output characters
  else
    if firstSend = 1 then
      firstSend = 0
      print a$
    endif
    if len(a$)+len(obuff$)< 240 then 'add the new string to the output buffer
      obuff$=obuff$+a$
    else 'too big to fit so send the current output buffer
      print #9,obuff$;
      obuff$=a$
    endif
  endif
end sub
  
sub EndSend
  print #9,obuff$
  print #9, ""
  obuff$=""
end sub
  
'function min(a as integer, b as integer) as integer
'  min=a
'  if(a>=b)then min=b
'end function
  
sub initialize
  Dim arg$(2,hVarmax) length 20
  DIM FLOAT inbuf(Maxlen\4) 'global input buffer
  dim integer nparams, ds18B20timeout
  DIM as string htmlRequest$
  dim as float htmlBuffer(longStringMaxLen/4) ' LB 170310
  DIM AS STRING htmlLine, templateLine, sHTMLVarNo length 2
  '                                                                          01234567
  DIM AS STRING sCheckboxSettings length 8, sOldCheckboxSettings length 8 ' "101010xx"
  DIM AS STRING sRelaySet1Val length 8, sRelaySet2Val length 8, sOldRelaySet1Val length 8, sOldRelaySet2Val length 8
  DIM AS INTEGER iRelaySet1Val, iRelaySet2Val, iOldRelaySet1Val, iOldRelaySet2Val, iRelaySet1Ck
  dim as integer iRelayPins(6) = (pCIRCULATOR, pLouver_Vent, pMister, pFan_Out, pFan_In, pHeater)
  dim as integer iRelayPinNo
  DIM AS INTEGER i,j,k,l,m,n,iContentLength
  DIM AS INTEGER nVarNdx(maxVars), nVarNos(maxVars)
  dim as integer flagNXUpdated, flagHTMLupdated, flagNoOutput
  dim as string sFrom length 12, sTo length 12, sTmp, sMinuteDigit length 1, sLength Length 5
  DIM AS string sVarVals(83) length 40
'  dim AS string sDay, sDayOfWeek(7) length 10 = ("Monday","Tuesday","Wednesday","Thursday","Friday","Saturday","Sunday")
  dim AS string sDay, sDayOfWeek(7) length 10 = ("Mon","Tue","Wed","Thu","Fri","Sat","Sun") ' Monday is DOW 1
  dim as integer iDayOfWeek, iToday, iMaxsVarVal=58
  dim as integer iOpMode=0 ' 0=OFF,1=AUTO,2=MANUAL
'  DIM as string sMonthNames(12) = ("January","February","March","April","May","June","July","August","September","October","November","December")
  DIM as string sMonthNames(12) = ("Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec")
  dim integer iMonth, iMasterLoopCount, iTotalLoopCount=0, iTotalLoopPeriods=0
  dim integer outsideTemp, insideTemp, iOutsideHumidity, iInsideHumidity
  dim integer iCircSupplyTemp, iCircReturnTemp
  dim float fLoopCountTimeout, fLoopCountLength, rtc17, rtc18
  dim as integer firstSend=1
  DIM as string obuff$="" 'used to buffer writes to the internet to optimise speed
  DIM as string htmlElementName length 1 ' A-F oTemp,iTemp,oHum,iHum,circSup,circRet
  DIM as string htmlElementValue length 10 ' A-F oTemp,iTemp,oHum,iHum,circSup,circRet
  DIM as string sContentLength Length 5 ' length of html display output
  dim integer iPos, jPos, flagVarChanged, flagSensorChanged, flagFirstPassAfterSim ' LB 170303
  dim as string sON length 10, sOFF length 10, sCh length 1
  dim string CRLF=chr$(13)+chr$(10) length 2
  'Chartreuse, red
  
  I2C open 100, 1000
'    rtc SETREG 0-seconds,1-min,2=hr;,3-dow,4=d,5=mo,6=yr
'    rtc SETREG 2,10 ' set hour; daylight savings time, march 12, 2017
'    rtc SETREG 2,21 ' set hour
'    rtc SETREG 1,7 ' set minute
'    rtc SETREG 3,5 ' set day of week: monday = 0
' RTC SETTIME year, month, day, hour, minute, second
'  RTC SETTIME 2017, 3, 12, 21, 11, 30
'  RTC SETTIME 2017, 4, 22, 11, 14, 0
  pause 1000
  if RTC_OK then
    rtc gettime
'   for i = 1 to 7 : print sDayOfWeek(i)+" " : next i
    RTC GETREG 17, rtc17
    RTC GETREG 18, rtc18
    IF rtc17 < &h80 THEN
      insideTemp = rtc17 + (rtc18 / 256)
    ELSE
      insideTemp = -(((rtc17 XOR &hFF) + 1) + (rtc18 / 256))
    ENDIF
  endif
  print "~458 ";date$;" ";TIME$
  newday
  print "DATE: ";date$
  print "TIME: ";TIMe$
  PRINT "DS3231 temperature: ";insideTemp
  memory
  readHTMLTemplate
  iMasterLoopCount = 0
  fLoopCountLength = 120 ' 5 minutes ' 600 ' 10 minutes -- 120 ' 2 minutes
  fLoopCountTimeout = TIMER + (1000*fLoopCountLength)
' ??  insideTemp = TEMPR(dspin,3) ' DS18B20
  print "Temp: "+str$(insideTemp,0)+"C "+str$(insideTemp*9/5+32,0)+"F" 'measure temp to 0.0625 degree accuracy
' ??    tempr start dspin,3 'start a new temperature conversion--takes up to 750ms
  ds18B20timeout = timer+1000 ' wait 1 second before reading
  iOldRelaySet1Val=0 ' all relays off
'  CONST pCIRCULATOR=26, pLouver_Vent=25, pMister=24, pFan_Out=23, pFan_In=16, pHeater=15
' ??  for i = 1 to nRelayPins : SETPIN iRelayPins(i), DOUT : next i ' set relay pins as output
'  for i = 1 to nRelayPins : pin(iRelayPins(i)) = cON : pause 1000 : next i ; turn pins on
'  for i = 1 to nRelayPins : pin(iRelayPins(i)) = cOFF : pause 1000 : next i ; turn pins oFF
  if SIMULATE then
    flagVarChanged = TRUE    ' outsideTemp, insideTemp, etc
    insideTemp=insideTemp+3
    outsideTemp = insideTemp - 6.5
    iOutsideHumidity=insideTemp+31
    iInsideHumidity=insideTemp+60
    iCircSupplyTemp=insideTemp+15
    iCircReturnTemp=insideTemp+9
    print "Opening COM3--HTML simulation"
'    open "com1:38400,4096" as #9
    open "com3:38400,4096" as #9
    do while loc(#9)>0  ' clear the TCP input buffer
      obuff$ = input$(min(250,loc(#9)),#9)
    loop
    ' const CIRCULATOR=10,FAN_OUT=11,LOUVER_VENT=12,FAN_IN=13,MISTER=14,HEATER=15
    ' sVarVals(CIRCULATOR)=cBackGroundOFF
    for i = CIRCULATOR to HEATER : sVarVals(i)=cBackGroundOFF : next i
    sVarVals(MODE_OFF)="checked"
'  const OUTTEMP=30,INTEMP=31,OUTHUMI=32,INHUMI=33,CIRCSUPPLY=34,CIRCRETURN=35
    sVarVals(INHUMI)=str$(iInsideHumidity,1)
    sVarVals(OUTHUMI)=str$(iOutsideHumidity,1)
    sVarVals(CIRCSUPPLY)=str$(iCircSupplyTemp,1)
    sVarVals(CIRCRETURN)=str$(iCircReturnTemp,1)
    outsideTemp = insideTemp - 6.5
    sVarVals(OUTTEMP)=str$(outsideTemp,0)
    sVarVals(INTEMP)=str$(insideTemp,0)
    sCheckboxSettings="00000000" ' all off
  endif
  var restore ' restore after power outage or autorun restart--iOpMode & sCheckboxSettings
  for i=50 to 55 
    j = i - 49
    sCh = mid$(sCheckboxSettings,j,1)
    if sCh = "1" then : sVarVals(i) = "checked" : else : sVarVals(i) = cNotChecked : endif    
    print "iOpMode, ckboxes: ";iOpMode;" ";sCheckboxSettings
  endif
  flagNoOutput=TRUE
  iContentLength = 0
  drawpage  ' get sContentLength
  sContentLength=str$(iContentLength)
  flagNoOutput=FALSE
  print "HTML Content-Length: "+sContentLength
  if NEXTIONDISPLAY then initNextion
  print "Ready for user input"
end sub
  
sub readHTMLTemplate
  LOCAL as string A(20)
A(17)="" : A(18)="" : A(19)="" : A(20)="" 
'A(1) = "<html> <title>Solar Greenhouse System</title> <meta http-equiv='refresh' content='120' > <head></head> <BODY bgcolor='#d0d0d0'> <form name='f1' method='get' action='G'><p> <!-- line below eliminates favicon requests --> <p><link href='data:"
A(1) = "<html> <title>Solar Greenhouse System</title> <head></head> <BODY bgcolor='#d0d0d0'> <form name='f1' method='get' action='G'><p> <!-- line below eliminates favicon requests --> <p><link href='data:"
A(2) = "image/x-icon;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQEAYAAABPYyMiAAAABmJLR0T///////8JWPfcAAAACXBIWXMAAABIAAAASABGyWs+AAAAF0lEQVRIx2NgGAWjYBSMglEwCkbBSAcACBAAAeaR9cIAAAAASUVORK5CYII=' rel='icon' type='image/x-icon' /> <P style='margin-top: .0"
A(3) = "1; margin-bottom: .01'><b> <table background='https://www.dropbox.com/s/3u25uvf2rkzmznx/Image3.jpg?raw=1'> <tr><td><center><font color='#088A08' size='6'> Solar Greenhouse System Status</font><br> <font size='4'>~01 ~02</font><br> </td></tr"
A(4) = ">  <tr><td> </font></P> <table border=1 rules=none><font size='5'> <tr><td></td> <td><center>&nbsp;<font size='5'> <input onChange='this.form.submit();' type='radio' name='Y' value='0' ~05> OFF&nbsp;&nbsp; <input onChange='this.form.submit("
A(5) = ");' type='radio' name='Y' value='1' ~06> AUTO&nbsp;&nbsp; <input onChange='this.form.submit();' type='radio' name='Y' value='2' ~07> MANUAL&nbsp;</td></font></center> <td>&emsp;&emsp;</td></tr> <tr><td>&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&e"
A(6) = "msp;&emsp;&emsp;</td> <td>&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp; &emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;</td> <td>&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp"
A(7) = ";&emsp;&emsp;</td></tr>  <tr><td><input size=13 value='CIRCULATOR' style='background-color:~10' readonly>&emsp; <input type='checkbox' name='W' value='1' ~50></td> <td><font size='5'><center>Outside Temperature&emsp;~30</center></td> <td>&e"
A(8) = "msp;&emsp;<input size=10 value='FAN OUT' style='background-color:~13' readonly> &ensp;<input type='checkbox' name='W' value='4' ~53>&ensp;</td></tr>  <tr><td></td> <td><font size='5'><center>Inside Temperature&emsp;~31</center></td> <td>&em"
A(9) = "sp;&emsp;</td></tr>  <tr><td><input size=13 value='LOUVER VENT' style='background-color:~11' readonly>&emsp; <input type='checkbox' name='W' value='2' ~51></td> <td><font size='5'><center>Outside Humidity&emsp;~32</center></td> <td>&emsp;&e"
A(10) = "msp;<input size=10 value='FAN IN' style='background-color:~14' readonly> &ensp;<input type='checkbox' name='W' value='5' ~54>&ensp;</td></tr>  <tr><td></td> <td><font size='5'><center>Inside Humidity&emsp;~33</center></td><td></td></tr>  <t"
A(11) = "r><td><input size=13 value='MISTER' style='background-color:~12' readonly>&emsp; <input type='checkbox' name='W' value='3' ~52></td> <td><font size='5'><center>Circulator Temperature Supply&emsp;~34</center></td> <td>&emsp;&emsp;<input size"
A(12) = "=10 value='HEATER' style='background-color:~15' readonly> &ensp;<input type='checkbox' name='W' value='6' ~55>&ensp;</td></tr>  <tr><td></td><td><font size='5'><center>Circulator Temperature Return&emsp;~35</center></td><td></td></tr> </fon"
A(13) = "t></table>  <center> <table rules=none> <tr><td><font size='5' color='red'><center>Values for Simulation</center></font></td></tr> </table> <table border=1 rules=none><font size='4'> <tr><td>Outside Temp</td><td><input size=5 name='A' value"
A(14) = "='~40'></td> <td>&emsp;Inside Temp </td><td><input size=5 name='B' value='~41'></td></tr> <tr><td>Outside Humidity</td><td><input size=5 name='C' value='~42'></td> <td>&emsp;Inside Humidity</td><td><input size=5 name='D' value='~43'></td></"
A(15) = "tr> <tr><td>Circulator Supply</td><td><input size=5 name='E' value='~44'></td> <td>&emsp;Circulator Return</td><td><input size=5 name='F' value='~45'></td></tr>  </font> </table> </center>  <br><center><font size='4'> To submit new values, "
A(16) = "click 'Simulate' <input type='submit' value='Simulate'></font>    </center></td></tr></font></table> </form> </BODY> </html>                   "
   
  SClear htmlBuffer()
  for i = 1 to 20
    SAddStr htmlBuffer(), A(i)
  next i
'  j = instr(htmlBuffer,"~")
  j = SInstr(htmlBuffer(),"~")
  i = 1
  n = 1
'  DIM AS INTEGER nVarNdx(maxVars), nVarNos(maxVars)
  do while j > 0
'      sHTMLVarNo = mid$(htmlBuffer,j+1,2)
    sHTMLVarNo = SGetStr(htmlBuffer(),j+1,2)
    k = VAL(sHTMLVarNo)
    if k > 0 and k <= maxVars then
      nVarNdx(n) = j ' character after end of string
      nVarNos(n) = k
'  print "nijk "+str$(n)+" "+str$(i)+" "+str$(j)+" "+str$(k)
      n = n + 1
    else
      PRINT "Invalid varNo: ";htmlBuffer
    endif
    i = j + 3
'      j = instr(i,htmlBuffer,"~")
    j = SInstr(htmlBuffer(),"~",i)
  loop
  nVarNdx(n) = 99999 ' invalid length
  print str$(n)+" variables found in html template"
'  printHTML
end sub
  
Sub newday
  if RTC_OK then
    rtc GETREG 3,iDayOfWeek
'    iDayOfWeek = iDayOfWeek mod 7 + 1
  else
    iDayOfWeek = 6
  endif
  print "DOW: "+str$(iDayOfWeek)+" -- ";sDayOfWeek(iDayOfWeek)
  iMonth=val(mid$(date$,4,2))
  if mid$(DATE$,1,1)="0" then
    sDay = mid$(date$,2,1)
  else
    sDay = mid$(date$,1,2)
  endif
  iToday = val(sDay)
  sVarVals(1)=sDayOfWeek(iDayOfWeek)+", "+sMonthNames(iMonth)+" "+sDay+", "+mid$(DATE$,7)
  sVarVals(2)=mid$(time$,1,5) ' "8:52pm"
  print sVarVals(1)+" "+sVarVals(2)
end sub
  
sub logToFile(id as string, a as string)
  local timeStamp as string
  timeStamp = mid$(DATE$,9)+mid$(DATE$,4,2)+mid$(DATE$,1,2)
  timeStamp = timeStamp+mid$(timE$,1,2)+mid$(timE$,4,2)+mid$(timE$,7,2)
'  open "log.txt" for append as #8 ' log
'  print #8,timeStamp+" "+id+" "+a
'  close #8
end sub

SUB initNextion
  dim as string cActionCode length 1, cActionVal length 1, sMode length 15
  dim as string sVal length 15, sNum length 15
  dim as string sFF3 length 3
  dim as integer iNxMode, iNxNDX
  

  sFF3 = cFF+cFF+cFF

  Open "com2:9600" As #2 ' nextion screen: uMite E28 pins: 9=Tx, 10=Rx
  IF debugNX THEN PRINT "COM2 opened--Nextion OLED"
  PRINT #2,"page page0";sFF3;

end sub

SUB getNextionCommand ' uses greenhouse.HMI loaded in Nextion 320x240 basic
' messages: 
'   #0   = page load
'   !0-2 = iOpMode: 0=OFF,1=AUTO,2=MANUAL
'   +0-5 = MANUAL mode checkbox ON: circulator,vent,mister,fanout,fanin,heater
'   -0-5 = MANUAL mode checkbox OFF
  cActionCode = Input$(1, #2)
  if cActionCode = "!" or cActionCode = "#" or cActionCode = "+" or cActionCode = "-" then 
    flagNXUpdated = TRUE  ' don't override display inputs with html inputs
    cActionVal = Input$(1, #2)
    iNxNDX = asc(cActionVal)-asc("0")
    PRINT "Command "+cActionCode+" "+cActionVal+" ";iNxNDX
'    select Case cActionCode
'      case "!"        ' button release
    if cActionCode = "!" then ' mode change: iOpMode
      iNxMode = iNxNDX 
      if cActionVal => "0" and cActionVal < "4" then ' mode change
        sVarVals(5) = cNotChecked: sVarVals(6) = cNotChecked: sVarVals(7) = cNotChecked
      endif
      select case cActionVal
        case "0"             ' OFF ' pg1 radio button 0 clicked
                 sVarVals(MODE_OFF) = "checked"
        case "1"    ' AUTO ON
                 sVarVals(MODE_AUTO) = "checked"
        case "2"    ' MANUAL ON
                 sVarVals(MODE_MANUAL) = "checked"
      End select
    elseif cActionCode = "+" then  ' checkbox clicked on c0-5 sVarVals(50-55)
      sVarVals(iNxNDX+50) = "checked"
      print "sVarVals(";iNxNDX+50;") checked"
      if iNxMode = cMANUAL then
        PRINT #2,"t";str$(iNxNDX);".bco=vGreen.val";sFF3;
        IF debugNX THEN PRINT "t";str$(iNxNDX);".bco=vGreen.val"
      endif
      sCheckboxSettings=mid$(sCheckboxSettings,1,iNxNDX)+"1"+mid$(sCheckboxSettings,iNxNDX+1)
      var save sCheckboxSettings
      sOldCheckboxSettings = sCheckboxSettings
    elseif cActionCode = "-" then  ' checkbox clicked off c0-5
      sVarVals(iNxNDX+50) = cNotChecked
      if iNxMode = cMANUAL then
        PRINT #2,"t";str$(iNxNDX);".bco=vRed.val";sFF3;
        IF debugNX THEN PRINT "t";str$(iNxNDX);".bco=vRed.val"
      endif
      sCheckboxSettings=mid$(sCheckboxSettings,1,iNxNDX)+"0"+mid$(sCheckboxSettings,iNxNDX+1)
      var save sCheckboxSettings
      sOldCheckboxSettings = sCheckboxSettings
'      Case "#"        ' page change
    elseif cActionCode = "#" then  ' change page #
'        IF cActionVal=>"0" and cActionVal<"9" then : iNxPage=asc(cActionVal)-asc("0") : ENDIF
        IF debugNX THEN PRINT "page change to "+cActionVal
        select case cActionVal
          case "0"    ' initial load of project--set mode
            sNum = chr$(iNxMode+48) ' offset to ascii "0", "1", "2"
            PRINT #2, "click r";sNum;",0";sFF3;
            IF debugNX THEN PRINT "click r";sNum;",0"
            PRINT #2, "r";sNum;".val=1";sFF3;
            IF debugNX THEN PRINT "r";sNum;".val=1"
            sTmp = sVarVals(1)+" "+sVarVals(2) ' full date
            PRINT #2, "tDate.txt=";qt;sTmp;qt;sFF3; ' send date/time to Nextion display
            IF debugNX THEN PRINT "tDate.txt=";qt;sTmp;qt
            for i = 0 to 5  ' uncheck boxes
'              PRINT #2,"c";str$(i);".val=0";sFF3;
'              PRINT #2,"click c";str$(i);",0";sFF3; ' (0 is click release)
            next i
            NXLoadSensorReadings
        End select
'    End select
    endif ' if cActionCode
    updateNxDisplay 
  endif ' if cActionCode = "!","#","+","-" then
END SUB ' getNextionCommand

sub updateNxDisplay ' nextion OLED
'  print "updateNxDisplay: "+cActionCode+cActionVal+" MODE: ";iNxMode;" ";iOpMode
'  print "sVarVals(51) ";sVarVals(51)
  if iNxMode <> iOpMode then ' mode change
    iOpMode = iNxMode
    var save iOpMode
    logToFile("Y", str$(iNxMode))
    if iNxMode = cOFF then
      for i = 0 to 5    
        PRINT #2,"u";str$(i);".bco=vRed.val";sFF3;
        IF debugNX THEN PRINT "u";str$(i);".bco=vRed.val"
      next i
    ELSEif iNxMode = cAUTO then
    ELSEif iNxMode = cMANUAL then
      for i = 0 to 5
          if sVarVals(i+50) = "checked" then ' is checked
          PRINT #2,"u";str$(i);".bco=vGreen.val";sFF3;
          IF debugNX THEN PRINT "u";str$(i);".bco=vGreen.val"
        endif
      next i
    endif
  endif
end sub

sub NXLoadSensorReadings
'  outsideTemp, insideTemp, iOutsideHumidity, iInsideHumidity,iCircSupplyTemp, iCircReturnTemp
  if flagVarChanged = TRUE then
    PRINT #2, "t16.txt=";qt;str$(outsideTemp,0);qt;sFF3;
    IF debugNX THEN PRINT "t16.txt=";qt;str$(outsideTemp,0);qt
    PRINT #2, "t17.txt=";qt;str$(insideTemp,0);qt;sFF3;
    IF debugNX THEN PRINT "t17.txt=";qt;str$(insideTemp,0);qt
    PRINT #2, "t18.txt=";qt;str$(iOutsideHumidity,0);qt;sFF3;
    IF debugNX THEN PRINT "t18.txt=";qt;str$(iOutsideHumidity,0);qt
    PRINT #2, "t19.txt=";qt;str$(iInsideHumidity,0);qt;sFF3;
    IF debugNX THEN PRINT "t19.txt=";qt;str$(iInsideHumidity,0);qt
    PRINT #2, "t20.txt=";qt;str$(iCircSupplyTemp,0);qt;sFF3;
    IF debugNX THEN PRINT "t20.txt=";qt;str$(iCircSupplyTemp,0);qt
    PRINT #2, "t21.txt=";qt;str$(iCircReturnTemp,0);qt;sFF3;
    IF debugNX THEN PRINT "t21.txt=";qt;str$(iCircReturnTemp,0);qt
    flagVarChanged = FALSE
  endif ' if flagVarChanged = TRUE
end sub

CSub SAddStr float, string
  00000000
  10800011 00000000 10A0000F 00000000 90A30000 8C820000 00623021 1060000A
  AC860000 24420004 00822021 24A50001 00831821 90A20000 A0820000 24840001
  1483FFFC 24A50001 03E00008 00000000
End CSub
  
CFunction SGetStr(float, integer, integer) string
  00000000
  3C029D00 27BDFFE0 8C420040 AFB00018 AFA50010 AFA60014 AFBF001C 00808021
  0040F809 24040100 8FA50010 1200001E 8FA60014 10A0001D 8FBF001C 50C0001C
  8FB00018 8CA30000 5060001C A0400000 8E050000 00A3202B 14800017 240400FF
  8CC60000 2CC70100 24A50001 00C7200B 00A32823 00A4302B 0086280A 10A0000A
  A0450000 24630003 02038021 00452821 00401821 92040000 A0640001 24630001
  1465FFFC 26100001 8FBF001C 8FB00018 03E00008 27BD0020 A0400000 8FBF001C
  8FB00018 03E00008 27BD0020
End CFunction
  
CSub SClear float
  00000000 54800001 AC800000 03E00008 00000000
End CSub
  
CSub SMid float, float, integer, integer
  00000000
  1080001F 00000000 10A0001D 00000000 10C0001B 00000000 50E0001D 3C07000F
  8CE70000 8CC20000 50400015 A0800000 8CA60000 00C2182B 14600013 24C60001
  00C23023 240300FF 2CC80100 0068300A 00E6182B 00E3300B 10C00009 AC860000
  24420003 00A22821 00861821 90A20000 A0820004 24840001 1483FFFC 24A50001
  03E00008 00000000 03E00008 A0800000 1000FFE4 24E7423F
End CSub
  
CFunction SInstr(float, string, integer) integer
  00000000
  10C00002 00005021 8CCA0000 50800027 00002021 50A00025 00002021 90A90000
  8C8B0000 01695823 016A102B 1440001E 008A2021 10000004 90AC0001 016A102B
  14400019 24840001 90820004 544CFFFB 254A0001 51200010 25440001 00801821
  10000006 24020001 90670005 91080000 15070006 24630001 00C01021 24460001
  0049382B 14E0FFF8 00A64021 5449FFEB 254A0001 25440001 00002821 00801021
  03E00008 00A01821 00002021 00002821 00801021 03E00008 00A01821
End CFunction
  
CFunction SLen(float) integer
  00000000
  10800005 00003821 8C860000 00C01021 03E00008 00E01821 00003021 00C01021
  03E00008 00E01821
End CFunction
