'  option autorun on
  Option explicit
  option default NONE
  const MaxLen=1024
  const max=20
  const altitude=120 'altitude in meters of station
  
  ' Global variables
  const quote=chr$(34)  
  CONST SSID$=quote+"mySSID"+quote
  CONST SSIDPassword$=quote+"myPW"+quote
  const portno$="1234" 'set the port to be used for the webserver
  '
  const starttext$="HTTP"
  const pnf$="<html><body>Page not Found</body></html>"
  const title$="<html><head><title>Remote Thermostat</title></head><body>"
  const ending$="</form></body></html>"
  const form$="<form name='f1' method='get' action='D'>"
  const hh2$="<h2 align='left'>Remote Thermostat V3.0</h2>"
  const code$="Update Code: <input type='text' name='S' size='6' value='000000'><br>"
  const tstart$="<p><TABLE BORDER='1' CELLSPACING='0' CELLPADDING='5'>"
  const heat$="<TR><TD>Heating</TD>"
  const hon$="<TD BGCOLOR='#ff0000'> On</TD></TR>"
  const hoff$="<TD BGCOLOR='#00ff00'>Off</TD></TR>"
  const tend$="</TABLE></p>"
  const hh3$="<TR><TD></TD><TD>Temperature</TD><TD>Humidity</TD><TD>Pressure</TD><TD>OAT</TD></TR>"
  const s1$="<TR><TD>Current</TD><TD>"
  const s2$="<TR><TD>Max</TD><TD>"
  const s3$="<TR><TD>Min</TD><TD>"
  const check$="<input name='C' type='checkbox' value='R' onClick='this.form.submit()'> Reset Max/Min"
  const s4$="<TR><TD>Thermostat</TD>"
  const s5$="<TD><input name='R' type='radio'  checked='checked' value='"
  const s6$="<TD><input name='R' type='radio' value='"
  const click$="'onClick='this.form.submit()'> "
  const degree$="&degC<br></TD>"
  const offstr$="Off<br></TD>"
  const onstr$="On<br></TD>"
  const ON=1
  const off=0
  '   
'  BME280 routines and test harness   
'   cip
const BME280_ADDRESS                    = &H77   
const BME280_REGISTER_T1                = &H88   
const BME280_REGISTER_P1                = &H8E   
const BME280_REGISTER_H1                = &HA1   
const BME280_REGISTER_H2                = &HE1   
const BME280_REGISTER_CHIPID            = &HD0   
const BME280_REGISTER_CONTROLHUMID      = &HF2   
const BME280_REGISTER_CONTROL           = &HF4   
const BME280_REGISTER_PRESSUREDATA      = &HF7   
const BME280_REGISTER_TEMPDATA          = &HFA   
const BME280_REGISTER_HUMIDDATA         = &HFD   
'   
dim integer s16=&HFFFFFFFFFFFF0000 , s16b=&H8000 
dim integer s12=&HFFFFFFFFFFFFF000 , s12b=&H800 
dim integer s8= &HFFFFFFFFFFFFFF00  , s8b=&H80 
'          
DIM INTEGER T1,T2,T3     'uint16_t, int16_t, int16_t    
DIM INTEGER P1,P2,P3,P4,P5,P6,P7,P8,P9    'uint16_t, 8 x int16_t    
DIM INTEGER H1,H2,H3,H4,H5,H6     'uint8_t, int16_t , uint8_t, int16_t, int16_t, int8_t    
' 
dim INTEGER t_fine  'used to store accurate temp reading from temp conversion for use in pressure and humidity conversions
dim integer iPos, jPos ' LB 170303
  '
  ' Set up parameters
  '
  const starttemp=20 'set the lowest temperature on the thermostat select radio buttons
  const hysteresis=2 ' 2 tenths of a degree either side of the setpoint
  const waittime=1000 'wait time in readrequest before timeout
  const password$="123456" 'password to access change mode
  '
  const dspin=15    ' d6 e-64=3
  const relaypin=14 ' d3 e-64=46
  const resetpin=6  ' a0 45
  '
  Dim arg$(2,max) length 20
  DIM integer inbuf(Maxlen\4) 'global longstring input buffer
  dim string CRLF=chr$(13)+chr$(10) length 2  

  dim integer DOSflag ' if DOS; else L4, etc
  dim integer IPDno  'global IPD numbers used to ensure transmit is on correct IPD
  dim integer heater,currenttemp,maxtemp,mintemp,setpoint
  dim integer outsidetemp,maxoutsidetemp,minoutsidetemp
  dim integer pressure,maxpressure,minpressure
  dim integer humidity,maxhumidity,minhumidity
  dim integer nparams,connected=0
  dim as string pageX$ 'variables used by main loop only
  DIM as string htmlRequest$ ' LB 170303
  DIM as string commportno
  dim as integer firstSend=1
  DIM obuff$="" 'used to buffer writes to the internet to optimise speed
  Init:
  print("Starting")
  if instr(mm.device$,"DOS") then : DOSflag = 1 : else : DOSflag = 0 : endif
  if DOSflag then
    commportno="5" 
  else
    setpin resetpin,dout
    pin(resetpin)=0 'put the ESP8266 into reset
'    bme280_init
'    ds18B20 start dspin,3 'measure temp to 0.0625 degree accuracy
    tempr start dspin,3 'measure temp to 0.0625 degree accuracy
    commportno="1" 
  endif
  mintemp=1000 'set to silly value to force reset if not saved
  minoutsidetemp=1000
  maxtemp=-1000
  maxoutsidetemp=-1000
  maxhumidity=-100
  minhumidity=200
  maxpressure=-1000
  minpressure=50000
  print("--1")
' LB outsidetemp=cint(tempr(dspin)*10)
  outsidetemp=62
'  currenttemp=cint(bme280_read_temp()*10)
  currenttemp=71
'  pressure=cint(10*bme280_read_pressure()*(((1-(altitude*0.0065)/(currenttemp/10+0.0065*altitude+273.15)))^-5.257))
  pressure=0
'  humidity=cint(bme280_read_humidity())
  humidity=49
' LB  ds18B20 start dspin,3 'start a temperature conversion
' lb 181121 error:   var restore 'recover the setpoint and min and max temps if already saved
' lb 190214
  maxmin 'update the maximum and minimum and save them if changed
  heater=off
  print("--2")
  if not DOSflag then : pin(relaypin)=heater : endif
' LB  setpin relaypin,dout
  setpoint=asc("E")
  pause 5000 'wait for ESP8266 to stabilise after power on
  print "Opening COM1"
'  open "com"+commportno+":115200,4096" as #3 ' on MX170, COM1 is hardware, COM2 software at lower speed
'  open "com"+commportno+":57600,4096" as #3 ' on MX170, COM1 is hardware, COM2 software at lower speed
  open "com"+commportno+":9600,4096" as #3 ' on MX170, COM1 is hardware, COM2 software at lower speed
  if not DOSflag then
    pin(resetpin)=1 'release the ESP8266 from reset
  endif
  timer=0
  do while TIMER<20000
    IF loc(#3)<>0 then LONGSTRING APPEND inbuf(),input$(min(255,loc(#3)),#3)
    if LLen(inbuf())>15 then
          if LInstr(inbuf(),"WIFI GOT IP") then
            connected=1 'set that we have got a connection
            exit DO          
          endif 
    endif
  loop
  close #3 'clear the buffer
  print "Reopening COM1"
'  open "com"+commportno+":115200,4096" as #3
'  open "com"+commportno+":57600,4096" as #3
  open "com"+commportno+":9600,4096" as #3
  print #3,"+++"; 'ensure the ESP is in command mode
  pause 500
  IF NOT Command("AT",500) THEN : END : endif  'If not responding to AT we have a problem
  if not connected then
    IF NOT Command("AT+RST",10000,"WIFI GOT IP") THEN 'software reset and check for valid connection
      PRINT "Set up WIFI on SSID: ",SSID$
      IF NOT Command("AT+CWMODE_DEF=1",5000) THEN END 'set device mode (1=client, 2=AP, 3=both)
      IF NOT Command("AT+CWLAP",30000) THEN END 'scan for WiFi hotspots
      longstring print inbuf() 'output the list of valid networks
      ' AT+CWJAP="Omnibus-Av2","amber1977"
      IF NOT Command("AT+CWJAP_DEF="+SSID$+","+SSIDPassword$,20000,"WIFI GOT IP") THEN END 'connect
      IF NOT Command("AT+CIFSR",5000) THEN END 'check IP address
    ENDIF
  else
  endif
  IF NOT Command("AT+CIPMUX=1",5000) THEN : END : endif
  IF NOT Command("AT+CIPSERVER=1,"+portno$,5000) THEN END ' const portno$="1234"
  print "Getting IP: ";
  IF Command("AT+CIFSR",5000) THEN  'check IP address
      iPos=LInstr(inbuf(),quote,1) ' opening quote
      if iPos > 0 then
        jPos=LInstr(inbuf(),quote,iPos+1) ' closing quote
        if jPos > 0 then
          print LGetStr$(inbuf(),iPos+1,jPos-iPos-1);
        endif
      endif
  endif
  Print ""
  Print "Connected"
'  ds18B20 start dspin,3 'start a new temperature conversion
'  pause 1000
  outsidetemp=cint(tempr(dspin)*10) 'read the temperature from the last conversion
'  print "Temperature: "+outtemp$(outsidetemp)+degree$
  print "Temperature: "+outtemp$(outsidetemp)+"C"
  
main:
  DO
    outsidetemp=cint(tempr(dspin)*10) 'read the temperature from the last conversion
'    currenttemp=cint(bme280_read_temp()*10)
'    pressure=cint(10*bme280_read_pressure()*(((1-(altitude*0.0065)/(currenttemp/10+0.0065*altitude+273.15)))^-5.257))
'    humidity=cint(bme280_read_humidity())
    updateheater
    tempr start dspin,3 'start a new temperature conversion
    maxmin 'update the maximum and minimum and save them if changed
    if ReadRequest(waittime) then 'process HTML request
      htmlRequest$ = parsehtmldata$(nparams)
      print "nparams: ";nparams;": |";htmlRequest$;"|"
'      pageX$=ucase$(parsehtmldata$(nparams)) 'parse the html request and get the page requested
'      pageX$=ucase$(htmlRequest$) 'parse the html request and get the page requested
      pageX$=htmlRequest$ 'parse the html request and get the page requested
      pageX$= "INDEX" ' force
      if pageX$<>"" then 'real request so do something
        firstSend = 1 ' LB print first buffer of html code sent
        if pageX$= "INDEX" then
          drawpage
        elseif pageX$="D" then
          if nparams<>0 then 'we have parameters to process
            if arg$(0,0)="S" and arg$(1,0) = password$ then
              if arg$(0,1)="C" and arg$(1,1)="R" then 'reset the max min to current
                maxtemp=currenttemp
                mintemp=currenttemp
                maxoutsidetemp=outsidetemp
                minoutsidetemp=outsidetemp
                maxpressure=pressure
                minpressure=pressure
                maxhumidity=humidity
                minhumidity=humidity
                var save setpoint, maxtemp, mintemp, maxoutsidetemp, minoutsidetemp, minhumidity,maxhumidity, minpressure, maxpressure
              endif
              if arg$(0,1)="R" then 'change the setpoint and update the heater if applicable
                setpoint=asc(arg$(1,1))
                var save setpoint, maxtemp, mintemp, maxoutsidetemp, minoutsidetemp, minhumidity,maxhumidity, minpressure, maxpressure
                updateheater
              endif
            endif
          endif
          drawpage
        elseif pageX$="A" then
          sendText "HTTP/1.1 200 OK"+crlf+"Content-type: text/html"+crlf+"Connection: close"+crlf+crlf
          firstSend = 1
          sendText title$+"Bingo!</body></html>"+crlf+crlf
        else
          SendText pnf$+crlf+crlf'invalid page
        endif
        EndSend 'clear the write buffer and terminate the write
      endif
    endif
  LOOP
' end
  '
sub maxmin()
  local integer update=off
  if pressure>maxpressure then
    maxpressure=pressure
    update=on
  endif
  if pressure<minpressure then
    minpressure=pressure
    update=on
  endif
  if humidity>maxhumidity then
    maxhumidity=humidity
    update=on
  endif
  if humidity<minhumidity then
    minhumidity=humidity
    update=on
  endif
  if outsidetemp>maxoutsidetemp then
    maxoutsidetemp=outsidetemp
    update=on
  endif
  if outsidetemp<minoutsidetemp then
    minoutsidetemp=outsidetemp
    update=on
  endif
  if currenttemp>maxtemp then
    maxtemp=currenttemp
    update=on
  endif
  if currenttemp<mintemp then
    mintemp=currenttemp
    update=on
  endif
' LB  if update then var save setpoint, maxtemp, mintemp, maxoutsidetemp, minoutsidetemp, minhumidity,maxhumidity, minpressure, maxpressure
end sub
  
Function parsehtmldata$(paramcount as integer)
  local a$,b$
  local integer buf(Maxlen\4) ' long string
  local integer inpos,startparam,processargs
    paramcount=0
  longstring print inbuf() ' LB 190215
  inpos=LInstr(inbuf(),"GET /",1)
  parsehtmldata$="INDEX"
  if inpos=0 then
    parsehtmldata$=""
  else
    LONGSTRING MID buf(),inbuf(),inpos+5, llen(inbuf())-(inpos+5)
    inpos=LInstr(buf(),starttext$,1)
    If inpos>2 Then 'page request found
      inpos=inpos-2
      a$=LGetStr$(buf(),1,inPos)
      inpos=Instr(a$,"?")
      If inpos<>0 Then 'parameters found
        processargs=1
        parsehtmldata$=Left$(a$,inpos-1)
        a$=Mid$(a$,inpos+1)
        Do
          arg$(0,paramcount)=""
          arg$(1,paramcount)=""
          inpos=Instr(a$,"=")
          startparam=1
          arg$(0,paramcount)=Mid$(a$,startparam,inpos-startparam)
          startparam=inpos+1
          inpos=Instr(a$,"&")
          If inpos<>0 Then
            arg$(1,paramcount)=Mid$(a$,startparam,inpos-startparam)
            a$=Mid$(a$,inpos+1)
            paramcount=paramcount+1
          Else
            arg$(1,paramcount)=Mid$(a$,startparam)
            paramcount=paramcount+1
            processargs=0
          EndIf
        Loop while processargs
      Else
        parsehtmldata$=a$
      EndIf
    Else ' no page requested
      parsehtmldata$="INDEX"
    EndIf
  endif
End Function
  
sub updateheater
  local integer hcalc
  if setpoint=asc("L") then
    pin(relaypin)=ON
    heater=on
  endif
  if setpoint=asc("A") then
    pin(relaypin)=OFF
    heater=oFF
  endif
  if setpoint>=asc("B") and setpoint<=asc("K") then
    hcalc=(setpoint-asc("B")+starttemp)*10 'setpoint temperature * 10
    hcalc = hcalc + hysteresis
    if currenttemp>=hcalc then 'turn heating off
      pin(relaypin)=OFF
      heater=oFF
    endif
    hcalc = hcalc - hysteresis - hysteresis
    if currenttemp<=hcalc then 'turn heating on
      pin(relaypin)=ON
      heater=oN
    endif
  endif
end sub
  
sub drawpage
  local integer loopcounter,tempconvert
  local b$
  sendText "HTTP/1.1 200 OK"+crlf+"Content-type: text/html"+crlf+"Connection: close"+crlf+crlf
  sendText title$
  sendtext form$+hh2$+code$
  sendText tstart$+heat$
  if heater then
    sendText hon$+tend$
  else
    sendText hoff$+tend$
  endif
  sendText tstart$
  sendText hh3$
  b$=s1$+outtemp$(currenttemp)+degree$+"<TD>"+str$(humidity)+"</TD><TD>"+outtemp$(pressure)+"</TD><TD>"+outtemp$(outsidetemp)+degree$
  sendText b$
  b$=s2$+outtemp$(maxtemp)+degree$+"<TD>"+str$(maxhumidity)+"</TD><TD>"+outtemp$(maxpressure)+"</TD><TD>"+outtemp$(maxoutsidetemp)+degree$
  sendText b$
  b$=s3$+outtemp$(mintemp)+degree$+"<TD>"+str$(minhumidity)+"</TD><TD>"+outtemp$(minpressure)+"</TD><TD>"+outtemp$(minoutsidetemp)+degree$
  sendText b$
  sendText tend$
  sendText check$
  sendText tstart$
  sendText s4$
  for loopcounter=asc("A") to asc("L")
    if loopcounter=setpoint then
      sendText s5$+chr$(loopcounter)
    else
      sendText s6$+chr$(loopcounter)
    endif
    sendText click$
    tempconvert=loopcounter-asc("B")+starttemp
    if loopcounter>asc("A") and loopcounter<asc("L") then sendText str$(tempconvert,2)+degree$
    if loopcounter=asc("A") then sendText offstr$
    if loopcounter=asc("L") then sendText onstr$
  next loopcounter
  sendText tend$
  sendText ending$+crlf+crlf
end sub
  '
function outtemp$(t as integer)
  local integer tenths=t mod 10
  local integer units= t\10
  outtemp$=str$(units,3)+"."+chr$(tenths+48)
end function
  '
sub EndSend
  local b$
  b$="AT+CIPSEND="+CHR$(IPDno+48)+","+STR$(len(obuff$)) 'send anything still in the buffer
  IF NOT Command(b$,500,">") THEN
    if LInstr(inbuf(),"link is not valid") then exit sub
  endif
  IF NOT Command(obuff$,500) THEN END
  pause 200 ' LB 170303
  IF NOT Command("AT+CIPCLOSE="+CHR$(IPDno+48),500) THEN
    if LInstr(inbuf(),"UNLINK") then
      obuff$=""
      exit sub
    else
      end
    endif
  endif
  obuff$=""
end sub

sub SendText(a$)
  local b$
  if firstSend = 1 then 
    firstSend = 0
    print a$
  endif
  if len(a$)+len(obuff$)< 240 then 'add the new string to the output buffer
    obuff$=obuff$+a$
  else 'too big to fit so send the current output buffer
    b$="AT+CIPSEND="+CHR$(IPDno+48)+","+STR$(len(obuff$))
    IF NOT Command(b$,500,">") THEN
      if LInstr(inbuf(),"link is not valid") then exit sub
    endif
    IF NOT Command(obuff$,500) THEN END
    obuff$=a$
  endif
end sub
'
FUNCTION ReadRequest(timeout%) as integer
  ReadRequest=0
  LONGSTRING CLEAR inbuf()
  timer=0
  do while TIMER<timeout% and LOC(#3)=0
  loop
  pause 200
  if TIMER>=timeout% then exit function
  do while loc(#3)<>0
    LONGSTRING APPEND inbuf(),input$(min(255,loc(#3)),#3)
  loop
  if (NOT LInstr(inbuf(),"favicon",0)) and (NOT LInstr(inbuf(),"CONNECT FAIL",1)) then ReadRequest=1 'junk the favicon requests and disconnects
  IF LInstr(inbuf(),"IPD,0",1) then IPDno=0
  IF LInstr(inbuf(),"IPD,1",1) then IPDno=1
end function
'
FUNCTION Command(AT$, timeout%, other$) as integer 'send a command and wait for the answer
local i%=0,j%
Local a$
Command=0
LONGSTRING CLEAR inbuf()
print #3,AT$+crlf;
TIMER=0
i%=0
do
  if TIMER>timeout% then
    Print "Timeout : "+AT$
    EXIT DO
  endif
  j%=LOC(#3)
  if j%>0 then
    i%=i%+min(255,j%)
    LONGSTRING APPEND inbuf(),input$(min(255,j%),#3)
    if LLen(inbuf())>4 and other$="" then
      if LInstr(inbuf(),"OK",1) then
        Command=1
        exit DO
      endif
    endif
    if LLen(inbuf())>7 then
      if LInstr(inbuf(),"ERROR",1) then
        Print "ERROR : "+AT$
        exit DO
      endif
    endif
    if LLen(inbuf())>len(other$)+2 then
      if LInstr(inbuf(),other$,1) then
        Command=1
        exit DO
      endif
    endif
  endif
loop
end function

function  bme280_read_temp() as float   
  local integer var1,var2,adc_T   
  local adc%(2)   
  i2c write BME280_ADDRESS,1,1,BME280_REGISTER_TEMPDATA   
  i2c read BME280_ADDRESS,0,3,adc%()   
  adc_T=((adc%(0)<<16) OR (adc%(1)<<8) or adc%(2))>>4   
  var1  = ((((adc_T>>3) - (T1 <<1))) * T2) \ q(11)   
  var2  = (((((adc_T>>4) - (T1)) * ((adc_T\ q(4)) - (T1))) \ q(12)) * (T3)) \ q(14)   
  t_fine = var1 + var2   
  bme280_read_temp = ((t_fine * 5 + 128) \ q(8))/100.0   
end function   

function  bme280_read_pressure() as float   
  local integer var1, var2, adc_P, p   
  local adc%(2)   
  i2c write BME280_ADDRESS,1,1,BME280_REGISTER_PRESSUREDATA   
  i2c read BME280_ADDRESS,0,3,adc%()   
  adc_P=((adc%(0)<<16) OR (adc%(1)<<8) or adc%(2))>>4   
  var1 = t_fine - 128000   
  var2 = var1 * var1 * P6   
  var2 = var2 + ((var1 * P5)<<17)   
  var2 = var2 + (P4 << 35)   
  var1 = ((var1 * var1 * P3)\ q(8)) +    ((var1 * P2)<<12)   
  var1 = ((1<<47)+var1)*P1\ q(33)   
  if var1 = 0 THEN   
    bme280_read_pressure =  0' avoid exception caused by division by zero   
    exit function   
  endif   
  p = 1048576 - adc_P   
  p = (((p<<31) - var2)*3125) \ var1   
  var1 = (P9 * (p\ q(13)) * (p\ q(13))) \ q(25)   
  var2 = (P8 * p) \ q(19)   
  p = ((p + var1 + var2) \ q(8)) + (P7<<4)   
  bme280_read_pressure = p/25600.0   
end function   
'   
function  bme280_read_humidity() as float   
  local integer v_x1,adc_H   
  local adc%(1)   
  i2c write BME280_ADDRESS,1,1,BME280_REGISTER_HUMIDDATA   
  i2c read BME280_ADDRESS,0,2,adc%()   
  adc_H=(adc%(0)<<8) or adc%(1)   
  v_x1 = t_fine - 76800   
  v_x1=(((((adc_H<<14)-((H4)<<20)-(H5*v_x1))+16384)\ q(15))*(((((((v_x1*H6)\ q(10))*(((v_x1*H3)\ q(11))+32768))\ q(10))+2097152)*H2+8192)\ q(14)))   
  v_x1 = (v_x1 - (((((v_x1 \ q(15)) * (v_x1 \ q(15))) \ q(7)) * (H1)) \ q(4)))   
  if v_x1< 0 then v_x1 = 0   
  if v_x1 > 419430400 then v_x1= 419430400   
  bme280_read_humidity = (v_x1\ q(12)) / 1024.0   
end function   

sub bme280_init   
  local i%,cal%(17)   
  i2c open 400,1000 '400KHz bus speed   
  i2c write BME280_ADDRESS,1,1,BME280_REGISTER_CHIPID   
  i2c read BME280_ADDRESS,0,1,i%   
  if i%<>&H60 then print "Error BME280 not found"   
  '   
  i2c write BME280_ADDRESS,1,1,BME280_REGISTER_T1   
  i2c read BME280_ADDRESS,0,6,cal%()   
  T1=cal%(0) OR (cal%(1)<< 8)   
  T2=cal%(2) OR (cal%(3)<< 8):   if T2 and s16b then T2=T2 OR s16 'sign extend if required   
  T3=cal%(4) OR (cal%(5)<< 8):   if T3 and s16b then T3=T3 OR s16  
  '   
  i2c write BME280_ADDRESS,1,1,BME280_REGISTER_P1   
  i2c read BME280_ADDRESS,0,18,cal%()   
  P1=cal%(0) OR (cal%(1)<<8)   
  P2=cal%(2) OR (cal%(3)<<8):   if P2 and s16b then P2=P2 OR s16 'sign extend if required   
  P3=cal%(4) OR (cal%(5)<<8):   if P3 and s16b then P3=P3 OR s16 
  P4=cal%(6) OR (cal%(7)<<8):   if P4 and s16b then P4=P4 OR s16  
  P5=cal%(8) OR (cal%(9)<<8):   if P5 and s16b then P5=P5 OR s16 
  P6=cal%(10) OR (cal%(11)<<8):   if P6 and s16b then P6=P6 OR s16 
  P7=cal%(12) OR (cal%(13)<<8):   if P7 and s16b then P7=P7 OR s16 
  P8=cal%(14) OR (cal%(15)<<8):   if P8 and s16b then P8=P8 OR s16 
  P9=cal%(16) OR (cal%(17)<<8):   if P9 and s16b then P9=P9 OR s16 
  '   
  i2c write BME280_ADDRESS,1,1,BME280_REGISTER_H1   
  i2c read BME280_ADDRESS,0,1,H1   
  i2c write BME280_ADDRESS,1,1,BME280_REGISTER_H2   
  i2c read BME280_ADDRESS,0,7,cal%()   
  H2=cal%(0) OR (cal%(1)<< 8):   if H2 and s16b then H2=H2 OR s16 'sign extend if required   
  H3=cal%(2)   
  H6=cal%(6):   if H6 and s8b then H6=H6 OR s8 'sign extend if required   
  H4=(cal%(3)<<4) OR (cal%(4) and &H0F): if H4 and s12b then H4=H4 OR s12 'sign extend if required   
  H5=(cal%(5)<<4) OR (cal%(4)>>4):  if H5 and s12b then H5=H5 OR s12 
  '   
  i2c write BME280_ADDRESS,0,2,BME280_REGISTER_CONTROLHUMID,&H05 '16x oversampling humidity 
  i2c write BME280_ADDRESS,0,2,BME280_REGISTER_CONTROL,&HB7      '16x oversampling pressure/temp, normal mode    
  '   
end sub   
' 
function q(x as integer) as integer  'returns 2 raised to the power   
  q=(1<<x)   
End Function  

