' sensors.bas
' For rotary see https://www.thebackshed.com/forum/ViewTopic.php?TID=10568&PID=124755#124755
'   but also corrected "rint" in post below
option default integer
dim integer i,j,k,l,m,n,iCol,iRow,x,y,iBtnFG,iBtnBG,kBtnBG=RGB(red),kBtnFG=RGB(yellow)
dim integer lastBtn, maxSensor=15, tmr1, tmr2, tLDR, MOVED, iSnsr, pico
dim integer iDistance, lastDist
Dim integer focusBtn, focusBtnFG, focusBtnBG, tickState, tick, lastTick, fastTick, lastFast
dim integer lastPot
Dim integer btnCol_x(maxSensor+1),btnRow_y(maxSensor+1),btnTick(maxSensor+1)
Dim integer btnStates(maxSensor+1)=(0,0,0,0,0,8,4,0,0,0,101, 0,40, 0, 0, 0, 0)
'                                     1 2 3 4 5 6 7 8 9  10 11 12 13 14 15

dim string a,b,c,d,e,f,g,h,s,lastSecond$
dim float fLDR
const false=0
const true=1
  const MCP23017addr = &h20 ' A2, A1, A0, R/W all connected to 0V
  const IODIRA = &h00 ' Port A IO Direction register DEFAULT = I/P
  const IODIRB = &h01 ' Port B IO Direction register DEFAULT = I/P
  const IOCON = &h0A ' IO Expander config register - address &h0B accesses the same register
  const GPIOA = &h12 ' Port A General purpose register
  const GPIOB = &h13 ' Port B General Purpose register
  const OLATA = &h14 ' Port A latch register
  const OLATB = &h15 ' Port B latch register
  const GPUPB = &h0D ' Port B pull-up register
  SetPin 1,I2C0sda
  SetPin 2,I2C0scl
'do: mcp17: inc tick: pause 250: ?tick mod 2: loop
SetPin 21,uart0tx:SetPin 22,uart0rx : Open "com0:9600" As #1 
'
dim string sensors(16) length 15 = ("","LDR","Buzzer","Potentiomtr", "Temperature","3-color","2-color","BM280","Acceleromtr","Vibration","Dimmer","Sound","Servo","Tilt","Ultrasonic","MCP23017","")
dim string picosnsrs(16) length 5 = ("","LDR","Buzzr","Pot", "Temp","3colr","led","B280","Accl","Vibr","Dim","Sound","Servo","Tilt","Usonc","23017","")
dim integer snsrActive(16)
const LDR=1,Buzzer=2,Potentiomtr=3,Temperature=4,c3_color=5,c2_color=6,BM280=7,Acceleromtr=8,Vibration=9,Dimmer=10,Sound=11,cServo=12,Tilt=13,Ultrasonic=14,MCP23017=15
' below for F4
if mm.device$="Colour Maximite 2" then
  dim integer in0=2 'encoder pins pulled high so should be reading high in detent positions, centre pin connected to ground
  dim integer in1=24 'swap the pin definitions as required to get the correct sense of rotation
  dim integer pRE=15 ' rotary encoder pushbutton--active low
  dim integer pR=19,pG=21,pB=23 ' RGB pins 
  dim integer pR2=11,pG2=13 ' 2-color RG pins
  dim integer pLDR=16,pBuzzer=33,pPotentiomtr=18,pTemperature=32,p3_color=0,p2_color=0,pBM280=0
  dim integer pAcceleromtr=0,pVibration=26,pDimmer=31,pSound=29,pServo=36,pTilt=12,pUltrasonic=0
  dim integer pMCP23017=0
  dim integer pCS=37 ' chip select for BM280; also indicator LED
  mode 2 ' 640x480
  
elseif mm.device$="Armmite F4" then
  dim integer in0=2 'encoder pins pulled high so should be reading high in detent positions, centre pin connected to ground
  dim integer in1=3 'swap the pin definitions as required to get the correct sense of rotation
  dim integer pRE=2 ' rotary encoder pushbutton--active low
  dim integer pR=89,pG=90,pB=91 ' RGB pins 
  dim integer pR2=64,pG2=5 ' 2-color RG pins
  dim integer pLDR=17,pBuzzer=18,pPotentiomtr=15,pTemperature=63,p3_color=0,p2_color=0,pBM280=0
  dim integer pAcceleromtr=0,pVibration=16,pDimmer=95,pSound=35,pServo=59,pTilt=31,pUltrasonic=0
  dim integer pMCP23017=0
  dim integer pCS=4 ' chip select for BM280; also indicator LED
  
elseif mm.device$="RP2040 PicoMite" then 
  dim integer in0=32 'encoder pins pulled high so should be reading high in detent positions, centre pin connected to ground
  dim integer in1=10 'swap the pin definitions as required to get the correct sense of rotation
  dim integer pRE=9 ' rotary encoder pushbutton--active low
  dim integer pR=4,pG=6,pB=5 ' RGB pins (not available with SPI LCD)
  dim integer pR2=12,pG2=12 ' 2-color RG pins (Green not available)
  
  dim integer pLDR=27 ' T_CS
  dim integer pBuzzer=26 ' D/C
  dim integer pPotentiomtr=34
  dim integer pTemperature=11,p3_color=0,p2_color=0,pBM280=0
  dim integer pAcceleromtr=14
  dim integer pVibration=29 ' T_IRQ
  dim integer pDimmer=17,pSound=31
  dim integer pServo=25 ' RST
  dim integer pTilt=34,pUltrasonic=0
  dim integer pMCP23017=0
  dim integer pCS=4 ' chip select for BM280; also indicator LED
  for i=1 to maxSensor: sensors(i)=uCase$(picosnsrs(i)): next i
  x=0: y=0: cls: font 1: iCol=0: iRow=0
  for i=1 to maxSensor ' 3 colums of 5 char+space, 4 char+space, 5 char
    text x,y,sensors(i)
    btnRow_y(i)=y
    btnCol_x(i)=x
    y=y+mm.fontheight
    if i=5 then
      y=0: x=x+mm.fontwidth*6: iCol=iCol+1: iRow=0
    elseif i=10 then
      y=0: x=x+mm.fontwidth*5: iCol=iCOl+1: iRow=0
    endif
  next i
  pico=true
endif
setpin pR2,dout
setpin pR,dout: setpin pG,dout: setpin pB,dout
setpin pBuzzer,dout:  'setpin pTemperature,din
setpin pDimmer,dout: setpin pSound,din: ' setpin pTilt,din,pullup
setpin pCS,dout
setpin pTilt,dout
if instr(mm.device$,"Pico") then 
'  setpin pVibration,ain: setpin pLDR,ain: setpin pG2,dout
'  setpin 16, PWM6A
  setpin pDimmer, PWM6B
  setpin pServo,PWM1B
  SetPin 1,I2C0sda
  SetPin 2,I2C0scl
  setpin pPotentiomtr,ain ' xferred to pTilt, 34
  setpin 19,dout: setpin 20,dout: setpin 16,dout: setpin 24,dout
endif
const cTurquoise=rgb(64,224,208)
dim integer nBlack
if mm.device$="Colour Maximite 2" then: nBlack=NOTBLACK: else: nBlack=rgb(black): endif
'
init:
setpin in0,intB,rint 'enable interrupts on both edges of both pins
setpin in1,intB,rint
setpin pRE,din,pullup
rotatedright=false
rotatedleft=false
resetenc=true
value=0 ' sensor pushbutton number
lastvalue=0
' print value
if not instr(mm.device$,"Pico") then cls
iBtnFG=kBtnFG:iBtnBG=kBtnBG
'lastBtn=0
'snsrActive(3)=1
'for i=1 to 15
'  focusOn (i)
''  if instr(mm.device$,"Pico") then pause 2000
'next i
focusOn (1)
lastBtn=1
focusBtn=1
iBtnFG=kBtnBG:iBtnBG=kBtnFG
MOVED=0
settick 100,blink ' blink the button which has the focus every half second
'
'do: loop
MAIN:
  Do
    if value <> lastvalue then
      if value > 0 and value < 16 then
'         print "Encoder: ";value
        MOVED=1 ' focus changed
        focusOn (value)
        lastvalue=value
        MOVED=0
      endif
    endif
    if pin(pRE) = 0 then
      snsrActive(value)=1 xor snsrActive(value) ' toggle the active state
      focusOn (value)
      tmr1=timer+8000 ' eight seconds to time out
      pause 50 ' debounce
      do: loop until pin(pRE)=1 or timer > tmr1
      pause 50 ' debounce
    endif
'    a=mid$(time$,7,2)
'    if a<>lastSecond$ then
    if fastTick<>lastFast then
      lastFast=fastTick
      checkActive
'      lastSecond$=mid$(time$,7,2) ' allow a second (less actually) for rotary encoder
    endif
  Loop
  end

sub checkActive
  if mm.device$="Armmite F4" or instr(mm.device$,"Pico") then
    for iSnsr=1 to maxSensor ' check if we are monitoring
      if snsrActive(iSnsr)=1 then
        if not pico then text mm.hres/3*2,mm.vres/8,sensors(iSnsr),,2,,nBlack,cTurquoise

        select case iSnsr
 
          case LDR: ' show LDR changes to tenths of a volt (change of at least 2 tenths)
            if pico then 
              print "analog input not available for LDR on PicoMite"
              pin(pBuzzer)=1: pause 1000: pin(pBuzzer)=0
            else
              print "Rework LDR code for 100ms tick state machine"
              pin(pBuzzer)=1: pause 1000: pin(pBuzzer)=0
              tmr2=timer+3000
              j=-2
              do
                k=pin(pLDR)*10: if abs(k-j) > 1 then
                  j=k: a=str$(j/10,1,1)
                  if pico then: 
                  else: text mm.hres/3*2,mm.vres/8*1.8,a,,2,,nBlack,cTurquoise: endif
                endif
              loop until timer > tmr2
              if pico then
              else: text mm.hres/3*2,mm.vres/8*1.8,a,,2,,nBlack,nBlack: endif
            endif

          case Buzzer ' 2
           if tick<>lastTick then ' every half second
             pin(pBuzzer)=1-pin(pBuzzer)
           endif

          case Potentiomtr ' 3
              for j=1 to 10: k=pin(pPotentiomtr)*100: if k then: exit for: endif: next j
              if k<10 then k=0
              if abs(k-lastPot) > 9 then
                lastPot=k: a=str$(lastPot,3)
                ?a+" ";
                if not pico then text mm.hres/3*2,mm.vres/8*1.8,a,,2,,nBlack,cTurquoise           
              endif
              if snsrActive(Dimmer)=0 then ' if dimmer not active, control LED with POT
                PWM 6,1000,,lastPot/3.3 ' scale 0-330 to 0-100
              endif
'              if not pico then text mm.hres/3*2,mm.vres/8*1.8,a,,2,,nBlack,nBlack

          Case c3_color ' 5 RGB pins F4: 89,90,91
'            ?"RGB ";
           if tick<>lastTick then ' every half second
            Select Case btnTick(iSnsr)
              Case 1: Pin(pR)=1
              Case 2: Pin(pR)=0: Pin(pG)=1
              Case 3: Pin(pG)=0: Pin(pB)=1
              Case 4: Pin(pB)=0: Pin(pR)=1: Pin(pG)=1
              Case 5: Pin(pG)=0: Pin(pB)=1
              Case 6: Pin(pR)=0: Pin(pG)=1
              Case 7: Pin(pR)=1
              Case 8: Pin(pR)=0: Pin(pG)=0: Pin(pB)=0
            End Select
            Inc btnTick(iSnsr)
           endif

          Case c2_color ' 6 RG pins 64,5 -- 2-color LED
           if tick<>lastTick then ' every half second
            Select Case btnTick(iSnsr)
              Case 1: Pin(pR2)=1
              Case 2: Pin(pR2)=0: Pin(pG2)=1
              Case 3: Pin(pR2)=1
              Case 4: Pin(pR2)=0: Pin(pG2)=0
            End Select
           endif

          Case BM280 ' 7 BMP280 (but flash pins)
           if tick<>lastTick then ' every half second
             if pico then
               if tick mod 2 then
                 pin(19)=1: pin(20)=0: pin(16)=0: pin(24)=1
               else
                 pin(19)=0: pin(20)=1: pin(16)=1: pin(24)=0
               endif
             endif
           endif

          Case Dimmer ' 10 PWM 2B IRF520 mosfet module (replace with IRL520, IRL
'            for j=0 to 100: pwm 2,1000,0,j:pause 50: next
'            for j=0 to 100: pwm 2,1000,0,100-j:pause 50: next j
'            pwm 2,stop
             if pico then
               If btnTick(iSnsr) < 50 Then
                 PWM 6,1000,,btnTick(iSnsr)*2
               ElseIf btnTick(iSnsr) < 100 Then
                 PWM 6,1000,,200-btnTick(iSnsr)*2
               Else
'                 PWM 6,off
               EndIf
             else
               If btnTick(iSnsr) < 100 Then
                 PWM 2,1000,0,btnTick(iSnsr)
               ElseIf btnTick(iSnsr) < 200 Then
                 PWM 2,1000,0,200-btnTick(iSnsr)
               Else
                 PWM 2,stop
               EndIf
             endif
             Inc btnTick(iSnsr)

          case cServo ' 12
            j=btnTick(iSnsr)
            if j < 21 Then
              PWM 1,50,,5+j*.25 ' ramp up
'              ?5+j*.25;" ";
            else
              PWM 1,50,, 10-(j-20)*.25 ' ramp down
'              ?10-(j-20)*.25;" ";
            endif
             Inc btnTick(iSnsr)
'            for j=8 to 22: servo 2,50,j/10: pause 50: next j
'            for j=22 to 8 step -1: servo 2,50,j/10: pause 50: next j          

          case Tilt ' 13
            if pin(pTilt)=0 then
              if tick<>lastTick then
                pin(pCS)=1-pin(pCS)
              endif
'              for j=1 to 5: pin(pCS)=1:pause 200: pin(pCS)=0:pause 200: next j
            endif

          case Ultrasonic ' 14
            if tick<>lastTick then
              if loc(#1)>12 then ' one complete distance available: D:nnn centimeters
                a=input$(254,#1)
                i=1: do: k=i: i=i+1: i=instr(i,a,chr$(13)): loop until i=0 ' find last CR
                if k>5 then
                  b=mid$(a,k-3,3)
                  if b<>"---" then
                    iDistance=val(b)
                    if lastDist<>iDistance then
                      lastDist=iDistance
                      print "dist="+b+"cm; ";
                    endif
                  endif
                endif
              endif
            endif

          case MCP23017 ' 15
           if tick<>lastTick then mcp17 ' every half second
'            mcp17_2

        end select
        if not pico then text mm.hres/3*2,mm.vres/8,sensors(iSnsr),,2,,nBlack,nBlack ' erase sensor name
      endif
      if btnTick(iSnsr)>btnStates(iSnsr) then btnTick(iSnsr)=1
    next iSnsr
  endif
end sub

sub focusOn(iButton as integer)
  static integer x,y
  focusBtn=iButton
  tickState=1
  if instr(mm.device$,"Pico") then
'    ?"Button ";iButton;" ";lastBtn;" ";snsrActive(iButton);" ";snsrActive(lastBtn)
    if iButton then
      if snsrActive(lastBtn)=1 then ' highlight
        text x,y,sensors(lastBtn),,,,0,1 ' inverted (black on white)
      else
        iCol=fix((lastBtn-1)/5) ' truncate (round down) 0-2
        iRow=fix((lastBtn-1) mod 5) ' truncate (round down) 0-4
        if iCol=0 then: x=0: elseif iCol=1 then: x=6*mm.fontwidth: else: x=11*mm.fontwidth: endif
        y=iRow*mm.fontheight
        text x,y,sensors(lastBtn) ' white on black
      endif
      iCol=fix((iButton-1)/5) ' truncate (round down)
      iRow=fix((iButton-1) mod 5) ' truncate (round down)
      if iCol=0 then: x=0: elseif iCol=1 then: x=6*mm.fontwidth: else: x=11*mm.fontwidth: endif
      y=iRow*mm.fontheight
      text x,y,sensors(iButton) 
      lastBtn=iButton
    endif
    exit sub
  endif ' end of Pico
'if mm.device$="Colour Maximite 2" then
'else ' F4
'  GUI Button pb_test, "TEST", 125, 200, 70, 25,RGB(yellow), RGB(red)
    if MOVED then
      on error skip
      if snsrActive(lastBtn)=0 then
        if mm.device$="Colour Maximite 2" then
          a=space$((20-len(sensors(lastBtn)))/2)+sensors(lastBtn)
          a=a+space$(20-len(a))
          text x,y,a,,2,,kBtnFG, kBtnBG
        else
          GUI Delete lastBtn
          GUI Button lastBtn, sensors(lastBtn), x, y, 95, 25, kBtnFG, kBtnBG
        endif
      endif
      lastBtn=iButton
    endif
    iCol=fix((iButton-1)/5) ' truncate (round down)
    iRow=fix((iButton-1) mod 5) ' truncate (round down)
    x=iCol*(mm.hres/3)+(mm.hres/50)
    y=iRow*(mm.vres/8)+(mm.vres/3)
    on error skip
    if mm.device$="Armmite F4" then GUI Delete iButton
    if snsrActive(iButton)=1 then
      if mm.device$="Armmite F4" then
        GUI Button iButton, sensors(iButton), x, y, 95, 25, kBtnFG, RGB(green)
      else
        a=space$((20-len(sensors(iButton)))/2)+sensors(iButton)
        a=a+space$(20-len(a))
        text x,y,a,,2,,kBtnFG, RGB(green)
      endif
    else
      if mm.device$="Armmite F4" then
        GUI Button iButton, sensors(iButton), x, y, 95, 25, iBtnFG, iBtnBG
      else
        a=space$((20-len(sensors(iButton)))/2)+sensors(iButton)
        a=a+space$(20-len(a))
        text x,y,a,,2,,iBtnFG, iBtnBG
      endif
    endif
'  endif
end sub

sub rint ' rotary encoder interrupt
' code: https://www.thebackshed.com/forum/ViewTopic.php?TID=10568&PID=124755#124755
' from matherp & goc
rint2:
pin0=NOT pin(in0) 'reverse sense to get positive logic
pin1=NOT pin(in1)
if pin0 then
if pin1 and not resetenc then 'in0 and in1 both active
if rotatedleft and not rotatedright then
value=fix(max(1,value-1)) ' minimum of 1
rotatedleft=false
endif
if rotatedright and not rotatedleft then
value=fix(min(maxSensor,value+1))
rotatedright=false
endif
else 'only in0 active
if resetenc and not rotatedleft then
rotatedright=true
resetenc=false
endif
endif
else
if pin1 then 'only in1 active
if resetenc and not rotatedright then
rotatedleft=true
resetenc=false
endif
else 'both off so reset
rotatedleft=false
rotatedright=false
resetenc=true
endif
endif
if pin(in0)=pin0 or pin(in1)=pin1 then goto rint2 're-enter if another change has happened almost immediately
end sub

sub MCP17
static MCPfirstpass=1
  if MCPfirstpass then
    print "initializing mcp23017 at ";MCP23017addr
    MCPfirstpass=0
'    if pico then SetPin 1,I2C0sda: SetPin 2,I2C0scl
    I2C open 100, 1000
    I2C WRITE MCP23017addr,0,2,IODIRA,0 ' set direction to output
    I2C WRITE MCP23017addr,0,2,IODIRB,0 ' set direction to output
'    I2C WRITE MCP23017addr,0,2,IODIRB,&HFF ' set direction to input
  endif
'  print "write to mcp23017"
'  for i = 1 to 6 
  if tick mod 2 then
    I2C Write MCP23017addr,0,2,OLATA,&b10101010 '  
    I2C Write MCP23017addr,0,2,OLATB,&b01010101 '  
'    PAUSE     250 
   else
    I2C Write MCP23017addr,0,2,OLATA,&b01010101 '  
    I2C Write MCP23017addr,0,2,OLATB,&b10101010 '
  endif  
'    PAUSE     250 
'  Next i 
'  I2C Write MCP23017addr,0,2,OLATA,0 ' turn all off
end sub

sub MCP17_2 
static MCP2firstpass=1
if instr(mm.device$,"Pico") then
  if MCP2firstpass then
'    print "initializing mcp23017"
    MCP2firstpass=0
'    I2C open 100, 1000
    I2C WRITE MCP23017addr,0,2,IODIRA,0 ' set direction to output
    I2C WRITE MCP23017addr,0,2,IODIRB,&HFF ' set direction to input
  endif
'  print "write to mcp23017"
  for i = 1 to 6 
    I2C Write MCP23017addr,0,2,OLATA,&b10101010 '  
    PAUSE     250 
    I2C Write MCP23017addr,0,2,OLATA,&b01010101 '  
    PAUSE     250 
  Next i 
  I2C Write MCP23017addr,0,2,OLATA,0 ' turn all off
else
  if MCP2firstpass then
    print "initializing mcp23017"
    MCP2firstpass=0
    I2C2 open 100, 1000
    I2C2 WRITE MCP23017addr,0,2,IODIRA,0 ' set direction to output
    I2C2 WRITE MCP23017addr,0,2,IODIRB,&HFF ' set direction to input
  endif
  print "write to mcp23017"
  for i = 1 to 6 
    I2C2 Write MCP23017addr,0,2,OLATA,&b10101010 '  
    PAUSE     250 
    I2C2 Write MCP23017addr,0,2,OLATA,&b01010101 '  
    PAUSE     250 
  Next i 
  I2C2 Write MCP23017addr,0,2,OLATA,0 ' turn all off
endif
end sub

sub blink ' settick interrupt every half second
  Inc fastTick
  lastTick=tick
  If fastTick Mod 5 = 0 Then
    Inc tick ' every half second
    If tickState Then
      If snsrActive(focusBtn) Then
        Text btnCol_x(focusBtn),btnRow_y(focusBtn),sensors(focusBtn),,,,1,1 ' te
      Else
        Text btnCol_x(focusBtn),btnRow_y(focusBtn),sensors(focusBtn),,,,0,0 ' te
      EndIf
    Else '
      If snsrActive(focusBtn) Then
        Text btnCol_x(focusBtn),btnRow_y(focusBtn),sensors(focusBtn),,,,0,1 ' te
      Else
        Text btnCol_x(focusBtn),btnRow_y(focusBtn),sensors(focusBtn),,,,1,0 ' te
      EndIf
    EndIf
    tickState=1-tickState ' toggle 0 and 1
  EndIf
end sub
