' V1.0
' Graphics library with drivers for ST7755R T18 display
'
' drawing primitives assume a graphics display where top left is point 0, 0
'
' set screen orientation: sub T18.setrot(x) ;T18_normal=normal, T18_inverse=invert, T18_rt_right=rotate right, T18_rt_left=rotate left
' draw circle: sub T18.dcirc(x0, y0, r, colour) ;x, y coordinates of centre, radius, colour
' draw filled circle: sub T18.fcirc(x0, y0, r, colour) ;x, y coordinates of centre, radius, colour
' draw triangle:  sub T18.dtri(x0, y0, x1, y1, 	x2, y2, colour) ;three coordinate pairs, colour
' draw filled triangle sub T18.ftri (x0, y0, x1, y1, x2, y2, colour) ;three coordinate pairs, colour
' print string: sub T18.pstring(xx0, yy0, text$, sz, orientation, forecolour, backcolour) ;x, y coordinates of top left of first character, text string, size, character orientation,  foreground colour,  background colour
' draw line: sub T18.dline(xx0, yy0, xx1, yy1, colour) ;x, y of start line, x, y of end line, colour
' draw rectangle: sub T18.drect(x, y, w, h, colour) ;x, y coordinate of top left, width, height, colour
' draw filled rectangle: sub T18.frect(x, y, w, h, colour) ;x, y coordinate of top left, width, height, colour
' draw rounded rectangle: sub T18.drndrect(x, y, w, h, r, colour) ;x, y coordinates of top left, width, height, radius of corner, colour
' draw filled rounded rectangle: sub T18.frndrect(x, y, w, h, r, colour) ;x, y coordinates of top left, width, height, radius of corner, colour
'
option default none
option explicit
cpu 48

T18.init
T18_test
end
'
sub T18.init
'Global "Constants"
  const T18_CS=4
  const T18_CD=5
  const T18_RESET=6
  const ST7735_NOP =&H0
  const ST7735_SWRESET =&H01
  const ST7735_RDDID =&H04
  const ST7735_RDDST =&H09
  const ST7735_SLPIN  =&H10
  const ST7735_SLPOUT  =&H11
  const ST7735_PTLON  =&H12
  const ST7735_NORON  =&H13
  const ST7735_INVOFF =&H20
  const ST7735_INVON =&H21
  const ST7735_DISPOFF =&H28
  const ST7735_DISPON =&H29
  const ST7735_CASET =&H2A
  const ST7735_RASET =&H2B
  const ST7735_RAMWR =&H2C
  const ST7735_RAMRD =&H2E
  const ST7735_COLMOD =&H3A
  DIM integer ST7735_MADCTL =&H36
  const ST7735_FRMCTR1 =&HB1
  const ST7735_FRMCTR2 =&HB2
  const ST7735_FRMCTR3 =&HB3
  const ST7735_INVCTR =&HB4
  const ST7735_DISSET5 =&HB6
  const ST7735_PWCTR1 =&HC0
  const ST7735_PWCTR2 =&HC1
  const ST7735_PWCTR3 =&HC2
  const ST7735_PWCTR4 =&HC3
  const ST7735_PWCTR5 =&HC4
  const ST7735_VMCTR1 =&HC5
  const ST7735_RDID1 =&HDA
  const ST7735_RDID2 =&HDB
  const ST7735_RDID3 =&HDC
  const ST7735_RDID4 =&HDD
  const ST7735_PWCTR6 =&HFC
  const ST7735_GMCTRP1 =&HE0
  const ST7735_GMCTRN1 =&HE1
'  
  dim integer BLACK = &H0000 ' Color definitions: 16 bit (RGB565) colour palette so these are just examples
  dim integer BLUE  = &H001F
  dim integer RED   = &HF800
  dim integer GREEN = &H07E0
  dim integer CYAN  = &H07FF
  dim integer MAGENTA=&HF81F
  dim integer YELLOW= &HFFE0 
  dim integer WHITE = &HFFFF
  dim integer T18.pix=0
  dim integer T18.ffr=1
  dim integer T18.drawchar=2
  dim integer T18.drawline=3
  dim integer T18.wcom=4
  dim integer T18.wdata=5
  dim integer T18.fastfillscreen=6
  dim integer T18_width=0 'location of width parameter in params array
  dim integer T18_height=1 'location of height parameter in params array
  dim integer T18_rotation=2 'location of rotation parameter in params array
  dim integer T18_normal=0
  dim integer T18_inverse=1
  dim integer T18_rt_right=2
  dim integer T18_rt_left=3
  dim integer T18_AddrOfFont, T18_params(3) ' Global variables
  local integer i
  spi open 10000000,3,8
  T18_Params(T18_width)=128
  T18_params(T18_height)=160
  T18_AddrOfFont=PEEK(CFunAddr FONT)  
  pin(T18_CS)=1
  setpin T18_CS, DOUT
  pin(T18_CD)=1
  setpin T18_CD, DOUT
  pin(T18_RESET)=1
  setpin T18_RESET, DOUT'  Reset the display
  pin(T18_RESET)=0
  pause 100
  pin(T18_RESET)=1
  pause 100
  i=T18draw(T18.wcom,ST7735_SWRESET)'software reset
  pause 150
  i=T18draw(T18.wcom,ST7735_SLPOUT)'out of sleep mode
  pause 500
  i=T18draw(T18.wcom,ST7735_FRMCTR1)'frame rate control - normal mode
  i=T18draw(T18.wdata,&H01)'frame rate = fosc / (1 x 2 + 40) * (LINE + 2C + 2D)
  i=T18draw(T18.wdata,&H2C) 
  i=T18draw(T18.wdata,&H2D) 
  i=T18draw(T18.wcom,ST7735_FRMCTR2)'frame rate control - idle mode
  i=T18draw(T18.wdata,&H01)'frame rate = fosc / (1 x 2 + 40) * (LINE + 2C + 2D)
  i=T18draw(T18.wdata,&H2C) 
  i=T18draw(T18.wdata,&H2D) 
  i=T18draw(T18.wcom,ST7735_FRMCTR3)'frame rate control - partial mode
  i=T18draw(T18.wdata,&H01)'dot inversion mode
  i=T18draw(T18.wdata,&H2C) 
  i=T18draw(T18.wdata,&H2D) 
  i=T18draw(T18.wdata,&H01)'line inversion mode
  i=T18draw(T18.wdata,&H2C) 
  i=T18draw(T18.wdata,&H2D) 
  i=T18draw(T18.wcom,ST7735_INVCTR)'display inversion control
  i=T18draw(T18.wdata,&H07)'no inversion
  i=T18draw(T18.wcom,ST7735_PWCTR1)'power control
  i=T18draw(T18.wdata,&HA2)'
  i=T18draw(T18.wdata,&H02)'-4.6V
  i=T18draw(T18.wdata,&H84)' Auto
  i=T18draw(T18.wcom,ST7735_PWCTR2)'power control
  i=T18draw(T18.wdata,&HC5)'VGH25 = 2.4C VGSEL = -10 VGH = 3 * AVDD
  i=T18draw(T18.wcom,ST7735_PWCTR3)'power control
  i=T18draw(T18.wdata,&H0A)'Opamp current small 
  i=T18draw(T18.wdata,&H00)'Boost frequency
  i=T18draw(T18.wcom,ST7735_PWCTR4)'power control
  i=T18draw(T18.wdata,&H8A)'BCLK/2, Opamp current small & Medium low
  i=T18draw(T18.wdata,&H2A)     
  i=T18draw(T18.wcom,ST7735_PWCTR5)'power control
  i=T18draw(T18.wdata,&H8A)'    
  i=T18draw(T18.wdata,&H2A)'     
  i=T18draw(T18.wcom,ST7735_VMCTR1)'power control
  i=T18draw(T18.wdata,&H0E)'  
  i=T18draw(T18.wcom,ST7735_INVOFF)'don't invert display
  i=T18draw(T18.wcom,ST7735_MADCTL)'memory access control (directions)
  i=T18draw(T18.wdata,&HC0)'row address/col address, bottom to top refresh
  i=T18draw(T18.wcom,ST7735_COLMOD)'set color mode
  i=T18draw(T18.wdata,&H05)'16-bit color
  i=T18draw(T18.wcom,ST7735_CASET)'column addr set
  i=T18draw(T18.wdata,&H00)
  i=T18draw(T18.wdata,&H00)'XSTART = 0
  i=T18draw(T18.wdata,&H00)
  i=T18draw(T18.wdata,&H7F)'XEND = 127
  i=T18draw(T18.wcom,ST7735_RASET)'row addr set
  i=T18draw(T18.wdata,&H00)
  i=T18draw(T18.wdata,&H00)'XSTART = 0
  i=T18draw(T18.wdata,&H00)
  i=T18draw(T18.wdata,&H9F)'XEND = 159
  i=T18draw(T18.wcom,ST7735_GMCTRP1)
  i=T18draw(T18.wdata,&H0f)
  i=T18draw(T18.wdata,&H1a)
  i=T18draw(T18.wdata,&H0f)
  i=T18draw(T18.wdata,&H18)
  i=T18draw(T18.wdata,&H2f)
  i=T18draw(T18.wdata,&H28)
  i=T18draw(T18.wdata,&H20)
  i=T18draw(T18.wdata,&H22)
  i=T18draw(T18.wdata,&H1f)
  i=T18draw(T18.wdata,&H1b)
  i=T18draw(T18.wdata,&H23)
  i=T18draw(T18.wdata,&H37)
  i=T18draw(T18.wdata,&H00)
  i=T18draw(T18.wdata,&H07)
  i=T18draw(T18.wdata,&H02)
  i=T18draw(T18.wdata,&H10)
  i=T18draw(T18.wcom,ST7735_GMCTRN1)
  i=T18draw(T18.wdata,&H0f)
  i=T18draw(T18.wdata,&H1b) 
  i=T18draw(T18.wdata,&H0f) 
  i=T18draw(T18.wdata,&H17) 
  i=T18draw(T18.wdata,&H33) 
  i=T18draw(T18.wdata,&H2c) 
  i=T18draw(T18.wdata,&H29) 
  i=T18draw(T18.wdata,&H2e) 
  i=T18draw(T18.wdata,&H30) 
  i=T18draw(T18.wdata,&H30) 
  i=T18draw(T18.wdata,&H39) 
  i=T18draw(T18.wdata,&H3f) 
  i=T18draw(T18.wdata,&H00) 
  i=T18draw(T18.wdata,&H07) 
  i=T18draw(T18.wdata,&H03) 
  i=T18draw(T18.wdata,&H10) 
  i=T18draw(T18.wcom,ST7735_DISPON)
  Pause 100
  i=T18draw(T18.wcom,ST7735_NORON)'normal display on
  pause 10
  T18.setrot(0)
  T18_fillscreen(black)
end sub
'
sub T18_fillscreen(colour as integer)
  local integer i=T18draw(T18.fastfillscreen,colour,T18_params())
end sub
'
' Generic drawing routines
'
sub T18.dcirc(x0 as integer, y0 as integer, r as integer, colour as integer) 'x, y coordinates of centre, radius
  local integer f=1-r, ddF_x=1, ddF_y=-2 * r, x=0, y=r, dp
  dp=T18draw(T18.pix, colour, x0, y0+r,  T18_params())
  dp=T18draw(T18.pix, colour, x0, y0-r,  T18_params())
  dp=T18draw(T18.pix, colour, x0+r, y0,  T18_params())
  dp=T18draw(T18.pix, colour, x0-r, y0,  T18_params())
  do while (x<y)
    if f>=0 then
  y=y-1
  ddF_y=ddF_y+2
  f=f+ddF_y
    endif
    x=x+1
    ddF_x=ddF_x+2
    f=f+ddF_x
    dp=T18draw(T18.pix, colour, x0+x, y0+y,  T18_params())
    dp=T18draw(T18.pix, colour, x0-x, y0+y,  T18_params())
    dp=T18draw(T18.pix, colour, x0+x, y0-y,  T18_params())
    dp=T18draw(T18.pix, colour, x0-x, y0-y,  T18_params())
    dp=T18draw(T18.pix, colour, x0+y, y0+x,  T18_params())
    dp=T18draw(T18.pix, colour, x0-y, y0+x,  T18_params())
    dp=T18draw(T18.pix, colour, x0+y, y0-x,  T18_params())
    dp=T18draw(T18.pix, colour, x0-y, y0-x,  T18_params())
  loop
end sub
 '
sub T18.dtri(x0 as integer, y0 as integer, x1 as integer, y1 as integer, x2 as integer, y2 as integer, colour as integer) 'three coordinate pairs
  T18.dline(x0, y0, x1, y1, colour)
  T18.dline(x1, y1, x2, y2, colour)
  T18.dline(x2, y2, x0, y0, colour)
end sub
 '
sub T18.ftri (x0 as integer, y0 as integer, x1 as integer, y1 as integer, x2 as integer, y2 as integer, colour as integer) 'three coordinate pairs
  local integer a, b, y, dp, last
  if (y0>y1) then
    swap(y0, y1)
    swap(x0, x1)
  endif
  if (y1>y2) then
    swap(y2, y1)
    swap(x2, x1)
  endif
  if (y0>y1) then
    swap(y0, y1)
    swap(x0, x1)
  endif
  if(y0=y2) then ' Handle awkward all-on-same-line case as its own thing
    a=x0
    b=x0
    if(x1<a) then
  a=x1
    else
  if(x1>b) then b=x1
    endif
    if(x2<a) then
  a=x2
    else
  if(x2>b) then b=x2
    endif
    dp=T18draw(T18.ffr, colour, a, y0, 1, b-a+1,  T18_params()) 
    exit sub
  endif
    local integer  dx01=x1-x0,  dy01=y1-y0,  dx02=x2-x0,  dy02=y2-y0, dx12=x2-x1,  dy12=y2-y1,  sa=0, sb=0
  if(y1=y2) then
    last=y1 'Include y1 scanline
  else
     last=y1-1 ' Skip it
  endif
  for y=y0 to last
    a=x0+sa \ dy01
    b=x0+sb \ dy02
    sa=sa+dx01
    sb=sb+dx02
    a=x0+(x1-x0) * (y-y0) \ (y1-y0)
    b=x0+(x2-x0) * (y-y0) \ (y2-y0)
    if(a>b) then swap(a, b)
    dp=T18draw(T18.ffr, colour, a, y, b-a+1, 1,  T18_params()) 
  next y
  sa=dx12 * (y-y1)
  sb=dx02 * (y-y0)
  do while y<=y2
    a=x1+sa \ dy12
    b=x0+sb \ dy02
    sa=sa+dx12
    sb=sb+dx02
    a=x1+(x2-x1) * (y-y1) \ (y2-y1)
    b=x0+(x2-x0) * (y-y0) \ (y2-y0)
    if(a>b) then swap(a, b)
    dp=T18draw(T18.ffr, colour, a, y, b-a+1, 1,  T18_params()) 
    y=y+1
  loop
end sub
'
sub T18.pstring(xx0 as integer, yy0 as integer, text$, sz as integer, orientation as integer, fontcolour as integer, backgroundcolour as integer) 'x, y coordinates of top left of first character, text string, size, orientation
  local integer i, c, x=xx0, y=yy0, chr0, dp
  i=1
  do while i<=len(text$)' and X>=0 and Y>=0 and X<T18_params(0) and Y<T18_params(1)
    c=asc(mid$(text$, i, 1))
    chr0=T18.Getchar(c) 'loads the character
    dp=T18draw(T18.drawchar, chr0, fontcolour, backgroundcolour, x, y, sz, orientation,  T18_params())
    on orientation+1 goto pT18_normal, pinvert, prtright, prtleft
pT18_normal:
    x=x+(6*sz)
    goto pcontinue
pinvert:
    x=x-(6*sz)
    goto pcontinue
prtright:
    y=y+(6*sz)
    goto pcontinue
prtleft:
    y=y-(6*sz)
pcontinue:
    i=i+1
  loop
  xx0=x
  yy0=y
end sub
'
sub T18.dline(xx0 as integer, yy0 as integer, xx1 as integer, yy1 as integer, colour as integer) ' x, y of start line, x, y of end line
   local integer dp=T18draw(T18.drawline, colour, xx0, yy0, xx1, yy1,  T18_params())
end sub
 '
sub swap (a% , b% )
  local  t%
  t%=b%
  b%=a%
  a%=t%
end sub
 '
sub T18.drect(x as integer, y as integer, w as integer, h as integer, rcolour as integer) 'x, y coordinate of top left, wi, ht
  local integer a, dp
  dp=T18draw(T18.ffr, rcolour, x, y, w, 1,  T18_params()) 
  a=y+h-1
  dp=T18draw(T18.ffr, rcolour, x, a, w, 1,  T18_params()) 
  dp=T18draw(T18.ffr, rcolour, x, y, 1, h,  T18_params()) 
  a=x+w-1
  dp=T18draw(T18.ffr, rcolour, a, y, 1, h,  T18_params()) 
end sub
'
sub T18.frect(x as integer, y as integer, w as integer, h as integer, rcolour as integer) 'x, y coordinate of top left, width, height
  local integer dp=T18draw(T18.ffr, rcolour, x, y, w, h,  T18_params()) 
end sub
'
FUNCTION T18.Getchar(char as integer) as integer
  local integer i=char<<3
  T18.Getchar=PEEK(WORD T18_AddrOfFont+i)+(PEEK(WORD T18_AddrOfFont+i+4)<<32) 
END FUNCTION
'
sub T18.fcirc(x0 as integer, y0 as integer, r as integer, ccolour as integer)  'x, y coordinates of centre, radius
  local integer dp
  dp=T18draw(T18.ffr, ccolour, x0, y0-r, 1, 2*r+1,  T18_params())
  T18.fcircH(x0, y0, r, 3, 0, ccolour);
end sub
 '
sub T18.drndrect(x as integer, y as integer, w as integer, h as integer, r as integer, rcolour as integer) 'x, y coordinates of top left, width, height, radius of corner
  local integer dp
  dp=T18draw(T18.ffr, rcolour, x+r, y, w-2*r, 1,  T18_params()) 
  dp=T18draw(T18.ffr, rcolour, x+r, y+h-1, w-2*r, 1,  T18_params()) 
  dp=T18draw(T18.ffr, rcolour, x, y+r, 1, h-2*r,  T18_params()) 
  dp=T18draw(T18.ffr, rcolour, x+w-1, y+r, 1, h-2*r,  T18_params()) 
  T18.dcircH(x+r, y+r, r, 1, rcolour)
  T18.dcircH(x+w-r-1, y+r, r, 2, rcolour)
  T18.dcircH(x+w-r-1, y+h-r-1, r, 4, rcolour)
  T18.dcircH(x+r, y+h-r-1, r, 8, rcolour)
end sub
 '
sub T18.dcircH( x0 as integer , y0 as integer , r as integer , cn as integer, colour as integer )
  local integer f=1-r, ddF_x=1, ddF_y=-2 * r, x=0, y=r, dp
  do while (x<y)
    if (f>=0) then
  y=y-1
  ddF_y=ddF_y+2
  f=f+ddF_y
    endif
    x=x+1
    ddF_x=ddF_x+2
    f=f+ddF_x
    if (cn and 4) then
  dp=T18draw(T18.pix, colour, x0+x, y0+y,  T18_params())
  dp=T18draw(T18.pix, colour, x0+y, y0+x,  T18_params())
    endif
    if (cn and 2) then
  dp=T18draw(T18.pix, colour, x0+x, y0-y,  T18_params())
  dp=T18draw(T18.pix, colour, x0+y, y0-x,  T18_params())
    endif
    if (cn and 8) then
  dp=T18draw(T18.pix, colour, x0-y, y0+x,  T18_params())
  dp=T18draw(T18.pix, colour, x0-x, y0+y,  T18_params())
    endif
    if (cn and 1) then
  dp=T18draw(T18.pix, colour, x0-y, y0-x,  T18_params())
  dp=T18draw(T18.pix, colour, x0-x, y0-y,  T18_params())
    endif
  loop
end sub
 '
sub T18.fcircH(x0 as integer, y0 as integer, r as integer, cn as integer, delta as integer, colour as integer)
  local integer dp, f=1-r, ddF_x=1, ddF_y=-2 * r, x=0, y=r
  do while x<y
    if f>=0 then
  y=y-1
  ddF_y=ddF_y+2
  f=f+ddF_y
    endif
    x=x+1
    ddF_x=ddF_x+2
    f=f+ddF_x
    if (cn and 1) then
  dp=T18draw(T18.ffr, colour, x0+x, y0-y, 1, 2*y+1+delta,  T18_params()) 
  dp=T18draw(T18.ffr, colour, x0+y, y0-x, 1, 2*x+1+delta,  T18_params()) 
    endif
    if (cn and 2) then
  dp=T18draw(T18.ffr, colour, x0-x, y0-y, 1, 2*y+1+delta,  T18_params()) 
  dp=T18draw(T18.ffr, colour, x0-y, y0-x, 1, 2*x+1+delta,  T18_params()) 
    endif
  loop
end sub
'
sub T18.frndrect(x as integer, y as integer, w as integer, h as integer, r as integer, colour as integer) 'x, y coordinates of top left, width, height, radius of corner
  local integer dp
  dp=T18draw(T18.ffr, colour, x+r, y, w-2*r, h,  T18_params()) 
  T18.fcircH(x+w-r-1, y+r, r, 1, h-2*r-1, colour)
  T18.fcircH(x+r, y+r, r, 2, h-2*r-1, colour)
end sub
 '
sub T18.setrot(x%) 'sets screen rotation: 0=T18_normal, 1=invert, 2=rotate right, 3-rotate left
   local integer R(3)=(&HC0,&H00,&HA0,&H60)
   x%=x% and 3
   local integer i=x% \ 2 '0 for portrait, 1 for landscape
   local integer j=T18_params(T18_rotation)\2 
   if i<>j then 'swap height and width if landscape
     local integer k=T18_params(T18_width)
     T18_params(T18_width)=T18_params(T18_height)
     T18_params(T18_height)=k
   endif  
   T18_params(T18_rotation)=x%
   i=T18draw(T18.wcom,ST7735_MADCTL)'memory access control (directions)
   i=T18draw(T18.wdata,R(x%))
end sub
'
'D:\Peter\MPLABXProjects\T1818\dist\default\production\T18draw.bas

'
'T18draw  2014-12-14 15:43:28 CFuncGen Ver 1.0.21 by user=Peter
'
CFunction T18draw
'T18.wcom
	00000517
	3c02bf88 24030001 ac436134 24030002 ac436134 3c03bf80 8c625810 30420008 
	1040fffd 3c02bf80 ac445820 3c03bf80 8c625810 30420080 1040fffd 3c02bf88 
	24030001 ac436138 03e00008 00000000 

'T18.wdata
3c02bf88 24030001 ac436134 24030002 
	ac436138 3c03bf80 8c625810 30420008 1040fffd 3c02bf80 ac445820 3c03bf80 
	8c625810 30420080 1040fffd 3c02bf88 24030001 ac436138 03e00008 00000000 

'fastfillscreen
	27bdffd8 afbf0024 afb40020 afb3001c afb20018 afb10014 afb00010 00c09021 
	7c913a00 309000ff 8cd30000 8cc20008 72629802 2404002a 00002821 0411FFC8 
	00000000 00002021 00002821 0411FFD8 00000000 00002021 00002821 0411FFD4 
	00000000 00002021 00002821 0411FFD0 00000000 8e450000 8e420004 24a4ffff 
	0085282b 2442ffff 00a22821 0411FFC8 00000000 2404002b 00002821 0411FFB0 
	00000000 00002021 00002821 0411FFC0 00000000 00002021 00002821 0411FFBC 
	00000000 00002021 00002821 0411FFB8 00000000 8e450008 8e42000c 24a4ffff 
	0085282b 2442ffff 00a22821 0411FFB0 00000000 2404002c 00002821 0411FF98 
	00000000 24030002 3c02bf88 ac436138 3c03bf80 8c625810 30420008 1040fffd 
	00000000 12600016 2673ffff 3c05bf88 24040001 3c02bf80 3c06bf81 aca46134 
	ac515820 8c435810 30630080 1060fffd 00000000 aca46138 8cc3f220 aca46134 
	ac505820 8c435810 30630080 1060fffd 00000000 aca46138 1660fff0 2673ffff 
	8fbf0024 8fb40020 8fb3001c 8fb20018 8fb10014 8fb00010 03e00008 27bd0028 

'localfastfillrect
	27bdffc8 afbf0034 afbe0030 afb7002c afb60028 afb50024 afb40020 afb3001c 
	afb20018 afb10014 afb00010 8fa30048 8fa5004c 8faf0058 8fae005c 8fa20060 
	8c4a0000 8c490004 8c4b0008 8c4c000c 7c913a00 309000ff 24c8ffff 0106202b 
	24e2ffff 00821021 8fad0050 010d6821 01a8402b 8fa40054 00441021 01024021 
	01a09021 04e00004 01001021 00c0a021 1000000a 00e0a821 24d20002 0246302b 
	00c73821 01b29021 024d682b 01074021 01a81021 0000a021 0000a821 0049202a 
	1480000b 2466ffff 55220005 2552ffff 024a202b 14800007 00c3382b 2552ffff 
	024a202b 2522ffff 00821021 2466ffff 00c3382b 24a4ffff 00e42021 00cf3821 
	00e6302b 008e7021 00ce3021 00e09821 04a00004 00c02021 0060b021 1000000a 
	00a0b821 24730002 0263182b 00652821 00f39821 0267382b 00c53021 00e62021 
	0000b021 0000b821 008c182a 1460000a 00000000 55840005 2573ffff 026b182b 
	14600005 00000000 2573ffff 026b202b 2583ffff 00832021 1c400005 00000000 
	54400066 00002021 52400064 00002021 1c800005 02a9102a 14800062 00002021 
	12600066 00002821 54400005 02ec102a 1535005e 028a502b 1140005c 02ec102a 
	14400007 0254f023 1597005b 00002021 02cb582b 11600059 00002821 0254f023 
	27de0001 02761023 24420001 73c2f002 2404002a 00002821 0411FEF1 00000000 
	00002021 00002821 0411FF01 00000000 328400ff 00002821 0411FEFD 00000000 
	00002021 00002821 0411FEF9 00000000 324400ff 00002821 0411FEF5 00000000 
	2404002b 00002821 0411FEDD 00000000 00002021 00002821 0411FEED 00000000 
	32c400ff 00002821 0411FEE9 00000000 00002021 00002821 0411FEE5 00000000 
	326400ff 00002821 0411FEE1 00000000 2404002c 00002821 0411FEC9 00000000 
	24030002 3c02bf88 ac436138 13c00018 3c02bf80 27c6ffff 3c05bf88 24040001 
	3c07bf81 aca46134 ac515820 8c435810 30630080 1060fffd 00000000 aca46138 
	8ce3f220 aca46134 ac505820 8c435810 30630080 1060fffd 00000000 aca46138 
	50c00004 03c02021 1000ffee 24c6ffff 03c02021 10000009 00002821 10000007 
	00002821 10000005 00002821 00002021 10000002 00002821 00002821 00801021 
	00a01821 8fbf0034 8fbe0030 8fb7002c 8fb60028 8fb50024 8fb40020 8fb3001c 
	8fb20018 8fb10014 8fb00010 03e00008 27bd0038 

'localdrawPixel
27bdffd8 afbf0024 afb40020 
	afb3001c afb20018 afb10014 afb00010 00809821 00c09021 00e08021 8fb40038 
	8fb1003c 8fa20040 00f12827 00052fc2 8c430004 00e3182a 14600009 24040001 
	8c430004 54670006 00002021 8c430000 00c3182b 54600003 8c46000c 00002021 
	8c46000c 0226302a 14c00009 24030001 8c46000c 54d10006 00001821 8c420008 
	0282102b 14400003 00831824 00001821 00831824 00651824 00002021 10600039 
	00002821 2404002a 00002821 0411FE64 00000000 00002021 00002821 0411FE74 
	00000000 02402021 02002821 0411FE70 00000000 00002021 00002821 0411FE6C 
	00000000 26440001 0092282b 00b02821 0411FE67 00000000 2404002b 00002821 
	0411FE4F 00000000 00002021 00002821 0411FE5F 00000000 02802021 02202821 
	0411FE5B 00000000 00002021 00002821 0411FE57 00000000 26840001 0094282b 
	00b12821 0411FE52 00000000 2404002c 00002821 0411FE3A 00000000 7e643a00 
	00002821 0411FE4A 00000000 326400ff 00002821 0411FE46 00000000 24040001 
	00002821 00801021 00a01821 8fbf0024 8fb40020 8fb3001c 8fb20018 8fb10014 
	8fb00010 03e00008 27bd0028 

'drawline
27bdffb8 afbf0044 afbe0040 afb7003c afb60038 
	afb50034 afb40030 afb3002c afb20028 afb10024 afb00020 afa40048 afa5004c 
	8fa20058 8fa30060 8fa40068 8fb60070 00c08021 00409021 00609821 0044a02a 
	00822823 00443823 00f4280a 00a0a021 00c3402a 00663823 00c32823 00e8280b 
	00b4a02a 12800005 0080a821 00809821 0060a821 00408021 00c09021 0270102a 
	10400008 0255102a 02401021 02a09021 0040a821 02001021 02608021 00409821 
	0255102a 10400007 0270b823 02b2a823 00178fc2 02378821 00118843 10000006 
	241e0001 0255a823 00178fc2 02378821 00118843 241effff 0270102a 14400020 
	8fbf0044 5280000d afb20010 afb00010 001017c3 afa20014 afb60018 8fa40048 
	8fa5004c 02403021 00123fc3 0411FF49 00000000 1000000b 02358823 001217c3 
	afa20014 afb60018 8fa40048 8fa5004c 02003021 00103fc3 0411FF3E 00000000 
	02358823 06210003 26100001 025e9021 02378821 0270102a 1040ffe2 8fbf0044 
	8fbe0040 8fb7003c 8fb60038 8fb50034 8fb40030 8fb3002c 8fb20028 8fb10024 
	8fb00020 03e00008 27bd0048 

'drawchar
27bdff50 afbf00ac afbe00a8 afb700a4 afb600a0 
	afb5009c afb40098 afb30094 afb20090 afb1008c afb00088 afa600b8 afa700bc 
	8fa200c8 afa20058 8fa300cc afa3006c 8fa600d0 afa6005c 8fa200d4 afa20060 
	8fb000d8 8fb400dc 8fa300e0 afa30070 8fa600e4 afa60074 afa40030 00661025 
	14400094 afa50034 00101023 0002182b 00142023 afa20064 00832023 afa40068 
	00101782 00141880 00431825 00102080 00901021 0044202b 00741821 00831821 
	8fa50058 00452021 0082102b 8fa6006c 00661821 afa4004c 00431821 afa30050 
	24a20005 0045182b afa20044 00661821 afa30048 27b50030 27a20036 afa20038 
	0200b021 0280b821 0200f021 10000067 afb40054 92a20000 02021007 30420001 
	50400022 24020001 24030001 57c30010 afb10010 8fa40054 5480000d afb10010 
	afb20010 afb40014 8fa500e8 afa50018 8fa400b8 8fa500bc 8fa60044 8fa70048 
	0411FED4 00000000 1000002f 26100001 afb30014 afb60018 afb7001c afb60020 
	afb70024 8fa600e8 afa60028 8fa400b8 8fa500bc 8fa6003c 8fa70040 0411FDE8 
	00000000 10000020 26100001 57c20010 afb10010 8fa30054 5460000d afb10010 
	afb20010 afb40014 8fa400e8 afa40018 8fa400c0 8fa500c4 8fa60044 8fa70048 
	0411FEB4 00000000 1000000f 26100001 afb30014 afb60018 afb7001c afb60020 
	afb70024 8fa500e8 afa50028 8fa400c0 8fa500c4 8fa6003c 8fa70040 0411FDC8 
	00000000 26100001 02361021 0051182b 02779821 00408821 00739821 26420001 
	0052182b 00409021 24060008 1606ffb1 0074a021 8fa3004c 8fa40064 00641021 
	0043202b 8fa50050 8fa60068 00a61821 afa2004c 00831821 afa30050 8fa30044 
	2462ffff 0043202b 8fa50048 24a3ffff afa20044 00831821 afa30048 26b50001 
	8fa60038 52a600c0 03c08021 8fa2004c afa2003c 8fa30050 afa30040 8fb1005c 
	8fb30060 02209021 0260a021 1000ff91 00008021 24020001 8fa40070 148200b4 
	24020002 8fa50074 14a000b2 8fa30070 00101023 0002182b 00142023 afa20078 
	00832023 afa4007c 8fa60058 24c20001 0046202b 8fa3006c 00832021 00501823 
	0043102b 00942023 afa30050 00822023 afa40054 afa60048 8fa4006c afa4004c 
	27b70035 27a5002f afa50038 8fa6005c 24c30001 0066282b 8fa20060 00a22821 
	00101023 0002202b 00143023 00c42023 00023742 000420c0 00c43025 000210c0 
	00502021 0082102b 00d43021 00463021 00641021 0043182b 00a62021 00641821 
	00502023 afa40068 0044102b 00741823 00621823 afa30080 8fa5005c 24a5fff9 
	afa50064 0280b021 10000066 0200a021 92e20000 02021007 30420001 10400021 
	24040001 24060001 5686000f afb10010 56c0000d afb10010 afb20010 afb50014 
	8fa200e8 afa20018 8fa400b8 8fa500bc 8fa60048 8fa7004c 0411FE26 00000000 
	1000002e 2610ffff afb30014 afb40018 afb6001c afb40020 afb60024 8fa300e8 
	afa30028 8fa400b8 8fa500bc 8fa60040 8fa70044 0411FD3A 00000000 1000001f 
	2610ffff 5684000f afb10010 56c0000d afb10010 afb20010 afb50014 8fa500e8 
	afa50018 8fa400c0 8fa500c4 8fa60048 8fa7004c 0411FE07 00000000 1000000f 
	2610ffff afb30014 afb40018 afb6001c afb40020 afb60024 8fa600e8 afa60028 
	8fa400c0 8fa500c4 8fa60040 8fa70044 0411FD1B 00000000 2610ffff 023e1021 
	0051182b 8fa4003c 02649821 00408821 00739821 26420001 0052182b 00409021 
	2405ffff 1605ffb2 0075a821 8fa60050 8fa30078 00c31021 0046182b 8fa50054 
	8fa6007c 00a62021 afa20050 00642021 afa40054 8fa30048 2462ffff 0043182b 
	8fa5004c 24a4ffff afa20048 00642021 afa4004c 26f7ffff 8fa60038 52e600b1 
	02808021 8fa20050 afa20040 8fa30054 afa30044 0280f021 afb6003c 8fb10068 
	8fb30080 8fa40064 8fa5005c 0085a82b 8fa60060 24c2ffff 00809021 02a2a821 
	1000ff8b 24100007 8fb40054 24020002 8fa30070 1462009d 24020003 8fa40074 
	1480009b 8fa30070 00101023 0002182b 00142023 afa20070 00832023 afa40064 
	8fa50058 24a20001 0045202b 8fa6006c 00862021 00501823 0043102b 00942023 
	afa30048 00822023 afa40050 afa5003c afa6004c 24a2fff8 0045202b 24c3ffff 
	afa2006c 00831821 afa30074 0200b021 0280b821 27a2002f afa20038 afb00068 
	10000068 afb40054 92020000 03c21024 50400022 24020001 24030001 56a30010 
	afb10010 8fa40054 5480000d afb10010 afb20010 afb40014 8fa500e8 afa50018 
	8fa400b8 8fa500bc 8fa6003c 8fa7004c 0411FD88 00000000 1000002f 2610ffff 
	afb30014 afb60018 afb7001c afb60020 afb70024 8fa600e8 afa60028 8fa400b8 
	8fa500bc 8fa60040 8fa70044 0411FC9C 00000000 10000020 2610ffff 56a20010 
	afb10010 8fa30054 5460000d afb10010 afb20010 afb40014 8fa400e8 afa40018 
	8fa400c0 8fa500c4 8fa6003c 8fa7004c 0411FD68 00000000 1000000f 2610ffff 
	afb30014 afb60018 afb7001c afb60020 afb70024 8fa500e8 afa50028 8fa400c0 
	8fa500c4 8fa60040 8fa70044 0411FC7C 00000000 2610ffff 02361021 0051182b 
	02779821 00408821 00739821 26420001 0052182b 00409021 8fa60038 1606ffb2 
	0074a021 8fa30048 8fa40070 00641021 0043202b 8fa50050 8fa60064 00a61821 
	afa20048 00831821 afa30050 8fa3003c 2462ffff 0043202b 8fa5004c 24a3ffff 
	afa2003c 00831821 afa3004c 8fa6006c 54460005 8fa30058 8fa20074 106200d4 
	8fbf00ac 8fa30058 8fa4003c 0064f023 24050001 03c5f004 8fa60048 afa60040 
	8fa20050 afa20044 27b00035 8fb1005c 8fb30060 02209021 0260a021 1000ff8a 
	8fb50068 02c0a021 24020003 8fa30070 146200be 8fa40074 148000bc 00101023 
	0002182b 00142023 afa20064 00832023 afa40068 00101742 001418c0 00431825 
	001020c0 00901023 0082202b 00741823 00641823 8fa50058 00452021 0082102b 
	8fa6006c 00661821 afa40050 00431821 afa30054 24a20007 0045182b afa20048 
	00661821 afa30058 24020007 afa2004c 8fa3005c 24620001 0043282b 8fa40060 
	00a42821 00101823 0003202b 00143023 00c42023 00033782 00042080 00c43025 
	00032080 00901821 0064202b 00d43021 00862021 000337c2 00042040 00c42025 
	00031840 00431821 afa3006c 0062102b 00a41821 00431821 afa30074 8fa5005c 
	24a5fffb afa50070 8fa6005c 00a6182b 8fa40060 2482ffff 00621021 afa2005c 
	0280b021 10000068 0200a021 92020000 02e21024 10400021 24030001 24050001 
	5685000f afb10010 56c0000d afb10010 afb20010 afb50014 8fa600e8 afa60018 
	8fa400b8 8fa500bc 8fa60048 8fa70058 0411FCC8 00000000 1000002e 26100001 
	afb30014 afb40018 afb6001c afb40020 afb60024 8fa200e8 afa20028 8fa400b8 
	8fa500bc 8fa60040 8fa70044 0411FBDC 00000000 1000001f 26100001 5683000f 
	afb10010 56c0000d afb10010 afb20010 afb50014 8fa400e8 afa40018 8fa400c0 
	8fa500c4 8fa60048 8fa70058 0411FCA9 00000000 1000000f 26100001 afb30014 
	afb40018 afb6001c afb40020 afb60024 8fa500e8 afa50028 8fa400c0 8fa500c4 
	8fa60040 8fa70044 0411FBBD 00000000 26100001 023e1021 0051182b 8fa6003c 
	02669821 00408821 00739821 26420001 0052182b 00409021 8fa20038 1602ffb3 
	0075a821 8fa3004c 2463ffff afa3004c 8fa40050 8fa50064 00851021 0044202b 
	8fa60054 8fa50068 00c51821 afa20050 00831821 afa30054 8fa60048 24c2ffff 
	0046202b 8fa50058 24a3ffff afa20048 00831821 afa30058 2402ffff 8fa6004c 
	10c20013 8fbf00ac 24170001 8fa2004c 0057b804 8fa30050 afa30040 8fa40054 
	afa40044 27b00030 0280f021 afb6003c 8fb1006c 8fb30074 8fb20070 8fb5005c 
	27a50036 1000ff89 afa50038 8fbf00ac 8fbe00a8 8fb700a4 8fb600a0 8fb5009c 
	8fb40098 8fb30094 8fb20090 8fb1008c 8fb00088 03e00008 27bd00b0 

'main
27bdffb8 
	afbf0044 afb00040 00808021 00e05821 8fa90058 8faa005c 8c820000 8c830004 
	00432025 1480000e 8fa80060 8ca40000 8ca50004 8cc70004 8cc60000 8d620000 
	8d630004 afa20010 afa30014 afa90018 0411FC40 00000000 1000007a 8fbf0044 
	24040001 14440018 24040002 14600016 00000000 8ca40000 8ca50004 8cc70004 
	8cc60000 8d620000 8d630004 afa20010 afa30014 8d220000 8d230004 afa20018 
	afa3001c 8d420000 8d430004 afa20020 afa30024 afa80028 0411FB49 00000000 
	10000060 8fbf0044 14440023 24040003 14600021 00000000 8ca40000 8ca50004 
	8cc70004 8cc60000 8d620000 8d630004 afa20010 afa30014 8d220000 8d230004 
	afa20018 afa3001c 8d420000 8d430004 afa20020 afa30024 8d020000 8d030004 
	afa20028 afa3002c 8fa20064 8c430004 8c420000 afa20030 afa30034 8fa20068 
	afa20038 0411FCD9 00000000 8e020000 1000003b 8e030004 14440019 24040004 
	14600017 00000000 8ca40000 8ca50004 8cc70004 8cc60000 8d620000 8d630004 
	afa20010 afa30014 8d220000 8d230004 afa20018 afa3001c 8d420000 afa20020 
	000217c3 afa20024 afa80028 0411FC57 00000000 8e020000 10000021 8e030004 
	1444000a 24040005 14600008 00000000 8ca40000 8ca50004 0411FA71 00000000 
	8e020000 10000016 8e030004 1444000a 24040006 14600008 00000000 8ca40000 
	8ca50004 0411FA7A 00000000 8e020000 1000000b 8e030004 1444000a 8fbf0044 
	54600009 8fb00040 8ca40000 8ca50004 0411FA83 00000000 8e020000 8e030004 
	8fbf0044 8fb00040 03e00008 27bd0048 
End CFunction

CFunction font
	00000000
	00000000 00000000 4f5b3e00 00003e5b 4f6b3e00 00003e6b 7c3e1c00 00001c3e 
	7e3c1800 0000183c 7d571c00 00001c57 7f5e1c00 00001c5e 3c180000 00000018 
	c3e7ff00 0000ffe7 24180000 00000018 dbe7ff00 0000ffe7 3a060e00 00003048 
	79292600 00002629 05050700 0000407f 05253f00 0000407f e73c5a00 00005a3c 
	1c1c0800 00007f3e 1c3e7f00 0000081c 7f221400 00001422 005f5f00 00005f5f 
	7f017f00 00000609 89956a00 00000066 60606000 00006060 ffa29400 000094a2 
	7e040800 00000804 7e201000 00001020 2a1c0800 00000808 2a080800 0000081c 
	10101000 00001e10 0c1e0c00 00000c1e 3e383000 00003038 3e0e0600 0000060e 
	00000000 00000000 5f000000 00000000 00070000 00000007 147f1400 0000147f 
	7f2a1200 0000242a 08646200 00002313 56205000 00003649 07030000 00000008 
	22410000 0000001c 221c0000 00000041 7f1c2a00 00002a1c 3e080800 00000808 
	70300000 00000080 08080800 00000808 60600000 00000000 08040200 00002010 
	49453e00 00003e51 7f400000 00000042 49494600 00007249 494d3300 00002141 
	127f1000 00001814 45453900 00002745 49493100 00003c4a 11090700 00004121 
	49493600 00003649 49291e00 00004649 14000000 00000000 34000000 00000040 
	14224100 00000008 14141400 00001414 22140800 00000041 59090600 00000201 
	5d594e00 00003e41 11127c00 00007c12 49493600 00007f49 41412200 00003e41 
	41413e00 00007f41 49494100 00007f49 09090100 00007f09 41517300 00003e41 
	08087f00 00007f08 7f410000 00000041 413f0100 00002040 14224100 00007f08 
	40404000 00007f40 1c027f00 00007f02 08107f00 00007f04 41413e00 00003e41 
	09090600 00007f09 51215e00 00003e41 19294600 00007f09 49493200 00002649 
	7f010300 00000301 40403f00 00003f40 40201f00 00001f20 38403f00 00003f40 
	08146300 00006314 78040300 00000304 494d4300 00006159 41414100 0000007f 
	08102000 00000204 41417f00 00000041 01020400 00000402 40404000 00004040 
	07080000 00000003 54784000 00002054 44443800 00007f28 44442800 00003844 
	44287f00 00003844 54541800 00003854 7e090200 00000008 a49c7800 000018a4 
	04047800 00007f08 7d400000 00000044 403d0000 00002040 28440000 00007f10 
	7f400000 00000041 78047800 00007c04 04047800 00007c08 44443800 00003844 
	24241800 0000fc18 2418fc00 00001824 04040800 00007c08 54542400 00004854 
	3f442400 00000404 40207c00 00003c40 40201c00 00001c20 30403c00 00003c40 
	10284400 00004428 90907c00 00004c90 544c4400 00004464 36410000 00000008 
	77000000 00000000 36080000 00000041 02040200 00000201 23263c00 00003c26 
	a1611200 00001ea1 40207a00 00003a40 54555900 00003854 55794100 00002155 
	54784200 00002254 54784000 00002155 55794000 00002054 52721200 00000c1e 
	55555900 00003955 54545900 00003954 54545800 00003955 457c4100 00000000 
	457d4200 00000002 457c4000 00000001 11127d00 00007d12 2528f000 0000f028 
	55450000 00007c54 547c5400 00002054 097f4900 00007c0a 49493200 00003249 
	44443a00 00003a44 48483000 0000324a 41217a00 00003a41 40207800 00003a42 
	a0a07d00 0000009d 42423d00 00003d42 40403d00 00003d40 ff242400 00003c24 
	49436600 0000487e fc2f2b00 00002b2f 29f62000 0000ff09 7e090300 0000c088 
	54794100 00002054 447d4100 00000000 484a3200 00003048 40227a00 00003840 
	0a0a7200 0000007a 19317d00 00007d0d 292f2800 00002629 29292600 00002629 
	4d402000 00003048 08080800 00003808 08083800 00000808 c8acba00 00002f10 
	2834fa00 00002f10 7b000000 00000000 2a142200 00000814 2a140800 00002214 
	5500aa00 0000aa00 aa55aa00 0000aa55 00ff0000 00000000 10ff0000 00001010 
	14ff0000 00001414 ff00ff00 00001010 f010f000 00001010 14fc0000 00001414 
	f700ff00 00001414 ff00ff00 00000000 f404fc00 00001414 17101f00 00001414 
	1f101f00 00001010 141f0000 00001414 10f00000 00001010 001f1000 00000000 
	101f1000 00001010 10f01000 00001010 00ff1000 00000000 10101000 00001010 
	10ff1000 00001010 00ff1400 00000000 ff00ff00 00000000 1f101700 00000000 
	fc04f400 00000000 17101700 00001414 f404f400 00001414 ff00f700 00000000 
	14141400 00001414 f700f700 00001414 14171400 00001414 1f101f00 00001010 
	14f41400 00001414 f010f000 00001010 1f101f00 00000000 001f1400 00000000 
	00fc1400 00000000 f010f000 00000000 ff10ff00 00001010 14ff1400 00001414 
	101f0000 00001010 00f01000 00000000 ffffff00 0000ffff f0f0f000 0000f0f0 
	ff000000 0000ffff 00ffff00 00000000 0f0f0f00 00000f0f 44384400 00003844 
	4a4a3400 0000fc4a 02060600 00007e02 027e0200 0000027e 49416300 00006355 
	443c0400 00003844 201e2000 0000407e 7e020200 00000602 e7a59900 000099a5 
	492a1c00 00001c2a 01724c00 00004c72 4d4d3000 0000304a 78483000 00003048 
	5a463d00 0000bc62 49490000 00003e49 01017e00 00007e01 2a2a2a00 00002a2a 
	5f444400 00004444 4a444000 00004051 4a514000 00004044 ff010300 00000000 
	ff000000 0000e080 6b6b0800 00000808 36243600 00003612 090f0600 0000060f 
	18180000 00000000 10100000 00000000 ff010100 00003040 01011e00 0000001f 
	1d171200 00000019 3c3c3c00 0000003c 00000000 00000000 
End CFunction
'
sub T18_test
  local integer i, xfs, yfs, x0, y0, x1, y1, wi, ht, sz
  local float tn
  do
  T18.setrot(T18_normal)
  T18.pstring(24, 10, "Welcome to the", 1, 0, green, black)
  T18.pstring(8, 30, "Micromite", 2, 0, red, black)
  T18.pstring(44,50,"MK2",2,0,red,black)
  T18.pstring(8, 80, "in colour", 2, 0, yellow, black)
  T18.pstring(10, 100, "1.8in SPI display", 1, 0, cyan, black)
  T18.pstring(18, 115,  "7735R contoller", 1, 0, cyan, black)

  pause 4000
' demo fast line draw
  T18_fillscreen(white)
  x0=0:y0=0:y1=T18_params(T18_height)-1
  for i=0 to 45 step 5
    tn=tan(rad(i))
    x1=T18_params(T18_width)*tn
    T18.dline(x0, y0, x1, y1, red)
  next i
  x1=T18_params(T18_width)-1
  for i=0 to 40 step 5
    tn=tan(rad(i))
    y1=T18_params(T18_height)*tn
    T18.dline(x0, y0, x1, y1, red)
  next i
  T18.drect(0, 0, T18_params(T18_width), T18_params(T18_height), blue)
  pause 2000
  T18_fillscreen(white)
'demo fast text write
  T18.setrot(T18_rt_right)
  for i=0 to T18_params(T18_width)-8 step 8
    T18.pstring(0, i, "Hello world:Bye world:Hello world", 1, T18_normal, green, black)
  next i
  pause 2000
  T18.setrot(T18_normal)
  T18_fillscreen(white)
  for i=T18_params(T18_height)-1 to 15 step -16
    T18.pstring(T18_params(T18_width)-1, i, "Micromite MK2:Micromite MK2", 2, T18_inverse, red, yellow)
  next i
  pause 2000
  T18_fillscreen(white)
  for i=23 to T18_params(T18_width) + 24 step 24
    T18.pstring(i, 0, "Rotate right", 3, T18_rt_right, yellow, black)
  next i
  pause 2000
  T18_fillscreen(black)
  for i=T18_params(T18_width)-32 to 0 step -32
    T18.pstring(i, T18_params(T18_height)-1, "Left", 4, T18_rt_left, blue, black)
  next i
  pause 2000
  T18_fillscreen(black)
  ' test drawing rectangles
  for i=0 to 3
     T18.setrot(i)
     T18.frect(4, 4, 12, 17, blue)
     T18.drect(2, 2, 16, 21, red)
  next i
  pause 2000
' test drawing rounded rectangles
  T18_fillscreen(black)
  for i=0 to 3
     T18.setrot(i)
     T18.frndrect(4, 4, 12, 17, 4, blue)
     T18.drndrect(2, 2, 16, 21, 6, red)
  next i
  pause 2000
  T18_fillscreen(black)
' test drawing circles
  for i=0 to 3
     T18.setrot(i)
     T18.fcirc(10, 10, 7, blue)
     T18.dcirc(10, 10, 9, red)
  next i
  pause 2000
' test drawing triangles and line drawing
  T18_fillscreen(black)
  for i=0 to 3
     T18.setrot(i)
     T18.ftri(4, 4, 20, 6, 12, 14, blue)
     T18.dtri(1, 2, 24, 4, 12, 17, red)
  next i
  pause 2000
' test character output and string output at all orientations
  for sz=1 to 3
  T18_fillscreen(black)
  T18.setrot(T18_normal)
  T18.pstring(T18_params(T18_width)/2, T18_params(T18_height)/2, "N", 3, T18_normal, white, black)
  T18.pstring(0, 0, "Normal", sz, T18_normal, red, black)
  T18.pstring(T18_params(T18_width)-1, T18_params(T18_height)-1, "Inverted", sz, T18_inverse, blue, black)
  T18.pstring(T18_params(T18_width)-1, 0, "Rotated right", sz, T18_rt_right, green, black)
  T18.pstring(0, T18_params(T18_height)-1, "Rotated left", sz, T18_rt_left, yellow, black)
  pause 2000
  T18_fillscreen(black)
  T18.setrot(T18_inverse)
  T18.pstring(T18_params(T18_width)/2, T18_params(T18_height)/2, "I", 3, T18_inverse, white, black)
  T18.pstring(0, 0, "Normal", sz, T18_normal, red, black)
  T18.pstring(T18_params(T18_width)-1, T18_params(T18_height)-1, "Inverted", sz, T18_inverse, blue, black)
  T18.pstring(T18_params(T18_width)-1, 0, "Rotated right", sz, T18_rt_right, green, black)
  T18.pstring(0, T18_params(T18_height)-1, "Rotated left", sz, T18_rt_left, yellow, black)
  pause 2000
  T18_fillscreen(black)
  T18.setrot(T18_rt_right)
  T18.pstring(T18_params(T18_width)/2, T18_params(T18_height)/2, "R", 3, T18_rt_left, white, black)
  T18.pstring(0, 0, "Normal", sz, T18_normal, red, black)
  T18.pstring(T18_params(T18_width)-1, T18_params(T18_height)-1, "Inverted", sz, T18_inverse, blue, black)
  T18.pstring(T18_params(T18_width)-1, 0, "Rotated Right", sz, T18_rt_right, green, black)
  T18.pstring(0, T18_params(T18_height)-1, "Rotated left", sz, T18_rt_left, yellow, black)
  pause 2000
  T18_fillscreen(black)
  T18.setrot(T18_rt_left)
  T18.pstring(T18_params(T18_width)/2, T18_params(T18_height)/2, "L", 3, T18_rt_right, white, black)
  T18.pstring(0, 0, "Normal", sz, T18_normal, red, black)
  T18.pstring(T18_params(T18_width)-1, T18_params(T18_height)-1, "Inverted", sz, T18_inverse, blue, black)
  T18.pstring(T18_params(T18_width)-1, 0, "Rotated right", sz, T18_rt_right, green, black)
  T18.pstring(0, T18_params(T18_height)-1, "Rotated left", sz, T18_rt_left, yellow, black)
  pause 2000
  next sz
  loop
end sub
