OPTION EXPLICIT 
   
  'Go run the TestSuite 
  TestSuite() 
   
END 
   
   '*********************************************************** ************************** 
  ' 
  ' Peter Mather (edited by Peter Carnegie) 
  ' 
  ' V1.1 
  ' 2014-12-11 
  ' 
  ' Monochrome Port of Adafruit graphics library with drivers for i2c SSD1306 display 
  ' 
  ' Initialise Display Library 
  ' You MUST call TFT.Init BEFORE any other call to this library 
  ' SUB TFT.Init(I2C_adr,of,I2C_Speed,wi,ht,nr)              
  ' 
  '   In  : I2C_adr : I2C address of the display 
  '         of : [optional] display offset, default 0 ,set to 2 for 1.3" displays
  '         I2C_speed : [optional] Speed in KHz of the I2C bus, default 400 
  '         wi : [optional] width in pixels of the display, default 128 
  '         ht : [optional] height in pixels, default 64 
  '         nr : [optional] number of rows, default=ht\8 
  ' 
  ' TFT.Init declares the following externally usable constants 
  '   TFT_ON=1 
  '   TFT_OFF=0 
  '   TFT_RT_RIGHT=2  Rotate Right 
  '   TFT_RT_LEFT=3   Rotate Left 
  '   TFT_NORMAL=0    Normal Aspect 
  '   TFT_INVERSE=1   Upside Down Aspect 
   
  ' The Drawing Primitives assume a graphics display where top left is point 0,0 
  ' The Drawing Primitives just update the memory image of the display 
  ' To actually update the physical display call SUB S_Refresh 
   
  ' Set screen orientation 
  ' SUB TFT.SetRot(x) 
  '     In : X  0=normal,1=invert,2=rotate right,3-rotate left 
   
  ' Draw circle 
  ' SUB TFT.DCirc(x0,y0,r) 
  '     In : x,y coordinates of centre,radius 
   
  ' Draw filled circle, ie a disc 
  ' SUB TFT.FCirc(x0,y0,r) 
  '     In: x,y coordinates of centre,r=radius 
   
  '     Draw triangle 
  ' SUB TFT.DTri(x0,y0, x1,y1, x2,y2)      
  '     In: three coordinate pairs representing each vertex 
   
  '     Draw filled triangle 
  ' SUB TFT.FTri (x0,y0, x1,y1, x2,y2) 
  '     In: three coordinate pairs representing each vertex 
   
  ' Print string 
  ' SUB TFT.PString(xx0,yy0,text$,sz,orientation)  
  '      In: x,y,           Coordinates of top left of first character, 
  '          text$,           String to display 
  '          sz,           Size of Text to display 
  '          orientation Orientation of displayed text 
   
  ' Draw line 
  ' SUB TFT.DLine(xx0,yy0,xx1,yy1) 
  '     In:     x0,y0           start of line 
  '          x1,y1           end of line 
   
  '     Draw rectangle 
  ' SUB TFT.DRect(x,y,w,h) 
  '     In:     x,y                Coordinate of top left corner 
  '          width               Width 
  '          height               Height 
   
  ' Draw filled rectangle 
  ' SUB TFT.FRect(x,y,w,h) 
  '     In:     x,y                Coordinate of top left corner 
  '          width               Width 
  '          height               Height 
   
  '     Clear rectangluar area 
  ' SUB TFT.CRect(x,y,w,h) 
  '     In:     x,y                Coordinate of top left corner 
  '          width               Width 
  '          height               Height 
   
  '     Draw rounded rectangle 
  ' SUB TFT.DRndRect(x,y,w,h,r) 
  '     In:     x,y                Coordinate of top left corner 
  '          width               Width 
  '          height               Height 
  '          radius                Radius of corners 
   
  ' Draw filled rounded rectangle 
  ' SUB TFT.FRndRect(x,y,w,h,r) 
  '       In:     x,y                Coordinate of top left corner 
  '            width               Width 
  '            height               Height 
  '            radius                Radius of corners 
   
  ' Update the physical display 
  ' SUB TFT.Refresh 
  '       In:     N/A 
   
  '     Clear the physical display and internal memory map 
  ' SUB TFT.Cls 
  '       In:     N/A 
   
  ' 
  ' Initialise Display Library 
  ' You MUST call TFT.Init BEFORE any other call to this library 
  ' SUB TFT.Init(I2C_adr,of,I2C_Speed,wi,ht,nr)              
  ' 
  '   In  : I2C_adr : I2C address of the display 
  '         of : [optional] display offset, default 0 ,set to 2 for 1.3" displays
  '         I2C_speed : [optional] Speed in KHz of the I2C bus, default 400 
  '         wi : [optional] width in pixels of the display, default 128 
  '         ht : [optional] height in pixels, default 64 
  '         nr : [optional] number of rows, default=ht\8 
  ' 
  ' TFT.Init declares the following externally usable constants 
  '   TFT_ON=1 
  '   TFT_OFF=0 
  '   TFT_RT_RIGHT=2  Rotate Right 
  '   TFT_RT_LEFT=3   Rotate Left 
  '   TFT_NORMAL=0    Normal Aspect 
  '   TFT_INVERSE=1   Upside Down Aspect 
  ' 
SUB TFT.Init(I2C_adr,of,I2C_Speed,wi,ht,nr) 
  IF I2C_Speed=0 THEN I2C_Speed=400 
  IF wi=0 THEN wi=128 
  IF ht=0 THEN ht=64 
  IF nr=0 THEN nr=ht\8 
   
  ' Global variables 
  DIM INTEGER  TFT_w1,TFT_ht,TFT_nr,TFT_i2caddr,TFT_rot_ht,TFT_rot_wi,TFT_rot,TFT_FontPtr,TFT_of 
   
  'set up arrays for screen map to mimic display 
  DIM INTEGER TFT_sc(wi),TFT_dd(wi)  
   
  'Global Constants 
  'CFunction DRAW function Indexes [sic] 
  DIM Integer TFT_PIX=0,TFT_FFR=1,TFT_DRAWCHAR=2,TFT_DRAWLINE=3, TFT_PSTRING=4  
     
  'Used by User program in calls to drawing primitives 
  DIM Integer TFT_ON=1,TFT_OFF=0 
  DIM Integer TFT_NORMAL=0,TFT_INVERSE=1,TFT_RT_RIGHT=2,TFT_RT_LEFT=3 
   
  TFT_FontPtr=PEEK(CFunAddr TFT_FONT) 
  TFT_i2caddr=I2C_adr 
  TFT_w1=wi 
  TFT_ht=ht 
  TFT_nr=nr 
  TFT_of=of
   
  LOCAL i% 
   
  'Open up the I2C Bus if not already open 
  IF TFT.isI2COpen()<>1 THEN 
    I2C OPEN I2C_Speed,1000 
  ENDIF 
   
  TFT.SCmd(&HAE)'DISPLAYOFF) 
  TFT.SCmd(&HD5)'DISPLAYCLOCKDIV 
  TFT.SCmd(&H80)'the suggested ratio &H80 
  TFT.SCmd(&HA8)'MULTIPLEX 
  TFT.SCmd(&H3F)' 
  TFT.SCmd(&HD3)'DISPLAYOFFSET 
  TFT.SCmd(&H0)'no offset 
  TFT.SCmd(&H40)'STARTLINE 
  TFT.SCmd(&H8D)'CHARGEPUMP 
  TFT.SCmd(&H14) 
  TFT.SCmd(&H20)'MEMORYMODE 
  TFT.SCmd(&H00)'&H0 act like ks0108 
  TFT.SCmd(&HA1)'SEGREMAP OR 1 
  TFT.SCmd(&HC8)'COMSCANDEC 
  TFT.SCmd(&HDA)'COMPINS 
  TFT.SCmd(&H12) 
  TFT.SCmd(&H81)'SETCONTRAST 
  TFT.SCmd(&HCF) 
  TFT.SCmd(&Hd9)'SETPRECHARGE 
  TFT.SCmd(&HF1) 
  TFT.SCmd(&HDB)'VCOMDETECT 
  TFT.SCmd(&H40) 
  TFT.SCmd(&HA4)'DISPLAYALLON_RESUME 
  TFT.SCmd(&HA6)'NORMALDISPLAY 
  TFT.SCmd(&HAF)'DISPLAYON 
   
  FOR i%=0 TO TFT_w1-1  'force the whole screen to be re-written at the next refresh 
    TFT_dd(i%)= -1      '&HFFFFFFFFFFFFFFFF 
    TFT_sc(i%)=0 
  NEXT i% 
   
  TFT.Refresh 
   
END SUB 

SUB TFT.SCmd(Comnd%) 
  I2C WRITE TFT_i2caddr,0,2,&H00,Comnd% 
END SUB 


SUB TFT.Refresh() 
  LOCAL StartRow%,StartCol%,R% 
  LOCAL OutChar$ length 130 
  TFT.SCz(0,0) 
  DO 
     R%=TFT.SGetNextUpdate(OutChar$,StartCol%,StartRow%,TFT_w1,TFT_nr,TFT_sc(),TFT_dd()) 
    IF R%<>0 THEN 
      TFT.SCz(StartCol%+TFT_of,StartRow%) 
      I2C WRITE TFT_i2caddr,0,LEN(OutChar$),OutChar$ 
    ENDIF 
  LOOP WHILE R%<>0 
END SUB 
   
  'Clear Screen 
SUB TFT.Cls 
  LOCAL i 
  FOR i=0 TO TFT_w1-1 
    TFT_sc(i)=0 
  NEXT i 
  TFT.Refresh 
END SUB 
   
   
SUB TFT.SCz(x%,y%) 
  TFT.SCmd(&HB0+y%)        'set page address 
  TFT.SCmd(&H10+(x%>>4 AND &H0F))  'set high col address 
  TFT.SCmd(&H00+(x% AND &H0f))     'set low col address 
END SUB 
   
  ' 
  ' Generic drawing routines 
  ' 
SUB TFT.DCirc(x0 AS Integer,y0 AS Integer,r AS Integer) 'x,y coordinates of centre,radius 
  LOCAL Integer f=1-r,ddF_x=1,ddF_y=-2*r,x=0,y=r,dp 
   dp=TFT.Draw(TFT_PIX,TFT_sc(),TFT_ON,x0,y0+r,TFT_rot,TFT_w1,TFT_ht) 
   dp=TFT.Draw(TFT_PIX,TFT_sc(),TFT_ON,x0,y0-r,TFT_rot,TFT_w1,TFT_ht) 
   dp=TFT.Draw(TFT_PIX,TFT_sc(),TFT_ON,x0+r,y0,TFT_rot,TFT_w1,TFT_ht) 
   dp=TFT.Draw(TFT_PIX,TFT_sc(),TFT_ON,x0-r,y0,TFT_rot,TFT_w1,TFT_ht) 
  DO WHILE (x<y) 
    IF f>=0 THEN 
      y=y-1 
      ddF_y=ddF_y+2 
      f=f+ddF_y 
    ENDIF 
    x=x+1 
    ddF_x=ddF_x+2 
    f=f+ddF_x 
     dp=TFT.Draw(TFT_PIX,TFT_sc(),TFT_ON,x0+x,y0+y,TFT_rot,TFT_w1 ,TFT_ht) 
     dp=TFT.Draw(TFT_PIX,TFT_sc(),TFT_ON,x0-x,y0+y,TFT_rot,TFT_w1 ,TFT_ht) 
     dp=TFT.Draw(TFT_PIX,TFT_sc(),TFT_ON,x0+x,y0-y,TFT_rot,TFT_w1 ,TFT_ht) 
     dp=TFT.Draw(TFT_PIX,TFT_sc(),TFT_ON,x0-x,y0-y,TFT_rot,TFT_w1 ,TFT_ht) 
     dp=TFT.Draw(TFT_PIX,TFT_sc(),TFT_ON,x0+y,y0+x,TFT_rot,TFT_w1 ,TFT_ht) 
     dp=TFT.Draw(TFT_PIX,TFT_sc(),TFT_ON,x0-y,y0+x,TFT_rot,TFT_w1 ,TFT_ht) 
     dp=TFT.Draw(TFT_PIX,TFT_sc(),TFT_ON,x0+y,y0-x,TFT_rot,TFT_w1 ,TFT_ht) 
     dp=TFT.Draw(TFT_PIX,TFT_sc(),TFT_ON,x0-y,y0-x,TFT_rot,TFT_w1 ,TFT_ht) 
  LOOP 
END SUB 

   
SUB TFT.DTri(x0 AS Integer,y0 AS Integer,x1 AS Integer,y1 AS Integer,x2 AS Integer,y2 AS Integer) 'three coordinate pairs 
  TFT.DLine(x0,y0,x1,y1) 
  TFT.DLine(x1,y1,x2,y2) 
  TFT.DLine(x2,y2,x0,y0) 
END SUB 

  
SUB TFT.FTri (x0 AS Integer,y0 AS Integer,x1 AS Integer,y1 AS Integer,x2 AS Integer,y2 AS Integer) 'three coordinate pairs 
  LOCAL Integer a,b,y,dp,last 
  IF (y0>y1) THEN 
    TFT.Swap(y0,y1) 
    TFT.Swap(x0,x1) 
  ENDIF 
  IF (y1>y2) THEN 
    TFT.Swap(y2,y1) 
    TFT.Swap(x2,x1) 
  ENDIF 
  IF (y0>y1) THEN 
    TFT.Swap(y0,y1) 
    TFT.Swap(x0,x1) 
  ENDIF 
  IF(y0=y2) THEN ' Handle awkward all-on-same-line case as its own thing 
    a=x0 
    b=x0 
    IF(x1<a) THEN 
      a=x1 
    ELSE 
      IF(x1>b) THEN b=x1 
    ENDIF 
    IF(x2<a) THEN 
      a=x2 
    ELSE 
      IF(x2>b) THEN b=x2 
    ENDIF 
     dp=TFT.Draw(TFT_FFR,TFT_sc(),TFT_ON,a,y0,1,b-a+1,TFT_rot,TFT_w1,TFT_ht) 
    EXIT SUB 
  ENDIF 
   
  LOCAL Integer dx01=x1-x0, dy01=y1-y0, dx02=x2-x0, dy02=y2-y0,dx12=x2-x1, dy12=y2-y1, sa=0,sb=0 
   
  IF(y1=y2) THEN 
    last=y1 'Include y1 scanline 
  ELSE 
    last=y1-1 ' Skip it 
  ENDIF 
   
  FOR y=y0 TO last 
    a=x0+sa \ dy01 
    b=x0+sb \ dy02 
    sa=sa+dx01 
    sb=sb+dx02 
    a=x0+(x1-x0) * (y-y0) \ (y1-y0) 
    b=x0+(x2-x0) * (y-y0) \ (y2-y0) 
    IF(a>b) THEN TFT.Swap(a,b) 
     dp=TFT.Draw(TFT_FFR,TFT_sc(),TFT_ON,a,y,b-a+1,1,TFT_rot,TFT_w1,TFT_ht) 
  NEXT y 
   
  sa=dx12 * (y-y1) 
  sb=dx02 * (y-y0) 
   
  DO WHILE y<=y2 
    a=x1+sa \ dy12 
    b=x0+sb \ dy02 
    sa=sa+dx12 
    sb=sb+dx02 
    a=x1+(x2-x1) * (y-y1) \ (y2-y1) 
    b=x0+(x2-x0) * (y-y0) \ (y2-y0) 
    IF(a>b) THEN TFT.Swap(a,b) 
     dp=TFT.Draw(TFT_FFR,TFT_sc(),TFT_ON,a,y,b-a+1,1,TFT_rot,TFT_w1,TFT_ht) 
    y=y+1 
  LOOP 
END SUB 

   

sub TFT.pstring(xx0 as integer, yy0 as integer, text$, sz as integer, orientation as integer) 'x, y coordinates of top left of first character, text string, size, orientation
  local integer screen,i
  screen=TFT_w1+(TFT_ht<<32)
  i=TFT.draw(TFT_pstring,TFT_FontPtr,xx0,yy0,sz,orientation,TFT_rot,screen,TFT_sc(),text$)
end sub

SUB TFT.DLine(xx0%,yy0%,xx1%,yy1%) ' x,y of start line,x,y of end line 
  'CONST drawline=3 
  LOCAL  dp%=TFT.Draw(3,TFT_sc(),TFT_ON,xx0%,yy0%,xx1%,yy1%,TFT_rot,TFT_w1,TFT_ht) 
END SUB 


SUB TFT.Swap(a%,b%) 
  LOCAL t% 
  t%=b% 
  b%=a% 
  a%=t% 
END SUB 


SUB TFT.DRect(x AS integer,y AS integer,w AS integer,h AS integer ) 'x,y coordinate of top left,TFT_w1,TFT_ht 
  LOCAL  Integer a,dp 
   dp=TFT.Draw(TFT_FFR,TFT_sc(),TFT_ON,x,y,w,1,TFT_rot,TFT_w1,TFT_ht) 
  a=y+h-1 
   dp=TFT.Draw(TFT_FFR,TFT_sc(),TFT_ON,x,a,w,1,TFT_rot,TFT_w1,TFT_ht) 
   dp=TFT.Draw(TFT_FFR,TFT_sc(),TFT_ON,x,y,1,h,TFT_rot,TFT_w1,TFT_ht) 
  a=x+w-1 
   dp=TFT.Draw(TFT_FFR,TFT_sc(),TFT_ON,a,y,1,h,TFT_rot,TFT_w1,TFT_ht) 
END SUB 


SUB TFT.FRect(x AS integer,y AS integer,w AS integer,h AS integer ) 'x,y coordinate of top left,width,height 
  LOCAL Integer  dp=TFT.Draw(TFT_FFR,TFT_sc(),TFT_ON,x,y,w,h,TFT_rot,TFT_w1,TFT_ht) 
END SUB 


SUB TFT.CRect(x AS integer,y AS integer,w AS integer,h AS integer) 'x,y coordinate of top left,width,height 
  LOCAL Integer  dp=TFT.Draw(TFT_FFR,TFT_sc(),TFT_OFF,x,y,w,h,TFT_rot,TFT_w1, TFT_ht) 
END SUB 


FUNCTION TFT.GetChar(char AS integer ) AS Integer 
  LOCAL i%=char<<3 
  TFT.GetChar=PEEK(WORD TFT_FontPtr+i%)+(PEEK(WORD TFT_FontPtr+i%+4)<<32) 
END FUNCTION 


SUB TFT.FCirc(x0%,y0%,r%)  'x,y coordinates of centre,radius 
  LOCAL  dp%=TFT.Draw(TFT_FFR,TFT_sc(),TFT_ON,x0%,y0%-r%,1,2*r%+1,TFT_rot,TFT_w1,TFT_ht) 
  TFT.FCircH(x0%,y0%,r%,3,0); 
END SUB 
   
   
SUB TFT.DRndRect(x AS integer,y AS integer,w AS integer,h AS integer,r AS integer ) 'x,y coordinates of top left,width,height,radius of corner
  LOCAL Integer dp 
   dp=TFT.Draw(TFT_FFR,TFT_sc(),TFT_ON,x+r,y,w-2*r,1,TFT_rot,TFT_w1,TFT_ht) 
   dp=TFT.Draw(TFT_FFR,TFT_sc(),TFT_ON,x+r,y+h-1,w-2*r,1,TFT_rot,TFT_w1,TFT_ht) 
   dp=TFT.Draw(TFT_FFR,TFT_sc(),TFT_ON,x,y+r,1,h-2*r,TFT_rot,TFT_w1,TFT_ht) 
   dp=TFT.Draw(TFT_FFR,TFT_sc(),TFT_ON,x+w-1,y+r,1,h-2*r,TFT_rot,TFT_w1,TFT_ht) 
  TFT.DCircH(x+r,y+r,r,1) 
  TFT.DCircH(x+w-r-1,y+r,r,2) 
  TFT.DCircH(x+w-r-1,y+h-r-1,r,4) 
  TFT.DCircH(x+r,y+h-r-1,r,8) 
END SUB 


SUB TFT.DCircH(x0 AS integer,y0 AS integer,r AS integer,cn AS integer) 
  LOCAL Integer f=1-r,ddF_x=1,ddF_y=-2*r,x=0,y=r,dp 
  DO WHILE (x<y) 
    IF (f>=0) THEN 
      y=y-1 
      ddF_y=ddF_y+2 
      f=f+ddF_y 
    ENDIF 
    x=x+1 
    ddF_x=ddF_x+2 
    f=f+ddF_x 
    IF (cn AND 4) THEN 
       dp=TFT.Draw(TFT_PIX,TFT_sc(),TFT_ON,x0+x,y0+y,TFT_rot,TFT_w1 ,TFT_ht) 
       dp=TFT.Draw(TFT_PIX,TFT_sc(),TFT_ON,x0+y,y0+x,TFT_rot,TFT_w1 ,TFT_ht) 
    ENDIF 
    IF (cn AND 2) THEN 
       dp=TFT.Draw(TFT_PIX,TFT_sc(),TFT_ON,x0+x,y0-y,TFT_rot,TFT_w1 ,TFT_ht) 
       dp=TFT.Draw(TFT_PIX,TFT_sc(),TFT_ON,x0+y,y0-x,TFT_rot,TFT_w1 ,TFT_ht) 
    ENDIF 
    IF (cn AND 8) THEN 
       dp=TFT.Draw(TFT_PIX,TFT_sc(),TFT_ON,x0-y,y0+x,TFT_rot,TFT_w1 ,TFT_ht) 
       dp=TFT.Draw(TFT_PIX,TFT_sc(),TFT_ON,x0-x,y0+y,TFT_rot,TFT_w1 ,TFT_ht) 
    ENDIF 
    IF (cn AND 1) THEN 
       dp=TFT.Draw(TFT_PIX,TFT_sc(),TFT_ON,x0-y,y0-x,TFT_rot,TFT_w1 ,TFT_ht) 
       dp=TFT.Draw(TFT_PIX,TFT_sc(),TFT_ON,x0-x,y0-y,TFT_rot,TFT_w1 ,TFT_ht) 
    ENDIF 
  LOOP 
END SUB 


SUB TFT.FCircH(x0 AS integer,y0 AS integer,r AS integer,cn AS integer,delta AS integer) 
  LOCAL Integer dp,f=1-r,ddF_x=1,ddF_y=-2 * r,x=0,y=r 
  DO WHILE x<y 
    IF f>=0 THEN 
      y=y-1 
      ddF_y=ddF_y+2 
      f=f+ddF_y 
    ENDIF 
    x=x+1 
    ddF_x=ddF_x+2 
    f=f+ddF_x 
    IF (cn AND 1) THEN 
       dp=TFT.Draw(TFT_FFR,TFT_sc(),TFT_ON,x0+x,y0-y,1,2*y+1+delta, TFT_rot,TFT_w1,TFT_ht) 
       dp=TFT.Draw(TFT_FFR,TFT_sc(),TFT_ON,x0+y,y0-x,1,2*x+1+delta, TFT_rot,TFT_w1,TFT_ht) 
    ENDIF 
    IF (cn AND 2) THEN 
       dp=TFT.Draw(TFT_FFR,TFT_sc(),TFT_ON,x0-x,y0-y,1,2*y+1+delta, TFT_rot,TFT_w1,TFT_ht) 
       dp=TFT.Draw(TFT_FFR,TFT_sc(),TFT_ON,x0-y,y0-x,1,2*x+1+delta, TFT_rot,TFT_w1,TFT_ht) 
    ENDIF 
  LOOP 
END SUB 


SUB TFT.FRndRect(x AS integer,y AS integer,w AS integer,h AS integer,r AS integer) 'x,y coordinates of top left,width,height,radius of corner 
  LOCAL Integer dp 
   dp=TFT.Draw(TFT_FFR,TFT_sc(),TFT_ON,x+r,y,w-2*r,h,TFT_rot,TFT_w1,TFT_ht) 
  TFT.FCircH(x+w-r-1,y+r,r,1,h-2*r-1) 
  TFT.FCircH(x+r,y+r,r,2,h-2*r-1) 
END SUB 


SUB TFT.SetRot(x%) 'sets screen rotation: 0=normal,1=invert,2=rotate right,3-rotate left 
  TFT_rot=(x% AND 3) 
  TFT_rot_wi=TFT_w1 
  TFT_rot_ht=TFT_ht 
  IF x%>=2 THEN 
    TFT_rot_wi=TFT_ht 
    TFT_rot_ht=TFT_w1 
  ENDIF 
END SUB 

  ' 
  ' CFunctions 
  ' 
CFUNCTION TFT.SGetNextUpdate 
  00000000 
  27bdffa8 afb00054 8fb80068 8faf006c 8fae0070 24020040 a0820001 8f090000 
  1120000b 00001021 00094880 2403ffff 27aa0010 01424021 ad030000 27b00030 
  02024021 24420004 1449fffa ad030000 8ce20000 1040002a 00004021 8f190000 
  00005821 240dffff 000840c0 01e81021 8c430004 8c420000 afa20000 afa30004 
  01c84021 8d020000 8d030004 afa20008 13200016 afa3000c 8f0c0000 27a30010 
  27a80030 00001021 03a25021 27b00008 02024821 914a0000 91290000 51490007 
  24420001 8c690000 552d0003 ad0b0000 ac6b0000 ad0b0000 24420001 24630004 
  004c482b 1520fff0 25080004 256b0001 8ce20000 0162102b 1440ffdb 01604021 
  8f020000 2442ffff 00004021 04400036 00004821 00021880 27a70010 00e31821 
  240bffff 2408ffff 8c670000 00e83826 0047580b 2442ffff 0441fffb 2463fffc 
  00004021 2402ffff 11620027 00004821 000b1080 03a21021 8c4a0010 acaa0000 
  8c4d0030 01aa102a 1440001b 24070001 000a28c0 01e57821 01c52821 03ab6021 
  8de20000 8de30004 afa20000 afa30004 8ca20000 8ca30004 afa20008 afa3000c 
  24e70001 91820000 a1820008 00871821 a0620000 8fa20008 8fa3000c aca20000 
  aca30004 254a0001 25ef0008 01aa102a 1040ffeb 24a50008 accb0000 a0870000 
  00e04021 00074fc3 01001021 01201821 8fb00054 03e00008 27bd0058 
END CFUNCTION 

'
'D:\Peter\MPLABXProjects\maincfunction.X\dist\default\production\draw.bas

'
'draw  2014-12-15 17:15:05 CFuncGen Ver 1.0.21 by user=Peter
'
CFunction TFT.draw
'localfastfillrect
	0000074E
	27bdffa8 afbe0054 afb70050 afb6004c afb50048 afb40044 afb30040 afb2003c 
	afb10038 afb00034 8fb90068 8faf006c 8fb10070 8fb00074 8fb30078 8fb4007c 
	8fb50080 8fb60084 8fae0088 8fb8008c 8fb20090 8fad0094 93b70098 afb70020 
	2417ffff a3b70008 241efffe a3be0009 241efffc a3be000a 241efff8 a3be000b 
	241efff0 a3be000c 241effe0 a3be000d 241effc0 a3be000e 241eff80 a3be000f 
	241e0001 a3be0010 241e0003 a3be0011 241e0007 a3be0012 241e000f a3be0013 
	241e001f a3be0014 241e003f a3be0015 241e007f a3be0016 a3b70017 01d8b825 
	56e0003b 24170001 01ed102a 14400007 2722ffff 15af01c9 00001021 0332102b 
	104001c6 00001021 2722ffff 0059282b 25e3ffff 00a32821 00531821 0062102b 
	00b42821 00451021 00402821 004d102a 1440000a 00606021 55a50005 264cffff 
	0072182b 14600005 00000000 264cffff 0192282b 25a2ffff 00a22821 06000007 
	00005021 155001ad 00001021 8fa30020 0223102b 104001a9 00001021 2622ffff 
	0051402b 2603ffff 01034021 00551821 0062102b 01164021 00481021 00604821 
	044001a0 00404021 15420006 8fa20020 8fb70020 0077182b 5460019b 02201021 
	8fa20020 244cffff 10000196 000c2fc3 15d70034 24170002 17000032 00000000 
	0019c827 000f7827 03329021 0259c82b 01ed6821 032d6821 02406021 05a00186 
	01a02821 00118827 00108027 8fa30020 0223b821 02f1882b 02308021 02e04821 
	0600017d 02004021 24020001 00539823 0053102b 01a26823 02729021 0253982b 
	01b4a023 02745021 000a1fc3 00037827 000fc7c3 02581024 01581824 00405821 
	00605021 24020001 0055a823 0055102b 02028023 02b7b821 02f5a82b 0216b023 
	02b66821 000d7fc3 000fc827 001987c3 02f07024 01b07824 01c01021 10000088 
	01e01821 55d7004a 24170003 57000048 24170003 00111827 00102827 00721021 
	0043182b 00ad2821 00651821 00602821 006d182a 1460000a 00406021 55a50005 
	264cffff 0052102b 14400006 24020001 264cffff 0192282b 25a2ffff 00a22821 
	24020001 00554023 0048102b 00a21023 010c1821 0068402b 00561023 00605821 
	01025021 000a1fc3 00034827 00091fc3 afa30028 afa3002c 01631024 01431824 
	00405821 00605021 05e00007 0000b821 16ef0132 00001021 8fa30020 0323102b 
	1040012e 00001021 2722ffff 0059402b 25e3ffff 01034021 00531821 0062102b 
	01144021 00481021 00604821 0440000d 00404021 16e20006 8fa20020 8fb70020 
	0077182b 54600008 03201021 8fa20020 2449ffff 000947c3 03201021 10000003 
	01e01821 03201021 01e01821 24170003 55d7003c 0003c7c3 5700003a 0003c7c3 
	020d102a 14400007 2622ffff 15b0010b 00001021 0232102b 10400108 00001021 
	2622ffff 0051282b 2603ffff 00a31821 0055a821 02a2102b 0076b021 00561021 
	00402821 004d102a 1440000a 02a06021 55a50005 264cffff 02b2a82b 56a00006 
	0019c827 264cffff 0192282b 25adffff 00ad2821 0019c827 000f7827 8fa30020 
	03235021 0159c82b 032f7821 01404821 05e000e9 01e04021 24020001 00539823 
	0053102b 01e27823 026a5021 0153982b 01f4a023 02745821 01401021 05600004 
	01601821 02205821 10000005 02005021 02205821 02005021 00001021 00001821 
	0003c7c3 33180007 0302a021 0298c02b 0303c021 00186f40 0014a0c2 01b4a025 
	0018c0c3 0280c821 000877c3 31ce0007 01c96821 01ae702b 01c84021 00087740 
	000d68c2 01cd6825 0008b0c3 01a08821 02c0f021 0014a0c0 0054a023 000d68c0 
	012d6823 17310038 afad0020 17160037 27350001 00aa102a 14400035 02b9b82b 
	15450004 000b68c0 018b102b 14400031 02f8b821 008d6821 01607021 01407821 
	00c7b825 03b98021 8fa80020 03a8a821 03b49821 01a09021 8da20000 8da30004 
	afa20000 12e00008 afa30004 92a30010 92620008 00621024 92030000 00431025 
	10000008 a2020000 92a30010 92620008 00621024 00021027 92030000 00431024 
	a2020000 8fa80000 8fa90004 ae480000 ae490004 25c20001 004e702b 01cf1821 
	00407021 00607821 00a3182a 14600006 25ad0008 15e5ffe0 01a09021 0182102b 
	5040ffde 8da20000 27350001 02b9b82b 02f8b821 02a06821 02d7102a 14400041 
	02e0c021 16fe0005 00aa102a 0235102b 5440003d 02f6b02a 00aa102a 5440003a 
	02f6b02a 15450004 000b18c0 018b102b 54400035 02f6b02a 00831821 01607021 
	01407821 00c79025 03b91021 03b4a021 03b1c821 8fa80020 03a89821 00608021 
	8c680000 8c690004 afa80000 1240000a afa90004 92890008 90480000 01284025 
	a0480000 92690010 93280000 01284025 1000000b a3280000 92880008 00084027 
	90490000 01094024 a0480000 92680010 00084027 93290000 01094024 a3280000 
	8fa80000 8fa90004 ae080000 ae090004 25c80001 010e702b 01cf4821 01007021 
	01207821 00a9482a 15200006 24630008 15e5ffdb 00608021 0188402b 5100ffd9 
	8c680000 02f6b02a 56c00006 03b5a821 57d80042 8fbe0054 02b1102b 10400034 
	03b5a821 00aa782a 000b10c0 00822021 00c73025 2407ffff 10000023 018bc82b 
	01008021 8d020000 8d030004 afa20000 10c00003 afa30004 10000002 a2a70000 
	a2a00000 8fa20000 8fa30004 ae020000 ae030004 25220001 0049482b 012e1821 
	00404821 00607021 00a3182a 14600006 25080008 15c5ffeb 01008021 0182102b 
	5040ffe9 8d020000 25a20001 004d182b 00406821 0078c021 14510003 26b50001 
	531e0016 8fbe0054 15e0fff8 25a20001 55450004 00804021 1720fff5 004d182b 
	00804021 01604821 1000ffd5 01407021 1000000a 8fbe0054 00001021 10000006 
	00001821 02201021 02001821 03205821 1000fee6 01e05021 8fbe0054 8fb70050 
	8fb6004c 8fb50048 8fb40044 8fb30040 8fb2003c 8fb10038 8fb00034 03e00008 
	27bd0058 

'localdrawPixel
27bdfff8 afb10004 afb00000 8fb80018 8faf001c 8fae0020 8fad0024 
	8fa30028 8fab002c 8fb00030 8faa0034 8fb10038 006bc825 17200006 8fac003c 
	03004821 01e01021 01c04021 10000020 01a02821 24190001 14790010 24190002 
	1560000e 00000000 0018c027 000f7827 03104821 0138c02b 01ea7821 030f1021 
	000e7027 000d6827 01d14021 010e702b 01ac6821 1000001a 01cd2821 1479000d 
	24190003 1560000b 00000000 03004021 01e02821 000e7027 000d6827 01d04821 
	012e702b 01aa6821 1000000d 01cd1021 24190003 5479000b 004a582b 15600008 
	0018c027 000f7827 03114021 0118c02b 01ec7821 030f2821 01c04821 01a01021 
	004a582b 15600007 24030001 55420005 00001821 0130802b 16000003 306300ff 
	00001821 306300ff 1060003a 00ac182b 14600007 24020001 55850005 00001021 
	0111882b 16200003 304200ff 00001021 304200ff 1040002f 00c73025 10c00015 
	00001021 14a00008 00001821 14a00004 24050001 2d050020 10a00004 24050001 
	10000003 01051004 24050001 01051804 000928c0 00852021 8c850000 00a22825 
	ac850000 8c850004 00a32825 10000016 ac850004 54a00009 24050001 14a00003 
	24050001 2d020020 10400005 01052804 00051027 10000004 2403ffff 01052804 
	00051827 2402ffff 000928c0 00852021 8c850000 00a22824 ac850000 8c850004 
	00a32824 ac850004 01202021 10000003 01002821 00002021 00002821 00801021 
	00a01821 8fb10004 8fb00000 03e00008 27bd0008 

'drawline
27bdffa0 afbf005c afbe0058 
	afb70054 afb60050 afb5004c afb40048 afb30044 afb20040 afb1003c afb00038 
	0080a821 afa60068 afa7006c 8fa20070 8fa30078 8fa40080 8fa50088 00408021 
	00609021 00809821 0065a02a 00a33023 00653823 00f4300a 00c0a021 0044402a 
	00823823 00443023 00e8300b 00d4a02a 12800005 00a0b021 00a09821 0080b021 
	00608021 00409021 0270102a 10400008 0256102a 02401021 02c09021 0040b021 
	02001021 02608021 00409821 0256102a 10400007 0270b823 02d2b023 00178fc2 
	02378821 00118843 10000006 241e0001 0256b023 00178fc2 02378821 00118843 
	241effff 0270102a 1440003a 8fbf005c 5280001a afb00010 afb20010 001217c3 
	afa20014 afb00018 001017c3 afa2001c 8fa20090 8fa30094 afa20020 afa30024 
	8fa60098 8fa7009c afa60028 afa7002c 8fa200a0 8fa300a4 afa20030 afa30034 
	02a02021 8fa60068 8fa7006c 0411FF1D 00000000 10000018 02368823 001017c3 
	afa20014 afb20018 001217c3 afa2001c 8fa60090 8fa70094 afa60020 afa70024 
	8fa20098 8fa3009c afa20028 afa3002c 8fa600a0 8fa700a4 afa60030 afa70034 
	02a02021 8fa60068 8fa7006c 0411FF05 00000000 02368823 06210003 26100001 
	025e9021 02378821 0270102a 1040ffc8 8fbf005c 8fbe0058 8fb70054 8fb60050 
	8fb5004c 8fb40048 8fb30044 8fb20040 8fb1003c 8fb00038 03e00008 27bd0060 

'drawchar
	27bdff38 afbf00c4 afbe00c0 afb700bc afb600b8 afb500b4 afb400b0 afb300ac 
	afb200a8 afb100a4 afb000a0 afa400c8 8fa200d8 afa2006c 8fa300dc afa30074 
	8fa400e0 afa40080 8fa500e4 afa50084 8fb000e8 8fb400ec 8fa200f0 afa20088 
	8fa300f4 afa30090 8fa40108 afa40078 8fa5010c afa5007c afa60048 00431025 
	144000b7 afa7004c 8fa3006c 24620005 0043182b afa20060 8fa40074 00641821 
	afa30068 27b50048 24050005 afa50064 0200b021 0280b821 8fa60078 30c600ff 
	afa6005c 0200f021 10000090 afb40070 92a20000 02021007 30420001 1040003a 
	24040001 24020001 17c2001d 8fa20054 8fa30070 5460001b afa20010 8fa40060 
	afa40010 8fa50068 afa50014 afb20018 afb4001c 8fa200f8 8fa300fc afa20020 
	afa30024 8fa40100 8fa50104 afa40028 afa5002c 8fa50078 afa50030 8fa6007c 
	afa60034 8fa400c8 24060001 00003821 0411FE9C 00000000 10000052 26100001 
	afa20010 8fa30058 afa30014 afb10018 afb3001c afb60020 afb70024 afb60028 
	afb7002c 8fa400f8 8fa500fc afa40030 afa50034 8fa20100 8fa30104 afa20038 
	afa3003c 8fa3005c afa30040 8fa400c8 24060001 00003821 0411FC69 00000000 
	10000038 26100001 17c4001d 8fa50054 8fa50070 14a0001a 8fa50054 8fa60060 
	afa60010 8fa20068 afa20014 afb20018 afb4001c 8fa400f8 8fa500fc afa40020 
	afa50024 8fa20100 8fa30104 afa20028 afa3002c 8fa30078 afa30030 8fa4007c 
	afa40034 8fa400c8 00003021 00003821 0411FE64 00000000 1000001a 26100001 
	afa50010 8fa60058 afa60014 afb10018 afb3001c afb60020 afb70024 afb60028 
	afb7002c 8fa200f8 8fa300fc afa20030 afa30034 8fa40100 8fa50104 afa40038 
	afa5003c 8fa5005c afa50040 8fa400c8 00003021 00003821 0411FC31 00000000 
	26100001 02361021 0051182b 02779821 00408821 00739821 26420001 0052182b 
	00409021 24060008 1606ff81 0074a021 8fa20064 2442ffff afa20064 8fa30060 
	2462ffff 0043202b 8fa50068 24a3ffff afa20060 00831821 afa30068 2402ffff 
	8fa60064 10c200f1 26b50001 8fa40064 009e0019 00001012 00001810 8fa50070 
	70a43002 00c31821 8fa5006c 00452021 0082282b 8fa60074 00661021 afa40054 
	00a21021 afa20058 8fb20080 8fb40084 02408821 02809821 1000ff5d 00008021 
	24020001 8fa30088 146200dc 24020002 8fa40090 148000d9 00142023 00101023 
	0002182b afa20094 00832023 afa40098 8fa5006c 24a20001 0045202b 8fa60074 
	00862021 00501823 0043102b 00942023 afa30068 00822023 afa40070 afa50060 
	afa60064 27b6004d 27a20047 afa20050 8fa30080 2463fff9 afa3008c 8fa40080 
	24820001 0044182b 8fa50084 00651821 0050a823 0055102b 00741823 00621823 
	afa3005c 8fb700c8 100000a1 02009021 92c20000 02021007 30420001 10400041 
	24020001 5642001c afbe0010 5680001a afbe0010 8fa60060 afa60010 8fa20064 
	afa20014 afb10018 afb3001c 8fa400f8 8fa500fc afa40020 afa50024 8fa20100 
	8fa30104 afa20028 afa3002c 8fa30078 afa30030 8fa4007c afa40034 02e02021 
	24060001 00003821 0411FDCE 00000000 10000063 2610ffff 8fa50054 afa50014 
	02120019 00001012 00001810 72902002 00831821 02a22023 02a4282b 8fa6005c 
	00c31023 00452823 afa40018 afa5001c afb20020 afb40024 afb20028 afb4002c 
	8fa200f8 8fa300fc afa20030 afa30034 8fa40100 8fa50104 afa40038 afa5003c 
	8fa50058 afa50040 02e02021 24060001 00003821 0411FB92 00000000 10000040 
	2610ffff 5642001c afbe0010 5680001a afbe0010 8fa60060 afa60010 8fa20064 
	afa20014 afb10018 afb3001c 8fa400f8 8fa500fc afa40020 afa50024 8fa20100 
	8fa30104 afa20028 afa3002c 8fa30078 afa30030 8fa4007c afa40034 02e02021 
	00003021 00003821 0411FD8E 00000000 10000023 2610ffff 8fa50054 afa50014 
	02120019 00001012 00001810 72902002 00831821 02a22023 02a4282b 8fa6005c 
	00c31023 00452823 afa40018 afa5001c afb20020 afb40024 afb20028 afb4002c 
	8fa200f8 8fa300fc afa20030 afa30034 8fa40100 8fa50104 afa40038 afa5003c 
	8fa50058 afa50040 02e02021 00003021 00003821 0411FB52 00000000 2610ffff 
	26220001 0051182b 00408821 2402ffff 1602ff77 00739821 8fa60068 8fa30094 
	00c31021 0046182b 8fa50070 8fa60098 00a62021 afa20068 00642021 afa40070 
	8fa30060 2462ffff 0043182b 8fa50064 24a4ffff afa20060 00642021 afa40064 
	26d6ffff 8fa60050 52c600da 02408021 8fbe0068 8fa20070 afa20054 8fa3008c 
	8fa40080 0064982b 8fa50084 24a2ffff 00608821 02629821 24100007 8fa60078 
	30c600ff 1000ff52 afa60058 03c08021 8fb40070 24020002 8fa30088 146200c6 
	24020003 8fa40090 148000c4 8fa60088 00101023 0002182b 00142023 afa20088 
	00832023 afa4008c 8fa5006c 24a20001 0045202b 8fa60074 00862021 00501823 
	0043102b 00942023 afa30064 00822023 afa40068 afa00060 0200b021 0280b821 
	27a20047 afa20050 8fa30078 306300ff afa3005c 0200f021 10000099 afb40070 
	92020000 02a21024 1040003a 24060001 24040001 17c4001d 8fa50054 8fa50070 
	14a0001a 8fa50054 8fa6006c afa60010 8fa20074 afa20014 afb20018 afb4001c 
	8fa400f8 8fa500fc afa40020 afa50024 8fa20100 8fa30104 afa20028 afa3002c 
	8fa30078 afa30030 8fa4007c afa40034 8fa400c8 24060001 00003821 0411FCF9 
	00000000 10000052 2610ffff afa50010 8fa60058 afa60014 afb10018 afb3001c 
	afb60020 afb70024 afb60028 afb7002c 8fa200f8 8fa300fc afa20030 afa30034 
	8fa40100 8fa50104 afa40038 afa5003c 8fa5005c afa50040 8fa400c8 24060001 
	00003821 0411FAC6 00000000 10000038 2610ffff 17c6001d 8fa20054 8fa20070 
	1440001a 8fa20054 8fa3006c afa30010 8fa40074 afa40014 afb20018 afb4001c 
	8fa200f8 8fa300fc afa20020 afa30024 8fa40100 8fa50104 afa40028 afa5002c 
	8fa50078 afa50030 8fa6007c afa60034 8fa400c8 00003021 00003821 0411FCC1 
	00000000 1000001a 2610ffff afa20010 8fa30058 afa30014 afb10018 afb3001c 
	afb60020 afb70024 afb60028 afb7002c 8fa400f8 8fa500fc afa40030 afa50034 
	8fa20100 8fa30104 afa20038 afa3003c 8fa3005c afa30040 8fa400c8 00003021 
	00003821 0411FA8E 00000000 2610ffff 02361021 0051182b 02779821 00408821 
	00739821 26420001 0052182b 00409021 8fa40050 1604ff82 0074a021 8fa50060 
	24a50001 afa50060 8fa60064 8fa30088 00c31021 0046202b 8fa50068 8fa6008c 
	00a61821 afa20064 00831821 afa30068 8fa3006c 2462ffff 0043202b 8fa50074 
	24a3ffff afa2006c 00831821 afa30074 24020008 8fa60060 10c20103 8fa20048 
	24020001 8fa30060 0062a804 8fa40064 afa40054 8fa50068 afa50058 27b0004d 
	8fb20080 8fb40084 02408821 1000ff5c 02809821 24020003 8fa60088 14c200f1 
	8fa20090 144000ef 00101023 0002182b 00142023 afa20090 00832023 afa40094 
	00101742 001418c0 00431825 001020c0 00901023 0082202b 00741823 00641823 
	8fa5006c 00452021 0082102b 8fa60074 00661821 afa40068 00431821 afa30070 
	24a20007 0045182b afa20060 00661821 afa30074 24020007 afa20064 8fa30080 
	24620001 0043282b 8fa40084 00a42821 00101823 0003202b 00143023 00c42023 
	00033782 00042080 00c43025 00032080 00901821 0064202b 00d43021 00862021 
	000337c2 00042040 00c42025 00031840 00431821 afa30088 0062102b 00a41821 
	00431821 afa30098 8fa50080 24a5fffb afa5008c 8fa60080 00a6182b 8fa40084 
	2482ffff 00621021 afa20080 0280b021 10000098 0200a021 92020000 02e21024 
	10400039 24060001 24050001 1685001c 8fa50058 56c0001b afa50010 8fa60060 
	afa60010 8fa20074 afa20014 afb20018 afb5001c 8fa400f8 8fa500fc afa40020 
	afa50024 8fa20100 8fa30104 afa20028 afa3002c 8fa30078 afa30030 8fa4007c 
	afa40034 8fa400c8 24060001 00003821 0411FC0C 00000000 10000051 26100001 
	afa50010 8fa6006c afa60014 afb10018 afb3001c afb40020 afb60024 afb40028 
	afb6002c 8fa200f8 8fa300fc afa20030 afa30034 8fa40100 8fa50104 afa40038 
	afa5003c 8fa5005c afa50040 8fa400c8 24060001 00003821 0411F9D9 00000000 
	10000037 26100001 1686001c 8fa50058 56c0001b afa50010 8fa20060 afa20010 
	8fa30074 afa30014 afb20018 afb5001c 8fa400f8 8fa500fc afa40020 afa50024 
	8fa20100 8fa30104 afa20028 afa3002c 8fa30078 afa30030 8fa4007c afa40034 
	8fa400c8 00003021 00003821 0411FBD5 00000000 1000001a 26100001 afa50010 
	8fa6006c afa60014 afb10018 afb3001c afb40020 afb60024 afb40028 afb6002c 
	8fa200f8 8fa300fc afa20030 afa30034 8fa40100 8fa50104 afa40038 afa5003c 
	8fa5005c afa50040 8fa400c8 00003021 00003821 0411F9A2 00000000 26100001 
	023e1021 0051182b 8fa60054 02669821 00408821 00739821 26420001 0052182b 
	00409021 8fa20050 1602ff83 0075a821 8fa30064 2463ffff afa30064 8fa40068 
	8fa50090 00851021 0044202b 8fa60070 8fa50094 00c51821 afa20068 00831821 
	afa30070 8fa60060 24c2ffff 0046202b 8fa50074 24a3ffff afa20060 00831821 
	afa30074 2402ffff 8fa60064 10c20016 8fa20048 24170001 8fa20064 0057b804 
	8fa30068 afa30058 8fa40070 afa4006c 27b00048 0280f021 afb60054 8fb10088 
	8fb30098 8fb2008c 8fb50080 27a5004e afa50050 8fa60078 30c600ff 1000ff56 
	afa6005c 8fa20048 8fa3004c 8fbf00c4 8fbe00c0 8fb700bc 8fb600b8 8fb500b4 
	8fb400b0 8fb300ac 8fb200a8 8fb100a4 8fb000a0 03e00008 27bd00c8 

'pstring
27bdff60 
	afbf009c afbe0098 afb70094 afb60090 afb5008c afb40088 afb30084 afb20080 
	afb1007c afb00078 afa40054 00c08821 8fb200b0 8fb500b4 8fbe00b8 8fa200bc 
	afa20048 8fb400c0 8fb700c4 8fa300d4 afa30074 8fb600dc 8fa400d0 afa4004c 
	afa30050 92c20000 1840007c 00e09821 001e1fc2 8fa50048 00051040 00621025 
	001e2040 00042f82 00021880 00a31825 001e28c0 00a42023 00a4282b 00621023 
	afa40064 00451023 afa20068 001e1023 0002182b 8fa50048 00052023 00831823 
	00022782 00031880 00831825 00022080 009e1021 0044202b 00651821 00831821 
	00022fc2 00031840 00021040 afa2006c 00a31825 afa30070 24100001 8fa2004c 
	000217c3 afa20058 8fa30050 00031fc3 afa3005c 02972025 afa40060 02d01021 
	90420000 000210c0 8fa50054 00451021 8c460000 8c470004 afb10010 afb30014 
	afb20018 afb5001c afbe0020 8fa20048 afa20024 afb40028 afb7002c 8fa400c8 
	8fa500cc afa40030 afa50034 8fa5004c afa50038 8fa20058 afa2003c 8fa30050 
	afa30040 8fa4005c afa40044 8fa400d8 0411FC1B 00000000 8fa50060 14a00009 
	24050001 8fa30064 02231021 0051182b 8fa40068 02649821 00408821 10000017 
	00739821 1685000a 24020002 16e00008 8fa3006c 02231021 0051182b 8fa40070 
	02649821 00408821 10000017 00739821 1682000b 24050003 16e00008 8fa50064 
	02451021 0052182b 8fa40068 02a4a821 00409021 1000000c 0075a821 24050003 
	5685000a 26100001 16e00007 8fa3006c 02431021 0052182b 8fa40070 02a4a821 
	00409021 0075a821 26100001 92c20000 0050102a 1040ffb2 02d01021 8fa50074 
	00051fc3 00a01021 8fbf009c 8fbe0098 8fb70094 8fb60090 8fb5008c 8fb40088 
	8fb30084 8fb20080 8fb1007c 8fb00078 03e00008 27bd00a0 

'main
27bdffb0 afbf004c 
	00e07021 8fad0060 8fac0064 8fab0068 8faa006c 8fa90070 8c820000 8c830004 
	00432025 1480001d 8fa80074 8cc20000 8ce30000 afa30010 00031fc3 afa30014 
	8da30000 afa30018 00031fc3 afa3001c 8d830000 afa30020 00031fc3 afa30024 
	8d630000 afa30028 00031fc3 afa3002c 8d430000 afa30030 00031fc3 afa30034 
	00a02021 00403021 00023fc3 0411FAA5 00000000 10000095 8fbf004c 24040001 
	14440025 24040002 14600023 00000000 8cc20000 8ce30000 afa30010 00031fc3 
	afa30014 8da30000 afa30018 00031fc3 afa3001c 8d830000 afa30020 00031fc3 
	afa30024 8d630000 afa30028 00031fc3 afa3002c 8d430000 afa30030 00031fc3 
	afa30034 8d230000 afa30038 00031fc3 afa3003c 91030000 afa30040 00a02021 
	00403021 00023fc3 0411F865 00000000 1000006e 8fbf004c 14440025 24040003 
	14600023 00000000 8cc70004 8cc60000 8dc20000 afa20010 000217c3 afa20014 
	8da20000 afa20018 000217c3 afa2001c 8d820000 afa20020 000217c3 afa20024 
	8d620000 afa20028 000217c3 afa2002c 8d420000 afa20030 000217c3 afa20034 
	8d220000 afa20038 000217c3 afa2003c 91020000 afa20040 afa00044 00a02021 
	0411FB67 00000000 10000048 8fbf004c 14440025 24040004 14600023 00000000 
	8cc70004 8cc60000 8dc20000 afa20010 000217c3 afa20014 8da20000 afa20018 
	000217c3 afa2001c 8d820000 afa20020 000217c3 afa20024 8d620000 afa20028 
	000217c3 afa2002c 8d420000 afa20030 000217c3 afa20034 8d220000 afa20038 
	000217c3 afa2003c 91020000 afa20040 afa00044 00a02021 0411FABE 00000000 
	10000022 8fbf004c 14440020 8fbf004c 1460001e 00000000 8ca40000 8ca50004 
	8cc70004 8cc60000 8dc20000 8dc30004 afa20010 afa30014 8da20000 8da30004 
	afa20018 afa3001c 8d820000 8d830004 afa20020 afa30024 8d620000 8d630004 
	afa20028 afa3002c 8d420000 8d430004 afa20030 afa30034 afa90038 afa8003c 
	0411FE9E 00000000 8fbf004c 03e00008 27bd0050 
End CFunction

CFUNCTION TFT_Font 
  00000000 
  00000000 00000000 4f5b3e00 00003e5b 4f6b3e00 00003e6b 7c3e1c00 00001c3e 
  7e3c1800 0000183c 7d571c00 00001c57 7f5e1c00 00001c5e 3c180000 00000018 
  c3e7ff00 0000ffe7 24180000 00000018 dbe7ff00 0000ffe7 3a060e00 00003048 
  79292600 00002629 05050700 0000407f 05253f00 0000407f e73c5a00 00005a3c 
  1c1c0800 00007f3e 1c3e7f00 0000081c 7f221400 00001422 005f5f00 00005f5f 
  7f017f00 00000609 89956a00 00000066 60606000 00006060 ffa29400 000094a2 
  7e040800 00000804 7e201000 00001020 2a1c0800 00000808 2a080800 0000081c 
  10101000 00001e10 0c1e0c00 00000c1e 3e383000 00003038 3e0e0600 0000060e 
  00000000 00000000 5f000000 00000000 00070000 00000007 147f1400 0000147f 
  7f2a1200 0000242a 08646200 00002313 56205000 00003649 07030000 00000008 
  22410000 0000001c 221c0000 00000041 7f1c2a00 00002a1c 3e080800 00000808 
  70300000 00000080 08080800 00000808 60600000 00000000 08040200 00002010 
  49453e00 00003e51 7f400000 00000042 49494600 00007249 494d3300 00002141 
  127f1000 00001814 45453900 00002745 49493100 00003c4a 11090700 00004121 
  49493600 00003649 49291e00 00004649 14000000 00000000 34000000 00000040 
  14224100 00000008 14141400 00001414 22140800 00000041 59090600 00000201 
  5d594e00 00003e41 11127c00 00007c12 49493600 00007f49 41412200 00003e41 
  41413e00 00007f41 49494100 00007f49 09090100 00007f09 41517300 00003e41 
  08087f00 00007f08 7f410000 00000041 413f0100 00002040 14224100 00007f08 
  40404000 00007f40 1c027f00 00007f02 08107f00 00007f04 41413e00 00003e41 
  09090600 00007f09 51215e00 00003e41 19294600 00007f09 49493200 00002649 
  7f010300 00000301 40403f00 00003f40 40201f00 00001f20 38403f00 00003f40 
  08146300 00006314 78040300 00000304 494d4300 00006159 41414100 0000007f 
  08102000 00000204 41417f00 00000041 01020400 00000402 40404000 00004040 
  07080000 00000003 54784000 00002054 44443800 00007f28 44442800 00003844 
  44287f00 00003844 54541800 00003854 7e090200 00000008 a49c7800 000018a4 
  04047800 00007f08 7d400000 00000044 403d0000 00002040 28440000 00007f10 
  7f400000 00000041 78047800 00007c04 04047800 00007c08 44443800 00003844 
  24241800 0000fc18 2418fc00 00001824 04040800 00007c08 54542400 00004854 
  3f442400 00000404 40207c00 00003c40 40201c00 00001c20 30403c00 00003c40 
  10284400 00004428 90907c00 00004c90 544c4400 00004464 36410000 00000008 
  77000000 00000000 36080000 00000041 02040200 00000201 23263c00 00003c26 
  a1611200 00001ea1 40207a00 00003a40 54555900 00003854 55794100 00002155 
  54784200 00002254 54784000 00002155 55794000 00002054 52721200 00000c1e 
  55555900 00003955 54545900 00003954 54545800 00003955 457c4100 00000000 
  457d4200 00000002 457c4000 00000001 11127d00 00007d12 2528f000 0000f028 
  55450000 00007c54 547c5400 00002054 097f4900 00007c0a 49493200 00003249 
  44443a00 00003a44 48483000 0000324a 41217a00 00003a41 40207800 00003a42 
  a0a07d00 0000009d 42423d00 00003d42 40403d00 00003d40 ff242400 00003c24 
  49436600 0000487e fc2f2b00 00002b2f 29f62000 0000ff09 7e090300 0000c088 
  54794100 00002054 447d4100 00000000 484a3200 00003048 40227a00 00003840 
  0a0a7200 0000007a 19317d00 00007d0d 292f2800 00002629 29292600 00002629 
  4d402000 00003048 08080800 00003808 08083800 00000808 c8acba00 00002f10 
  2834fa00 00002f10 7b000000 00000000 2a142200 00000814 2a140800 00002214 
  5500aa00 0000aa00 aa55aa00 0000aa55 00ff0000 00000000 10ff0000 00001010 
  14ff0000 00001414 ff00ff00 00001010 f010f000 00001010 14fc0000 00001414 
  f700ff00 00001414 ff00ff00 00000000 f404fc00 00001414 17101f00 00001414 
  1f101f00 00001010 141f0000 00001414 10f00000 00001010 001f1000 00000000 
  101f1000 00001010 10f01000 00001010 00ff1000 00000000 10101000 00001010 
  10ff1000 00001010 00ff1400 00000000 ff00ff00 00000000 1f101700 00000000 
  fc04f400 00000000 17101700 00001414 f404f400 00001414 ff00f700 00000000 
  14141400 00001414 f700f700 00001414 14171400 00001414 1f101f00 00001010 
  14f41400 00001414 f010f000 00001010 1f101f00 00000000 001f1400 00000000 
  00fc1400 00000000 f010f000 00000000 ff10ff00 00001010 14ff1400 00001414 
  101f0000 00001010 00f01000 00000000 ffffff00 0000ffff f0f0f000 0000f0f0 
  ff000000 0000ffff 00ffff00 00000000 0f0f0f00 00000f0f 44384400 00003844 
  4a4a3400 0000fc4a 02060600 00007e02 027e0200 0000027e 49416300 00006355 
  443c0400 00003844 201e2000 0000407e 7e020200 00000602 e7a59900 000099a5 
  492a1c00 00001c2a 01724c00 00004c72 4d4d3000 0000304a 78483000 00003048 
  5a463d00 0000bc62 49490000 00003e49 01017e00 00007e01 2a2a2a00 00002a2a 
  5f444400 00004444 4a444000 00004051 4a514000 00004044 ff010300 00000000 
  ff000000 0000e080 6b6b0800 00000808 36243600 00003612 090f0600 0000060f 
  18180000 00000000 10100000 00000000 ff010100 00003040 01011e00 0000001f 
  1d171200 00000019 3c3c3c00 0000003c 00000000 00000000 
END CFUNCTION 
   
  ' 
  'isI2COpen  2014-12-08 12:34:39 CFuncGen Ver 1.0.21 by user=Peter 
  ' 
  ' Returns 1 if I2C Bus is OPEN, 0 otherwise 
  ' 
CFUNCTION TFT.isI2COpen 
  00000000 
  3c02bf80 8c425000 7c4203c0 03e00008 00001821 
END CFUNCTION 
   
  '-------------------Delete ALL text below when using Library in your own programs 
   
   
SUB TestSuite 
   
  CPU 48 
   
  CONST i2caddr=&H3C 
   
  PRINT "Starting initialisation" 
  PRINT "Using  1.3inch I2C SSD1306" 
   
  'initialise the display 
  TFT.Init i2caddr,2,400 
   
PRINT "starting main" 
  'Variables for use in main 
  LOCAL Integer i,xfs,yfs,x0=0,y0=0,x1,y1=63 
  LOCAL FLOAT tn 
  LOCAL Integer Sz 
   
  DO 
     
    ' demo fast line draw 
    TFT.SetRot(TFT_NORMAL) 
    TFT.Cls 
    FOR i=0 TO 45 STEP 5 
      tn=TAN(RAD(i)) 
      x1=TFT_w1*tn 
      TFT.DLine(x0,y0,x1,y1) 
    NEXT i 
     
    x1=127 
    FOR i=0 TO 40 STEP 5 
      tn=TAN(RAD(i)) 
      y1=TFT_ht*tn 
      TFT.DLine(x0,y0,x1,y1) 
    NEXT i 
    TFT.Refresh 
    PAUSE 2000 
    TFT.Cls 
     
    'demo fast text write 
    FOR i=0 TO 56 STEP 8 
      TFT.PString(0,i,"Hello world:Bye world",1,TFT_NORMAL) 
    NEXT i 
    TFT.Refresh 
    PAUSE 2000 
    TFT.Cls 
     
    FOR i=63 TO 15 STEP -16 
      TFT.PString(127,i,"Micromite2",2,TFT_INVERSE) 
    NEXT i 
    TFT.Refresh 
    PAUSE 2000 
    TFT.Cls 
     
    FOR i=16 TO 128 STEP 16 
      TFT.PString(i,0,"RIGHT",2,TFT_RT_RIGHT) 
    NEXT i 
    TFT.Refresh 
    PAUSE 2000 
    TFT.Cls 
     
    FOR i=104 TO 0 STEP -24 
      TFT.PString(i,63,"LEFT",3,TFT_RT_LEFT) 
    NEXT i 
    TFT.Refresh 
    PAUSE 2000 
    TFT.Cls 
     
    ' test drawing rectangles 
    FOR i=0 TO 3 
      TFT.SetRot(i) 
      TFT.FRect(5,5,10,15) 
      TFT.DRect(2,2,16,21) 
    NEXT i 
    TFT.Refresh 
    PAUSE 2000 
    TFT.Cls 
     
    ' test drawing rounded rectangles 
    FOR i=0 TO 3 
      TFT.SetRot(i) 
      TFT.FRndrect(5,5,10,15,4) 
      TFT.DRndrect(2,2,16,21,6) 
    NEXT i 
    TFT.Refresh 
    PAUSE 2000 
    TFT.Cls 
     
    ' test drawing circles 
    FOR i=0 TO 3 
      TFT.SetRot(i) 
      TFT.FCirc(10,10,7) 
      TFT.DCirc(10,10,9) 
    NEXT i 
    TFT.Refresh 
    PAUSE 2000 
    TFT.Cls 
     
    ' test drawing triangles and line drawing 
    FOR i=0 TO 3 
      TFT.SetRot(i) 
      TFT.FTri(4,4,20,6,12,14) 
      TFT.DTri(1,2,24,4,12,17) 
    NEXT i 
    TFT.Refresh 
    PAUSE 2000 
     
    ' test character output and string output at all orientations 
    FOR sz=1 TO 3 
      TFT.Cls 
      TFT.SetRot(TFT_NORMAL) 
      xfs=0 
      yfs=0 
      TFT.PString(xfs,yfs,"nr",sz,TFT_NORMAL) 
      TFT.PString(xfs,yfs,"g",sz,TFT_NORMAL) 
      TFT.PString(TFT_rot_wi-1,TFT_rot_ht-1,"Iv",sz,TFT_INVERSE) 
      TFT.PString(TFT_rot_wi-1,0,"Rr",sz,TFT_RT_RIGHT) 
      TFT.PString(0,TFT_rot_ht-1,"Rl",sz,TFT_RT_LEFT) 
      TFT.Refresh 
      PAUSE 1000 
      TFT.Cls 
      TFT.SetRot(TFT_INVERSE) 
      xfs=0 
      yfs=0 
      TFT.PString(xfs,yfs,"nr",sz,TFT_NORMAL) 
      TFT.PString(xfs,yfs,"g",sz,TFT_NORMAL) 
      TFT.PString(TFT_rot_wi-1,TFT_rot_ht-1,"Iv",sz,TFT_INVERSE) 
      TFT.PString(TFT_rot_wi-1,0,"Rr",sz,TFT_RT_RIGHT) 
      TFT.PString(0,TFT_rot_ht-1,"Rl",sz,TFT_RT_LEFT) 
      TFT.Refresh 
      PAUSE 1000 
      TFT.Cls 
      TFT.SetRot(TFT_RT_RIGHT) 
      xfs=0 
      yfs=0 
      TFT.PString(xfs,yfs,"nr",sz,TFT_NORMAL) 
      TFT.PString(xfs,yfs,"g",sz,TFT_NORMAL) 
      TFT.PString(TFT_rot_wi-1,TFT_rot_ht-1,"Iv",sz,TFT_INVERSE) 
      TFT.PString(TFT_rot_wi-1,0,"Rr",sz,TFT_RT_RIGHT) 
      TFT.PString(0,TFT_rot_ht-1,"Rl",sz,TFT_RT_LEFT) 
      TFT.Refresh 
      PAUSE 1000 
      TFT.Cls 
      TFT.SetRot(TFT_RT_LEFT) 
      xfs=0 
      yfs=0 
      TFT.PString(xfs,yfs,"nr",sz,TFT_NORMAL) 
      TFT.PString(xfs,yfs,"g",sz,TFT_NORMAL) 
      TFT.PString(TFT_rot_wi-1,TFT_rot_ht-1,"Iv",sz,TFT_INVERSE) 
      TFT.PString(TFT_rot_wi-1,0,"Rr",sz,TFT_RT_RIGHT) 
      TFT.PString(0,TFT_rot_ht-1,"Rl",sz,TFT_RT_LEFT) 
      TFT.Refresh 
      PAUSE 1000 
    NEXT sz 
  LOOP 
   
END SUB
